# Teaching English in Bangkok

## Overview

Teaching English is one of the most accessible ways to work legally in Thailand. Bangkok has thousands of schools, language centers, and private tutoring opportunities.

## Salary Expectations

### School Types & Salary

| Type | Monthly Salary | Hours | Requirements |
|------|----------------|-------|--------------|
| **Government schools** | ฿30,000-40,000 | 40-50 | Degree, sometimes TEFL |
| **Private Thai schools** | ฿35,000-50,000 | 30-40 | Degree, TEFL preferred |
| **International schools** | ฿80,000-150,000+ | 30-40 | Teaching license, experience |
| **Language centers** | ฿35,000-60,000 | 20-30 | Degree, TEFL |
| **University** | ฿40,000-70,000 | 15-20 | Master's preferred |
| **Private tutoring** | ฿500-1,500/hour | Flexible | Varies |

### Reality Check
- Entry-level: ฿35,000-45,000 typical
- Comfortable living but not saving much
- International schools pay well but competitive
- Private tutoring supplements income significantly

---

## Requirements

### Minimum Requirements

**Legal Requirements**:
- Bachelor's degree (any field)
- Non-B visa + work permit
- Clean background check

**Typical Requirements**:
- Native English speaker (or near-native)
- TEFL/TESOL certificate (120+ hours)
- Passport from English-speaking country (preferred, not required)
- No criminal record

### TEFL Certification

**Why Get One**:
- Many jobs require it
- Better salary negotiation
- Actually helps you teach
- Quick to obtain

**Options**:

**In Thailand**:
- SEE TEFL Bangkok: ฿40,000-50,000, 4 weeks
- International TEFL Academy
- i-to-i TEFL

**Online**:
- ฿3,000-15,000
- 120+ hours for credibility
- Self-paced

**Recommendation**: At minimum, 120-hour online TEFL before arriving.

---

## Work Permit Process

### Overview

1. **Get hired** by school
2. School applies for your **Non-B visa** invitation
3. You apply for **Non-B visa** at Thai embassy (home country or nearby)
4. **Enter Thailand** on Non-B visa
5. School processes your **work permit** (takes 2-4 weeks)
6. Work permit + Non-B visa = legally employed

### Documents Needed
- Passport
- Degree (apostilled/legalized from home country)
- TEFL certificate
- Photos (2x2 inch, formal)
- Medical certificate (from Thailand)
- Background check (FBI/police clearance from home)

### Timeline
- Get documents ready: 2-4 weeks before leaving home
- Visa application: 1-2 weeks
- Work permit: 2-4 weeks after arriving

**Important**: Don't work before work permit is issued.

---

## Finding Jobs

### Job Boards

**ajarn.com** — The main site for Thailand teaching jobs
**teachaway.com** — International teaching jobs
**eslcafe.com** — Dave's ESL Cafe forums
**Facebook groups** — "Teaching Jobs in Thailand"

### Timing

**Peak Hiring**:
- **March-April**: For May semester start
- **September-October**: For November semester start

**Year-Round**: Language centers, international schools

### Application Tips
- Apply 2-3 months before desired start
- Have documents ready
- Professional photo and CV
- Be flexible on location initially

---

## School Types

### Government Schools
**Pros**: Job security, vacation time, authentic Thailand experience
**Cons**: Low salary, large classes (40+ students), bureaucracy, limited resources

### Private Thai Schools
**Pros**: Better pay, smaller classes, more resources
**Cons**: Higher expectations, longer hours possible

### International Schools
**Pros**: Best salary, professional environment, Western standards
**Cons**: Need teaching license and experience, competitive

**Types**:
- British curriculum (IGCSE/A-Levels)
- American curriculum
- IB (International Baccalaureate)

### Language Centers

**Major Centers**:
- Wall Street English
- ECC
- AUA
- British Council

**Pros**: Flexible hours, adult students, professional setting
**Cons**: Evening/weekend work, less stable than schools

### Universities
**Pros**: Educated students, light teaching load, academic environment
**Cons**: Lower pay, limited openings, may need Master's

---

## Cost of Living as a Teacher

### On ฿35,000-40,000/month (Entry Level)

| Category | Budget |
|----------|--------|
| Rent | ฿10,000-15,000 |
| Utilities | ฿2,000 |
| Food | ฿6,000-8,000 |
| Transport | ฿2,000 |
| Phone/internet | ฿1,000 |
| Entertainment | ฿3,000 |
| **Total** | **฿24,000-31,000** |
| **Savings** | ฿4,000-11,000 |

You can live on a teacher's salary but saving is limited.

### Supplementing Income

**Private Tutoring**:
- ฿500-1,000/hour typical
- 10 hours/week = ฿20,000-40,000 extra
- Technically needs work permit amendment

**Online Teaching**:
- VIPKid, iTalki, Cambly
- Gray area visa-wise
- ฿300-800/hour

---

## Day in the Life

### School Teacher

**7:00 AM**: Arrive at school
**7:30 AM**: Morning assembly (students sing anthem)
**8:00 AM - 12:00 PM**: Classes (4-5 periods)
**12:00 PM**: Lunch with students or alone
**1:00 PM - 3:30 PM**: Afternoon classes
**3:30 PM**: End of classes
**4:00 PM**: Lesson planning, meetings
**5:00 PM**: Leave (hopefully)

**Extras**: Sports days, English camps, special events, parent meetings

### Language Center Teacher

**2:00 PM**: Arrive, prep
**3:00 PM - 6:00 PM**: After-school classes (kids)
**6:00 PM**: Dinner break
**7:00 PM - 9:00 PM**: Adult classes
**9:30 PM**: Head home

More evening/weekend work but less morning commitment.

---

## Culture & Classroom

### Thai Students
- Generally respectful, shy
- Won't challenge teacher publicly
- Group-oriented
- May struggle with critical thinking exercises
- Respond well to games, activities

### Classroom Management
- Be patient
- Don't embarrass students publicly
- Use positive reinforcement
- Games and activities work
- Keep energy high (they get sleepy!)

### Thai School Culture
- **Wai** (greeting) expected
- Call students by nicknames
- Respect hierarchy
- Dress code: Professional (often formal)
- Don't touch students' heads

---

## Career Progression

### Path 1: Stay in Teaching
- Move to better schools
- Get teaching license (from home country)
- Aim for international schools (฿80,000-150,000+)
- Leadership roles (department head, curriculum coordinator)

### Path 2: Teacher Training
- TEFL trainer
- Teacher training center
- Textbook development

### Path 3: Exit Teaching
- Transition to corporate training
- EdTech
- Other industries (use Thailand as springboard)

---

## Warnings

### Red Flags in Schools
- No work permit offered
- "Start tomorrow" pressure
- Unclear contract terms
- Salary significantly below market
- Poor reviews on ajarn.com

### Legal Issues
- **Don't work without work permit** — Deportation risk
- **Tax**: You'll pay Thai income tax (~5-10% at teacher salary)
- **90-day reporting**: Required, don't forget

### Quality of Life
- Teaching can be rewarding but exhausting
- Thai summers (March-May) are brutally hot
- Air quality issues Nov-Feb
- Isolation possible if school is far from expat areas
