# Bangkok Safety Guide

## Overall Safety

Bangkok is one of the safest major cities in Southeast Asia for tourists and expats. Violent crime against foreigners is rare. Main concerns are scams, traffic, and petty theft.

### Crime Reality
- **Violent crime**: Very rare against tourists
- **Petty theft**: Occasional pickpocketing on crowded BTS
- **Bag snatching**: Rare but possible on quiet streets (motorbike grab-and-go)
- **Scams**: Most common issue by far

---

## Common Scams

### Gem Scam (Most Famous)
**How it works**: Stranger approaches, says palace/temple is closed today, offers to take you to "special government gem sale" that's ending today. You buy worthless gems at 10x markup.

**Signs**: 
- "Temple closed today"
- "Special sale"
- "Government export promotion"
- Well-dressed stranger being unusually helpful

**Defense**: If anyone approaches you with unsolicited help near tourist areas, politely decline. Temples don't close randomly.

### Tuk-Tuk Tour Scam
**How it works**: Tuk-tuk offers very cheap or free tour. Takes you to commission shops (tailors, jewelers) where driver gets kickback. You waste hours and may be pressured to buy.

**Defense**: Never accept "free" or suspiciously cheap tours. Use Grab for transport.

### Taxi Meter Refusal
**How it works**: Driver refuses meter, quotes inflated fixed price.

**Defense**: Walk away. Insist on meter ("meter, meter"). Use Grab.

### Jet Ski Damage Scam
**How it works**: Rent jet ski (usually Pattaya/islands). Return it. Owner claims you damaged it, demands thousands of baht. Sometimes threatening.

**Defense**: Don't rent jet skis in Thailand. Period. The scam is well-organized.

### Ping Pong Show Bills
**How it works**: Lured into bar with promises of free entry. Massive bill at end for "mandatory drinks" — sometimes ฿5,000-20,000 with threatening bouncers.

**Defense**: Avoid these entirely. If you must, agree on all costs upfront in writing.

### Bar Girl Scams
**How it works**: Girl befriends you, orders expensive drinks on your tab, runs up enormous bill. Or: "sick buffalo" sob story asking for money.

**Defense**: Understand the bar fine system, set expectations, don't get emotionally manipulated.

### Fake Monks
**How it works**: "Monk" gives you amulet or blessing, then demands donation. Real monks don't solicit money directly.

**Defense**: Don't accept items from unsolicited "monks" on the street.

---

## Laws You Must Know

### Lèse-Majesté (Royal Defamation)

**The most important law for foreigners to understand.**

- **Offense**: Any criticism, insult, or defamation of the King, Queen, Regent, or Heir
- **Penalty**: 3-15 years prison PER OFFENSE
- **Enforcement**: Active. People have been prosecuted for Facebook posts.

**What This Means**:
- Never criticize the royal family
- Don't share memes about the monarchy
- Stand for royal anthem before movies (everyone does)
- Respect images of the King (on money, photos everywhere)
- This applies even in private conversations

### Drugs

**Zero tolerance.**

- **Possession**: Up to 10 years for marijuana (though enforcement relaxed since 2022 legalization)
- **Trafficking**: Death penalty for hard drugs (heroin, meth, cocaine)
- **Trace amounts**: Can result in arrest

**2022 Cannabis Changes**:
- Decriminalized for medical/wellness
- Many cannabis shops opened
- **Still technically regulated** — extracts over 0.2% THC are controlled
- Don't assume it's fully legal like Amsterdam
- Don't smoke in public

### Vaping

**E-cigarettes are illegal in Thailand.**

- Possession: Up to 10 years imprisonment or ฿500,000 fine
- Import: Same penalties
- Enforcement: Sporadic but real — tourists have been arrested
- Vape shops exist (gray market) but that doesn't make it legal

### Gambling

**Illegal** except government lottery.

- Private poker games: Raided periodically
- Underground casinos: Exist but risky
- Online gambling: Technically illegal

### Alcohol

- Legal age: 20 (often stated as 21)
- **No public drinking** outside licensed venues
- DUI: Strict — jail time possible, high fines
- Sales hours: Officially 11 AM-2 PM, 5 PM-midnight (often ignored)

### Public Behavior

- **Public affection**: Minimal. Kissing can technically be prosecuted.
- **Nudity**: Illegal in public (even beaches)
- **Obscene gestures**: Can result in arrest
- **Defamation**: Taken seriously — harsh words can be criminal

---

## LGBTQ+ Safety

### The Reality
Thailand is **relatively** accepting but has important nuances.

**Positive**:
- Large visible LGBT community
- Trans women (kathoey) have cultural acceptance
- Bangkok has thriving gay scene (Silom Soi 2/4)
- Same-sex couples generally not harassed

**Legal Status**:
- Same-sex relationships: **Legal**
- Same-sex marriage: **Not recognized** (but civil partnership law progressing)
- Anti-discrimination: Limited protections

**Advice**:
- Public affection: Keep minimal (same as straight couples)
- Outside Bangkok: More conservative
- Use common sense as you would anywhere

---

## Emergency Contacts

| Service | Number |
|---------|--------|
| **Tourist Police** | 1155 (English speaking) |
| **Police** | 191 |
| **Ambulance** | 1669 |
| **Fire** | 199 |
| **Your Embassy** | Save before traveling |

**Tourist Police**: Best option for foreigners. They speak English and handle tourist issues.

---

## Traffic Safety

### Reality Check
- Bangkok traffic kills more foreigners than violent crime
- Motorbike accidents are common
- Pedestrians have NO right of way

### Pedestrian Safety
- **Look multiple times** before crossing
- Use pedestrian bridges when available
- Traffic may come from unexpected directions
- Just because traffic stopped doesn't mean it's safe (motorbikes weave through)

### Motorbike Safety
- Wear helmet (even as passenger)
- Don't drink and ride
- Avoid night riding in unfamiliar areas
- Rain makes roads extremely slippery

### If Renting Motorbike
- Get proper insurance
- Have valid license (international + home)
- Check bike thoroughly before accepting
- Take video of existing damage
- Understand you're liable for damage

---

## Health & Environmental

### Heat
- Heatstroke is real
- Hydrate constantly
- Take breaks in A/C
- Don't underestimate 35°C with high humidity

### Air Quality
- **Nov-Feb**: Worst pollution (AQI 100-200+)
- Check AQI app daily during season
- N95 masks help
- Limit outdoor exercise on bad days

### Water
- Don't drink tap water
- Ice is usually safe (commercial)
- Bottled water everywhere

### Food
- Generally safe
- Busy stalls = fresh food
- If in doubt, eat cooked

---

## Neighborhood Safety

| Area | Safety Level | Notes |
|------|--------------|-------|
| Sukhumvit | Very Safe | Tourist/expat area |
| Silom/Sathorn | Very Safe | Business district |
| Siam | Very Safe | Shopping area |
| Thonglor | Very Safe | Upscale area |
| Ari | Very Safe | Residential |
| Chinatown | Safe | Crowded, watch belongings |
| Khao San | Safe | Petty theft possible, drunk tourists |
| Nana | Moderate | Red light area, scams common |
| Patpong | Moderate | Red light, overcharging scams |

---

## Women's Safety

### Generally Safe
Bangkok is safer than many Western cities for women.

### Precautions
- Standard precautions apply (as anywhere)
- Solo female travel is common and normal
- Taxis at night: Use Grab (tracked)
- Avoid walking alone in quiet areas late night
- Drink spiking: Rare but possible — watch your drink

### Harassment
- Less catcalling than Western countries
- Thai men generally don't approach aggressively
- Some Western men can be problematic in tourist areas

---

## General Safety Tips

1. **Keep copies of passport** (photo in phone)
2. **Travel insurance**: Get it. Hospitals want payment upfront.
3. **Don't flash wealth**: Rolex watches attract attention
4. **Use hotel safe**: For passport and extra cash
5. **ATM awareness**: Cover PIN, use bank ATMs
6. **Grab > street taxis**: Trackable, accountable
7. **Trust instincts**: If something feels wrong, leave
8. **Avoid confrontation**: Thai "face" culture means aggressive arguments can escalate
9. **Document rentals**: Video before/after for any rental (motorbike, apartment)
