# Moving to Bangkok

## Pre-Arrival Checklist

### Documents to Prepare
- [ ] Passport (6+ months validity)
- [ ] Visa (if required — check before flying)
- [ ] Passport photos (4x6 cm, white background)
- [ ] University degree (apostilled, for work permit)
- [ ] Driver's license (international + home)
- [ ] Travel insurance
- [ ] Bank statements (for some visas)
- [ ] Vaccination records (optional but useful)

### Before You Leave Home
- [ ] Notify bank of travel
- [ ] Set up international card (Wise, Schwab)
- [ ] Download offline maps
- [ ] Get travel insurance
- [ ] Save digital copies of documents
- [ ] Research visa options

---

## First Week Essentials

### Day 1-2: Immediate Needs
1. **SIM card** at airport (AIS, True, DTAC)
2. **Cash** from ATM (฿5,000-10,000)
3. **Grab app** downloaded
4. **Temporary accommodation** (hotel/Airbnb booked ahead)

### Day 3-7: Getting Settled
1. **Find apartment** — visit 5-10 places
2. **Bank account** — try Bangkok Bank main branch
3. **Explore neighborhoods** — use BTS to compare
4. **Stock essentials** — pharmacy, groceries
5. **Register SIM** — needs passport

---

## Finding an Apartment

### Search Process

**Online First**:
- **Hipflat.co.th**: Best for condos
- **DDProperty.com**: Wide selection  
- **Facebook groups**: Bangkok Expats, Digital Nomads Bangkok
- **Renthub.in.th**: Thai site, cheaper options

**Then Visit**:
- Schedule 5-10 viewings
- Different buildings same area
- Check at different times (noise, traffic)

### What to Look For

**Must-Haves**:
- [ ] BTS/MRT proximity (actual walking time)
- [ ] Working A/C (check all units)
- [ ] Hot water
- [ ] Reasonable electricity rate (฿5-7/unit, not ฿8-10)
- [ ] Security (guards, key cards)
- [ ] Building condition

**Nice-to-Haves**:
- Pool, gym
- Laundry in unit or building
- Convenience store nearby
- Good internet included
- Rooftop access

### Red Flags
- Electricity over ฿8/unit (standard is ฿4, condos charge ฿6-8)
- Water damage or mold
- Thin walls (visit during day AND night)
- Poor building management
- No fire escape
- Sketchy security

### The Lease

**Standard Terms**:
- 6-12 month minimum
- 2 months deposit (refundable)
- 1 month advance rent
- Utilities separate

**Negotiable**:
- Monthly rate (especially 6+ months)
- Move-in date
- Furniture additions
- Breaking lease terms

**Document Everything**:
- Photos of condition at move-in
- Inventory list signed by both
- Meter readings (electricity, water)

---

## Setting Up Utilities

### Already Set Up (Usually)
- Electricity (condo meters)
- Water
- Building internet (sometimes)

### You Arrange
**Internet** (if not included):
- 3BB, True Online, AIS Fibre
- Call or visit shop
- 1-3 days installation
- ฿500-1,000/month

**TV** (optional):
- True Visions (cable)
- Netflix/streaming works fine

---

## Bank Account

### Why You Need One
- Pay rent by transfer
- PromptPay (instant transfer)
- QR code payments everywhere
- Bill payments via app

### Best Banks for Foreigners

**Bangkok Bank** (most recommended):
- Most experience with foreigners
- Main branches easier
- Good English app

**Kasikorn (KBank)**:
- Popular, good app
- Green cards/branches

**SCB (Siam Commercial)**:
- Decent for foreigners
- Purple branding

### What to Bring
- Passport
- Proof of address (lease, utility bill, bank statement)
- Work permit (if you have one)
- Some branches: reference letter from employer

### Tips
- Go to MAIN branches (Silom, Asok, etc.)
- Morning, weekday
- Be patient, persistent
- If refused, try another branch or bank

---

## Health Insurance

### Do You Need It?
**Yes.** Thai hospitals want payment upfront or insurance.

### Options

**Thai Local Policies**:
- ฿10,000-30,000/year
- Covers Thai hospitals
- Lower limits than international
- Good for routine care

**International Policies**:
- $1,000-5,000/year
- Higher coverage limits
- Worldwide coverage options
- Better for emergencies/evacuation

**Popular Providers**:
- **Pacific Cross** (local, expat-focused)
- **Cigna Thailand**
- **Bupa Thailand**
- **SafetyWing** (nomad-focused)
- **World Nomads** (travel insurance)

### Minimum Recommended
- $100,000+ hospitalization coverage
- Evacuation coverage
- Outpatient included

---

## Work Permit & Visas

See `visas.md` for full details.

### Quick Summary

**For Employment**:
- Need employer to sponsor work permit
- Process: Non-B visa → Work permit
- Takes 1-2 months

**For Digital Nomads**:
- Legal gray area (technically need work permit)
- Most use tourist visa + extensions
- New LTR visa option for high earners
- Thailand Elite for long-term

---

## Cost of Living Reality Check

### Monthly Budget (Single Person, Comfortable)

| Category | Budget | Comfortable | Upscale |
|----------|--------|-------------|---------|
| Rent | ฿15,000 | ฿25,000 | ฿45,000 |
| Utilities | ฿2,000 | ฿3,000 | ฿5,000 |
| Food | ฿8,000 | ฿12,000 | ฿20,000 |
| Transport | ฿2,000 | ฿4,000 | ฿8,000 |
| Phone/Net | ฿1,000 | ฿1,500 | ฿2,000 |
| Health | ฿1,000 | ฿2,000 | ฿3,000 |
| Entertainment | ฿3,000 | ฿7,000 | ฿15,000 |
| **Total** | **฿32,000** | **฿54,500** | **฿98,000** |
| **USD** | ~$915 | ~$1,560 | ~$2,800 |

---

## Culture Shock Adjustments

### Expect These
- **Heat**: It's relentless. Accept A/C lifestyle.
- **Traffic**: Don't fight it. Plan around it.
- **Pace**: Things move slower. Mai pen rai.
- **Language barrier**: Learn basics, use apps.
- **Bureaucracy**: Patience required for visas, banks.
- **Noise**: Bangkok is loud. Earplugs help.

### What Helps
- Join expat groups (but don't ONLY hang with expats)
- Learn Thai basics
- Embrace local food
- Find your neighborhood routine
- Exercise/maintain health routines
- Explore beyond tourist areas

---

## Expat Communities

### Facebook Groups
- **Bangkok Expats**: General help
- **Digital Nomads Bangkok**: Remote workers
- **Bangkok Foodies**: Restaurant recs
- **Bangkok Buy and Sell**: Second-hand items

### Meetups
- Meetup.com Bangkok
- InterNations
- Couchsurfing events
- Sports clubs (running, cycling)
- Language exchange

### Co-working Communities
- Hubba
- The Hive
- Glowfish
- WeWork

---

## Long-term Considerations

### After 3-6 Months
- [ ] Thai driver's license (useful ID)
- [ ] Health checkup at Thai hospital
- [ ] Build local friendships
- [ ] Explore outside Bangkok
- [ ] Learn more Thai

### Annual
- [ ] Visa renewal/90-day reports
- [ ] Insurance renewal
- [ ] Tax considerations (home country)
- [ ] Re-entry permit if traveling
