# Bangkok Digital Nomad Guide

## Why Bangkok

### Pros
- **Cost**: $1,000-2,000/month comfortable
- **Internet**: Fast, reliable fiber and 4G/5G
- **Infrastructure**: Malls, cafés, coworking everywhere
- **Food**: Best in the world, incredibly cheap
- **Community**: Large established nomad scene
- **Travel hub**: Cheap flights around Asia

### Cons
- **Visa complexity**: No straightforward nomad visa (until LTR)
- **Legal gray area**: Technically can't work on tourist visa
- **Heat**: Brutal, plan around A/C
- **Traffic**: Horrific, affects quality of life
- **Air quality**: Nov-Feb pollution can be bad

---

## Visa Strategy for Nomads

### Short-Term (1-3 Months)
**Visa exemption + extension**
- 30 days on arrival
- Extend 30 days at immigration (฿1,900)
- Total: 60 days

### Medium-Term (3-12 Months)
**Options ranked by legality**:

1. **LTR Visa** (if $80K+ income)
   - 10-year visa
   - Explicitly allows remote work
   - Best option if you qualify

2. **Thailand Elite** (฿600,000 for 5 years)
   - Legal stay, no work permit
   - Good for committed nomads
   - ~฿10,000/month amortized

3. **ED Visa** (Language school)
   - ฿30,000-50,000/year
   - Requires attending classes
   - 90-day renewals

4. **Multiple Tourist Visas** (visa runs)
   - Getting harder
   - Immigration watching patterns
   - Not sustainable long-term

### Long-Term (1+ Years)
- Thailand Elite or LTR visa
- Or find formal employment

---

## Coworking Spaces

### Best for Nomads

| Space | Locations | Day | Monthly | Vibe |
|-------|-----------|-----|---------|------|
| **Hubba** | Ekkamai, Silom | ฿350 | ฿4,500 | Startup energy |
| **The Hive** | Thonglor, Prakanong | ฿450 | ฿6,000 | Professional |
| **Glowfish** | Sathorn, Ploenchit | ฿400 | ฿5,000 | Corporate-ish |
| **TCDC** | Charoenkrung | ฿100 | ฿1,200 | Design focused |
| **KX** | Sukhumvit | ฿200 | ฿3,500 | Budget friendly |
| **AIS DC** | Siam | ฿150 | ฿2,000 | Tech events |

### Amenities Comparison
- **Hubba**: Events, community, startup vibe
- **The Hive**: Quiet zones, meeting rooms
- **TCDC**: Library, design resources
- **Glowfish**: Corporate feel, networking

---

## Café Working

Bangkok is extremely café-friendly for remote work.

### Best Areas for Café Hopping
1. **Thonglor**: Hipster cafés everywhere
2. **Ari**: Local trendy, great options
3. **Ekkamai**: Similar to Thonglor, less crowded
4. **Sathorn/Silom**: Coffee shops near offices

### Top Work-Friendly Cafés

**Thonglor Area**:
- **Roast Coffee** — Large, good WiFi, popular
- **Rocket Coffeebar** — Work-friendly, brunch
- **Too Fast to Sleep** — 24/7, literally designed for working

**Ari Area**:
- **Casa Lapin** — Multi-story, institution
- **Ceresia** — Excellent coffee, work friendly
- **Factory Coffee** — Industrial space

**Sukhumvit**:
- **Ink & Lion** — Multiple locations
- **Pacamara** — Chain, consistent
- **Blue Dye** — Large space

### Café Tips
- No time limits (usually)
- Order every 2-3 hours to be polite
- WiFi is standard and usually good
- Power outlets: look before sitting
- A/C: dress in layers

---

## Internet & Tech

### Fiber Internet
Most condos have fiber available:
- **100 Mbps**: ฿400-600/month
- **300 Mbps**: ฿600-800/month
- **1 Gbps**: ฿1,000-1,500/month

Providers: 3BB, True Online, AIS Fibre

### Mobile Data
4G/5G excellent in Bangkok:
- **Unlimited plans**: ฿700-1,000/month
- **Tourist SIM**: 30GB for ฿500/month

### Backup Options
- Café WiFi as backup
- Coworking space
- Mobile hotspot

### Video Call Quality
Generally excellent. Bangkok has better internet than many Western cities.

---

## Sample Nomad Budgets

### Budget Nomad (฿35,000-45,000 / $1,000-1,285)

| Category | Monthly |
|----------|---------|
| Rent (1BR On Nut) | ฿15,000 |
| Utilities | ฿2,000 |
| Food (mostly local) | ฿8,000 |
| Transport | ฿2,000 |
| Coworking/café | ฿2,000 |
| Phone/internet | ฿1,000 |
| Entertainment | ฿3,000 |
| Misc | ฿2,000 |
| **Total** | **฿35,000** |

### Comfortable Nomad (฿55,000-70,000 / $1,570-2,000)

| Category | Monthly |
|----------|---------|
| Rent (1BR Thonglor) | ฿28,000 |
| Utilities | ฿3,000 |
| Food (mix local/Western) | ฿12,000 |
| Transport | ฿3,000 |
| Coworking | ฿5,000 |
| Phone/internet | ฿1,500 |
| Entertainment | ฿8,000 |
| Health/gym | ฿3,000 |
| Misc | ฿3,000 |
| **Total** | **฿66,500** |

---

## Nomad Community

### Events & Meetups
- **Meetup.com**: Digital Nomads Bangkok
- **Facebook groups**: Active community
- **Coworking events**: Hubba, The Hive host regularly
- **Nomad coffee meetups**: Organic, check groups

### Facebook Groups
- Digital Nomads Bangkok
- Bangkok Expats
- Thailand Remote Workers
- Bangkok Startups

### Online
- **Nomad List**: City info, chat
- **r/digitalnomad**: Subreddit
- **Remote OK**: Job board

---

## Best Neighborhoods for Nomads

### Thonglor / Ekkamai
**Pros**: Cafés, restaurants, nightlife, coworking
**Cons**: Expensive, traffic
**Budget**: ฿25,000-40,000 rent

### Ari
**Pros**: Local vibe, great cafés, cheaper
**Cons**: Less international
**Budget**: ฿15,000-30,000 rent

### On Nut
**Pros**: Budget-friendly, BTS access, real neighborhood
**Cons**: Less trendy, fewer cafés
**Budget**: ฿12,000-22,000 rent

### Asok
**Pros**: Central, transit hub, everything accessible
**Cons**: Busy, touristy nearby (Nana)
**Budget**: ฿18,000-35,000 rent

---

## Daily Routine (Example)

**7:00 AM**: Wake, cold shower (Thai style)
**7:30 AM**: Breakfast at local market or café
**8:00 AM**: Deep work session (condo or coworking)
**12:00 PM**: Lunch (street food or food court)
**12:30 PM**: Light work or break (heat peak)
**3:00 PM**: Afternoon work session
**6:00 PM**: Gym or walk
**7:00 PM**: Dinner
**8:00 PM**: Social, explore, or light work
**11:00 PM**: Wind down

### Productivity Tips
- Work early before heat
- Long break during hottest hours (12-3 PM)
- Evening sessions in A/C
- Use pomodoro for focus
- Change locations for variety

---

## Health & Wellness

### Staying Healthy
- **Hydrate constantly**: Carry water
- **A/C dependency**: Accept it
- **Exercise**: Gym or early morning
- **Air quality**: Check AQI Nov-Feb, mask if needed

### Fitness Options
- Condo gyms: Usually basic but free
- Commercial gyms: ฿1,500-3,500/month
- Muay Thai: ฿3,000-5,000/month
- Yoga: ฿3,000-6,000/month

### Mental Health
- Maintain routine
- Build social connections
- Take breaks from screens
- Get outside (early morning)
- Travel on weekends

---

## Exit Planning

### When to Leave
- Visa expires
- Hot season too much (April-May)
- Pollution season (Jan-Feb)
- Need change of scene

### Nearby Nomad Hubs
- **Chiang Mai**: Cheaper, mountains, cooler
- **Koh Lanta/Phangan**: Beach vibes
- **Bali**: Different scene
- **Da Nang/Hoi An**: Vietnam options
- **Kuala Lumpur**: Easy visa, modern city
