# Bangkok Neighborhoods — Quick Comparison

## Overview Map

Bangkok's main districts along two axes:
- **East-West**: BTS Sukhumvit line (Sukhumvit Road corridor)
- **North-South**: BTS Silom line + MRT

```
North
  ↑
  Chatuchak (Mo Chit)
  │
  Ari ← Trendy local area
  │
  Victory Monument
  │
  Phaya Thai ← ARL connection
  │
  Ratchathewi
  │
CENTER: Siam (BTS hub)
  │
  ├─→ East: Sukhumvit line
  │   Phloen Chit → Nana → Asok → Phrom Phong → Thonglor → Ekkamai → On Nut
  │
  └─→ South: Silom line
      Sala Daeng/Silom → Chong Nonsi → Sathorn → Saphan Taksin (river)

West: Old Town (Rattanakosin)
  Grand Palace, Khao San, Chinatown
  No rail — boats and taxis
```

## Quick Decision Table

| I want... | Go to... | Why |
|-----------|----------|-----|
| Best transit + variety | **Asok/Sukhumvit** | BTS+MRT hub, everything walkable |
| Trendy cafés + nightlife | **Thonglor** | Expat cool kids, Soi 38 food |
| Budget living near BTS | **On Nut** | Half the rent, still on the line |
| Local Thai vibe | **Ari** | Cafés, vintage, residential |
| Business district | **Silom/Sathorn** | Office towers, Lumphini Park |
| Backpacker scene | **Khao San** | Hostels, chaos, no rail |
| Temples + culture | **Rattanakosin** | Grand Palace, Wat Pho area |
| Riverside luxury | **Riverside** | 5-star hotels, Asiatique |
| Street food heaven | **Chinatown** | Yaowarat Road, evening magic |

## Neighborhood Profiles

### Sukhumvit Corridor (BTS Sukhumvit Line)

| Station | Character | Rent (1BR) | Best For |
|---------|-----------|------------|----------|
| **Phloen Chit** | Embassy Row, upscale | ฿30,000-60,000 | Executives |
| **Nana** | Red light + Arab quarter | ฿18,000-35,000 | Budget central |
| **Asok** | Transit hub, mixed | ฿20,000-45,000 | First-timers, business |
| **Phrom Phong** | EmQuartier, Japanese expats | ฿25,000-50,000 | Families, shopping |
| **Thonglor** | Hip, cafés, nightlife | ฿25,000-55,000 | Young expats, creatives |
| **Ekkamai** | Thonglor-lite, residential | ฿20,000-40,000 | Quieter trendy |
| **Phra Khanong** | Up-and-coming | ฿15,000-30,000 | Budget nomads |
| **On Nut** | Value + BTS access | ฿12,000-25,000 | Budget long-term |
| **Bang Na** | Far but cheap | ฿10,000-20,000 | Very budget |

### Silom/Sathorn Corridor (BTS Silom Line)

| Station | Character | Rent (1BR) | Best For |
|---------|-----------|------------|----------|
| **Sala Daeng** | CBD center, Patpong | ฿25,000-50,000 | Business, LGBT |
| **Chong Nonsi** | Offices, high-rises | ฿22,000-45,000 | Corporate |
| **Sathorn** | Embassies, luxury condos | ฿28,000-60,000 | Upscale expats |
| **Saphan Taksin** | River access | ฿20,000-40,000 | Riverside life |

### Beyond BTS

| Area | Character | Rent (1BR) | Transit |
|------|-----------|------------|---------|
| **Ari** | Hipster local, cafés | ฿18,000-35,000 | BTS Ari |
| **Chatuchak** | Weekend market, residential | ฿15,000-28,000 | BTS Mo Chit, MRT |
| **Khao San/Old Town** | Backpacker, temples | ฿8,000-18,000 | None, boats/taxi |
| **Chinatown** | Street food, old Bangkok | ฿10,000-22,000 | MRT Wat Mangkon |
| **Riverside** | Luxury hotels | ฿30,000-100,000+ | Boats, BTS far |

## Lifestyle Match

### Digital Nomads
1. **Thonglor** — Cafés, coworking, social scene
2. **Ari** — Cheaper, equally trendy, local vibe
3. **On Nut** — Budget base, still connected

### Families
1. **Phrom Phong** — Japanese schools, Emporium, parks
2. **Sukhumvit 31-39** — International schools, quieter
3. **Ari** — Local feel, good schools

### Young Professionals
1. **Asok** — Central, transit hub
2. **Thonglor** — Night life, dating scene
3. **Silom** — Corporate access, LGBT-friendly

### Budget Travelers
1. **On Nut** — Modern BTS area, half the rent
2. **Khao San** — If you want the backpacker scene
3. **Ari** — Local prices, good vibes

### Business Travelers
1. **Silom/Sathorn** — CBD, walking to offices
2. **Asok** — Terminal 21, two rail lines
3. **Phloen Chit** — Embassy Row, upscale

## Red Flags by Area

| Area | What to Know |
|------|--------------|
| **Nana** | Red light district — sleaze factor |
| **Khao San** | No rail, party noise 24/7 |
| **Patpong** | Night market + go-go bars |
| **Lower Sukhumvit (Soi 1-11)** | Touristy, foreign-facing |
| **Thonglor upper sois** | Can be far from BTS |

## Commute Times (Rush Hour)

| From → To | BTS | Grab |
|-----------|-----|------|
| On Nut → Siam | 20 min | 45-90 min |
| Thonglor → Silom | 25 min | 60-120 min |
| Asok → Chatuchak | 20 min | 45-90 min |
| Khao San → Siam | N/A | 30-60 min |

**Rule**: If you can BTS it, BTS it. Traffic is brutal.
