# Thai Language Basics

## Overview

Thai is a tonal language with its own script. It's challenging but rewarding to learn. You can live in Bangkok without Thai, but basics dramatically improve daily life.

## Do You Need Thai?

### You Can Get By Without It In:
- Tourist areas
- International restaurants
- Malls and chains
- Expat neighborhoods
- International workplaces

### Thai Helps Enormously For:
- Street food ordering
- Taxi negotiations (less needed with Grab)
- Local markets
- Making Thai friends
- Getting better prices
- Understanding culture
- Earning respect

---

## The Basics

### Tones

Thai has 5 tones. Same syllable, different tone = different meaning.

| Tone | Symbol | Description | Example |
|------|--------|-------------|---------|
| Mid | (none) | Normal voice | กา (kaa) - crow |
| Low | à | Voice drops | ข่า (khàa) - galangal |
| Falling | â | High to low | ข้า (khâa) - slave |
| High | á | Higher pitch | ค้า (kháa) - trade |
| Rising | ǎ | Low to high | ขา (khǎa) - leg |

**The famous example**: "mai" with different tones means: new, silk, burn, no/not, question marker.

### Polite Particles

Every sentence ends with a polite particle:
- **ครับ (khrap)**: Male speaker
- **ค่ะ/คะ (kha/ka)**: Female speaker

Use these constantly. They make everything more polite.

---

## Essential Phrases

### Greetings

| English | Thai | Pronunciation |
|---------|------|---------------|
| Hello | สวัสดี | Sawatdee (+ khrap/ka) |
| How are you? | สบายดีไหม | Sabai dee mai? |
| I'm fine | สบายดี | Sabai dee |
| Thank you | ขอบคุณ | Khop khun (+ khrap/ka) |
| You're welcome | ไม่เป็นไร | Mai pen rai |
| Sorry/Excuse me | ขอโทษ | Khor thot |
| Goodbye | ลาก่อน | Laa gon (+ khrap/ka) |

### Basic Communication

| English | Thai | Pronunciation |
|---------|------|---------------|
| Yes | ใช่ | Chai |
| No | ไม่ใช่ | Mai chai |
| I don't understand | ไม่เข้าใจ | Mai khao jai |
| Do you speak English? | พูดภาษาอังกฤษได้ไหม | Phood pasa angrit dai mai? |
| I don't speak Thai | พูดไทยไม่ได้ | Phood Thai mai dai |
| Please speak slowly | พูดช้าๆ หน่อย | Phood cha cha noi |
| What is this? | นี่คืออะไร | Nee keu arai? |

### Numbers

| Number | Thai | Pronunciation |
|--------|------|---------------|
| 0 | ศูนย์ | Soon |
| 1 | หนึ่ง | Neung |
| 2 | สอง | Song |
| 3 | สาม | Saam |
| 4 | สี่ | See |
| 5 | ห้า | Haa |
| 6 | หก | Hok |
| 7 | เจ็ด | Jet |
| 8 | แปด | Paet |
| 9 | เก้า | Kao |
| 10 | สิบ | Sip |
| 20 | ยี่สิบ | Yee sip |
| 100 | ร้อย | Roi |
| 1,000 | พัน | Phan |

**Pattern**: 25 = yee sip haa, 37 = saam sip jet

### Money

| English | Thai | Pronunciation |
|---------|------|---------------|
| How much? | เท่าไหร่ | Tao rai? |
| Too expensive | แพงไป | Paeng pai |
| Discount? | ลดได้ไหม | Lot dai mai? |
| Baht | บาท | Baht |

### Food Ordering

| English | Thai | Pronunciation |
|---------|------|---------------|
| Delicious | อร่อย | Aroi |
| I want... | เอา... | Ao... |
| Not spicy | ไม่เผ็ด | Mai phet |
| A little spicy | เผ็ดนิดหน่อย | Phet nit noi |
| No sugar | ไม่ใส่น้ำตาล | Mai sai nam taan |
| No MSG | ไม่ใส่ผงชูรส | Mai sai pong choo rot |
| Fried egg | ไข่ดาว | Kai dao |
| Check please | เช็คบิล | Check bin |
| Take away | ใส่ถุง | Sai toong |
| Eat here | ทานที่นี่ | Taan tee nee |

### Getting Around

| English | Thai | Pronunciation |
|---------|------|---------------|
| Go to... | ไป... | Pai... |
| Turn left | เลี้ยวซ้าย | Liao sai |
| Turn right | เลี้ยวขวา | Liao kwaa |
| Go straight | ตรงไป | Trong pai |
| Stop here | จอดที่นี่ | Jot tee nee |
| How far? | ไกลไหม | Glai mai? |
| Near | ใกล้ | Glai (rising tone) |
| Far | ไกล | Glai (mid tone) |

### Emergencies

| English | Thai | Pronunciation |
|---------|------|---------------|
| Help! | ช่วยด้วย | Chuay duay! |
| I'm sick | ไม่สบาย | Mai sabai |
| Hospital | โรงพยาบาล | Rong payaban |
| Police | ตำรวจ | Tamruat |
| I need a doctor | ต้องการหมอ | Tong gaan mor |

---

## Common Situations

### At a Restaurant

```
You: "Ao pad krapao moo sap, kai dao, mai phet khrap/ka"
(I want pad krapao with minced pork, fried egg, not spicy)

Vendor: "Kha/Khrap" (OK)

After eating:
You: "Aroi mak khrap/ka" (Very delicious)
You: "Check bin khrap/ka" (Bill please)
```

### In a Taxi

```
You: "Pai Siam khrap/ka" (Go to Siam)
You: "Jot tee nee khrap/ka" (Stop here)
You: "Tao rai khrap/ka?" (How much?)
```

### Shopping

```
You: "Nee tao rai?" (How much is this?)
Vendor: "Song roi baht" (200 baht)
You: "Paeng pai! Lot dai mai?" (Too expensive! Can you discount?)
```

---

## Learning Thai

### Language Schools

**Popular Options**:
- **Union Language School**: Well-known, ED visa possible
- **AAA Thai Language**: Central locations
- **Pro Language**: Good reputation
- **Duke Language School**: Budget option

**Cost**: ฿10,000-30,000 for 60-100 hours

### Private Tutors

- ฿400-800/hour
- Find through schools or italki
- Customize to your needs
- Faster progress than group

### Apps & Online

**Apps**:
- **Ling**: Good for Thai
- **Pimsleur**: Audio-based
- **Write Me**: Thai script practice
- **Thai2English**: Dictionary

**YouTube**:
- Learn Thai with Mod
- Thai with Grace
- Kruu Wee

### Self-Study Tips

1. **Start with sounds**: Pronunciation matters more than script initially
2. **Learn survival phrases**: Use them daily
3. **Listen actively**: Thai music, TV, podcasts
4. **Practice with vendors**: They appreciate effort
5. **Script later**: Useful but not essential initially

---

## Thai Script

Thai has 44 consonants, 15 vowels, and 4 tone marks. It's complex but learnable.

### Why Learn Script?

**Pros**:
- Read menus, signs
- Use Thai apps/websites
- Deeper understanding
- Impress locals

**Cons**:
- Takes 3-6 months for basics
- Can live without it
- Romanization works for speaking

### Script Basics

Thai is written left to right, no spaces between words.

**Consonant Classes** (affect tone):
- High class
- Middle class
- Low class

**Vowels** can appear before, after, above, or below consonants.

---

## Common Mistakes

### Pronunciation
- **Ignoring tones**: Changes meaning completely
- **R/L confusion**: Thais often swap, but they're different letters
- **Hard consonants**: Final consonants are often unaspirated

### Cultural
- **Not using polite particles**: Sounds abrupt
- **Wrong pronoun**: Thai has many "I" and "you" words
- **Forgetting particles for questions**: Mai? at end

### Learning
- **Starting with script**: Can slow progress
- **Only classroom learning**: Need real practice
- **Giving up on tones**: They matter

---

## Realistic Expectations

### 1 Month
- Basic greetings
- Numbers, prices
- Food ordering basics
- Directions (simple)

### 3 Months (Regular Study)
- Simple conversations
- Taxi, restaurant, shopping confident
- Understanding some responses
- Maybe basic reading

### 1 Year (Dedicated Study)
- Conversational on daily topics
- Read simple text
- Understand Thai spoken to you
- Still struggle with complex/fast speech

### Fluency
- 2-4 years of immersion and study
- Regular practice with Thais
- Reading and writing practice
- Ongoing effort required

---

## Tips for Success

1. **Use what you learn immediately**
2. **Don't be afraid of mistakes**
3. **Thais love when you try**
4. **A little Thai goes a long way**
5. **Focus on practical phrases first**
6. **Learn tones from the beginning**
7. **Practice with different people**
8. **Make Thai friends, not just expat friends**
