# Bangkok Healthcare Guide

## Overview

Bangkok is a global medical tourism hub. Healthcare ranges from world-class private hospitals to basic public clinics. Quality is excellent, and prices are 30-70% lower than Western countries.

## Hospital Tiers

### Tier 1: International Hospitals

**Premium care, international standards, high prices (but still cheaper than West)**

| Hospital | Specialty | Location |
|----------|-----------|----------|
| **Bumrungrad** | Everything, most famous | Sukhumvit |
| **Bangkok Hospital** | Multi-specialty | Multiple |
| **Samitivej** | Family-friendly, expat-focused | Sukhumvit, Thonburi |
| **BNH** | General, obstetrics | Silom |
| **Vejthani** | Multi-specialty, value | Ramkhamhaeng |

**What to Expect**:
- English-speaking staff
- Hotel-like facilities
- Short wait times
- International insurance accepted
- 2-5x more expensive than Thai hospitals

**Cost Example (Without Insurance)**:
- Consultation: ฿1,500-3,000
- ER visit: ฿3,000-10,000
- Minor surgery: ฿50,000-200,000
- Major surgery: ฿200,000-1,000,000+

### Tier 2: Private Thai Hospitals

**Good care, Thai focus, moderate prices**

| Hospital | Notes |
|----------|-------|
| **Phyathai** | Good quality, multiple locations |
| **Paolo** | Decent care, lower cost |
| **Vibharam** | Good value |
| **Mission Hospital** | Older but reliable |

**What to Expect**:
- Some English, mostly Thai
- Good medical care
- Longer waits possible
- 30-50% cheaper than Tier 1

### Tier 3: Public Hospitals

**Cheapest, long waits, Thai language required**

| Hospital | Notes |
|----------|-------|
| **Ramathibodi** | Teaching hospital, excellent doctors |
| **Siriraj** | Largest, historic |
| **Chulalongkorn** | Connected to university |

**What to Expect**:
- Crowded
- Long wait times (hours)
- Little English
- Very cheap
- Emergency care available

---

## Common Medical Needs

### Finding a Doctor

**General Practice**:
- Walk into any hospital's outpatient department
- No appointment needed (but helps)
- Or book online with major hospitals

**Specialists**:
- Get referral or book directly with hospital
- Bumrungrad has every specialty
- Wait times usually <1 week

### Emergency

- **Call 1669** (ambulance)
- **Go directly** to nearest hospital ER
- International hospitals have 24/7 ER
- Payment/insurance sorted after stabilization

### Pharmacy

**How It Works**:
- Pharmacies everywhere (Boots, Watsons, independent)
- Many medications available without prescription
- Pharmacists can advise on minor issues
- Prescription drugs often sold OTC
- Antibiotics: Technically prescription, often sold anyway

**Common Medications**:
- Available and cheaper than Western countries
- Bring prescription for controlled substances
- Some brands different (check active ingredient)

---

## Insurance

### Do You Need It?

**Yes**, if staying long-term. Bangkok hospitals are affordable but major illness/injury can still cost ฿500,000-2,000,000+.

### Options

**Travel Insurance**:
- Short-term coverage
- World Nomads, SafetyWing
- $50-150/month
- Good for emergencies, less for routine

**Thai Local Insurance**:
- Pacific Cross, Thai Paiboon
- ฿15,000-50,000/year
- Covers Thai hospitals
- May exclude pre-existing conditions

**International Insurance**:
- Cigna, Bupa, Aetna
- $1,000-5,000/year
- Higher coverage limits
- Worldwide coverage options

### Recommended Minimum Coverage
- $100,000 hospitalization
- Medical evacuation
- Outpatient included

---

## Medical Tourism

Bangkok is a top destination for:

### Popular Procedures

| Procedure | Bangkok Price | US Price |
|-----------|---------------|----------|
| LASIK | $1,500-3,000 | $4,000-6,000 |
| Dental crown | $300-500 | $1,000-2,000 |
| Heart bypass | $15,000-30,000 | $70,000-150,000 |
| Hip replacement | $12,000-20,000 | $40,000-80,000 |
| Cosmetic surgery | 30-50% of US | - |

### Top Medical Tourism Hospitals
- **Bumrungrad**: Most famous, Arabic speakers, Middle East focus
- **Bangkok Hospital**: Strong across specialties
- **Yanhee**: Cosmetic surgery
- **Dental Hospital Bangkok**: Dental procedures

### What to Know
- Research thoroughly
- Check doctor credentials
- Plan recovery time
- Consider follow-up care at home
- Don't fly too soon after surgery

---

## Dental Care

**Bangkok has excellent, affordable dental care.**

### Dental Facilities

**Premium**:
- Bangkok International Dental Center (BIDC)
- Dental Hospital Bangkok
- Thantakit Dental Center

**Good Value**:
- Hospital dental departments
- Standalone clinics throughout city

### Costs

| Procedure | Price (THB) |
|-----------|-------------|
| Cleaning | ฿800-1,500 |
| Filling | ฿1,000-2,500 |
| Crown (porcelain) | ฿10,000-18,000 |
| Root canal | ฿8,000-15,000 |
| Implant | ฿40,000-80,000 |
| Veneers (each) | ฿8,000-15,000 |

### Tips
- Get quote before procedure
- Check dentist credentials
- Major dental work: Get second opinion
- Allow recovery time before flying

---

## Mental Health

### Finding Help

**Hospitals with Psychology/Psychiatry**:
- Bumrungrad
- Samitivej
- Bangkok Hospital

**Standalone Clinics**:
- MindSpa
- Thanyapura (Phuket but telehealth)

**Online/Telehealth**:
- BetterHelp, Talkspace work in Thailand
- Thai-based online counseling growing

### Costs
- Psychiatrist: ฿2,000-4,000/session
- Psychologist/counselor: ฿1,500-3,500/session
- Some insurance covers mental health

### Language
- English-speaking therapists available
- Mostly in international hospitals
- Ask about language when booking

---

## Pharmacies

### Where to Go

**Chain Pharmacies**:
- Boots (Western-style)
- Watsons
- Pure (health focus)

**Hospital Pharmacies**:
- Attached to hospitals
- Fill prescriptions

**Independent Pharmacies**:
- Every neighborhood
- Often family-run
- May have more flexible dispensing

### What You Can Get

**Without Prescription** (varies by pharmacy):
- Antibiotics (technically rx but often sold)
- Many painkillers
- Allergy medications
- Sleep aids (some)
- Muscle relaxants

**Prescription Required**:
- Strong painkillers (opioids)
- Psychotropic medications
- Some sedatives

### Bringing Medications to Thailand

- Bring copy of prescription
- Keep in original containers
- 30-day supply generally fine
- Controlled substances: Bring documentation

---

## Health Checkups

Many expats get annual checkups — much cheaper than home.

### Package Costs

| Hospital | Basic | Comprehensive |
|----------|-------|---------------|
| Bumrungrad | ฿4,000 | ฿15,000-40,000 |
| Bangkok Hospital | ฿3,500 | ฿12,000-30,000 |
| Phyathai | ฿2,500 | ฿8,000-20,000 |

### What's Included (Comprehensive)
- Blood tests (full panel)
- Chest X-ray
- ECG
- Ultrasound
- Cancer markers (some)
- Specialist consultations

### Tips
- Book in advance
- Usually done morning (fasting)
- Results in 1-3 days
- Many hospitals have online portals

---

## Vaccinations

### Required
- None for most Western travelers

### Recommended (If Not Already Vaccinated)
- Hepatitis A & B
- Typhoid
- Tetanus-diphtheria
- Japanese encephalitis (if rural travel)
- Rabies (if animal contact likely)

### Where to Get
- Hospital travel clinics
- Thai Red Cross (Saovabha Institute)
- Queen Saovabha Memorial Institute

---

## Emergency Situations

### What to Do

1. **Minor injury/illness**: Walk-in clinic or pharmacy
2. **Moderate**: Hospital outpatient or ER
3. **Serious**: Call 1669 or go directly to ER
4. **Life-threatening**: 1669 ambulance

### Key Numbers
- **Ambulance**: 1669
- **Tourist Police**: 1155
- **Hospital switchboard**: Look up your nearest

### Insurance in Emergencies
- Hospitals may want deposit or insurance confirmation
- Emergency care will be provided regardless
- Sort payment after stabilization
