# Thai Cuisine Essentials

## The Four Flavors

Thai food balances four tastes in every dish:
- **Spicy** (เผ็ด / phet): Chilies
- **Sour** (เปรี้ยว / priao): Lime, tamarind
- **Sweet** (หวาน / waan): Palm sugar, coconut
- **Salty** (เค็ม / kem): Fish sauce, soy sauce

Great Thai food hits all four. Adjust with table condiments.

## Regional Cuisines

### Central Thai (Bangkok)
- What tourists think of as "Thai food"
- Coconut-based curries, balanced flavors
- **Dishes**: Green curry, pad thai, tom yum

### Isaan (Northeastern)
- Laos-influenced, bold and spicy
- Sticky rice base, grilled meats
- **Dishes**: Som tam, larb, gai yang, nam tok

### Northern Thai (Chiang Mai)
- Milder, more herbs, Burmese influence
- **Dishes**: Khao soi, sai oua, nam prik noom

### Southern Thai
- Hottest region, Malaysian influence, lots of turmeric
- **Dishes**: Massaman curry, yellow curry, roti

## Essential Dishes (Complete Guide)

### Curries (Gaeng)

**Green Curry (Gaeng Keow Wan)**
- Sweet, creamy, spicy — green from fresh chilies
- Chicken or pork most common
- Eat with rice

**Red Curry (Gaeng Phet)**
- Spicier than green, red from dried chilies
- Often with duck or beef

**Massaman Curry (Gaeng Massaman)**
- Southern Muslim curry, mild and rich
- Potatoes, peanuts, cinnamon
- Usually beef

**Panang Curry (Gaeng Panang)**
- Thick, rich, peanutty
- Usually pork or beef

**Yellow Curry (Gaeng Karee)**
- Mildest, Indian-influenced
- Potatoes, chicken

### Soups

**Tom Yum (ต้มยำ)**
- Hot and sour soup, lemongrass, galangal, lime
- Tom yum goong (shrimp) is iconic
- Clear (nam sai) or creamy (nam khon)

**Tom Kha (ต้มข่า)**
- Coconut soup, milder than tom yum
- Same aromatics, gentler flavor
- Tom kha gai (chicken) most common

**Khao Tom (ข้าวต้ม)**
- Rice soup/porridge
- Breakfast food, hangover cure
- Light, comforting

### Stir-Fries

**Pad Krapao (ผัดกระเพรา)**
- Holy basil stir-fry
- Thailand's national comfort food
- Minced pork + fried egg = perfect

**Pad See Ew (ผัดซีอิ๊ว)**
- Wide rice noodles, soy sauce, egg
- Chinese-Thai crossover
- Mild, filling

**Pad Thai (ผัดไทย)**
- Rice noodles, egg, tofu, peanuts
- Created in 1930s as national dish
- Tourist staple, but good versions exist

**Pad Pak (ผัดผัก)**
- Stir-fried vegetables
- Morning glory (pak bung) most famous

### Salads (Yam)

**Som Tam (ส้มตำ)**
- Green papaya salad
- Spicy, sour, sweet, funky
- Isaan staple, eaten everywhere

**Larb (ลาบ)**
- Minced meat salad, lime, mint, chilies
- Isaan dish, intense flavors
- Larb moo (pork) most common

**Nam Tok (น้ำตก)**
- Grilled meat salad
- Similar to larb but with sliced grilled beef/pork

**Yam Woon Sen (ยำวุ้นเส้น)**
- Glass noodle salad
- Seafood, lime, cilantro

### Rice Dishes

**Khao Pad (ข้าวผัด)**
- Thai fried rice
- Eggs, vegetables, meat/seafood
- Squeeze lime over it

**Khao Man Gai (ข้าวมันไก่)**
- Chicken rice
- Poached chicken, rice cooked in broth
- With sweet soy sauce and ginger sauce

**Khao Moo Daeng (ข้าวหมูแดง)**
- Red BBQ pork with rice
- Chinese-Thai classic
- Sweet sauce, hard-boiled egg

**Khao Ka Moo (ข้าวขาหมู)**
- Braised pork leg on rice
- Five-spice flavored, tender meat

### Noodles

**Kuay Teow (ก๋วยเตี๋ยว)**
- Noodle soup — the everyday meal
- Choose: noodle type, meat, soup style

**Noodle Types:**
- Sen lek: Thin rice noodles
- Sen yai: Wide rice noodles
- Sen mee: Vermicelli
- Bami: Egg noodles

**Boat Noodles (Kuay Teow Reua)**
- Dark, intense broth
- Small portions, eat many
- Victory Monument famous

**Pad See Ew**
- Wide noodles, dark soy sauce
- Mild, filling, good intro dish

### Grilled/Fried

**Gai Yang (ไก่ย่าง)**
- Isaan grilled chicken
- Lemongrass marinade
- Served with sticky rice, som tam

**Moo Ping (หมูปิ้ง)**
- Grilled pork skewers
- Sweet, savory, charred
- Breakfast or snack

**Pla Pao (ปลาเผา)**
- Salt-crusted grilled fish
- Whole fish, herbs inside
- Dramatic presentation

## Thai Cooking Ingredients

### Essential Aromatics
- **Lemongrass**: Citrus, essential in tom yum
- **Galangal**: Like ginger but sharper
- **Kaffir lime leaves**: Citrus fragrance
- **Thai basil**: Anise notes, used fresh
- **Cilantro**: Root, stem, and leaves used

### Sauces
- **Fish sauce (nam pla)**: The salt of Thai cooking
- **Oyster sauce**: Savory sweetness
- **Soy sauce**: Light and dark varieties
- **Shrimp paste (gapi)**: Funky, intense

### Chilies
- **Prik kee noo**: Bird's eye chili, tiny and deadly
- **Prik chee fah**: Milder, for curries
- **Dried chilies**: For curry pastes

## Eating Etiquette

### How Thais Eat
- **Shared dishes**: Order for the table, share everything
- **Rice is central**: Dishes accompany rice
- **Spoon and fork**: Fork pushes food onto spoon
- **Chopsticks**: Only for noodle soups
- **No knives**: Food is pre-cut

### At the Table
- **Eldest serves first** or orders
- **Take small portions**, go back for more
- **Don't finish everything** — shows you're full
- **Compliment the food** — "Aroi mak" (very delicious)

## Common Misconceptions

- **"All Thai food is spicy"**: Many dishes are mild (khao man gai, pad see ew)
- **"Pad thai is authentic Thai"**: It's a 1930s invention for nationalism
- **"Thai food is like Vietnamese"**: Very different cuisines
- **"Fish sauce ruins everything"**: It adds depth, not fishiness
- **"Street food is risky"**: It's often safer than restaurants (fresher, faster)
