# Bangkok Food Practical Guide

## Dietary Restrictions

### Vegetarian

**Challenge**: Thai cooking uses fish sauce, oyster sauce, and shrimp paste in almost everything.

**Solutions**:

**Jay Food (เจ)**
- Buddhist vegetarian cuisine
- Strictly no meat, no fish sauce, no garlic, no onion
- Look for: Yellow flags with red ธ symbol
- Found: Near temples, dedicated stalls, during vegetarian festival

**Ordering Vegetarian**
```
"Gin jay" (กินเจ) — I eat vegetarian (jay style)
"Mai sai nam pla" — No fish sauce
"Mai sai sauce hoi" — No oyster sauce
"Gin pak" — I eat vegetables (but not strictly vegetarian)
```

**Good Vegetarian-Friendly Spots**
- **Ethos** (Khao San) — Veggie restaurant
- **Broccoli Revolution** (Sukhumvit 49) — Health food
- **Rasayana Retreat** — Raw vegan
- **Indian restaurants** — Many vegetarian options

**Naturally Vegetarian Dishes**
- Pad pak (stir-fried vegetables) — but ask mai sai nam pla
- Spring rolls (but check for shrimp)
- Morning glory (pak bung fai daeng)
- Papaya salad — can be made vegetarian

### Vegan

Same challenges as vegetarian, plus:
- **Eggs**: In pad thai, fried rice, many dishes
- **Fish sauce**: Ubiquitous
- **Condensed milk**: In Thai tea, desserts

**Say**: "Mai sai kai, mai sai nom" (no egg, no milk)

**Best Options**
- Jay food restaurants
- Indian restaurants (specify vegan)
- Dedicated vegan restaurants (small but growing)
- Fruit and rice dishes

### Halal

**Where to Find**
- **Sukhumvit Soi 3**: Arab Quarter, everything halal
- **Look for**: Arabic signage, halal certificates
- **Some food courts**: Label halal stalls
- **Muslim areas**: Ramkhamhaeng, Minburi

**Halal Restaurants**
- **Nasir Al-Masri** (Soi 3/1) — 24/7 Arab
- **Al Hussain** — Egyptian
- **Many Indian places**: Check before ordering

### Gluten-Free

**Good News**: Thai food is mostly rice-based

**Watch Out For**
- Soy sauce (contains wheat)
- Oyster sauce
- Some curry pastes
- Fried foods (shared oil)
- Noodles (some contain wheat)

**Safe Options**
- Rice dishes
- Grilled meats (without marinade)
- Curries (check paste ingredients)
- Rice noodles (sen lek, sen yai)

**Say**: "Allergy gluten" — most won't understand, so avoid soy sauce dishes

### Allergies

**Common Allergens in Thai Food**
- **Peanuts**: Pad thai, satay, som tam, curries
- **Shellfish**: Shrimp paste in curry, fish sauce everywhere
- **Tree nuts**: Cashews in stir-fries
- **Soy**: Soy sauce, tofu

**Communication**
- Print allergy cards in Thai (Google "Thai allergy card")
- Show pictures
- Stick to simple dishes you can see prepared
- High-end restaurants understand allergies better

---

## Alcohol in Bangkok

### Legal Drinking
- **Age**: 21 years old (but rarely checked)
- **Hours**: Officially 11 AM - 2 PM and 5 PM - midnight
- **Reality**: Many places serve outside hours, especially in entertainment zones

### Where to Drink

**Bars and Clubs**
- Open late (some until 3-4 AM in entertainment zones)
- RCA, Sukhumvit Soi 11, Thonglor

**Restaurants**
- Most serve alcohol
- Even street restaurants (small bottles on table)

**Convenience Stores**
- 7-Eleven sells beer, wine, whisky
- No sales 2-5 PM or midnight-11 AM (technically)
- Reality: Rules often ignored

### What to Drink

**Beer**
- **Singha**: Premium Thai lager
- **Chang**: Strong (6.4%), cheap, headache-inducing
- **Leo**: Lighter option
- **Craft beer**: Growing scene (Mikeller, etc.)

**Thai Whisky**
- **Mekhong**: Actually rum, sweet
- **Sang Som**: Thai rum, mixer-friendly
- **Hong Thong**: Budget option

**Cocktails**
- Bangkok has excellent cocktail bars
- **Teens of Thailand** — Speakeasy
- **Backstage** — Experimental
- **Tropic City** — Tiki

### Prices
- **7-Eleven large Chang**: ฿55
- **Bar beer**: ฿100-200
- **Cocktail bar**: ฿300-500
- **Hotel bar**: ฿400-800

---

## Coffee Culture

Bangkok has an excellent specialty coffee scene.

### Café Culture
- Work-friendly (laptops common)
- No time limits usually
- Free WiFi standard
- AC salvation from heat

### Types of Cafés

**Specialty Coffee**
- Roaster-owned
- Single origin options
- ฿100-200 per drink

**Chain Cafés**
- **Amazon** (everywhere, cheap)
- **Starbucks** (malls)
- **True Coffee** (decent, many locations)
- **Pacamara** (local specialty chain)

**Instagram Cafés**
- Aesthetic-focused
- Often overpriced
- Good for photos

### Notable Cafés
- **Roots** (Thonglor) — Specialty pioneer
- **Ceresia** (Ari) — Excellent roastery
- **Rocket Coffeebar** (Sathorn) — Brunch + coffee
- **Casa Lapin** (Ari) — Multi-story landmark
- **Factory Coffee** (Phrom Phong) — Industrial design

### Thai Coffee

**Traditional (Gafae Boran)**
- Sock-brewed, condensed milk
- Very sweet and strong
- ฿20-40 at street stalls

**Thai Iced Tea/Coffee**
- Orange from tea leaves + condensed milk
- Ubiquitous and addictive
- ฿30-60

---

## Food Delivery

### Apps

**Grab Food**
- Most popular
- Widest selection
- English interface
- Card payment

**Foodpanda**
- Good alternative
- Sometimes better deals
- English interface

**LINE MAN**
- Thai-owned
- Good coverage
- Thai interface (but manageable)

**Robinhood**
- Thai platform
- Zero commission = better for restaurants
- Growing selection

### How It Works
1. Download app, register
2. Set delivery address
3. Browse restaurants
4. Order and pay (cash or card)
5. Track delivery

### Delivery Fees
- Usually ฿10-50 for nearby
- ฿50-100+ for far
- Free delivery promotions common

### Tips
- Add apartment/condo name, not just address
- Include floor number
- Thai phone number helps
- Tip riders (฿20 is appreciated)

---

## Grocery Shopping

### Supermarkets

**Premium**
- **Gourmet Market** (Siam Paragon)
- **Villa Market** (Sukhumvit)
- **UFM Fuji Super** (Japanese imports)

**Mid-Range**
- **Tops** (Central malls)
- **MaxValu** (Japanese-owned, good produce)

**Budget**
- **Big C**
- **Tesco Lotus**
- **Makro** (wholesale, need card)

### Fresh Markets

**Or Tor Kor** — Premium produce, near Chatuchak
**Klong Toey Market** — Wholesale, early morning
**Local wet markets** — Every neighborhood

### What's Cheap
- Rice, noodles
- Local vegetables
- Tropical fruits
- Fresh seafood

### What's Expensive
- Imported cheese
- Wine (200% tax)
- Western packaged goods
- Beef (most is imported)

---

## Tipping

### Not Expected (But Appreciated)

**Street Food**: No tip
**Food Courts**: No tip
**Local Restaurants**: Round up to nearest ฿10-20
**Western Restaurants**: 10% if no service charge
**Fine Dining**: Often includes 10% service charge

### If Service Charge Included
- Usually 10%
- No additional tip needed
- But ฿50-100 for excellent service is appreciated

---

## Useful Food Phrases

| English | Thai | Pronunciation |
|---------|------|---------------|
| Delicious! | อร่อย | Aroi |
| Check please | เช็คบิล | Check bin |
| No spicy | ไม่เผ็ด | Mai phet |
| A little spicy | เผ็ดนิดหน่อย | Phet nit noi |
| No sugar | ไม่ใส่น้ำตาล | Mai sai nam taan |
| No MSG | ไม่ใส่ผงชูรส | Mai sai pong choo rot |
| Take away | ใส่ถุง | Sai toong |
| Eat here | ทานที่นี่ | Taan tee nee |
| One more | อีกหนึ่ง | Eek neung |
| Too expensive | แพงไป | Paeng pai |
