# Bangkok Food Overview

## Why Bangkok is a Food Capital

Bangkok consistently ranks among the world's best food cities. Unlike many capitals where you seek out good restaurants, in Bangkok you're surrounded by excellent food at every corner — from ฿40 street stalls to Michelin-starred restaurants.

### What Makes It Special
- **Street food culture**: Eating out is cheaper than cooking. Most Thais eat street food daily.
- **Regional diversity**: All Thai regional cuisines represented (Isaan, Southern, Northern, Central)
- **International options**: Large expat population means excellent Japanese, Indian, Middle Eastern, Western
- **Price range**: ฿40 ($1.15) street meal to ฿5,000+ ($145) fine dining
- **Quality floor**: Even cheap food is good. Bad restaurants don't survive.

## The Eating Day in Bangkok

### Breakfast (7-10 AM)
**Thai style**:
- Jok (rice porridge) — ฿40-60
- Pa-tong-go (fried dough) + coffee — ฿30-50
- Khao tom (rice soup) — ฿50-80

**Expat style**:
- Café breakfast (eggs, toast, coffee) — ฿150-300
- Hotel breakfast buffet — ฿400-800

### Lunch (11 AM - 2 PM)
Peak eating time. Office workers flood street stalls.
- **Street food**: ฿40-80
- **Food courts**: ฿50-100
- **Restaurants**: ฿100-300
- **Expat lunch spots**: ฿200-500

### Dinner (6-10 PM)
- **Street food**: ฿50-100
- **Local restaurants**: ฿100-200
- **Mid-range**: ฿300-600
- **Fine dining**: ฿1,500-5,000+

### Late Night (10 PM - 3 AM)
Bangkok never sleeps. Find:
- Chinatown stalls (until midnight+)
- Pratunam area (24/7)
- Night markets
- After-party spots

## Food Court Culture

Thai mall food courts are exceptional:

### Top Food Courts
| Location | Vibe | Price |
|----------|------|-------|
| **Terminal 21** (Asok, 5th floor) | Best value, diverse | ฿40-80 |
| **MBK** (6th floor) | Classic, touristy | ฿50-100 |
| **Siam Paragon** (basement) | Upscale | ฿100-200 |
| **EmQuartier** (Helix) | Premium | ฿150-300 |
| **Icon Siam** (Sook Siam) | Stunning, floating market theme | ฿60-150 |

### How They Work
1. Buy a prepaid card at the counter
2. Load ฿100-300
3. Use card at any stall
4. Refund unused balance at exit

## Price Guide

| Category | Price Range | Examples |
|----------|-------------|----------|
| **Street stall** | ฿40-80 | Pad thai, rice dishes, noodles |
| **Food court** | ฿50-100 | Same dishes, air-conditioned |
| **Local restaurant** | ฿80-150 | Sit-down, menu ordering |
| **Casual dining** | ฿150-350 | Chain restaurants, cafés |
| **Mid-range** | ฿350-800 | Good restaurants |
| **Upscale** | ฿800-2,000 | Fine dining, hotel restaurants |
| **Top-tier** | ฿2,000-5,000+ | Michelin, celebrity chefs |

## Michelin Guide Bangkok

Bangkok has its own Michelin Guide. Notable stars:

### Michelin-Starred Restaurants
- **Gaggan Anand** (2 stars) — Progressive Indian
- **Le Normandie** (2 stars) — French, Mandarin Oriental
- **Sühring** (2 stars) — German fine dining
- **R-Haan** (2 stars) — Royal Thai cuisine
- **Jay Fai** (1 star) — Street food legend, crab omelette

### Bib Gourmand (Great Value)
Dozens of street stalls and small restaurants — look for the designation.

## Dietary Considerations

### Vegetarian/Vegan
- **"Jay" food**: Buddhist vegetarian, widely available
- **Look for**: ธ symbol (yellow flag) at jay stalls
- **Challenge**: Many "vegetable" dishes have fish sauce or oyster sauce
- **Say**: "Gin jay" (กินเจ) — I eat vegetarian
- **Or**: "Mai sai nam pla" — No fish sauce

### Halal
- Large Muslim population = many halal options
- **Sukhumvit Soi 3/3/1**: Arab Quarter, halal everywhere
- **Look for**: Arabic signage, halal certificates
- **Areas**: Nana, Ramkhamhaeng, some food courts label halal stalls

### Allergies
- **Peanuts**: Common in pad thai, satay, som tam
- **Shellfish**: Shrimp paste (gapi) is in many curry pastes
- **Gluten**: Rice-based cuisine is mostly safe, but soy sauce is common
- **Communication**: Google Translate allergy cards help

## Spice Levels

Thai food is spicy. Really spicy.

### Ordering Guide
- **Mai phet** (ไม่เผ็ด): Not spicy — safest for beginners
- **Phet nit noi** (เผ็ดนิดหน่อย): A little spicy — still has kick
- **Phet** (เผ็ด): Spicy — Thai normal, foreigner pain
- **Phet mak** (เผ็ดมาก): Very spicy — local level

### Reality Check
- "A little spicy" by Thai standards can be intense for Westerners
- Start with "mai phet" and add chili yourself
- Chili flakes, fish sauce, and sugar on every table

## Food Safety

Bangkok street food is generally safe. Millions eat it daily.

### Rules
1. **Busy stalls = safe stalls** — High turnover means fresh
2. **Watch them cook it** — Fresh preparation
3. **If in doubt, eat cooked** — Avoid raw in early days
4. **Ice is usually safe** — Machine-made, cylindrical with holes

### If You Get Sick
- **Charcoal pills**: Thai cure-all, pharmacies everywhere
- **Rehydration salts**: Essential
- **Imodium**: Short-term fix
- **Pharmacies**: Speak English, well-stocked

### Water
- **Tap water**: Don't drink it
- **Ice**: Usually safe (commercial machine-made)
- **Bottled water**: ฿10-20 everywhere
