# Bangkok Cost of Living

## Overview

Bangkok is affordable by Western standards, especially for housing and food. Lifestyle choices dramatically impact costs — you can live on $1,000/month or spend $5,000+.

## Quick Budget Summary

| Lifestyle | Monthly (THB) | Monthly (USD) |
|-----------|---------------|---------------|
| **Backpacker** | ฿20,000-30,000 | $570-860 |
| **Budget expat** | ฿35,000-50,000 | $1,000-1,430 |
| **Comfortable** | ฿60,000-80,000 | $1,700-2,300 |
| **Upscale** | ฿100,000-150,000 | $2,850-4,300 |
| **Luxury** | ฿200,000+ | $5,700+ |

---

## Housing

The biggest cost variation.

### Condos (Most Common for Expats)

| Area | Studio | 1BR | 2BR |
|------|--------|-----|-----|
| **On Nut** | ฿8,000-12,000 | ฿12,000-20,000 | ฿18,000-30,000 |
| **Ari** | ฿12,000-18,000 | ฿18,000-35,000 | ฿30,000-50,000 |
| **Asok** | ฿15,000-25,000 | ฿20,000-45,000 | ฿35,000-70,000 |
| **Thonglor** | ฿18,000-30,000 | ฿25,000-55,000 | ฿45,000-90,000 |
| **Silom** | ฿18,000-28,000 | ฿25,000-50,000 | ฿40,000-80,000 |
| **Sukhumvit luxury** | ฿25,000-50,000 | ฿40,000-100,000 | ฿80,000-200,000 |

### What's Included (Usually)
- Air conditioning (but YOU pay electricity)
- Furniture (most condos rented furnished)
- Building facilities (pool, gym)
- Security

### Additional Costs
- **Electricity**: ฿1,500-4,000/month (A/C usage = big factor)
- **Water**: ฿100-300/month
- **Internet**: ฿600-1,000/month (or included)
- **Deposit**: 2 months rent

### Rent Tips
- Negotiate for stays 6+ months
- Rainy season = better deals
- Direct from owner = cheaper
- Agents take 1 month fee

---

## Food

Eating out is often cheaper than cooking.

### Daily Food Costs

| Style | Per Meal | Daily Total |
|-------|----------|-------------|
| **Street food only** | ฿40-80 | ฿120-250 |
| **Mix street + food court** | ฿60-120 | ฿200-400 |
| **Casual restaurants** | ฿100-250 | ฿400-800 |
| **Western restaurants** | ฿250-500 | ฿700-1,500 |
| **Fine dining** | ฿1,000-3,000+ | N/A |

### Groceries

| Item | Price (THB) |
|------|-------------|
| Rice (5 kg) | ฿150-250 |
| Eggs (10) | ฿40-60 |
| Chicken breast (kg) | ฿100-150 |
| Pork (kg) | ฿120-180 |
| Local vegetables | ฿15-30/bunch |
| Imported vegetables | ฿50-150 |
| Milk (1L imported) | ฿60-80 |
| Bread | ฿30-60 |
| Local beer (Chang/Leo) | ฿45-60 |
| Imported wine | ฿400-1,500+ |

### Monthly Food Budgets

| Style | Monthly |
|-------|---------|
| Local eating only | ฿5,000-8,000 |
| Mix local + some Western | ฿8,000-15,000 |
| Mostly Western | ฿15,000-25,000 |
| Restaurants + delivery | ฿20,000-40,000 |

---

## Transport

### Monthly Scenarios

| Usage | Monthly Cost |
|-------|--------------|
| BTS/MRT daily commute | ฿1,500-2,500 |
| BTS + occasional Grab | ฿2,500-4,000 |
| Regular Grab user | ฿4,000-8,000 |
| Heavy Grab/taxi | ฿8,000-15,000 |

### Individual Costs
- BTS single trip: ฿17-62
- MRT single trip: ฿17-42
- Grab short trip: ฿50-100
- Grab airport: ฿300-450
- Motorbike taxi: ฿20-60

### Car Ownership (If You Must)
- Car payment: ฿10,000-20,000
- Insurance: ฿1,000-2,000
- Fuel: ฿3,000-6,000
- Parking: ฿2,000-5,000
- Tolls: ฿1,000-3,000
- **Total**: ฿17,000-36,000/month

---

## Utilities

### Electricity

A/C usage dominates your bill.

| Usage Pattern | Monthly |
|---------------|---------|
| Minimal A/C (fan mostly) | ฿500-1,000 |
| A/C evenings only | ฿1,500-2,500 |
| A/C all day (working from home) | ฿3,000-5,000 |
| Multiple A/C units | ฿4,000-8,000 |

**Note**: Most condos charge ฿7-8/unit vs government rate of ฿4. Budget accordingly.

### Other Utilities
- **Water**: ฿100-300
- **Internet**: ฿600-1,000 (100-1000 Mbps)
- **Mobile**: ฿300-700 (with data)

---

## Healthcare

### Insurance Options
- **Local policies**: ฿10,000-30,000/year
- **International**: $1,000-5,000/year
- **Travel insurance**: $50-150/month

### Without Insurance (Cash Pay)
- Doctor visit: ฿500-1,500
- Private hospital consultation: ฿1,000-3,000
- Dental cleaning: ฿800-1,500
- Medications: Cheaper than Western countries

### Why Insurance Matters
Major hospitalization can cost ฿100,000-1,000,000+. Get insurance.

---

## Entertainment

### Fitness
- Gym membership: ฿1,500-3,500/month
- Yoga studio: ฿3,000-6,000/month
- Muay Thai gym: ฿3,000-5,000/month
- Pool (condo): Usually included

### Nightlife
- Local beer: ฿60-120
- Cocktail bar: ฿250-400
- Club entry: ฿400-800
- Rooftop bar drink: ฿350-600

### Movies
- Regular ticket: ฿200-280
- VIP/first class: ฿500-1,500

### Coworking
- Hot desk: ฿300-500/day
- Monthly membership: ฿3,000-8,000

---

## Services

### Massage
- Thai massage (1 hr): ฿250-400
- Foot massage (1 hr): ฿200-300
- Oil massage (1 hr): ฿400-600
- Spa (2 hr package): ฿1,000-3,000

### Laundry
- Wash + fold (kg): ฿30-50
- Dry cleaning (shirt): ฿50-100

### Haircut
- Basic (Thai barber): ฿100-200
- Salon cut: ฿300-800
- Expat salon: ฿800-2,000

### Maid Service
- Weekly cleaning: ฿500-1,000
- Full-time maid: ฿12,000-18,000/month

---

## Sample Budgets

### Digital Nomad (Budget Comfortable)

| Category | Monthly (THB) |
|----------|---------------|
| Rent (1BR On Nut) | ฿15,000 |
| Electricity | ฿2,500 |
| Internet/phone | ฿1,000 |
| Food (mix local/Western) | ฿12,000 |
| Transport | ฿3,000 |
| Coworking | ฿4,000 |
| Entertainment | ฿5,000 |
| Misc | ฿2,500 |
| **Total** | **฿45,000** (~$1,285) |

### Young Professional (Comfortable)

| Category | Monthly (THB) |
|----------|---------------|
| Rent (1BR Thonglor) | ฿30,000 |
| Electricity | ฿3,000 |
| Utilities | ฿1,500 |
| Food | ฿15,000 |
| Transport | ฿4,000 |
| Gym | ฿2,500 |
| Entertainment | ฿10,000 |
| Savings/misc | ฿9,000 |
| **Total** | **฿75,000** (~$2,140) |

### Couple (Upscale)

| Category | Monthly (THB) |
|----------|---------------|
| Rent (2BR Sukhumvit) | ฿50,000 |
| Utilities | ฿5,000 |
| Food | ฿25,000 |
| Transport | ฿8,000 |
| Healthcare/insurance | ฿4,000 |
| Entertainment | ฿15,000 |
| Travel/savings | ฿18,000 |
| **Total** | **฿125,000** (~$3,570) |

---

## Comparison to Western Cities

| Category | Bangkok | New York | London | Sydney |
|----------|---------|----------|--------|--------|
| 1BR rent | $600 | $3,500 | $2,500 | $2,000 |
| Street meal | $2 | $15 | $12 | $15 |
| Monthly transport | $100 | $130 | $200 | $150 |
| Beer (bar) | $3 | $8 | $7 | $9 |

Bangkok costs roughly **30-50%** of major Western cities for comparable lifestyle.
