# Bangkok Climate & Weather

## Overview

Bangkok is **hot and humid year-round**. There are three seasons, but temperatures rarely drop below 25°C or rise above 40°C.

### The Three Seasons

| Season | Months | Temperature | Humidity | Rain |
|--------|--------|-------------|----------|------|
| **Hot** | Mar-May | 35-40°C | 60-70% | Occasional |
| **Rainy** | Jun-Oct | 28-35°C | 80-90% | Daily |
| **Cool** | Nov-Feb | 25-32°C | 50-70% | Rare |

"Cool" is relative — still warm by Western standards.

---

## Month-by-Month

### November - February (Cool/Dry Season)

**Best time to visit.**

| Month | Avg High | Avg Low | Rain Days | Notes |
|-------|----------|---------|-----------|-------|
| Nov | 32°C | 24°C | 5 | Cooling begins |
| Dec | 31°C | 22°C | 1 | Peak tourist season |
| Jan | 32°C | 22°C | 1 | Pleasant, dry |
| Feb | 33°C | 24°C | 1 | Warming starts |

**What to Expect**:
- Most comfortable weather
- Minimal rain
- Lower humidity
- **Air pollution peaks** (Nov-Feb)
- Christmas/New Year crowds
- Chinese New Year (Feb) = busy

### March - May (Hot Season)

**Brutal heat.**

| Month | Avg High | Avg Low | Rain Days | Notes |
|-------|----------|---------|-----------|-------|
| Mar | 34°C | 26°C | 3 | Getting hot |
| Apr | 35°C | 27°C | 6 | Peak heat, Songkran |
| May | 34°C | 26°C | 16 | Transition to rain |

**What to Expect**:
- Oppressive heat (35-40°C+ possible)
- High humidity
- Exhausting outdoor activities
- **Songkran** (April 13-15): Thai New Year water festival
- Fewer tourists
- Some beach closures begin

### June - October (Rainy/Monsoon Season)

**Daily rain, but not all day.**

| Month | Avg High | Avg Low | Rain Days | Notes |
|-------|----------|---------|-----------|-------|
| Jun | 33°C | 26°C | 16 | Monsoon begins |
| Jul | 33°C | 26°C | 18 | Steady rain |
| Aug | 33°C | 26°C | 20 | Heavy rain |
| Sep | 32°C | 25°C | 21 | Wettest month |
| Oct | 32°C | 25°C | 17 | Tapering off |

**What to Expect**:
- Afternoon showers (usually 30-60 min)
- Morning often clear
- Flash flooding possible
- Humidity very high
- Lush and green
- Fewer tourists, better deals
- Some islands less accessible

---

## What the Weather Actually Feels Like

### Hot Season (March-May)
- **8 AM**: Already warm (28°C)
- **12 PM - 4 PM**: Unbearable outside (35°C+)
- **Evening**: Still hot (30°C)
- **Night**: Warm, need A/C to sleep (28°C)

Outdoor activities only feasible early morning or after dark.

### Rainy Season (June-October)
- **Morning**: Often sunny, humid
- **2-5 PM**: Likely rain (sometimes heavy)
- **Evening**: Clears up usually
- **Pattern**: Rain comes fast, leaves fast

Don't cancel plans — just wait 30-60 minutes.

### Cool Season (November-February)
- **Morning**: Pleasantly cool (22-25°C)
- **Midday**: Warm but comfortable (30-32°C)
- **Evening**: Pleasant (26-28°C)
- **Night**: Can feel cool to acclimated expats (22-24°C)

Best time for temples, walking, outdoor activities.

---

## Air Quality

### The Problem
November to February has the worst air quality due to:
- Crop burning in surrounding regions
- Vehicle emissions trapped by weather
- Geography (Bangkok sits in a basin)

### AQI Levels

| AQI | Category | Advice |
|-----|----------|--------|
| 0-50 | Good | No concerns |
| 51-100 | Moderate | Sensitive groups take care |
| 101-150 | Unhealthy for Sensitive | Limit outdoor exercise |
| 151-200 | Unhealthy | Everyone reduce outdoor activity |
| 200+ | Very Unhealthy | Stay inside, use mask outside |

### Typical Season
- **Nov-Dec**: Building (AQI 50-100)
- **Jan-Feb**: Peak (AQI 100-200+)
- **March**: Improving
- **Apr-Oct**: Generally good

### What to Do
- Download AQI app (IQAir, AirVisual)
- Check daily during season
- **N95 mask**: Get one for bad days
- Air purifier in room helps
- Schedule outdoor activities for good days
- Gyms/indoor exercise when bad

---

## Surviving the Heat

### Daily Habits
1. **Hydrate constantly**: Carry water everywhere
2. **Plan around midday**: Indoor 12-4 PM
3. **Accept A/C dependency**: It's not weakness
4. **Light clothing**: Cotton, linen
5. **Umbrella**: For sun AND rain
6. **Cold showers**: Thai habit, embrace it

### Acclimatization
- First 1-2 weeks are hardest
- Body adjusts after ~3 weeks
- Locals often feel cold in A/C you find comfortable

### Heat Exhaustion Signs
- Excessive sweating then stopping
- Weakness, dizziness
- Nausea
- Rapid heartbeat
- Headache

**Action**: Get to A/C, hydrate, rest. Seek medical help if severe.

---

## Rain Survival

### The Pattern
- **Usually afternoon** (2-5 PM)
- **Usually 30-60 minutes**
- **Intense while it lasts**
- **Quick drainage usually** (but not always)

### What to Carry
- **Compact umbrella**: Essential
- **Sandals**: Feet will get wet
- **Waterproof bag**: For electronics
- **Grab app**: Rain = surge, but better than walking

### Flooding
- Some areas flood regularly (Asok underpass, Sukhumvit Soi 21)
- Check drainage before renting apartment
- Water recedes quickly usually
- Major floods rare but possible

### Indoor Options
- Malls: Air-conditioned paradise
- Cafés: Wait out the rain
- Cinemas: Perfect for afternoon storms

---

## Packing for Bangkok

### Hot Season (Mar-May)
- Lightest possible clothes
- Sun protection essential
- Hat or umbrella for sun
- Multiple changes (you'll sweat)

### Rainy Season (Jun-Oct)
- Quick-dry materials
- Waterproof bag for electronics
- Sandals that handle water
- Umbrella or poncho

### Cool Season (Nov-Feb)
- Light layers (evenings can feel cool)
- Still mostly hot clothes
- N95 mask for pollution days

### Year-Round
- Temple cover-ups (shoulders, knees)
- Sunscreen, sunglasses
- Comfortable walking shoes
- Light cardigan for A/C

---

## Best Times For...

### Sightseeing (Temples)
- **Best**: November-February (cooler)
- **OK**: Early morning any season
- **Avoid**: Midday March-May

### Beach Trips
- **Best**: December-April
- **Note**: West coast (Phuket) vs East coast (Koh Samui) have different seasons
- **Avoid**: September-October for Gulf islands

### Shopping/Indoor
- Any time (everything is A/C)

### Outdoor Activities
- **Best**: November-February
- **Alternative**: Early morning/evening year-round

### Budget Travel
- **Best deals**: May-October (rainy season)
- **Fewer crowds**: Same period

---

## Thai Adaptations

**What locals do**:
- Wake early, do activities before noon
- Long lunch breaks in A/C
- Evening activities (night markets, dining)
- Umbrella used for sun, not just rain
- Cold drinks constantly
- Multiple showers per day
- Accept the sweating
