# Bangkok Business Setup Guide

## Overview

Setting up a business in Thailand is possible for foreigners but involves specific requirements. This covers the main routes and considerations.

## Business Structures

### Thai Limited Company

**Most Common Structure for Foreigners**

**Requirements**:
- Minimum 3 shareholders
- At least 51% Thai ownership (standard)
- 2 million THB registered capital for work permit
- Thai directors can be included

**Foreign Majority Ownership (49%+) Possible If**:
- BOI promoted business
- Under a treaty (US-Thai Amity)
- Specific exempted sectors

**Setup Cost**: ฿40,000-80,000 (through agent)
**Timeline**: 2-4 weeks
**Annual Filing**: Required (accounting, tax returns)

### BOI (Board of Investment) Company

**For Investment-Heavy Businesses**

**Benefits**:
- Up to 100% foreign ownership
- Tax holidays (3-8 years corporate tax exemption)
- Work permit facilitation
- Land ownership rights possible

**Requirements**:
- Investment threshold (varies by sector)
- Business plan review
- Technology/employment requirements

**Best For**: Manufacturing, tech, R&D, high-value services

### US-Thai Amity Treaty Company

**For US Citizens/Companies Only**

**Benefits**:
- 100% US ownership allowed
- National treatment
- Most business activities allowed

**Requirements**:
- US citizen(s) as majority shareholders
- Amity Treaty registration
- Standard company formation

### Branch Office

**For Established Foreign Companies**

- Represents parent company
- Limited scope of activities
- Requires Foreign Business License
- Good for regional sales offices

---

## Common Business Activities

### Restricted for Foreigners

Under Foreign Business Act, foreigners cannot own 50%+ in:
- Retail businesses (unless BOI or specific exemption)
- Restaurants (can operate but Thai majority needed)
- Import/export trading
- Many service businesses

### More Accessible
- IT/Software development (can often get BOI)
- Digital services
- Consulting (with proper structuring)
- Manufacturing (BOI route)
- Tourism (with restrictions)

---

## Costs of Setting Up

### Company Registration

| Item | Cost (THB) |
|------|------------|
| Company registration fees | ฿5,000-10,000 |
| Legal/agent fees | ฿30,000-70,000 |
| Registered capital (minimum) | ฿2,000,000 (for work permit) |
| Office registration | ฿10,000-20,000 |
| **Total (Basic Setup)** | ฿50,000-100,000 |

### Ongoing Costs

| Item | Annual Cost |
|------|-------------|
| Accounting | ฿20,000-60,000 |
| Office space | ฿60,000-300,000+ |
| Work permit renewals | ฿5,000-10,000 |
| Corporate tax | 20% of profits |
| VAT registration | If revenue >1.8M THB |

### Registered Capital Note

The 2 million THB doesn't need to be deposited — it's commitment capital. But you need it for work permit eligibility.

---

## Work Permit Through Company

### Requirements
- Company must have 2M THB registered capital per work permit
- 4:1 ratio (4 Thai employees per 1 foreign work permit)
- Legitimate business activity

### Process
1. Set up company
2. Register for tax
3. Hire Thai employees
4. Apply for Non-B visa
5. Apply for work permit (after arrival)

**Timeline**: 1-3 months total

---

## BOI Promoted Business

### How It Works

1. **Apply to BOI** with business plan
2. **Receive promotion** (if approved)
3. **Register company** with BOI benefits
4. **Operate** under promotion conditions

### Popular Promoted Categories

**Tech & Digital**:
- Software development
- Digital content
- E-commerce platforms
- Cloud services

**Manufacturing**:
- Electronics
- Automotive parts
- Food processing
- Medical devices

**Services**:
- R&D centers
- Regional operating headquarters
- International business centers

### BOI Benefits Comparison

| Benefit | Standard Company | BOI Promoted |
|---------|------------------|--------------|
| Foreign ownership | 49% max | Up to 100% |
| Corporate tax | 20% | 0-13% for 3-8 years |
| Import duty on machinery | Standard rates | Exemption possible |
| Land ownership | Cannot | Possible |
| Work permit process | Complex | Facilitated |

---

## Freelancing / Sole Proprietor

### Legal Reality
Thailand doesn't have a freelancer visa or easy sole proprietor option for foreigners.

**Options**:
1. **Work illegally** (common but risky)
2. **Set up company** (expensive for small operators)
3. **Work remotely for foreign clients** (gray area)
4. **LTR visa** (if qualifying income, legal remote work)
5. **Partner with Thai company** (as contractor)

---

## Office Space

### Virtual Office
- **Cost**: ฿3,000-8,000/month
- **Provides**: Registered address, mail handling
- **Good for**: Initial registration, remote businesses

### Coworking
- **Cost**: ฿3,000-10,000/month
- **Provides**: Workspace, meeting rooms
- **Note**: May not qualify for company registration

### Serviced Office
- **Cost**: ฿15,000-50,000/month
- **Provides**: Private office, reception, utilities
- **Good for**: Small teams, professional image

### Traditional Office
- **Cost**: ฿200-1,000/sqm depending on area
- **Best areas**: Silom, Sathorn, Sukhumvit
- **Lease**: Usually 3+ years

---

## Taxation

### Corporate Tax
- **Standard rate**: 20%
- **SME rate**: 15% on first 3M THB profit (conditions apply)
- **BOI**: 0-13% (promotional periods)

### VAT
- **Rate**: 7%
- **Registration required**: If revenue exceeds 1.8M THB/year
- **Filing**: Monthly

### Personal Income Tax
If taking salary from your company:
- Progressive rates: 0-35%
- First 150,000 THB: 0%
- Above 5M THB: 35%

### Withholding Tax
Various rates on payments to contractors, etc.

---

## Banking for Business

### Opening Business Account

**Requirements**:
- Company registration documents
- Director ID/passport
- Company stamp
- Board resolution authorizing account

**Banks**:
- Bangkok Bank (most foreigner-friendly)
- Kasikorn
- SCB

**Timeline**: 1-2 weeks

### Payment Processing
- Credit card processing available
- QR code payments (PromptPay)
- International transfers possible

---

## Hiring Employees

### Requirements
- Register with Social Security
- Minimum wage compliance (฿353/day in Bangkok, 2024)
- Work rules if 10+ employees
- Labor law compliance

### Costs Beyond Salary
- Social Security: 5% employer contribution (capped)
- Provident fund: Optional, typically 3-5%
- Insurance: Usually provided for competitiveness

### Termination
Thai labor law is employee-protective:
- Severance required based on tenure
- Proper process must be followed
- Wrongful termination is expensive

---

## Finding Help

### Legal & Accounting
- **Tilleke & Gibbins**: Major law firm
- **Baker McKenzie**: International
- **Mazars Thailand**: Accounting
- **Local agents**: Cheaper, good for simple setup

### Government Resources
- **BOI**: boi.go.th
- **DBD (Business Development)**: dbd.go.th
- **Revenue Department**: rd.go.th

### Networking
- **AmCham**: US businesses
- **BCCT**: British Chamber
- **JCCB**: Japanese Chamber
- **AustCham**: Australian businesses
