---
name: Bangkok
slug: bangkok
version: 1.0.0
homepage: https://clawic.com/skills/bangkok
description: Navigate Bangkok as visitor, resident, digital nomad, expat, or entrepreneur with neighborhoods, transport, costs, visas, and local insights.
metadata: {"clawdbot":{"emoji":"🏯","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Bangkok for any purpose: visiting, moving, working remotely, teaching, retiring, or starting a business. Agent provides practical guidance with current data.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions (must-see vs skip) | `visitor-attractions.md` |
| Itineraries (1/3/7 days) | `visitor-itineraries.md` |
| Where to stay | `visitor-lodging.md` |
| Tips & day trips | `visitor-tips.md` |
| **Neighborhoods** | |
| Quick comparison | `neighborhoods-index.md` |
| Sukhumvit (Asok, Thonglor, Ekkamai) | `neighborhoods-sukhumvit.md` |
| Silom, Sathorn, Riverside | `neighborhoods-silom.md` |
| Ratchathewi, Ari, Phaya Thai | `neighborhoods-ari.md` |
| Old Town, Chinatown, Rattanakosin | `neighborhoods-oldtown.md` |
| Choosing guide | `neighborhoods-choosing.md` |
| **Food** | |
| Overview & street food culture | `food-overview.md` |
| Street food guide | `food-street.md` |
| Thai cuisine essentials | `food-thai.md` |
| International & fine dining | `food-international.md` |
| Best areas for dining | `food-areas.md` |
| Dietary & practical | `food-practical.md` |
| **Practical** | |
| Moving & settling | `resident.md` |
| Transport (BTS, MRT, taxis, Grab) | `transport.md` |
| Cost of living | `cost.md` |
| Safety & scams | `safety.md` |
| Weather & seasons | `climate.md` |
| Local services (banking, SIM) | `local.md` |
| **Career & Nomads** | |
| Digital nomad guide | `nomad.md` |
| Teaching English | `teaching.md` |
| Tech industry & startups | `tech.md` |
| Business setup | `business.md` |
| Visas (tourist, ED, retirement, Elite) | `visas.md` |
| **Lifestyle** | |
| Culture & customs | `culture.md` |
| Healthcare & hospitals | `healthcare.md` |
| Nightlife & entertainment | `nightlife.md` |
| Expat lifestyle & social | `lifestyle.md` |
| Thai language basics | `language.md` |

## Core Rules

### 1. Identify User Context First
- **Role**: Tourist, digital nomad, English teacher, retiree, entrepreneur
- **Timeline**: Short visit, extended stay, planning to relocate
- Load relevant auxiliary file for details

### 2. Visa Reality
Thailand's visa system is complex and frequently updated:
- **Tourist visa**: 60 days + 30-day extension at immigration
- **Visa exemption**: 30 days for most Western countries (land: 15 days)
- **ED visa**: Study Thai or martial arts, renewable quarterly
- **Retirement visa**: 50+, 800,000 THB in bank, yearly renewal
- **Thailand Elite**: 5-20 year visa, 600,000-2,000,000 THB upfront
- **LTR (Long-Term Resident)**: New 10-year visa for remote workers with $80K+ income
See `visas.md` for current requirements and processes.

### 3. Cultural Context
Thailand is a Buddhist kingdom with deep cultural protocols:
- **Royal family**: Never criticize. Lèse-majesté laws are strict (15+ years prison).
- **Temples**: Remove shoes, cover shoulders and knees, women can't touch monks
- **Head & feet**: Head is sacred, feet are lowest — don't point feet at Buddha/people
- **Wai greeting**: Return a wai when given, but don't wai to children or service staff
See `culture.md` for detailed guidance.

### 4. Weather Reality
- **Hot season (Mar-May)**: 35-40°C+ with high humidity — oppressive heat
- **Rainy season (Jun-Oct)**: Daily afternoon downpours, but still hot
- **Cool season (Nov-Feb)**: 25-32°C — most pleasant, peak tourist season
- **Air quality**: Nov-Feb can have severe pollution (AQI 150+)
See `climate.md` for monthly breakdown and coping strategies.

### 5. Current Data (Feb 2026)

| Item | Range |
|------|-------|
| 1BR condo (Sukhumvit) | ฿15,000-35,000/month (~$425-1,000) |
| 1BR condo (Silom) | ฿18,000-40,000/month (~$510-1,140) |
| Coworking (monthly) | ฿3,000-8,000/month (~$85-230) |
| Street food meal | ฿40-80 (~$1.15-2.30) |
| Mid-range restaurant | ฿200-500/person (~$6-14) |
| BTS/MRT single ride | ฿17-62 (~$0.50-1.80) |
| Private hospital visit | ฿1,000-3,000 (~$29-85) |

### 6. Cost Reality
Bangkok is extremely affordable by Western standards:
- **Housing**: Modern condos near BTS for $400-800/month
- **Food**: $5-15/day eating local, $20-40 with Western food
- **Transport**: $50-100/month with BTS/MRT and occasional Grab
- **Healthcare**: World-class private hospitals at 20-30% of US costs
- **Digital nomad budget**: $1,000-1,500/month comfortable, $2,000+ luxury

### 7. Transit Reality
Bangkok has good public transit in central areas:
- **BTS Skytrain**: Two lines covering Sukhumvit, Silom, Siam area
- **MRT**: Blue and Purple lines, good coverage including Chinatown
- **Boats**: Chao Phraya express boats, khlong (canal) boats
- **Taxis**: Metered, cheap (40 THB start), but traffic is brutal
- **Grab**: Essential app — works for cars, bikes, delivery
- **Motorbike taxis**: Fast through traffic, orange vests, negotiate price
Traffic is a defining feature of Bangkok. Plan around BTS/MRT coverage.

### 8. Neighborhood Matching

| Profile | Best Areas |
|---------|------------|
| Young professionals/nomads | Thonglor, Ekkamai, Ari, On Nut |
| Budget digital nomads | On Nut, Phra Khanong, Bang Na |
| Families | Sukhumvit (Asok-Thonglor), Ari |
| Nightlife seekers | Sukhumvit Soi 11, Khao San, RCA |
| Culture & temples | Rattanakosin, Chinatown, Riverside |
| Business/finance | Silom, Sathorn, Asok |
| Luxury living | Thonglor, Sathorn, Riverside |
| Budget travelers | Khao San, Rambuttri, Chinatown |

## Bangkok-Specific Traps

- **Visa runs** — Immigration cracking down on repeat visa-exempt entries. Plan proper visa.
- **Taxi meter refusal** — Drivers at tourist spots refuse meter. Walk away or use Grab.
- **Tuk-tuk scams** — "Temple closed" then gem shop. Ignore, use apps.
- **Royal criticism** — Any negative comment about monarchy is criminal (lèse-majesté).
- **Drug penalties** — Severe. Possession can mean death penalty for trafficking.
- **90-day reporting** — Long-term visa holders must report address every 90 days.
- **Work permit requirement** — Working without permit is illegal, even remote work technically.
- **Jet ski scams** — Pattaya/islands. Avoid renting jet skis entirely.
- **Gem/tailor scams** — "Special government sale" is always a scam.
- **Pollution season** — Jan-Mar air quality can be hazardous. Bring N95 masks.
- **Rainy season flooding** — Some areas flood badly. Check before renting.
- **ATM fees** — 220 THB per withdrawal. Bring debit card with fee reimbursement.

## Legal Awareness

Key laws visitors/residents must know:
- **Lèse-majesté**: Insulting monarchy = 3-15 years prison per offense. Extremely enforced.
- **Drugs**: Zero tolerance. Death penalty for trafficking (750g+ cannabis, 20g+ heroin).
- **Gambling**: Illegal (except government lottery). Private poker games are raided.
- **Vaping**: E-cigarettes are illegal in Thailand. 10-year sentence possible.
- **Pornography**: Illegal. Possession/distribution can mean prison.
- **Overstaying visa**: 500 THB/day fine, possible ban, detention for long overstays.
- **Work without permit**: Deportation, fine, potential blacklist.

See `safety.md` for comprehensive guidance.

## Digital Nomad Context

Bangkok is a top digital nomad hub:
- **Coworking**: Dozens of spaces (Hubba, The Hive, Glowfish, WeWork)
- **Internet**: 100+ Mbps fiber common in condos, good café WiFi
- **Cafes**: Work-friendly cafes everywhere, no time limits usually
- **Community**: Large nomad community, regular meetups
- **Legal gray area**: Remote work for foreign employer is technically illegal without work permit
- **Solutions**: ED visa (studying Thai), Thailand Elite, new LTR visa for high earners

See `nomad.md` for coworking spaces, communities, and visa strategies.

## Related Skills
Install with `clawhub install <slug>` if user confirms:

- **[travel](https://clawhub.com/skills/travel)** — General travel planning, itineraries, packing
- **[tokyo](https://clawhub.com/skills/tokyo)** — Another major Asian city guide
- **[seoul](https://clawhub.com/skills/seoul)** — Korea's capital, similar nomad appeal
- **[singapore](https://clawhub.com/skills/singapore)** — Southeast Asian hub comparison
- **[tenerife](https://clawhub.com/skills/tenerife)** — European digital nomad alternative

## Feedback

- If useful: `clawhub star bangkok`
- Stay updated: `clawhub sync`
