# Bali Itineraries (3, 5, and 10 Days)

> Last updated: March 2026

## Assumptions

- Arrival/departure via DPS airport.
- One base switch maximum for most travelers.
- Traffic and weather can remove 20-35% of theoretical plans.

## 3-Day First Timer (No Base Change)

### Day 1: South Coast Landing
- Settle in Seminyak/Canggu/Jimbaran depending on vibe.
- Light beach sunset and early dinner.
- No deep inland transfer on arrival day.

### Day 2: Ubud Culture Day
- Early departure to Ubud.
- Rice terrace + temple + central Ubud walk.
- Return before late-night traffic wave.

### Day 3: Uluwatu Sunset Arc
- Relaxed morning.
- Uluwatu Temple around golden hour.
- Kecak show + seafood in Jimbaran.

## 5-Day Balanced Plan

| Day | Focus | Base |
|-----|-------|------|
| 1 | Arrival + local beach reset | South coast |
| 2 | Ubud temples/terraces | South coast |
| 3 | Free day: surf, wellness, or beach clubs | South coast |
| 4 | Uluwatu cliffs + sunset | South coast |
| 5 | Sanur sunrise or shopping/spa before departure | South coast |

Optional replacement for Day 3 or 5:
- Nusa Penida day trip (weather-dependent, long day)

## 10-Day Two-Base Plan

### Base A (Days 1-5): Canggu/Seminyak or Sanur
- Recovery + coast days.
- Uluwatu and one deep-south exploration day.
- One offshore trip if sea conditions are good.

### Base B (Days 6-10): Ubud
- Rice terraces, temples, artisan villages.
- One mountain day (Batur/Kintamani).
- Slower pace and wellness blocks.

## Family Plan (5 Days)

- Prioritize Sanur or Nusa Dua base.
- Keep transfer windows short.
- Use one park day (Waterbom/Bali Safari) and one culture-light day.
- Avoid aggressive island-hopping with younger kids.

## Remote Worker + Leisure (7 Days)

| Day Type | Mix |
|----------|-----|
| 4 weekdays | Work mornings + local afternoon activity |
| 2 weekend days | One full adventure day + one recovery day |
| 1 flex day | Buffer for weather, meetings, or transport disruption |

## Wet Season Variant

- Replace long outdoor slots with cafe, spa, or museum alternatives.
- Start adventure activities early; storms often intensify later.
- Keep one contingency day unscheduled.

## Pacing Rules

1. Two major activities per day is usually the limit.
2. Inland + south-cliff in same day is often unrealistic.
3. Keep at least one low-energy day every 3-4 days.
4. Time-box Instagram stops; photo queues can consume hours.

## Departure-Day Rule

- For international flights, leave buffer for traffic + airport queueing.
- Avoid long-distance inland plans on departure day.
