# Bali Research Sources (2025-2026)

> Last reviewed: March 2026

This file tracks key online sources used to build the Bali skill. Re-check critical legal and price items before final user recommendations.

## Government and Official Portals

| Topic | Source |
|------|--------|
| Indonesia immigration (main) | https://www.imigrasi.go.id/ |
| eVisa / visa selection | https://evisa.imigrasi.go.id/web/visa-selection?visaType=B1 |
| Molina immigration portal | https://molina.imigrasi.go.id/ |
| Indonesia arrival card portal | https://allindonesia.imigrasi.go.id/ |
| Customs e-CD | https://ecd.beacukai.go.id/ |
| Bali tourist levy (Love Bali) | https://lovebali.baliprov.go.id/ |
| Bali Provincial Government | https://www.baliprov.go.id/ |
| Bali tourism office | https://disparda.baliprov.go.id/ |
| Bali statistics (BPS) | https://bali.bps.go.id/en |
| Indonesia statistics (BPS) | https://www.bps.go.id/en |
| BMKG weather agency | https://www.bmkg.go.id/ |
| Volcano monitoring (MAGMA) | https://magma.esdm.go.id/ |
| Bank Indonesia exchange info | https://www.bi.go.id/en/statistik/informasi-kurs/transaksi-bi/default.aspx |
| Ngurah Rai airport (DPS) official | https://baliairport.com/ |

## Security and Travel Advisories

| Topic | Source |
|------|--------|
| US travel advisory (Indonesia) | https://travel.state.gov/content/travel/en/traveladvisories/traveladvisories/indonesia-travel-advisory.html |
| Australia Smartraveller (Indonesia) | https://www.smartraveller.gov.au/destinations/asia/indonesia |
| UK FCDO advice (Indonesia) | https://www.gov.uk/foreign-travel-advice/indonesia |

## Costs, Market, and Practical Benchmarks

| Topic | Source |
|------|--------|
| Cost of living (Denpasar) | https://www.numbeo.com/cost-of-living/in/Denpasar |
| Climate table (Denpasar) | https://weather-and-climate.com/average-monthly-Rainfall-Temperature-Sunshine,Denpasar,Indonesia |
| Ecosystem benchmark (Denpasar startup) | https://www.startupblink.com/startup-ecosystem/denpasar-id |

## Tax and Business References

| Topic | Source |
|------|--------|
| Personal income tax (Indonesia) | https://taxsummaries.pwc.com/indonesia/individual/taxes-on-personal-income |
| Corporate tax (Indonesia) | https://taxsummaries.pwc.com/indonesia/corporate/taxes-on-corporate-income |
| VAT and other taxes (Indonesia) | https://taxsummaries.pwc.com/indonesia/corporate/other-taxes |
| OSS licensing portal | https://oss.go.id/ |

## Transport and Mobility Services

| Topic | Source |
|------|--------|
| Gojek Indonesia | https://www.gojek.com/id-id/ |
| Grab Indonesia | https://www.grab.com/id/ |
| Bluebird taxi | https://www.bluebirdgroup.com/ |
| Pelni ferry operator | https://www.pelni.co.id/ |

## Healthcare and Education References

| Topic | Source |
|------|--------|
| Siloam Hospitals | https://www.siloamhospitals.com/ |
| BIMC Hospitals Bali | https://bimcbali.com/ |
| Bali Island School | https://www.baliislandschool.com/ |
| Canggu Community School | https://www.canggucommunityschool.com/ |
| Green School Bali | https://www.greenschool.org/bali |

## Community and Work Infrastructure

| Topic | Source |
|------|--------|
| Outpost coworking | https://outpost.id/ |
| BWork Bali coworking | https://www.bworkbali.com/ |

## Data Freshness Rules

1. Visa, immigration, and levy data: re-check before every final recommendation.
2. Prices: present as ranges and include month/year context.
3. Safety/legal: prioritize government advisory pages over social media/forum claims.
4. Business and tax setup: recommend professional local legal/tax validation before action.
