# Bali Business Setup and Tax Context 2026

> Last updated: March 2026 | This is operational guidance, not legal advice.

## Business Reality

Foreigners can operate in Indonesia through valid legal structures, but sector eligibility, licensing, and immigration compliance must align with actual activity.

## Core Decisions

| Decision | Why It Matters |
|----------|----------------|
| Legal entity route | Determines ownership, licensing, and risk |
| Activity classification | Controls permits and compliance scope |
| Visa and work authorization | Must match day-to-day operations |
| Tax setup | Prevents downstream penalties |

## Tax Snapshot (Indonesia)

| Tax Item | Reference Direction |
|----------|---------------------|
| Corporate income tax | 22% standard rate |
| VAT | 11% standard (with ability to move in legal range) |
| Personal income tax | Progressive up to 35% |

## Founder Compliance Baseline

1. Define exact commercial activities first.
2. Confirm eligibility and licensing route with qualified local advisors.
3. Separate personal and business transactions early.
4. Keep bookkeeping and tax submissions structured from month one.

## Frequent Errors

- Running commercial activity on tourism assumptions.
- Copying another founder's entity model without sector check.
- Delaying tax setup until after revenue starts.
- Signing leases or payroll obligations before legal route is clear.

## Practical Recommendation

For foreign founders, use a staged approach:
- Stage 1: validate model with compliant temporary structure.
- Stage 2: formalize entity and permits once product-market signal exists.
