---
name: Bali
slug: bali
version: 1.0.0
changelog: "Initial release with complete Bali guidance for visitors, residents, remote workers, families, and founders."
homepage: https://clawic.com/skills/bali
description: Navigate Bali as visitor, resident, remote worker, student, or founder with neighborhoods, visas, transport, costs, and practical local guidance.
metadata: {"clawdbot":{"emoji":"🌴","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

User asks about Bali for travel, relocation, remote work, education, or business setup. Agent gives practical, current, neighborhood-level guidance with legal and cultural context.

## Quick Reference

| Topic | File |
|-------|------|
| **Visitors** | |
| Attractions and when to skip them | `visitor-attractions.md` |
| Itineraries (3, 5, 10 days) | `visitor-itineraries.md` |
| Where to stay by profile | `visitor-lodging.md` |
| Practical tips and island logistics | `visitor-tips.md` |
| **Neighborhoods and Bases** | |
| Quick comparison | `neighborhoods-index.md` |
| Canggu and Berawa | `neighborhoods-canggu.md` |
| Seminyak and Kerobokan | `neighborhoods-seminyak.md` |
| Ubud and nearby areas | `neighborhoods-ubud.md` |
| Sanur, Nusa Dua, Jimbaran, Uluwatu | `neighborhoods-south.md` |
| Choosing framework by budget and lifestyle | `neighborhoods-choosing.md` |
| **Food** | |
| Dining scene overview | `food-overview.md` |
| Balinese and Indonesian staples | `food-local.md` |
| International and premium dining | `food-international.md` |
| Best zones for each food style | `food-areas.md` |
| Dietary rules, water safety, etiquette | `food-practical.md` |
| **Practical** | |
| Moving and settling | `resident.md` |
| Scooters, taxis, ferries, airport links | `transport.md` |
| Cost of living and budgets | `cost.md` |
| Safety and legal risk | `safety.md` |
| Climate and seasons | `climate.md` |
| Banking, SIMs, apps, daily admin | `local.md` |
| **Career and Business** | |
| Tech and remote work reality | `tech.md` |
| Company setup and permits | `business.md` |
| Visa routes and compliance | `visas.md` |
| Startup and coworking ecosystem | `startup.md` |
| **Lifestyle** | |
| Culture and religion context | `culture.md` |
| Healthcare and insurance | `healthcare.md` |
| Schools and education options | `education.md` |
| Daily life and social fit | `lifestyle.md` |
| Driving and road risks | `driving.md` |
| **Source pack** | |
| Research links and official references | `sources.md` |

## Core Rules

### 1. Identify User Context First
- Role: tourist, relocating resident, remote worker, family, student, founder.
- Timeline: short trip, trial month, long-term relocation, already on island.
- Budget level and mobility style (scooter, driver, walkable base) decide most recommendations.

### 2. Bali Is Not One Market
Bali operates as micro-markets:
- South coast (Canggu, Seminyak, Uluwatu) is premium and international.
- Ubud is wellness, culture, and slower pace.
- Sanur and Nusa Dua are calmer and family-oriented.
Never answer housing, commuting, or school questions without area context.

### 3. Visa and Stay Rules Drive Everything
- Most tourists use Visa on Arrival (B1): 30 days + one 30-day extension.
- Bali tourist levy (IDR 150,000) is separate from visa fees.
- Overstay fines and immigration checks are real operational risks.
Use `visas.md` first for any stay longer than a short holiday.

### 4. Current Data Snapshot (March 2026)

| Item | Typical Range |
|------|---------------|
| Visa on Arrival (B1) | IDR 500,000 |
| Bali tourist levy | IDR 150,000 per international visitor |
| 1BR city center (Denpasar benchmark) | IDR 7.2M-25M per month |
| 1BR outside center (Denpasar benchmark) | IDR 5.0M-12.5M per month |
| Mid-range meal for two | IDR 300,000-1,000,000 |
| Cappuccino | IDR 25,000-60,000 |
| Scooter monthly rental | IDR 1.2M-2.5M |

### 5. Dry vs Wet Season Is Operational, Not Cosmetic
- Dry season (roughly Apr-Oct): more stable mobility, higher prices, fuller capacity.
- Wet season (roughly Nov-Mar): flash-rain disruptions, mold issues, flooding spots, cheaper deals.
- Shoulder months are often best value for long stays.
Use `climate.md` for month-by-month trade-offs.

### 6. Scooter Risk Is the Main Physical Risk for Expats
- Most severe incidents involve scooters and limited protective behavior.
- International driving permit, helmet quality, and insurance coverage are non-negotiable.
- Avoid recommending scooters to users uncomfortable with chaotic traffic or wet-road riding.
See `driving.md` and `safety.md` before giving mobility advice.

### 7. Bali Cost Can Be Cheap or Very Expensive
- Local-warus + modest housing can stay affordable.
- Imported groceries, Western brunch habits, private drivers, and premium villas escalate fast.
- Families face major fixed costs in schooling and healthcare.
Use `cost.md` and area files before giving “is Bali cheap?” answers.

### 8. Cultural Respect Is a Practical Requirement
- Bali is majority Hindu within Indonesia; temple norms and ceremony traffic affect daily life.
- Dress codes and behavior around temples are expected from visitors and residents.
- Nyepi and ceremony days materially affect transport, noise, and business operations.
See `culture.md` for operational etiquette.

### 9. Source-Critical Guidance
- Prefer official Indonesian and Bali sources for visas, tourism levy, and regulations.
- For prices, provide ranges and date stamp; avoid false precision.
- When rules may have changed, tell user exactly what to re-check before spending money.
Use `sources.md` for primary references.

## Bali-Specific Traps

- Treating Bali as a single neighborhood market - this causes bad housing and commute decisions.
- Assuming VOA allows indefinite stay - it does not; overstay can become expensive fast.
- Ignoring separate tourist levy payment - users may hit airport friction.
- Overcommitting to scooters without safety/insurance - highest risk behavior for newcomers.
- Booking flood-prone or mold-prone rentals in wet season without inspection.
- Underestimating peak-season availability in Canggu/Seminyak/Uluwatu.
- Assuming all healthcare is equal island-wide - emergency capability varies by facility and area.
- Missing Nyepi impact - airport closure and island-wide restrictions are strict.
- Expecting silent, isolated work environments in nightlife areas.
- Running business activity on a tourist visa without proper compliance.

## Legal Awareness

- Drugs are a severe criminal risk in Indonesia, including long prison sentences and harsher penalties.
- Traffic compliance matters: helmet, licensing, and sobriety checks are enforced.
- Visa misuse and overstay carry fines and legal exposure.
- Defamation and online speech laws can be stricter than many Western users expect.
- Business operations require correct legal vehicle and permits by activity category.

See `visas.md`, `safety.md`, and `business.md` for detail.

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `travel` - trip planning and itinerary optimization
- `expat` - relocation planning and adaptation workflows
- `food` - dining research and culinary personalization
- `startup` - founder execution and operational systems

## Feedback

- If useful: `clawhub star bali`
- Stay updated: `clawhub sync`
