---
name: baidu-search
description: 使用百度 AI 搜索 API 进行 Web 搜索。优先使用 API 模式，配额不足时自动切换到浏览器模式。支持中文搜索、新闻搜索等功能。
metadata: { "openclaw": { "emoji": "🔍︎", "requires": { "bins": ["python3"], "env": ["BAIDU_API_KEY"] }, "primaryEnv": "BAIDU_API_KEY" } }
---

# 百度搜索

使用百度 AI 搜索 API 或浏览器进行 Web 搜索。支持两种模式：
1. **API 模式** - 使用百度千帆 AI 搜索 API（优先）
2. **浏览器模式** - 使用浏览器打开百度搜索页面

## 配置

### 环境变量
使用技能前需要设置百度千帆 API Key：
```bash
# Linux/Mac
export BAIDU_API_KEY="your-api-key"

# Windows
$env:BAIDU_API_KEY="your-api-key"
```

API Key 获取地址：https://console.bce.baidu.com/qianfan/ais/console/apiKey

### API 端点
- 端点：`https://qianfan.baidubce.com/v2/ai_search/web_search`
- 模型：百度千帆 AI 搜索

## 使用流程

1. **首先尝试 API 模式**（需要设置 BAIDU_API_KEY 环境变量）
2. **如果 API 失败（配额不足等）** → 切换到浏览器模式

## API 模式

### Python 脚本调用

```bash
# 设置环境变量后执行
python3 skills/baidu-search/scripts/search.py '{"query":"今日新闻"}'
```

### 请求参数

| 参数 | 类型 | 必填 | 默认值 | 说明 |
|------|------|------|--------|------|
| query | string | 是 | - | 搜索关键词 |
| edition | string | 否 | standard | standard(完整版) 或 lite(轻量版) |
| resource_type_filter | array | 否 | web:20 | 资源类型过滤 |
| search_filter | object | 否 | - | 高级过滤条件 |
| block_websites | array | 否 | - | 排除的网站列表 |
| search_recency_filter | string | 否 | year | 时间过滤：week, month, semiyear, year |
| safe_search | bool | 否 | false | 严格内容过滤 |

### 使用 exec 工具调用

```powershell
# 先设置环境变量
$env:BAIDU_API_KEY = "your-api-key"

# 然后调用 API
$body = @{
    messages = @(
        @{content = "今日新闻"; role = "user"}
    )
    edition = "standard"
    search_source = "baidu_search_v2"
    resource_type_filter = @(
        @{type = "web"; top_k = 10}
    )
    search_recency_filter = "week"
    safe_search = $false
} | ConvertTo-Json -Depth 3

Invoke-RestMethod -Uri "https://qianfan.baidubce.com/v2/ai_search/web_search" `
    -Method POST `
    -Headers @{
        "Authorization" = "Bearer $env:BAIDU_API_KEY"
        "X-Appbuilder-From" = "openclaw"
        "Content-Type" = "application/json"
    } `
    -Body $body
```

### SearchFilter 高级过滤

```json
{
  "query": "最新新闻",
  "search_recency_filter": "week",
  "search_filter": {
    "match": {
      "site": ["news.baidu.com"]
    }
  }
}
```

### 资源类型过滤

```json
{
  "query": "旅游景点",
  "resource_type_filter": [
    {"type": "web", "top_k": 20},
    {"type": "video", "top_k": 5}
  ]
}
```

## 浏览器模式

### 搜索 URL 格式
- 网页搜索：`https://www.baidu.com/s?wd=关键词`
- 新闻搜索：`https://www.baidu.com/s?wd=关键词&tn=news`

### 操作步骤

1. 使用 `browser` 工具的 `open` action 打开搜索 URL
2. 使用 `browser` 工具的 `snapshot` action 获取搜索结果

## 注意事项

1. **API 配额**：每用户有一定免费配额，用完需付费
2. **环境变量**：必须设置 BAIDU_API_KEY 才能使用 API 模式
3. **自动降级**：API 调用失败时自动切换到浏览器模式
4. **中文支持**：两种模式都完美支持中文搜索
