---
name: baidu-map
description: 使用百度地图Web服务API进行地点搜索、天气查询、路线规划和地理编码。
homepage: https://lbsyun.baidu.com/
metadata: {"clawdbot":{"emoji":"🗺️","slug":"baidu-map","requires":{"bins":["curl"]},"primaryEnv":"BAIDU_MAP_AK"}}
---

# 百度地图 (Baidu Map)

本技能使用百度地图 Web 服务 API 提供丰富的地理位置服务。

**重要：** 使用本技能前，你必须在百度地图开放平台申请一个应用，并获取 Access Key (AK)，然后将其设置为环境变量 `BAIDU_MAP_AK`。

```bash
export BAIDU_MAP_AK="你的百度地图Access Key"
```

Clawdbot 会自动读取这个环境变量来调用 API。

## 何时使用 (触发条件)

当用户提出以下类型的请求时，应优先使用本技能：
- "帮我查一下[城市]的天气"
- "搜索[地点]附近的[东西]"
- "查找[关键词]的位置"
- "从[A]到[B]怎么走？"
- "查询[地址]的经纬度"
- "这个坐标[经度,纬度]是哪里？"
- "百度地图[地点]"

## 核心功能与用法

### 1. 地点搜索 (POI检索)

用于根据关键字在指定区域搜索地点信息。

```bash
# 将 [关键词] 替换为用户提供的内容
# region参数可以是城市名或区域名
curl "https://api.map.baidu.com/place/v2/search?query=[关键词]&region=全国&output=json&ak=$BAIDU_MAP_AK"

# 或者指定具体城市
curl "https://api.map.baidu.com/place/v2/search?query=[关键词]&region=广州&output=json&ak=$BAIDU_MAP_AK"
```

### 2. 城市内地点搜索

用于在特定城市内搜索地点，结果更精确。

```bash
# 将 [关键词] 和 [城市] 替换为实际内容
curl "https://api.map.baidu.com/place/v2/search?query=[关键词]&region=[城市]&output=json&ak=$BAIDU_MAP_AK"
```

### 3. 周边搜索 (圆形区域内搜索)

用于在指定坐标点周围搜索特定类型的地点。

```bash
# 将 [经度,纬度] 替换为实际坐标，radius为搜索半径(米)
curl "https://api.map.baidu.com/place/v2/search?query=花店&location=[纬度],[经度]&radius=1000&output=json&ak=$BAIDU_MAP_AK"
```

### 4. 地理编码 (地址 → 坐标)

将结构化的地址信息转换为经纬度坐标。

```bash
# 将 [地址] 替换为用户提供的地址
curl "https://api.map.baidu.com/geocoding/v3/?address=[地址]&output=json&ak=$BAIDU_MAP_AK"
```

### 5. 逆地理编码 (坐标 → 地址)

将经纬度坐标转换为结构化的地址信息。

```bash
# 将 [经度,纬度] 替换为实际坐标
curl "https://api.map.baidu.com/reverse_geocoding/v3/?coordtype=wgs84ll&location=[纬度],[经度]&output=json&ak=$BAIDU_MAP_AK"
```

### 6. 驾车路线规划

用于规划两个地点之间的驾车路线。

```bash
# 将 [起点] 和 [终点] 替换为实际地址或坐标
# 起终点可以用地址表示，也可以用经纬度表示
curl "https://api.map.baidu.com/direction/v2/driving?origin=[起点]&destination=[终点]&output=json&ak=$BAIDU_MAP_AK"

# 使用经纬度坐标的示例
curl "https://api.map.baidu.com/direction/v2/driving?origin=39.90923,116.397428&destination=31.230416,121.473701&output=json&ak=$BAIDU_MAP_AK"
```

### 7. 步行路线规划

用于规划两个地点之间的步行路线。

```bash
# 将 [起点] 和 [终点] 替换为实际地址或坐标
curl "https://api.map.baidu.com/direction/v2/walking?origin=[起点]&destination=[终点]&output=json&ak=$BAIDU_MAP_AK"
```

### 8. 公交路线规划

用于规划两个地点之间的公交路线。

```bash
# 将 [起点] 和 [终点] 替换为实际地址或坐标
curl "https://api.map.baidu.com/direction/v2/transit?origin=[起点]&destination=[终点]&output=json&ak=$BAIDU_MAP_AK"
```

### 9. 行政区划边界查询

用于查询行政区域的边界坐标点集合。

```bash
# 将 [行政区名称] 替换为实际的省市区名称
curl "https://api.map.baidu.com/district/v1/getdistrict?qt=dis&level=city&names=[行政区名称]&ak=$BAIDU_MAP_AK"
```

### 10. IP定位

根据IP地址获取大致的地理位置信息。

```bash
# 将 [IP地址] 替换为实际IP，若不提供则使用当前客户端IP
curl "https://api.map.baidu.com/location/ip?ip=[IP地址]&ak=$BAIDU_MAP_AK"
```

## 使用技巧

1. **搜索半径**: 在周边搜索时，可以根据需要调整radius参数，默认1000米
2. **坐标系统**: 百度地图主要使用BD09坐标系，注意与其他坐标系的转换
3. **结果数量**: 默认返回10个结果，可通过page_size参数调整（最大50）
4. **分页查询**: 当结果较多时，可通过page_num参数获取后续页面结果

## 错误处理

如果API返回错误，通常是以下原因之一：
- AK无效或未正确设置
- 请求参数格式错误
- API调用次数超限
- 网络连接问题