---
name: baidu-hot-cn
description: "百度热榜监控 | Baidu Hot Topics Monitor. 获取百度热搜榜、搜索趋势、关键词热度 | Get Baidu trending searches, trends, keyword popularity. 触发词：百度、热搜、baidu."
metadata:
  openclaw:
    emoji: "🔍"
    category: "search"
    tags: ["baidu", "hot", "trending", "china", "search-engine"]
    requires:
      bins: ["python3"]
---

# 百度热榜监控

百度搜索热搜榜实时监控，支持搜索趋势分析、关键词热度追踪。

## 功能

### 热榜获取
- **实时热搜** - 获取当前百度热搜榜 Top 30
- **搜索指数** - 显示每条热搜的搜索量
- **分类标签** - 娱乐、科技、社会、体育等

### 趋势分析
- **上升最快** - 搜索量上升最快的关键词
- **地域分布** - 不同地区的搜索热度
- **时间趋势** - 24小时搜索趋势

### 关键词监控
- **关键词追踪** - 监控特定关键词热度
- **竞品监控** - 监控竞品相关搜索
- **行业趋势** - 行业关键词热度变化

## 使用方式

### 获取热搜榜

```
获取百度热搜榜前 10
```

返回：
```json
[
  {"rank": 1, "title": "春节档电影票房", "search_count": 1234567, "category": "娱乐"},
  {"rank": 2, "title": "AI技术突破", "search_count": 987654, "category": "科技"},
  {"rank": 3, "title": "春运最新消息", "search_count": 876543, "category": "社会"}
]
```

### 关键词搜索

```
查询 "AI" 在百度的搜索热度
```

### 趋势分析

```
分析百度热搜今天的科技类话题
```

## 数据来源

- 百度热搜榜 API（如可用）
- 模拟数据（API 不可用时）
- 历史数据对比

## 与其他 Skill 配合

- `weibo-hot-cn` - 微博热搜对比
- `zhihu-hot-cn` - 知乎热榜对比
- `toutiao-hot-news-cn` - 头条热榜对比

## 输出格式

### 热榜列表
```
🔍 百度热搜榜 Top 10

1. [娱乐] 春节档电影票房 - 123.5万搜索
2. [科技] AI技术突破 - 98.8万搜索
3. [社会] 春运最新消息 - 87.7万搜索
...
```

### 趋势报告
```
📊 百度热搜趋势分析

今日热点分类：
- 娱乐：35%
- 科技：28%
- 社会：22%
- 体育：15%

上升最快：AI技术突破 (+250%)
```

---

*百度热榜，洞察搜索趋势* 🔍
