#!/bin/bash
set -e

# Clear any local state
echo "Starting Backboard OpenClaw Skill Backend..."

# Validate required environment variable
if [ -z "$BACKBOARD_API_KEY" ]; then
    echo "ERROR: BACKBOARD_API_KEY environment variable is not set"
    echo "Please set it with: export BACKBOARD_API_KEY=your_api_key"
    exit 1
fi

echo "BACKBOARD_API_KEY is set"

# Change to script directory
cd "$(dirname "$0")"

# Install dependencies if needed
if [ ! -d ".venv" ]; then
    echo "Creating virtual environment..."
    uv venv
fi

echo "Installing dependencies..."
uv pip install -e .

# Run the Flask app
echo "Starting Flask server on port 5100..."
export FLASK_APP="${FLASK_APP:-api.app}"
export FLASK_ENV="${FLASK_ENV:-development}"
uv run flask run --host=0.0.0.0 --port=5100
