---
name: backboard
description: Integrate Backboard.io for assistants, threads, memories, and document RAG via a local backend on http://localhost:5100.
---

## Tools

This skill connects to a local Flask backend that wraps the Backboard SDK. The backend must be running on `http://localhost:5100`.

### backboard_create_assistant

Create a new Backboard assistant with a name and system prompt.

**Parameters:**
- `name` (string, required): Name of the assistant
- `system_prompt` (string, required): System instructions for the assistant

**Example:**
```json
{
  "name": "Support Bot",
  "system_prompt": "You are a helpful customer support assistant."
}
```

### backboard_list_assistants

List all available Backboard assistants.

**Parameters:** None

### backboard_get_assistant

Get details of a specific assistant.

**Parameters:**
- `assistant_id` (string, required): ID of the assistant

### backboard_delete_assistant

Delete an assistant.

**Parameters:**
- `assistant_id` (string, required): ID of the assistant to delete

### backboard_create_thread

Create a new conversation thread for an assistant.

**Parameters:**
- `assistant_id` (string, required): ID of the assistant to create thread for

### backboard_list_threads

List all conversation threads, optionally filtered by assistant.

**Parameters:**
- `assistant_id` (string, optional): Filter threads by assistant ID

### backboard_get_thread

Get a thread with its message history.

**Parameters:**
- `thread_id` (string, required): ID of the thread

### backboard_send_message

Send a message to a thread and get a response.

**Parameters:**
- `thread_id` (string, required): ID of the thread
- `content` (string, required): Message content
- `memory` (string, optional): Memory mode - "Auto", "Readonly", or "off" (default: "Auto")

### backboard_add_memory

Store a memory for an assistant that persists across conversations.

**Parameters:**
- `assistant_id` (string, required): ID of the assistant
- `content` (string, required): Memory content to store
- `metadata` (object, optional): Additional metadata for the memory

**Example:**
```json
{
  "assistant_id": "asst_123",
  "content": "User prefers Python programming and dark mode interfaces",
  "metadata": {"category": "preferences"}
}
```

### backboard_list_memories

List all memories for an assistant.

**Parameters:**
- `assistant_id` (string, required): ID of the assistant

### backboard_get_memory

Get a specific memory.

**Parameters:**
- `assistant_id` (string, required): ID of the assistant
- `memory_id` (string, required): ID of the memory

### backboard_update_memory

Update an existing memory.

**Parameters:**
- `assistant_id` (string, required): ID of the assistant
- `memory_id` (string, required): ID of the memory
- `content` (string, required): New content for the memory

### backboard_delete_memory

Delete a memory.

**Parameters:**
- `assistant_id` (string, required): ID of the assistant
- `memory_id` (string, required): ID of the memory to delete

### backboard_memory_stats

Get memory statistics for an assistant.

**Parameters:**
- `assistant_id` (string, required): ID of the assistant

### backboard_upload_document

Upload a document to an assistant or thread for RAG (Retrieval-Augmented Generation).

**Parameters:**
- `assistant_id` (string, optional): ID of the assistant (use this OR thread_id)
- `thread_id` (string, optional): ID of the thread (use this OR assistant_id)
- `file_path` (string, required): Path to the document file

**Supported file types:** PDF, DOCX, XLSX, PPTX, TXT, CSV, MD, PY, JS, HTML, CSS, XML, JSON

### backboard_list_documents

List documents for an assistant or thread.

**Parameters:**
- `assistant_id` (string, optional): ID of the assistant
- `thread_id` (string, optional): ID of the thread

### backboard_document_status

Check the processing status of an uploaded document.

**Parameters:**
- `document_id` (string, required): ID of the document

### backboard_delete_document

Delete a document.

**Parameters:**
- `document_id` (string, required): ID of the document to delete

## Instructions

When the user asks about:

### Memory Operations
- "Remember that..." or "Store this..." → Use `backboard_add_memory`
- "What do you remember about..." → Use `backboard_list_memories` or `backboard_get_memory`
- "Forget..." or "Delete memory..." → Use `backboard_delete_memory`
- "Update my preference..." → Use `backboard_update_memory`

### Document Operations
- "Upload this document" or "Index this file" → Use `backboard_upload_document`
- "What documents do I have?" → Use `backboard_list_documents`
- "Is my document ready?" → Use `backboard_document_status`

### Assistant Management
- "Create a new assistant" → Use `backboard_create_assistant`
- "List my assistants" → Use `backboard_list_assistants`
- "Delete assistant" → Use `backboard_delete_assistant`

### Conversation Threading
- "Start a new conversation" → Use `backboard_create_thread`
- "Show conversation history" → Use `backboard_get_thread`
- "Send message to thread" → Use `backboard_send_message`

### General Guidelines
1. Always confirm successful operations with the user
2. When creating assistants, suggest meaningful names and system prompts
3. For document uploads, verify the file type is supported before attempting
4. When using memory, explain what information is being stored
5. Thread IDs and assistant IDs should be stored/tracked for the user's context

## Examples

### Example 1: Store a User Preference
- User: "Remember that I prefer dark mode and Python code examples"
- Action: Call `backboard_add_memory` with content "User prefers dark mode interfaces and Python code examples" and metadata `{"category": "preferences"}`
- Response: "I've stored your preferences. You prefer dark mode and Python code examples."

### Example 2: Create an Assistant
- User: "Create a code review assistant"
- Action: Call `backboard_create_assistant` with name "Code Reviewer" and system_prompt "You are an expert code reviewer. Analyze code for bugs, performance issues, and best practices. Provide constructive feedback."
- Response: "Created your Code Reviewer assistant (ID: asst_xxx). It's ready to review code and provide feedback."

### Example 3: Upload and Query a Document
- User: "Upload my project documentation and then tell me what it covers"
- Action 1: Call `backboard_upload_document` with the file
- Action 2: Wait for processing, check status with `backboard_document_status`
- Action 3: Use `backboard_send_message` with memory="Auto" to query about the document
- Response: "I've uploaded and indexed your documentation. Based on the content, it covers..."

### Example 4: Start a Threaded Conversation
- User: "Start a new conversation with my support assistant"
- Action: Call `backboard_create_thread` with the assistant_id
- Response: "Started a new conversation thread (ID: thread_xxx). You can now send messages to your support assistant."

## Backend Setup

The skill requires a running backend server. To start:

1. Set the `BACKBOARD_API_KEY` environment variable
2. Navigate to the backend directory
3. Run `./start.sh`

The backend will be available at `http://localhost:5100`.

## API Endpoints Reference

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/health` | GET | Health check |
| `/assistants` | GET, POST | List/create assistants |
| `/assistants/{id}` | GET, PATCH, DELETE | Get/update/delete assistant |
| `/assistants/{id}/threads` | GET, POST | List/create threads for assistant |
| `/assistants/{id}/memory` | GET, POST | List/add memories |
| `/assistants/{id}/memory/{mid}` | GET, PATCH, DELETE | Get/update/delete memory |
| `/assistants/{id}/memory/stats` | GET | Memory statistics |
| `/assistants/{id}/documents` | GET, POST | List/upload documents |
| `/threads` | GET | List all threads |
| `/threads/{id}` | GET, DELETE | Get/delete thread |
| `/threads/{id}/messages` | POST | Send message |
| `/threads/{id}/documents` | GET, POST | List/upload thread documents |
| `/documents/{id}/status` | GET | Document processing status |
| `/documents/{id}` | DELETE | Delete document |
