# b3ehive 🐝

[![OpenClaw Skill](https://img.shields.io/badge/OpenClaw-Skill-blue)](https://openclaw.ai)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://opensource.org/licenses/MIT)

> **"Fake it until make it"** — The Feynman Way

## The B3ehive Philosophy

I learned from one of the greatest physicists, **Richard Feynman**, whose nature was cheerful and whose intellect spanned multiple domains. He left behind the renowned **Feynman Technique** — learning by teaching. Inspired by *"Surely You're Joking, Mr. Feynman!"*, I realized that **AI can adopt the Feynman Technique**: building a **swarm of agents** that compete, evaluate, and ultimately deliver the **best result to humanity**.

This best result is still, fundamentally, **a teacher for humanity**.

### Why Three Agents?

Just as Feynman would explain the same concept differently to a freshman, a colleague, and a child — three perspectives yield three implementations. Through **competition**, they reveal blind spots. Through **evaluation**, they teach each other. Through **consensus**, they converge on truth.

**b3ehive** is not just code generation. It is **collective intelligence** mimicking the scientific method: hypothesize, test, debate, conclude.

---

## Quick Start

```bash
# Install
git clone https://github.com/weiyangzen/b3ehive.git ~/.openclaw/skills/b3ehive

# Run
b3ehive "Implement a thread-safe rate limiter"
```

## What Makes b3ehive Different

| Traditional AI | b3ehive |
|---------------|---------|
| Single agent | **3 competing agents** |
| One-shot output | **Iterative refinement** |
| Black box | **Transparent evaluation** |
| "Trust me" | **Prove it with data** |

---

## The Four Phases

1. **Spawn** — Three agents, three philosophies
2. **Evaluate** — Objective criticism, no ego
3. **Score** — Fair self-assessment
4. **Deliver** — The best solution wins

## Documentation

- [SKILL.md](SKILL.md) — Technical specification
- [config.yaml](config.yaml) — Configuration

## License

MIT © Weiyang ([@weiyangzen](https://github.com/weiyangzen))

---

*"What I cannot create, I do not understand."* — Richard Feynman

**b3ehive**: Create three times. Understand completely.

---

## The Name

**b3** = Build × 3  
**hive** = Swarm intelligence

> **Build ×3, evaluate each other, and evolve.**  
> *So called b3ehive.* 🐝
