# Monetization Models & Paywall Design

## Model Selection Matrix

| Model | Best When | Avoid When |
|-------|-----------|------------|
| **Freemium** | Product has natural limits (storage, features) | Core value is one action |
| **Free Trial** | Value compounds over time | Value is instant |
| **Subscription** | Ongoing value delivery | One-time purchase mindset |
| **One-Time** | Complete solution, no maintenance | Costs scale with usage |
| **Ads** | Massive scale, low willingness to pay | Premium positioning |
| **Hybrid** | Multiple user segments | Confusion kills conversion |

## Paywall Placement

### Hard vs Soft Paywall
| Type | Description | Use When |
|------|-------------|----------|
| **Hard** | Block after X uses/time | Strong activation, proven value |
| **Soft** | Limit features, not access | Building habit, viral potential |
| **Metered** | Pay per usage | Variable value per user |

### Placement Rules
1. **After aha moment** — User must feel value before seeing price
2. **At natural limit** — Storage full, exports needed, features unlocked
3. **Not during onboarding** — Never interrupt first session
4. **With clear upgrade path** — Show what they get, not what's blocked

## Pricing Psychology

### Anchoring
- Show annual price as monthly equivalent
- Display "most popular" on target tier
- Use crossed-out "original" prices sparingly

### Price Points
| Segment | Monthly Range | Annual Discount |
|---------|--------------|-----------------|
| Casual consumer | $2-5 | 15-20% |
| Power user | $8-15 | 25-35% |
| Prosumer | $20-50 | 40-50% |

### Red Flags
- Pricing below $5/mo often signals low LTV
- Heavy discounts attract churny users
- Free tier that solves the problem = no upgrades
