# Growth Loops & Acquisition Channels

## Growth Loop Types

### 1. Viral Loop
```
User → Invites friend → Friend converts → Repeat
```
- **K-factor** = Invites sent × Conversion rate
- K > 1 = exponential growth
- Best for: social products, multiplayer, collaboration

### 2. Content Loop
```
Product creates content → Content gets indexed/shared → Discovery → User
```
- Examples: Canva (designs), Notion (templates), TikTok (videos)
- Requires: shareable output, SEO value

### 3. Paid Loop
```
$ spent → Users acquired → Revenue → Reinvest $
```
- Sustainable when: LTV > CAC with margin for reinvestment
- Doesn't compound, but scales linearly

### 4. Data Loop
```
Users → Data → Better product → More users
```
- Examples: Waze (traffic), Spotify (recommendations)
- Defensible moat when it works

## Channel Selection

### Discovery Questions
1. Where does your audience already spend time?
2. What do they search for when they have the problem?
3. Who do they trust for recommendations?
4. Is the problem talked about publicly?

### Channel Matrix
| Channel | CAC Range | Volume | Time to Scale |
|---------|-----------|--------|---------------|
| Organic social | Low | Medium | 6-12 months |
| SEO | Low | High | 12-24 months |
| Paid social | Medium-High | High | 1-3 months |
| Influencers | Variable | Medium | 3-6 months |
| App Store | Medium | Medium | 6-12 months |
| Referral | Low | Low-Medium | 3-6 months |

## First 100 Users Tactics

1. **Launch where they are** — Post in relevant communities (Reddit, Discord, Slack)
2. **Solve one person's problem** — DM people complaining about the problem
3. **Build in public** — Share progress, get early believers
4. **Leverage your network** — Personal asks convert better than ads
5. **Create a waitlist** — Scarcity + anticipation

## Anti-Patterns

- **Premature paid ads** — Before knowing LTV, you'll burn money
- **Feature launches as growth** — Users don't care about features
- **Ignoring organic** — Paid-only doesn't compound
- **Copy competitor channels** — Their economics aren't yours
