# Unit Economics (CAC, LTV, Payback)

## Core Formulas

### Customer Acquisition Cost (CAC)
```
CAC = Total Marketing Spend / New Paying Customers
```
- Include ALL costs: ads, content, tools, salaries
- Segment by channel: CAC(organic), CAC(paid), CAC(referral)

### Lifetime Value (LTV)
```
LTV = ARPU × Average Lifetime (months)
LTV = ARPU / Monthly Churn Rate
```

### Payback Period
```
Payback = CAC / Monthly ARPU
```
- Target: < 6 months for venture-backed
- Target: < 3 months for bootstrapped

### LTV:CAC Ratio
| Ratio | Interpretation |
|-------|----------------|
| < 1:1 | Losing money, fix immediately |
| 1:1 - 2:1 | Unprofitable, optimize |
| 3:1 | Healthy target |
| > 5:1 | Under-investing in growth |

## By-Channel Analysis

### Calculation Template
| Channel | Spend | Customers | CAC | D30 Retention | Est. LTV | LTV:CAC |
|---------|-------|-----------|-----|---------------|----------|---------|
| Facebook | $X | Y | $Z | A% | $B | C:1 |
| Google | ... | ... | ... | ... | ... | ... |

### Warning Signs
- Paid CAC > 2x organic CAC → paid quality problem
- High variance in LTV by channel → segmentation needed
- Payback > 12 months → unsustainable without funding

## Churn Analysis

### Types of Churn
| Type | Formula | Insight |
|------|---------|---------|
| User churn | Lost users / Start users | Volume problem |
| Revenue churn | Lost MRR / Start MRR | Value problem |
| Net revenue churn | (Lost - Expansion) / Start | Growth health |

### Churn Benchmarks
| Category | Good D7 | Good D30 | Good M3 |
|----------|---------|----------|---------|
| Gaming | 30% | 10% | 5% |
| Productivity | 40% | 20% | 12% |
| Social | 50% | 25% | 15% |
| Fitness | 35% | 15% | 8% |
