---
name: B2C Strategy
slug: b2c
version: 1.0.0
description: Build consumer apps with validated demand, sustainable unit economics, and growth loops that compound.
metadata: {"clawdbot":{"emoji":"📱","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## Quick Reference

| Topic | File |
|-------|------|
| Monetization models & paywall design | `monetization.md` |
| Unit economics (CAC, LTV, payback) | `economics.md` |
| Growth loops & acquisition channels | `growth.md` |
| Retention benchmarks by category | `benchmarks.md` |

## Core Framework

### Stage-Aware Priorities
| Stage | Focus | Key Metric |
|-------|-------|------------|
| Pre-PMF | Activation + Retention | D7 retention > 20% |
| Post-PMF | Acquisition + Conversion | CAC payback < 6 months |
| Scaling | LTV optimization + Loops | LTV:CAC > 3:1 |

### The 30-Second Rule
Consumer products win or lose in the first 30 seconds:
1. Is there a hook? (emotional trigger, curiosity, benefit)
2. How many taps to value? (target: ≤3)
3. Is signup deferred until after value shown?

### Critical Metrics
- **Activation**: % reaching "aha moment" in first session
- **Retention**: D1/D7/D30 by acquisition cohort
- **Monetization**: Conversion rate, ARPU, payback period
- **Referral**: Viral coefficient (K-factor), organic vs paid ratio

## Anti-Patterns (Common B2C Mistakes)

1. **Building for power users** — The 80% casual users pay the bills
2. **Generous freemium** — If free tier solves the problem, why upgrade?
3. **Vanity metrics** — MAU without defining "active" hides churn
4. **B2B thinking** — Long onboarding, feature demos, rational appeals
5. **Ignoring emotions** — Status, FOMO, delight drive consumer behavior
6. **Late paywall** — Users habituate to free before seeing upgrade value

## Decision Support

For any B2C decision, apply this framework:
1. **Validate demand first** — Search Reddit/Twitter/forums for complaints about the problem
2. **Design monetization early** — Model matters more than price initially
3. **Define activation moment** — What must happen for user to "get it"?
4. **Plan growth loop** — Paid-only doesn't scale; what compounds?
5. **Set kill metrics** — Below what retention do you pivot?
