# Pipeline Management — B2B

## Key Metrics

| Metric | Formula | Healthy Range |
|--------|---------|---------------|
| Pipeline Coverage | Pipeline / Quota | 3-4x minimum |
| Win Rate | Closed Won / Total Closed | 20-30% typical |
| Average Cycle | Days from first touch to close | Industry dependent |
| ASP | Revenue / Deals Won | Should trend up |
| Slippage | Deals moved past commit date | <20% |

## Weighted Pipeline

```
Deal Value × Probability = Weighted Value

Example:
$100K deal at 30% = $30K weighted
$50K deal at 80% = $40K weighted
```

**Problem:** CRM probabilities are usually wrong. Adjust based on:
- Actual win rate at each stage
- Rep track record
- Deal-specific signals

## Stage Hygiene

| Stage | Must Have |
|-------|-----------|
| Qualified | BANT/MEDDIC basics confirmed |
| Discovery | Pain documented, stakeholders mapped |
| Demo/Eval | Technical validation scheduled |
| Proposal | Budget confirmed, decision process clear |
| Negotiation | Economic buyer engaged, timeline agreed |
| Verbal | Written confirmation, paperwork in motion |

**Deal in wrong stage = bad forecast**

## Red Flags to Monitor

- **Zombie deals:** >2x average cycle, no recent activity
- **Single-threaded:** Only one contact engaged
- **Stalled:** No next step scheduled
- **Champion ghosting:** Main contact unresponsive
- **Scope creep:** Requirements keep expanding without commitment

## Pipeline Reviews

Questions to ask on every deal:
1. When did we last talk to them?
2. What's the next step and date?
3. Have we talked to the economic buyer?
4. What could kill this deal?
5. What has to happen to close by [date]?

## Commit vs. Best Case

| Category | Definition |
|----------|------------|
| **Commit** | 90%+ confident, will close this period |
| **Best Case** | Could close if everything goes right |
| **Pipeline** | Working but won't close this period |
| **Omit** | Remove from forecast entirely |

Forecast accuracy depends on honest categorization.
