# Outreach Best Practices — B2B

## Personalization Tiers

| Tier | Effort | When |
|------|--------|------|
| **1:1** | Deep research, custom message | Strategic accounts, >$50K deals |
| **1:few** | Segment-specific, some personalization | Industry/role clusters |
| **1:many** | Templates with variables | Volume prospecting |

## 3x3 Research Method

3 relevant insights in 3 minutes:
1. Recent company news/press releases
2. Prospect's LinkedIn activity/posts
3. Industry trend affecting them

## Cold Email Structure

```
Subject: [Specific + Curiosity]

[Observation about them — 1 sentence]
[Problem you solve — 1 sentence]
[Social proof or data point — 1 sentence]
[Clear CTA — 1 question]

[Name]
```

**Anti-patterns:**
- "I hope this email finds you well"
- Wall of text about your product
- Multiple CTAs
- Fake personalization ("I noticed you work at...")

## Cold Call Framework

1. **Pattern interrupt** — Different opening than expected
2. **Permission** — "Did I catch you at a bad time?"
3. **Reason** — Why calling specifically them, specifically now
4. **Interest** — Ask about their relevant challenge
5. **CTA** — Book next step, not close the deal

## Follow-up Sequence

| Day | Action | Note |
|-----|--------|------|
| 0 | Initial email | |
| 3 | Follow-up, add new value | |
| 7 | Different angle/channel | LinkedIn, phone |
| 14 | Break-up email | Creates urgency |
| 30 | Nurture sequence | Long-term value |

**Stop if:** They ask to stop. Silence ≠ no (sometimes = busy).

## Subject Line Patterns That Work

- [Mutual connection] suggested I reach out
- Question about [their specific initiative]
- [Their competitor] just did X
- Idea for [their actual goal]
- [Specific metric] at [their company]

**Avoid:** "Quick question", "Following up", "Checking in"
