---
name: B2B
slug: b2b
version: 1.0.0
description: Close enterprise deals with qualification frameworks, prospecting research, pipeline management, and outreach personalization.
metadata: {"clawdbot":{"emoji":"🤝","requires":{"bins":[]},"os":["linux","darwin","win32"]}}
---

## When to Use

Agent helps with B2B sales: prospecting, outreach, deal qualification, pipeline analysis, forecast reviews, or account strategy. Applies to founders selling enterprise, sales reps, or sales managers.

## Quick Reference

| Topic | File |
|-------|------|
| Frameworks | `frameworks.md` |
| Outreach | `outreach.md` |
| Pipeline | `pipeline.md` |

## Core Rules

### 1. Research Before Outreach
- Min 3 insights per prospect: recent news, hiring signals, tech stack, funding
- Identify decision makers AND influencers (map org chart)
- Detect buying signals: leadership changes, expansion, competitor issues
- Never send generic "I noticed you work at X" messages

### 2. Qualify Ruthlessly (MEDDIC)
| Element | Question |
|---------|----------|
| Metrics | What measurable outcome do they need? |
| Economic Buyer | Who signs the check? |
| Decision Criteria | What will they evaluate? |
| Decision Process | What steps before purchase? |
| Identify Pain | What specific problem hurts? |
| Champion | Who will sell internally for us? |

### 3. Multi-Thread Every Deal
- Never single-threaded (one contact = fragile deal)
- Map: Champion, Economic Buyer, Technical Evaluator, End Users
- Ask: "Who else should be involved in this decision?"
- If champion leaves, deal often dies

### 4. Next Step Obsession
- Every interaction MUST end with concrete next step + date
- "I'll follow up" is not a next step
- Use Mutual Action Plans for complex deals
- No next step = deal is stalled

### 5. Don't Trust CRM Stage
- A deal in "Negotiation" may be dead
- Validate with: recent activity, next step scheduled, champion engaged
- Time in stage matters: 60 days in Discovery = red flag
- Weighted pipeline only works with realistic probabilities

### 6. Build Champions, Not Just Contacts
- Champion = someone who sells internally when you're not there
- Arm them with ROI data, competitive positioning, internal pitch
- If they can't articulate value without you, not a champion yet
- Protect and nurture: their success = your success

## Common Traps

| Trap | Reality |
|------|---------|
| Superficial personalization | "Hi [Name], I see you work at [Company]" is not personalization |
| Talking features before pain | Understand their problem first; demo features they need |
| Ignoring buying committee | You need consensus, not just one excited person |
| Happy ears syndrome | Rep says "great call!" but no commitment to next step |
| Chasing volume over ICP | 10 qualified leads > 100 random ones |
| Premature proposal | Sending pricing before validating budget/authority |
| Forgetting the champion post-close | Recipe for churn |
| Same message to CEO and user | Different stakeholders need different value props |

## Forecasting Red Flags

- Deal in pipeline 3x average cycle length
- No activity in 14+ days
- Single-threaded with one contact
- Verbal "yes" but no signed paperwork
- Champion "too busy" for next meeting
- Procurement/legal not engaged in late stage
- Slipped commit date more than once
