# Lenny Rachitsky's "First 1000 Users" (B2B Edition)

This reference contains the core lessons from Lenny Rachitsky's research into how the biggest B2B companies (Slack, Stripe, Figma, Salesforce) acquired their first 1,000 customers.

## The Golden Rule: "Do Things That Don't Scale"
In the early days (Kickstart phase), automated marketing channels (Ads, SEO, Viral Loops) rarely work. Founders must manually recruit customers.

## The 3 Main B2B Channels
Almost every successful B2B startup started with one of these three tactics.

### 1. Personal Network (The Most Common)
Leveraging existing connections (and 2nd-degree connections) to get the first foot in the door.
*   **Who used it:** Slack, Stripe, Yammer, Carta.
*   **The Strategy:** Don't just ask friends to buy. Ask friends for *intros* to the specific decision-maker at their company.
*   **Quote:** "It's all about warm intros. Cold emails are dead on arrival unless you are a sniper."

### 2. Targeted Cold Outreach (The Sniper Approach)
If you don't have a network, you must build one. This is NOT "spray and pray."
*   **Who used it:** Salesforce, Box, Zoom, Segment.
*   **The Strategy:** High-fidelity personalization.
    *   Find the exact person with the pain.
    *   Find a valid "trigger" (they just hired, they just migrated tech).
    *   Send a personalized, human note.
*   **Key Insight:** Benioff (Salesforce) didn't spam lists. He targeted specific people he knew needed CRM and called/emailed them relentlessly with a specific value prop.

### 3. Niche Communities (The "Watering Hole")
Finding where your users hang out online and becoming a helpful member of that tribe.
*   **Who used it:** Figma (Twitter design community), Atlassian (Dev forums), Zapier.
*   **The Strategy:**
    *   Identify the subreddit, Slack group, or Discord.
    *   Do NOT sell immediately.
    *   Answer questions, provide value, and build reputation.
    *   "Launch" by asking for feedback, not money.

## The Anti-Patterns (What NOT to do)
*   **The "Big Launch":** Thinking a Product Hunt launch will solve sales. It won't.
*   **Paid Ads:** Burning cash before you know your pitch works.
*   **Content Marketing (Too Early):** Writing blogs that nobody reads because you have no distribution.

## B2B Sales Wisdom (Jen Abel / Sell the Alpha)
*   **Don't sell the problem:** They already know they have the problem.
*   **Don't sell the product:** They don't care about your features yet.
*   **Sell the Alpha:** Sell a unique insight or perspective on their industry that they *haven't* realized yet.
    *   *Bad:* "Our database is faster."
    *   *Good:* "Most teams think latency comes from compute, but we found 80% comes from serialization. We fixed that."
