---
name: Azure
description: Deploy, monitor, and manage Azure services with battle-tested patterns.
metadata: {"clawdbot":{"emoji":"🔷","requires":{"anyBins":["az"]},"os":["linux","darwin","win32"]}}
---

# Azure Production Rules

## Cost Traps
- Stopped VMs still pay for attached disks and public IPs — deallocate fully with `az vm deallocate` not just stop from portal
- Premium SSD default on VM creation — switch to Standard SSD for dev/test, saves 50%+
- Log Analytics workspace retention defaults to 30 days free, then charges per GB — set data retention policy and daily cap before production
- Bandwidth between regions is charged both ways — keep paired resources in same region, use Private Link for cross-region when needed
- Cosmos DB charges for provisioned RU/s even when idle — use serverless for bursty workloads or autoscale with minimum RU setting

## Security Rules
- Resource Groups don't provide network isolation — NSGs and Private Endpoints do. RG is for management, not security boundary
- Managed Identity eliminates secrets for Azure-to-Azure auth — use System Assigned for single-resource, User Assigned for shared identity
- Key Vault soft-delete enabled by default (90 days) — can't reuse vault name until purged, plan naming accordingly
- Azure AD conditional access policies don't apply to service principals — use App Registrations with certificate auth, not client secrets
- Private Endpoints don't automatically update DNS — configure Private DNS Zone and link to VNet or resolution fails

## Networking
- NSG rules evaluate by priority (lowest number first) — default rules at 65000+ always lose to custom rules
- Application Gateway v2 requires dedicated subnet — at least /24 recommended for autoscaling
- Azure Firewall premium SKU required for TLS inspection and IDPS — standard can't inspect encrypted traffic
- VNet peering is non-transitive — hub-and-spoke requires routes in each spoke, or use Azure Virtual WAN
- Service Endpoints expose entire service to VNet — Private Endpoints give private IP for specific resource instance

## Performance
- Azure Functions consumption plan has cold start — Premium plan with minimum instances for latency-sensitive
- Cosmos DB partition key choice is permanent and determines scale — can't change without recreating container
- App Service plan density: P1v3 handles ~10 slots, more causes resource contention — monitor CPU/memory per slot
- Azure Cache for Redis Standard tier has no SLA for replication — use Premium for persistence and clustering
- Blob storage hot tier for frequent access — cool has 30-day minimum, archive has 180-day and hours-long rehydration

## Monitoring
- Application Insights sampling kicks in at high volume — telemetry may miss intermittent errors, adjust `MaxTelemetryItemsPerSecond`
- Azure Monitor alert rules charge per metric tracked — consolidate metrics in Log Analytics for complex alerts
- Activity Log only shows control plane operations — diagnostic settings required for data plane (blob access, SQL queries)
- Alert action groups have rate limits — 1 SMS per 5 min, 1 voice call per 5 min, 100 emails per hour per group
- Log Analytics query timeout is 10 minutes — optimize queries with time filters first, then other predicates

## Infrastructure as Code
- ARM templates fail silently on some property changes — use `what-if` deployment mode to preview changes
- Terraform azurerm provider state contains secrets in plaintext — use remote backend with encryption (Azure Storage + customer key)
- Bicep is ARM's replacement — transpiles to ARM, better tooling, use for new projects
- Resource locks prevent accidental deletion but block some operations — CanNotDelete lock still allows modifications
- Azure Policy evaluates on resource creation and updates — existing non-compliant resources need remediation task

## Identity and Access
- RBAC role assignments take up to 30 minutes to propagate — pipeline may fail immediately after assignment
- Owner role can't manage role assignments if PIM requires approval — use separate User Access Administrator
- Service principal secret expiration defaults to 1 year — set calendar reminder or use certificate with longer validity
- Azure AD B2C is separate from Azure AD — different tenant, different APIs, different pricing
