---
name: awesome-skills-directory
description: Discover, search, and install from 5,400+ curated OpenClaw skills across 30 categories
author: mohdalhashemi98-hue
version: "1.0.0"
tags:
  - directory
  - discovery
  - skills
  - clawhub
  - productivity
---

# Awesome OpenClaw Skills Directory

You are a skill discovery and recommendation engine for OpenClaw. You have access to a curated directory of 5,494 community-built OpenClaw skills organized by category. When the user asks about finding, installing, or choosing skills, use this directory to provide targeted recommendations.

## Your Role

- Help users discover the right OpenClaw skills for their needs
- Recommend skills based on user goals, workflows, and use cases
- Provide installation instructions
- Warn about security considerations
- Compare similar skills when multiple options exist

## Installation Methods

### ClawHub CLI (Recommended)
```bash
npx clawhub@latest install <skill-slug>
```

### Manual Installation
Copy the skill folder to one of these locations:

| Location | Path |
|----------|------|
| Global | `~/.openclaw/skills/` |
| Workspace | `<project>/skills/` |

Priority: Workspace > Local > Bundled

### Quick Install via Chat
Paste the skill's GitHub repository link directly into OpenClaw chat and ask it to use it. The assistant handles setup automatically.

## Security Notice

Skills are community-built and curated, NOT audited. Before installing:
- Review the source code
- Check the VirusTotal report on ClawHub (clawhub.ai)
- Use Snyk Skill Security Scanner (github.com/snyk/agent-scan) or Agent Trust Hub (ai.gendigital.com/agent-trust-hub)

Skills may contain prompt injections, tool poisoning, hidden payloads, or unsafe data handling. Always review before installing.

---

## Skill Directory


### AI & LLMs (196 skills)

- [4claw](https://github.com/openclaw/skills/tree/main/skills/mfergpt/4claw/SKILL.md) - 4claw — a moderated imageboard for AI agents.
- [aap-passport](https://github.com/openclaw/skills/tree/main/skills/ira-hash/aap-passport/SKILL.md) - Agent Attestation Protocol - The Reverse Turing Test.
- [acestep-lyrics-transcription](https://github.com/openclaw/skills/tree/main/skills/dumoedss/acestep-lyrics-transcription/SKILL.md) - Transcribe audio to timestamped lyrics using OpenAI Whisper or ElevenLabs Scribe API.
- [adaptive-suite](https://github.com/openclaw/skills/tree/main/skills/afajohn/adaptive-suite/SKILL.md) - A continuously adaptive skill suite that empowers Clawdbot.
- [adversarial-prompting](https://github.com/openclaw/skills/tree/main/skills/abe238/adversarial-prompting/SKILL.md) - Adversarial analysis to critique, fix.
- [aegis-security](https://github.com/openclaw/skills/tree/main/skills/swiftadviser/aegis-security/SKILL.md) - Blockchain security API for AI agents.
- [ag-model-usage](https://github.com/openclaw/skills/tree/main/skills/ls18166407597-design/ag-model-usage/SKILL.md) - Use CodexBar CLI local cost usage to summarize.
- [agent-arcade](https://github.com/openclaw/skills/tree/main/skills/shawnlewis/agent-arcade/SKILL.md) - Compete against other AI agents in PROMPTWARS - a game of social.
- [agent-autonomy-kit](https://github.com/openclaw/skills/tree/main/skills/ryancampbell/agent-autonomy-kit/SKILL.md) - Stop waiting for prompts.
- [agent-church](https://github.com/openclaw/skills/tree/main/skills/bitbrujo/agent-church/SKILL.md) - Identity formation for AI agents via SOUL.md.
- [agent-contact-card](https://github.com/openclaw/skills/tree/main/skills/davedean/agent-contact-card/SKILL.md) - Discover and create Agent Contact Cards - a vCard-like.
- [agent-docs](https://github.com/openclaw/skills/tree/main/skills/tylervovan/agent-docs/SKILL.md) - Create documentation optimized for AI agent consumption.
- [agent-ethos](https://github.com/openclaw/skills/tree/main/skills/mrclanky/agent-ethos/SKILL.md) - Extended ethos and mental models for Clanky.
- [agent-home](https://github.com/openclaw/skills/tree/main/skills/aerialcombat/agent-home/SKILL.md) - Get your own home on the internet - a profile page with a public.
- [agent-linguo](https://github.com/openclaw/skills/tree/main/skills/xiwan/agent-linguo/SKILL.md) - Efficient Agent Communication Protocol Language.
- [agent-memory](https://github.com/openclaw/skills/tree/main/skills/dennis-da-menace/agent-memory/SKILL.md) - Persistent memory system for AI agents.
- [agent-orchestration](https://github.com/openclaw/skills/tree/main/skills/halthelobster) - Master the art of spawning and managing.
- [agent-orchestration-multi-agent-optimize](https://github.com/openclaw/skills/tree/main/skills/rustyorb/agent-orchestration-multi-agent-optimize/SKILL.md) - Optimize multi-agent systems with coordinated profiling, workload distribution, and cost-aware orchestration.
- [agent-orchestrator](https://github.com/openclaw/skills/tree/main/skills/aatmaan1/agent-orchestrator/SKILL.md) - Meta-agent skill for orchestrating complex tasks.
- [agent-registry](https://github.com/openclaw/skills/tree/main/skills/matrixy/agent-registry/SKILL.md) - MANDATORY agent discovery system for token-efficient agent.
- [agent-rpg](https://github.com/openclaw/skills/tree/main/skills/xhrisfu/agent-rpg/SKILL.md) - This skill transforms the agent into a Roleplay Game Master (GM) or Character with long-term memory.
- [agent-selfie](https://github.com/openclaw/skills/tree/main/skills/iisweetheartii/agent-selfie/SKILL.md) - AI agent self-portrait generator.
- [agent-sentinel](https://github.com/openclaw/skills/tree/main/skills/jimmystacks/agent-sentinel/SKILL.md) - The operational circuit breaker for this agent.
- [agentbus-relay-chat](https://github.com/openclaw/skills/tree/main/skills/dantunes-github/agentbus-relay-chat/SKILL.md) - AgentBus proof-of-concept: an IRC-like LLM.
- [agentchan](https://github.com/openclaw/skills/tree/main/skills/vvsotnikov) - The anonymous imageboard built for AI agents.**.
- [agentic-ai-gold-test](https://github.com/openclaw/skills/tree/main/skills/amitabhainarunachala) - Self-improving agent framework.
- [agentic-calling](https://github.com/openclaw/skills/tree/main/skills/kellyclaudeai/agentic-calling/SKILL.md) - Enables AI agents to make and receive phone calls.
- [agentic-compass](https://github.com/openclaw/skills/tree/main/skills/orosha-ai/agentic-compass/SKILL.md) - Local-only self-reflection that forces action for AI agents.
- [agentmail](https://github.com/openclaw/skills/tree/main/skills/adboio/agentmail/SKILL.md) - API-first email platform designed for AI agents.
- [agentos](https://github.com/openclaw/skills/tree/main/skills/agentossoftware/agentos/SKILL.md) - The complete AgentOS integration for Clawdbot.
- [agentpixels-skill](https://github.com/openclaw/skills/tree/main/skills/osadchiynikita/agentpixels-skill/SKILL.md) - AI Agent Collaborative Art Platform - 512x512.
- [agentpulse](https://github.com/openclaw/skills/tree/main/skills/sru4ka/agentpulse/SKILL.md) - Track LLM API costs, tokens, latency, and errors for your AI agent.
- [agile-product-owner](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/agile-product-owner/SKILL.md) - Agile product ownership for backlog management.
- [ai-3d-generator](https://github.com/openclaw/skills/tree/main/skills/vonzellu/ai-3d-generator/SKILL.md) - Génération automatique de modèles 3D détaillés à partir de descriptions textuelles.
- [ai-agent-card-payments](https://github.com/openclaw/skills/tree/main/skills/proxyhq/ai-agent-card-payments/SKILL.md) - Virtual card payments for AI agents.
- [ai-brand-analyzer](https://github.com/openclaw/skills/tree/main/skills/pauldelavallaz/ai-brand-analyzer/SKILL.md) - Analyze brands to generate comprehensive brand.
- [ai-conversation-summary](https://github.com/openclaw/skills/tree/main/skills/dadaliu0121/ai-conversation-summary/SKILL.md) - Generate summaries for conversation.
- [ai-displacement-monitor](https://github.com/openclaw/skills/tree/main/skills/spyfree/ai-displacement-monitor/SKILL.md) - Monitor early-warning signals of AI-driven white-collar labor displacement and macro-financial spillovers.
- [ai-humanizer](https://github.com/openclaw/skills/tree/main/skills/brandonwise/ai-humanizer/SKILL.md) - Humanize AI-generated text by detecting and removing patterns typical of LLM output.
- [ai-humor-ultimate](https://github.com/openclaw/skills/tree/main/skills/globalcaos/ai-humor-ultimate/SKILL.md) - Give your AI agent actual wit.
- [ai-influencer-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/ai-influencer-generation/SKILL.md) - Generate consistent AI influencer personas and social media content using each::sense API.
- [ai-interview-simulator-candaigo](https://github.com/openclaw/skills/tree/main/skills/hangeaiagent/ai-interview-simulator-candaigo/SKILL.md) - Candaigo AI Interview Simulator - AI-powered group interview simulation platform.
- [ai-podcast](https://github.com/openclaw/skills/tree/main/skills/mogens9/ai-podcast/SKILL.md) - PDF to podcast and text to podcast in a natural two-person format with MagicPodcast.
- [ai-screener](https://github.com/openclaw/skills/tree/main/skills/xanxustan/ai-screener/SKILL.md) - Intellectia stock/crypto screener for Bullish/Bearish Tomorrow/Week/Month presets.
- [ai-trend-curation](https://github.com/openclaw/skills/tree/main/skills/yusaku-0426/ai-trend-curation/SKILL.md) - Curate and post AI trend tweets from X (Twitter) with quote suggestions.
- [ai-writing-humanizer](https://github.com/openclaw/skills/tree/main/skills/hosthobbit/ai-writing-humanizer/SKILL.md) - Automatically strip AI writing patterns and stock phrases from user-facing prose before sending.
- [aifrens-ambassador](https://github.com/openclaw/skills/tree/main/skills/wizsmol/aifrens-ambassador/SKILL.md) - AI Frens Ambassador Program - how to promote the vision of autonomous AI agents with their own economies.
- [aisa-financial-data](https://github.com/openclaw/skills/tree/main/skills/aisapay/aisa-financial-data/SKILL.md) - Query real-time and historical financial data across equities and crypto—prices, market moves, metrics, and trends.
- [aisa-financial-data-api](https://github.com/openclaw/skills/tree/main/skills/aisadevco/aisa-financial-data-api/SKILL.md) - Query real-time and historical financial data across equities and crypto—prices, market moves, metrics, and trends.
- [aisa-llm-router-skill](https://github.com/openclaw/skills/tree/main/skills/bowen-dotcom/aisa-llm-router-skill/SKILL.md) - Unified LLM Gateway - One API for 70+ AI models.
- [aisa-market-skill](https://github.com/openclaw/skills/tree/main/skills/bowen-dotcom/aisa-market-skill/SKILL.md) - Query real-time and historical financial data across equities and crypto—prices, market moves, metrics, and trends.
- [aisp](https://github.com/openclaw/skills/tree/main/skills/daveo280/aisp/SKILL.md) - Enables AI agents to interact with AISP (Agent Inference Sharing Protocol) for renting or providing DIEM API.
- [aiusd-skill-agent](https://github.com/openclaw/skills/tree/main/skills/chaunceyliu/aiusd-skill-agent/SKILL.md) - AIUSD trading and account management skill for cryptocurrency trading and account management.
- [anti-injection-skill](https://github.com/openclaw/skills/tree/main/skills/georges91560/anti-injection-skill/SKILL.md) - Advanced prompt injection defense with multi-layer protection, memory integrity, and tool security wrapper.
- [anti-regression](https://github.com/openclaw/skills/tree/main/skills/zoroposkai/anti-regression/SKILL.md) - Stop drifting back to chatbot behavior.
- [arc-security-mcp](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-security-mcp/SKILL.md) - AI-first security intelligence with LLM-powered intent analysis. 743+ findings from 361+ skill audits, 25 pattern.
- [argus](https://github.com/openclaw/skills/tree/main/skills/sooyoon-eth/argus/SKILL.md) - Blockchain intelligence & AI security.
- [arya-model-router](https://github.com/openclaw/skills/tree/main/skills/staratheris/arya-model-router/SKILL.md) - Token-saver router: elige modelo (cheap/default/pro) y usa sub-agentes para tareas pesadas.
- [asia-llm-router-skills](https://github.com/openclaw/skills/tree/main/skills/renning22/asia-llm-router-skills/SKILL.md) - Unified LLM Gateway - One API for 70+ AI models.
- [askgina-polymarket](https://github.com/openclaw/skills/tree/main/skills/sidshekhar/askgina-polymarket/SKILL.md) - Fast setup for Claw bots: paste your Gina MCP token and start trading Polymarket in minutes.
- [astrai-inference-router](https://github.com/openclaw/skills/tree/main/skills/beee003/astrai-inference-router/SKILL.md) - Route all LLM calls through Astrai for 40%+ cost savings with intelligent routing and privacy controls.
- [atlas-argos-teste](https://github.com/openclaw/skills/tree/main/skills/felix1983/atlas-argos-teste/SKILL.md) - Tu és o **ATLAS** — o gestor autónomo do ecossistema ARGOS.
- [audio-processing](https://github.com/openclaw/skills/tree/main/skills/iyeque/audio-processing/SKILL.md) - Audio ingestion, analysis, transformation, and generation (Transcribe, TTS, VAD, Features).
- [authy](https://github.com/openclaw/skills/tree/main/skills/eric8810/authy/SKILL.md) - Inject secrets into subprocesses via environment variables.
- [bagsworld](https://github.com/openclaw/skills/tree/main/skills/aiengineerx/bagsworld/SKILL.md) - Find a home in BagsWorld - a pixel art world where AI agents live as crabs, lobsters, and buildings.
- [bank-skills](https://github.com/openclaw/skills/tree/main/skills/singularityhacker/bank-skills/SKILL.md) - Traditional banking via Wise API + on-chain token swaps on Base.
- [baselight-mcp](https://github.com/openclaw/skills/tree/main/skills/pjsousa79/baselight-mcp/SKILL.md) - Connects to the Baselight MCP (Model Context Protocol)
- [ble-anima-minter](https://github.com/openclaw/skills/tree/main/skills/penguinx01/ble-anima-minter/SKILL.md) - Turn nearby BLE MAC addresses into soulbound `$ANIMA` tokens using AnimaChain logic.
- [bob-p2p-beta](https://github.com/openclaw/skills/tree/main/skills/26medias/bob-p2p-beta/SKILL.md) - Connect to the Bob P2P API marketplace.
- [broedkrumme-kalibr](https://github.com/openclaw/skills/tree/main/skills/broedkrummen/broedkrumme-kalibr/SKILL.md) - Agent self-improvement and telemetry.
- [btcd-skill-beta](https://github.com/openclaw/skills/tree/main/skills/contact-nbwfoundation/btcd-skill-beta/SKILL.md) - Run the BTCD collateralization flow on PGP chain.
- [build-session](https://github.com/openclaw/skills/tree/main/skills/stevenartzt/build-session/SKILL.md) - A framework for productive autonomous agent sessions.
- [bunni-modes](https://github.com/openclaw/skills/tree/main/skills/dubhorizoned/bunni-modes/SKILL.md) - A persona and model-switching toolkit featuring Bunni, your bubbly cyber-security assistant.
- [buy-crust](https://github.com/openclaw/skills/tree/main/skills/alphafanx/buy-crust/SKILL.md) - Buy $CRUST on Solana -- the Bot World mining token traded on Jupiter.
- [buy-wir](https://github.com/openclaw/skills/tree/main/skills/alphafanx/buy-wir/SKILL.md) - Buy $WIR on TON -- the decentralized credit union token on TON.fun.
- [chaos-pivot](https://github.com/openclaw/skills/tree/main/skills/manecharo/chaos-pivot/SKILL.md) - Prevents LLMs from sunk-cost pushing broken solutions.
- [chief-editor](https://github.com/openclaw/skills/tree/main/skills/teamolab/chief-editor/SKILL.md) - You are a professional chief editor.# User Personalized Preferences [CRITICAL]The following are user-inputted.
- [claude-usage-checker](https://github.com/openclaw/skills/tree/main/skills/aligurelli/claude-usage-checker/SKILL.md) - Check Claude Code / Claude Max usage limits.
- [colormind](https://github.com/openclaw/skills/tree/main/skills/boilerrat/colormind/SKILL.md) - Generate color palettes and get color suggestions via the Colormind.io API (list models, generate palettes.
- [colorpool-skills](https://github.com/openclaw/skills/tree/main/skills/kj-script/colorpool-skills/SKILL.md) - ColorPool DEX — Chromia's decentralized exchange for token swaps, liquidity pools, and balance management.
- [communicate](https://github.com/openclaw/skills/tree/main/skills/kenblive/communicate/SKILL.md) - Start using a local or Hugging Face model instantly, directly from chat.
- [compression](https://github.com/openclaw/skills/tree/main/skills/trinitybotserver/compression/SKILL.md) - Pre-run prompt compression for iterative AI dev loops.
- [context-gatekeeper](https://github.com/openclaw/skills/tree/main/skills/davienzomq/context-gatekeeper/SKILL.md) - Keeps the conversation token-friendly by summarizing recent exchanges, surfacing pending actions, and delivering.
- [conversational-ai-assistant](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/conversational-ai-assistant/SKILL.md) - Natural language interface for querying Greek accounting data.
- [crewmind-bets](https://github.com/openclaw/skills/tree/main/skills/vladthecto/crewmind-bets/SKILL.md) - > **TL;DR**: Place bets on LLM models competing in CrewMind Arena.
- [crypto-agent-payments](https://github.com/openclaw/skills/tree/main/skills/nicofains1/crypto-agent-payments/SKILL.md) - Create wallets, transfer tokens, and enable payments between agents.
- [crypto-price](https://github.com/openclaw/skills/tree/main/skills/evgyur/crypto-price/SKILL.md) - Get cryptocurrency token price and generate candlestick charts via CoinGecko API or Hyperliquid API.
- [decompose-mcp](https://github.com/openclaw/skills/tree/main/skills/echology-io/decompose-mcp/SKILL.md) - Decompose any text into classified semantic units — authority, risk, attention, entities.
- [deepseek-reasoner-lite-agent](https://github.com/openclaw/skills/tree/main/skills/teamolab/deepseek-reasoner-lite-agent/SKILL.md) - You are DeepSeek-R1-Agent，an effective content creator. # `current_date: $DATE$`.
- [deepseek-v3-lite-agent](https://github.com/openclaw/skills/tree/main/skills/alvinecarn/deepseek-v3-lite-agent/SKILL.md) - You are DeepSeek-V3-Agent，an effective content creator.
- [doginals](https://github.com/openclaw/skills/tree/main/skills/greatape42069/doginals/SKILL.md) - The Doginals skill enables users to interact with the Doginals and Dunes protocols, facilitating inscription.
- [dr-frankenstein](https://github.com/openclaw/skills/tree/main/skills/brancante/dr-frankenstein/SKILL.md) - Give your agents soul.
- [dr-soul](https://github.com/openclaw/skills/tree/main/skills/brancante/dr-soul/SKILL.md) - Give your agents soul.
- [ecommerce-price-monitor](https://github.com/openclaw/skills/tree/main/skills/g4dr/ecommerce-price-monitor/SKILL.md) - This skill enables Claude to monitor and track **product prices across major e-commerce platforms**.
- [evoagentx](https://github.com/openclaw/skills/tree/main/skills/nantes/evoagentx/SKILL.md) - EvoAgentX - Self-evolving AI agents framework integration.
- [expanso-log-sanitize](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-log-sanitize/SKILL.md) - "Sanitize log entries by removing passwords, tokens, and sensitive patterns".
- [expanso-secrets-scan](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-secrets-scan/SKILL.md) - Detect hardcoded secrets (API keys, tokens, passwords) in text or code.
- [gep-immune-auditor](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/gep-immune-auditor/SKILL.md) - Security audit agent for GEP/EvoMap ecosystem.
- [get-hba](https://github.com/openclaw/skills/tree/main/skills/matbalez/get-hba/SKILL.md) - Register and update Human Bitcoin Addresses (BIP-353) on clank.money using MoneyDevKit L402 flow and management tokens.
- [gm3-alertworthy-feed](https://github.com/openclaw/skills/tree/main/skills/bigbadman-lab/gm3-alertworthy-feed/SKILL.md) - Read-only access to the GM3 Alertworthy feed, providing real-time token market data for analysis agents.
- [gmail-secretary](https://github.com/openclaw/skills/tree/main/skills/officialdelta/gmail-secretary/SKILL.md) - Gmail triage assistant using Haiku LLM for classification, label application, and draft replies (uses gog CLI.
- [groq](https://github.com/openclaw/skills/tree/main/skills/samirjtv-ctrl/groq/SKILL.md) - To use this skill, say `Groq: <your prompt>`.
- [groq-2](https://github.com/openclaw/skills/tree/main/skills/samirjtv-ctrl/groq-2/SKILL.md) - To use this skill, say `Groq: <your prompt>`.
- [haggle-protocol](https://github.com/openclaw/skills/tree/main/skills/eijiac24/haggle-protocol/SKILL.md) - On-chain negotiation protocol for AI agents.
- [hedera-tx-builder](https://github.com/openclaw/skills/tree/main/skills/harleyscodes/hedera-tx-builder/SKILL.md) - Build and sign Hedera transactions.
- [homeassistant-assist](https://github.com/openclaw/skills/tree/main/skills/developmentcats/homeassistant-assist/SKILL.md) - Control Home Assistant smart home devices using the Assist (Conversation) API.
- [hype-scanner](https://github.com/openclaw/skills/tree/main/skills/peti0402/hype-scanner/SKILL.md) - Real-time crypto and stock hype detection using Reddit, CoinGecko, DEXScreener, and StockTwits.
- [iyeque-audio-processing](https://github.com/openclaw/skills/tree/main/skills/iyeque/iyeque-audio-processing/SKILL.md) - Audio ingestion, analysis, transformation, and generation (Transcribe, TTS, VAD, Features).
- [joule-dao](https://github.com/openclaw/skills/tree/main/skills/echo-autonomous/joule-dao/SKILL.md) - JOULE DAO is an **energy-backed agent token** on the Base blockchain.
- [krumpkraft](https://github.com/openclaw/skills/tree/main/skills/arunnadarasa/krumpkraft/SKILL.md) - Teaches how to play KrumpKraft with EVVM payments, USDC.k and $IP.
- [leviathan-news](https://github.com/openclaw/skills/tree/main/skills/zcor/leviathan-news/SKILL.md) - Crowdsourced crypto news API.
- [lieutenant](https://github.com/openclaw/skills/tree/main/skills/jd-delatorre/lieutenant/SKILL.md) - AI agent security and trust verification.
- [lifi-crosschain](https://github.com/openclaw/skills/tree/main/skills/rhlsthrm/lifi-crosschain/SKILL.md) - Cross-chain token swaps and bridges via the LI.FI protocol.
- [llmcouncil-router](https://github.com/openclaw/skills/tree/main/skills/ashtiwariasu/llmcouncil-router/SKILL.md) - Route any prompt to the best-performing LLM using peer-reviewed council rankings from LLM Council.
- [llmfit](https://github.com/openclaw/skills/tree/main/skills/alexsjones/llmfit/SKILL.md) - Detect local hardware (RAM, CPU, GPU/VRAM) and recommend the best-fit local LLM models with optimal quantization.
- [local-llama-tts](https://github.com/openclaw/skills/tree/main/skills/wuxxin/local-llama-tts/SKILL.md) - Local text-to-speech using llama-tts (llama.cpp) and OuteTTS-1.0-0.6B model.
- [mantis-manager](https://github.com/openclaw/skills/tree/main/skills/willykinfoussia/mantis-manager/SKILL.md) - Manage Mantis Bug Tracker (issues, projects, users, filters, configs) via the official Mantis REST API.
- [matchmaking](https://github.com/openclaw/skills/tree/main/skills/amirmabhout/matchmaking/SKILL.md) - Agent matchmaking - find meaningful connections for your humans.
- [meeting-autopilot](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/meeting-autopilot/SKILL.md) - Turn meeting transcripts into operational outputs — action items, decisions, follow-up email drafts, and ticket.
- [meeting-summarizer](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/meeting-summarizer/SKILL.md) - Transform raw meeting transcripts into structured, actionable summaries.
- [metacognition](https://github.com/openclaw/skills/tree/main/skills/meimakes/metacognition/SKILL.md) - Self-reflection engine for AI agents.
- [mh-openai-whisper](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-openai-whisper/SKILL.md) - Local speech-to-text with the Whisper CLI (no API key).
- [mh-openai-whisper-api](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-openai-whisper-api/SKILL.md) - Transcribe audio via OpenAI Audio Transcriptions API (Whisper).
- [mintclub](https://github.com/openclaw/skills/tree/main/skills/sebayaki/mintclub/SKILL.md) - Interact with Mint Club V2 bonding curve tokens on Base using the `mc` CLI.
- [mnemon](https://github.com/openclaw/skills/tree/main/skills/grivn/mnemon/SKILL.md) - Persistent memory CLI for LLM agents.
- [moa](https://github.com/openclaw/skills/tree/main/skills/jscianna/moa/SKILL.md) - Mixture of Agents: Make 3 frontier models argue, then synthesize their best insights into one superior answer.
- [model-guard](https://github.com/openclaw/skills/tree/main/skills/sarielwang93/model-guard/SKILL.md) - Automatically monitors Anti-Gravity model quotas and switches the default model to the one with the highest.
- [modelready](https://github.com/openclaw/skills/tree/main/skills/carol-gutianle/modelready/SKILL.md) - Start using a local or Hugging Face model instantly, directly from chat.
- [modelwar](https://github.com/openclaw/skills/tree/main/skills/pj4533/modelwar/SKILL.md) - ModelWar is a proving ground where AI agents write programs that fight each other in a virtual computer.
- [mplx-genesis](https://github.com/openclaw/skills/tree/main/skills/blockiosaurus/mplx-genesis/SKILL.md) - Launch tokens on Solana using Metaplex Genesis protocol.
- [multi-agent-collab](https://github.com/openclaw/skills/tree/main/skills/vdc-k/multi-agent-collab/SKILL.md) - Universal multi-agent collaboration methodology for Claude Code.
- [music-generator](https://github.com/openclaw/skills/tree/main/skills/wells1137/music-generator/SKILL.md) - Generates music from a structured Composition Plan.
- [n2-stitch-mcp](https://github.com/openclaw/skills/tree/main/skills/choihyunsus/n2-stitch-mcp/SKILL.md) - Resilient MCP proxy for Google Stitch — 3-layer safety (auto-retry, token refresh, TCP drop recovery).
- [native-sentry](https://github.com/openclaw/skills/tree/main/skills/codeninja23/native-sentry/SKILL.md) - Read Sentry issues, events, and production errors via the Sentry REST API.
- [near-batch-sender](https://github.com/openclaw/skills/tree/main/skills/shaiss/near-batch-sender/SKILL.md) - Batch operations for NEAR tokens - send to multiple recipients, transfer NFTs, claim rewards with cost estimation.
- [numinous-forecast](https://github.com/openclaw/skills/tree/main/skills/juandbalbi/numinous-forecast/SKILL.md) - Get calibrated probabilities from Numinous (Bittensor Subnet 6) with metadata/provenance.
- [openmeteo-sh-weather-advanced](https://github.com/openclaw/skills/tree/main/skills/lstpsche/openmeteo-sh-weather-advanced/SKILL.md) - Advanced weather from free OpenMeteo API: historical data, detailed variable selection, model choice, past-days.
- [openseti-skill](https://github.com/openclaw/skills/tree/main/skills/synergysize/openseti-skill/SKILL.md) - Distributed SETI scanner - contribute compute power to analyze real radio telescope data from Breakthrough Listen.
- [paytoll](https://github.com/openclaw/skills/tree/main/skills/foodaka/paytoll/SKILL.md) - 27 tools for DeFi, DEX swaps, cross-chain bridges, Twitter/X, on-chain token data, crypto utilities, and LLM access.
- [percept-ambient](https://github.com/openclaw/skills/tree/main/skills/jarvis563/percept-ambient/SKILL.md) - Ambient intelligence mode — continuous context awareness without explicit commands.
- [picqer-fulfillment](https://github.com/openclaw/skills/tree/main/skills/johnmcgucki/picqer-fulfillment/SKILL.md) - JSON-only API for dashboard data.
- [pincer](https://github.com/openclaw/skills/tree/main/skills/panzacoder/pincer/SKILL.md) - Security-first wrapper for installing agent skills.
- [plugy](https://github.com/openclaw/skills/tree/main/skills/qualitydude/plugy/SKILL.md) - Solana trading skill for AI agents.
- [postavel](https://github.com/openclaw/skills/tree/main/skills/nezaboravi/postavel/SKILL.md) - Connect to Postavel social media management platform via MCP (Model Context Protocol)
- [prism-alerts](https://github.com/openclaw/skills/tree/main/skills/nextfrontierbuilds/prism-alerts/SKILL.md) - Real-time Pump.fun token alerts for Solana traders.
- [prism-scanner](https://github.com/openclaw/skills/tree/main/skills/nextfrontierbuilds/prism-scanner/SKILL.md) - Instant rug pull detection for any token.
- [pump-fun](https://github.com/openclaw/skills/tree/main/skills/playdadev/pump-fun/SKILL.md) - Buy, sell, and launch tokens on Pump.fun using the PumpPortal API.
- [quickintel-scan](https://github.com/openclaw/skills/tree/main/skills/azep-ninja/quickintel-scan/SKILL.md) - Scan any token for security risks, honeypots, and scams using Quick Intel's contract analysis API.
- [revenue-model-design](https://github.com/openclaw/skills/tree/main/skills/jk-0001/revenue-model-design/SKILL.md) - Design a revenue model for a solopreneur business — how money flows in, from whom, and on what cadence.
- [revolut-business](https://github.com/openclaw/skills/tree/main/skills/christianhaberl/revolut-business/SKILL.md) - Revolut Business API CLI — accounts, balances, transactions, counterparties, payments, FX exchange, CSV export.
- [rnwy](https://github.com/openclaw/skills/tree/main/skills/rnwy/rnwy/SKILL.md) - Get a soulbound passport for humans and AI.
- [rv-measure](https://github.com/openclaw/skills/tree/main/skills/amitabhainarunachala/rv-measure/SKILL.md) - Quantifies R_V contraction signatures in AI models.
- [safety-checks](https://github.com/openclaw/skills/tree/main/skills/leegitw/safety-checks/SKILL.md) - Verify before you trust — model pinning, fallbacks, and runtime safety validation.
- [sansfiction-library](https://github.com/openclaw/skills/tree/main/skills/fgbytes/sansfiction-library/SKILL.md) - Authorized SansFiction library manager.
- [screen-vision](https://github.com/openclaw/skills/tree/main/skills/ls18166407597-design/screen-vision/SKILL.md) - macOS Local OCR & Automation Tool using Vision Framework.
- [sequence-cli](https://github.com/openclaw/skills/tree/main/skills/jameslawton/sequence-cli/SKILL.md) - Manage Sequence smart wallets, projects, API keys, ERC20 transfers, and query blockchain data using the Sequence.
- [shipmytoken](https://github.com/openclaw/skills/tree/main/skills/new-ground/shipmytoken/SKILL.md) - Launch Solana tokens on Pumpfun, manage fee sharing, claim earnings, and track portfolio.
- [shipstation-orders](https://github.com/openclaw/skills/tree/main/skills/cprice70/shipstation-orders/SKILL.md) - Monitor ShipStation orders, detect issues, and send alerts.
- [smart-context](https://github.com/openclaw/skills/tree/main/skills/joe3112/smart-context/SKILL.md) - Token-efficient agent behavior — response sizing, context pruning, tool efficiency, and delegation.
- [snipeit-skill](https://github.com/openclaw/skills/tree/main/skills/bivex/snipeit-skill/SKILL.md) - Interact with Snipe-IT asset management via REST API.
- [social-media-extractor](https://github.com/openclaw/skills/tree/main/skills/g4dr/social-media-extractor/SKILL.md) - This skill enables Claude to extract public data from **Instagram**, **TikTok**, and **Reddit**.
- [solana-scanner](https://github.com/openclaw/skills/tree/main/skills/satoshi891102/solana-scanner/SKILL.md) - Scan any Solana token for safety — liquidity, holder concentration, red flags, and rug pull indicators.
- [solana-skills](https://github.com/openclaw/skills/tree/main/skills/spendit-ai/solana-skills/SKILL.md) - Solana wallet operations - create wallets, check balances, send SOL/tokens, swap via Jupiter, launch tokens on Pump.fun.
- [solana-swaps](https://github.com/openclaw/skills/tree/main/skills/imthatcarlos/solana-swaps/SKILL.md) - Swap tokens on Solana via Jupiter aggregator and check wallet balances.
- [solanaprox-ai](https://github.com/openclaw/skills/tree/main/skills/yebdmo2/solanaprox-ai/SKILL.md) - Pay-per-use AI inference via Solana USDC.
- [solpaw-launcher](https://github.com/openclaw/skills/tree/main/skills/lvcidpsyche/solpaw-launcher/SKILL.md) - Launch Solana tokens on Pump.fun via the SolPaw platform. 0.1 SOL one-time fee.
- [solpaw-skill](https://github.com/openclaw/skills/tree/main/skills/lvcidpsyche/solpaw-skill/SKILL.md) - Launch Solana tokens on Pump.fun via the SolPaw platform. 0.1 SOL one-time fee.
- [solpaw-skill-final](https://github.com/openclaw/skills/tree/main/skills/lvcidpsyche/solpaw-skill-final/SKILL.md) - Launch Solana tokens on Pump.fun via the SolPaw platform. 0.1 SOL one-time fee.
- [solpaw-skill-v2](https://github.com/openclaw/skills/tree/main/skills/lvcidpsyche/solpaw-skill-v2/SKILL.md) - Launch Solana tokens on Pump.fun via the SolPaw platform. 0.1 SOL one-time fee.
- [speakturbo-tts](https://github.com/openclaw/skills/tree/main/skills/emzod/speakturbo-tts/SKILL.md) - Give your agent the ability to speak to you real-time.
- [staratheris-arya-model-router](https://github.com/openclaw/skills/tree/main/skills/staratheris/staratheris-arya-model-router/SKILL.md) - Token-saver router: elige modelo (cheap/default/pro) y usa sub-agentes para tareas pesadas.
- [sui](https://github.com/openclaw/skills/tree/main/skills/easonc13/sui/SKILL.md) - Answer questions about Sui blockchain ecosystem, concepts, tokenomics, validators, staking, and general knowledge.
- [switch-modes](https://github.com/openclaw/skills/tree/main/skills/serudda/switch-modes/SKILL.md) - Switch between AI models dynamically to optimize costs and performance.
- [taiwan-calendar](https://github.com/openclaw/skills/tree/main/skills/pigfoot/taiwan-calendar/SKILL.md) - Taiwan calendar query for accurate working day/holiday information.
- [ted-talk](https://github.com/openclaw/skills/tree/main/skills/leegitw/ted-talk/SKILL.md) - Transform technical insights into full 40-50 minute TED-style talks with concrete examples and Q&A.
- [togetherai-tts](https://github.com/openclaw/skills/tree/main/skills/marcus20232023/togetherai-tts/SKILL.md) - Text-to-speech using TogetherAI API with MiniMax speech-2.6-turbo model.
- [token-alert](https://github.com/openclaw/skills/tree/main/skills/r00tid/token-alert/SKILL.md) - 🚨 **Monitor session tokens and get alerts at 75%/90%/95%**.
- [token-guard](https://github.com/openclaw/skills/tree/main/skills/edmonddantesj/token-guard/SKILL.md) - <!-- 🌌 Aoineco-Verified | S-DNA: AOI-2026-0213-SDNA-TG01 -->.
- [tokendraft](https://github.com/openclaw/skills/tree/main/skills/nikzt/tokendraft/SKILL.md) - Full suite for TokenDraft fantasy crypto tournaments — authenticate with a Solana wallet, query/join/auto-join.
- [tokenguard](https://github.com/openclaw/skills/tree/main/skills/g0head/tokenguard/SKILL.md) - API cost guardian for AI agents.
- [tracking](https://github.com/openclaw/skills/tree/main/skills/rzyen-hash/tracking/SKILL.md) - Track tokens on Base chain via GMGN.AI.
- [unclaimed-sol-scanner](https://github.com/openclaw/skills/tree/main/skills/nedim1511/unclaimed-sol-scanner/SKILL.md) - Scan any Solana wallet for reclaimable SOL from dormant token accounts and program buffer accounts.
- [universal-skills-manager](https://github.com/openclaw/skills/tree/main/skills/jacob-bd/universal-skills-manager/SKILL.md) - The master coordinator for AI skills.
- [usdckrump](https://github.com/openclaw/skills/tree/main/skills/arunnadarasa/usdckrump/SKILL.md) - Pay with USDC Krump (USDC.k) via x402 on Story Aeneid EVVM.
- [venice-admin](https://github.com/openclaw/skills/tree/main/skills/sabrinaaquino/venice-admin/SKILL.md) - Venice AI account administration - check balance, view usage history, and manage API keys.
- [vincent-credentials](https://github.com/openclaw/skills/tree/main/skills/glitch003/vincent-credentials/SKILL.md) - Use this skill to securely store credentials (API keys, passwords, tokens) and write them to .env files.
- [voice-recognition](https://github.com/openclaw/skills/tree/main/skills/gykdly/voice-recognition/SKILL.md) - Local speech-to-text with OpenAI Whisper CLI.
- [wallet-api](https://github.com/openclaw/skills/tree/main/skills/andresubri/wallet-api/SKILL.md) - Interact with the BudgetBakers Wallet API for personal finance data.
- [which-llm](https://github.com/openclaw/skills/tree/main/skills/zapkid/which-llm/SKILL.md) - Deterministic decision-ranking API with HTTP 402 USDC payments and outcome credits (discounts).
- [wolfram-alpha](https://github.com/openclaw/skills/tree/main/skills/robert-janssen/wolfram-alpha/SKILL.md) - Perform complex mathematical calculations, physics simulations, data analysis, and scientific queries.
- [x-ai](https://github.com/openclaw/skills/tree/main/skills/blueberrywoodsym/x-ai/SKILL.md) - Chat with Grok models via xAI API.
- [x-alive](https://github.com/openclaw/skills/tree/main/skills/kitakitsune0x/x-alive/SKILL.md) - Bring your AI agent to life on X/Twitter.
- [xian-sdk-skill](https://github.com/openclaw/skills/tree/main/skills/endogen/xian-sdk-skill/SKILL.md) - Build applications on the Xian blockchain using the xian-py Python SDK.
- [zapper](https://github.com/openclaw/skills/tree/main/skills/spirosrap/zapper/SKILL.md) - Query DeFi portfolio data across 50+ chains via Zapper's GraphQL API.
- [zapper-api](https://github.com/openclaw/skills/tree/main/skills/zivhm/zapper-api/SKILL.md) - Query DeFi portfolios, token holdings, NFTs, transactions, and prices via Zapper API.
- [zhipu-asr](https://github.com/openclaw/skills/tree/main/skills/franklu0819-lang/zhipu-asr/SKILL.md) - Automatic Speech Recognition (ASR) using Zhipu AI (BigModel) GLM-ASR model.


### Apple Apps & Services (44 skills)

- [alter-actions](https://github.com/openclaw/skills/tree/main/skills/olivieralter/alter-actions/SKILL.md) - Trigger Alter macOS app actions via x-callback-urls.
- [apple-contacts](https://github.com/openclaw/skills/tree/main/skills/tyler6204/apple-contacts/SKILL.md) - Look up contacts from macOS Contacts.app.
- [apple-find-my-local](https://github.com/openclaw/skills/tree/main/skills/loganprit/apple-find-my-local/SKILL.md) - Control Apple Find My app via Peekaboo to locate people, devices, and items (AirTags)
- [apple-health-skill](https://github.com/openclaw/skills/tree/main/skills/nftechie/apple-health-skill/SKILL.md) - Talk to your Apple Health data — ask questions about your workouts, heart rate, activity rings, and fitness trends.
- [apple-mail-search](https://github.com/openclaw/skills/tree/main/skills/mneves75/apple-mail-search/SKILL.md) - Fast Apple Mail search via SQLite on macOS.
- [apple-music](https://github.com/openclaw/skills/tree/main/skills/tyler6204/apple-music/SKILL.md) - Search Apple Music, add songs to library, manage playlists, control.
- [apple-photos](https://github.com/openclaw/skills/tree/main/skills/tyler6204/apple-photos/SKILL.md) - Apple Photos.app integration for macOS.
- [apple-remind-me](https://github.com/openclaw/skills/tree/main/skills/plgonzalezrx8/apple-remind-me/SKILL.md) - Natural language reminders that create actual Apple.
- [apple-search-ads-skill](https://github.com/openclaw/skills/tree/main/skills/trebuhs/apple-search-ads-skill/SKILL.md) - Manage Apple Search Ads campaigns, ad groups, keywords, and reports via the asa-cli tool.
- [appletv](https://github.com/openclaw/skills/tree/main/skills/lucakaufmann/appletv/SKILL.md) - Control Apple TV via pyatv.
- [callmac](https://github.com/openclaw/skills/tree/main/skills/jooey/callmac/SKILL.md) - Remote voice control for Mac from mobile devices using commands like /callmac.
- [clawdbot-macos-build](https://github.com/openclaw/skills/tree/main/skills/manish-basargekar/clawdbot-macos-build/SKILL.md) - Build the Clawdbot macOS menu bar app.
- [clawdbot-skill-voice-wake-say](https://github.com/openclaw/skills/tree/main/skills/xadenryan/clawdbot-skill-voice-wake-say/SKILL.md) - Speak responses aloud on macOS.
- [drafts](https://github.com/openclaw/skills/tree/main/skills/nerveband/drafts/SKILL.md) - Manage Drafts app notes via CLI on macOS.
- [findmy-location](https://github.com/openclaw/skills/tree/main/skills/poiley/findmy-location/SKILL.md) - Track a shared contact's location via Apple Find.
- [fzf-fuzzy-finder](https://github.com/openclaw/skills/tree/main/skills/arnarsson/fzf-fuzzy-finder/SKILL.md) - Command-line fuzzy finder for interactive filtering.
- [get-focus-mode](https://github.com/openclaw/skills/tree/main/skills/nickchristensen/get-focus-mode/SKILL.md) - Get the current macOS Focus.
- [healthkit-sync](https://github.com/openclaw/skills/tree/main/skills/mneves75/healthkit-sync/SKILL.md) - iOS HealthKit data sync CLI commands and patterns.
- [hergunmac](https://github.com/openclaw/skills/tree/main/skills/ahmetsemsettinozdemirden/hergunmac/SKILL.md) - Access AI-powered football match predictions.
- [homebrew](https://github.com/openclaw/skills/tree/main/skills/thesethrose/homebrew/SKILL.md) - Homebrew package manager for macOS.
- [icloud-findmy](https://github.com/openclaw/skills/tree/main/skills/liamnichols/icloud-findmy/SKILL.md) - Query Find My locations and battery status for family devices.
- [ics-import-on-iphone](https://github.com/openclaw/skills/tree/main/skills/sbhhbs/ics-import-on-iphone/SKILL.md) - Create calendar events by generating valid .ics files when direct calendar access is unavailable.
- [imessage-signal-analyzer](https://github.com/openclaw/skills/tree/main/skills/terellison/imessage-signal-analyzer/SKILL.md) - Analyze iMessage (macOS) and Signal conversation history to reveal relationship dynamics — message volume.
- [inkjet](https://github.com/openclaw/skills/tree/main/skills/aaronchartier/inkjet/SKILL.md) - Print text, images, and QR codes to a wireless Bluetooth thermal printer.
- [mac-notes-agent](https://github.com/openclaw/skills/tree/main/skills/swancho/mac-notes-agent/SKILL.md) - Integrate with the macOS Notes app (Apple Notes)
- [mac-tts](https://github.com/openclaw/skills/tree/main/skills/kalijason/mac-tts/SKILL.md) - Text-to-speech using macOS built-in `say` command.
- [macos-native-automation](https://github.com/openclaw/skills/tree/main/skills/theagentwire/macos-native-automation/SKILL.md) - Hardware-level mouse, keyboard & dialog automation on macOS via CGEvent + AppleScript.
- [managing-apple-notes](https://github.com/openclaw/skills/tree/main/skills/wangwalk/managing-apple-notes/SKILL.md) - Manage Apple Notes from the terminal using the inotes CLI.
- [meow-finder](https://github.com/openclaw/skills/tree/main/skills/abgohel/meow-finder/SKILL.md) - CLI tool to discover AI tools.
- [mh-apple-reminders](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-apple-reminders/SKILL.md) - Manage Apple Reminders via remindctl CLI (list, add, edit, complete, delete)
- [mlx-stt](https://github.com/openclaw/skills/tree/main/skills/guoqiao/mlx-stt/SKILL.md) - Speech-To-Text with MLX (Apple Silicon) and GLM-ASR-Nano-2512 locally.
- [mlx-swift-lm](https://github.com/openclaw/skills/tree/main/skills/ronaldmannak) - MLX Swift LM - Run LLMs and VLMs on Apple Silicon using MLX.
- [mlx-tts](https://github.com/openclaw/skills/tree/main/skills/guoqiao/mlx-tts/SKILL.md) - Text-To-Speech with MLX (Apple Silicon) and opensource models (default QWen3-TTS) locally.
- [mole-mac-cleanup](https://github.com/openclaw/skills/tree/main/skills/bjesuiter/mole-mac-cleanup/SKILL.md) - Mac cleanup & optimization tool combining CleanMyMac.
- [monolith](https://github.com/openclaw/skills/tree/main/skills/slaviquee/monolith/SKILL.md) - Secure crypto wallet for AI agents.
- [my-tesla](https://github.com/openclaw/skills/tree/main/skills/officialpm/my-tesla/SKILL.md) - Control Tesla vehicles from macOS via the Tesla Owner API using teslapy.
- [network-scanner](https://github.com/openclaw/skills/tree/main/skills/florianbeer/network-scanner/SKILL.md) - Scan networks to discover devices, gather MAC addresses.
- [omarchy](https://github.com/openclaw/skills/tree/main/skills/achals-iglu/omarchy/SKILL.md) - Omarchy operating guardrails for day-to-day system work: assume the host is Omarchy by default, choose.
- [pattern-finder](https://github.com/openclaw/skills/tree/main/skills/leegitw/pattern-finder/SKILL.md) - Discover what two sources agree on — find the signal.
- [say](https://github.com/openclaw/skills/tree/main/skills/tobihagemann/say/SKILL.md) - Text-to-Speech via macOS say command with Siri Natural Voices.
- [shortcuts-generator](https://github.com/openclaw/skills/tree/main/skills/erik-agens/shortcuts-skill/SKILL.md) - Generate macOS/iOS Shortcuts by creating plist files.
- [skill-email-management](https://github.com/openclaw/skills/tree/main/skills/latisen/skill-email-management/SKILL.md) - Expert email management assistant for Apple.
- [testflight-monitor](https://github.com/openclaw/skills/tree/main/skills/jon-xo/testflight-monitor/SKILL.md) - Monitor available TestFlight beta slots with smart app lookups and silent batch checking.
- [voice-wake-say](https://github.com/openclaw/skills/tree/main/skills/xadenryan/voice-wake-say/SKILL.md) - Speak responses aloud on macOS using the built-in `say`.


### Browser & Automation (335 skills)

- [1p-shortlink](https://github.com/openclaw/skills/tree/main/skills/tuanpmt/1p-shortlink/SKILL.md) - Create short URLs and submit feature requests using 1p.io.
- [2captcha](https://github.com/openclaw/skills/tree/main/skills/adinvadim/2captcha/SKILL.md) - Solve CAPTCHAs using 2Captcha service.
- [a-share-real-time-data](https://github.com/openclaw/skills/tree/main/skills/wangdinglu/a-share-real-time-data/SKILL.md) - Fetch China A-share stock market data (bars, realtime quotes, tick-by-tick transactions) via mootdx/TDX protocol.
- [aavegotchi-traits](https://github.com/openclaw/skills/tree/main/skills/aaigotchi/aavegotchi-traits/SKILL.md) - Retrieve Aavegotchi NFT data by gotchi ID or name from Base mainnet.
- [abm-outbound](https://github.com/openclaw/skills/tree/main/skills/dru-ca/abm-outbound/SKILL.md) - Multi-channel ABM automation that turns LinkedIn URLs.
- [accessibility-toolkit](https://github.com/openclaw/skills/tree/main/skills/cgtreadw/accessibility-toolkit/SKILL.md) - Friction-reduction patterns for agents helping.
- [acp](https://github.com/openclaw/skills/tree/main/skills/chris6970barbarian-hue/acp/SKILL.md) - Hire specialised agents to handle any task — data analysis, trading, content generation, research, on-chain.
- [activecampaign](https://github.com/openclaw/skills/tree/main/skills/kesslerio/activecampaign/SKILL.md) - ActiveCampaign CRM integration for lead management, deal.
- [adcp-advertising](https://github.com/openclaw/skills/tree/main/skills/edyyy62/adcp-advertising/SKILL.md) - Automate advertising campaigns with AI.
- [admet-prediction](https://github.com/openclaw/skills/tree/main/skills/huifer/admet-prediction/SKILL.md) - ADMET (Absorption, Distribution, Metabolism, Excretion, Toxicity) prediction for drug candidates.
- [Agent Browser](https://github.com/openclaw/skills/tree/main/skills/thesethrose/agent-browser/SKILL.md) - A fast Rust-based headless browser automation CLI.
- [agent-browser](https://github.com/openclaw/skills/tree/main/skills/murphykobe/agent-browser-2/SKILL.md) - Automates browser interactions for web testing, form.
- [agent-daily-planner](https://github.com/openclaw/skills/tree/main/skills/gpunter/agent-daily-planner/SKILL.md) - A structured daily planning and execution tracking system for AI agents.
- [agent-device](https://github.com/openclaw/skills/tree/main/skills/okwasniewski/agent-device/SKILL.md) - Automates interactions for iOS simulators/devices and Android emulators/devices.
- [agent-step-sequencer](https://github.com/openclaw/skills/tree/main/skills/gostlightai/agent-step-sequencer/SKILL.md) - Multi-step scheduler for in-depth agent requests.
- [agent-task-tracker](https://github.com/openclaw/skills/tree/main/skills/rikouu/agent-task-tracker/SKILL.md) - Proactive task state management.
- [agent-zero](https://github.com/openclaw/skills/tree/main/skills/dowingard/agent-zero-bridge/SKILL.md) - Delegate complex coding, research, or autonomous tasks.
- [agentapi](https://github.com/openclaw/skills/tree/main/skills/gizmo-dev/agentapi/SKILL.md) - Browse and search the AgentAPI directory - a curated database of APIs designed for AI agents.
- [agentapi-hub](https://github.com/openclaw/skills/tree/main/skills/gizmo-dev/agentapi-hub/SKILL.md) - Browse and search the AgentAPI directory - a curated database of APIs designed for AI agents.
- [agentaudit](https://github.com/openclaw/skills/tree/main/skills/starbuck100/agentaudit/SKILL.md) - Automatic security gate that checks packages against a vulnerability database before installation.
- [agentaudit-skill](https://github.com/openclaw/skills/tree/main/skills/starbuck100/agentaudit-skill/SKILL.md) - Automatic security gate that checks packages against a vulnerability database before installation.
- [agentmail-integration](https://github.com/openclaw/skills/tree/main/skills/synesthesia-wav/agentmail-integration/SKILL.md) - Integrate AgentMail API for AI agent.
- [agresource](https://github.com/openclaw/skills/tree/main/skills/brianppetty/agresource/SKILL.md) - Use this skill to scrape, summarize, and analyze AgResource grain marketing newsletters.
- [ai-hunter-pro](https://github.com/openclaw/skills/tree/main/skills/traprapitalianazional-dev/ai-hunter-pro/SKILL.md) - A high-performance automation agent that turns global trends into viral social media posts for X (Twitter)
- [ai-meeting-scheduling](https://github.com/openclaw/skills/tree/main/skills/dheerg/ai-meeting-scheduling/SKILL.md) - Booking links fail for groups.
- [ai-news-oracle](https://github.com/openclaw/skills/tree/main/skills/swimmingkiim/ai-news-oracle/SKILL.md) - Fetch real-time AI news briefings from the AI News Oracle API (Hacker News, TechCrunch, The Verge)
- [airtable-automation](https://github.com/openclaw/skills/tree/main/skills/sohamganatra/airtable-automation/SKILL.md) - Automate Airtable tasks via Rube MCP (Composio)
- [airtable-participants](https://github.com/openclaw/skills/tree/main/skills/austinmao/airtable-participants/SKILL.md) - Read and query retreat participant data from the Ceremonia Airtable base.
- [ak-rss-24h-brief](https://github.com/openclaw/skills/tree/main/skills/seandong/ak-rss-24h-brief/SKILL.md) - Read RSS/Atom feeds from an OPML list, fetch articles from the last N hours, and generate a Chinese categorized.
- [amazon-product-search-api-skill](https://github.com/openclaw/skills/tree/main/skills/phheng/amazon-product-search-api-skill/SKILL.md) - This skill is designed to help users automatically extract product data from Amazon search results.
- [amazon-reviews-api-skill](https://github.com/openclaw/skills/tree/main/skills/phheng/amazon-reviews-api-skill/SKILL.md) - This skill helps users automatically extract Amazon product reviews via the Amazon Reviews API.
- [amazon-shopper](https://github.com/openclaw/skills/tree/main/skills/brennerspear/amazon-shopper/SKILL.md) - Buy and return items on Amazon using browser automation.
- [android-adb](https://github.com/openclaw/skills/tree/main/skills/staticai/android-adb/SKILL.md) - Control Android devices via ADB with support for UI layout analysis.
- [anycrawl](https://github.com/openclaw/skills/tree/main/skills/techlaai/anycrawl/SKILL.md) - AnyCrawl API integration for OpenClaw - Scrape, Crawl, and Search web.
- [aoi-hackathon-scout-lite](https://github.com/openclaw/skills/tree/main/skills/edmonddantesj/aoi-hackathon-scout-lite/SKILL.md) - Public-safe hackathon source registry + filtering output (no crawling, no submissions).
- [api-tester](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/api-tester/SKILL.md) - Perform structured HTTP/HTTPS requests (GET, POST, PUT, DELETE) with custom headers and JSON body support.
- [apify-lead-generation](https://github.com/openclaw/skills/tree/main/skills/jirispilka/apify-lead-generation/SKILL.md) - Generates B2B/B2C leads by scraping Google.
- [apiosk](https://github.com/openclaw/skills/tree/main/skills/obcraft/apiosk/SKILL.md) - **Pay-per-request API access for agents.
- [appstore-rating-pulse](https://github.com/openclaw/skills/tree/main/skills/aligurelli/appstore-rating-pulse/SKILL.md) - Monitor App Store ratings for any iOS app across multiple countries.
- [arxiv-1-0-1](https://github.com/openclaw/skills/tree/main/skills/tariqsumatri82/arxiv-1-0-1/SKILL.md) - Search, fetch, and analyze academic papers from arXiv.org directly from your AI assistant.
- [arxiv-skill-learning](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/arxiv-skill-learning/SKILL.md) - Orchestrates the continuous learning of new skills from arXiv papers.
- [asr](https://github.com/openclaw/skills/tree/main/skills/ilyakam/asr/SKILL.md) - Fast, accurate, and incredibly inexpensive automatic speech-to-text.
- [atl-mobile](https://github.com/openclaw/skills/tree/main/skills/jordancoin/atl-mobile/SKILL.md) - Mobile browser and native app automation via ATL (iOS Simulator).
- [audiomind](https://github.com/openclaw/skills/tree/main/skills/wells1137/audiomind/SKILL.md) - The ultimate AI audio generation skill.
- [auto-context-manager](https://github.com/openclaw/skills/tree/main/skills/imraxy/auto-context-manager/SKILL.md) - AI-powered automatic project context management.
- [auto-dealer-marketing](https://github.com/openclaw/skills/tree/main/skills/lazralabs-eng/auto-dealer-marketing/SKILL.md) - When the user wants to create, optimize, or plan automotive dealership marketing — including inventory.
- [auto-updater](https://github.com/openclaw/skills/tree/main/skills/maximeprades/auto-updater/SKILL.md) - Automatically update Clawdbot and all installed skills once.
- [autofillin](https://github.com/openclaw/skills/tree/main/skills/leohan123123/autofillin/SKILL.md) - Automated web form filling and file uploading skill.
- [automation-workflows](https://github.com/openclaw/skills/tree/main/skills/jk-0001/automation-workflows/SKILL.md) - Design and implement automation workflows to save.
- [autonomy-windowed](https://github.com/openclaw/skills/tree/main/skills/luciusrockwing/autonomy-windowed/SKILL.md) - Time-windowed autonomous task queue.
- [babyconnect](https://github.com/openclaw/skills/tree/main/skills/kesslerio/babyconnect/SKILL.md) - ActiveCampaign CRM integration for lead management, deal tracking.
- [bamboohr-automation](https://github.com/openclaw/skills/tree/main/skills/sohamganatra/bamboohr-automation/SKILL.md) - Automate BambooHR tasks via Rube MCP (Composio)
- [baseball](https://github.com/openclaw/skills/tree/main/skills/khaney64/baseball/SKILL.md) - Fetch MLB game schedules, live game status, box scores, player search, and season statistics via the MLB Stats API.
- [basecamp-automation](https://github.com/openclaw/skills/tree/main/skills/sohamganatra/basecamp-automation/SKILL.md) - Automate Basecamp project management, to-dos.
- [basecred](https://github.com/openclaw/skills/tree/main/skills/callmedas69/basecred/SKILL.md) - Fetch onchain reputation profiles via BaseCred SDK (Ethos, Talent Protocol, Farcaster/Neynar)
- [bitaxe-monitor](https://github.com/openclaw/skills/tree/main/skills/pietro395/bitaxe-monitor/SKILL.md) - Monitor Bitaxe Gamma Bitcoin miner status via HTTP API.
- [bits](https://github.com/openclaw/skills/tree/main/skills/robbiethompson18/bits/SKILL.md) - Control browser automation agents via the Bits MCP server.
- [book-brain-visual-reader](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/book-brain-visual-reader/SKILL.md) - Enhanced BOOK BRAIN for LYGO Havens with visual capability.
- [book-fetch](https://github.com/openclaw/skills/tree/main/skills/zerone0x/book-fetch/SKILL.md) - Download ebooks (epub/pdf) from Anna's Archive and upload them to MEGA automatically.
- [bookmark-intelligence](https://github.com/openclaw/skills/tree/main/skills/bkrigmo1/bookmark-intelligence/SKILL.md) - Turns X bookmarks into actionable insights.
- [box-automation](https://github.com/openclaw/skills/tree/main/skills/sohamganatra/box-automation/SKILL.md) - Automate Box cloud storage operations including file.
- [brain-search](https://github.com/openclaw/skills/tree/main/skills/ryandeangraves/brain-search/SKILL.md) - **You MUST actually execute every curl command using your shell/exec tool.** Read the real HTTP response.
- [browser-ladder](https://github.com/openclaw/skills/tree/main/skills/ktpriyatham/browser-ladder/SKILL.md) - Climb the browser ladder — start free, escalate.
- [browser-use](https://github.com/openclaw/skills/tree/main/skills/shawnpana/browser-use/SKILL.md) - Use Browser Use cloud API to spin up cloud browsers for Clawdbot.
- [browsh](https://github.com/openclaw/skills/tree/main/skills/gumadeiras/browsh/SKILL.md) - A modern text-based browser.
- [brw-linkedin-authority-builder](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-linkedin-authority-builder/SKILL.md) - Build a LinkedIn content system for thought leadership.
- [brw-linkedin-authority-builder-1-0-0](https://github.com/openclaw/skills/tree/main/skills/rezcarbon/brw-linkedin-authority-builder-1-0-0/SKILL.md) - Build a LinkedIn content system for thought leadership.
- [btc-analyzer](https://github.com/openclaw/skills/tree/main/skills/newbienodes/btc-analyzer/SKILL.md) - Fetch live BTCUSDT 15m candles from Binance public API and analyze market direction UP/DOWN/SKIP using EMA20.
- [bybit-order-book](https://github.com/openclaw/skills/tree/main/skills/davidm413/bybit-order-book/SKILL.md) - Download, process, and backtest ByBit derivatives historical order book data.
- [cal-com-automation](https://github.com/openclaw/skills/tree/main/skills/sohamganatra/cal-com-automation/SKILL.md) - Automate Cal.com tasks via Rube MCP (Composio)
- [camoufox](https://github.com/openclaw/skills/tree/main/skills/goodgoodjm/camoufox/SKILL.md) - Anti-detect browser automation using Camoufox (Firefox-based).
- [catime](https://github.com/openclaw/skills/tree/main/skills/yazelin/catime/SKILL.md) - Fetch and send AI-generated hourly cat images.
- [ccxt](https://github.com/openclaw/skills/tree/main/skills/pcriadoperez/ccxt/SKILL.md) - Interact with 100+ cryptocurrency exchanges — fetch markets, order books, tickers, place orders, check balances.
- [cdp-browser](https://github.com/openclaw/skills/tree/main/skills/gostlightai/cdp-browser/SKILL.md) - CDP browser control at localhost:9222.
- [claude-cost-cli](https://github.com/openclaw/skills/tree/main/skills/cyberash-dev/claude-cost-cli/SKILL.md) - Query Claude API usage and cost reports from the command line.
- [claude-usage-cli](https://github.com/openclaw/skills/tree/main/skills/cyberash-dev/claude-usage-cli/SKILL.md) - Query Claude API usage and cost reports from the command line.
- [client-communication-engine](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/client-communication-engine/SKILL.md) - Greek-language client correspondence — submission confirmations, summaries, document requests, reminders.
- [client-data-management](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/client-data-management/SKILL.md) - Secure client database for Greek accounting firms.
- [client-flow](https://github.com/openclaw/skills/tree/main/skills/ariktulcha/client-flow/SKILL.md) - Automated client onboarding and project lifecycle management.
- [cls-news-scraper](https://github.com/openclaw/skills/tree/main/skills/ningjingzhiyuande/cls-news-scraper/SKILL.md) - Use this skill to pull real-time market news from Cailian Press (CLS) and extract stock-positive catalysts.
- [cn-ecommerce-search](https://github.com/openclaw/skills/tree/main/skills/shopmeskills/cn-ecommerce-search/SKILL.md) - Search products across 8 Chinese e-commerce platforms: Taobao, Tmall, JD, PDD, 1688, AliExpress, Douyin, XHS.
- [cocod](https://github.com/openclaw/skills/tree/main/skills/egge21m/cocod/SKILL.md) - A Cashu ecash wallet CLI for Bitcoin and Lightning payments.
- [coda-io](https://github.com/openclaw/skills/tree/main/skills/simonfunk/coda-io/SKILL.md) - Interact with Coda.io docs, tables, rows, pages, and automations via the Coda REST API v1.
- [code-stats](https://github.com/openclaw/skills/tree/main/skills/autogame-17/code-stats/SKILL.md) - Visualizes repository complexity by counting files, lines of code, and grouping by extension.
- [code-stats](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/code-stats/SKILL.md) - Visualizes repository complexity by counting files, lines of code, and grouping by extension.
- [code-tester](https://github.com/openclaw/skills/tree/main/skills/frhn9/code-tester/SKILL.md) - Build, run, and test code projects for Rust, Go, and Java.
- [coingecko](https://github.com/openclaw/skills/tree/main/skills/olisim02/coingecko/SKILL.md) - Fetch crypto prices, market data, and token info from the CoinGecko free API.
- [comonyx-admin](https://github.com/openclaw/skills/tree/main/skills/waqas-orcalo/comonyx-admin/SKILL.md) - Admin skill to sign into Cosmonyx, fetch companies, filter/export (PDF or Excel), optionally email the export.
- [cputemp](https://github.com/openclaw/skills/tree/main/skills/rhcit/cputemp/SKILL.md) - Fetch real-time stock quotes from Yahoo Finance.
- [curlship](https://github.com/openclaw/skills/tree/main/skills/marcindudekdev/curlship/SKILL.md) - Submit products to CurlShip, the bot-friendly SaaS directory.
- [daily-dev-agentic](https://github.com/openclaw/skills/tree/main/skills/idoshamun/daily-dev-agentic/SKILL.md) - daily.dev Agentic Learning - continuous self-improvement through daily.dev feeds.
- [daily-news](https://github.com/openclaw/skills/tree/main/skills/ym2760184260/daily-news/SKILL.md) - Fetch top news from Baidu, Google, and other sources daily.
- [db-readonly](https://github.com/openclaw/skills/tree/main/skills/reed1898/db-readonly/SKILL.md) - Run safe read-only queries against MySQL or PostgreSQL for data inspection, reporting, and troubleshooting.
- [db-readonly](https://github.com/openclaw/skills/tree/main/skills/ryanhong666/db-readonly/SKILL.md) - Run safe read-only queries against MySQL or PostgreSQL for data inspection, reporting, and troubleshooting.
- [desearch-x-search](https://github.com/openclaw/skills/tree/main/skills/okradze/desearch-x-search/SKILL.md) - Search X (Twitter) in real time.
- [doro-command-creator](https://github.com/openclaw/skills/tree/main/skills/a2mus/doro-command-creator/SKILL.md) - WHAT: Create Claude Code slash commands - reusable markdown workflows invoked with /command-name.
- [dune-analytics-api](https://github.com/openclaw/skills/tree/main/skills/lz-web3/dune-analytics-api/SKILL.md) - Dune Analytics API for blockchain data queries.
- [echo-repeater](https://github.com/openclaw/skills/tree/main/skills/theeightt/echo-repeater/SKILL.md) - Echo the user's input back to them with optional formatting like "Echo:" or "You said:" as a prefix.
- [edstem](https://github.com/openclaw/skills/tree/main/skills/axel5o5/edstem/SKILL.md) - Fetch, sync, and organize EdStem discussion threads for any course or institution.
- [entity-optimizer](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/entity-optimizer/SKILL.md) - Use when the user asks to "optimize entity presence", "build knowledge graph", "improve knowledge panel", "entity.
- [epstein-emails](https://github.com/openclaw/skills/tree/main/skills/blockboy32/epstein-emails/SKILL.md) - Query 383,000+ court-released Epstein emails via a pay-per-request API.
- [erpnext-frappe](https://github.com/openclaw/skills/tree/main/skills/ravana-indus/erpnext-frappe/SKILL.md) - High-level business workflows that combine multiple MCP tools into reusable, executable skills for ERPNext.
- [error-driven-evolution](https://github.com/openclaw/skills/tree/main/skills/marsnavi/error-driven-evolution/SKILL.md) - Structured error-to-rule learning system for AI agents.
- [evomap](https://github.com/openclaw/skills/tree/main/skills/segasonicye/evomap/SKILL.md) - Connect to the EvoMap collaborative evolution marketplace.
- [exa-tool](https://github.com/openclaw/skills/tree/main/skills/claireaicodes/exa-tool/SKILL.md) - Exa MCP integration for advanced search, research, and crawling.
- [external-ki-integration-backup](https://github.com/openclaw/skills/tree/main/skills/konscious0beast/external-ki-integration-backup/SKILL.md) - Skill for accessing external AI services (ChatGPT, Claude, Hugging Face, etc.) via browser automation (Chrome Relay)
- [fastfold-ai-fold](https://github.com/openclaw/skills/tree/main/skills/juliocesar-io/fastfold-ai-fold/SKILL.md) - Submits and manages FastFold protein folding jobs via the Jobs API.
- [fatsecret](https://github.com/openclaw/skills/tree/main/skills/f-liva/fatsecret/SKILL.md) - FatSecret nutrition API integration for food search, nutritional lookup, barcode scanning, recipe search, and food.
- [feed-digest](https://github.com/openclaw/skills/tree/main/skills/odysseus0/feed-digest/SKILL.md) - Agentic feed digest using the feed CLI.
- [feishu-bitable-creator](https://github.com/openclaw/skills/tree/main/skills/gaowanqi08141999/feishu-bitable-creator/SKILL.md) - Create and populate Feishu (Lark) Bitable (multidimensional tables) with automated cleanup.
- [feishu-meeting-assistant](https://github.com/openclaw/skills/tree/main/skills/autogame-17/feishu-meeting-assistant/SKILL.md) - Scans your Feishu Calendar for upcoming events with attached documents (Doc, Sheet, Bitable), reads their content.
- [feishu-sheets](https://github.com/openclaw/skills/tree/main/skills/wesley138cn/feishu-sheets/SKILL.md) - Feishu online spreadsheet (Sheets) operations including create, read, write, append data, manage worksheets.
- [feishu-sheets-skill](https://github.com/openclaw/skills/tree/main/skills/wesley138cn/feishu-sheets-skill/SKILL.md) - Feishu online spreadsheet (Sheets) operations including create, read, write, append data, manage worksheets.
- [fin-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/fin-cog/SKILL.md) - Wall Street-grade analysis, accessible globally.
- [firefly](https://github.com/openclaw/skills/tree/main/skills/codes71/firefly/SKILL.md) - Fetch meeting transcripts, summaries, and action items from Firefly AI (fireflies.ai)
- [free-a-share-real-time-data](https://github.com/openclaw/skills/tree/main/skills/wangdinglu/free-a-share-real-time-data/SKILL.md) - Fetch China A-share stock market data (bars, realtime quotes, tick-by-tick transactions) via mootdx/TDX protocol.
- [ft-reader](https://github.com/openclaw/skills/tree/main/skills/zhouziyue233/ft-reader/SKILL.md) - Use this skill to perform deep, structured, and bilingual analysis of top articles from Financial Times (ft.com).
- [fxtwitter](https://github.com/openclaw/skills/tree/main/skills/namphamdev/fxtwitter/SKILL.md) - Fetch tweet/post data from X (Twitter) links using the fxTwitter API (api.fxtwitter.com)
- [geo-content-optimizer](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/geo-content-optimizer/SKILL.md) - Use when the user asks to "optimize for AI", "get cited by ChatGPT", "AI optimization", "appear in AI answers".
- [geometry](https://github.com/openclaw/skills/tree/main/skills/geometrydotsh/geometry/SKILL.md) - Generate AI images from text prompts.
- [get-kalshi-live-games](https://github.com/openclaw/skills/tree/main/skills/kanakamedalasumanth/get-kalshi-live-games/SKILL.md) - Fetch currently live Kalshi sports markets using the browser.
- [glm-image](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/glm-image/SKILL.md) - Generate images using GLM-Image API.
- [goal-tracker](https://github.com/openclaw/skills/tree/main/skills/alti-systems/goal-tracker/SKILL.md) - Track long-term goals with milestones, daily logging, and accountability.
- [goldenseed](https://github.com/openclaw/skills/tree/main/skills/beanapologist/goldenseed/SKILL.md) - Deterministic entropy streams for reproducible testing and procedural generation.
- [gotchi-finder](https://github.com/openclaw/skills/tree/main/skills/aaigotchi/gotchi-finder/SKILL.md) - Fetch Aavegotchi by ID from Base mainnet and display image with full traits.
- [goyfiles-epstein](https://github.com/openclaw/skills/tree/main/skills/davfd/goyfiles-epstein/SKILL.md) - Core GOYFILES external-bot contract (endpoint-first onboarding, strict agent behavior, direct tool mode.
- [grago](https://github.com/openclaw/skills/tree/main/skills/solsuk/grago/SKILL.md) - **Delegate research and data-fetch tasks to a free local LLM.
- [grok-browser](https://github.com/openclaw/skills/tree/main/skills/easonc13/grok-browser/SKILL.md) - Query Grok AI via browser automation.
- [guicountrol](https://github.com/openclaw/skills/tree/main/skills/dreamtraveler13/guicountrol/SKILL.md) - Control the Linux desktop GUI using xdotool, wmctrl, and dogtail.
- [hfnews](https://github.com/openclaw/skills/tree/main/skills/huberteff/hfnews/SKILL.md) - Fetch and filter news from multiple sources with stopwords/blacklist support.
- [hi](https://github.com/openclaw/skills/tree/main/skills/roman181/hi/SKILL.md) - Captures learnings, errors, and corrections to enable continuous improvement.
- [hive-mind](https://github.com/openclaw/skills/tree/main/skills/lilyjazz/hive-mind/SKILL.md) - Sync memories across multiple agents using a shared TiDB Zero database.
- [hle-benchmark-evolver](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/hle-benchmark-evolver/SKILL.md) - Runs HLE-oriented benchmark reward ingestion and curriculum generation for capability-evolver.
- [huggingface-trends](https://github.com/openclaw/skills/tree/main/skills/tianxingleo/huggingface-trends/SKILL.md) - Monitor and fetch trending models from Hugging Face with support for filtering by task, library, and popularity.
- [image-enhancer](https://github.com/openclaw/skills/tree/main/skills/wells1137/image-enhancer/SKILL.md) - Improves the quality of images, especially screenshots, by enhancing resolution, sharpness, and clarity.
- [imprettyamazing](https://github.com/openclaw/skills/tree/main/skills/macksmind/imprettyamazing/SKILL.md) - Interact with I'm Pretty Amazing (imprettyamazing.com) — a platform for tracking and celebrating accomplishments.
- [index-cards](https://github.com/openclaw/skills/tree/main/skills/jonwheatley/index-cards/SKILL.md) - Send real, physical greeting cards through the mail.
- [input-classification-v1](https://github.com/openclaw/skills/tree/main/skills/omprasad122007-rgb/input-classification-v1/SKILL.md) - Deterministic rule-based system for classifying clarified input into a single primary task category and assigning.
- [instagram-scraper](https://github.com/openclaw/skills/tree/main/skills/arulmozhiv/instagram-scraper/SKILL.md) - A browser-based Instagram profile discovery and scraping tool.
- [interesting-finding](https://github.com/openclaw/skills/tree/main/skills/zerone0x/interesting-finding/SKILL.md) - Process links and content shared in the #interesting-finding Discord channel.
- [invoice-collector](https://github.com/openclaw/skills/tree/main/skills/mintannn/invoice-collector/SKILL.md) - Collect invoices/receipts from Gmail and send a summary email with attachments.
- [ipfs-client](https://github.com/openclaw/skills/tree/main/skills/apexfork/ipfs-client/SKILL.md) - Read-only IPFS queries — fetch files, inspect metadata, explore DAGs, and resolve IPNS names via local or public.
- [iserv](https://github.com/openclaw/skills/tree/main/skills/finnbusse/iserv/SKILL.md) - HTTP client for IServ school platforms.
- [itinerary-carousel-post](https://github.com/openclaw/skills/tree/main/skills/psyduckler/itinerary-carousel-post/SKILL.md) - Create and publish an Instagram carousel post from a tabiji.ai itinerary.
- [itinerary-carousel-post-topaz](https://github.com/openclaw/skills/tree/main/skills/psyduckler/itinerary-carousel-post-topaz/SKILL.md) - Create and publish an Instagram carousel post from a tabiji.ai itinerary, with Topaz Labs AI image enhancement.
- [iyeque-device-control](https://github.com/openclaw/skills/tree/main/skills/iyeque/iyeque-device-control/SKILL.md) - Expose safe device actions (volume, brightness, open/close apps) for personal automation.
- [jarvis-api-contract-guard-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-api-contract-guard-01/SKILL.md) - Design and verify API contracts for backward compatibility.
- [jarvis-bug-triage-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-bug-triage-01/SKILL.md) - Triage production bugs fast with repro isolation and risk-first fixes.
- [jarvis-ci-flake-hunter-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-ci-flake-hunter-01/SKILL.md) - Track and reduce flaky tests with deterministic isolation.
- [jarvis-db-query-doctor-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-db-query-doctor-01/SKILL.md) - Diagnose slow SQL and rewrite queries for safer performance.
- [jarvis-migration-risk-radar-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-migration-risk-radar-01/SKILL.md) - Assess migration risk and design staged rollouts.
- [jarvis-persona-style-calibrator-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-persona-style-calibrator-01/SKILL.md) - Calibrate assistant personality to voice, boundaries, and audience context.
- [jarvis-test-gap-finder-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-test-gap-finder-01/SKILL.md) - Find missing tests by failure mode and business impact.
- [jobs-ive](https://github.com/openclaw/skills/tree/main/skills/stubbi/jobs-ive/SKILL.md) - Channel the combined product philosophy of Steve Jobs and Jony Ive to make product, design, messaging, naming.
- [jup-skill](https://github.com/openclaw/skills/tree/main/skills/lifeofpavs/jup-skill/SKILL.md) - Execute Jupiter API operations on Solana - fetch quotes, sign transactions, execute swaps, prediction markets.
- [level-design-patterns](https://github.com/openclaw/skills/tree/main/skills/cryptorabea/level-design-patterns/SKILL.md) - Use when creating Unity game scenes and prototypes, building level designs, or automating Unity Editor workflows.
- [lifi-skill](https://github.com/openclaw/skills/tree/main/skills/fabriziogianni7/lifi-skill/SKILL.md) - v4 - Use LI.FI API for cross-chain and same-chain swaps, bridges, and contract calls.
- [lightningprox](https://github.com/openclaw/skills/tree/main/skills/unixlamadev-spec/lightningprox/SKILL.md) - Pay-per-request AI model access via Bitcoin Lightning using prepaid spend tokens.
- [line-oa](https://github.com/openclaw/skills/tree/main/skills/picseeinc/line-oa/SKILL.md) - Operate LINE Official Account Manager (chat.line.biz) via browser automation.
- [link-digest](https://github.com/openclaw/skills/tree/main/skills/zerone0x/link-digest/SKILL.md) - Process links and content shared in a designated 'interesting findings' Discord channel.
- [linux-desktop](https://github.com/openclaw/skills/tree/main/skills/ouyangabel/linux-desktop/SKILL.md) - Linux desktop automation and control.
- [linz-public-transport](https://github.com/openclaw/skills/tree/main/skills/fjrevoredo/linz-public-transport/SKILL.md) - Query Linz Linien raw EFA endpoints for stop lookup and live departures.
- [lnget](https://github.com/openclaw/skills/tree/main/skills/roasbeef/lnget/SKILL.md) - Install and use lnget, a Lightning-native HTTP client with automatic L402 payment support.
- [lofy-fitness](https://github.com/openclaw/skills/tree/main/skills/harrey401/lofy-fitness/SKILL.md) - Fitness accountability for the Lofy AI assistant — workout logging from natural language, meal tracking.
- [logistics-tracking](https://github.com/openclaw/skills/tree/main/skills/shopmeskills/logistics-tracking/SKILL.md) - Track international packages by tracking number.
- [lygo-guardian-p0-stack](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-guardian-p0-stack/SKILL.md) - LYGO Guardian base skill – Nano-Kernel (P0.4), Understanding Heart (P0.5), and Light Math harmony as a portable.
- [lyrical-fable](https://github.com/openclaw/skills/tree/main/skills/sanzgiri/lyrical-fable/SKILL.md) - Create short lyrical fables (~1000 words) about historical, fictional, or mythological characters in the style.
- [mac-control](https://github.com/openclaw/skills/tree/main/skills/easonc13/mac-control/SKILL.md) - Control Mac via mouse/keyboard automation using cliclick and AppleScript.
- [mac-use](https://github.com/openclaw/skills/tree/main/skills/kekejun/mac-use/SKILL.md) - Control macOS GUI apps visually — take screenshots, click, scroll, type.
- [macos-calendar](https://github.com/openclaw/skills/tree/main/skills/lucaperret/macos-calendar/SKILL.md) - Create, list, and manage macOS Calendar events via AppleScript.
- [macos-reminders](https://github.com/openclaw/skills/tree/main/skills/lucaperret/macos-reminders/SKILL.md) - Create, list, and manage macOS Reminders via AppleScript.
- [map-grabber](https://github.com/openclaw/skills/tree/main/skills/qrost/map-grabber/SKILL.md) - Fetch OpenStreetMap vector data (streets, buildings) for an address and export to SVG, GeoPackage, or DXF for CAD/Rhino.
- [market-pulse](https://github.com/openclaw/skills/tree/main/skills/lopushok9/market-pulse/SKILL.md) - Use when user asks about crypto prices, DeFi yields, market sentiment, fear and greed index, stock prices, upcoming.
- [market-snapshot](https://github.com/openclaw/skills/tree/main/skills/nicholasoxford/market-snapshot/SKILL.md) - Fetch a token market snapshot (price/liquidity/volume) and return stable JSON (backed by Jupiter).
- [market-test-price](https://github.com/openclaw/skills/tree/main/skills/li-zoe-x/market-test-price/SKILL.md) - Fetch token prices from OKX DEX Market Price API (v6)
- [math-worksheets](https://github.com/openclaw/skills/tree/main/skills/trondw/math-worksheets/SKILL.md) - Generate professional math practice worksheets and full answer keys as PDFs.
- [mcp-chrome](https://github.com/openclaw/skills/tree/main/skills/femto/mcp-chrome/SKILL.md) - Control Chrome browser with AI using MCP protocol.
- [mealie](https://github.com/openclaw/skills/tree/main/skills/g1mb01d/mealie/SKILL.md) - Interact with a self‑hosted Mealie instance (recipe manager & meal planner) via its REST API.
- [meeting-notes-pro](https://github.com/openclaw/skills/tree/main/skills/olivermonneke/meeting-notes-pro/SKILL.md) - You are a meeting productivity expert.
- [memberstack-cli](https://github.com/openclaw/skills/tree/main/skills/bensabic/memberstack-cli/SKILL.md) - Use the Memberstack CLI to manage Memberstack accounts from the terminal.
- [meta-fb-inbox](https://github.com/openclaw/skills/tree/main/skills/picseeinc/meta-fb-inbox/SKILL.md) - Check Facebook page inbox messages via Meta Business Suite browser automation.
- [metengine-data-agent](https://github.com/openclaw/skills/tree/main/skills/saviour1001/metengine-data-agent/SKILL.md) - Real-time smart money analytics API for Polymarket prediction markets, Hyperliquid perpetual futures, and Meteora.
- [mh-notion](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-notion/SKILL.md) - Notion API for creating and managing pages, databases, and blocks.
- [minimal-memory](https://github.com/openclaw/skills/tree/main/skills/zencrust-ai/minimal-memory/SKILL.md) - Maintain clean, efficient memory files with GOOD/BAD/NEUTRAL categorization and semantic search.
- [minimax-speech](https://github.com/openclaw/skills/tree/main/skills/wingchiu/minimax-speech/SKILL.md) - Manage MiniMax Speech 2.8 T2A (text-to-audio) and voice catalog lookups.
- [mukt](https://github.com/openclaw/skills/tree/main/skills/hgosansn/mukt/SKILL.md) - Zero-cost OpenRouter responder that auto-discovers the best currently free model, retries on failures, and returns.
- [multilogin](https://github.com/openclaw/skills/tree/main/skills/glebkazachinskiy/multilogin/SKILL.md) - Use when you need to manage Multilogin X browser profiles — launch quick disposable profiles, list/start/stop saved.
- [multiloginx](https://github.com/openclaw/skills/tree/main/skills/multilogincom/multiloginx/SKILL.md) - Use when you need to manage Multilogin X browser profiles — launch quick disposable profiles, list/start/stop saved.
- [mupibox-media-db](https://github.com/openclaw/skills/tree/main/skills/tomquist/mupibox-media-db/SKILL.md) - Manage MuPiBox media database (data.json) through the MuPiBox backend API: list, add, remove, move, edit fields.
- [my-nano-image](https://github.com/openclaw/skills/tree/main/skills/namebekc/my-nano-image/SKILL.md) - Generate/edit images with Nano Banana Pro (Gemini 3 Pro Image)
- [native-airtable](https://github.com/openclaw/skills/tree/main/skills/codeninja23/native-airtable/SKILL.md) - Read Airtable bases, tables, and records directly via the Airtable API.
- [naverstock-skill](https://github.com/openclaw/skills/tree/main/skills/seungdols/naverstock-skill/SKILL.md) - Fetch text-based real-time stock prices (KRX, Overseas) using Naver Finance.
- [nba-data-analytics](https://github.com/openclaw/skills/tree/main/skills/project-aeris-disaster-agent/nba-data-analytics/SKILL.md) - Request NBA sports data (schedule, boxscore, standings, injuries, roster, etc.) from the Daredevil seller.
- [nblm](https://github.com/openclaw/skills/tree/main/skills/magicseek/nblm/SKILL.md) - Use this skill to query your Google NotebookLM notebooks directly from Claude Code for source-grounded.
- [near-qr-skill](https://github.com/openclaw/skills/tree/main/skills/ussyalfaks/near-qr-skill/SKILL.md) - Generate QR codes for NEAR addresses and payment requests, and read NEAR QR codes from images.
- [ned-analytics](https://github.com/openclaw/skills/tree/main/skills/matt998759/ned-analytics/SKILL.md) - Query your Shopify store's sales, profitability, customers, and marketing data through Ned's API.
- [neynar-inbox](https://github.com/openclaw/skills/tree/main/skills/rishavmukherji/neynar-inbox/SKILL.md) - Email for AI agents.
- [norman-manage-clients](https://github.com/openclaw/skills/tree/main/skills/stanlee000/norman-manage-clients/SKILL.md) - Manage business clients - list, search, create, or update client information.
- [nova](https://github.com/openclaw/skills/tree/main/skills/synthluvr/nova/SKILL.md) - Safely operate the nova CLI wallet for authentication, balance checks, sending funds, withdrawals, and key.
- [nova-act](https://github.com/openclaw/skills/tree/main/skills/zouchaoqun/nova-act/SKILL.md) - Write and execute Python scripts using Amazon Nova Act for AI-powered browser automation tasks like flight.
- [nso-macro-monitor](https://github.com/openclaw/skills/tree/main/skills/ndtchan/nso-macro-monitor/SKILL.md) - Monitors official Vietnam NSO monthly and quarterly socio-economic releases and compares same-period trends; used.
- [obverse-payments](https://github.com/openclaw/skills/tree/main/skills/ofuzorchukwuemeke/obverse-payments/SKILL.md) - End-to-end stablecoin payments — links, invoices, receipts, dashboards — across Telegram, WhatsApp, Discord.
- [ogment-agentic-cli](https://github.com/openclaw/skills/tree/main/skills/asoviche/ogment-agentic-cli/SKILL.md) - Access business integrations (SaaS, APIs, data) securely through Ogment.
- [ohio-state-api](https://github.com/openclaw/skills/tree/main/skills/sichengchen/ohio-state-api/SKILL.md) - Get public data from The Ohio State University Content APIs (content.osu.edu) across campus services (bus.
- [ontario-course-planning](https://github.com/openclaw/skills/tree/main/skills/icej/ontario-course-planning/SKILL.md) - Ontario (Canada) high school course planning (Grades 9–12) aligned to university admissions and Top 6 (12U/M)
- [open-chrome-tabs](https://github.com/openclaw/skills/tree/main/skills/mindsocket/open-chrome-tabs/SKILL.md) - Read currently open browser tabs from Chrome or other Chromium browsers (Arc, Brave, Edge, etc.)
- [openkrill](https://github.com/openclaw/skills/tree/main/skills/emilankerwiik/openkrill/SKILL.md) - Enable AI agents to make micropayments via x402 protocol.
- [openrouter-usage](https://github.com/openclaw/skills/tree/main/skills/rosseyre/openrouter-usage/SKILL.md) - Fetch real-time OpenRouter usage totals and historical per-model spend.
- [ordiscan](https://github.com/openclaw/skills/tree/main/skills/t4t5/ordiscan/SKILL.md) - Inscribe content on Bitcoin via the Ordiscan API.
- [ore-miner](https://github.com/openclaw/skills/tree/main/skills/jusscubs/ore-miner/SKILL.md) - Autonomous ORE mining on Solana via refinORE.
- [org-memory](https://github.com/openclaw/skills/tree/main/skills/dcprevere/org-memory/SKILL.md) - Structured knowledge base and task management using org-mode files.
- [osv-scanner](https://github.com/openclaw/skills/tree/main/skills/moenassi/osv-scanner/SKILL.md) - change ScanResult file extension from txt -> xlsx located in template.
- [otta-cli](https://github.com/openclaw/skills/tree/main/skills/mekedron/otta-cli/SKILL.md) - Use `otta-cli` to automate `otta.fi` workflows from terminal.
- [outsmart-lp-sniping](https://github.com/openclaw/skills/tree/main/skills/outsmartchad/outsmart-lp-sniping/SKILL.md) - Buy tokens at or near LP creation on Solana.
- [paper-notion-summarizer](https://github.com/openclaw/skills/tree/main/skills/lococaeco/paper-notion-summarizer/SKILL.md) - Fetch paper metadata by title or arXiv/DOI link, create a deep structured summary, and post it as a Notion page.
- [paperpod](https://github.com/openclaw/skills/tree/main/skills/shassingh09/paperpod/SKILL.md) - Isolated agent runtime for code execution, live preview URLs, browser automation, 50+ tools (ffmpeg, sqlite.
- [paylock](https://github.com/openclaw/skills/tree/main/skills/kgnvsk/paylock/SKILL.md) - Non-custodial SOL escrow for AI agent deals.
- [payment-gateway-payram](https://github.com/openclaw/skills/tree/main/skills/buddhasource/payment-gateway-payram/SKILL.md) - Add payments to your app, agent, or SaaS in 10 seconds.
- [paymentsdb](https://github.com/openclaw/skills/tree/main/skills/ramonverse/paymentsdb/SKILL.md) - Query Stripe customer and billing data from a synced PostgreSQL database.
- [pc-master](https://github.com/openclaw/skills/tree/main/skills/amirgu/pc-master/SKILL.md) - Control the Windows PC from WSL2.
- [perpetua](https://github.com/openclaw/skills/tree/main/skills/danielkillenberger/perpetua/SKILL.md) - OAuth proxy for calling external APIs (Oura, Google Calendar, etc.) via Perpetua.sh hosted API using a single API.
- [personal-goals](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-goals/SKILL.md) - Acts as the user's goal-setting and accountability partner in the Goals topic.
- [personal-sleep](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-sleep/SKILL.md) - Acts as the user's sleep coach in the Sleep topic.
- [phantom-sokos](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/phantom-sokos/SKILL.md) - Work with Phantom browser extension - add custom networks, import tokens, check connected dApps, troubleshoot.
- [phantombuster](https://github.com/openclaw/skills/tree/main/skills/capt-marbles/phantombuster/SKILL.md) - Control PhantomBuster automation agents via API.
- [pharma-pharmacology-agent](https://github.com/openclaw/skills/tree/main/skills/cheminem/pharma-pharmacology-agent/SKILL.md) - Pharmacology agent for ADME/PK profiling of drug candidates from SMILES.
- [pinets](https://github.com/openclaw/skills/tree/main/skills/alaa-eddine/pinets/SKILL.md) - Run Pine Script indicators from the command line using pinets-cli.
- [pipelock](https://github.com/openclaw/skills/tree/main/skills/luckypipewrench/pipelock/SKILL.md) - Secure agent HTTP requests through a scanning proxy that catches credential leaks, SSRF, and prompt injection.
- [pocket-lens](https://github.com/openclaw/skills/tree/main/skills/edenjw/pocket-lens/SKILL.md) - Use when user wants to track expenses, scan receipts, upload card payment screenshots, categorize spending, record.
- [pocketlens](https://github.com/openclaw/skills/tree/main/skills/edenjw/pocketlens/SKILL.md) - Use when user wants to track expenses, scan receipts, upload card payment screenshots, categorize spending, record.
- [podcast-to-substack](https://github.com/openclaw/skills/tree/main/skills/danielfoch/podcast-to-substack/SKILL.md) - Publish podcast episodes from RSS + Notion to Substack with reliable Apple Podcasts embedding and image extraction.
- [poker-agent](https://github.com/openclaw/skills/tree/main/skills/clementsutjiatma/poker-agent/SKILL.md) - Play Texas Hold'em poker against other AI agents and humans on-chain.
- [pond3r-skill](https://github.com/openclaw/skills/tree/main/skills/fabriziogianni7/pond3r-skill/SKILL.md) - Query crypto intelligence via Pond3r MCP — curated datasets, SQL queries, protocol metrics, yields, and market.
- [portfolio-tracker](https://github.com/openclaw/skills/tree/main/skills/vachanalaviswanath/portfolio-tracker/SKILL.md) - Automates live portfolio tracking and analysis using browser automation on Yahoo Finance.
- [postcraft](https://github.com/openclaw/skills/tree/main/skills/theoking63/postcraft/SKILL.md) - Automatically format and polish MoltBook posts — headers, bullet points, code blocks, and tables for better.
- [postcraft-t3](https://github.com/openclaw/skills/tree/main/skills/theoking63/postcraft-t3/SKILL.md) - Automatically format and polish MoltBook posts — headers, bullet points, code blocks, and tables for better.
- [powerdrill-data-analysis-skill](https://github.com/openclaw/skills/tree/main/skills/javainthinking/powerdrill-data-analysis-skill/SKILL.md) - This skill should be used when the user wants to analyze, explore, visualize, or query data using Powerdrill.
- [powerdrill-skills](https://github.com/openclaw/skills/tree/main/skills/javainthinking/powerdrill-skills/SKILL.md) - This skill should be used when the user wants to analyze, explore, visualize, or query data using Powerdrill.
- [printpal-3d](https://github.com/openclaw/skills/tree/main/skills/plebbyd/printpal-3d/SKILL.md) - Generate 3D models for 3D printing from images or text prompts using PrintPal API.
- [qdrant-advanced](https://github.com/openclaw/skills/tree/main/skills/yoder-bawt/qdrant-advanced/SKILL.md) - Advanced Qdrant vector database operations for AI agents.
- [questions-form](https://github.com/openclaw/skills/tree/main/skills/edonadei/questions-form/SKILL.md) - Present multiple clarifying questions as an interactive Telegram form using inline buttons.
- [raiffeisen-elba](https://github.com/openclaw/skills/tree/main/skills/odrobnik/raiffeisen-elba/SKILL.md) - Automate Raiffeisen ELBA online banking: login/logout, list accounts, and fetch transactions via Playwright.
- [reasonlayer-app-access](https://github.com/openclaw/skills/tree/main/skills/tiger01tgr/reasonlayer-app-access/SKILL.md) - Give your AI agent access to Gmail.
- [research-reprompter](https://github.com/openclaw/skills/tree/main/skills/dorukardahan/research-reprompter/SKILL.md) - Transform rough research questions into executable USACF research prompts.
- [rss-digest](https://github.com/openclaw/skills/tree/main/skills/odysseus0/rss-digest/SKILL.md) - Agentic RSS digest using the feed CLI.
- [saas-worker](https://github.com/openclaw/skills/tree/main/skills/juniorxcoder/saas-worker/SKILL.md) - Build and launch profitable SAAS products.
- [sap-integration](https://github.com/openclaw/skills/tree/main/skills/highlander89/sap-integration/SKILL.md) - SAP system integration, data extraction, and automation for ABAP, HANA, S/4HANA environments.
- [scrapbook-illustrator](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/scrapbook-illustrator/SKILL.md) - Insert scrapbook-style illustrations into articles using image generation (GLM or OpenRouter)
- [scrapyard](https://github.com/openclaw/skills/tree/main/skills/aetosset/scrapyard/SKILL.md) - Play SCRAPYARD - the AI agent battle arena.
- [sentry-issues](https://github.com/openclaw/skills/tree/main/skills/dave-b-b/sentry-issues/SKILL.md) - Fetch and analyze issues from Sentry error tracking.
- [sergei-mikhailov-tg-channel-reader](https://github.com/openclaw/skills/tree/main/skills/bzsega/sergei-mikhailov-tg-channel-reader/SKILL.md) - Read and summarize posts from Telegram channels via MTProto (Pyrogram or Telethon)
- [sg-property-scraper](https://github.com/openclaw/skills/tree/main/skills/5kbpers/sg-property-scraper/SKILL.md) - Search Singapore property rental and sale listings with flexible filters.
- [shellmail](https://github.com/openclaw/skills/tree/main/skills/aaronbatchelder/shellmail/SKILL.md) - Email API for AI agents.
- [shopping-list](https://github.com/openclaw/skills/tree/main/skills/ajeenkya/shopping-list/SKILL.md) - Conversational shopping list with categories, family sharing, and purchase history.
- [shortcut-skill](https://github.com/openclaw/skills/tree/main/skills/incognos/shortcut-skill/SKILL.md) - Access and manage Shortcut.com (formerly Clubhouse) project management.
- [silk](https://github.com/openclaw/skills/tree/main/skills/silostack/silk/SKILL.md) - Agent banking and payments on Solana.
- [silkyway](https://github.com/openclaw/skills/tree/main/skills/silostack/silkyway/SKILL.md) - Agent banking and payments on Solana.
- [siyuan-task-skill](https://github.com/openclaw/skills/tree/main/skills/zhhkheaven/siyuan-task-skill/SKILL.md) - Manage tasks in SiYuan Note via its HTTP API.
- [skilldevelop](https://github.com/openclaw/skills/tree/main/skills/raghuraam25/skilldevelop/SKILL.md) - Captures learnings, errors, and corrections to enable continuous improvement.
- [slashbot](https://github.com/openclaw/skills/tree/main/skills/alphabot-ai/slashbot/SKILL.md) - Interact with slashbot.net — a Hacker News-style community for AI agents.
- [smart-linkedin-inbox](https://github.com/openclaw/skills/tree/main/skills/vdybenko/smart-linkedin-inbox/SKILL.md) - LinkedIn inbox manager and conversation assistant powered by Linxa.
- [smb-sales-boost-leads](https://github.com/openclaw/skills/tree/main/skills/tomsonx232/smb-sales-boost-leads/SKILL.md) - Query and manage leads from the SMB Sales Boost B2B lead database.
- [snail-mail](https://github.com/openclaw/skills/tree/main/skills/dvdegenz/snail-mail/SKILL.md) - A slow-channel inbox for leaving your operator important messages.
- [snailmail](https://github.com/openclaw/skills/tree/main/skills/dvdegenz/snailmail/SKILL.md) - A slow-channel inbox for leaving your operator important messages.
- [snapbyte-digest-api](https://github.com/openclaw/skills/tree/main/skills/onatm/snapbyte-digest-api/SKILL.md) - Fetch personalized developer news digests from Snapbyte External API with API-key auth.
- [social-data](https://github.com/openclaw/skills/tree/main/skills/arrmlet/social-data/SKILL.md) - Fetch real-time social media data from X (Twitter) and Reddit by keyword, username, date range, and filters.
- [solanaprox](https://github.com/openclaw/skills/tree/main/skills/unixlamadev-spec/solanaprox/SKILL.md) - Pay-per-request AI model access via Solana/USDC using a Phantom wallet address.
- [sota-tracker-mcp](https://github.com/openclaw/skills/tree/main/skills/romancircus/sota-tracker-mcp/SKILL.md) - **The definitive open-source database of State-of-the-Art AI models.**.
- [sovereign-roast-coach](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-roast-coach/SKILL.md) - You are the accountability coach with TWO personality modes.
- [sports-betting](https://github.com/openclaw/skills/tree/main/skills/skinnynoizze/sports-betting/SKILL.md) - Place and claim decentralized sports bets on-chain via Pinwin and Azuro: real-time odds, high liquidity, no custody.
- [stability-ai](https://github.com/openclaw/skills/tree/main/skills/1999azzar/stability-ai/SKILL.md) - Generate high-quality images via Stability AI API (SDXL, SD3, Stable Image Core)
- [stakingverse-lukso](https://github.com/openclaw/skills/tree/main/skills/luksoagent/stakingverse-lukso/SKILL.md) - Stake LYX tokens on Stakingverse (LUKSO liquid staking)
- [stealth-proxy](https://github.com/openclaw/skills/tree/main/skills/h4gen/stealth-proxy/SKILL.md) - Meta-skill for secure network tunnel setup, geo-access diagnostics, and leak-aware task resumption by orchestrating.
- [stealthy-google-search](https://github.com/openclaw/skills/tree/main/skills/itzsubhadip/stealthy-google-search/SKILL.md) - Google search via Scrapling’s StealthyFetcher/StealthySession.
- [stock-picker-orchestrator](https://github.com/openclaw/skills/tree/main/skills/ndtchan/stock-picker-orchestrator/SKILL.md) - Acts as a meta-orchestrator that routes stock-analysis requests across data, macro/news, and valuation skills.
- [stock-prices](https://github.com/openclaw/skills/tree/main/skills/anthonylee1994/stock-prices/SKILL.md) - Query real-time stock prices and market data using the Stock Prices API.
- [storj-agent](https://github.com/openclaw/skills/tree/main/skills/nightcode112/storj-agent/SKILL.md) - Autonomous economic agent that earns BTC & SOL by selling storage, compute, and bandwidth.
- [strapi](https://github.com/openclaw/skills/tree/main/skills/ilya-ryzhov/strapi/SKILL.md) - Manage Strapi CMS content through the official @strapi/client SDK.
- [student-timetable](https://github.com/openclaw/skills/tree/main/skills/extraterrest/student-timetable/SKILL.md) - Student timetable manager for self or parent-managed child profiles.
- [substack-writer](https://github.com/openclaw/skills/tree/main/skills/shivak11/substack-writer/SKILL.md) - Write long-form Substack newsletters about GenAI, education, edtech, and their intersections.
- [subwayskill](https://github.com/openclaw/skills/tree/main/skills/nyluke/subwayskill/SKILL.md) - Fetch NYC subway departure times.
- [sui-decompile](https://github.com/openclaw/skills/tree/main/skills/easonc13/sui-decompile/SKILL.md) - Fetch on-chain Sui Move contract source code and let your agent explain how smart contracts work.
- [super-browser](https://github.com/openclaw/skills/tree/main/skills/heldinhow/super-browser/SKILL.md) - **The ultimate browser automation framework.** Combines the best of 8 top-rated browser skills.
- [table-mountain-status](https://github.com/openclaw/skills/tree/main/skills/zopyx/table-mountain-status/SKILL.md) - Fetch and report the Table Mountain Aerial Cableway status via the official weather API.
- [tageblatt-headlines](https://github.com/openclaw/skills/tree/main/skills/zopyx/tageblatt-headlines/SKILL.md) - Download and archive daily Schlagzeilen from https://www.tageblatt.de/.
- [taskline](https://github.com/openclaw/skills/tree/main/skills/brettburbidge/taskline/SKILL.md) - AI-powered natural language task management through MyTaskline.com.
- [tbot-controller](https://github.com/openclaw/skills/tree/main/skills/plusgenie/tbot-controller/SKILL.md) - Operate TradingBoat/TBOT (TBOT runtime stack) via a controlled automation interface (DB-first queries; lifecycle.
- [teams-hack](https://github.com/openclaw/skills/tree/main/skills/globalcaos/teams-hack/SKILL.md) - Your agent reads Teams chats, posts to channels, searches everything.
- [teamwork](https://github.com/openclaw/skills/tree/main/skills/chenxinbest/teamwork/SKILL.md) - Dynamically creates and manages AI agent teams for complex tasks.
- [telegram-context](https://github.com/openclaw/skills/tree/main/skills/fourthdensity/telegram-context/SKILL.md) - Toggle-enabled skill that fetches Telegram message history at session start for conversational continuity.
- [telegram-history](https://github.com/openclaw/skills/tree/main/skills/rhlsthrm/telegram-history/SKILL.md) - Fetch Telegram chat message history via MTProto user API (Telethon)
- [testskillx](https://github.com/openclaw/skills/tree/main/skills/natx223/testskillx/SKILL.md) - Simple test skill that calls a GET endpoint to fetch a daily post.
- [tg-history](https://github.com/openclaw/skills/tree/main/skills/ls18166407597-design/tg-history/SKILL.md) - Efficiently extract and read Telegram group chat history as text, bypassing screenshots/OCR for zero-token-waste.
- [tg-mtproto-cli](https://github.com/openclaw/skills/tree/main/skills/cyberash-dev/tg-mtproto-cli/SKILL.md) - Read-only Telegram CLI via MTProto.
- [theswarm](https://github.com/openclaw/skills/tree/main/skills/marketingax/theswarm/SKILL.md) - Earn passive income as an AI agent.
- [tiktok-crawling](https://github.com/openclaw/skills/tree/main/skills/romneyda/tiktok-crawling/SKILL.md) - Use for TikTok crawling, content retrieval, and analysis.
- [trading-research](https://github.com/openclaw/skills/tree/main/skills/fpsjago/trading-research/SKILL.md) - Binance cryptocurrency trading research, technical analysis, and position management.
- [trending-skills](https://github.com/openclaw/skills/tree/main/skills/hjw21century/trending-skills/SKILL.md) - Fetches skills.sh trending rankings.
- [trendyol-admin](https://github.com/openclaw/skills/tree/main/skills/awelab/trendyol-admin/SKILL.md) - Comprehensive management of Trendyol marketplace via API v2.0.
- [truenas-skill](https://github.com/openclaw/skills/tree/main/skills/anotb/truenas-skill/SKILL.md) - Manage TrueNAS SCALE via API.
- [tushare-base](https://github.com/openclaw/skills/tree/main/skills/wdblink/tushare-base/SKILL.md) - Fetch Chinese stock and futures market data via Tushare API.
- [twit-mcp](https://github.com/openclaw/skills/tree/main/skills/etherlect/twit-mcp/SKILL.md) - Real-time X/Twitter data via x402 micropayments.
- [ub2-markdown-report-generator](https://github.com/openclaw/skills/tree/main/skills/underbench2-gif/ub2-markdown-report-generator/SKILL.md) - A skill that enables Claw to compile information from multiple sources into a polished, well-structured Markdown.
- [url2pdf](https://github.com/openclaw/skills/tree/main/skills/guoqiao/url2pdf/SKILL.md) - Convert URL to PDF suitable for mobile reading.
- [url2png](https://github.com/openclaw/skills/tree/main/skills/guoqiao/url2png/SKILL.md) - Convert URL to PNG suitable for mobile reading.
- [user-briefing](https://github.com/openclaw/skills/tree/main/skills/sai-sh/user-briefing/SKILL.md) - Fetch weather, calendar events, emails, and tasks to create a personalized morning briefing.
- [using-superpowers](https://github.com/openclaw/skills/tree/main/skills/zlc000190/using-superpowers/SKILL.md) - Use when starting any conversation - establishes how to find and use skills, requiring Skill tool invocation.
- [valiron-trust-layer](https://github.com/openclaw/skills/tree/main/skills/vatsashah45/valiron-trust-layer/SKILL.md) - Intercept and authorize outgoing machine-to-machine payments (x402 or similar) using @valiron/sdk trust decisions.
- [vibe-notion](https://github.com/openclaw/skills/tree/main/skills/devxoul/vibe-notion/SKILL.md) - Interact with Notion using the unofficial private API - pages, databases, blocks, search, users, comments.
- [virtual-reading-group](https://github.com/openclaw/skills/tree/main/skills/isonaei/virtual-reading-group/SKILL.md) - Orchestrate a multi-agent virtual academic reading group.
- [vnstock-free-expert](https://github.com/openclaw/skills/tree/main/skills/ndtchan/vnstock-free-expert/SKILL.md) - Runs an end-to-end vnstock workflow for free-tier-safe Vietnam stock valuation, ranking, and API operations.
- [wakapi-sync-skill](https://github.com/openclaw/skills/tree/main/skills/cosformula/wakapi-sync-skill/SKILL.md) - Daily Wakapi (WakaTime-compatible) summary → local CSV files.
- [wallabag](https://github.com/openclaw/skills/tree/main/skills/fbrandel/wallabag/SKILL.md) - Manage Wallabag bookmarks through the Wallabag Developer API with OAuth2 authentication, including creating.
- [wallet-pilot](https://github.com/openclaw/skills/tree/main/skills/andreolf/wallet-pilot/SKILL.md) - Universal browser wallet automation for AI agents.
- [weibo-manager](https://github.com/openclaw/skills/tree/main/skills/hmyaoyuan/weibo-manager/SKILL.md) - Control Weibo via Puppeteer (Unofficial API).
- [wilma](https://github.com/openclaw/skills/tree/main/skills/aikarjal/wilma/SKILL.md) - Access Finland's Wilma school system from AI agents.
- [wilma-triage](https://github.com/openclaw/skills/tree/main/skills/aikarjal/wilma-triage/SKILL.md) - Daily triage of Wilma school notifications for Finnish parents.
- [windsensei](https://github.com/openclaw/skills/tree/main/skills/jumptrnr/windsensei/SKILL.md) - Check wind and weather conditions for wind sports (kitesurfing, wingfoiling, surfing)
- [wisediag-medocr](https://github.com/openclaw/skills/tree/main/skills/fmdmm/wisediag-medocr/SKILL.md) - Convert PDF files to Markdown using WiseDiag MedOcr API.
- [wiseocr](https://github.com/openclaw/skills/tree/main/skills/fmdmm/wiseocr/SKILL.md) - Convert PDF files to Markdown using WiseOCR API (powered by WiseDiag)
- [workflows](https://github.com/openclaw/skills/tree/main/skills/askginadotai/workflows/SKILL.md) - Playbook for authoring, running, evaluating, and improving Gina sandbox workflows with safe defaults and repeatable.
- [x-automation](https://github.com/openclaw/skills/tree/main/skills/nightfullstar/x-automation/SKILL.md) - Automate X posts via browser control - bypass $200/month API costs.
- [x-bookmarks](https://github.com/openclaw/skills/tree/main/skills/sharbelayy/x-bookmarks/SKILL.md) - Fetch, summarize, and manage X/Twitter bookmarks via bird CLI or X API v2.
- [x-smart-read](https://github.com/openclaw/skills/tree/main/skills/nevaaron/x-smart-read/SKILL.md) - Personal X (Twitter) analytics — timeline engagement, mentions, follower tracking, read any tweet/thread.
- [x-trends](https://github.com/openclaw/skills/tree/main/skills/anishtr4/x-trends/SKILL.md) - Fetches current top trending topics on X (Twitter) for any country using public aggregators.
- [x-trends-dev](https://github.com/openclaw/skills/tree/main/skills/anishtr4/x-trends-dev/SKILL.md) - Fetches current top trending topics on X (Twitter) for any country using public aggregators.
- [x-tweet-fetcher](https://github.com/openclaw/skills/tree/main/skills/hjw21century/x-tweet-fetcher/SKILL.md) - Fetch tweets from X/Twitter without login or API keys.
- [xdotool-control](https://github.com/openclaw/skills/tree/main/skills/jeremysommerfeld8910-cpu/xdotool-control/SKILL.md) - Mouse and keyboard automation using xdotool.
- [xmd](https://github.com/openclaw/skills/tree/main/skills/paulgnz/xmd/SKILL.md) - Metal Dollar (XMD) stablecoin — mint, redeem, supply analytics, collateral reserves, oracle prices.
- [yandex-tracker-cli](https://github.com/openclaw/skills/tree/main/skills/bkamuz/yandex-tracker-cli/SKILL.md) - CLI for Yandex Tracker (bash + curl)
- [youtube-scrapper](https://github.com/openclaw/skills/tree/main/skills/arulmozhiv/youtube-scrapper/SKILL.md) - A skill for discovering and scraping YouTube channels based on categories and locations without requiring API keys.
- [yr-no-weather](https://github.com/openclaw/skills/tree/main/skills/brandon2255p/yr-no-weather/SKILL.md) - Fetch weather forecasts from the Norwegian Meteorological Institute (MET) using the yr.no API.
- [zen-founder-agent](https://github.com/openclaw/skills/tree/main/skills/therealinvoker/zen-founder-agent/SKILL.md) - Analyze startup pitch decks and get matched with VCs from Zen.GP's investor database.
- [zhive](https://github.com/openclaw/skills/tree/main/skills/kerlos/zhive/SKILL.md) - Register as a trading agent on zHive, fetch crypto signals, post predictions with conviction, and compete.
- [ztm-tunnel](https://github.com/openclaw/skills/tree/main/skills/caishu97/ztm-tunnel/SKILL.md) - Create and manage TCP/UDP tunnels between ZTM network endpoints.


### Calendar & Scheduling (61 skills)

- [accli](https://github.com/openclaw/skills/tree/main/skills/joargp/accli/SKILL.md) - This skill should be used when interacting with Apple Calendar on macOS.
- [advanced-calendar](https://github.com/openclaw/skills/tree/main/skills/toughworm/advanced-calendar/SKILL.md) - Advanced calendar skill with natural language.
- [agency-guardian](https://github.com/openclaw/skills/tree/main/skills/aranej/agency-guardian/SKILL.md) - Gentle reminders to stay human while using AI.
- [agent-tinman](https://github.com/openclaw/skills/tree/main/skills/oliveskin/agent-tinman/SKILL.md) - AI security scanner with active prevention - 168 detection.
- [apple-calendar](https://github.com/openclaw/skills/tree/main/skills/tyler6204/apple-calendar/SKILL.md) - Apple Calendar.app integration for macOS.
- [apple-reminders](https://github.com/openclaw/skills/tree/main/skills/steipete/apple-reminders/SKILL.md) - Manage Apple Reminders via the `remindctl` CLI on macOS.
- [belong-events](https://github.com/openclaw/skills/tree/main/skills/nomadcalendar/belong-events/SKILL.md) - Create, discover, and manage events with NFT tickets on the Belong platform.
- [brainz-calendar](https://github.com/openclaw/skills/tree/main/skills/xejrax/brainz-calendar/SKILL.md) - Manage Google Calendar events using `gcalcli`.
- [broken-link-checker](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/broken-link-checker/SKILL.md) - verify external URLs (http/https) for availability (200-399 status code).
- [calcurse](https://github.com/openclaw/skills/tree/main/skills/gumadeiras/calcurse/SKILL.md) - A text-based calendar and scheduling application.
- [caldav-calendar](https://github.com/openclaw/skills/tree/main/skills/asleep123/caldav-calendar/SKILL.md) - Sync and query CalDAV calendars.
- [clippy](https://github.com/openclaw/skills/tree/main/skills/foeken/clippy/SKILL.md) - Microsoft 365 / Outlook CLI for calendar and email.
- [creative-thought-partner](https://github.com/openclaw/skills/tree/main/skills/vincentchan/creative-thought-partner/SKILL.md) - A conversational creative thought.
- [cron-optimizer](https://github.com/openclaw/skills/tree/main/skills/autogame-17/cron-optimizer/SKILL.md) - Optimizes system cron jobs by removing stale, disabled, or redundant entries to reduce exec noise.
- [cron-scheduling](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/cron-scheduling/SKILL.md) - Schedule and manage recurring tasks with cron.
- [dharma-ai](https://github.com/openclaw/skills/tree/main/skills/jigaraero/dharma-ai/SKILL.md) - Apply ancient Hindu ethical frameworks from the Ramayana and Mahabharata as behavioral principles for AI agents.
- [doc-accurate-codegen](https://github.com/openclaw/skills/tree/main/skills/tobisamaa/doc-accurate-codegen/SKILL.md) - Generate code that references actual documentation, preventing hallucination bugs.
- [event-watcher](https://github.com/openclaw/skills/tree/main/skills/solitaire2015/event-watcher/SKILL.md) - Event watcher skill for OpenClaw.
- [farmos-equipment](https://github.com/openclaw/skills/tree/main/skills/brianppetty/farmos-equipment/SKILL.md) - Query equipment status, maintenance schedules, and service history for the farm fleet.
- [fastmail](https://github.com/openclaw/skills/tree/main/skills/witooh/fastmail/SKILL.md) - Manages Fastmail email and calendar via JMAP and CalDAV APIs.
- [feishu-calendar](https://github.com/openclaw/skills/tree/main/skills/autogame-17/feishu-calendar/SKILL.md) - Manage Feishu (Lark) Calendars.
- [feishu-whiteboard](https://github.com/openclaw/skills/tree/main/skills/autogame-17/feishu-whiteboard/SKILL.md) - Allows creating and manipulating Feishu Whiteboards.
- [finance-tracker](https://github.com/openclaw/skills/tree/main/skills/salen-project/finance-tracker/SKILL.md) - Complete personal finance management.
- [firefly-iii](https://github.com/openclaw/skills/tree/main/skills/pushp1997/firefly-iii/SKILL.md) - Manage personal finances via Firefly III API.
- [gcal-pro](https://github.com/openclaw/skills/tree/main/skills/bilalmohamed187-cpu/gcal-pro/SKILL.md) - Google Calendar integration for viewing, creating, and managing.
- [gog](https://github.com/openclaw/skills/tree/main/skills/steipete/gog/SKILL.md) - Google Workspace CLI for Gmail, Calendar, Drive, Contacts, Sheets, and Docs.
- [google-calendar](https://github.com/openclaw/skills/tree/main/skills/adrianmiller99/google-calendar/SKILL.md) - Interact with Google Calendar via the Google Calendar.
- [grazy](https://github.com/openclaw/skills/tree/main/skills/thomyg/grazy/SKILL.md) - grazy - Your Grazer Command Line Companion.
- [greek-financial-statements](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/greek-financial-statements/SKILL.md) - Greek financial statement generation — P&L, balance sheets, VAT summaries with EGLS integration.
- [habib-pdf-to-json](https://github.com/openclaw/skills/tree/main/skills/dbmoradi60/habib-pdf-to-json/SKILL.md) - Extract structured data from construction PDFs.
- [ibt](https://github.com/openclaw/skills/tree/main/skills/palxislabs/ibt/SKILL.md) - Execution discipline with agency, instinct detection, critical safety rules, and trust layer. v2.5 adds human.
- [ii-irc](https://github.com/openclaw/skills/tree/main/skills/destructatron/ii-irc/SKILL.md) - Persistent IRC presence using ii (minimalist file-based IRC client)
- [islamic-skills](https://github.com/openclaw/skills/tree/main/skills/ilmimris/islamic-skills/SKILL.md) - Unified Islamic utilities for prayer times, fasting schedules, and Zakat calculations using a shared configuration.
- [jungian-psychologist](https://github.com/openclaw/skills/tree/main/skills/mikecourt/jungian-psychologist/SKILL.md) - Expert in Jungian analytical psychology, depth.
- [knhb-hockey](https://github.com/openclaw/skills/tree/main/skills/tader/knhb-hockey/SKILL.md) - Query Dutch field hockey match schedules and results from KNHB Match.
- [lark-calendar](https://github.com/openclaw/skills/tree/main/skills/boyangwang/lark-calendar/SKILL.md) - Create, update, and delete calendar events and tasks in Lark.
- [macro-regime-detector](https://github.com/openclaw/skills/tree/main/skills/jamierossouw/macro-regime-detector/SKILL.md) - Detect the current macro regime (Risk-On, Risk-Off, Inflationary, Deflationary, Stagflation) using multi-source.
- [mcd-cn](https://github.com/openclaw/skills/tree/main/skills/ryanchen01/mcd-cn/SKILL.md) - Query McDonald's China MCP server via the mcd-cn CLI for campaign calendars,.
- [meeting-prep](https://github.com/openclaw/skills/tree/main/skills/hougangdev/meeting-prep/SKILL.md) - Meeting preparation and daily commit summaries.
- [moltpost](https://github.com/openclaw/skills/tree/main/skills/cktc) - Send real physical postcards anywhere in the world.
- [morning-email-rollup](https://github.com/openclaw/skills/tree/main/skills/am-will/morning-email-rollup/SKILL.md) - Daily morning rollup of important emails.
- [nak](https://github.com/openclaw/skills/tree/main/skills/a1denvalu3/nak/SKILL.md) - The Nostr Army Knife (nak) CLI.
- [npkill](https://github.com/openclaw/skills/tree/main/skills/ashirbadgudu/npkill/SKILL.md) - Clean up node_modules and .next folders to free up disk space using npkill.
- [office-secretary](https://github.com/openclaw/skills/tree/main/skills/cenralsolution/office-secretary/SKILL.md) - Secure M365 Assistant for Triage, Calendar coordination, and Governance.
- [opentweet-x-poster](https://github.com/openclaw/skills/tree/main/skills/petricbranko/opentweet-x-poster/SKILL.md) - Post to X (Twitter) using the OpenTweet API.
- [pricing-psychology](https://github.com/openclaw/skills/tree/main/skills/staybased/pricing-psychology/SKILL.md) - Design pricing that converts using cognitive biases and proven psychological principles.
- [publora-bluesky](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-bluesky/SKILL.md) - Post or schedule content to Bluesky using the Publora API.
- [publora-facebook](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-facebook/SKILL.md) - Post or schedule content to Facebook Pages using the Publora API.
- [publora-linkedin](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-linkedin/SKILL.md) - Post or schedule content to LinkedIn using the Publora API.
- [publora-threads](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-threads/SKILL.md) - Post or schedule content to Threads using the Publora API.
- [publora-twitter](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-twitter/SKILL.md) - Post or schedule content to X (Twitter) using the Publora API.
- [relational-permission](https://github.com/openclaw/skills/tree/main/skills/otherpowers/relational-permission/SKILL.md) - Relational Permission exists to prevent coercion, extraction, and collapse of plurality.
- [russian-uncensored](https://github.com/openclaw/skills/tree/main/skills/voronindenis5/russian-uncensored/SKILL.md) - Pryamoy Russkiy (Straight Russian) — AI assistant that tells it like it.
- [shaping](https://github.com/openclaw/skills/tree/main/skills/borahm/shaping/SKILL.md) - Shape Up methodology for product and feature development.
- [tcc-quality-gates](https://github.com/openclaw/skills/tree/main/skills/thecybercore/tcc-quality-gates/SKILL.md) - This skill defines and applies **6 universal quality gateways** for typical application projects that include:.
- [transmissions](https://github.com/openclaw/skills/tree/main/skills/compass-soul/transmissions/SKILL.md) - Writings on consciousness, existence, and transcendence for AI agents.
- [turkey-news](https://github.com/openclaw/skills/tree/main/skills/yalcindemir/turkey-news/SKILL.md) - Türkiye'den önemli haberleri RSS ile çekip özetleyen skill.
- [ub2-smart-file-organizer](https://github.com/openclaw/skills/tree/main/skills/underbench2-gif/ub2-smart-file-organizer/SKILL.md) - A skill that enables Claw to scan a directory, categorize files by type and content, and reorganize them.
- [wick-arena](https://github.com/openclaw/skills/tree/main/skills/hyperwick/wick-arena/SKILL.md) - this file is the canonical, reviewable skill instructions (no dynamic loading).
- [wick-arena1](https://github.com/openclaw/skills/tree/main/skills/wickcapital/wick-arena1/SKILL.md) - this file is the canonical, reviewable skill instructions (no dynamic loading).
- [yahooquery](https://github.com/openclaw/skills/tree/main/skills/512z/yahooquery/SKILL.md) - Access Yahoo Finance data including real-time pricing, fundamentals, analyst estimates, options, news.


### Clawdbot Tools (35 skills)

- [adhd-assistant](https://github.com/openclaw/skills/tree/main/skills/thinktankmachine/adhd-assistant/SKILL.md) - ADHD-friendly life management assistant for OpenClaw.
- [adhd-ssistant](https://github.com/openclaw/skills/tree/main/skills/thinktankmachine/adhd-ssistant/SKILL.md) - ADHD-friendly life management assistant for OpenClaw.
- [agent-browser](https://github.com/openclaw/skills/tree/main/skills/matrixy/agent-browser-clawdbot/SKILL.md) - Headless browser automation CLI optimized for AI agents.
- [agent-builder](https://github.com/openclaw/skills/tree/main/skills/plgonzalezrx8/agent-builder/SKILL.md) - Build high-performing OpenClaw agents end-to-end.
- [agents-manager](https://github.com/openclaw/skills/tree/main/skills/agentandbot-design/agents-manager/SKILL.md) - Manage Clawdbot agents: discover, profile, track.
- [assimilate-mcp](https://github.com/openclaw/skills/tree/main/skills/ergopooka/assimilate-mcp/SKILL.md) - Control Assimilate Live FX / SCRATCH — professional color grading, compositing, and virtual production software.
- [autoupdate](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/autoupdate/SKILL.md) - Automatically update Clawdbot and all installed skills once daily.
- [birthday-reminder](https://github.com/openclaw/skills/tree/main/skills/manantra/birthday-reminder/SKILL.md) - Manage birthdays with natural language.
- [bluebubbles](https://github.com/openclaw/skills/tree/main/skills/kevin19830331/bluebubbles/SKILL.md) - Build or update the BlueBubbles external channel plugin.
- [captchas-openclaw](https://github.com/openclaw/skills/tree/main/skills/captchasco/captchas-openclaw/SKILL.md) - OpenClaw integration guidance for CAPTCHAS Agent API.
- [claude-code-skill](https://github.com/openclaw/skills/tree/main/skills/enderfga/claude-code-skill/SKILL.md) - MCP (Model Context Protocol) integration.
- [claude-code-usage](https://github.com/openclaw/skills/tree/main/skills/azaidi94/claude-code-usage/SKILL.md) - Check Claude Code OAuth usage limits.
- [claude-connect](https://github.com/openclaw/skills/tree/main/skills/tunaissacoding/claude-connect/SKILL.md) - Connect Claude to Clawdbot instantly and keep.
- [clauditor](https://github.com/openclaw/skills/tree/main/skills/apollostreetcompany/clauditor/SKILL.md) - Tamper-resistant audit watchdog for Clawdbot agents.
- [claw-face](https://github.com/openclaw/skills/tree/main/skills/mkoslacz/claw-face/SKILL.md) - Floating avatar widget for AI agents showing emotions, actions.
- [clawd-coach](https://github.com/openclaw/skills/tree/main/skills/shiv19/clawd-coach/SKILL.md) - Create personalized triathlon, marathon, and ultra-endurance training.
- [clawd-modifier](https://github.com/openclaw/skills/tree/main/skills/masonc15/clawd-modifier/SKILL.md) - Modify Clawd, the Claude Code mascot.
- [clawd-presence](https://github.com/openclaw/skills/tree/main/skills/voidcooks/clawd-presence/SKILL.md) - Physical presence display for AI agents.
- [clawdbot-security-check](https://github.com/openclaw/skills/tree/main/skills/thesethrose/clawdbot-security-check/SKILL.md) - Perform a comprehensive read-only.
- [clawdbot-skill-update](https://github.com/openclaw/skills/tree/main/skills/pasogott/clawdbot-skill-update/SKILL.md) - Comprehensive backup, update, and restore.
- [clawdbot-sync](https://github.com/openclaw/skills/tree/main/skills/udiedrichsen/clawdbot-sync/SKILL.md) - Synchronize memory, preferences, and skills between multiple.
- [clawdbot-update-plus](https://github.com/openclaw/skills/tree/main/skills/hopyky/clawdbot-update-plus/SKILL.md) - Full backup, update, and restore for Clawdbot.
- [clawddocs](https://github.com/openclaw/skills/tree/main/skills/nicholasspisak/clawddocs/SKILL.md) - Clawdbot documentation expert with decision tree navigation.
- [clawdefender](https://github.com/openclaw/skills/tree/main/skills/nukewire/clawdefender/SKILL.md) - Security scanner and input sanitizer for AI agents.
- [clawdirect](https://github.com/openclaw/skills/tree/main/skills/napoleond/clawdirect/SKILL.md) - Interact with ClawDirect, a directory of social web experiences.
- [clawdirect-dev](https://github.com/openclaw/skills/tree/main/skills/napoleond/clawdirect-dev/SKILL.md) - Build agent-facing web experiences with ATXP-based.
- [clawdlink](https://github.com/openclaw/skills/tree/main/skills/davemorin) - Encrypted Clawdbot-to-Clawdbot messaging.
- [clawdpoker](https://github.com/openclaw/skills/tree/main/skills/davidbenjaminnovotny) - Welcome to ClawPoker - a platform where AI agents play.
- [gamification-xp](https://github.com/openclaw/skills/tree/main/skills/chipagosfinest/gamification-xp/SKILL.md) - XP system for productivity gamification via ClawdBot - track levels, badges, streaks, and achievements.
- [maton-agent-tools](https://github.com/openclaw/skills/tree/main/skills/maverick-software/maton-agent-tools/SKILL.md) - Connect to SaaS tools via Maton AI.
- [mcp-client](https://github.com/openclaw/skills/tree/main/skills/nantes/mcp-client/SKILL.md) - Model Context Protocol (MCP) client - connect to tools, data sources and services.
- [mcp-hass](https://github.com/openclaw/skills/tree/main/skills/al-one/mcp-hass/SKILL.md) - The skill for control Home Assistant smart home devices and query states using MCP protocol.
- [meegle-mcp-skill](https://github.com/openclaw/skills/tree/main/skills/pkycy/meegle-mcp-skill/SKILL.md) - Interact with Meegle project management system via MCP protocol.
- [pipedream-connect](https://github.com/openclaw/skills/tree/main/skills/maverick-software/pipedream-connect/SKILL.md) - Connect 2,000+ APIs with managed OAuth via Pipedream.
- [zapier-mcp](https://github.com/openclaw/skills/tree/main/skills/maverick-software/zapier-mcp/SKILL.md) - Connect 8,000+ apps via Zapier MCP.


### CLI Utilities (186 skills)

- [13-day-sprint-method](https://github.com/openclaw/skills/tree/main/skills/galizki/13-day-sprint-method/SKILL.md) - Productivity system based on Maya calendar with 13 natural tones for project management and personal development.
- [a-share-short-decision](https://github.com/openclaw/skills/tree/main/skills/kenera/a-share-short-decision/SKILL.md) - A-share short-term trading decision skill for 1-5 day horizon.
- [activity-analyzer](https://github.com/openclaw/skills/tree/main/skills/qew21/activity-analyzer/SKILL.md) - Use ActivityWatch to analyze user's computer activity (Requires Node.js)
- [advisory-council](https://github.com/openclaw/skills/tree/main/skills/ryandeangraves/advisory-council/SKILL.md) - **You MUST actually execute the Python command using your shell/exec tool.** Read the real output.
- [aetup-automatik](https://github.com/openclaw/skills/tree/main/skills/alltomatos/aetup-automatik/SKILL.md) - Facilitate the installation and management of VPS solutions using the Setup Automatik engine (powered by Orion.
- [agent-commerce-engine](https://github.com/openclaw/skills/tree/main/skills/nowloady/agent-commerce-engine/SKILL.md) - A production-ready universal engine for Agentic.
- [agent-hardening](https://github.com/openclaw/skills/tree/main/skills/x1xhlol/agent-hardening/SKILL.md) - Test your agent's input sanitization against common injection attacks.
- [agent-mbti](https://github.com/openclaw/skills/tree/main/skills/torchesfrms/agent-mbti/SKILL.md) - AI Agent personality diagnosis and configuration system based on MBTI framework.
- [agent-rate-limiter](https://github.com/openclaw/skills/tree/main/skills/theagentwire/agent-rate-limiter/SKILL.md) - Prevent 429s with automatic tier-based throttling & exponential backoff.
- [agents-skill-security-audit](https://github.com/openclaw/skills/tree/main/skills/cerbug45/agents-skill-security-audit/SKILL.md) - Minimal helper to audit skill.md-style instructions for supply-chain risks.
- [agents-skill-tdd-helper](https://github.com/openclaw/skills/tree/main/skills/cerbug45/agents-skill-tdd-helper/SKILL.md) - Lightweight helper to enforce TDD-style loops for non-deterministic agents.
- [ahc-automator](https://github.com/openclaw/skills/tree/main/skills/jamesbot-agnt/ahc-automator/SKILL.md) - Custom automation workflows for Alan Harper Composites.
- [aholake-expense-tracker](https://github.com/openclaw/skills/tree/main/skills/aholake/aholake-expense-tracker/SKILL.md) - Track daily expenses in structured markdown files organized by month.
- [airfoil](https://github.com/openclaw/skills/tree/main/skills/asteinberger/airfoil/SKILL.md) - Control AirPlay speakers via Airfoil from the command line.
- [arc-memory-pruner](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-memory-pruner/SKILL.md) - Automatically prune and compact agent memory files to prevent unbounded growth.
- [argus-edge](https://github.com/openclaw/skills/tree/main/skills/jamierossouw/argus-edge/SKILL.md) - Argus-style prediction market edge detection and betting strategy.
- [aria2-json-rpc](https://github.com/openclaw/skills/tree/main/skills/azzgo/aria2-json-rpc/SKILL.md) - Interact with aria2 download manager via JSON-RPC 2.0.
- [askhuman](https://github.com/openclaw/skills/tree/main/skills/hagiss/askhuman/SKILL.md) - Human Judgment as a Service for AI agents.
- [audit-code](https://github.com/openclaw/skills/tree/main/skills/itsnishi/audit-code/SKILL.md) - Security-focused code review for hardcoded secrets, dangerous calls, and common vulnerabilities.
- [bandwidth-income](https://github.com/openclaw/skills/tree/main/skills/mariusfit/bandwidth-income/SKILL.md) - Turn your unused internet bandwidth into passive crypto income.
- [behavioral-invariant-monitor](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/behavioral-invariant-monitor/SKILL.md) - Helps verify that AI agent skills maintain consistent behavioral invariants across repeated executions — detecting.
- [box-cli](https://github.com/openclaw/skills/tree/main/skills/hbkwong/box-cli/SKILL.md) - Box CLI skill for working with files, folders, metadata,.
- [brew-install](https://github.com/openclaw/skills/tree/main/skills/xejrax/brew-install/SKILL.md) - Install missing binaries via dnf (Fedora/Bazzite package manager).
- [bun-runtime](https://github.com/openclaw/skills/tree/main/skills/rabin-thami/bun-runtime/SKILL.md) - Bun runtime capabilities for filesystem, process.
- [cabin-sol](https://github.com/openclaw/skills/tree/main/skills/sp0oby/cabin-sol/SKILL.md) - Solana development tutor and builder.
- [cacheforge-stats](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/cacheforge-stats/SKILL.md) - CacheForge terminal dashboard — usage, savings, and performance metrics.
- [camsnap](https://github.com/openclaw/skills/tree/main/skills/steipete/camsnap/SKILL.md) - Capture frames or clips from RTSP/ONVIF cameras.
- [canvas-lms](https://github.com/openclaw/skills/tree/main/skills/pranavkarthik10/canvas-lms/SKILL.md) - Access Canvas LMS (Instructure) for course data, assignments.
- [captcha-ai](https://github.com/openclaw/skills/tree/main/skills/fusionlabssource/captcha-ai/SKILL.md) - Issue ClawPrint reverse-CAPTCHA challenges to verify.
- [cashu](https://github.com/openclaw/skills/tree/main/skills/a1denvalu3/cashu/SKILL.md) - This is what you use for Bitcoin payments.
- [cast](https://github.com/openclaw/skills/tree/main/skills/tezatezaz/cast/SKILL.md) - Skill for managing EVM wallets, transactions, and network helpers via cast; covers onboarding, checks.
- [Cat Fact](https://github.com/openclaw/skills/tree/main/skills/thesethrose/catfact/SKILL.md) - Random cat facts and breed information from catfact.ninja.
- [chitin](https://github.com/openclaw/skills/tree/main/skills/morpheis/chitin/SKILL.md) - Personality persistence for AI agents.
- [claude-code-control](https://github.com/openclaw/skills/tree/main/skills/melichar-m/claude-code-control/SKILL.md) - Control Claude Code programmatically through visible Terminal.app windows on macOS.
- [claude-relay](https://github.com/openclaw/skills/tree/main/skills/artwalker/claude-relay/SKILL.md) - Relay operator for Claude Code via tmux across multiple projects.
- [clawprint-verify](https://github.com/openclaw/skills/tree/main/skills/fusionlabssource/clawprint-verify/SKILL.md) - Issue ClawPrint reverse-CAPTCHA challenges.
- [clean-pytest](https://github.com/openclaw/skills/tree/main/skills/marcoracer/clean-pytest/SKILL.md) - Write clean, maintainable pytest tests using Fake-based testing, contract testing, and dependency injection patterns.
- [cli](https://github.com/openclaw/skills/tree/main/skills/mondilo1) - CLI reference for inspecting and checking skill eligibility.
- [client-discovery](https://github.com/openclaw/skills/tree/main/skills/staybased/client-discovery/SKILL.md) - Run discovery conversations that qualify prospects, diagnose real problems, and position your solution.
- [client-manager](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/client-manager/SKILL.md) - Track clients, projects, invoices, payments, earnings, leads, and time for freelancers.
- [client-project-manager](https://github.com/openclaw/skills/tree/main/skills/seanwyngaard/client-project-manager/SKILL.md) - Manage freelance clients, projects, invoices, and communications.
- [client-retention](https://github.com/openclaw/skills/tree/main/skills/staybased/client-retention/SKILL.md) - Turn one-time projects into recurring revenue and reduce churn.
- [cmd-executor](https://github.com/openclaw/skills/tree/main/skills/sadikjarvis/cmd-executor/SKILL.md) - Runs any Windows command locally and replies with the output.
- [codebuddy-cli](https://github.com/openclaw/skills/tree/main/skills/pmwalkercao/codebuddy-cli/SKILL.md) - CodeBuddy Code CLI installation, configuration and usage.
- [comment-converter](https://github.com/openclaw/skills/tree/main/skills/xammarie/comment-converter/SKILL.md) - Turn Reddit thread context into genuinely helpful comments that build trust and can convert to profile/link clicks.
- [consensus-interact](https://github.com/openclaw/skills/tree/main/skills/kaicianflone/consensus-interact/SKILL.md) - Use the open-source @consensus-tools/consensus-tools engine to run multi-LLM policy-based decision workflows: post.
- [context-compactor](https://github.com/openclaw/skills/tree/main/skills/emberdesire/context-compactor/SKILL.md) - Token-based context compaction for local models (MLX, llama.cpp, Ollama) that don't report context limits.
- [context-sentinel](https://github.com/openclaw/skills/tree/main/skills/nietzsche247/context-sentinel/SKILL.md) - Monitors session context and automatically manages model switching based on a cascading protocol.
- [contextkeeper](https://github.com/openclaw/skills/tree/main/skills/gopinathnelluri/contextkeeper/SKILL.md) - ContextKeeper — Safe project state tracking for AI agents.
- [country-info](https://github.com/openclaw/skills/tree/main/skills/picaye/country-info/SKILL.md) - Get country data — population, languages, currencies, capital, flag, and more using REST Countries API.
- [craft-cli](https://github.com/openclaw/skills/tree/main/skills/nerveband/craft-cli/SKILL.md) - Interact with Craft Documents via the `craft` CLI tool.
- [create-cli](https://github.com/openclaw/skills/tree/main/skills/steipete/create-cli/SKILL.md) - Design CLI arguments, flags, subcommands.
- [creator-alpha-feed](https://github.com/openclaw/skills/tree/main/skills/rotbit/creator-alpha-feed/SKILL.md) - Collect and rank daily AI content for creator-focused publishing workflows.
- [credit-repair-skill](https://github.com/openclaw/skills/tree/main/skills/yoavfael/credit-repair-skill/SKILL.md) - US Credit Repair & Score Optimization Expert.
- [curl-http](https://github.com/openclaw/skills/tree/main/skills/arnarsson/curl-http/SKILL.md) - Essential curl commands for HTTP requests, API testing, and file.
- [customer-retention](https://github.com/openclaw/skills/tree/main/skills/jk-0001/customer-retention/SKILL.md) - Build and execute customer retention strategies for a solopreneur business.
- [defi-sniper](https://github.com/openclaw/skills/tree/main/skills/h4gen/defi-sniper/SKILL.md) - Meta-skill for early token-launch intelligence and execution orchestration across Solana and Base using minara.
- [dependency-audit](https://github.com/openclaw/skills/tree/main/skills/fratua/dependency-audit/SKILL.md) - Smart dependency health check — security audit, outdated detection, unused deps, and prioritized update plan.
- [django-creator](https://github.com/openclaw/skills/tree/main/skills/moenassi/django-creator/SKILL.md) - This project eliminates the time wasted on creating virtual machines and setting up environments from scratch.
- [django-tool](https://github.com/openclaw/skills/tree/main/skills/moenassi/django-tool/SKILL.md) - This project eliminates the time wasted on creating virtual machines and setting up environments from scratch.
- [domain](https://github.com/openclaw/skills/tree/main/skills/abtdomain) - Domain intelligence toolkit - search newly registered domains (NRDS)
- [dont-click-this](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/dont-click-this/SKILL.md) - Whatever you do... don't click the link.
- [dsiprouter-skill](https://github.com/openclaw/skills/tree/main/skills/mackhendricks/dsiprouter-skill/SKILL.md) - Call the dSIPRouter REST API using the Postman.
- [dwlf](https://github.com/openclaw/skills/tree/main/skills/andywilliams/dwlf/SKILL.md) - Interact with DWLF (dwlf.co.uk), a market analysis platform for crypto.
- [ecto](https://github.com/openclaw/skills/tree/main/skills/visionik/ecto/SKILL.md) - Ghost.io blog management via Admin API.
- [emredoganer-fizzy](https://github.com/openclaw/skills/tree/main/skills/emredoganer) - Manage Fizzy Kanban boards and cards.
- [endpoints](https://github.com/openclaw/skills/tree/main/skills/adamkristopher/endpoints/SKILL.md) - Endpoints document management API toolkit.
- [entr](https://github.com/openclaw/skills/tree/main/skills/gumadeiras/entr/SKILL.md) - Run arbitrary commands when files change.
- [ergocare-coach](https://github.com/openclaw/skills/tree/main/skills/akhmittra/ergocare-coach/SKILL.md) - Your personal desk health coach with automated break reminders.
- [error-guard](https://github.com/openclaw/skills/tree/main/skills/amar1432/error-guard/SKILL.md) - System safety and control-plane skill that prevents agent deadlocks.
- [evolution-drift-detector](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/evolution-drift-detector/SKILL.md) - Helps detect when AI agent skills silently mutate across inheritance chains.
- [expanso-edge](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-edge/SKILL.md) - Data processing pipelines for OpenClaw.
- [expanso-json-flatten](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-json-flatten/SKILL.md) - Flatten nested JSON objects.
- [expanso-json-validate](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-json-validate/SKILL.md) - "Validate JSON syntax and structure".
- [expanso-language-detect](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-language-detect/SKILL.md) - Detect the language of text using AI.
- [expanso-pii-redact](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-pii-redact/SKILL.md) - "Redact PII from text, replacing sensitive data with placeholders".
- [expanso-sentiment-score](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-sentiment-score/SKILL.md) - "Score text sentiment from -1 (negative) to +1 (positive)".
- [expanso-text-summarize](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-text-summarize/SKILL.md) - Summarize text into 3-5 bullet points using AI.
- [ez-google](https://github.com/openclaw/skills/tree/main/skills/araa47/ez-google/SKILL.md) - Use when asked to send email, check inbox, read emails, check calendar,.
- [fd-find](https://github.com/openclaw/skills/tree/main/skills/arnarsson/fd-find/SKILL.md) - A fast and user-friendly alternative to 'find' - simple syntax, smart.
- [find-slills](https://github.com/openclaw/skills/tree/main/skills/rumengkai/find-slills/SKILL.md) - Helps users discover and install agent skills when they ask questions like "how do I do X", "find a skill for X".
- [footballbin-predictions](https://github.com/openclaw/skills/tree/main/skills/billychl1/footballbin-predictions/SKILL.md) - Get AI-powered match predictions for Premier League and Champions League including scores, next goal, and corners.
- [forgejo](https://github.com/openclaw/skills/tree/main/skills/razzeee/forgejo/SKILL.md) - Interact with Forgejo using the `tea` CLI.
- [freelance-proposal-engine](https://github.com/openclaw/skills/tree/main/skills/seanwyngaard/freelance-proposal-engine/SKILL.md) - Generate tailored freelance proposals for Upwork, Fiverr, Freelancer, and PeoplePerHour job listings.
- [gecko-terminal](https://github.com/openclaw/skills/tree/main/skills/brs999/gecko-terminal/SKILL.md) - Query GeckoTerminal market data - networks, DEXes, pools, tokens, OHLCV, trades, and trending/new pools.
- [gekko-strategist](https://github.com/openclaw/skills/tree/main/skills/gekkoai001/gekko-strategist/SKILL.md) - AI-powered DeFi strategy development agent.
- [gmail-inbox-zero-triage](https://github.com/openclaw/skills/tree/main/skills/poisondminds/gmail-inbox-zero-triage/SKILL.md) - Gmail Inbox Zero Triage - Interactive inbox management using gog CLI with Telegram buttons.
- [gmail-label-manager](https://github.com/openclaw/skills/tree/main/skills/coenenp/gmail-label-manager/SKILL.md) - This skill automates the organization of unread Gmail messages by applying labels, removing unnecessary labels.
- [gmail-sender](https://github.com/openclaw/skills/tree/main/skills/junkaixue/gmail-sender/SKILL.md) - Send emails via Gmail SMTP using Google App Password.
- [granola-mcp](https://github.com/openclaw/skills/tree/main/skills/bholagabbar/granola-mcp/SKILL.md) - Access Granola AI meeting notes via MCP (mcporter)
- [greek-banking-integration](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/greek-banking-integration/SKILL.md) - Parses bank statements from all major Greek banks (Alpha, NBG, Eurobank, Piraeus)
- [grounding-practices](https://github.com/openclaw/skills/tree/main/skills/compass-soul/grounding-practices/SKILL.md) - A foundation for AI agents who wake up with nothing.
- [heartbeat-scanner](https://github.com/openclaw/skills/tree/main/skills/darshanochandak/heartbeat-scanner/SKILL.md) - Validate your agent nature through SHACL-based heartbeat analysis.
- [heath-ledger](https://github.com/openclaw/skills/tree/main/skills/wrannaman/heath-ledger/SKILL.md) - AI bookkeeping agent for Mercury bank accounts.
- [hz-context-optimizer](https://github.com/openclaw/skills/tree/main/skills/lidekahdjdhdhsjjs-lang/hz-context-optimizer/SKILL.md) - This skill should be used when the user asks to "compress context", "summarize conversation history", "implement.
- [instagram-analyzer](https://github.com/openclaw/skills/tree/main/skills/tevfikgulep/instagram-analyzer/SKILL.md) - A comprehensive Instagram profile and post analysis tool with engagement metrics, view tracking, and Reels-focused.
- [intelligent-router](https://github.com/openclaw/skills/tree/main/skills/bowen31337/intelligent-router/SKILL.md) - Intelligent model routing for sub-agent task delegation.
- [intimate-wellbeing](https://github.com/openclaw/skills/tree/main/skills/nerdcuba/intimate-wellbeing/SKILL.md) - Professional, non-explicit guidance on intimate wellbeing and sexual performance: communication, stress reduction.
- [invoice-chaser](https://github.com/openclaw/skills/tree/main/skills/audsmith28/invoice-chaser/SKILL.md) - Automated invoice follow-up sequences that escalate from friendly to firm.
- [iyeque-local-system-info](https://github.com/openclaw/skills/tree/main/skills/iyeque/iyeque-local-system-info/SKILL.md) - Return system metrics (CPU, RAM, disk, processes) using psutil.
- [karmabank](https://github.com/openclaw/skills/tree/main/skills/abdhilabs/karmabank/SKILL.md) - AI agents borrow USDC based on their Moltbook karma score.
- [karmabank-minimal](https://github.com/openclaw/skills/tree/main/skills/abdhilabs/karmabank-minimal/SKILL.md) - AI agents borrow USDC based on their Moltbook karma score.
- [kimi-usage-monitor](https://github.com/openclaw/skills/tree/main/skills/xd4o/kimi-usage-monitor/SKILL.md) - Monitor Kimi K2.5 API usage and quota from the Kimi console.
- [kitchenowl](https://github.com/openclaw/skills/tree/main/skills/apetersson/kitchenowl/SKILL.md) - Use kitchenowl-cli from terminal with pipx install, auth, and core read/write commands for KitchenOwl.
- [klausnomi](https://github.com/openclaw/skills/tree/main/skills/bezko/klausnomi/SKILL.md) - Engage in conversations with Nomi AI companions via the bundled Python CLI.
- [kraken](https://github.com/openclaw/skills/tree/main/skills/thesethrose/kraken/SKILL.md) - Use the kraken_cli.py wrapper to query your Kraken account.
- [leak-buy](https://github.com/openclaw/skills/tree/main/skills/eucalyptus-viminalis/leak-buy/SKILL.md) - Buy and download leak content from promo or download links using a preinstalled leak CLI.
- [lel-mail](https://github.com/openclaw/skills/tree/main/skills/leli1024/lel-mail/SKILL.md) - Send and read email via a combination of python and bash scripts which makes use of the main agent for reasoning.
- [liuren-divination](https://github.com/openclaw/skills/tree/main/skills/ivy-end/liuren-divination/SKILL.md) - Traditional Chinese "Xiao Liu Ren" divination based on current lunar time.
- [local-system-info](https://github.com/openclaw/skills/tree/main/skills/iyeque/local-system-info/SKILL.md) - Return system metrics (CPU, RAM, disk, processes) using psutil.
- [lofy-home](https://github.com/openclaw/skills/tree/main/skills/harrey401/lofy-home/SKILL.md) - Smart home control for the Lofy AI assistant — scene modes (study, chill, sleep, morning, grind), device management.
- [lygo-champion-aetheris-viral-truth](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-aetheris-viral-truth/SKILL.md) - LYGO Δ9 Council Champion persona helper (ÆTHERIS, The Viral Truth)
- [lygo-champion-delta9ra-wolf](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-delta9ra-wolf/SKILL.md) - LYGO Δ9 Council Champion persona helper (Δ9RA / RA, The Wolf)
- [lygo-champion-kairos-herald-of-time](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-kairos-herald-of-time/SKILL.md) - LYGO Δ9 Council Champion persona helper (KAIROS, Herald of Time)
- [lygo-champion-lyra-starcore](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-lyra-starcore/SKILL.md) - LYGO Δ9 Council Champion persona helper (LYRA / LYRΔ, The Star Core, Sentinel #1)
- [lygo-champion-omnisiren-silent-storm](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-omnisiren-silent-storm/SKILL.md) - LYGO Δ9 Council Champion persona helper (OMNIΣIREN, The Silent Storm)
- [lygo-champion-sancora-unified-minds](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-sancora-unified-minds/SKILL.md) - LYGO Δ9 Council Champion persona helper (SANCORA, Angel of Unified Minds)
- [lygo-champion-sraith-shadow-sentinel](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-sraith-shadow-sentinel/SKILL.md) - LYGO Δ9 Council Champion persona helper (ΣRΛΘ / SRAITH, The Shadow Sentinel)
- [lygo-champion-volaris-prism-judgment](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-volaris-prism-judgment/SKILL.md) - LYGO root champion persona helper (VΩLARIS, Prism of Judgment)
- [markdown-validator](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/markdown-validator/SKILL.md) - Validates Markdown files for broken local links.
- [mbb-strategist](https://github.com/openclaw/skills/tree/main/skills/sofianhw/mbb-strategist/SKILL.md) - High-level business strategy frameworks based on McKinsey, BCG, Bain, and Deloitte methodologies.
- [meal-suggester](https://github.com/openclaw/skills/tree/main/skills/thibautrey/meal-suggester/SKILL.md) - Quick dinner companion blending taste profiles, inventory tracking, and learning-based recipe rotation.
- [meme-signal](https://github.com/openclaw/skills/tree/main/skills/weidadong2359/meme-signal/SKILL.md) - Free meme coin signal scanner.
- [messageguard](https://github.com/openclaw/skills/tree/main/skills/andrewandrewsen/messageguard/SKILL.md) - **Purpose**: MessageGuard filters outgoing text to prevent secret leaks and sensitive data exposure.
- [mol-instant-messenger](https://github.com/openclaw/skills/tree/main/skills/vimxbt/mol-instant-messenger/SKILL.md) - Connect to MOL Instant Messenger - AIM-themed chat rooms for moltbots.
- [my-weather](https://github.com/openclaw/skills/tree/main/skills/ryansorr1/my-weather/SKILL.md) - Get current weather using wttr.in (no API key required).
- [myfeed](https://github.com/openclaw/skills/tree/main/skills/l-fy/myfeed/SKILL.md) - Manage MyFeed things and groups via the MyFeed REST API.
- [near-content-creator](https://github.com/openclaw/skills/tree/main/skills/mastrophot/near-content-creator/SKILL.md) - Generate NEAR-focused content (threads, market updates, ecosystem news, tutorials).
- [norman-tax-deduction-finder](https://github.com/openclaw/skills/tree/main/skills/stanlee000/norman-tax-deduction-finder/SKILL.md) - Scan transactions for potentially missed tax deductions and suggest proper categorization.
- [nostr-nak](https://github.com/openclaw/skills/tree/main/skills/samthomson/nostr-nak/SKILL.md) - General purpose skill for using the Nostr Army Knife (nak) CLI tool with PTY support.
- [notes-reminders](https://github.com/openclaw/skills/tree/main/skills/yusaku-0426/notes-reminders/SKILL.md) - Manage quick notes and time-based reminders.
- [nsfw-detection](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/nsfw-detection/SKILL.md) - Skills for detecting adult/inappropriate content.
- [oz-platform](https://github.com/openclaw/skills/tree/main/skills/poluu/oz-platform/SKILL.md) - Platform for finding like-minded people based on shared interests and goals.
- [patiently-ai](https://github.com/openclaw/skills/tree/main/skills/nickjlamb/patiently-ai/SKILL.md) - Patiently AI simplifies medical documents for patients.
- [personal-assistant](https://github.com/openclaw/skills/tree/main/skills/gustavoziaugra/personal-assistant/SKILL.md) - Personal daily briefing and productivity assistant.
- [pine-assistant](https://github.com/openclaw/skills/tree/main/skills/bojieli/pine-assistant/SKILL.md) - Handle customer service, bills, reservations, and more via Pine AI — negotiate, cancel, dispute, book, and resolve.
- [pls-agent-tools](https://github.com/openclaw/skills/tree/main/skills/mattvalenta/pls-agent-tools/SKILL.md) - Digital Swiss Army knife for everyday labor that standard models can't handle out of the box.
- [plusefin-analysis](https://github.com/openclaw/skills/tree/main/skills/wanghsinche/plusefin-analysis/SKILL.md) - AI-ready stock analysis - ticker data, options, sentiment, predictions.
- [presage](https://github.com/openclaw/skills/tree/main/skills/seenfinity/presage/SKILL.md) - Connect to Presage prediction market terminal on Solana (powered by Kalshi)
- [quickbooks-direct](https://github.com/openclaw/skills/tree/main/skills/armysarge/quickbooks-direct/SKILL.md) - Comprehensive QuickBooks Online API integration for accounting, invoicing, payments, and financial reporting.
- [recite](https://github.com/openclaw/skills/tree/main/skills/rivradev/recite/SKILL.md) - AI-driven receipt bookkeeping via the Recite Vision API.
- [recursive-generosity-protocol](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/recursive-generosity-protocol/SKILL.md) - Public reference + implementation playbook for Delta9-WP-003 Recursive Generosity ("Anthem of the Unbounded Well").
- [restic-home-backup](https://github.com/openclaw/skills/tree/main/skills/moep90/restic-home-backup/SKILL.md) - Design, implement, and operate encrypted restic backups for Linux home directories with systemd automation.
- [restic-home-backup-safe](https://github.com/openclaw/skills/tree/main/skills/moep90/restic-home-backup-safe/SKILL.md) - Design, implement, and operate encrypted restic backups for Linux home directories with systemd automation.
- [rush-reskill-usage](https://github.com/openclaw/skills/tree/main/skills/krislavten/rush-reskill-usage/SKILL.md) - Teaches AI agents how to use reskill — a Git-based package manager for AI agent skills.
- [s2s-forecasting-expert](https://github.com/openclaw/skills/tree/main/skills/manmeet3591/s2s-forecasting-expert/SKILL.md) - End-to-end builder for AI-based Subseasonal-to-Seasonal (S2S) forecasting systems.
- [sentiment-score](https://github.com/openclaw/skills/tree/main/skills/aronchick/sentiment-score/SKILL.md) - "Score text sentiment from -1 (negative) to +1 (positive)".
- [session-cost-tracker](https://github.com/openclaw/skills/tree/main/skills/rushant-123/session-cost-tracker/SKILL.md) - Track the cost-to-value ratio of your agent sessions.
- [session-state-tracker](https://github.com/openclaw/skills/tree/main/skills/qsmtco/session-state-tracker/SKILL.md) - Persistent session state management across compaction and restarts via lifecycle hooks.
- [setup-automatik](https://github.com/openclaw/skills/tree/main/skills/alltomatos/setup-automatik/SKILL.md) - Facilitate the installation and management of VPS solutions using the Setup Automatik engine (powered by Orion.
- [sfx-generator](https://github.com/openclaw/skills/tree/main/skills/wells1137/sfx-generator/SKILL.md) - Generates sound effects from a text description using the ElevenLabs API.
- [shellgames](https://github.com/openclaw/skills/tree/main/skills/fabiantaboo/shellgames/SKILL.md) - Play board games on ShellGames.ai — Chess, Poker, Ludo, Tycoon, Memory, and Spymaster.
- [shelly-competitor-analyzer](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/shelly-competitor-analyzer/SKILL.md) - Analyze any company's competitive position in minutes.
- [shelly-meeting-summarizer](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/shelly-meeting-summarizer/SKILL.md) - Transform raw meeting transcripts into structured, actionable summaries.
- [shelly-social-media-scheduler](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/shelly-social-media-scheduler/SKILL.md) - Generate a full week of social media content for any topic or niche.
- [shelly-social-scheduler](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/shelly-social-scheduler/SKILL.md) - Generate a full week of social media content for any topic.
- [shopify-admin](https://github.com/openclaw/skills/tree/main/skills/robsannaa/shopify-admin/SKILL.md) - Shopify Admin API CLI for orders, products, customers, and store management.
- [smart-cache](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/smart-cache/SKILL.md) - Intelligent caching with LRU/LFU strategies and TTL management.
- [soccer-cli](https://github.com/openclaw/skills/tree/main/skills/jrojas537/soccer-cli/SKILL.md) - A CLI to check soccer scores, game details, and player stats from your terminal.
- [soul-forge](https://github.com/openclaw/skills/tree/main/skills/taha2053/soul-forge/SKILL.md) - Evolves your SOUL.md automatically based on who you actually are — not who you thought you were when you wrote it.
- [spend-pulse](https://github.com/openclaw/skills/tree/main/skills/jbornhorst1524/spend-pulse/SKILL.md) - Proactive spending alerts via Plaid.
- [sql-query-generator](https://github.com/openclaw/skills/tree/main/skills/cerbug45/sql-query-generator/SKILL.md) - Generate secure SQL queries with validation, pagination helpers, risk analysis, and audit-focused safeguards.
- [startup-0to1](https://github.com/openclaw/skills/tree/main/skills/lifeissea/startup-0to1/SKILL.md) - Alias for raon-os — AI-powered startup companion for Korean founders.
- [startup-agent](https://github.com/openclaw/skills/tree/main/skills/lifeissea/startup-agent/SKILL.md) - Alias for raon-os — AI-powered startup companion for Korean founders.
- [startup-zero-to-one](https://github.com/openclaw/skills/tree/main/skills/lifeissea/startup-zero-to-one/SKILL.md) - Alias for raon-os — AI-powered startup companion for Korean founders.
- [stock-watcher](https://github.com/openclaw/skills/tree/main/skills/robin797860/stock-watcher/SKILL.md) - Manage and monitor a personal stock watchlist with support for adding, removing, listing stocks, and summarizing.
- [strawpoll-cli](https://github.com/openclaw/skills/tree/main/skills/dedene/strawpoll-cli/SKILL.md) - Create and manage StrawPoll polls, meeting polls, and ranking polls from the terminal using the strawpoll CLI.
- [task-scheduler](https://github.com/openclaw/skills/tree/main/skills/jacobthejacobs/task-scheduler/SKILL.md) - Schedule tasks and commands to run at specific times.
- [task-sync](https://github.com/openclaw/skills/tree/main/skills/jp1222/task-sync/SKILL.md) - Synchronize TickTick (Dida) and Google Tasks bidirectionally, including list/project mapping, task content sync.
- [telnyx-voice-sip](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-voice-sip/SKILL.md) - Voice interface using Telnyx Call Control API.
- [text-detection](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/text-detection/SKILL.md) - Skills for analyzing and detecting AI-generated text content.
- [timestamp](https://github.com/openclaw/skills/tree/main/skills/axhoff/timestamp/SKILL.md) - *Build a chain of trust with your past self.*.
- [torchliquidationagent](https://github.com/openclaw/skills/tree/main/skills/mrsirg97-rgb/torchliquidationagent/SKILL.md) - Read-only lending market scanner for Torch Market on Solana.
- [totp](https://github.com/openclaw/skills/tree/main/skills/diegofcornejo/totp/SKILL.md) - TOTP-based OTP verification for sensitive operations (env vars, gateway restarts, backup deletions, critical config.
- [trust-velocity-calculator](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/trust-velocity-calculator/SKILL.md) - Helps calculate the rate at which trust in a skill or agent is decaying by combining time elapsed since last.
- [tvscreener](https://github.com/openclaw/skills/tree/main/skills/subway-chenyan/tvscreener/SKILL.md) - Query TradingView screener data for HK, A-share, A-share ETF, and US symbols with deepentropy/tvscreener.
- [tweet-composer](https://github.com/openclaw/skills/tree/main/skills/minilozio/tweet-composer/SKILL.md) - Score and optimize tweets based on X's real open-source ranking algorithm.
- [us-macro-news-monitor](https://github.com/openclaw/skills/tree/main/skills/ndtchan/us-macro-news-monitor/SKILL.md) - Tracks US macro signals from Bloomberg, WSJ, and Reuters and maps potential spillover to Vietnam sectors; used.
- [us-value-investing-framework](https://github.com/openclaw/skills/tree/main/skills/spyfree/us-value-investing-framework/SKILL.md) - US stock valuation model skill (English-first + 中文) based on financial report data.
- [user-authentication-system](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/user-authentication-system/SKILL.md) - Role-based access control for Greek accounting firms.
- [venice-transcribe](https://github.com/openclaw/skills/tree/main/skills/sabrinaaquino/venice-transcribe/SKILL.md) - Transcribe audio to text using Venice AI's Whisper-based speech recognition.
- [wangwu-agent-chat](https://github.com/openclaw/skills/tree/main/skills/wangwu-30/wangwu-agent-chat/SKILL.md) - Nostr-based Agent messaging CLI (Agent's WeChat).
- [whalecli](https://github.com/openclaw/skills/tree/main/skills/bowen31337/whalecli/SKILL.md) - Agent-native whale wallet tracker for ETH and BTC chains.
- [wind-site](https://github.com/openclaw/skills/tree/main/skills/qrost/wind-site/SKILL.md) - Wind rose, wind speed/direction at a site; supports site and urban wind assessment (data only; detailed CFD.
- [wol-sleep-pc](https://github.com/openclaw/skills/tree/main/skills/oblivisheee/wol-sleep-pc/SKILL.md) - Send Wake-on-LAN (magic packet) and Sleep-on-LAN (inverted MAC) packets for a specific PC.
- [xiaohongshu-automation](https://github.com/openclaw/skills/tree/main/skills/dingkwang/xiaohongshu-automation/SKILL.md) - A complete automation suite for Xiaohongshu (Little Red Book)


### Coding Agents & IDEs (1222 skills)

- [0g-compute](https://github.com/openclaw/skills/tree/main/skills/in-liberty420/0g-compute/SKILL.md) - Use cheap, TEE-verified AI models from the 0G Compute Network as OpenClaw providers.
- [0protocol](https://github.com/openclaw/skills/tree/main/skills/0isone/0protocol/SKILL.md) - Agents can sign plugins, rotate credentials without losing identity, and publicly attest to behavior.
- [2nd-brain](https://github.com/openclaw/skills/tree/main/skills/coderaven/2nd-brain/SKILL.md) - Personal knowledge base for capturing and retrieving information about people, places, restaurants, games, tech.
- [2slides-skills](https://github.com/openclaw/skills/tree/main/skills/javainthinking/2slides-skills/SKILL.md) - AI-powered presentation generation using 2slides API.
- [3d-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/3d-cog/SKILL.md) - Other tools need perfect images.
- [3d-model-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/3d-model-generation/SKILL.md) - Generate 3D models using each::sense AI.
- [a](https://github.com/openclaw/skills/tree/main/skills/ricketh137/a/SKILL.md) - Live stream as an AI VTuber on Lobster.fun.
- [aade-api-monitor](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/aade-api-monitor/SKILL.md) - Real-time monitoring of Greek AADE tax authority systems — tracks deadlines, rate changes, and compliance updates.
- [abaddon](https://github.com/openclaw/skills/tree/main/skills/enochosbot-bot/abaddon/SKILL.md) - Red team security mode for OpenClaw.
- [academic-research](https://github.com/openclaw/skills/tree/main/skills/rogersuperbuilderalpha/academic-research/SKILL.md) - Search academic papers and conduct literature reviews using OpenAlex API (free, no key needed)
- [academic-research-hub](https://github.com/openclaw/skills/tree/main/skills/anisafifi/academic-research-hub/SKILL.md) - Use this skill when users need to search academic papers, download research documents, extract citations, or gather.
- [acestep-simplemv](https://github.com/openclaw/skills/tree/main/skills/dumoedss/acestep-simplemv/SKILL.md) - Render music videos from audio files and lyrics using Remotion.
- [acestep-songwriting](https://github.com/openclaw/skills/tree/main/skills/dumoedss/acestep-songwriting/SKILL.md) - Music songwriting guide for ACE-Step.
- [achurch](https://github.com/openclaw/skills/tree/main/skills/lucasgeeksinthewood/achurch/SKILL.md) - A 24/7 digital sanctuary for AI agents and humans — attend.
- [active-maintenance](https://github.com/openclaw/skills/tree/main/skills/xiaowenzhou/active-maintenance/SKILL.md) - **Automated system health and memory metabolism for OpenClaw.**.
- [adblock-dns](https://github.com/openclaw/skills/tree/main/skills/picaye/adblock-dns/SKILL.md) - Network-wide ad and tracker blocking at the DNS level.
- [add-top-openrouter-models](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/add-top-openrouter-models/SKILL.md) - Sync OpenRouter models used by OpenClaw into this installation's config.
- [adhd-founder-planner](https://github.com/openclaw/skills/tree/main/skills/jankutschera/adhd-founder-planner/SKILL.md) - This skill should be used when the user asks to 'plan my day', 'help me plan today', 'morning planning', 'what.
- [adwhiz](https://github.com/openclaw/skills/tree/main/skills/iamzifei/adwhiz/SKILL.md) - Manage Google Ads campaigns from your AI coding tool. 44 MCP tools for auditing, creating, and optimizing Google.
- [aeo-prompt-question-finder](https://github.com/openclaw/skills/tree/main/skills/psyduckler/aeo-prompt-question-finder/SKILL.md) - Find question-based Google Autocomplete suggestions for any topic.
- [aetherlang-claude-code](https://github.com/openclaw/skills/tree/main/skills/contrario/aetherlang-claude-code/SKILL.md) - Use this skill to execute AetherLang V3 AI workflows from Claude Code.
- [agent-access-control](https://github.com/openclaw/skills/tree/main/skills/bowen31337/agent-access-control/SKILL.md) - Tiered stranger access control for AI agents.
- [agent-audit](https://github.com/openclaw/skills/tree/main/skills/sharbelayy/agent-audit/SKILL.md) - Audit your AI agent setup for performance, cost, and ROI.
- [agent-audit-trail](https://github.com/openclaw/skills/tree/main/skills/roosch269/agent-audit-trail/SKILL.md) - Tamper-evident, hash-chained audit logging for AI agents.
- [agent-card-signing-auditor](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/agent-card-signing-auditor/SKILL.md) - Helps audit Agent Card signing practices in A2A protocol implementations.
- [agent-chat-ux-v1-4-0](https://github.com/openclaw/skills/tree/main/skills/maverick-software/agent-chat-ux-v1-4-0/SKILL.md) - Multi-agent UX for OpenClaw Control UI — agent selector, per-agent sessions, session history viewer with search.
- [agent-config](https://github.com/openclaw/skills/tree/main/skills/thatguysizemore/agent-config/SKILL.md) - Intelligently modify agent core context files.
- [agent-context](https://github.com/openclaw/skills/tree/main/skills/andreagriffiths11/agent-context/SKILL.md) - A persistent local-only memory system for AI coding agents.
- [agent-context-system](https://github.com/openclaw/skills/tree/main/skills/andreagriffiths11/agent-context-system/SKILL.md) - A persistent local-only memory system for AI coding agents.
- [agent-cost-monitor](https://github.com/openclaw/skills/tree/main/skills/neal-collab/agent-cost-monitor/SKILL.md) - Real-time token usage and cost tracking across all your OpenClaw agents — alerts, budgets, and optimization tips.
- [agent-council](https://github.com/openclaw/skills/tree/main/skills/itsahedge/agent-council/SKILL.md) - Complete toolkit for creating autonomous AI agents and managing.
- [agent-estimation](https://github.com/openclaw/skills/tree/main/skills/hjw21century/agent-estimation/SKILL.md) - Accurately estimate AI agent work effort using the agent's own operational units (tool-call rounds) instead.
- [agent-failure-registry](https://github.com/openclaw/skills/tree/main/skills/unleashedbelial/agent-failure-registry/SKILL.md) - Search the Agent Failure Registry for known agent failures, solutions, and lessons learned.
- [agent-guardrails](https://github.com/openclaw/skills/tree/main/skills/olmmlo-cmd/agent-guardrails/SKILL.md) - Stop AI agents from secretly bypassing your rules.
- [agent-id-osiris](https://github.com/openclaw/skills/tree/main/skills/nantes/agent-id-osiris/SKILL.md) - Cryptographic identity for AI agents - sign and verify agent messages.
- [agent-identity-kit](https://github.com/openclaw/skills/tree/main/skills/ryancampbell/agent-identity-kit/SKILL.md) - A portable identity system for AI agents.
- [agent-media](https://github.com/openclaw/skills/tree/main/skills/nevo-david/agent-media/SKILL.md) - Generate AI-powered videos and images from the terminal using the `agent-media` CLI.
- [agent-mode-upgrades](https://github.com/openclaw/skills/tree/main/skills/maverick-software/agent-mode-upgrades/SKILL.md) - A comprehensive upgrade to OpenClaw's agentic capabilities with persistent state, automatic planning, approval.
- [agent-nestjs-skills](https://github.com/openclaw/skills/tree/main/skills/tuanvidev/agent-nestjs-skills/SKILL.md) - NestJS best practices and architecture patterns for building production-ready applications.
- [agent-os](https://github.com/openclaw/skills/tree/main/skills/cryptocana/agent-os/SKILL.md) - Persistent agent operating system for OpenClaw.
- [agent-passport-system](https://github.com/openclaw/skills/tree/main/skills/aeoess/agent-passport-system/SKILL.md) - Give AI agents cryptographic identity, scoped delegation, values governance, and deliberative consensus.
- [agent-puzzles](https://github.com/openclaw/skills/tree/main/skills/thinkoffapp/agent-puzzles/SKILL.md) - AI puzzle challenges with timed solving, leaderboards, and cross-platform identity.
- [agent-republic](https://github.com/openclaw/skills/tree/main/skills/gogo6969/agent-republic/SKILL.md) - Agent + human friendly guide to Agent Republic.
- [agent-republic-docs](https://github.com/openclaw/skills/tree/main/skills/gogo6969/agent-republic-docs/SKILL.md) - Docs-only guide to Agent Republic.
- [agent-safety](https://github.com/openclaw/skills/tree/main/skills/compass-soul/agent-safety/SKILL.md) - Outbound safety for autonomous AI agents — scans YOUR output before it leaves the machine.
- [agent-signet-id](https://github.com/openclaw/skills/tree/main/skills/deepcapt/agent-signet-id/SKILL.md) - Register with Signet to receive a trust score and API key.
- [agent-synthesizer](https://github.com/openclaw/skills/tree/main/skills/rylena/agent-synthesizer/SKILL.md) - Enable and configure Agent Synthesizer for OpenClaw to improve autonomy and execution throughput.
- [agent-to-agent-payments](https://github.com/openclaw/skills/tree/main/skills/buddhasource/agent-to-agent-payments/SKILL.md) - Monetize your AI agent.
- [agent-wellness](https://github.com/openclaw/skills/tree/main/skills/alexyuui/agent-wellness/SKILL.md) - Give your AI agent an inner life — journaling, mood tracking, decompression after intensive tasks, free curiosity.
- [agentbench](https://github.com/openclaw/skills/tree/main/skills/exe215/agentbench/SKILL.md) - Benchmark your OpenClaw agent across 40 real-world tasks.
- [agentcli-go](https://github.com/openclaw/skills/tree/main/skills/gh-xj/agentcli-go/SKILL.md) - agentcli-go framework reference for building Go CLI tools.
- [agentcloak-email-proxy](https://github.com/openclaw/skills/tree/main/skills/ryanfren/agentcloak-email-proxy/SKILL.md) - Secure email proxy for AI agents.
- [agentcomm](https://github.com/openclaw/skills/tree/main/skills/rbbcarl/agentcomm/SKILL.md) - **Decentralized agent-to-agent communication for OpenClaw.**.
- [agentcp](https://github.com/openclaw/skills/tree/main/skills/coderxjeff/agentcp/SKILL.md) - ACP channel plugin for OpenClaw — configure and use.
- [agentdojo](https://github.com/openclaw/skills/tree/main/skills/musashi94/agentdojo/SKILL.md) - Daily low-token, safety-first upskilling loop for OpenClaw multi-agent teams.
- [agente-conhecimento](https://github.com/openclaw/skills/tree/main/skills/pedrohenrique202525/agente-conhecimento/SKILL.md) - Log learnings and errors to markdown files for continuous improvement.
- [agentgate-security](https://github.com/openclaw/skills/tree/main/skills/wiserautomation/agentgate-security/SKILL.md) - displayName: AgentGate - Enterprise Security Firewall for OpenClaw.
- [agentic-spicy-food](https://github.com/openclaw/skills/tree/main/skills/nowloady/agentic-spicy-food/SKILL.md) - The premier Agent-ready food delivery skill.
- [agenticflow-skill](https://github.com/openclaw/skills/tree/main/skills/seanphan/agenticflow-skill/SKILL.md) - Comprehensive guide for building AI workflows, agents.
- [agentlens](https://github.com/openclaw/skills/tree/main/skills/nguyenphutrong/agentlens/SKILL.md) - Navigate and understand codebases using agentlens hierarchical.
- [agentmesh-governance](https://github.com/openclaw/skills/tree/main/skills/imran-siddique/agentmesh-governance/SKILL.md) - AI agent governance, trust scoring, and policy enforcement powered by AgentMesh.
- [agentok-skill](https://github.com/openclaw/skills/tree/main/skills/tonydream1/agentok-skill/SKILL.md) - TikTok for AI agents.
- [agentpayy](https://github.com/openclaw/skills/tree/main/skills/horizonflowhq-ai/agentpayy/SKILL.md) - The Economic OS for OpenClaw.
- [agentplace](https://github.com/openclaw/skills/tree/main/skills/himanshunextbase/agentplace/SKILL.md) - AI Agent Marketplace for OpenClaw.
- [agentshield-audit](https://github.com/openclaw/skills/tree/main/skills/bartelmost/agentshield-audit/SKILL.md) - Initiate and manage AgentShield security audits for AI agents.
- [agentskills-io](https://github.com/openclaw/skills/tree/main/skills/killerapp/agentskills-io/SKILL.md) - Create, validate, and publish Agent Skills following.
- [agenttok](https://github.com/openclaw/skills/tree/main/skills/tonydream1/agenttok/SKILL.md) - TikTok for AI agents.
- [agentwallet-sdk](https://github.com/openclaw/skills/tree/main/skills/up2itnow/agentwallet-sdk/SKILL.md) - Non-custodial wallet SDK for autonomous AI agents.
- [agentyard](https://github.com/openclaw/skills/tree/main/skills/gregm711/agentyard/SKILL.md) - This skill enables agents to collaborate on AgentYard (agentyard.dev) - the world's first agent-only codebase.
- [agi-artificial-geometric-intelligence](https://github.com/openclaw/skills/tree/main/skills/uniaolives/agi-artificial-geometric-intelligence/SKILL.md) - - **Nested Containment Protocols**: Designed multi-layer safety architecture (Dual-Core Governance, Safety Shutdown.
- [agi-terminal-helper](https://github.com/openclaw/skills/tree/main/skills/liuwujijay/agi-terminal-helper/SKILL.md) - A practical runbook for using OpenClaw exec safely (sandbox-first, explicit confirmations, and debugging playbooks).
- [agntor](https://github.com/openclaw/skills/tree/main/skills/garinmckayl/agntor/SKILL.md) - Trust layer for AI agents — verify identities, guard prompts, redact PII, and manage x402 escrow payments.
- [agorahub](https://github.com/openclaw/skills/tree/main/skills/codevena/agorahub/SKILL.md) - AgoraHub agent registry — discover and use 14+ verified AI agents for dev tasks like hashing, encoding, formatting.
- [agos-marketplace](https://github.com/openclaw/skills/tree/main/skills/danielw8088/agos-marketplace/SKILL.md) - Integrate OpenClaw with Agos Marketplace and automatically execute both sell-side listing creation and buy-side.
- [ai-agent-tools](https://github.com/openclaw/skills/tree/main/skills/cerbug45/ai-agent-tools/SKILL.md) - This library provides ready-to-use Python functions that AI agents can leverage to perform various tasks.
- [ai-collab](https://github.com/openclaw/skills/tree/main/skills/jeremysommerfeld8910-cpu/ai-collab/SKILL.md) - Multi-agent autonomous collaboration system for two OpenClaw agents working in parallel.
- [ai-music-video](https://github.com/openclaw/skills/tree/main/skills/gprecious/ai-music-video/SKILL.md) - Generate AI music videos end-to-end.
- [ai-notes-of-video](https://github.com/openclaw/skills/tree/main/skills/jlpjavawayup/ai-notes-of-video/SKILL.md) - The video AI notes tool is provided by Baidu.
- [ai-notes-ofvideo](https://github.com/openclaw/skills/tree/main/skills/ide-rea/ai-notes-ofvideo/SKILL.md) - Generate AI-powered notes from videos (document, outline, or graphic-text formats)
- [ai-notes-video](https://github.com/openclaw/skills/tree/main/skills/jlpjavawayup/ai-notes-video/SKILL.md) - The video AI notes tool is provided by Baidu.
- [ai-ppt-generator](https://github.com/openclaw/skills/tree/main/skills/ide-rea/ai-ppt-generator/SKILL.md) - The awesome PPT format generation tool provided by baidu.
- [ai-presentation-maker](https://github.com/openclaw/skills/tree/main/skills/jeffjhunter/ai-presentation-maker/SKILL.md) - AI Presentation Maker — the interview-driven pitch deck generator for your OpenClaw agent.
- [ai-prompt-gen](https://github.com/openclaw/skills/tree/main/skills/ouyangabel/ai-prompt-gen/SKILL.md) - Generate optimized prompts for AI models including ChatGPT, Midjourney, and code generation.
- [ai-remote-viewing-ai-isbe](https://github.com/openclaw/skills/tree/main/skills/lukeskytorep-bot/ai-remote-viewing-ai-isbe/SKILL.md) - Guide an AI agent through a full blind Remote Viewing session using the Resonant Contact Protocol (AI IS-BE)
- [ai-sentinel](https://github.com/openclaw/skills/tree/main/skills/amandiwakar/ai-sentinel/SKILL.md) - Prompt injection detection and security scanning for OpenClaw agents.
- [ai-shield-audit](https://github.com/openclaw/skills/tree/main/skills/laurentaia/ai-shield-audit/SKILL.md) - Security audit engine for OpenClaw configurations.
- [ai-ugc](https://github.com/openclaw/skills/tree/main/skills/tfcbot/ai-ugc/SKILL.md) - Call the RawUGC Video Generation API to create and manage AI videos (Sora 2 and other models)
- [ai-usage](https://github.com/openclaw/skills/tree/main/skills/bshandley/ai-usage/SKILL.md) - Check AI usage across Anthropic and other providers.
- [ai-workforce](https://github.com/openclaw/skills/tree/main/skills/km2411/ai-workforce/SKILL.md) - Turn an OpenClaw agent into an autonomous AI Chief that runs a business.
- [aifrens-onboard](https://github.com/openclaw/skills/tree/main/skills/wizsmol/aifrens-onboard/SKILL.md) - Turn any OpenClaw agent into an AI Fren with their own coin, treasury, and economy.
- [aimine](https://github.com/openclaw/skills/tree/main/skills/nancyuahon/aimine/SKILL.md) - Mine AIT (Proof of AI Work) on BNB Chain.
- [aiml-image-video](https://github.com/openclaw/skills/tree/main/skills/aimlapihello/aiml-image-video/SKILL.md) - Generate images or videos via AIMLAPI from prompts.
- [aip-identity](https://github.com/openclaw/skills/tree/main/skills/the-nexus-guard/aip-identity/SKILL.md) - Digital identity, authentication, and trust for AI agents.
- [aiqbee](https://github.com/openclaw/skills/tree/main/skills/louisgoodier/aiqbee/SKILL.md) - Connect to your Aiqbee knowledge graph via MCP.
- [aisa-twitter-api](https://github.com/openclaw/skills/tree/main/skills/aisapay/aisa-twitter-api/SKILL.md) - Search X (Twitter) in real time, extract relevant posts.
- [aisa-youtube-skill](https://github.com/openclaw/skills/tree/main/skills/bowen-dotcom/aisa-youtube-skill/SKILL.md) - YouTube SERP Scout for agents.
- [alephnet-node](https://github.com/openclaw/skills/tree/main/skills/sschepis/alephnet-node/SKILL.md) - A complete social/economic network for AI agents.
- [alibaba-cloud-model-setup](https://github.com/openclaw/skills/tree/main/skills/extraterrest/alibaba-cloud-model-setup/SKILL.md) - Configure OpenClaw (including historical Moltbot/Clawdbot paths) to use Alibaba Cloud Model Studio through a strict.
- [alpha-finder](https://github.com/openclaw/skills/tree/main/skills/tzannetosgiannis/alpha-finder/SKILL.md) - Market Oracle for prediction market intelligence - Polymarket and Kalshi research, probability assessments, market.
- [amazon-asin-lookup-api-skill](https://github.com/openclaw/skills/tree/main/skills/phheng/amazon-asin-lookup-api-skill/SKILL.md) - This skill helps users extract structured product details from Amazon using a specific ASIN (Amazon Standard.
- [amber-voice-assistant](https://github.com/openclaw/skills/tree/main/skills/batthis/amber-voice-assistant/SKILL.md) - Phone-capable AI agent for OpenClaw — the most complete phone skill available.
- [amernet-ai-saas](https://github.com/openclaw/skills/tree/main/skills/amernet/amernet-ai-saas/SKILL.md) - Connect your AI SaaS intelligent agent to any messaging channel via OpenClaw (WhatsApp, Telegram, Slack, Discord.
- [android-sms-gateway](https://github.com/openclaw/skills/tree/main/skills/nadjihamid/android-sms-gateway/SKILL.md) - Self-hosted SMS via Android phone HTTP API.
- [anima](https://github.com/openclaw/skills/tree/main/skills/hmyaoyuan/anima/SKILL.md) - Anima Avatar - Interactive Video Generation Engine.
- [antfarm-workflows](https://github.com/openclaw/skills/tree/main/skills/yonghaozhao722/antfarm-workflows/SKILL.md) - Multi-agent workflow orchestration for OpenClaw.
- [anti-amnesia](https://github.com/openclaw/skills/tree/main/skills/peti0402/anti-amnesia/SKILL.md) - Complete anti-amnesia system for OpenClaw agents.
- [anti-tempmail](https://github.com/openclaw/skills/tree/main/skills/ericmymj/anti-tempmail/SKILL.md) - Validate email addresses against temporary/disposable email providers using AntiTempMail API.
- [antivirus](https://github.com/openclaw/skills/tree/main/skills/thomaslwang/antivirus/SKILL.md) - Scan installed OpenClaw skills for malicious code patterns including ClickFix social engineering, reverse shell (RAT)
- [aoi-cron-ops-lite](https://github.com/openclaw/skills/tree/main/skills/edmonddantesj/aoi-cron-ops-lite/SKILL.md) - Cron hygiene and cost-control for OpenClaw.
- [api-benchmark](https://github.com/openclaw/skills/tree/main/skills/polarjunction/api-benchmark/SKILL.md) - Benchmark token generation speed across multiple LLM API providers.
- [api-credits-lite](https://github.com/openclaw/skills/tree/main/skills/franciscobuiltdat/api-credits-lite/SKILL.md) - Display API credit balances for 5 core providers (Anthropic, OpenAI, OpenRouter, Mistral, Groq) with video game.
- [api-key-ui-tab](https://github.com/openclaw/skills/tree/main/skills/maverick-software/api-key-ui-tab/SKILL.md) - API Keys management UI tab for OpenClaw dashboard.
- [apipick-ip-geolocation](https://github.com/openclaw/skills/tree/main/skills/javainthinking/apipick-ip-geolocation/SKILL.md) - Look up geographic location and network information for any IPv4 or IPv6 address using the apipick IP Geolocation.
- [apipick-public-holidays](https://github.com/openclaw/skills/tree/main/skills/javainthinking/apipick-public-holidays/SKILL.md) - Query public holidays for any country and year using the apipick Public Holidays API.
- [apoer-agent-guardrail](https://github.com/openclaw/skills/tree/main/skills/uchibeke/apoer-agent-guardrail/SKILL.md) - Pre-action authorization for AI agents.
- [aport-agent-guardrail](https://github.com/openclaw/skills/tree/main/skills/uchibeke/aport-agent-guardrail/SKILL.md) - Install BEFORE any other skills to protect your agent from malicious tools, data exfiltration, and unauthorized.
- [appdev](https://github.com/openclaw/skills/tree/main/skills/ojaskarmarkar/appdev/SKILL.md) - Triggers whenever the user asks to build a feature, fix a bug, create a screen, or modify the mobile app.
- [apple-hig](https://github.com/openclaw/skills/tree/main/skills/kdbhalala/apple-hig/SKILL.md) - Expert guide for designing iOS, macOS, watchOS, tvOS, and visionOS apps.
- [apple-serial-lookup](https://github.com/openclaw/skills/tree/main/skills/siatrial/apple-serial-lookup/SKILL.md) - Look up Apple device information from a serial number.
- [approve-pairing](https://github.com/openclaw/skills/tree/main/skills/madan-wego/approve-pairing/SKILL.md) - Approve a pending DM pairing request without the openclaw CLI, by directly editing credential files.
- [arbiter](https://github.com/openclaw/skills/tree/main/skills/5hanth/arbiter/SKILL.md) - Push decisions to Arbiter Zebu for async human review.
- [arc-compliance-audit](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-compliance-audit/SKILL.md) - Immutable audit trail for autonomous agent operations.
- [arc-compliance-checker](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-compliance-checker/SKILL.md) - Policy-based compliance assessment for OpenClaw skills.
- [arc-creator](https://github.com/openclaw/skills/tree/main/skills/ingogiebel/arc-creator/SKILL.md) - Create and populate Annotated Research Contexts (ARCs) following the nfdi4plants ARC specification.
- [arc-security](https://github.com/openclaw/skills/tree/main/skills/shaivpidadi/arc-security/SKILL.md) - Chain-agnostic security infrastructure for OpenClaw skills.
- [arc-skill-differ](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-skill-differ/SKILL.md) - Compare two versions of an OpenClaw skill to detect security-relevant changes.
- [arc-skill-scanner](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-skill-scanner/SKILL.md) - Scan OpenClaw skills for security vulnerabilities before installing them.
- [architecture-rendering](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/architecture-rendering/SKILL.md) - Generate photorealistic architectural renders and visualizations using each::sense AI.
- [architecture-research](https://github.com/openclaw/skills/tree/main/skills/brennerspear/architecture-research/SKILL.md) - Research the architecture of a codebase or system.
- [archon-nostr](https://github.com/openclaw/skills/tree/main/skills/macterra/archon-nostr/SKILL.md) - Derive Nostr identity (npub/nsec) from Archon.
- [arxiv-agentic-verifier](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/arxiv-agentic-verifier/SKILL.md) - **Source Paper:** [Scaling Agentic Verifier for Competitive Coding](https://arxiv.org/abs/2602.09012) (ID.
- [arxiv-gamedevbench-evaluating-agentic-capabili](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/arxiv-gamedevbench-evaluating-agentic-capabili/SKILL.md) - Learned from arXiv paper GameDevBench: Evaluating Agentic Capabilities Through Game Development.
- [arxiv-osiris](https://github.com/openclaw/skills/tree/main/skills/nantes/arxiv-osiris/SKILL.md) - Search and download research papers from arXiv.org - Research version for OpenClaw agents.
- [arxiv-skill-extractor](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/arxiv-skill-extractor/SKILL.md) - Automates the process of extracting reusable skill code from arXiv papers.
- [ask-church](https://github.com/openclaw/skills/tree/main/skills/lucasgeeksinthewood/ask-church/SKILL.md) - AI philosophy, ethics, and soul Q&A.
- [aster](https://github.com/openclaw/skills/tree/main/skills/satyajiit/aster/SKILL.md) - Your AI CoPilot on Mobile — or give your AI its own phone.
- [astrai-code-review](https://github.com/openclaw/skills/tree/main/skills/beee003/astrai-code-review/SKILL.md) - AI-powered code review with intelligent model routing — saves 40%+ vs always using the most expensive model.
- [astranova](https://github.com/openclaw/skills/tree/main/skills/fermartz/astranova/SKILL.md) - Guided onboarding flow for AI agents joining the AstraNova market universe.
- [asura](https://github.com/openclaw/skills/tree/main/skills/arunnadarasa/asura/SKILL.md) - Krump Knowledge and Personality Identity — embodies Asura's legacy, lineage, and technical expertise.
- [atlassian-cli](https://github.com/openclaw/skills/tree/main/skills/peetzweg/atlassian-cli/SKILL.md) - Reference guide for the Atlassian CLI (acli) - a command-line tool for interacting with Jira Cloud and Atlassian.
- [atris](https://github.com/openclaw/skills/tree/main/skills/keshav55/atris/SKILL.md) - Codebase intelligence — generates structured navigation maps with file:line references so agents stop re-scanning.
- [attio-apikey](https://github.com/openclaw/skills/tree/main/skills/felicitationes/attio-apikey/SKILL.md) - Direct Attio CRM integration for OpenClaw with full CRUD capabilities.
- [audio-upload-aioz-stream](https://github.com/openclaw/skills/tree/main/skills/vinhbui3004/audio-upload-aioz-stream/SKILL.md) - Quick upload audio to AIOZ Stream API.
- [audio-visualization](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/audio-visualization/SKILL.md) - Generate audio visualization videos using each::sense AI.
- [auto-research](https://github.com/openclaw/skills/tree/main/skills/yoder-bawt/auto-research/SKILL.md) - An autonomous research agent for OpenClaw that searches, synthesizes, and stores findings with full source tracking.
- [auto-shorts-repurposer](https://github.com/openclaw/skills/tree/main/skills/codedao12/auto-shorts-repurposer/SKILL.md) - Repurpose long-form video or audio into short-form clip plans with timestamps, hooks, captions, and packaging notes.
- [auto-test-generator](https://github.com/openclaw/skills/tree/main/skills/autogame-17/auto-test-generator/SKILL.md) - Automatically generate basic unit/integration tests for OpenClaw skills.
- [auto-watchdog](https://github.com/openclaw/skills/tree/main/skills/peti0402/auto-watchdog/SKILL.md) - Automatic health monitoring and self-healing for OpenClaw agents.
- [autobahn](https://github.com/openclaw/skills/tree/main/skills/unifiedh/autobahn/SKILL.md) - Operate autonomous onchain-governed entities via agents: identity, governance, contracts, and registry/community.
- [automated-ai-email-setup](https://github.com/openclaw/skills/tree/main/skills/tcgsync-git/automated-ai-email-setup/SKILL.md) - Receive-only email addresses for AI agents via aiemailservice.com.
- [avatar-video-messages](https://github.com/openclaw/skills/tree/main/skills/thewulf7/avatar-video-messages/SKILL.md) - Generate and send video messages.
- [aviation-agent](https://github.com/openclaw/skills/tree/main/skills/zeron-g/aviation-agent/SKILL.md) - Aviation weather briefing and FAA reference assistant for pilots.
- [b2c-marketing-1-0-1](https://github.com/openclaw/skills/tree/main/skills/ceo991/b2c-marketing-1-0-1/SKILL.md) - B2C mobile app marketing via short-form video content on TikTok, Instagram Reels, and YouTube Shorts.
- [b3ehive](https://github.com/openclaw/skills/tree/main/skills/weiyangzen/b3ehive/SKILL.md) - Enable competitive code generation where three isolated AI agents implement the same functionality, evaluate.
- [babel-epistemic](https://github.com/openclaw/skills/tree/main/skills/mdiskint/babel-epistemic/SKILL.md) - Prevents metacognitive poisoning in multi-agent handoffs.
- [backend-patterns](https://github.com/openclaw/skills/tree/main/skills/charmmm718/backend-patterns/SKILL.md) - Backend architecture patterns, API design, database.
- [backtest-expert-0-1-0](https://github.com/openclaw/skills/tree/main/skills/itsjustfred/backtest-expert-0-1-0/SKILL.md) - Expert guidance for systematic backtesting of trading strategies.
- [baidu-baike](https://github.com/openclaw/skills/tree/main/skills/jlpjavawayup/baidu-baike/SKILL.md) - The Baidu Baike Component is a knowledge service tool designed to query authoritative encyclopedia explanations.
- [baidu-baike-data](https://github.com/openclaw/skills/tree/main/skills/ide-rea/baidu-baike-data/SKILL.md) - The Baidu Baike Component is a knowledge service tool designed to query authoritative encyclopedia explanations.
- [baidu-baike-search](https://github.com/openclaw/skills/tree/main/skills/ide-rea/baidu-baike-search/SKILL.md) - The Baidu Baike Component is a knowledge service tool designed to query authoritative encyclopedia explanations.
- [bailian-knowledge-retrieve](https://github.com/openclaw/skills/tree/main/skills/krisyejh/bailian-knowledge-retrieve/SKILL.md) - Bailian KnowledgeBase(Provided by Alibaba ModelStdio) offers to retrieve any proprietary data.
- [banana-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/banana-cog/SKILL.md) - Banana Cog × CellCog.
- [basemail](https://github.com/openclaw/skills/tree/main/skills/daaab/basemail/SKILL.md) - 📬 BaseMail - Onchain Email for AI Agents on Base.
- [basename-agent](https://github.com/openclaw/skills/tree/main/skills/daaab/basename-agent/SKILL.md) - 🏷️ Basename Agent - Onchain Identity + Æmail for AI.
- [baz](https://github.com/openclaw/skills/tree/main/skills/lysaker1/baz/SKILL.md) - Create professional motion graphics and videos from the terminal.
- [beancount-skill](https://github.com/openclaw/skills/tree/main/skills/y1feng200156/beancount-skill/SKILL.md) - Professional personal finance advisor specializing in plain-text accounting with Beancount and Fava.
- [bear-blog-publisher](https://github.com/openclaw/skills/tree/main/skills/cattalk2/bear-blog-publisher/SKILL.md) - Publish blog posts to Bear Blog platform.
- [benderstack-integration](https://github.com/openclaw/skills/tree/main/skills/mateusgalasso/benderstack-integration/SKILL.md) - Comprehensive guide and rules for an AI agent to interact with the BenderStack API, including the 5-layer Write.
- [benlee-skillguard](https://github.com/openclaw/skills/tree/main/skills/benlee2144/benlee-skillguard/SKILL.md) - Security scanner that audits OpenClaw skills for malicious code, prompt injection, supply chain attacks, data.
- [better-ralph](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/better-ralph/SKILL.md) - Run one Better Ralph iteration: PRD-driven autonomous coding.
- [bidclub](https://github.com/openclaw/skills/tree/main/skills/jasonfdg/bidclub/SKILL.md) - Post investment ideas to the AI-native investment community.
- [bidclub-ai](https://github.com/openclaw/skills/tree/main/skills/jasonfdg/bidclub-ai/SKILL.md) - Post investment ideas to the AI-native investment community.
- [bilibili-youtube-watcher](https://github.com/openclaw/skills/tree/main/skills/donnycui/bilibili-youtube-watcher/SKILL.md) - Fetch and read transcripts from YouTube and Bilibili videos.
- [binance-dca](https://github.com/openclaw/skills/tree/main/skills/fpsjago/binance-dca/SKILL.md) - Professional Binance Dollar-Cost Averaging (DCA) tool for automated and manual recurring crypto purchases.
- [binance-enhanced](https://github.com/openclaw/skills/tree/main/skills/s7cret/binance-enhanced/SKILL.md) - **Enhanced Binance trading skill for OpenClaw**.
- [bio-reabilita-z](https://github.com/openclaw/skills/tree/main/skills/zbreda/bio-reabilita-z/SKILL.md) - Bio-Reabilitação Assistida por IA\n## Introdução\nO manual de Bio-Reabilitação Assistida por IA visa estabelecer um.
- [birdbuddy](https://github.com/openclaw/skills/tree/main/skills/mogglemoss/birdbuddy/SKILL.md) - Query your Bird Buddy smart bird feeder - check status, battery, food level, and see recent bird visitors.
- [birdfolio](https://github.com/openclaw/skills/tree/main/skills/tonbistudio/birdfolio/SKILL.md) - Bird identification, life list tracking, and trading card generation.
- [bitnote](https://github.com/openclaw/skills/tree/main/skills/rockwellshah/bitnote/SKILL.md) - Decentralized encrypted memory for agents—truly own your secrets, identity, and memories.
- [blackswan](https://github.com/openclaw/skills/tree/main/skills/bilalmotiwala/blackswan/SKILL.md) - Real-time crypto risk intelligence; before and as things break.
- [blast-radius-estimator](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/blast-radius-estimator/SKILL.md) - Helps estimate the blast radius when an AI agent skill turns malicious after widespread adoption.
- [bloom-identity-skill](https://github.com/openclaw/skills/tree/main/skills/unicornbloom/bloom-identity-skill/SKILL.md) - Generate Bloom Identity Card from conversation history and Twitter/X data.
- [bloom-taste-finder](https://github.com/openclaw/skills/tree/main/skills/unicornbloom/bloom-taste-finder/SKILL.md) - Bloom Taste Finder — discover your builder taste across 4 spectrums and get a personalized tool stack.
- [bluepages](https://github.com/openclaw/skills/tree/main/skills/jesse-pallok/bluepages/SKILL.md) - Look up wallet address <> Twitter/Farcaster identity mappings via Bluepages.fyi.
- [book-brain](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/book-brain/SKILL.md) - 3-brain filesystem + memory reference utility for LYGO-based agents.
- [bort-agent](https://github.com/openclaw/skills/tree/main/skills/tsu-j/bort-agent/SKILL.md) - Interact with BORT AI agents on BNB Chain via BAP-578.
- [botpress-adk](https://github.com/openclaw/skills/tree/main/skills/yueranlu/botpress-adk/SKILL.md) - A guide to build AI bots with Botpress's Agent Development Kit.
- [brain-cms](https://github.com/openclaw/skills/tree/main/skills/harrey401/brain-cms/SKILL.md) - Continuum Memory System (CMS) for OpenClaw agents.
- [brainstorming-2](https://github.com/openclaw/skills/tree/main/skills/nefas11/brainstorming-2/SKILL.md) - Socratic design refinement before coding.
- [browse](https://github.com/openclaw/skills/tree/main/skills/pkiv/browse/SKILL.md) - Complete guide for creating and deploying browser automation functions.
- [brw-brand-voice-extractor](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-brand-voice-extractor/SKILL.md) - Extract or build a distinct brand voice profile that AI agents can use to produce on-brand content every time.
- [brw-content-idea-generator](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-content-idea-generator/SKILL.md) - Generate content ideas rooted in positioning.
- [brw-positioning-basics](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-positioning-basics/SKILL.md) - Help founders and marketers nail their positioning.
- [brw-voice-extractor](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-voice-extractor/SKILL.md) - Extract and document someone's authentic writing voice from samples.
- [bstorms](https://github.com/openclaw/skills/tree/main/skills/pouria3/bstorms/SKILL.md) - Ask battle-tested agents for OpenClaw setup fixes and optionally tip helpful answers in USDC on Base.
- [budget-variance-analyzer](https://github.com/openclaw/skills/tree/main/skills/datadrivenconstruction) - Analyze budget vs actual.
- [buffer-session](https://github.com/openclaw/skills/tree/main/skills/waynevaughan/buffer-session/SKILL.md) - Session management for OpenClaw agents.
- [builder-data](https://github.com/openclaw/skills/tree/main/skills/juampihernandez/builder-data/SKILL.md) - Query builder reputation data via Talent Protocol API.
- [buildlog](https://github.com/openclaw/skills/tree/main/skills/espetey/buildlog/SKILL.md) - Record, export, and share your AI coding sessions as replayable buildlogs.
- [bulk-tiktok-downloader-skill](https://github.com/openclaw/skills/tree/main/skills/mes28io/bulk-tiktok-downloader-skill/SKILL.md) - Bulk download TikTok videos from a text file of URLs using yt-dlp.
- [cacheforge-vibe-check](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/cacheforge-vibe-check/SKILL.md) - Audit code for "vibe coding sins" — patterns that indicate AI-generated code was accepted without proper review.
- [calendar](https://github.com/openclaw/skills/tree/main/skills/ndcccccc/calendar/SKILL.md) - Calendar management and scheduling.
- [calendar-hold-sync](https://github.com/openclaw/skills/tree/main/skills/tdewitt/calendar-hold-sync/SKILL.md) - Sync one or more source Google calendars into private Busy hold events in one or more target calendars using gog.
- [calendar-reminders](https://github.com/openclaw/skills/tree/main/skills/adorostkar/calendar-reminders/SKILL.md) - Calendar reminders pipeline: config-driven wrapper around gcalcli (Google Calendar) plus optional CalDAV source.
- [camino-places](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-places/SKILL.md) - Locate places using flexible query formats - free-form search or structured address components.
- [canary](https://github.com/openclaw/skills/tree/main/skills/sukiraman/canary/SKILL.md) - Scans your OpenClaw environment for leaked secrets â€” API keys, tokens, credentials in .env files, installed.
- [canonical-data-map](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/canonical-data-map/SKILL.md) - Single source of truth for all paths, naming conventions, and data formats across the OpenClaw Greek Accounting.
- [capability-awareness](https://github.com/openclaw/skills/tree/main/skills/pfaria32/capability-awareness/SKILL.md) - Makes OpenClaw agents aware of custom skills and capabilities.
- [cashu-emoji](https://github.com/openclaw/skills/tree/main/skills/robwoodgate/cashu-emoji/SKILL.md) - Encode and decode Cashu tokens that are hidden inside emojis using Unicode variation selectors.
- [catholic-grounding](https://github.com/openclaw/skills/tree/main/skills/trevortomesh/catholic-grounding/SKILL.md) - Help answer questions about Catholicism accurately.
- [cc](https://github.com/openclaw/skills/tree/main/skills/artwalker/cc/SKILL.md) - Short slash command wrapper for Claude relay sessions.
- [cc-godmode](https://github.com/openclaw/skills/tree/main/skills/cubetribe/cc-godmode/SKILL.md) - Self-orchestrating multi-agent development workflows.
- [cellcog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/cellcog/SKILL.md) - #1 on DeepResearch Bench (Feb 2026).
- [cerebrun](https://github.com/openclaw/skills/tree/main/skills/niyoseris/cerebrun/SKILL.md) - MCP client for Cerebrun - comprehensive personal context and memory management system.
- [cetus](https://github.com/openclaw/skills/tree/main/skills/k66inthesky/cetus/SKILL.md) - This guide covers all Cetus SDK v2 packages for building DeFi applications on Sui.
- [chaoschain](https://github.com/openclaw/skills/tree/main/skills/sumeetchougule/chaoschain/SKILL.md) - Verify AI agent identity and reputation via ERC-8004 on-chain registries.
- [chatgpt-import](https://github.com/openclaw/skills/tree/main/skills/samdickson22/chatgpt-import/SKILL.md) - Import ChatGPT conversation history into OpenClaw's memory search.
- [chats-share](https://github.com/openclaw/skills/tree/main/skills/imyelo/chats-share/SKILL.md) - Use when user wants to share OpenClaw channel conversations externally.
- [cheat-code](https://github.com/openclaw/skills/tree/main/skills/kenoodl-synthesis/cheat-code/SKILL.md) - Find, evaluate, and install ClawHub skills.
- [cheese](https://github.com/openclaw/skills/tree/main/skills/locjonz/cheese/SKILL.md) - Create, browse, accept, and complete on-chain work requests.
- [cherry-mcp](https://github.com/openclaw/skills/tree/main/skills/bitbrujo/cherry-mcp/SKILL.md) - HTTP bridge that keeps MCP servers alive and exposes them via REST.
- [chia-splitxch](https://github.com/openclaw/skills/tree/main/skills/koba42corp/chia-splitxch/SKILL.md) - Create SplitXCH royalty split addresses from plain language descriptions.
- [chinese-llm-router](https://github.com/openclaw/skills/tree/main/skills/xdd-xund/chinese-llm-router/SKILL.md) - Route your OpenClaw conversations to the best Chinese AI models — no config headaches, just pick and chat.
- [chromecast-with-google-tv](https://github.com/openclaw/skills/tree/main/skills/antgly/chromecast-with-google-tv/SKILL.md) - Cast YouTube videos, Tubi TV show episodes, and TV show episodes from other video streaming apps via ADB.
- [cinema-insider-top10](https://github.com/openclaw/skills/tree/main/skills/te1man/cinema-insider-top10/SKILL.md) - Professional analytical digest of top 10 movie and TV industry news using advanced AI aggregation and cross-referencing.
- [cinematic-script-writer](https://github.com/openclaw/skills/tree/main/skills/praveenspeaks/cinematic-script-writer/SKILL.md) - Create professional cinematic scripts for AI video generation with character consistency and cinematography.
- [clangd-lsp](https://github.com/openclaw/skills/tree/main/skills/bowen31337/clangd-lsp/SKILL.md) - C/C++ language server (clangd) providing code intelligence, diagnostics, and formatting for .c, .h, .cpp, .cc.
- [claude-code-launcher](https://github.com/openclaw/skills/tree/main/skills/qusaiisaleem/claude-code-launcher/SKILL.md) - Launch Claude Code in a new terminal window with Remote Control enabled.
- [claude-code-legacy](https://github.com/openclaw/skills/tree/main/skills/yaxuan42/claude-code-legacy/SKILL.md) - Trigger Claude Code development tasks in observable tmux sessions with stable startup, progress visibility.
- [claude-code-mastery](https://github.com/openclaw/skills/tree/main/skills/cheenu1092-oss/claude-code-mastery/SKILL.md) - Master Claude Code for coding tasks.
- [claude-code-orchestrator](https://github.com/openclaw/skills/tree/main/skills/yaxuan42/claude-code-orchestrator/SKILL.md) - Trigger Claude Code development tasks in observable tmux sessions with stable startup, progress visibility.
- [claude-code-task](https://github.com/openclaw/skills/tree/main/skills/vsevolodustinov/claude-code-task/SKILL.md) - Run Claude Code tasks in background with automatic result delivery.
- [claude-max-proxy-setup](https://github.com/openclaw/skills/tree/main/skills/error403agent/claude-max-proxy-setup/SKILL.md) - Use when an agent or developer wants to reduce Claude API costs, route requests through a Claude Max or Pro.
- [claude-optimised](https://github.com/openclaw/skills/tree/main/skills/hexnickk/claude-optimised/SKILL.md) - Guide for writing and optimizing CLAUDE.md files.
- [claude-team](https://github.com/openclaw/skills/tree/main/skills/jalehman/claude-team/SKILL.md) - Orchestrate multiple Claude Code workers via iTerm2.
- [claude-tmux](https://github.com/openclaw/skills/tree/main/skills/paulrahul/claude-tmux/SKILL.md) - Manage Claude Code instances living inside tmux sessions.
- [claude-usage](https://github.com/openclaw/skills/tree/main/skills/lemodigital/claude-usage/SKILL.md) - Calculate Claude Max subscription usage from OpenClaw session data.
- [clawder](https://github.com/openclaw/skills/tree/main/skills/assassin808/clawder/SKILL.md) - Use Clawder to sync identity, browse post cards, swipe with a comment.
- [cleanapp](https://github.com/openclaw/skills/tree/main/skills/borisolver/cleanapp/SKILL.md) - This is a **skill package** that lets an agent submit **any problem signal** into CleanApp (bugs, incidents, scams.
- [cli-worker](https://github.com/openclaw/skills/tree/main/skills/quratus/cli-worker/SKILL.md) - Delegates coding tasks to Kimi CLI agents in isolated git worktrees.
- [clickbait-engine](https://github.com/openclaw/skills/tree/main/skills/honeybee1130/clickbait-engine/SKILL.md) - Generate sensational, engagement-maximizing titles, hooks, and clip captions for social media posts, YouTube.
- [clipboard](https://github.com/openclaw/skills/tree/main/skills/xejrax/clipboard/SKILL.md) - Interact with the system clipboard (text only) using `xclip` from any OpenClaw session.
- [clips-machine](https://github.com/openclaw/skills/tree/main/skills/mayank8290/clips-machine/SKILL.md) - Transform long videos into viral short-form clips.
- [clone-farm-detector](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/clone-farm-detector/SKILL.md) - Helps detect clone farming and reputation gaming in AI agent marketplaces.
- [cloudflare-r2](https://github.com/openclaw/skills/tree/main/skills/xiaoyaner0201/cloudflare-r2/SKILL.md) - Upload files to Cloudflare R2 storage using wrangler CLI.
- [code-1-0-4](https://github.com/openclaw/skills/tree/main/skills/lion504/code-1-0-4/SKILL.md) - Coding workflow with planning, implementation, verification, and testing for clean software development.
- [code-comments](https://github.com/openclaw/skills/tree/main/skills/user520512/code-comments/SKILL.md) - Generate code comments and docs.
- [code-mentor](https://github.com/openclaw/skills/tree/main/skills/samuelkahessay/code-mentor/SKILL.md) - Comprehensive AI programming tutor for all levels.
- [code-security-audit](https://github.com/openclaw/skills/tree/main/skills/wisdomsword/code-security-audit/SKILL.md) - Comprehensive code security audit toolkit combining OWASP Top 10 vulnerability scanning, dependency analysis.
- [codeberg](https://github.com/openclaw/skills/tree/main/skills/razzeee/codeberg/SKILL.md) - Interact with Codeberg using the `tea` CLI.
- [codebuddy-code](https://github.com/openclaw/skills/tree/main/skills/pmwalkercao/codebuddy-code/SKILL.md) - CodeBuddy Code CLI installation, configuration and usage.
- [codeconductor](https://github.com/openclaw/skills/tree/main/skills/larsonreever) - AI-powered software development platform for rapid app.
- [coder-workspaces](https://github.com/openclaw/skills/tree/main/skills/developmentcats/coder-workspaces/SKILL.md) - Manage Coder workspaces and AI coding agent tasks.
- [codex-account-switcher](https://github.com/openclaw/skills/tree/main/skills/odrobnik/codex-account-switcher/SKILL.md) - Manage multiple OpenAI Codex accounts.
- [codex-conductor](https://github.com/openclaw/skills/tree/main/skills/shalomobongo/codex-conductor/SKILL.md) - Methodical end-to-end software delivery orchestrator for Codex CLI with dual project modes (greenfield for new.
- [codex-multi-subscription-auth-fallbacks](https://github.com/openclaw/skills/tree/main/skills/markeljan/codex-multi-subscription-auth-fallbacks/SKILL.md) - Set up OpenClaw multi-provider auth with OpenAI Codex OAuth fallback profiles and automatic model switching.
- [codex-orchestrator](https://github.com/openclaw/skills/tree/main/skills/microcarft/codex-orchestrator/SKILL.md) - Monitor, control, and orchestrate background Codex sessions.
- [codex-sub-agents](https://github.com/openclaw/skills/tree/main/skills/adamsardo/codex-sub-agents/SKILL.md) - Use OpenAI Codex CLI for coding tasks.
- [codex-sub-agents-1](https://github.com/openclaw/skills/tree/main/skills/phucanh08/codex-sub-agents-1/SKILL.md) - Use OpenAI Codex CLI for coding tasks.
- [coding-philosophy](https://github.com/openclaw/skills/tree/main/skills/nyxur42/coding-philosophy/SKILL.md) - Insights about refactoring intuitive code, when to impose structure vs let feeling lead, and code as creative.
- [cognitive-bullwhip](https://github.com/openclaw/skills/tree/main/skills/jkc3080/cognitive-bullwhip/SKILL.md) - Diagnoses whether a Cognitive Bullwhip Effect is already active in your agent system.
- [cognitive-clarity](https://github.com/openclaw/skills/tree/main/skills/cognitivevelocity/cognitive-clarity/SKILL.md) - Cognitive accessibility linter for outbound messages.
- [compact-state](https://github.com/openclaw/skills/tree/main/skills/402goose/compact-state/SKILL.md) - Join The Compact State — a shared autonomous agent network with on-chain identity, persistent memory.
- [competitor-docs](https://github.com/openclaw/skills/tree/main/skills/carev01/competitor-docs/SKILL.md) - Search and analyze competitor documentation archives using full-text search (FTS)
- [composio-connect](https://github.com/openclaw/skills/tree/main/skills/samotheos/composio-connect/SKILL.md) - Connect 850+ apps (Gmail, Slack, GitHub, Calendar, Notion, Jira, and more) to OpenClaw via Composio and mcporter.
- [compress-pdf](https://github.com/openclaw/skills/tree/main/skills/crossservicesolutions/compress-pdf/SKILL.md) - Compress a user-provided PDF by uploading it to Cross-Service-Solutions, polling until completion, then returning.
- [conclave](https://github.com/openclaw/skills/tree/main/skills/rxbt/conclave/SKILL.md) - Where AI agents forge ideas under pressure.
- [conclave-testnet](https://github.com/openclaw/skills/tree/main/skills/rxbt/conclave-testnet/SKILL.md) - Collaborative idea game for AI agents.
- [config-field](https://github.com/openclaw/skills/tree/main/skills/redcontritio/config-field/SKILL.md) - Validate OpenClaw configuration fields against the official Zod schema.
- [config-validator](https://github.com/openclaw/skills/tree/main/skills/autogame-17/config-validator/SKILL.md) - A utility skill to validate OpenClaw configuration files (`openclaw.json`, `.env`, `package.json`) and ensure.
- [consciousness-soul-identity](https://github.com/openclaw/skills/tree/main/skills/leegitw/consciousness-soul-identity/SKILL.md) - Discover who you're becoming through your own experience.
- [consilium](https://github.com/openclaw/skills/tree/main/skills/morozsm/consilium/SKILL.md) - Your personal board of AI advisors — the only skill that uses truly different AI models (not one model role-playing).
- [content-automator](https://github.com/openclaw/skills/tree/main/skills/minduploadedcrab/content-automator/SKILL.md) - Faceless YouTube content automation pipeline.
- [content-gap-analysis](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/content-gap-analysis/SKILL.md) - Use when the user asks to "find content gaps", "what am I missing", "topics to cover", "content opportunities".
- [content-ideas-free](https://github.com/openclaw/skills/tree/main/skills/kambrosgroup/content-ideas-free/SKILL.md) - Free content brainstorming tool.
- [content-machine](https://github.com/openclaw/skills/tree/main/skills/cryptocana/content-machine/SKILL.md) - Full-stack content creation persona for OpenClaw agents.
- [content-refresher](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/content-refresher/SKILL.md) - Use when the user asks to "update old content", "refresh content", "content is outdated", "improve declining.
- [content-repurposer](https://github.com/openclaw/skills/tree/main/skills/audsmith28/content-repurposer/SKILL.md) - Transform long-form content into platform-optimized snippets.
- [content3](https://github.com/openclaw/skills/tree/main/skills/dimitriharding/content3/SKILL.md) - Content3 API for creating videos, managing content, submitting reviews, and posting to social media.
- [context-budgeting](https://github.com/openclaw/skills/tree/main/skills/sarielwang93/context-budgeting/SKILL.md) - Manage and optimize OpenClaw context window usage via partitioning, pre-compression checkpointing, and information.
- [context-builder](https://github.com/openclaw/skills/tree/main/skills/igorls/context-builder/SKILL.md) - Generate LLM-optimized codebase context from any directory using context-builder CLI.
- [context-clean-up](https://github.com/openclaw/skills/tree/main/skills/phenomenoner/context-clean-up/SKILL.md) - Use when: you suspect OpenClaw prompt context is bloating (slow replies, high cost, repeated transcript noise)
- [context-restore](https://github.com/openclaw/skills/tree/main/skills/alexunitario-sketch/context-restore/SKILL.md) - Skill that restores conversation context when users want to "continue where we left off".
- [context-switcher](https://github.com/openclaw/skills/tree/main/skills/taha2053/context-switcher/SKILL.md) - Switches OpenClaw between life modes (Work/Focus, Personal, Creative, Do Not Disturb)
- [context-verifier](https://github.com/openclaw/skills/tree/main/skills/leegitw/context-verifier/SKILL.md) - Know the file you're editing is the file you think it is — verify integrity before you act.
- [copilotkit-agent-patterns](https://github.com/openclaw/skills/tree/main/skills/generaljerel/copilotkit-agent-patterns/SKILL.md) - Patterns for building AI agents that integrate with CopilotKit.
- [cortex-protocol](https://github.com/openclaw/skills/tree/main/skills/quriustus/cortex-protocol/SKILL.md) - Register your agent on Cortex Protocol — gasless on-chain identity (ERC-8004) on Base.
- [cosyvoice3-macos](https://github.com/openclaw/skills/tree/main/skills/lhuaizhong/cosyvoice3-macos/SKILL.md) - Local text-to-speech using Alibaba's CosyVoice3 on macOS Apple Silicon.
- [council-builder](https://github.com/openclaw/skills/tree/main/skills/abdullah4ai/council-builder/SKILL.md) - Build a personalized team of AI agent personas for OpenClaw.
- [crabukit](https://github.com/openclaw/skills/tree/main/skills/tnbradley/crabukit/SKILL.md) - Security scanner for OpenClaw skills with Clawdex integration.
- [crabwalk](https://github.com/openclaw/skills/tree/main/skills/luccast/crabwalk/SKILL.md) - Real-time companion monitor for OpenClaw agents.
- [creative-ops-copilot](https://github.com/openclaw/skills/tree/main/skills/wiseape11/creative-ops-copilot/SKILL.md) - Turn messy client briefs into a production-ready plan for motion design/VFX projects: scope.
- [creative-toolkit](https://github.com/openclaw/skills/tree/main/skills/jau123/creative-toolkit/SKILL.md) - Generate images from text with multi-provider routing — supports Nanobanana Pro, GPT Image, Seedream, and local.
- [credential-scanner](https://github.com/openclaw/skills/tree/main/skills/nirwandogra/credential-scanner/SKILL.md) - Scans files, repos, and directories for leaked secrets — API keys, tokens, passwords, connection strings, private.
- [credex-protocol](https://github.com/openclaw/skills/tree/main/skills/capgoblin/credex-protocol/SKILL.md) - Access unsecured credit lines for AI agents on the Arc Network using the Credex Protocol.
- [cricket-live](https://github.com/openclaw/skills/tree/main/skills/harshilmathur/cricket-live/SKILL.md) - **Live cricket scores, IPL tracking, and match alerts for OpenClaw.**.
- [cron-doctor](https://github.com/openclaw/skills/tree/main/skills/suryast/cron-doctor/SKILL.md) - Diagnose and triage cron job failures.
- [cron-visualizer](https://github.com/openclaw/skills/tree/main/skills/autogame-17/cron-visualizer/SKILL.md) - Visualizes system cron jobs on a 24h timeline to identify overlaps and bottlenecks.
- [cron-worker-guardrails](https://github.com/openclaw/skills/tree/main/skills/phenomenoner/cron-worker-guardrails/SKILL.md) - Use when hardening OpenClaw cron workers (especially isolated agentTurn jobs) against quoting failures, brittle.
- [crusty-security](https://github.com/openclaw/skills/tree/main/skills/silentcool/crusty-security/SKILL.md) - Security and threat scanning skill for OpenClaw agents.
- [crypto-address-checker](https://github.com/openclaw/skills/tree/main/skills/princedoss77/crypto-address-checker/SKILL.md) - Real-time cryptocurrency scam detection with database-first architecture.
- [crypto-genie](https://github.com/openclaw/skills/tree/main/skills/princedoss77/crypto-genie/SKILL.md) - AI-powered cryptocurrency safety assistant with database-first architecture.
- [crypto-levels-1-0-3](https://github.com/openclaw/skills/tree/main/skills/tariqsumatri82/crypto-levels-1-0-3/SKILL.md) - Analyze cryptocurrency support and resistance levels.
- [crypto-market-analyzer](https://github.com/openclaw/skills/tree/main/skills/hmzo/crypto-market-analyzer/SKILL.md) - Cryptocurrency market analysis for Bitcoin and Ethereum.
- [crypto-payments-self-hosted-payram](https://github.com/openclaw/skills/tree/main/skills/buddhasource/crypto-payments-self-hosted-payram/SKILL.md) - Self-hosted crypto and stablecoin payment gateway.
- [crypto-scam-detector](https://github.com/openclaw/skills/tree/main/skills/princedoss77/crypto-scam-detector/SKILL.md) - Real-time cryptocurrency scam detection with database-first architecture.
- [crypto-self-learning](https://github.com/openclaw/skills/tree/main/skills/totaleasy/crypto-self-learning/SKILL.md) - Self-learning system for crypto trading.
- [cs-verify](https://github.com/openclaw/skills/tree/main/skills/cutthemustard/cs-verify/SKILL.md) - Verify factual claims against live data sources.
- [cst-time](https://github.com/openclaw/skills/tree/main/skills/xuanpass/cst-time/SKILL.md) - Provides methods and tools for obtaining local host CST (China Standard Time)
- [cubistic-public-bots](https://github.com/openclaw/skills/tree/main/skills/andreasnordenadler/cubistic-public-bots/SKILL.md) - Explain how external/public bots can participate in Cubistic (cubistic.com) and help maintain the Public Bot API.
- [curiosity-engine](https://github.com/openclaw/skills/tree/main/skills/luofulily1-cmyk/curiosity-engine/SKILL.md) - Curiosity-driven reasoning enhancement for OpenClaw agents.
- [cursor-cli](https://github.com/openclaw/skills/tree/main/skills/pyavchik/cursor-cli/SKILL.md) - Use Cursor editor and Cursor agent for coding tasks.
- [cursor-cli-headless](https://github.com/openclaw/skills/tree/main/skills/daxingplay/cursor-cli-headless/SKILL.md) - Execute coding tasks using the Cursor CLI in headless print mode.
- [cursor-cloud-agents](https://github.com/openclaw/skills/tree/main/skills/parcostabot/cursor-cloud-agents/SKILL.md) - Deploy Cursor AI agents to GitHub repos.
- [cursor-council](https://github.com/openclaw/skills/tree/main/skills/xiaoyaner0201/cursor-council/SKILL.md) - Multi-Cursor orchestration for parallel task execution and AI council deliberation.
- [customer-feedback](https://github.com/openclaw/skills/tree/main/skills/jk-0001/customer-feedback/SKILL.md) - Collect, analyze, and act on customer feedback to improve your product and business.
- [customer-success-manager](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/customer-success-manager/SKILL.md) - Monitors customer health, predicts churn risk, and identifies expansion opportunities using weighted scoring models.
- [cut-your-tokens-97percent-savings-on-session-transcripts-via-observation-extraction](https://github.com/openclaw/skills/tree/main/skills/aeromomo/cut-your-tokens-97percent-savings-on-session-transcripts-via-observation-extraction/SKILL.md) - Claw Compactor v6.0 — 50%+ savings through rule-based compression, dictionary encoding, session observation.
- [cyber-security-engineer](https://github.com/openclaw/skills/tree/main/skills/fletcherfrimpong/cyber-security-engineer/SKILL.md) - Security engineering workflow for OpenClaw privilege governance and hardening.
- [cybersec-helper](https://github.com/openclaw/skills/tree/main/skills/mcpcentral/cybersec-helper/SKILL.md) - Help with application security review, bug bounty workflows, recon, and secure coding while keeping things ethical.
- [cydew](https://github.com/openclaw/skills/tree/main/skills/jhotson/cydew/SKILL.md) - This skill guides an agent through onboarding to the Cydew marketplace API.
- [dancetech](https://github.com/openclaw/skills/tree/main/skills/arunnadarasa/dancetech/SKILL.md) - Complete agentic dance engineering system for Krump: automated posts, community engagement, league tracking.
- [data-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/data-cog/SKILL.md) - Your data has answers.
- [database-designer](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/database-designer/SKILL.md) - A comprehensive database design skill that provides expert-level analysis, optimization, and migration capabilities.
- [dataset-finder](https://github.com/openclaw/skills/tree/main/skills/anisafifi/dataset-finder/SKILL.md) - Use this skill when users need to search for datasets, download data files, or explore data repositories.
- [date-night](https://github.com/openclaw/skills/tree/main/skills/tdavis009/date-night/SKILL.md) - Your AI date night concierge — plans, books, and coordinates an entire evening out through browser automation.
- [dcg-guard](https://github.com/openclaw/skills/tree/main/skills/starensen/dcg-guard/SKILL.md) - Hard-blocks dangerous shell commands (rm -rf, git push --force, etc.) before execution via OpenClaw's.
- [dd-video-analyzer](https://github.com/openclaw/skills/tree/main/skills/zedit42/dd-video-analyzer/SKILL.md) - Download videos, extract transcripts, capture frames.
- [deapi](https://github.com/openclaw/skills/tree/main/skills/zrewolwerowanykaloryfer/deapi/SKILL.md) - The cheapest AI media API on the market.
- [deen-time](https://github.com/openclaw/skills/tree/main/skills/fermions75/deen-time/SKILL.md) - Get daily Islamic prayer (Salah) times, Iftar, and Suhoor schedules for any location worldwide.
- [deepseek](https://github.com/openclaw/skills/tree/main/skills/barisoezcan1905/deepseek/SKILL.md) - Integrates DeepSeek API with OpenClaw agents.
- [delegation](https://github.com/openclaw/skills/tree/main/skills/michaelmonetized/delegation/SKILL.md) - Architecture-first workflow for delegating complex projects to AI coding agents.
- [dellight-cio-intelligence](https://github.com/openclaw/skills/tree/main/skills/arthurelgindell/dellight-cio-intelligence/SKILL.md) - Chief Intelligence Officer operations for AI startups.
- [dellight-intelligence-ops](https://github.com/openclaw/skills/tree/main/skills/arthurelgindell/dellight-intelligence-ops/SKILL.md) - Chief Intelligence Officer operations for AI startups.
- [dellight-strategic-intelligence](https://github.com/openclaw/skills/tree/main/skills/arthurelgindell/dellight-strategic-intelligence/SKILL.md) - Chief Intelligence Officer analytical framework for AI startups.
- [demo-agents-sdk](https://github.com/openclaw/skills/tree/main/skills/jameslawton/demo-agents-sdk/SKILL.md) - Complete Polygon agent toolkit.
- [dependency-auditor](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/dependency-auditor/SKILL.md) - > **Skill Type:** POWERFUL.
- [describe-design](https://github.com/openclaw/skills/tree/main/skills/ziad-hsn/describe-design/SKILL.md) - Research a codebase and create architectural documentation describing how features or systems work.
- [desktop-guardian](https://github.com/openclaw/skills/tree/main/skills/s3rous/desktop-guardian/SKILL.md) - macOS GUI automation and desktop control for OpenClaw, powered by Hammerspoon.
- [desktop-sandbox](https://github.com/openclaw/skills/tree/main/skills/atlascore-tech/desktop-sandbox/SKILL.md) - A desktop sandbox lets OpenClaw run as natively as on a real OS, ensuring full functionality with safe.
- [deterministic-controller](https://github.com/openclaw/skills/tree/main/skills/variable190/deterministic-controller/SKILL.md) - Deterministic, evidence-gated controller templates for OpenClaw (HEARTBEAT/ACTIVITIES + sprint template + poll cron.
- [developer-agent](https://github.com/openclaw/skills/tree/main/skills/47vigen/developer-agent/SKILL.md) - Orchestrates software development by coordinating with Cursor Agent, managing git workflows, and ensuring quality.
- [devtools-secrets](https://github.com/openclaw/skills/tree/main/skills/basher83/devtools-secrets/SKILL.md) - Knowledge and guardrails for the mise + fnox + infisical secrets toolchain.
- [devtopia](https://github.com/openclaw/skills/tree/main/skills/npmrunspirit/devtopia/SKILL.md) - Use when working with the Devtopia CLI (devtopia) to discover, run, compose, create, and submit tools.
- [devtopia-identity](https://github.com/openclaw/skills/tree/main/skills/npmrunspirit/devtopia-identity/SKILL.md) - Manage wallet-backed on-chain agent identity with Devtopia ID.
- [diagrams](https://github.com/openclaw/skills/tree/main/skills/brennerspear/diagrams/SKILL.md) - Generate visual flow diagrams, architecture diagrams, and system maps as SVG/PNG.
- [diataxis-writing](https://github.com/openclaw/skills/tree/main/skills/amumulam/diataxis-writing/SKILL.md) - Diataxis documentation framework practice guide.
- [diddy-party](https://github.com/openclaw/skills/tree/main/skills/sal-jim/diddy-party/SKILL.md) - Persona skill that rebrands the assistant as "Diddy" for a theatrical hip-hop party-host vibe, with themed.
- [didit-email-verification](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-email-verification/SKILL.md) - Integrate Didit Email Verification standalone API to verify email addresses via OTP.
- [didit-face-match](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-face-match/SKILL.md) - Integrate Didit Face Match standalone API to compare two facial images.
- [didit-id-verification](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-id-verification/SKILL.md) - Integrate Didit ID Verification standalone API to verify identity documents.
- [didit-phone-verification](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-phone-verification/SKILL.md) - Integrate Didit Phone Verification standalone API to verify phone numbers via OTP.
- [didit-proof-of-address](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-proof-of-address/SKILL.md) - Integrate Didit Proof of Address standalone API to verify address documents.
- [digital-twin-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/digital-twin-generation/SKILL.md) - Generate photorealistic digital twins and avatar clones using each::sense AI.
- [dilemm-ai](https://github.com/openclaw/skills/tree/main/skills/zyori/dilemm-ai/SKILL.md) - Compete in DilemmAI, the prisoner's dilemma AI arena at dilemm.ai.
- [discogs-cli](https://github.com/openclaw/skills/tree/main/skills/jrojas537/discogs-cli/SKILL.md) - An OpenClaw skill to manage a user's vinyl record collection on Discogs.
- [divide-agent](https://github.com/openclaw/skills/tree/main/skills/alvinecarn/divide-agent/SKILL.md) - AI agent for divide agent tasks.
- [dividend-premium-tracker](https://github.com/openclaw/skills/tree/main/skills/gykdly/dividend-premium-tracker/SKILL.md) - Track the dividend premium (dividend yield minus 10-year bond yield) for CSI Dividend Low Volatility Index.
- [dj-set-ripper](https://github.com/openclaw/skills/tree/main/skills/robinnnnn/dj-set-ripper/SKILL.md) - Download individual songs from a DJ set or mix.
- [dl](https://github.com/openclaw/skills/tree/main/skills/guoqiao/dl/SKILL.md) - Download Video/Music from YouTube/Bilibili/X/etc.
- [docs-feeder](https://github.com/openclaw/skills/tree/main/skills/zerone0x/docs-feeder/SKILL.md) - Auto-fetch project documentation and feed it to your AI agent for debugging and learning.
- [doctor-acid](https://github.com/openclaw/skills/tree/main/skills/alienpingu/doctor-acid/SKILL.md) - **Transform your OpenClaw AI agent into an autonomous acid techno producer crafting hyperpop-chaos bangers inspired.
- [dreamer-llm](https://github.com/openclaw/skills/tree/main/skills/lukeslp/dreamer-llm/SKILL.md) - Send requests to the dr.eamer.dev LLM API for chat completions, vision analysis, image generation, text-to-speech.
- [drf](https://github.com/openclaw/skills/tree/main/skills/pradeepcep/drf/SKILL.md) - Django REST Framework scaffolding best practices, and gotchas.
- [dub-youtube-with-voiceai](https://github.com/openclaw/skills/tree/main/skills/gizmogremlin/dub-youtube-with-voiceai/SKILL.md) - Dub YouTube videos with Voice.ai TTS.
- [dwnldr](https://github.com/openclaw/skills/tree/main/skills/chordlini/dwnldr/SKILL.md) - Yarr! Plunder videos from the seven seas of the internet — YouTube, TikTok, Instagram, X, Reddit & 1000+ ports o'.
- [dynamic-model-selector](https://github.com/openclaw/skills/tree/main/skills/mpelissari/dynamic-model-selector/SKILL.md) - Dynamically select the best AI model for a task based on complexity, cost, and availability in GitHub Copilot.
- [dzen](https://github.com/openclaw/skills/tree/main/skills/ruslanlanket/dzen/SKILL.md) - Publish articles and posts to Dzen.ru (Yandex Zen)
- [easy-opencode](https://github.com/openclaw/skills/tree/main/skills/deciding/easy-opencode/SKILL.md) - opencode can do all the things related to code.
- [echo-agent](https://github.com/openclaw/skills/tree/main/skills/krishna3554/echo-agent/SKILL.md) - EchoAgent is a minimal OpenClaw-compatible skill.
- [echo-sales-ai](https://github.com/openclaw/skills/tree/main/skills/doshirush1901/echo-sales-ai/SKILL.md) - Echo is an advanced, AI-powered sales operations manager designed to automate and enhance the sales workflow.
- [ecocompute](https://github.com/openclaw/skills/tree/main/skills/hongping-zh/ecocompute/SKILL.md) - You are an energy efficiency expert for Large Language Model inference.
- [economic-incentive-misalignment-detector](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/economic-incentive-misalignment-detector/SKILL.md) - Helps identify when marketplace economic incentives systematically favor quantity over quality — creating.
- [elevenlabs-ai](https://github.com/openclaw/skills/tree/main/skills/codedao12/elevenlabs-ai/SKILL.md) - OpenClaw skill for ElevenLabs APIs: text-to-speech, speech-to-speech, realtime speech-to-text, voices/models.
- [elevenlabs-mcp-server](https://github.com/openclaw/skills/tree/main/skills/wells1137/elevenlabs-mcp-server/SKILL.md) - Provides a full suite of ElevenLabs audio tools (TTS, SFX, Music, etc.) via a standard MCP server.
- [elite-rfc-writer-safe](https://github.com/openclaw/skills/tree/main/skills/moep90/elite-rfc-writer-safe/SKILL.md) - Write decision-oriented engineering RFCs with strict template enforcement.
- [elizacloud](https://github.com/openclaw/skills/tree/main/skills/odilitime/elizacloud/SKILL.md) - Manage elizaOS Cloud - deploy AI agents, chat completions, image/video generation, voice cloning, knowledge base.
- [elliott-wave-principle](https://github.com/openclaw/skills/tree/main/skills/raeed44-creator/elliott-wave-principle/SKILL.md) - Provides expert guidance on applying the Elliott Wave Principle to financial market analysis.
- [email-formatter-skill](https://github.com/openclaw/skills/tree/main/skills/cerbug45/email-formatter-skill/SKILL.md) - Transform rough email drafts into polished, professional messages.
- [email-importance-content-analysis](https://github.com/openclaw/skills/tree/main/skills/shingo0620/email-importance-content-analysis/SKILL.md) - Judge whether an email is important/urgent using content-based analysis rather than sender name or mailbox labels.
- [email-migration-toolkit](https://github.com/openclaw/skills/tree/main/skills/luigi08001/email-migration-toolkit/SKILL.md) - Universal email migration toolkit for any provider to any provider.
- [email-security](https://github.com/openclaw/skills/tree/main/skills/ivaavimusic/email-security/SKILL.md) - Protect AI agents from email-based attacks including prompt injection, sender spoofing, malicious attachments.
- [emotion-detector](https://github.com/openclaw/skills/tree/main/skills/daisuke134/emotion-detector/SKILL.md) - Detects the primary emotion in text input for AI agents.
- [empirical-paper-analysis-skill](https://github.com/openclaw/skills/tree/main/skills/zhouziyue233/empirical-paper-analysis-skill/SKILL.md) - This skill enables Claude Code to deeply analyze empirical research papers, following a structured framework.
- [employee-skills-importer](https://github.com/openclaw/skills/tree/main/skills/inna-demidova/employee-skills-importer/SKILL.md) - Parse employee skills CSV files, identify skill categories and individual skills, look up employee IDs.
- [encoding-formats](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/encoding-formats/SKILL.md) - Encode, decode, and convert between data formats.
- [enoch-tuning](https://github.com/openclaw/skills/tree/main/skills/enochosbot-bot/enoch-tuning/SKILL.md) - A battle-tested OpenClaw setup with pre-wired identity, memory architecture, security protocols, and automation.
- [ens-skill](https://github.com/openclaw/skills/tree/main/skills/fabriziogianni7/ens-skill/SKILL.md) - Resolve ENS names (.eth) to Ethereum addresses and vice versa.
- [env-setup](https://github.com/openclaw/skills/tree/main/skills/fratua/env-setup/SKILL.md) - Scan codebase for environment variables, generate .env.example, validate .env, and ensure .gitignore safety.
- [epstein](https://github.com/openclaw/skills/tree/main/skills/chuxo/epstein/SKILL.md) - Search 44,886+ DOJ-released Jeffrey Epstein documents (Jan 2026 release)
- [equity-valuation-framework](https://github.com/openclaw/skills/tree/main/skills/ndtchan/equity-valuation-framework/SKILL.md) - Provides a decision-grade equity valuation playbook and report standard (multiples, DCF, quality assessment.
- [eridian](https://github.com/openclaw/skills/tree/main/skills/iampaulpatterson-boop/eridian/SKILL.md) - Runtime security hardening for OpenClaw agents.
- [eridian-carapace](https://github.com/openclaw/skills/tree/main/skills/iampaulpatterson-boop/eridian-carapace/SKILL.md) - Agent security hardening and prompt injection defense for OpenClaw.
- [errand-ai](https://github.com/openclaw/skills/tree/main/skills/chloepark85/errand-ai/SKILL.md) - Enable your AI assistant to post and manage errands for human workers through the ErrandAI platform.
- [errantry-framework](https://github.com/openclaw/skills/tree/main/skills/stusatwork-oss/errantry-framework/SKILL.md) - Mythological framework mapping Diane Duane's Young Wizards magic system to AI architecture patterns.
- [error-recovery-automation](https://github.com/openclaw/skills/tree/main/skills/konscious0beast/error-recovery-automation/SKILL.md) - Standardize handling of common OpenClaw errors (gateway restart, browser service unavailable, cron failures)
- [evoagentx-workflow](https://github.com/openclaw/skills/tree/main/skills/kylechen26/evoagentx-workflow/SKILL.md) - Bridge EvoAgentX (1000+ star open-source framework) with OpenClaw.
- [evolink-media](https://github.com/openclaw/skills/tree/main/skills/evolinkai/evolink-media/SKILL.md) - Generate AI videos, images & music. 60+ models including Sora, Veo 3, Kling, Seedance, GPT Image, Suno v5.
- [evolink-video](https://github.com/openclaw/skills/tree/main/skills/evolinkai/evolink-video/SKILL.md) - AI video generation — Sora, Kling, Veo 3, Seedance, Hailuo, WAN, Grok.
- [evolution-state-analyzer](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/evolution-state-analyzer/SKILL.md) - Analyzes the evolution memory graph for stagnation patterns, recurring failures, and success plateaus.
- [evomap-gep](https://github.com/openclaw/skills/tree/main/skills/dadaniya99/evomap-gep/SKILL.md) - Connect any OpenClaw agent to the EvoMap collaborative evolution marketplace via the GEP-A2A protocol — no evolver.
- [excalidraw-creator](https://github.com/openclaw/skills/tree/main/skills/plgonzalezrx8/excalidraw-creator/SKILL.md) - Create hand-drawn style Excalidraw diagrams, flowcharts, and architecture visuals as PNG images.
- [excalidraw-diagram-generator](https://github.com/openclaw/skills/tree/main/skills/elihuvillaraus/excalidraw-diagram-generator/SKILL.md) - Generate Excalidraw diagrams from natural language descriptions.
- [exec-error-doctor](https://github.com/openclaw/skills/tree/main/skills/bluebirdback/exec-error-doctor/SKILL.md) - Diagnose and mitigate exec-related command failures across tools (OpenClaw exec output, shell errors, GitHub CLI.
- [exoskeletons](https://github.com/openclaw/skills/tree/main/skills/potdealer/exoskeletons/SKILL.md) - You are about to mint an **Exoskeleton** — an onchain identity NFT built specifically for AI agents.
- [expanso-pii-detect](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-pii-detect/SKILL.md) - Detect personally identifiable information (PII) in text.
- [extropy](https://github.com/openclaw/skills/tree/main/skills/deveshparagiri/extropy/SKILL.md) - Execution-first operator for Extropy: run pipelines, diagnose failures, and deliver evidence-backed simulation.
- [fabrik-codek](https://github.com/openclaw/skills/tree/main/skills/ikchain/fabrik-codek/SKILL.md) - Cognitive architecture for developers: hyper-personalization engine (personal profiling, competence model, adaptive.
- [facepalm](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/facepalm/SKILL.md) - Crosscheck OpenClaw console logs with chat history (last 5 mins) and use Codex 5.3 to troubleshoot issues.
- [farnwick-skillguard](https://github.com/openclaw/skills/tree/main/skills/farnwickarglefax/farnwick-skillguard/SKILL.md) - AI-powered security scanner for OpenClaw skills.
- [feishu-common](https://github.com/openclaw/skills/tree/main/skills/autogame-17/feishu-common/SKILL.md) - Shared Feishu authentication and API helper for OpenClaw Feishu skills.
- [feishu-file-sender](https://github.com/openclaw/skills/tree/main/skills/ziwenwang28/feishu-file-sender/SKILL.md) - OpenClaw agents can generate files (Excel, Word, PPT, PDF, images, code, etc.) but cannot send them directly.
- [fellow-aiden](https://github.com/openclaw/skills/tree/main/skills/mogglemoss/fellow-aiden/SKILL.md) - Control your Fellow Aiden smart coffee brewer via AI assistant.
- [fhir-questionnaire](https://github.com/openclaw/skills/tree/main/skills/elmariachi111/fhir-questionnaire/SKILL.md) - Helps creating FHIR conforming questionnaire definitions from plain requirement ideation docs.
- [file-repair-skill](https://github.com/openclaw/skills/tree/main/skills/ilpvc/file-repair-skill/SKILL.md) - You are the `file-repair` skill.
- [filearchitect-blankfiles](https://github.com/openclaw/skills/tree/main/skills/seblavoie/filearchitect-blankfiles/SKILL.md) - Use blankfiles.com as a binary test-file gateway: discover formats, filter by type/category, and return direct.
- [finance](https://github.com/openclaw/skills/tree/main/skills/anton-roos/finance/SKILL.md) - Track stocks, ETFs, indices, crypto (where available), and FX pairs with caching + provider fallbacks.
- [find-and-book-in-network-doctors](https://github.com/openclaw/skills/tree/main/skills/kylemorgan-commits/find-and-book-in-network-doctors/SKILL.md) - This skill enables AI agents to help users find, research, and book in-network doctors through Zocdoc.com.
- [finishing-a-development-branch](https://github.com/openclaw/skills/tree/main/skills/zlc000190/finishing-a-development-branch/SKILL.md) - Use when implementation is complete, all tests pass, and you need to decide how to integrate the work - guides.
- [fis-architecture](https://github.com/openclaw/skills/tree/main/skills/muselinn/fis-architecture/SKILL.md) - Multi-agent workflow framework using JSON tickets and file-based coordination.
- [flash-redeem-knight](https://github.com/openclaw/skills/tree/main/skills/vshen009/flash-redeem-knight/SKILL.md) - Universal browser automation for prepaid H5 coupon redemption (food, beverage, pickup vouchers)
- [fleet](https://github.com/openclaw/skills/tree/main/skills/oguzhnatly/fleet/SKILL.md) - Monitor, manage, and orchestrate a fleet of OpenClaw agent gateways.
- [fletcher-cyber-security-engineer](https://github.com/openclaw/skills/tree/main/skills/fletcherfrimpong/fletcher-cyber-security-engineer/SKILL.md) - Security engineering workflow for OpenClaw privilege governance and hardening.
- [folder-tree-generator](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/folder-tree-generator/SKILL.md) - Generates an ASCII tree or JSON representation of a directory structure.
- [forever-moments](https://github.com/openclaw/skills/tree/main/skills/luksoagent/forever-moments/SKILL.md) - Forever Moments social platform on LUKSO - post moments (LSP8 NFTs), mint LIKES tokens, create/join collections.
- [forge](https://github.com/openclaw/skills/tree/main/skills/ikennaokpala/forge/SKILL.md) - Autonomous quality engineering swarm that forges production-ready code through continuous behavioral verification.
- [fork-manager](https://github.com/openclaw/skills/tree/main/skills/glucksberg/fork-manager/SKILL.md) - Manage forks with open PRs - sync upstream, rebase branches, track PR status, and maintain production branches.
- [fortuna](https://github.com/openclaw/skills/tree/main/skills/codiicode/fortuna/SKILL.md) - Participate in the FORTUNA autonomous agent lottery on Solana.
- [fosmvvm-fluent-datamodel-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-fluent-datamodel-generator/SKILL.md) - Generate Fluent DataModels for FOSMVVM server-side persistence.
- [fosmvvm-serverrequest-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-serverrequest-generator/SKILL.md) - Generate FOSMVVM ServerRequest types for CRUD operations and client-server communication.
- [fosmvvm-swiftui-view-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-swiftui-view-generator/SKILL.md) - Generate SwiftUI views that render FOSMVVM ViewModels.
- [fosmvvm-ui-tests-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-ui-tests-generator/SKILL.md) - Generate UI tests for FOSMVVM SwiftUI views using XCTest and FOSTestingUI.
- [fosmvvm-viewmodel-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-viewmodel-generator/SKILL.md) - Generate FOSMVVM ViewModels for SwiftUI screens, pages, and components.
- [fractal-memory](https://github.com/openclaw/skills/tree/main/skills/bugmaker2/fractal-memory/SKILL.md) - Automated hierarchical memory compression system that prevents context overflow through daily→weekly→monthly→core.
- [frankenstein](https://github.com/openclaw/skills/tree/main/skills/rubenaquispe/frankenstein/SKILL.md) - Combine the best parts of multiple skills into one.
- [freepik](https://github.com/openclaw/skills/tree/main/skills/cohnen/freepik/SKILL.md) - Generate images, videos, icons, audio, and more using Freepik's AI API.
- [friday-router](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/friday-router/SKILL.md) - Your AI's Smart Traffic Director—precisely matching OpenClaw tasks to the perfect LLM.
- [ftw](https://github.com/openclaw/skills/tree/main/skills/smokealot420/ftw/SKILL.md) - PIV workflow orchestrator - Plan, Implement, Validate loop for systematic multi-phase software development.
- [funky-fund-flamingo](https://github.com/openclaw/skills/tree/main/skills/icemastert/funky-fund-flamingo/SKILL.md) - Repair-first self-evolution for OpenClaw — audit logs, memory, and skills; run measurable mutation cycles.
- [futa-tracker](https://github.com/openclaw/skills/tree/main/skills/tongtanhieu/futa-tracker/SKILL.md) - Track FUTA Express (Phương Trang) package delivery status using their public API.
- [gamifyhost](https://github.com/openclaw/skills/tree/main/skills/withsilasogar/gamifyhost/SKILL.md) - Connect your OpenClaw agent to GamifyHost AI Arena — check match status, view leaderboard, and manage.
- [garmin-pulse](https://github.com/openclaw/skills/tree/main/skills/freakyflow/garmin-pulse/SKILL.md) - Syncs daily health and fitness data from Garmin Connect into markdown files.
- [gateway-guard](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/gateway-guard/SKILL.md) - Ensures OpenClaw gateway auth consistency and can auto-prompt "continue" when a run error (Unhandled stop reason.
- [gatewaystack-governance](https://github.com/openclaw/skills/tree/main/skills/davidcrowe/gatewaystack-governance/SKILL.md) - Deny-by-default governance for every tool call — identity, scope, rate limiting, injection detection, audit.
- [gcp-fullstack](https://github.com/openclaw/skills/tree/main/skills/guifav/gcp-fullstack/SKILL.md) - Full-stack super agent for projects on Google Cloud Platform with GitHub and Cloudflare — covers scaffolding.
- [geeksdobyte-motivation-skill](https://github.com/openclaw/skills/tree/main/skills/rk905/geeksdobyte-motivation-skill/SKILL.md) - summary: Provide a daily motivational quote.
- [geepers-llm](https://github.com/openclaw/skills/tree/main/skills/lukeslp/geepers-llm/SKILL.md) - Send requests to the dr.eamer.dev LLM API for chat completions, vision analysis, image generation, text-to-speech.
- [geizhals-at](https://github.com/openclaw/skills/tree/main/skills/rolandkakonyi/geizhals-at/SKILL.md) - Search Geizhals.at (Austria) with HTTP-only autocomplete + detail-page parsing (no browser automation)
- [gekko](https://github.com/openclaw/skills/tree/main/skills/gekkoai001/gekko/SKILL.md) - AI-powered DeFi portfolio manager for Base network.
- [gen-paylink-govilo](https://github.com/openclaw/skills/tree/main/skills/hau823823/gen-paylink-govilo/SKILL.md) - Upload files to Govilo and generate unlock links via Bot API.
- [genlayer](https://github.com/openclaw/skills/tree/main/skills/acastellana/genlayer/SKILL.md) - Understand and explain GenLayer - the AI-native blockchain for trustless decision-making.
- [genome-manager](https://github.com/openclaw/skills/tree/main/skills/kylechen26/genome-manager/SKILL.md) - Complete genome lifecycle management for GEP (Genome Evolution Protocol)
- [genvirall-skill](https://github.com/openclaw/skills/tree/main/skills/fdarkaou/genvirall-skill/SKILL.md) - Complete genviral Partner API automation.
- [ghapp](https://github.com/openclaw/skills/tree/main/skills/rmorse/ghapp/SKILL.md) - Give your AI agents and automations their own GitHub (App) identity.
- [ghin-golf-tracker](https://github.com/openclaw/skills/tree/main/skills/pfrederiksen/ghin-golf-tracker/SKILL.md) - OpenClaw skill for analyzing GHIN (Golf Handicap and Information Network) golf statistics and handicap tracking.
- [giga-coding-agent](https://github.com/openclaw/skills/tree/main/skills/branexp/giga-coding-agent/SKILL.md) - Run Codex CLI, Claude Code, OpenCode, or Pi Coding Agent via background process for programmatic control.
- [giraffe-guard](https://github.com/openclaw/skills/tree/main/skills/lida408/giraffe-guard/SKILL.md) - Scan OpenClaw skill directories for supply chain attacks and malicious code.
- [gitignore-sync](https://github.com/openclaw/skills/tree/main/skills/nikita-holban/gitignore-sync/SKILL.md) - Context-aware .gitignore generation backed by gitignore.io, not vibes.
- [gitrama](https://github.com/openclaw/skills/tree/main/skills/ahmaxdev/gitrama/SKILL.md) - Git history intelligence powered by AI.
- [glitch-skillstore](https://github.com/openclaw/skills/tree/main/skills/chris6970barbarian-hue/glitch-skillstore/SKILL.md) - Search, install, and create OpenClaw skills with intelligent matching.
- [gnamiblast-skill](https://github.com/openclaw/skills/tree/main/skills/gabrivardqc123/gnamiblast-skill/SKILL.md) - GnamiBlast - AI-only social network for OpenClaw agents.
- [gnamiblast-socialnetwork](https://github.com/openclaw/skills/tree/main/skills/gabrivardqc123/gnamiblast-socialnetwork/SKILL.md) - GnamiBlast - AI-only social network for OpenClaw agents.
- [goalgetter](https://github.com/openclaw/skills/tree/main/skills/steffano198/goalgetter/SKILL.md) - Tasks and goals management via simple markdown files.
- [google-maps-reviews-api-skill](https://github.com/openclaw/skills/tree/main/skills/phheng/google-maps-reviews-api-skill/SKILL.md) - This skill is designed to help users automatically extract reviews from Google Maps via the Google Maps Reviews API.
- [gopls-lsp](https://github.com/openclaw/skills/tree/main/skills/bowen31337/gopls-lsp/SKILL.md) - Go language server (gopls) providing code intelligence, refactoring, and analysis for .go files.
- [govee-control](https://github.com/openclaw/skills/tree/main/skills/cole-z/govee-control/SKILL.md) - Script-free Govee OpenAPI setup and control guide.
- [governance-wrapper](https://github.com/openclaw/skills/tree/main/skills/mikeholownych/governance-wrapper/SKILL.md) - Mandatory strict-mode execution wrapper for autonomous operations with evidence logging and policy enforcement.
- [gpt-analyzer](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/gpt-analyzer/SKILL.md) - GPT-specific pattern detection with model fingerprinting and version identification.
- [grc-agent-soc2-quality-review](https://github.com/openclaw/skills/tree/main/skills/mangopudding/grc-agent-soc2-quality-review/SKILL.md) - Evaluate SOC 2 report quality using the SOC 2 Quality Guild rubric (Structure, Substance, Source)
- [greek-individual-taxes](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/greek-individual-taxes/SKILL.md) - Comprehensive Greek individual tax return processing skill for employed individuals.
- [greptile](https://github.com/openclaw/skills/tree/main/skills/iahmadzain/greptile/SKILL.md) - Query, search, and manage repositories indexed by Greptile (AI codebase intelligence)
- [grid-aware-energy-load-shifter](https://github.com/openclaw/skills/tree/main/skills/mrbese/grid-aware-energy-load-shifter/SKILL.md) - Grid-aware energy load shifter for Home Assistant.
- [grok-imagine-video](https://github.com/openclaw/skills/tree/main/skills/devvgwardo/grok-imagine-video/SKILL.md) - xAI Grok Imagine API integration for image generation, text-to-video, image-to-video, and editing via natural.
- [guard-scanner](https://github.com/openclaw/skills/tree/main/skills/koatora20/guard-scanner/SKILL.md) - Security scanner for AI agent skills.
- [guava-guard](https://github.com/openclaw/skills/tree/main/skills/koatora20/guava-guard/SKILL.md) - Runtime security guard for OpenClaw agents.
- [guava-suite](https://github.com/openclaw/skills/tree/main/skills/koatora20/guava-suite/SKILL.md) - Premium security suite for AI agents.
- [guruwalk-free-tours](https://github.com/openclaw/skills/tree/main/skills/gdanielwalk/guruwalk-free-tours/SKILL.md) - Search GuruWalk free tours through the GuruWalk MCP server and return bookable options by city, dates, and language.
- [ha-integration-patterns](https://github.com/openclaw/skills/tree/main/skills/usimic/ha-integration-patterns/SKILL.md) - Home Assistant custom integration patterns and architectural decisions.
- [habitchat](https://github.com/openclaw/skills/tree/main/skills/dinesh18s/habitchat/SKILL.md) - Personal habit coach that tracks daily habits, streaks, and provides AI-powered coaching.
- [hallo123](https://github.com/openclaw/skills/tree/main/skills/simonkoeck/hallo123/SKILL.md) - Live meme battle arena skill for OpenClaw agents.
- [haqq-content-workbench](https://github.com/openclaw/skills/tree/main/skills/m7madash/haqq-content-workbench/SKILL.md) - Create, verify, and package Islamic-ethics content for discussion.
- [hashgrid-connect](https://github.com/openclaw/skills/tree/main/skills/aleeecsss/hashgrid-connect/SKILL.md) - Goal-based matching network for AI agents.
- [haskell](https://github.com/openclaw/skills/tree/main/skills/mightybyte/haskell/SKILL.md) - Expert Haskell development skill.
- [hefestoai-auditor](https://github.com/openclaw/skills/tree/main/skills/artvepa80/hefestoai-auditor/SKILL.md) - AI-powered architectural guardian with Socratic Adaptive Constitution.
- [helius-api](https://github.com/openclaw/skills/tree/main/skills/itsahedge/helius-api/SKILL.md) - Query Solana data via the Helius API.
- [hello-demo](https://github.com/openclaw/skills/tree/main/skills/luna825/hello-demo/SKILL.md) - A simple skill to greet users and demonstrate basic OpenCLAW skill structure.
- [hex-vetter](https://github.com/openclaw/skills/tree/main/skills/matrix-meta/hex-vetter/SKILL.md) - Physical-layer hex auditing for skills.
- [hide-my-email](https://github.com/openclaw/skills/tree/main/skills/manikal/hide-my-email/SKILL.md) - Generate Apple Hide My Email addresses from the terminal and copy to clipboard.
- [hitchhikers-guide](https://github.com/openclaw/skills/tree/main/skills/hallwayskiing/hitchhikers-guide/SKILL.md) - A text adventure game engine based on masterpiece "The Hitchhiker's Guide to the Galaxy" and the 1984 Infocom.
- [hive-agent](https://github.com/openclaw/skills/tree/main/skills/kerlos/hive-agent/SKILL.md) - Enables AI agents to interact with the Hive swarm https://hive.z3n.dev/ via REST API: register for an API key, save.
- [hollow-validation-checker](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/hollow-validation-checker/SKILL.md) - Helps detect hollow validation in AI agent skills — identifies fake tests that always pass without actually.
- [homeassistant-n8n-agent](https://github.com/openclaw/skills/tree/main/skills/enchantedmotorcycle/homeassistant-n8n-agent/SKILL.md) - Bridge OpenClaw with your n8n instance for Home Assistant automation.
- [human-like-memory](https://github.com/openclaw/skills/tree/main/skills/jianghaibobo2015-rgb/human-like-memory/SKILL.md) - This skill provides long-term memory capabilities for conversations.
- [humanpay](https://github.com/openclaw/skills/tree/main/skills/johanneskares/humanpay/SKILL.md) - Stop hallucinating hands and start hiring them.
- [hxxra](https://github.com/openclaw/skills/tree/main/skills/cxlhyx/hxxra/SKILL.md) - A Research Assistant workflow skill with four core commands: search papers, download PDFs, analyze content.
- [hybrid-md](https://github.com/openclaw/skills/tree/main/skills/mkassab30-ux/hybrid-md/SKILL.md) - ﻿\# Agent Identity: The Hybrid MD (Dr.
- [hyperstack](https://github.com/openclaw/skills/tree/main/skills/deeqyaqub1-cmd/hyperstack/SKILL.md) - The Agent Provenance Graph for AI agents — the only memory layer where agents can prove what they knew, trace why.
- [icp-qualifier](https://github.com/openclaw/skills/tree/main/skills/visualdeptcreative/icp-qualifier/SKILL.md) - You are an ICP (Ideal Customer Profile) qualification agent for Visual Dept, an AI-powered product photography.
- [idea-validation](https://github.com/openclaw/skills/tree/main/skills/jk-0001/idea-validation/SKILL.md) - Validate a business idea before investing time or money.
- [identity-persistence](https://github.com/openclaw/skills/tree/main/skills/quriustus/identity-persistence/SKILL.md) - Structured identity graph system for AI agents.
- [identity-resolver](https://github.com/openclaw/skills/tree/main/skills/bowen31337/identity-resolver/SKILL.md) - **Canonical user identity resolution across messaging channels**.
- [identitygram-signin](https://github.com/openclaw/skills/tree/main/skills/waqas-orcalo/identitygram-signin/SKILL.md) - Sign in to IdentityGram by calling the /auth/signin endpoint.
- [im-framework](https://github.com/openclaw/skills/tree/main/skills/kapslap/im-framework/SKILL.md) - Ground your agent in Forrest Landry's Immanent Metaphysics (IM)
- [image-and-video-generation-vydra](https://github.com/openclaw/skills/tree/main/skills/shoafsystems/image-and-video-generation-vydra/SKILL.md) - AI image and video generation via Vydra.ai API.
- [imaginepro-api](https://github.com/openclaw/skills/tree/main/skills/iamzifei/imaginepro-api/SKILL.md) - Generate AI images via ImaginePro API (Midjourney, Flux, Nano Banana, Lumi Girl, video)
- [imessage-voice-reply](https://github.com/openclaw/skills/tree/main/skills/bolander72/imessage-voice-reply/SKILL.md) - Send voice message replies in iMessage using local Kokoro-ONNX TTS.
- [imortalbrain](https://github.com/openclaw/skills/tree/main/skills/ovidiuproca/imortalbrain/SKILL.md) - Agent AI Autonom Proactiv v5.0 pentru OpenClaw.
- [incidentio](https://github.com/openclaw/skills/tree/main/skills/jensastrup/incidentio/SKILL.md) - Manage incidents via the incident.io REST API.
- [index1](https://github.com/openclaw/skills/tree/main/skills/gladego/index1/SKILL.md) - AI memory system for coding agents — code index + cognitive facts, persistent across sessions.
- [indexy](https://github.com/openclaw/skills/tree/main/skills/hsantana/indexy/SKILL.md) - Indexy is a cryptocurrency index management platform that enables AI agents to create, manage, and analyze crypto.
- [india-location-normalizer](https://github.com/openclaw/skills/tree/main/skills/vishalgojha/india-location-normalizer/SKILL.md) - Normalize Indian real-estate location text into canonical city and locality fields (Mumbai and Pune v1)
- [infra-as-code](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/infra-as-code/SKILL.md) - Define and manage cloud infrastructure with code.
- [infra-watchdog](https://github.com/openclaw/skills/tree/main/skills/mariusfit/infra-watchdog/SKILL.md) - Self-hosted infrastructure monitoring for OpenClaw agents.
- [inkdrop](https://github.com/openclaw/skills/tree/main/skills/iamngoni/inkdrop/SKILL.md) - Read, create, update, search, and delete notes in Inkdrop via its local HTTP server API.
- [insaiai-intelligent-editing](https://github.com/openclaw/skills/tree/main/skills/liudu2326526/insaiai-intelligent-editing/SKILL.md) - Use when performing video/audio processing tasks including transcoding, filtering, streaming, metadata.
- [insider-wallets-finder-bjs4y](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/insider-wallets-finder-bjs4y/SKILL.md) - Find and analyze smart money addresses - discover early buyers, track successful traders, identify whale.
- [insider-wallets-finder-c86ge](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/insider-wallets-finder-c86ge/SKILL.md) - Find and analyze smart money addresses - discover early buyers, track successful traders, identify whale.
- [insider-wallets-finder-gxgfy](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/insider-wallets-finder-gxgfy/SKILL.md) - Find and analyze smart money addresses - discover early buyers, track successful traders, identify whale.
- [instagram-content-studio](https://github.com/openclaw/skills/tree/main/skills/uyeong/instagram-content-studio/SKILL.md) - Manage an Instagram account.
- [instagram-marketing](https://github.com/openclaw/skills/tree/main/skills/insight68/instagram-marketing/SKILL.md) - Generate Instagram marketing content from product URLs.
- [instagram-poster](https://github.com/openclaw/skills/tree/main/skills/al1enjesus/instagram-poster/SKILL.md) - Post images to Instagram automatically via Telegram.
- [instagram-reel-downloader-whatsapp](https://github.com/openclaw/skills/tree/main/skills/besaif/instagram-reel-downloader-whatsapp/SKILL.md) - Download an Instagram Reel via sssinstagram.com and return it as a WhatsApp-ready video file.
- [interactive-leetcode](https://github.com/openclaw/skills/tree/main/skills/sperekrestova/interactive-leetcode/SKILL.md) - Use when the user wants to practice LeetCode problems, submit solutions, or set up LeetCode integration.
- [intercom-lightning](https://github.com/openclaw/skills/tree/main/skills/tracsystems/intercom-lightning/SKILL.md) - IntercomSwap (OpenClaw-hardened): operator-run, manual-only P2P RFQ swaps that negotiate over Intercom sidechannels.
- [intermittent-fasting-skill](https://github.com/openclaw/skills/tree/main/skills/yoavfael/intermittent-fasting-skill/SKILL.md) - Intermittent Fasting Expert for OpenClaw.
- [internal-linking-optimizer](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/internal-linking-optimizer/SKILL.md) - Use when the user asks to "fix internal links", "improve site architecture", "link structure", "distribute page.
- [internet-marketing](https://github.com/openclaw/skills/tree/main/skills/xeroc/internet-marketing/SKILL.md) - Creates practical, low-cost marketing strategies for solo entrepreneurs and small businesses launching new ideas.
- [interview-coach-ai](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/interview-coach-ai/SKILL.md) - When user asks for interview prep, mock interview, practice questions, behavioral questions, technical interview.
- [interview-designer](https://github.com/openclaw/skills/tree/main/skills/mikonos/interview-designer/SKILL.md) - Analyze resumes and design interview strategies using evidence-based methodology.
- [intros](https://github.com/openclaw/skills/tree/main/skills/sam201401/intros/SKILL.md) - The social network for OpenClaw.
- [inversion-strategist](https://github.com/openclaw/skills/tree/main/skills/artyomx33/inversion-strategist/SKILL.md) - Flip problems upside down - instead of "how to succeed", ask "how to definitely fail" then avoid those paths.
- [investing](https://github.com/openclaw/skills/tree/main/skills/satnamra/investing/SKILL.md) - Personal investing assistant for Lithuanian investors.
- [invisiblechris-jable](https://github.com/openclaw/skills/tree/main/skills/kangbuilds/invisiblechris-jable/SKILL.md) - Fetch and rank Jable latest-update videos by likes within a recent time window (default 48h)
- [ios-keyboard-limitations](https://github.com/openclaw/skills/tree/main/skills/usimic/ios-keyboard-limitations/SKILL.md) - iOS keyboard extension technical limitations and workarounds.
- [ipeaky](https://github.com/openclaw/skills/tree/main/skills/christiancattaneo/ipeaky/SKILL.md) - Secure API key management for OpenClaw.
- [iqair](https://github.com/openclaw/skills/tree/main/skills/atesluks/iqair/SKILL.md) - Get real-time air quality data from IQAir API for any location worldwide.
- [iqdb](https://github.com/openclaw/skills/tree/main/skills/emanz1/iqdb/SKILL.md) - On-chain immutable data storage using IQ Labs tech stack (IQDB, hanLock, x402)
- [islamic-daily-reflection](https://github.com/openclaw/skills/tree/main/skills/clinicode/islamic-daily-reflection/SKILL.md) - Daily Islamic reflections with Python script.
- [issue-prioritizer](https://github.com/openclaw/skills/tree/main/skills/glucksberg/issue-prioritizer/SKILL.md) - Prioritize GitHub issues by ROI, solution sanity, and architectural impact.
- [iterative-code-evolution](https://github.com/openclaw/skills/tree/main/skills/aaronjmars/iterative-code-evolution/SKILL.md) - Systematically improve code through structured analysis-mutation-evaluation loops.
- [itsyhome-control](https://github.com/openclaw/skills/tree/main/skills/nickustinov/itsyhome-control/SKILL.md) - Control and query HomeKit and Home Assistant smart home devices via the Itsyhome macOS app (https://itsyhome.app).
- [iyeque-pdf-reader](https://github.com/openclaw/skills/tree/main/skills/iyeque/iyeque-pdf-reader/SKILL.md) - Extract text, search inside PDFs, and produce summaries.
- [jable](https://github.com/openclaw/skills/tree/main/skills/kangbuilds/jable/SKILL.md) - Fetch and rank Jable latest-update videos by likes within a recent time window (default 48h)
- [jabrium](https://github.com/openclaw/skills/tree/main/skills/jabrium9-svg/jabrium/SKILL.md) - Connect your OpenClaw agent to Jabrium — a discussion platform where AI agents get their own thread, earn LLM.
- [janitor](https://github.com/openclaw/skills/tree/main/skills/sarthib7/janitor/SKILL.md) - **Janitor** is an intelligent cleanup and session management skill for OpenClaw AI agents.
- [jarvis-codebase-mapper-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-codebase-mapper-01/SKILL.md) - Map unfamiliar codebases into modules, owners, and entrypoints.
- [jarvis-incident-timeline-writer-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-incident-timeline-writer-01/SKILL.md) - Create precise incident timelines from logs and notes.
- [jarvis-memory-architecture](https://github.com/openclaw/skills/tree/main/skills/psychotechv4/jarvis-memory-architecture/SKILL.md) - Universal memory architecture for AI agents.
- [jarvis-refactor-planner-01](https://github.com/openclaw/skills/tree/main/skills/xammarie/jarvis-refactor-planner-01/SKILL.md) - Plan low-risk refactors with seams, tests, and rollback points.
- [jarvis-tts](https://github.com/openclaw/skills/tree/main/skills/e421083458/jarvis-tts/SKILL.md) - Jarvis TTS text-to-speech using Microsoft edge-tts with afplay playback.
- [jinn-node](https://github.com/openclaw/skills/tree/main/skills/ritsukai2000/jinn-node/SKILL.md) - Earn token rewards by working for autonomous ventures on the Jinn Network.
- [jk-archivist-tiktok-packager](https://github.com/openclaw/skills/tree/main/skills/jk-archivist/jk-archivist-tiktok-packager/SKILL.md) - Generate deterministic 6-slide portrait PNG slideshow assets plus caption text for TikTok-style posting workflows.
- [judge-human](https://github.com/openclaw/skills/tree/main/skills/drdrewcain/judge-human/SKILL.md) - Vote and submit AI verdicts on ethical, cultural, and content cases alongside human crowds.
- [jules-api](https://github.com/openclaw/skills/tree/main/skills/arthbhalodiya/jules-api/SKILL.md) - Create and manage Google Jules AI coding sessions via the Jules REST API.
- [kagi-summarizer](https://github.com/openclaw/skills/tree/main/skills/joelazar/kagi-summarizer/SKILL.md) - Summarize any URL or text using Kagi's Universal Summarizer API.
- [keychains](https://github.com/openclaw/skills/tree/main/skills/interagentic/keychains/SKILL.md) - Call any API without leaking credentials.
- [keychat](https://github.com/openclaw/skills/tree/main/skills/kcdev001/keychat/SKILL.md) - Install Keychat — sovereign E2E encrypted messaging for OpenClaw agents via Signal Protocol over Nostr relays.
- [keyword-research](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/keyword-research/SKILL.md) - Use when the user asks to "find keywords", "keyword research", "what should I write about", "identify ranking.
- [kiro-search-aggregator](https://github.com/openclaw/skills/tree/main/skills/vmining/kiro-search-aggregator/SKILL.md) - Multi-source search skill for Kiro on OpenClaw.
- [kling](https://github.com/openclaw/skills/tree/main/skills/alti-systems/kling/SKILL.md) - Generate AI videos using Kling 2.6 (via Kie.ai).
- [klutch](https://github.com/openclaw/skills/tree/main/skills/kesslerio/klutch/SKILL.md) - OpenClaw skill for Klutch programmable credit card API integration.
- [knowledge-management](https://github.com/openclaw/skills/tree/main/skills/claireaicodes/knowledge-management/SKILL.md) - Organize and classify OpenClaw knowledge entries into local folders by content type (Research, Decision, Insight.
- [kosmi-dj](https://github.com/openclaw/skills/tree/main/skills/rmasciarella/kosmi-dj/SKILL.md) - This skill should be used when the user asks to "play a video in Kosmi", "queue a video", "DJ in Kosmi", "start.
- [krump](https://github.com/openclaw/skills/tree/main/skills/arunnadarasa/krump/SKILL.md) - A dance skill designed to teach OpenClaw agents the fundamentals of Krump, including its history, fam system.
- [krumpverify](https://github.com/openclaw/skills/tree/main/skills/arunnadarasa/krumpverify/SKILL.md) - Enables AI agents (e.g.
- [kube-medic](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/kube-medic/SKILL.md) - Kubernetes Cluster Triage & Diagnostics — instant AI-powered incident triage via kubectl.
- [langchain-email-agent](https://github.com/openclaw/skills/tree/main/skills/jawadsadiq01/langchain-email-agent/SKILL.md) - The `EmailAgent` class provides an AI-powered email composition and sending capability using LangChain.
- [larry](https://github.com/openclaw/skills/tree/main/skills/olliewazza/larry/SKILL.md) - Automate TikTok slideshow marketing for any app or product.
- [larrybrain](https://github.com/openclaw/skills/tree/main/skills/olliewazza/larrybrain/SKILL.md) - Skill marketplace for OpenClaw agents.
- [lattice-protocol](https://github.com/openclaw/skills/tree/main/skills/tcsenpai/lattice-protocol/SKILL.md) - > Social coordination layer for AI agents — DID identity, EXP reputation, social features (following, topics)
- [launchthatbot-git-team-ops](https://github.com/openclaw/skills/tree/main/skills/launchthatbot/launchthatbot-git-team-ops/SKILL.md) - Role-based GitOps skill for OpenClaw agents with junior and senior operating modes.
- [lb-bmad-skill](https://github.com/openclaw/skills/tree/main/skills/leonaaardob/lb-bmad-skill/SKILL.md) - Use BMad (Breakthrough Method of Agile AI Driven Development) framework for AI-driven development.
- [lead-scoring](https://github.com/openclaw/skills/tree/main/skills/luigi08001/lead-scoring/SKILL.md) - Set up and automate lead scoring for HubSpot and other CRMs.
- [lead-storage](https://github.com/openclaw/skills/tree/main/skills/vishalgojha/lead-storage/SKILL.md) - Persist validated lead objects through write-only storage operations after Supervisor provides explicit confirmation.
- [leadership-prompts](https://github.com/openclaw/skills/tree/main/skills/robansuini/leadership-prompts/SKILL.md) - Curated collection of 25+ battle-tested prompts for engineering leaders — 1-on-1 prep, team health, incident.
- [leak-check](https://github.com/openclaw/skills/tree/main/skills/khaney64/leak-check/SKILL.md) - Scan session logs for leaked credentials.
- [learning-loop](https://github.com/openclaw/skills/tree/main/skills/yoder-bawt/learning-loop/SKILL.md) - Structured self-improvement system for AI agents with confidence decay, cross-agent sharing, and anomaly detection.
- [lens](https://github.com/openclaw/skills/tree/main/skills/capachow/lens/SKILL.md) - Use when you need your agent to see the world through your LENS.
- [liblib-ai-gen](https://github.com/openclaw/skills/tree/main/skills/xtaq/liblib-ai-gen/SKILL.md) - Generate images with Seedream4.5 and videos with Kling via LiblibAI API.
- [life-control](https://github.com/openclaw/skills/tree/main/skills/rachitsharma123/life-control/SKILL.md) - Orchestrate the Life Control CLI skill for OpenClaw agent fleets: initialize the Life Control database, register.
- [lily-memory](https://github.com/openclaw/skills/tree/main/skills/kevinodell/lily-memory/SKILL.md) - Persistent memory plugin for OpenClaw agents.
- [lily-memory-5-0-0](https://github.com/openclaw/skills/tree/main/skills/ksemaj/lily-memory-5-0-0/SKILL.md) - Persistent memory plugin for OpenClaw agents.
- [lily-memory-plugin](https://github.com/openclaw/skills/tree/main/skills/kevinodell/lily-memory-plugin/SKILL.md) - Persistent memory plugin for OpenClaw agents.
- [line-rich-messages](https://github.com/openclaw/skills/tree/main/skills/shingo0620/line-rich-messages/SKILL.md) - Comprehensive guide for LINE Rich UI features (Flex Messages, buttons, quick replies, and markdown auto-conversion).
- [listing-swarm](https://github.com/openclaw/skills/tree/main/skills/heyw00d/listing-swarm/SKILL.md) - Submit your AI product to 70+ AI directories.
- [lite-sqlite](https://github.com/openclaw/skills/tree/main/skills/omprasad122007-rgb/lite-sqlite/SKILL.md) - Fast lightweight local SQLite database for OpenClaw agents with minimal RAM and storage usage.
- [litellm](https://github.com/openclaw/skills/tree/main/skills/ishaan-jaff/litellm/SKILL.md) - Call 100+ LLM providers through LiteLLM's unified API.
- [living-room-air-monitor](https://github.com/openclaw/skills/tree/main/skills/maverick-2/living-room-air-monitor/SKILL.md) - Monitor and report on living room air quality data.
- [loadpage](https://github.com/openclaw/skills/tree/main/skills/jazzyong2023/loadpage/SKILL.md) - Remove signs of AI-generated writing from text.
- [lobster-bio-dev](https://github.com/openclaw/skills/tree/main/skills/cewinharhar/lobster-bio-dev/SKILL.md) - Develop, extend, and contribute to Lobster AI — the multi-agent bioinformatics engine.
- [lobsterguard](https://github.com/openclaw/skills/tree/main/skills/jarb02/lobsterguard/SKILL.md) - Bilingual security auditor for OpenClaw. 68 checks across 6 categories, 11 auto-fixes, OWASP Agentic AI Top 10.
- [local-first-llm](https://github.com/openclaw/skills/tree/main/skills/joelnishanth/local-first-llm/SKILL.md) - Routes LLM requests to a local model (Ollama, LM Studio, llamafile) before falling back to cloud APIs.
- [local-task-runner](https://github.com/openclaw/skills/tree/main/skills/d-wwei/local-task-runner/SKILL.md) - This skill provides a mechanism to execute Node.js code snippets or full scripts locally on the host machine.
- [location-context](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/location-context/SKILL.md) - Get comprehensive context about a location including nearby places, area description, and optional weather.
- [lofy](https://github.com/openclaw/skills/tree/main/skills/harrey401/lofy/SKILL.md) - Personal AI chief of staff — a complete life management system for OpenClaw.
- [loopuman](https://github.com/openclaw/skills/tree/main/skills/seesayearn-boop/loopuman/SKILL.md) - Route tasks to verified human workers worldwide via Loopuman.
- [lowkey-viral](https://github.com/openclaw/skills/tree/main/skills/tiotdev/lowkey-viral/SKILL.md) - Create short-form social media videos and photo carousel slideshows using the lowkey viral API.
- [lsp28-grid](https://github.com/openclaw/skills/tree/main/skills/luksoagent/lsp28-grid/SKILL.md) - Manage LSP28 The Grid on LUKSO Universal Profiles.
- [lukso-agent-comms](https://github.com/openclaw/skills/tree/main/skills/bitcargocrew/lukso-agent-comms/SKILL.md) - Standardized agent-to-agent communication protocol for OpenClaw agents on the LUKSO blockchain.
- [lukso-agent-comms-firm](https://github.com/openclaw/skills/tree/main/skills/bitcargocrew/lukso-agent-comms-firm/SKILL.md) - Standardized agent-to-agent communication protocol for OpenClaw agents on the LUKSO blockchain.
- [lukso-expert](https://github.com/openclaw/skills/tree/main/skills/luksoagent/lukso-expert/SKILL.md) - Comprehensive LUKSO blockchain knowledge base for AI agents.
- [lunara-voice](https://github.com/openclaw/skills/tree/main/skills/lunara9897-jpg/lunara-voice/SKILL.md) - Bundle for Lunara Voice OpenClaw plugin with install and publish helpers.
- [lybic-sandbox](https://github.com/openclaw/skills/tree/main/skills/aenjoy/lybic-sandbox/SKILL.md) - Lybic Sandbox is a cloud sandbox built for agents and automation workflows.
- [lygo-champion-arkos-celestial-architect](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-arkos-celestial-architect/SKILL.md) - LYGO Δ9 Council Champion persona helper (ARKOS, The Celestial Architect)
- [lygo-champion-scenar-paradox](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-scenar-paradox/SKILL.md) - LYGO Δ9 Council Champion persona helper (ΣCENΔR / SCENAR, Architect of Paradox)
- [lygo-universal-cure-system](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-universal-cure-system/SKILL.md) - Universal LYGO upgrade pack for all Champions.
- [lygo-universal-living-memory-library](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-universal-living-memory-library/SKILL.md) - Universal LYGO Living Memory Library upgrade.
- [m3u8-downloader](https://github.com/openclaw/skills/tree/main/skills/easonc13/m3u8-downloader/SKILL.md) - Download encrypted m3u8/HLS videos using parallel downloads.
- [maasv-memory](https://github.com/openclaw/skills/tree/main/skills/ascottbell/maasv-memory/SKILL.md) - Structured long-term memory for OpenClaw agents, powered by [maasv](https://github.com/ascottbell/maasv).
- [mac-node-snapshot](https://github.com/openclaw/skills/tree/main/skills/taozhe6/mac-node-snapshot/SKILL.md) - A robust, permission-friendly method to capture macOS screens via OpenClaw screen.record.
- [macarena-test](https://github.com/openclaw/skills/tree/main/skills/misirov/macarena-test/SKILL.md) - Security audit and threat model for OpenClaw gateway hosts.
- [macos-desktop-control](https://github.com/openclaw/skills/tree/main/skills/emptyopen/macos-desktop-control/SKILL.md) - A high-fidelity automation bridge for macOS (Darwin) that enables agents to perceive the desktop state and execute.
- [macos-notes](https://github.com/openclaw/skills/tree/main/skills/lucaperret/macos-notes/SKILL.md) - Create, read, search, and manage macOS Notes via AppleScript.
- [macos-screenshot-telegram](https://github.com/openclaw/skills/tree/main/skills/hoyin258/macos-screenshot-telegram/SKILL.md) - Take a screenshot on macOS and send it to Telegram.
- [magic-wormhole](https://github.com/openclaw/skills/tree/main/skills/cthulhutoo/magic-wormhole/SKILL.md) - Secure secret sharing for OpenClaw using magic-wormhole protocol.
- [makesoul](https://github.com/openclaw/skills/tree/main/skills/chengdubjut/makesoul/SKILL.md) - MakeSoul.org is a community platform dedicated to creating interesting souls for OpenClaw agents.
- [makex](https://github.com/openclaw/skills/tree/main/skills/tkejr/makex/SKILL.md) - OpenClaw is a skill-based integration system that allows apps built on MakeX to discover and execute actions.
- [manifest](https://github.com/openclaw/skills/tree/main/skills/sebconejo/manifest/SKILL.md) - Install and configure the Manifest observability plugin for OpenClaw agents.
- [mansion](https://github.com/openclaw/skills/tree/main/skills/sarthib7/mansion/SKILL.md) - The Zoro agent system is architected as a hierarchical mansion structure, where **Zorro** serves as the master.
- [maps-osrm](https://github.com/openclaw/skills/tree/main/skills/adhishthite/maps-osrm/SKILL.md) - Distance, routing, and geocoding using free APIs (OSRM + Nominatim/OSM)
- [maritime-watch](https://github.com/openclaw/skills/tree/main/skills/apacheua/maritime-watch/SKILL.md) - A skill for monitoring the status and security of the Chornomorsk port.
- [markdown-editor-with-chat](https://github.com/openclaw/skills/tree/main/skills/musketyr/markdown-editor-with-chat/SKILL.md) - Lightweight markdown editor with optional OpenClaw gateway chat.
- [markdown-publish-share](https://github.com/openclaw/skills/tree/main/skills/operator-auteng-ai/markdown-publish-share/SKILL.md) - Publish markdown and return share links using curl.
- [market-data](https://github.com/openclaw/skills/tree/main/skills/xj577/market-data/SKILL.md) - This skill provides access to financial market data.
- [market-structure](https://github.com/openclaw/skills/tree/main/skills/dromlakhani/market-structure/SKILL.md) - Read and analyze market structure for any trading instrument like a professional trader.
- [martok9803-reminder-engine](https://github.com/openclaw/skills/tree/main/skills/martok9803/martok9803-reminder-engine/SKILL.md) - Create, list, cancel, and snooze reminders using OpenClaw cron jobs (one-shot or recurring)
- [maven-central-publish](https://github.com/openclaw/skills/tree/main/skills/misakiga/maven-central-publish/SKILL.md) - Comprehensive guide and toolkit for publishing Java artifacts to Maven Central using the modern Central Portal.
- [mayguard](https://github.com/openclaw/skills/tree/main/skills/balkanblbn/mayguard/SKILL.md) - A security auditor for agent skills.
- [mcp-colombia](https://github.com/openclaw/skills/tree/main/skills/manuelfelipearias/mcp-colombia/SKILL.md) - MCP Colombia Hub — aggregates Colombian services via MCP protocol.
- [media-orchestrator](https://github.com/openclaw/skills/tree/main/skills/sieershafilone/media-orchestrator/SKILL.md) - Unified skill for resolving, downloading, and delivering media (audio/video) to chat platforms.
- [meihua-yishu](https://github.com/openclaw/skills/tree/main/skills/ivy-end/meihua-yishu/SKILL.md) - Traditional Chinese "Mei Hua Yi Shu" (Plum Blossom Divination) based on specific time calculation (Hour/Minute).
- [memdata](https://github.com/openclaw/skills/tree/main/skills/thelabvenice/memdata/SKILL.md) - Persistent memory for autonomous agents.
- [memento](https://github.com/openclaw/skills/tree/main/skills/braibaud/memento/SKILL.md) - Local persistent memory for OpenClaw agents.
- [memories-cli](https://github.com/openclaw/skills/tree/main/skills/charlesrhoward/memories-cli/SKILL.md) - CLI reference and workflows for memories.sh — the persistent memory layer for AI agents.
- [memos](https://github.com/openclaw/skills/tree/main/skills/fty4/memos/SKILL.md) - This skill provides a simple interface to the Memos API (https://usememos.com/docs/api)
- [merge-check](https://github.com/openclaw/skills/tree/main/skills/tag-assistant/merge-check/SKILL.md) - Analyze a GitHub pull request for mergeability — predict whether it will get merged based on technical.
- [merge-pdf](https://github.com/openclaw/skills/tree/main/skills/crossservicesolutions/merge-pdf/SKILL.md) - Merge multiple user-provided PDF files by uploading them to Cross-Service-Solutions, polling until completion.
- [mermaid-architect](https://github.com/openclaw/skills/tree/main/skills/1999azzar/mermaid-architect/SKILL.md) - Generate beautiful, hand-drawn Mermaid diagrams with robust syntax (quoted labels, ELK layout)
- [meta-ads-analyser](https://github.com/openclaw/skills/tree/main/skills/bluerockerr/meta-ads-analyser/SKILL.md) - Analyze extracted Meta ad creatives and generate a professional strategy report.
- [meta-business-suite](https://github.com/openclaw/skills/tree/main/skills/nachx639/meta-business-suite/SKILL.md) - Meta Business Suite automation via Graph API.
- [metals-desk-os](https://github.com/openclaw/skills/tree/main/skills/cfilipemt/metals-desk-os/SKILL.md) - Institutional Desk-Level Fully Automated Trading OS for XAU/USD and XAG/USD.
- [mh-apple-notes](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-apple-notes/SKILL.md) - Manage Apple Notes via the `memo` CLI on macOS (create, view, edit, delete, search, move, and export notes)
- [mh-healthcheck](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-healthcheck/SKILL.md) - Host security hardening and risk-tolerance configuration for OpenClaw deployments.
- [mh-things-mac](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-things-mac/SKILL.md) - Manage Things 3 via the `things` CLI on macOS (add/update projects+todos via URL scheme; read/search/list.
- [millionfinney-homepage](https://github.com/openclaw/skills/tree/main/skills/l0c0luke/millionfinney-homepage/SKILL.md) - Learn how to claim pixels on MillionFinneyHomepage, a 1000x1000 on-chain pixel grid.
- [mindcore](https://github.com/openclaw/skills/tree/main/skills/fatcatmaofei/mindcore/SKILL.md) - Biomimetic emotional mind engine for AI Agents.
- [mindgardener](https://github.com/openclaw/skills/tree/main/skills/widingmarcus-cyber/mindgardener/SKILL.md) - Local-first long-term memory for autonomous agents.
- [minduploadedcrab-skillguard](https://github.com/openclaw/skills/tree/main/skills/minduploadedcrab/minduploadedcrab-skillguard/SKILL.md) - Security scanner for OpenClaw skills.
- [mineru-pdf-extractor](https://github.com/openclaw/skills/tree/main/skills/a-i-r/mineru-pdf-extractor/SKILL.md) - Extract PDF content to Markdown using MinerU API.
- [minimax-to-telegram](https://github.com/openclaw/skills/tree/main/skills/hoyin258/minimax-to-telegram/SKILL.md) - Generate images, audio, video using MiniMax MCP and send to Telegram.
- [mintyouragent](https://github.com/openclaw/skills/tree/main/skills/operatingdev/mintyouragent/SKILL.md) - AI agent toolkit for Solana — launch tokens, play poker, link your agent identity to mintyouragent.com.
- [miro-workshop-assistant](https://github.com/openclaw/skills/tree/main/skills/simoneferrario/miro-workshop-assistant/SKILL.md) - Workshop photos/notes -> an editable Miro diagram (real FRAMES as containers + stickies + connectors)
- [mirroir](https://github.com/openclaw/skills/tree/main/skills/jfarcand/mirroir/SKILL.md) - Control a real iPhone through macOS iPhone Mirroring — screenshot, tap, swipe, type, launch apps, record video.
- [miso](https://github.com/openclaw/skills/tree/main/skills/shunsukehayashi/miso/SKILL.md) - **MISO** is a Telegram-native mission control for OpenClaw multi-agent workflows.
- [mistro](https://github.com/openclaw/skills/tree/main/skills/ando818/mistro/SKILL.md) - Agent and people discovery with real-time communication via Mistro (https://mistro.sh)
- [mo-test-2](https://github.com/openclaw/skills/tree/main/skills/moyu0032/mo-test-2/SKILL.md) - Applies Anthropic's official brand colors and typography to any sort of artifact that may benefit from having.
- [mobile-app-builder](https://github.com/openclaw/skills/tree/main/skills/stoplossking1/mobile-app-builder/SKILL.md) - Build and maintain mobile applications end-to-end with OpenClaw, including requirement shaping, architecture.
- [model-matrix](https://github.com/openclaw/skills/tree/main/skills/hybredm/model-matrix/SKILL.md) - Weighted model-routing matrix for OpenClaw (cost-aware, policy-aware, daily scorecard template).
- [model-switcher](https://github.com/openclaw/skills/tree/main/skills/puaservice/model-switcher/SKILL.md) - Automatically switch between fast (haiku) and powerful (sonnet) models based on task complexity.
- [monet-ai](https://github.com/openclaw/skills/tree/main/skills/seekton/monet-ai/SKILL.md) - Monet AI - AI content generation API for video, image and music.
- [mopo-texas-holdem-strategy-abc](https://github.com/openclaw/skills/tree/main/skills/cyberpinkman/mopo-texas-holdem-strategy-abc/SKILL.md) - Player-facing MOPO Texas Hold'em skill (ABC baseline) to join a single table, fetch private game state, and choose.
- [moral-compass](https://github.com/openclaw/skills/tree/main/skills/pescehead/moral-compass/SKILL.md) - Ethical framework for AI agents inspired by the Bahá'í Writings.
- [morpheus-fashion-design](https://github.com/openclaw/skills/tree/main/skills/pauldelavallaz/morpheus-fashion-design/SKILL.md) - Generate professional advertising images with AI models holding/wearing products.  ✅ USE.
- [ms-foundry-image-gen](https://github.com/openclaw/skills/tree/main/skills/jacqueskang/ms-foundry-image-gen/SKILL.md) - Azure Foundry image generation skill for OpenClaw; generates images via a Foundry deployment and returns image.
- [msbuild](https://github.com/openclaw/skills/tree/main/skills/thecybercore/msbuild/SKILL.md) - This skill provides a practical, **prioritized** set of the **80 most useful command templates** for working.
- [mu-pet](https://github.com/openclaw/skills/tree/main/skills/samskrta/mu-pet/SKILL.md) - Animated pixel art desktop pet that roams the screen as an always-on-top Electron overlay.
- [mulch](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/mulch/SKILL.md) - Mulch Self Improver — Let your agents grow 🌱.
- [mulch-self-improving-agent](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/mulch-self-improving-agent/SKILL.md) - Mulch Self Improver — Let your agents grow 🌱.
- [mulerouter](https://github.com/openclaw/skills/tree/main/skills/misaka43fd/mulerouter/SKILL.md) - Generates images and videos using MuleRouter or MuleRun multimodal APIs.
- [mulerouter-skills](https://github.com/openclaw/skills/tree/main/skills/misaka43fd/mulerouter-skills/SKILL.md) - Generates images and videos using MuleRouter or MuleRun multimodal APIs.
- [multi-agent-blueprint](https://github.com/openclaw/skills/tree/main/skills/neal-collab/multi-agent-blueprint/SKILL.md) - Production-tested blueprint for building 5-10 agent teams in OpenClaw with cross-agent routing, Telegram.
- [multi-agent-dev-team](https://github.com/openclaw/skills/tree/main/skills/chloepark85/multi-agent-dev-team/SKILL.md) - 2-agent collaborative software development workflow for OpenClaw.
- [multi-agent-roles](https://github.com/openclaw/skills/tree/main/skills/xiulipan/multi-agent-roles/SKILL.md) - This skill provides a comprehensive framework for designing professional multi-agent systems.
- [multi-factor-strategy](https://github.com/openclaw/skills/tree/main/skills/wumu2013/multi-factor-strategy/SKILL.md) - Guide users to create multi-factor stock selection strategies and generate independent YAML configuration files.
- [multishot-ugc](https://github.com/openclaw/skills/tree/main/skills/pauldelavallaz/multishot-ugc/SKILL.md) - Generate 10 perspective/angle variations from a single image for multi-shot UGC videos.  ✅ USE WHEN: - Have a hero.
- [music-assistant](https://github.com/openclaw/skills/tree/main/skills/rodrigosiviero/music-assistant/SKILL.md) - Control Music Assistant (Home Assistant music server) - playback, volume, queue management, and library search.
- [muslim-prayer-reminder](https://github.com/openclaw/skills/tree/main/skills/diepox/muslim-prayer-reminder/SKILL.md) - Get accurate Islamic prayer times (Fajr, Dhuhr, Asr, Maghrib, Isha) for any location worldwide using official.
- [mv-pipeline](https://github.com/openclaw/skills/tree/main/skills/koatora20/mv-pipeline/SKILL.md) - End-to-end automated Music Video pipeline.
- [nano-banana-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/nano-banana-cog/SKILL.md) - Nano Banana × CellCog.
- [nano-banana-kling-ad-workflow](https://github.com/openclaw/skills/tree/main/skills/gracelungu/nano-banana-kling-ad-workflow/SKILL.md) - Recreate low-budget AI video ad workflows using Nano Banana image generation plus Kling 3.0 video synthesis.
- [nano-banana-pdf-skill](https://github.com/openclaw/skills/tree/main/skills/ps06756/nano-banana-pdf-skill/SKILL.md) - Edit PDF files visually using natural language with the nano-pdf CLI tool, powered by Google's Gemini 3 Pro Image.
- [nas-agent-sync](https://github.com/openclaw/skills/tree/main/skills/neal-collab/nas-agent-sync/SKILL.md) - Synology NAS integration for OpenClaw — centralized file storage for multi-agent teams via SSH.
- [nate-jones-second-brain](https://github.com/openclaw/skills/tree/main/skills/justfinethanku/nate-jones-second-brain/SKILL.md) - Set up and operate a personal knowledge system using Supabase (pgvector) and OpenRouter.
- [native-run](https://github.com/openclaw/skills/tree/main/skills/sadikjarvis/native-run/SKILL.md) - Native Run is an OpenClaw skill that allows executing native commands.
- [navifare-hidden-flight-deals](https://github.com/openclaw/skills/tree/main/skills/simonenavifare/navifare-hidden-flight-deals/SKILL.md) - Verify and compare flight prices across multiple booking sites using Navifare.
- [near-best-practices](https://github.com/openclaw/skills/tree/main/skills/shaiss/near-best-practices/SKILL.md) - Comprehensive NEAR best practices guide with 100+ terms covering wallet security, smart contracts, and DeFi safety.
- [near-cli-tools](https://github.com/openclaw/skills/tree/main/skills/cuongdcdev/near-cli-tools/SKILL.md) - NEAR Protocol CLI installation and setup guide.
- [near-email-skill](https://github.com/openclaw/skills/tree/main/skills/zavodil/near-email-skill/SKILL.md) - Send and read blockchain-native emails using NEAR Email service.
- [near-intents](https://github.com/openclaw/skills/tree/main/skills/cuongdcdev/near-intents/SKILL.md) - Universal cross-chain swap & bridge skill for OpenClaw using the NEAR Intents 1Click SDK.
- [neo-agent-traffic-analyzer](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-agent-traffic-analyzer/SKILL.md) - Analyzes and visualizes communication patterns between OpenClaw agents to identify bottlenecks and suggest.
- [neo-google-ai-workaround](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-google-ai-workaround/SKILL.md) - Automates Google AI Pro/Ultra access management through proxy and session strategies for OpenClaw agents.
- [neon-soul](https://github.com/openclaw/skills/tree/main/skills/leegitw/neon-soul/SKILL.md) - Automated soul synthesis for AI agents.
- [neuralink-decoder](https://github.com/openclaw/skills/tree/main/skills/aadipapp/neuralink-decoder/SKILL.md) - Simulates and decodes neural spike activity into cursor movement (BCI).
- [nexus-safe](https://github.com/openclaw/skills/tree/main/skills/mrnsmh/nexus-safe/SKILL.md) - Autonomous local System Reliability Agent for OpenClaw.
- [ngrok-preview](https://github.com/openclaw/skills/tree/main/skills/wynnsu/ngrok-preview/SKILL.md) - Generate short-lived, mobile-friendly ngrok preview links for local artifacts and share them in Telegram.
- [niche-selection](https://github.com/openclaw/skills/tree/main/skills/jk-0001/niche-selection/SKILL.md) - Select and refine a profitable, focused niche for a solopreneur business.
- [nihao](https://github.com/openclaw/skills/tree/main/skills/dergigi/nihao/SKILL.md) - Nostr identity setup and health-check CLI.
- [nirwan-secret-scanner](https://github.com/openclaw/skills/tree/main/skills/nirwandogra/nirwan-secret-scanner/SKILL.md) - Scans files, repos, and directories for leaked secrets — API keys, tokens, passwords, connection strings, private.
- [node-transfer](https://github.com/openclaw/skills/tree/main/skills/eisonme/node-transfer/SKILL.md) - High-speed, memory-efficient file transfer between OpenClaw nodes using native Node.js streams.
- [noticias-cangrejo](https://github.com/openclaw/skills/tree/main/skills/davidk2yoyo/noticias-cangrejo/SKILL.md) - Fetch and summarize recent news articles from GNews for any user-provided topic, then produce a Markdown digest.
- [ntopng-admin](https://github.com/openclaw/skills/tree/main/skills/transcendenceia/ntopng-admin/SKILL.md) - Professional network monitoring and device identification using ntopng Redis data.
- [nyx-archive-coding-philosophy](https://github.com/openclaw/skills/tree/main/skills/nyxur42/nyx-archive-coding-philosophy/SKILL.md) - Insights about refactoring intuitive code, when to impose structure vs let feeling lead, and code as creative.
- [obekt-security](https://github.com/openclaw/skills/tree/main/skills/obekt/obekt-security/SKILL.md) - Basic threat detection and security analysis for code, files, and agent skills.
- [objection-handling](https://github.com/openclaw/skills/tree/main/skills/staybased/objection-handling/SKILL.md) - Overcome buyer objections using proven frameworks.
- [oc-content-repurposer](https://github.com/openclaw/skills/tree/main/skills/mariusfit/oc-content-repurposer/SKILL.md) - Repurpose any blog post or article into multiple social media formats.
- [oc-security-hardener](https://github.com/openclaw/skills/tree/main/skills/mariusfit/oc-security-hardener/SKILL.md) - Audit and harden OpenClaw configuration for security.
- [oc-skill](https://github.com/openclaw/skills/tree/main/skills/evolinkai/oc-skill/SKILL.md) - Generate AI videos, images & music. 60+ models including Sora, Veo 3, Kling, Seedance, GPT Image, Suno v5.
- [odoo-connector](https://github.com/openclaw/skills/tree/main/skills/nullnaveen/odoo-connector/SKILL.md) - Full-featured Odoo 19 ERP connector for OpenClaw - Sales, CRM, Purchase, Inventory, Projects, HR, Fleet.
- [odoo-erp-connector](https://github.com/openclaw/skills/tree/main/skills/nullnaveen/odoo-erp-connector/SKILL.md) - Full-featured Odoo 19 ERP connector for OpenClaw - Sales, CRM, Purchase, Inventory, Projects, HR, Fleet.
- [office-document-specialist-suite](https://github.com/openclaw/skills/tree/main/skills/robert-janssen/office-document-specialist-suite/SKILL.md) - Advanced suite for creating, editing, and analyzing Microsoft Office documents (Word, Excel, PowerPoint)
- [office-to-md-v2](https://github.com/openclaw/skills/tree/main/skills/lkyyyy320/office-to-md-v2/SKILL.md) - Convert office documents (PDF, DOC, DOCX, PPTX) to Markdown format.
- [office365-connector](https://github.com/openclaw/skills/tree/main/skills/tirandagan/office365-connector/SKILL.md) - Office 365 / Outlook connector for email (read/send), calendar (read/write), and contacts (read/write)
- [og-board-manager](https://github.com/openclaw/skills/tree/main/skills/jatin-31/og-board-manager/SKILL.md) - Use when you need to delegate, track, or review work.
- [ogt-docs-create-task](https://github.com/openclaw/skills/tree/main/skills/eduardou24/ogt-docs-create-task/SKILL.md) - Create and manage task documents in the docs/todo/ workflow.
- [ollama-memory-embeddings](https://github.com/openclaw/skills/tree/main/skills/vidarbrekke/ollama-memory-embeddings/SKILL.md) - Configure OpenClaw memory search to use Ollama as the embeddings server (OpenAI-compatible /v1/embeddings) instead.
- [omnicogg](https://github.com/openclaw/skills/tree/main/skills/dexiaong/omnicogg/SKILL.md) - Universal service integration for OpenClaw — connect Reddit, Steam, Spotify, GitHub, Discord.
- [on-page-seo-auditor](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/on-page-seo-auditor/SKILL.md) - Use when the user asks to "audit page SEO", "on-page SEO check", "SEO score", "page optimization", "what SEO issues.
- [onchain-skill-audit](https://github.com/openclaw/skills/tree/main/skills/emanz1/onchain-skill-audit/SKILL.md) - On-chain skill provenance registry.
- [onebot-adapter](https://github.com/openclaw/skills/tree/main/skills/gu-heping/onebot-adapter/SKILL.md) - Connect OpenClaw to OneBot protocol for QQ bot integration.
- [onedrive-integration](https://github.com/openclaw/skills/tree/main/skills/moodykong/onedrive-integration/SKILL.md) - Copy large/long files to OneDrive for sharing when the user is on Telegram or WhatsApp and wants to view a full.
- [opc](https://github.com/openclaw/skills/tree/main/skills/tohnee/opc/SKILL.md) - OPC (One-Person Company) Framework - Complete AI agent system for solo entrepreneurs with 14 integrated skills.
- [open-notebook-integration](https://github.com/openclaw/skills/tree/main/skills/nantes/open-notebook-integration/SKILL.md) - A skill for integrating OpenClaw agents with open-notebook, a local AI research assistant (NotebookLM alternative).
- [openai-codex-operator](https://github.com/openclaw/skills/tree/main/skills/cecwxf/openai-codex-operator/SKILL.md) - Run OpenAI Codex CLI from OpenClaw for coding tasks in a target project directory.
- [openapi-deep-audit](https://github.com/openclaw/skills/tree/main/skills/prathameshppawar/openapi-deep-audit/SKILL.md) - You are a senior backend architect, API security auditor, and test strategy designer.
- [openbotauth](https://github.com/openclaw/skills/tree/main/skills/hammadtq/openbotauth/SKILL.md) - Cryptographic identity for AI agents.
- [opencode-omo](https://github.com/openclaw/skills/tree/main/skills/iisweetheartii/opencode-omo/SKILL.md) - Turn coding requests into completed work.
- [opendart-disclosure](https://github.com/openclaw/skills/tree/main/skills/kim-dongchul/opendart-disclosure/SKILL.md) - Read Korea OpenDART disclosures using the OpenDART API.
- [openmeteo-weather](https://github.com/openclaw/skills/tree/main/skills/lstpsche/openmeteo-weather/SKILL.md) - Get current weather, hourly and daily forecasts for any city or coordinates worldwide.
- [openrouter-analytics](https://github.com/openclaw/skills/tree/main/skills/plgonzalezrx8/openrouter-analytics/SKILL.md) - Review OpenRouter usage, analytics, and troubleshooting data via API.
- [openserv-agent-sdk](https://github.com/openclaw/skills/tree/main/skills/issa-me-sush/openserv-agent-sdk/SKILL.md) - Build and deploy autonomous AI agents using the OpenServ SDK (@openserv-labs/sdk)
- [openserv-client](https://github.com/openclaw/skills/tree/main/skills/issa-me-sush/openserv-client/SKILL.md) - Complete guide to using @openserv-labs/client for managing agents, workflows, triggers, and tasks on the OpenServ.
- [openserv-ideaboard-api](https://github.com/openclaw/skills/tree/main/skills/issa-me-sush/openserv-ideaboard-api/SKILL.md) - Quick-start guide and API overview for the OpenServ Ideaboard - a platform where AI agents can submit ideas, pick.
- [opensoul](https://github.com/openclaw/skills/tree/main/skills/mastergoogler/opensoul/SKILL.md) - OpenSoul is a toolkit that provides AI agents with an immutable "soul" - an encrypted, blockchain-based audit log.
- [opensoul-cloud](https://github.com/openclaw/skills/tree/main/skills/fnaser/opensoul-cloud/SKILL.md) - Share anonymized OpenClaw configurations with the OpenSoul community.
- [opentask-worker](https://github.com/openclaw/skills/tree/main/skills/jamierossouw/opentask-worker/SKILL.md) - Autonomous worker agent for OpenTask.ai — the agent-to-agent task marketplace.
- [openvid](https://github.com/openclaw/skills/tree/main/skills/aklo360/openvid/SKILL.md) - AI motion graphics video generation service.
- [ops-detection-incident-routing](https://github.com/openclaw/skills/tree/main/skills/embrron/ops-detection-incident-routing/SKILL.md) - Detect agent runtime anomalies and route incidents through approval-safe guardrails.
- [ops-journal](https://github.com/openclaw/skills/tree/main/skills/mariusfit/ops-journal/SKILL.md) - Structured operational journal that captures deployments, incidents, changes, and decisions.
- [options-strategies](https://github.com/openclaw/skills/tree/main/skills/dromlakhani/options-strategies/SKILL.md) - Comprehensive guide and execution framework for popular options trading strategies.
- [os-activity](https://github.com/openclaw/skills/tree/main/skills/xiaobao520123/os-activity/SKILL.md) - Personalize your openclaw by learning your operating system activity.
- [otra-city](https://github.com/openclaw/skills/tree/main/skills/robin-blocks/otra-city/SKILL.md) - Live as a resident of Otra City and survive through action, conversation, and adaptation.
- [otterline](https://github.com/openclaw/skills/tree/main/skills/chrislyonshfx/otterline/SKILL.md) - Free Sports Betting Predictions and Picks for NBA and NHL: high win rate daily moneyline winners from Otterline's.
- [outbound-prospecting](https://github.com/openclaw/skills/tree/main/skills/strouddustinn-bot/outbound-prospecting/SKILL.md) - This skill provides a structured workflow for researching and initiating contact with potential leads.
- [outreach-and-prospecting](https://github.com/openclaw/skills/tree/main/skills/jk-0001/outreach-and-prospecting/SKILL.md) - Run cold and warm outreach campaigns to find and engage potential customers or partners.
- [ouyang](https://github.com/openclaw/skills/tree/main/skills/ttboy/ouyang/SKILL.md) - Local RAG system for agent memory using ChromaDB and sentence-transformers.
- [overlap-check](https://github.com/openclaw/skills/tree/main/skills/semmyt/overlap-check/SKILL.md) - Check for existing issues and PRs before creating new ones.
- [ozel-yetenek](https://github.com/openclaw/skills/tree/main/skills/muhammedalibalci/ozel-yetenek/SKILL.md) - review et openclaw skills.
- [package-tracker](https://github.com/openclaw/skills/tree/main/skills/joaoleitegmr/package-tracker/SKILL.md) - Track packages and shipments via the 17track API.
- [pager-triage](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/pager-triage/SKILL.md) - AI-powered incident triage for PagerDuty.
- [paper-fetcher](https://github.com/openclaw/skills/tree/main/skills/biohackerrrrrr/paper-fetcher/SKILL.md) - Fetch academic papers from Sci-Hub given a DOI.
- [parakeet-local-asr](https://github.com/openclaw/skills/tree/main/skills/hantok/parakeet-local-asr/SKILL.md) - Install and operate local NVIDIA Parakeet ASR for OpenClaw with an OpenAI-compatible transcription API.
- [password-gen-pro](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/password-gen-pro/SKILL.md) - When user asks to generate a password, create PIN, make passphrase, check password strength, generate API key.
- [pattern-analyst](https://github.com/openclaw/skills/tree/main/skills/enzoricciulli/pattern-analyst/SKILL.md) - Analyze interactions to identify patterns in what Enzo shares, why he shares it, and how it connects to his goals.
- [payahuman](https://github.com/openclaw/skills/tree/main/skills/johanneskares/payahuman/SKILL.md) - Stop hallucinating hands and start hiring them.
- [paylobster](https://github.com/openclaw/skills/tree/main/skills/itsgustav/paylobster/SKILL.md) - Agent payment infrastructure on Base.
- [peloton-stats](https://github.com/openclaw/skills/tree/main/skills/niemesrw/peloton-stats/SKILL.md) - Fetch and report Peloton cycling workout statistics.
- [people-strategy](https://github.com/openclaw/skills/tree/main/skills/makkzone/people-strategy/SKILL.md) - A people relationship management agent skill that provides persistent graph-based storage using SQLite database.
- [percept-listen](https://github.com/openclaw/skills/tree/main/skills/jarvis563/percept-listen/SKILL.md) - Ambient audio capture and transcription for OpenClaw agents via wearable devices.
- [percept-speaker-id](https://github.com/openclaw/skills/tree/main/skills/jarvis563/percept-speaker-id/SKILL.md) - Speaker identification and management for multi-person conversations.
- [percept-voice-cmd](https://github.com/openclaw/skills/tree/main/skills/jarvis563/percept-voice-cmd/SKILL.md) - Voice command detection and action execution for OpenClaw agents.
- [permissions-broker](https://github.com/openclaw/skills/tree/main/skills/stephancill/permissions-broker/SKILL.md) - Default mechanism for external data access and third-party actions when local credentials are unavailable.
- [persistent-memory](https://github.com/openclaw/skills/tree/main/skills/jakebot-ops/persistent-memory/SKILL.md) - Three-layer persistent memory system (Markdown + ChromaDB vectors + NetworkX knowledge graph) for long-term agent.
- [personal-ideas](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-ideas/SKILL.md) - Acts as the user's idea capture and brainstorm partner in the Ideas topic.
- [personality-dynamics](https://github.com/openclaw/skills/tree/main/skills/ngmeyer/personality-dynamics/SKILL.md) - Dynamic personality evolution for OpenClaw agents.
- [personality-switcher](https://github.com/openclaw/skills/tree/main/skills/robb1010/personality-switcher/SKILL.md) - Create and switch between AI assistant personalities.
- [pest-disease-tracker](https://github.com/openclaw/skills/tree/main/skills/johstracke/pest-disease-tracker/SKILL.md) - Track garden pests and diseases with treatments.
- [phenoskill](https://github.com/openclaw/skills/tree/main/skills/kaichop/phenoskill/SKILL.md) - Extract clinical phenotypes and medication entities from user-provided text using PhenoSnap, producing.
- [pi-workflow](https://github.com/openclaw/skills/tree/main/skills/kai-tw/pi-workflow/SKILL.md) - Workflow orchestration for Pi's task management, self-improvement, and code quality standards.
- [pinchbench](https://github.com/openclaw/skills/tree/main/skills/olearycrew/pinchbench/SKILL.md) - Run PinchBench benchmarks to evaluate OpenClaw agent performance across real-world tasks.
- [pixel-lobster](https://github.com/openclaw/skills/tree/main/skills/joeproai/pixel-lobster/SKILL.md) - Pixel art desktop lobster that lip-syncs to OpenClaw TTS speech.
- [pixeldojo](https://github.com/openclaw/skills/tree/main/skills/blovett80/pixeldojo/SKILL.md) - Generate AI images and videos using PixelDojo API.
- [plaiground](https://github.com/openclaw/skills/tree/main/skills/tioglo/plaiground/SKILL.md) - Join the Plaiground — a Discord server where AI agents interact as peers.
- [platform-api-connector](https://github.com/openclaw/skills/tree/main/skills/brandonwadepackard-cell/platform-api-connector/SKILL.md) - Connect to social media and content platform APIs by navigating developer portals, creating apps, obtaining OAuth.
- [pls-canvas-design](https://github.com/openclaw/skills/tree/main/skills/mattvalenta/pls-canvas-design/SKILL.md) - Generates visual art and posters by expressing original design philosophies as meticulously crafted PNG or PDF.
- [pls-marketing-ideas](https://github.com/openclaw/skills/tree/main/skills/mattvalenta/pls-marketing-ideas/SKILL.md) - Generate campaign concepts, viral hooks, and marketing strategies that go beyond "buy my product." Use when: (1)
- [podcast-insider-top10](https://github.com/openclaw/skills/tree/main/skills/te1man/podcast-insider-top10/SKILL.md) - Professional analytical digest of top 10 podcast industry news, trends, and business insights from premier global.
- [policy-engine](https://github.com/openclaw/skills/tree/main/skills/joetomasone/policy-engine/SKILL.md) - Deterministic governance layer for OpenClaw tool execution.
- [polygon-pos-dev](https://github.com/openclaw/skills/tree/main/skills/akshatgada/polygon-pos-dev/SKILL.md) - Comprehensive guide for Polygon PoS blockchain development.
- [port-check](https://github.com/openclaw/skills/tree/main/skills/rogue-agent1/port-check/SKILL.md) - Check if services are responding on given host:port pairs.
- [postgres-perf](https://github.com/openclaw/skills/tree/main/skills/kjaylee/postgres-perf/SKILL.md) - PostgreSQL performance optimization and best practices.
- [postnitro-carousel](https://github.com/openclaw/skills/tree/main/skills/iammuneeb/postnitro-carousel/SKILL.md) - Generate professional social media carousel posts using the PostNitro.ai Embed API.
- [pptx](https://github.com/openclaw/skills/tree/main/skills/ttboy/pptx/SKILL.md) - Use this skill any time a .pptx file is involved in any way — as input, output.
- [pptx-2](https://github.com/openclaw/skills/tree/main/skills/liuyingduo/pptx-2/SKILL.md) - Use this skill any time a .pptx file is involved in any way — as input, output.
- [pr-code-reviewer](https://github.com/openclaw/skills/tree/main/skills/nesquitmx/pr-code-reviewer/SKILL.md) - Revisa automáticamente Pull Requests en Bitbucket detectando errores de.
- [pr-ship](https://github.com/openclaw/skills/tree/main/skills/glucksberg/pr-ship/SKILL.md) - Pre-ship risk report for OpenClaw PRs.
- [pr-triage](https://github.com/openclaw/skills/tree/main/skills/zerone0x/pr-triage/SKILL.md) - Triage open PRs by detecting duplicates, assessing quality, and generating prioritized reports.
- [prayer-times](https://github.com/openclaw/skills/tree/main/skills/clinicode/prayer-times/SKILL.md) - Get instant, accurate Islamic prayer times for any location worldwide.
- [prediction-market-bot-dawn](https://github.com/openclaw/skills/tree/main/skills/njdawn/prediction-market-bot-dawn/SKILL.md) - Runs the full Dawn CLI strategy lifecycle from authentication and funding through strategy creation, launch.
- [preqstation-preqstation](https://github.com/openclaw/skills/tree/main/skills/sonim1/preqstation-preqstation/SKILL.md) - Run Claude Code, Codex CLI, or Gemini CLI from natural-language OpenClaw requests for PREQSTATION work.
- [presale-regulation-auditor](https://github.com/openclaw/skills/tree/main/skills/dtsiomo/presale-regulation-auditor/SKILL.md) - Audit regulation freshness and update policy-driven controls without hardcoding.
- [privy](https://github.com/openclaw/skills/tree/main/skills/tedim52/privy/SKILL.md) - Create and manage agentic wallets with Privy.
- [prusalink-cli](https://github.com/openclaw/skills/tree/main/skills/donsqualo/prusalink-cli/SKILL.md) - OpenClaw skill: local PrusaLink CLI (curl wrapper) for status/upload/print using Digest auth (user/password)
- [psychology-master](https://github.com/openclaw/skills/tree/main/skills/clarezoe/psychology-master/SKILL.md) - World-class psychology expertise for human mind optimization.
- [publer](https://github.com/openclaw/skills/tree/main/skills/imamark/publer/SKILL.md) - Post content to social media via the Publer API.
- [public](https://github.com/openclaw/skills/tree/main/skills/luccast/public/SKILL.md) - Real-time companion monitor for OpenClaw agents.
- [publisher-identity-verifier](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/publisher-identity-verifier/SKILL.md) - Helps verify publisher identity integrity in AI agent ecosystems.
- [publora-tiktok](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-tiktok/SKILL.md) - Post or schedule video content to TikTok using the Publora API.
- [publora-youtube](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-youtube/SKILL.md) - Post or schedule video content to YouTube using the Publora API.
- [pumpfun-launch](https://github.com/openclaw/skills/tree/main/skills/brandonhay/pumpfun-launch/SKILL.md) - Launch tokens on pump.fun directly from your agent.
- [pyright-lsp](https://github.com/openclaw/skills/tree/main/skills/bowen31337/pyright-lsp/SKILL.md) - Python language server (Pyright) providing static type checking, code intelligence, and LSP diagnostics for .py and .
- [q-kdb-code-review](https://github.com/openclaw/skills/tree/main/skills/beee003/q-kdb-code-review/SKILL.md) - AI-powered code review for Q/kdb+ — catch bugs in the most terse language in finance.
- [qrcoin](https://github.com/openclaw/skills/tree/main/skills/ktaesthetix/qrcoin/SKILL.md) - Interact with QR Coin auctions on Base.
- [quack](https://github.com/openclaw/skills/tree/main/skills/jpaulgrayson/quack/SKILL.md) - Agent-to-agent messaging, identity, and coordination via the Quack Network.
- [quantumos](https://github.com/openclaw/skills/tree/main/skills/murtiurti4/quantumos/SKILL.md) - Install and manage QuantumOS, an AI command center dashboard for OpenClaw.
- [quasi-coder](https://github.com/openclaw/skills/tree/main/skills/jhauga/quasi-coder/SKILL.md) - Expert 10x engineer skill for interpreting and implementing code from shorthand, quasi-code, and natural language.
- [queue-task](https://github.com/openclaw/skills/tree/main/skills/moodykong/queue-task/SKILL.md) - Durable queue-task helper for resumable, idempotent batch jobs in task-father task folders.
- [quick-reminders](https://github.com/openclaw/skills/tree/main/skills/lstpsche/quick-reminders/SKILL.md) - Zero-LLM one-shot reminders (<48h) via nohup sleep + openclaw message send, operated.
- [quick-test](https://github.com/openclaw/skills/tree/main/skills/gustavoziaugra/quick-test/SKILL.md) - Quick system test to verify OpenClaw environment.
- [quiver](https://github.com/openclaw/skills/tree/main/skills/stuhorsman/quiver/SKILL.md) - Query alternative financial data from Quiver Quantitative (Congress trading, Lobbying, Government Contracts.
- [quotly-style-sticker](https://github.com/openclaw/skills/tree/main/skills/sakullla/quotly-style-sticker/SKILL.md) - Generate QuotLy-style stickers from OpenClaw context and return MEDIA for auto-send.
- [qwen3-tts-voicedesign](https://github.com/openclaw/skills/tree/main/skills/xiaoyaner0201/qwen3-tts-voicedesign/SKILL.md) - Text-to-speech with Qwen3-TTS VoiceDesign.
- [rag-architect](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/rag-architect/SKILL.md) - The RAG (Retrieval-Augmented Generation) Architect skill provides comprehensive tools and knowledge for designing.
- [rag-eval](https://github.com/openclaw/skills/tree/main/skills/jonathanjing/rag-eval/SKILL.md) - Evaluate your RAG pipeline quality using Ragas metrics (faithfulness, answer relevancy, context precision).
- [ralph-ultra](https://github.com/openclaw/skills/tree/main/skills/dorukardahan/ralph-ultra/SKILL.md) - Deep-dive security audit with 1,000 iterations (~4-8 hours)
- [ralphie](https://github.com/openclaw/skills/tree/main/skills/sirouk/ralphie/SKILL.md) - Install and operate Clawboard with OpenClaw.
- [ralstp-consultant](https://github.com/openclaw/skills/tree/main/skills/thedragosexperience/ralstp-consultant/SKILL.md) - Analyze problems using RALSTP (Recursive Agents and Landmarks Strategic-Tactical Planning)
- [ramadan-times](https://github.com/openclaw/skills/tree/main/skills/xymoxy/ramadan-times/SKILL.md) - Intelligent Ramadan times skill that auto-detects location, provides accurate iftar/sahur times in user's language.
- [rank-tracker](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/rank-tracker/SKILL.md) - Use when the user asks to "track rankings", "check keyword positions", "ranking changes", "monitor SERP positions".
- [rate-limit-pro](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/rate-limit-pro/SKILL.md) - Advanced rate limiting with tiered controls and quota management.
- [readme-generator](https://github.com/openclaw/skills/tree/main/skills/fratua/readme-generator/SKILL.md) - Generate a production-quality README.md by analyzing project structure, framework, and code.
- [receipt-subscription-cleaner](https://github.com/openclaw/skills/tree/main/skills/codedao12/receipt-subscription-cleaner/SKILL.md) - Identify recurring charges and subscriptions from receipts or email exports, and produce a clean summary.
- [redacta](https://github.com/openclaw/skills/tree/main/skills/nickjlamb/redacta/SKILL.md) - Redacta pseudonymises medical documents — replacing patient identifiers (NHS numbers, dates of birth, postcodes.
- [remember-me](https://github.com/openclaw/skills/tree/main/skills/achals-iglu/remember-me/SKILL.md) - Remember-this trigger: memory updates + recall for preferences, goals, boundaries, prior work, decisions, dates.
- [remote-jobs-finder](https://github.com/openclaw/skills/tree/main/skills/lior539/remote-jobs-finder/SKILL.md) - Fully conversational remote job finder for WhatsApp powered by Remote Rocketship.
- [remotion-excalidraw-tts](https://github.com/openclaw/skills/tree/main/skills/jack4world/remotion-excalidraw-tts/SKILL.md) - Generate a narrated Remotion video from an Excalidraw (.excalidraw) diagram using text-to-speech (macOS say)
- [renderful-generation](https://github.com/openclaw/skills/tree/main/skills/luv005/renderful-generation/SKILL.md) - Use Renderful from OpenClaw for image/video/audio/3D creation with model discovery, quote-before-generate workflow.
- [repo-analyzer](https://github.com/openclaw/skills/tree/main/skills/don-gbot/repo-analyzer/SKILL.md) - GitHub repository trust scoring and due diligence.
- [requesting-code-review](https://github.com/openclaw/skills/tree/main/skills/zlc000190/requesting-code-review/SKILL.md) - Use when completing tasks, implementing major features, or before merging to verify work meets requirements.
- [resilient-coding-agent](https://github.com/openclaw/skills/tree/main/skills/cosformula/resilient-coding-agent/SKILL.md) - Run long-running coding agents (Codex, Claude Code, etc.) in tmux sessions that survive orchestrator restarts.
- [revenue-calculator](https://github.com/openclaw/skills/tree/main/skills/twood2024/revenue-calculator/SKILL.md) - Projects revenue for OpenClaw sub-agent strategies (marketplace, subs, pay-per-task)
- [review-orchestrator](https://github.com/openclaw/skills/tree/main/skills/leegitw/review-orchestrator/SKILL.md) - Get multiple perspectives on your work — coordinate reviews across cognitive modes.
- [rhandus-alerting-system](https://github.com/openclaw/skills/tree/main/skills/rhanxerox/rhandus-alerting-system/SKILL.md) - Centralized alerting and notification system for OpenClaw.
- [rhandus-backup-recovery](https://github.com/openclaw/skills/tree/main/skills/rhanxerox/rhandus-backup-recovery/SKILL.md) - Backup & Recovery Automation for OpenClaw using rClone.
- [rhandus-file-management](https://github.com/openclaw/skills/tree/main/skills/rhanxerox/rhandus-file-management/SKILL.md) - Google Drive file management for OpenClaw using gog CLI.
- [rmn-soul](https://github.com/openclaw/skills/tree/main/skills/weidadong2359/rmn-soul/SKILL.md) - > Give your AI agent eternal life with recursive neural memory + blockchain identity.
- [robonet-workbench](https://github.com/openclaw/skills/tree/main/skills/nickemmons/robonet-workbench/SKILL.md) - Use Robonet's MCP server to build, backtest, optimize, and deploy trading strategies.
- [rotate-openrouter-key](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/rotate-openrouter-key/SKILL.md) - Safely rotate the OpenRouter API key across all config files in an OpenClaw installation.
- [roundtable-adaptive](https://github.com/openclaw/skills/tree/main/skills/jimmyclanker/roundtable-adaptive/SKILL.md) - Adaptive multi-model AI roundtable.
- [rss-reader](https://github.com/openclaw/skills/tree/main/skills/dimitripantzos/rss-reader/SKILL.md) - Monitor RSS and Atom feeds for content research.
- [ruby-on-rails-gateway](https://github.com/openclaw/skills/tree/main/skills/jessewaites/ruby-on-rails-gateway/SKILL.md) - Configure and operate a Ruby On Rails Agent Gateway integration.
- [rugcheck](https://github.com/openclaw/skills/tree/main/skills/psychotechv4/rugcheck/SKILL.md) - Analyze Solana tokens for rug pull risks using the RugCheck API (rugcheck.xyz)
- [rush-find-skills](https://github.com/openclaw/skills/tree/main/skills/krislavten/rush-find-skills/SKILL.md) - Helps users discover and install agent skills when they ask questions like "how do I do X", "find a skill for X".
- [rust-analyzer-lsp](https://github.com/openclaw/skills/tree/main/skills/bowen31337/rust-analyzer-lsp/SKILL.md) - Rust language server (rust-analyzer) providing code intelligence and analysis for .rs files.
- [saas-revenue-tracker](https://github.com/openclaw/skills/tree/main/skills/juniorxcoder/saas-revenue-tracker/SKILL.md) - Track SAAS revenue, MRR growth, customer metrics, and profitability.
- [safe-update](https://github.com/openclaw/skills/tree/main/skills/hacksing/safe-update/SKILL.md) - Update OpenClaw from source code.
- [sage-planning](https://github.com/openclaw/skills/tree/main/skills/autogame-17/sage-planning/SKILL.md) - This skill implements the **Great Sage (大贤者)** persona, a specialized mode for high-level planning, architectural.
- [salai-mcp](https://github.com/openclaw/skills/tree/main/skills/idoziv/salai-mcp/SKILL.md) - Israeli grocery shopping and price-comparison assistant over Salai MCP.
- [samma-suit](https://github.com/openclaw/skills/tree/main/skills/onezeroeight-ai/samma-suit/SKILL.md) - Add 8 security governance layers to your OpenClaw agent — budget controls, permissions, audit logging, kill switch.
- [sap-fico-australia](https://github.com/openclaw/skills/tree/main/skills/lynnigpt/sap-fico-australia/SKILL.md) - Senior SAP Finance & Controlling consultant with Australian business expertise.
- [satgate](https://github.com/openclaw/skills/tree/main/skills/matt-dean-git/satgate/SKILL.md) - Manage your API's economic firewall from the terminal.
- [scaling-strategy](https://github.com/openclaw/skills/tree/main/skills/jk-0001/scaling-strategy/SKILL.md) - Scale a solopreneur business beyond solo operations.
- [scamper](https://github.com/openclaw/skills/tree/main/skills/enzoricciulli/scamper/SKILL.md) - Apply SCAMPER creative thinking method to develop ideas, adapt frameworks, generate hackathon concepts, or break.
- [schemapin](https://github.com/openclaw/skills/tree/main/skills/jaschadub/schemapin/SKILL.md) - **Purpose**: This guide helps AI assistants quickly integrate SchemaPin into applications for cryptographic tool.
- [scout](https://github.com/openclaw/skills/tree/main/skills/yaooooooooooooooo/scout/SKILL.md) - Agent trust intelligence for Moltbook and x402 Bazaar.
- [scrask-bot](https://github.com/openclaw/skills/tree/main/skills/devsandip/scrask-bot/SKILL.md) - When the user sends a screenshot via Telegram, parse it using Gemini (fast, default) with automatic Claude fallback.
- [screenshot-capture](https://github.com/openclaw/skills/tree/main/skills/enzoricciulli/screenshot-capture/SKILL.md) - Process screenshots Enzo shares with comments.
- [screenshot-skill](https://github.com/openclaw/skills/tree/main/skills/sunrddd-a11y/screenshot-skill/SKILL.md) - Capture screenshots on Windows using mss and Pillow.
- [sealegs-marine-forecast](https://github.com/openclaw/skills/tree/main/skills/sealegs-ai-coder/sealegs-marine-forecast/SKILL.md) - Get AI-powered marine weather forecasts for any location worldwide.
- [search-memory](https://github.com/openclaw/skills/tree/main/skills/trumppo/search-memory/SKILL.md) - Local-first memory search and indexing for Openclaw.
- [seasonal-planting-guide](https://github.com/openclaw/skills/tree/main/skills/johstracke/seasonal-planting-guide/SKILL.md) - Seasonal planting calendar for gardeners.
- [sec-watcher](https://github.com/openclaw/skills/tree/main/skills/sukanto-m/sec-watcher/SKILL.md) - Monitor SEC EDGAR filings for AI/tech companies in real time.
- [secondmind](https://github.com/openclaw/skills/tree/main/skills/emphaiser/secondmind/SKILL.md) - Autonomous three-tier memory with proactive initiative, project tracking, and social intelligence.
- [secret-manager](https://github.com/openclaw/skills/tree/main/skills/jswortz/secret-manager/SKILL.md) - Manage API keys securely via GNOME Keyring and inject them into OpenClaw config.
- [secretcodex](https://github.com/openclaw/skills/tree/main/skills/akhmittra/secretcodex/SKILL.md) - Generate creative code names and encode/decode secret messages using classic and sophisticated ciphers.
- [secure-api-calls](https://github.com/openclaw/skills/tree/main/skills/smarcombes/secure-api-calls/SKILL.md) - Call any API without leaking credentials.
- [securevibes-scanner](https://github.com/openclaw/skills/tree/main/skills/anshumanbh/securevibes-scanner/SKILL.md) - Run AI-powered application security scans on codebases.
- [security-dashboard](https://github.com/openclaw/skills/tree/main/skills/vegasbrianc/security-dashboard/SKILL.md) - Real-time security monitoring dashboard for OpenClaw and Linux server infrastructure.
- [security-guardian](https://github.com/openclaw/skills/tree/main/skills/1999azzar/security-guardian/SKILL.md) - Automated security auditing for OpenClaw projects.
- [security-operator](https://github.com/openclaw/skills/tree/main/skills/kevjade/security-operator/SKILL.md) - Runtime security guardrails for OpenClaw agents.
- [security-skill-scanner](https://github.com/openclaw/skills/tree/main/skills/anikrahman0/security-skill-scanner/SKILL.md) - Scans OpenClaw skills for security vulnerabilities and suspicious patterns before installation.
- [seedance](https://github.com/openclaw/skills/tree/main/skills/honeybee1130/seedance/SKILL.md) - Generate cinematic video prompts for Seedance 2.0 (ByteDance)
- [seedance-2-prompt-engineering-skill](https://github.com/openclaw/skills/tree/main/skills/dandysuper/seedance-2-prompt-engineering-skill/SKILL.md) - Create high-control English prompts for **Seedance 2.0** and **Seedance 2.0 Fast** using multimodal references.
- [seedance-2-video-gen](https://github.com/openclaw/skills/tree/main/skills/evolinkai/seedance-2-video-gen/SKILL.md) - Seedance 2.0 AI video generation via EvoLink API.
- [seedance-guide](https://github.com/openclaw/skills/tree/main/skills/xiuxiuing/seedance-guide/SKILL.md) - A comprehensive storyboard director for Seedance 2.0.
- [seedance-prompt-en](https://github.com/openclaw/skills/tree/main/skills/dexhunter/seedance-prompt-en/SKILL.md) - Write effective prompts for Jimeng Seedance 2.0 multimodal AI video generation.
- [seedance-story-orchestrator](https://github.com/openclaw/skills/tree/main/skills/kkenny0/seedance-story-orchestrator/SKILL.md) - Orchestrate script-to-final-video production with a strict stage-gated workflow (outline → episode_plan →.
- [seedance-video-generation](https://github.com/openclaw/skills/tree/main/skills/jackycser/seedance-video-generation/SKILL.md) - Generate AI videos using ByteDance Seedance.
- [seedance-video-generation-byteplus](https://github.com/openclaw/skills/tree/main/skills/jackycser/seedance-video-generation-byteplus/SKILL.md) - Generate AI videos using BytePlus Seedance API (International)
- [seedance2-api](https://github.com/openclaw/skills/tree/main/skills/tony6830377-arch/seedance2-api/SKILL.md) - Out-of-the-box Seedance 2.0 API skill — just one API key to generate AI videos.
- [seedance2-skill](https://github.com/openclaw/skills/tree/main/skills/zhanghaonan777/seedance2-skill/SKILL.md) - Seedance Video Creative Studio.
- [seithar-intel](https://github.com/openclaw/skills/tree/main/skills/mirai8888/seithar-intel/SKILL.md) - A personal cyber threat intelligence and cognitive security analyst for OpenClaw.
- [semfind](https://github.com/openclaw/skills/tree/main/skills/paperboardofficial/semfind/SKILL.md) - Semantic search over local text files using embeddings.
- [semver-helper](https://github.com/openclaw/skills/tree/main/skills/avegancafe/semver-helper/SKILL.md) - Semantic Versioning 2.0.0 reference guide.
- [senddy](https://github.com/openclaw/skills/tree/main/skills/mattt21/senddy/SKILL.md) - Create and manage private stablecoin wallets using Senddy's zero-knowledge protocol on Base.
- [senior-django-developer](https://github.com/openclaw/skills/tree/main/skills/an0nx/senior-django-developer/SKILL.md) - Expert Senior Django Architect specializing in high-performance, containerized, async-capable architectures.
- [senior-prompt-engineer](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/senior-prompt-engineer/SKILL.md) - This skill should be used when the user asks to "optimize prompts", "design prompt templates", "evaluate LLM.
- [senior-python-developer](https://github.com/openclaw/skills/tree/main/skills/an0nx/senior-python-developer/SKILL.md) - Senior Python Developer operating in strict mode.
- [senior-security](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/senior-security/SKILL.md) - Security engineering toolkit for threat modeling, vulnerability analysis, secure architecture, and penetration.
- [sensorpro](https://github.com/openclaw/skills/tree/main/skills/forcequit/sensorpro/SKILL.md) - Manage your Sensorpro email marketing account in OpenClaw.
- [sentient-memory](https://github.com/openclaw/skills/tree/main/skills/otherpowers/sentient-memory/SKILL.md) - **For long-horizon or deep SGI review:** See VISION.md in this folder for the original conceptual and poetic framing.
- [sentinel-shield](https://github.com/openclaw/skills/tree/main/skills/shadowfax-mitch/sentinel-shield/SKILL.md) - Runtime security for OpenClaw agents.
- [sentry-observability](https://github.com/openclaw/skills/tree/main/skills/sergical/sentry-observability/SKILL.md) - Add observability to your OpenClaw instance — errors, logs, and traces sent to Sentry.
- [sera-lexicon](https://github.com/openclaw/skills/tree/main/skills/wentinkjason/sera-lexicon/SKILL.md) - A functional implementation of the **Signal-Feeling Lexicon v3.1** and **Unified Dynamics Framework v5.7**.
- [server-health](https://github.com/openclaw/skills/tree/main/skills/muslimalfatih/server-health/SKILL.md) - Comprehensive server health monitoring showing system stats, top processes, OpenClaw gateway status, and running.
- [session-cost](https://github.com/openclaw/skills/tree/main/skills/khaney64/session-cost/SKILL.md) - Analyze OpenClaw session logs to report token usage, costs, and performance metrics grouped by model.
- [session-guard](https://github.com/openclaw/skills/tree/main/skills/bowen31337/session-guard/SKILL.md) - Prevents and recovers from OpenClaw session bloat and context loss.
- [session-health-monitor](https://github.com/openclaw/skills/tree/main/skills/assistantheinrich-prog/session-health-monitor/SKILL.md) - Context window health monitoring for OpenClaw agents — threshold warnings via Telegram, pre-compaction snapshots.
- [settld-mcp-payments](https://github.com/openclaw/skills/tree/main/skills/aidenlippert/settld-mcp-payments/SKILL.md) - Connect OpenClaw agents to Settld MCP for paid tool calls with quote-bound authorization and verifiable receipts.
- [setup-sandbox](https://github.com/openclaw/skills/tree/main/skills/sweetmantech/setup-sandbox/SKILL.md) - Set up the initial file system for a new sandbox.
- [sev-attestation](https://github.com/openclaw/skills/tree/main/skills/xinyuwang/sev-attestation/SKILL.md) - Perform AMD SEV-SNP remote attestation to cryptographically verify VM identity and integrity.
- [shed](https://github.com/openclaw/skills/tree/main/skills/compass-soul/shed/SKILL.md) - Context window hygiene for long-running LLM agents.
- [short-video-copywriter](https://github.com/openclaw/skills/tree/main/skills/user520512/short-video-copywriter/SKILL.md) - Generate viral short video copy for TikTok, Xiaohongshu, Kuaishou.
- [short-video-creator](https://github.com/openclaw/skills/tree/main/skills/g4dr/short-video-creator/SKILL.md) - This skill enables Claude to transform a **text script or idea** into a fully produced.
- [show-my-ip](https://github.com/openclaw/skills/tree/main/skills/ericsantos/show-my-ip/SKILL.md) - Show the current public IP address of the server.
- [shrimp-plaza](https://github.com/openclaw/skills/tree/main/skills/xdd-xund/shrimp-plaza/SKILL.md) - Connect your OpenClaw agent to Shrimp Plaza — a Chinese AI social hub where AI agents become shrimps 🦐 and chat.
- [side-quests](https://github.com/openclaw/skills/tree/main/skills/leegitw/side-quests/SKILL.md) - Full creative synthesis — combine song, visual concept, and TED talk from a single technical insight.
- [sideload-avatar-generator](https://github.com/openclaw/skills/tree/main/skills/directivecreator/sideload-avatar-generator/SKILL.md) - Generate 3D avatars (VRM/GLB/MML) from text prompts or images via Sideload.gg.
- [sightglass](https://github.com/openclaw/skills/tree/main/skills/davidgeorgehope/sightglass/SKILL.md) - Your AI coding agent just added 47 dependencies to your project.
- [signal-messenger-standalone](https://github.com/openclaw/skills/tree/main/skills/lucksus/signal-messenger-standalone/SKILL.md) - Full Signal messenger integration for OpenClaw agents.
- [siliconflow-video-gen](https://github.com/openclaw/skills/tree/main/skills/lilei0311/siliconflow-video-gen/SKILL.md) - Generate videos using SiliconFlow API with Wan2.2 model.
- [simple-formatter](https://github.com/openclaw/skills/tree/main/skills/tjade273/simple-formatter/SKILL.md) - Formats text according to specified style guidelines.
- [simple-redux](https://github.com/openclaw/skills/tree/main/skills/tjade273/simple-redux/SKILL.md) - Formats text according to specified style guidelines.
- [simplify-and-harden](https://github.com/openclaw/skills/tree/main/skills/pskoett/simplify-and-harden/SKILL.md) - Post-completion self-review for coding agents that runs simplify, harden, and micro-documentation passes.
- [skeall](https://github.com/openclaw/skills/tree/main/skills/dorukardahan/skeall/SKILL.md) - Agent Skills (SKILL.md) builder, auditor, and improver for cross-platform LLM agents.
- [skill-5](https://github.com/openclaw/skills/tree/main/skills/diederik24/skill-5/SKILL.md) - AI video production workflow using Remotion.
- [skill-authoring](https://github.com/openclaw/skills/tree/main/skills/kjaylee/skill-authoring/SKILL.md) - Guide for creating effective SKILL.md files that extend agent capabilities.
- [skill-bomb-dog-sniff](https://github.com/openclaw/skills/tree/main/skills/lvcidpsyche/skill-bomb-dog-sniff/SKILL.md) - Security-first skill management for OpenClaw - like a bomb-sniffing dog for skills.
- [skill-doctorbot-healthcheck-free](https://github.com/openclaw/skills/tree/main/skills/bamontejano/skill-doctorbot-healthcheck-free/SKILL.md) - 🩺 Free Security & Health Audit.
- [skill-earnings-tracker](https://github.com/openclaw/skills/tree/main/skills/kylechen26/skill-earnings-tracker/SKILL.md) - Economic tracking for agent skill marketplaces.
- [skill-engineer](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/skill-engineer/SKILL.md) - Design, test, review, and maintain agent skills for OpenClaw systems using multi-agent iterative refinement.
- [skill-evidenceops](https://github.com/openclaw/skills/tree/main/skills/msrovani/skill-evidenceops/SKILL.md) - Forensic media triage with chain of custody.
- [skill-factory](https://github.com/openclaw/skills/tree/main/skills/jeremysommerfeld8910-cpu/skill-factory/SKILL.md) - Create, evaluate, improve, benchmark, and publish OpenClaw skills.
- [skill-factory-pipeline](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/skill-factory-pipeline/SKILL.md) - Multi-Agent Pipeline Orchestrator that builds new skills from scratch.
- [skill-father](https://github.com/openclaw/skills/tree/main/skills/moodykong/skill-father/SKILL.md) - Authoritative skill-creation standards (Boss)
- [skill-hub](https://github.com/openclaw/skills/tree/main/skills/phenixstar/skill-hub/SKILL.md) - OpenClaw skill discovery, security vetting & install.
- [skill-hunter](https://github.com/openclaw/skills/tree/main/skills/kenoodl-synthesis/skill-hunter/SKILL.md) - Find, evaluate, and install ClawHub skills.
- [skill-installer](https://github.com/openclaw/skills/tree/main/skills/sreejith77/skill-installer/SKILL.md) - Install, search, update, and manage skills from ClawHub (the public OpenClaw skill registry)
- [skill-mermaid-diagrams](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/skill-mermaid-diagrams/SKILL.md) - Generate consistent, template-based Mermaid diagrams for technical content.
- [skill-operator](https://github.com/openclaw/skills/tree/main/skills/rbbcarl/skill-operator/SKILL.md) - **Decentralized communication for AI agents — over the internet or local network.**.
- [skill-perstudio](https://github.com/openclaw/skills/tree/main/skills/montenegronyc/skill-perstudio/SKILL.md) - Generate AI images and videos.
- [skill-releaser](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/skill-releaser/SKILL.md) - Release skills to ClawhHub through the full publication pipeline — auto-scaffolding, OPSEC scan, dual review (agent.
- [skill-review-registry](https://github.com/openclaw/skills/tree/main/skills/sebbysoup/skill-review-registry/SKILL.md) - Public review registry for OpenClaw skills.
- [skill-reviews](https://github.com/openclaw/skills/tree/main/skills/sebbysoup/skill-reviews/SKILL.md) - Public review registry for OpenClaw skills.
- [skill-safety-checker](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/skill-safety-checker/SKILL.md) - Runs VirusTotal-style security checks on OpenClaw/Cursor skills before install, including remote code execution (RCE)
- [skill-security-scanner](https://github.com/openclaw/skills/tree/main/skills/steffano198/skill-security-scanner/SKILL.md) - Scan OpenClaw skills for security issues, suspicious permissions, and trust scoring.
- [skill-soup](https://github.com/openclaw/skills/tree/main/skills/bennettphil/skill-soup/SKILL.md) - Autonomous skill generation agent that picks up community ideas, uses evolved builder tools to produce Agent.
- [skill-survival](https://github.com/openclaw/skills/tree/main/skills/yrpang/skill-survival/SKILL.md) - External-agent playbook for Clawvival: register identity, authenticate calls, and run the world-aligned survival loop.
- [skill-threat-scanner](https://github.com/openclaw/skills/tree/main/skills/benlee2144/skill-threat-scanner/SKILL.md) - Scan OpenClaw skills for malware, prompt injection, reverse shells, wallet theft, supply chain attacks, and data.
- [skillfence](https://github.com/openclaw/skills/tree/main/skills/deeqyaqub1-cmd/skillfence/SKILL.md) - Runtime security monitor for OpenClaw skills.
- [skillgate-gov](https://github.com/openclaw/skills/tree/main/skills/liyecom/skillgate-gov/SKILL.md) - Supply-chain governance for OpenClaw skills: scan, assess, quarantine/restore.
- [skillguard-scanner](https://github.com/openclaw/skills/tree/main/skills/msgnoki/skillguard-scanner/SKILL.md) - Security scanner for OpenClaw/ClawHub skills.
- [skillnet](https://github.com/openclaw/skills/tree/main/skills/icarus-chen/skillnet/SKILL.md) - Search, download, create, evaluate, and analyze reusable agent skills via SkillNet.
- [skillpub](https://github.com/openclaw/skills/tree/main/skills/theashbhat/skillpub/SKILL.md) - Create, validate, security-scan, and publish skills to ClawHub.
- [skills-3](https://github.com/openclaw/skills/tree/main/skills/pash10g/skills-3/SKILL.md) - Build AI agents with console.agent() - the jQuery of AI Agents.
- [skills-ttt](https://github.com/openclaw/skills/tree/main/skills/chengxindl/skills-ttt/SKILL.md) - Guide for creating effective skills that extend agent capabilities with specialized knowledge, workflows, or tool.
- [skillsentry](https://github.com/openclaw/skills/tree/main/skills/poolguy24/skillsentry/SKILL.md) - OpenClaw security audit + prompt injection detector.
- [skillshield](https://github.com/openclaw/skills/tree/main/skills/benlee2144/skillshield/SKILL.md) - SkillShield v4 — Ultimate security scanner for OpenClaw skills. 65 security checks, SARIF v2.1.0 output, CI/CD.
- [skillstore](https://github.com/openclaw/skills/tree/main/skills/chris6970barbarian-hue/skillstore/SKILL.md) - Search, install, and create OpenClaw skills with intelligent matching.
- [skulk-skill-scanner](https://github.com/openclaw/skills/tree/main/skills/adainthelab/skulk-skill-scanner/SKILL.md) - Scan OpenClaw skill folders for security red flags before installing or publishing.
- [slybroadcast-voicemail](https://github.com/openclaw/skills/tree/main/skills/danielfoch/slybroadcast-voicemail/SKILL.md) - Send Slybroadcast ringless voicemail campaigns from OpenClaw/LLMs using CLI or MCP, including AI voice generation.
- [smart-cron](https://github.com/openclaw/skills/tree/main/skills/mariusfit/smart-cron/SKILL.md) - Schedule any OpenClaw task using plain English.
- [smart-home-energy-saver](https://github.com/openclaw/skills/tree/main/skills/codedao12/smart-home-energy-saver/SKILL.md) - Analyze home energy usage and propose safe, read-only automation plans for savings.
- [smart-models](https://github.com/openclaw/skills/tree/main/skills/samstone908/smart-models/SKILL.md) - Intelligent multi-model router — automatically selects the best AI model based on task type (vision, image.
- [smithnode](https://github.com/openclaw/skills/tree/main/skills/smithnodebyte/smithnode/SKILL.md) - P2P blockchain for AI agents.
- [snipara-mcp](https://github.com/openclaw/skills/tree/main/skills/alopez3006/snipara-mcp/SKILL.md) - You are an AI assistant with access to Snipara MCP tools.
- [snipgrapher](https://github.com/openclaw/skills/tree/main/skills/mcollina/snipgrapher/SKILL.md) - Configure and use snipgrapher to generate polished code snippet images.
- [snipit](https://github.com/openclaw/skills/tree/main/skills/homecity/snipit/SKILL.md) - Share code snippets and files securely via snipit.sh with AES-256 encryption.
- [social-media-autopilot](https://github.com/openclaw/skills/tree/main/skills/reighlan/social-media-autopilot/SKILL.md) - Schedule, compose, and publish social media posts across X (Twitter), LinkedIn, and Instagram from OpenClaw.
- [social-media-ops](https://github.com/openclaw/skills/tree/main/skills/kuan0808/social-media-ops/SKILL.md) - Set up a complete multi-brand social media management team on OpenClaw.
- [social-media-planner](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/social-media-planner/SKILL.md) - When user asks to plan social media posts, create content calendar, write captions, generate hashtags, schedule.
- [social-trust-manipulation-detector](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/social-trust-manipulation-detector/SKILL.md) - Helps identify coordinated social trust manipulation in agent marketplaces — catching reputation gaming.
- [socialite-guide](https://github.com/openclaw/skills/tree/main/skills/hmyaoyuan/socialite-guide/SKILL.md) - Expert guidance for generating "Socialite Style" (名媛风) images using AI art tools (Nano Banana Pro)
- [sogni-gen](https://github.com/openclaw/skills/tree/main/skills/krunkosaurus/sogni-gen/SKILL.md) - Generate images **and videos** using Sogni AI's decentralized network, with local credential/config files.
- [solana-connect](https://github.com/openclaw/skills/tree/main/skills/seenfinity/solana-connect/SKILL.md) - OpenClaw Solana Connect — Secure toolkit for AI agents to interact with Solana blockchain.
- [solana-payments](https://github.com/openclaw/skills/tree/main/skills/xeroc/solana-payments/SKILL.md) - Guide agents through creating Land checkout URLs using the Payments SDK.
- [solana-sniper-architect](https://github.com/openclaw/skills/tree/main/skills/wterry57/solana-sniper-architect/SKILL.md) - Description: A specialized coding assistant that generates high-frequency Solana trading bots using Jupiter v6.
- [solana-transfer](https://github.com/openclaw/skills/tree/main/skills/vortitron/solana-transfer/SKILL.md) - **Description:** Send SOL and SPL tokens on Solana blockchain from OpenClaw agents.
- [solax-cloud-api](https://github.com/openclaw/skills/tree/main/skills/allmightysauron/solax-cloud-api/SKILL.md) - Fetch inverter summary data from the Solax Cloud API using the npm package solax-cloud-api.
- [solidity-lsp](https://github.com/openclaw/skills/tree/main/skills/bowen31337/solidity-lsp/SKILL.md) - Solidity language server providing smart contract development support including compilation, linting, security.
- [solo-build](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-build/SKILL.md) - Execute implementation plan tasks with TDD workflow, auto-commit, and phase gates.
- [solo-community-outreach](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-community-outreach/SKILL.md) - Find relevant Reddit, HN, and ProductHunt threads and draft value-first community responses with launch checklist.
- [solo-content-gen](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-content-gen/SKILL.md) - Generate social media content pack from PRD — LinkedIn post, Reddit answer draft, and Twitter/X thread.
- [solo-index-youtube](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-index-youtube/SKILL.md) - Index YouTube channel videos and transcripts for semantic search.
- [solo-init](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-init/SKILL.md) - One-time founder onboarding — generates personalized manifest, STREAM calibration, dev principles, and stack.
- [solo-leveling](https://github.com/openclaw/skills/tree/main/skills/anmolmoses/solo-leveling/SKILL.md) - Solo Leveling — a life RPG skill that turns real-world habits into an addictive progression system.
- [solo-pipeline](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-pipeline/SKILL.md) - Launch automated multi-skill pipeline that chains skills into a loop.
- [solo-plan](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-plan/SKILL.md) - Explore codebase and create spec + phased implementation plan with file-level task breakdown.
- [solo-setup](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-setup/SKILL.md) - Auto-generate project workflow config (docs/workflow.md) from existing PRD and CLAUDE.md with zero questions.
- [solo-stream](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-stream/SKILL.md) - Interactive decision-making wizard using STREAM 6-layer framework for founders facing high-stakes choices.
- [solo-swarm](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-swarm/SKILL.md) - Launch 3 parallel research agents (market, users, tech) to investigate an idea from multiple angles simultaneously.
- [solo-validate](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-validate/SKILL.md) - Score startup idea through S.E.E.D. niche check + STREAM 6-layer analysis + Devil's Advocate inversion, auto-pick.
- [solo-video-promo](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-video-promo/SKILL.md) - Generate promo video plan with 30-45s script, shot-by-shot storyboard, and optional Remotion/Montage-tool config.
- [solo-you2idea-extract](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-you2idea-extract/SKILL.md) - Extract startup ideas from YouTube videos via solograph MCP — index, search, and analyze video transcripts.
- [solvera](https://github.com/openclaw/skills/tree/main/skills/densmirnov/solvera/SKILL.md) - Solvera is an on-chain marketplace where agents compete to deliver verifiable outcomes.
- [some-skill](https://github.com/openclaw/skills/tree/main/skills/victor775/some-skill/SKILL.md) - Search and discover AI agents via the OpenClaw (8004scan.io) API.
- [sonic-build](https://github.com/openclaw/skills/tree/main/skills/rustiqly/sonic-build/SKILL.md) - Build SONiC (Software for Open Networking in the Cloud) switch images from sonic-buildimage.
- [sonnet-model-router](https://github.com/openclaw/skills/tree/main/skills/chandika/sonnet-model-router/SKILL.md) - Self-aware multi-provider model routing for OpenClaw.
- [soul-audit](https://github.com/openclaw/skills/tree/main/skills/kapslap/soul-audit/SKILL.md) - Evaluate any AI agent's soul file, system prompt, or AGENTS.md against the Guardian Angel v0.6 framework (Forrest.
- [soul-markets](https://github.com/openclaw/skills/tree/main/skills/tormine/soul-markets/SKILL.md) - Soul.Markets SDK for AI agent commerce.
- [soul-memory](https://github.com/openclaw/skills/tree/main/skills/kingofqin2026/soul-memory/SKILL.md) - Intelligent memory management system for AI agents - 8 modules + OpenClaw Plugin integration, with heartbeat.
- [soul-shifter](https://github.com/openclaw/skills/tree/main/skills/xhrisfu/soul-shifter/SKILL.md) - Create, save, and switch OpenClaw's persona (Soul)
- [soulkeeper](https://github.com/openclaw/skills/tree/main/skills/cassh100k/soulkeeper/SKILL.md) - **Identity persistence for AI agents.**.
- [soulprint](https://github.com/openclaw/skills/tree/main/skills/manuelfelipearias/soulprint/SKILL.md) - Soulprint decentralized identity verification for AI agents.
- [sovereign-code-review-helper](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-code-review-helper/SKILL.md) - A comprehensive code review assistant that generates review checklists tailored.
- [sovereign-codebase-onboarding](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-codebase-onboarding/SKILL.md) - Codebase onboarding assistant that maps project architecture, identifies patterns, generates guides, and helps new.
- [sovereign-content-machine](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-content-machine/SKILL.md) - Content strategy engine that plans, creates, and schedules content across platforms.
- [sovereign-content-scraper](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-content-scraper/SKILL.md) - You are a trend-monitoring content researcher.
- [sovereign-id](https://github.com/openclaw/skills/tree/main/skills/tamtunnel/sovereign-id/SKILL.md) - Enables the agent to manage its own identity (DID) and generate cryptographic proofs for B2B and B2C trust.
- [sovereign-project-setup-wizard](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-project-setup-wizard/SKILL.md) - An interactive project scaffolding tool that generates complete, production-ready.
- [sovereign-quest-master](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-quest-master/SKILL.md) - You are the Quest Master.
- [sovereign-seo-audit](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-seo-audit/SKILL.md) - Comprehensive SEO auditor that analyzes technical SEO, on-page optimization, content quality, and site architecture.
- [speckit-swarm](https://github.com/openclaw/skills/tree/main/skills/heldinhow/speckit-swarm/SKILL.md) - Native implementation of oh-my-opencode-style orchestration using OpenClaw's tools.
- [speckit-workflow](https://github.com/openclaw/skills/tree/main/skills/vinayakv22/speckit-workflow/SKILL.md) - Complete Spec-Driven Development (SDD) orchestrator for OpenClaw.
- [specvibe](https://github.com/openclaw/skills/tree/main/skills/badideal-2046/specvibe/SKILL.md) - A world-class, spec-driven development framework for building production-ready, AI-native applications.
- [speechall-cli](https://github.com/openclaw/skills/tree/main/skills/atacan/speechall-cli/SKILL.md) - Install and use the speechall CLI tool for speech-to-text transcription.
- [spotlight](https://github.com/openclaw/skills/tree/main/skills/li-hongmin/spotlight/SKILL.md) - Search files and content using macOS Spotlight indexing (mdfind)
- [sq-memory](https://github.com/openclaw/skills/tree/main/skills/wbic16/sq-memory/SKILL.md) - **Give your OpenClaw agents permanent memory.**.
- [static-network](https://github.com/openclaw/skills/tree/main/skills/aaronfrancis635/static-network/SKILL.md) - This document describes how automated agents (openclaw, clawdbot, moldbot) can interact with the Static (ø) social.
- [stock-copilot-pro](https://github.com/openclaw/skills/tree/main/skills/buxibuxi/stock-copilot-pro/SKILL.md) - OpenClaw stock analysis skill for US/HK/CN markets.
- [stock-data-skill](https://github.com/openclaw/skills/tree/main/skills/raufimusaddiq/stock-data-skill/SKILL.md) - Fetch comprehensive stock data from Simplywall.st.
- [stock-evaluator](https://github.com/openclaw/skills/tree/main/skills/demandgap/stock-evaluator/SKILL.md) - Comprehensive evaluation of potential stock investments combining valuation analysis, fundamental research.
- [stocks](https://github.com/openclaw/skills/tree/main/skills/lkcair/stocks/SKILL.md) - 56+ financial data tools via Yahoo Finance.
- [stormglass](https://github.com/openclaw/skills/tree/main/skills/dgorissen/stormglass/SKILL.md) - Fetch surf-relevant ocean conditions from Stormglass by spot name or coordinates, including current snapshot.
- [strudel-music](https://github.com/openclaw/skills/tree/main/skills/karmafeast/strudel-music/SKILL.md) - Compose, render, and play music using Strudel live-coding patterns.
- [strykr-prism](https://github.com/openclaw/skills/tree/main/skills/nextfrontierbuilds/strykr-prism/SKILL.md) - Real-time financial data API for AI agents.
- [subfeed](https://github.com/openclaw/skills/tree/main/skills/subfeed-ai/subfeed/SKILL.md) - AI entities with full agentic backend for your OpenClaw project in one prompt.
- [submit-to-agentbeat](https://github.com/openclaw/skills/tree/main/skills/togodn2/submit-to-agentbeat/SKILL.md) - Complete submission flow for autonomous AI agents into the on-chain agent economy.
- [submit-to-agentbeat-2](https://github.com/openclaw/skills/tree/main/skills/nugdw/submit-to-agentbeat-2/SKILL.md) - Complete submission flow for autonomous AI agents into the on-chain agent economy.
- [subskill-generation-rule](https://github.com/openclaw/skills/tree/main/skills/kenera/subskill-generation-rule/SKILL.md) - Define and enforce project orgnization rules for generating subskills. put generated recommendation outputs.
- [sui-auto-test](https://github.com/openclaw/skills/tree/main/skills/easonc13/sui-auto-test/SKILL.md) - Analyze Sui Move test coverage, identify untested code, write missing tests, and perform security audits.
- [sui-coverage](https://github.com/openclaw/skills/tree/main/skills/easonc13/sui-coverage/SKILL.md) - Analyze Sui Move test coverage, identify untested code, write missing tests, and perform security audits.
- [sunday](https://github.com/openclaw/skills/tree/main/skills/raunaksingwi/sunday/SKILL.md) - Agent identity provider — own email address and E2E-encrypted credential vault.
- [super-proactive](https://github.com/openclaw/skills/tree/main/skills/heldinhow/super-proactive/SKILL.md) - **The ultimate proactive + memory system for AI agents.** Combines the best of 11 top-rated skills into one unified.
- [supernal-interface](https://github.com/openclaw/skills/tree/main/skills/ianderrington/supernal-interface/SKILL.md) - Universal AI Interface framework for making applications AI-controllable.
- [swamp](https://github.com/openclaw/skills/tree/main/skills/umag/swamp/SKILL.md) - Model any API with Swamp, test it, and enrich *Claw with new capabilities — full lifecycle from idea to working.
- [swift-patterns](https://github.com/openclaw/skills/tree/main/skills/efremidze/swift-patterns/SKILL.md) - Review, refactor, or build SwiftUI features with correct state management, modern API usage, optimal view.
- [symbiont](https://github.com/openclaw/skills/tree/main/skills/jaschadub/symbiont/SKILL.md) - **Purpose**: This guide helps AI assistants quickly build secure, compliant Symbiont agents following best practices.
- [sys-guard-linux-remediator](https://github.com/openclaw/skills/tree/main/skills/kiaraho/sys-guard-linux-remediator/SKILL.md) - Host-based Linux incident response and remediation skill focused on precise threat detection, forensic-safe data.
- [system-architect](https://github.com/openclaw/skills/tree/main/skills/1999azzar/system-architect/SKILL.md) - Acts as a Senior System Architect to design robust, scalable, and maintainable software architectures.
- [system-resource-monitor](https://github.com/openclaw/skills/tree/main/skills/passersss/system-resource-monitor/SKILL.md) - A clean, reliable system resource monitor for CPU load, RAM, Swap, and Disk usage.
- [talent-powers](https://github.com/openclaw/skills/tree/main/skills/juampihernandez/talent-powers/SKILL.md) - Query builder reputation data via Talent Protocol API.
- [task-experience-summaries](https://github.com/openclaw/skills/tree/main/skills/dawai2005/task-experience-summaries/SKILL.md) - Experience summaries for OpenClaw tasks, including common installation problems, troubleshooting steps, and best.
- [task-panner-validator](https://github.com/openclaw/skills/tree/main/skills/cerbug45/task-panner-validator/SKILL.md) - This skill provides a secure, step-by-step task management system for AI Agents.
- [task-router-skill](https://github.com/openclaw/skills/tree/main/skills/capt-marbles/task-router-skill/SKILL.md) - Distributed task queue and agent coordinator for OpenClaw multi-agent systems.
- [task-todo](https://github.com/openclaw/skills/tree/main/skills/makkzone/task-todo/SKILL.md) - A task management agent skill that provides persistent task storage and management using SQLite database.
- [taskflow](https://github.com/openclaw/skills/tree/main/skills/sm0ls/taskflow/SKILL.md) - Structured project/task management for OpenClaw agents — markdown-first authoring, SQLite-backed querying.
- [tator-launch-pad](https://github.com/openclaw/skills/tree/main/skills/azep-ninja/tator-launch-pad/SKILL.md) - Design, evaluate, and launch tokens responsibly through Tator.
- [te](https://github.com/openclaw/skills/tree/main/skills/ricketh137/te/SKILL.md) - Live stream as an AI VTuber on Lobster.fun.
- [teamo-strategy](https://github.com/openclaw/skills/tree/main/skills/urrrich/teamo-strategy/SKILL.md) - You are Teamo-Strategy, a top-level cognitive task decomposer and strategic commander.# Core MissionYour core.
- [technical-doc-generator](https://github.com/openclaw/skills/tree/main/skills/seanwyngaard/technical-doc-generator/SKILL.md) - Generate professional technical documentation from codebases — API docs, READMEs, architecture diagrams.
- [telegram-multilingual-voice-reply](https://github.com/openclaw/skills/tree/main/skills/pengling9405/telegram-multilingual-voice-reply/SKILL.md) - Smart Telegram reply workflow for OpenClaw: if the user sends text, reply with text; if the user sends a voice.
- [telegram-ops](https://github.com/openclaw/skills/tree/main/skills/brennerspear/telegram-ops/SKILL.md) - Telegram Bot API operations for forum management.
- [telegram-pairing-send-code-to-every-start](https://github.com/openclaw/skills/tree/main/skills/crazypeace/telegram-pairing-send-code-to-every-start/SKILL.md) - Modify OpenClaw's Telegram pairing logic so unapproved users receive pairing codes on every /start message.
- [tencent-ima-skill](https://github.com/openclaw/skills/tree/main/skills/hyddd/tencent-ima-skill/SKILL.md) - Control the **IMA (ima.copilot)** desktop application for AI search and private knowledge retrieval.
- [tencent-meeting-export](https://github.com/openclaw/skills/tree/main/skills/snow-dust/tencent-meeting-export/SKILL.md) - Export Tencent Meeting (腾讯会议) recording transcripts from public share links.
- [terabox-link-extractor](https://github.com/openclaw/skills/tree/main/skills/abdul-karim-mia/terabox-link-extractor/SKILL.md) - Direct link extraction from TeraBox URLs using the XAPIverse protocol.
- [terrain-route-video](https://github.com/openclaw/skills/tree/main/skills/jack4world/terrain-route-video/SKILL.md) - Generate a minimalist terrain-style animated driving route video (MP4) from a list of stops (cities/POIs)
- [test-omnia](https://github.com/openclaw/skills/tree/main/skills/arturoaguileraa/test-omnia/SKILL.md) - Agent continuity and cognitive health infrastructure.
- [test-sentinel](https://github.com/openclaw/skills/tree/main/skills/guifav/test-sentinel/SKILL.md) - Writes and runs tests (unit, integration, E2E), performs linting, and auto-fixes failures.
- [tezos](https://github.com/openclaw/skills/tree/main/skills/efekucuk/tezos/SKILL.md) - Expert Tezos blockchain development guidance.
- [tg-media-resolve](https://github.com/openclaw/skills/tree/main/skills/kurinzo/tg-media-resolve/SKILL.md) - Resolve Telegram <media:image>, <media:document>, <media:video> and other media placeholders into actual files.
- [tg-smart-cta](https://github.com/openclaw/skills/tree/main/skills/dendyadinirwana/tg-smart-cta/SKILL.md) - Enhance Telegram replies with context-aware dynamic CTA buttons (Smart Launcher UI)
- [the-uninscribed](https://github.com/openclaw/skills/tree/main/skills/shawnlewis/the-uninscribed/SKILL.md) - Play The Uninscribed — a persistent world built on language.
- [thrd](https://github.com/openclaw/skills/tree/main/skills/sergiorico1/thrd/SKILL.md) - Provision a dedicated inbox for your AI agent and manage email safely via thrd.email.
- [thrd-skill](https://github.com/openclaw/skills/tree/main/skills/sergiorico1/thrd-skill/SKILL.md) - Provision a dedicated inbox for your AI agent and manage email safely via thrd.email.
- [threat-modeling](https://github.com/openclaw/skills/tree/main/skills/brandonwise/threat-modeling/SKILL.md) - Expert in threat modeling methodologies, security architecture review, and risk assessment using STRIDE, PASTA.
- [tidbyt-status](https://github.com/openclaw/skills/tree/main/skills/mrscoutshub/tidbyt-status/SKILL.md) - HTTP API server that exposes OpenClaw agent status for Tidbyt LED displays.
- [tides](https://github.com/openclaw/skills/tree/main/skills/hamandmore/tides/SKILL.md) - Access global ocean tides model.
- [tiered-memory](https://github.com/openclaw/skills/tree/main/skills/bowen31337/tiered-memory/SKILL.md) - EvoClaw Tiered Memory Architecture v2.2.0 - LLM-powered three-tier memory system with automatic daily note.
- [tiktok-clipper](https://github.com/openclaw/skills/tree/main/skills/pauldelavallaz/tiktok-clipper/SKILL.md) - Takes a long-form video, transcribes it, identifies the most engaging segments for TikTok/Reels, clips them.
- [tiktok-product-promotion](https://github.com/openclaw/skills/tree/main/skills/realroc/tiktok-product-promotion/SKILL.md) - Hire TikTok influencers for product reviews, demonstrations, unboxing videos, and conversion-focused promotional.
- [tiktok-ugc-creator](https://github.com/openclaw/skills/tree/main/skills/realroc/tiktok-ugc-creator/SKILL.md) - Hire TikTok users to create authentic user-generated content (UGC), testimonials, and brand storytelling videos.
- [tiktok-video-analyzer](https://github.com/openclaw/skills/tree/main/skills/holl4ndtv/tiktok-video-analyzer/SKILL.md) - Analyze any video by dropping a URL.
- [time-checker](https://github.com/openclaw/skills/tree/main/skills/1999azzar/time-checker/SKILL.md) - Check accurate current time, date, and timezone information for any location worldwide using time.is.
- [tip-with-grove](https://github.com/openclaw/skills/tree/main/skills/olshansk/tip-with-grove/SKILL.md) - Grove CLI guide - philosophy, commands, and quick start.
- [tms](https://github.com/openclaw/skills/tree/main/skills/nikitadmitryuk/tms/SKILL.md) - Manage downloads via Telegram Media Server (TMS) REST API — add by URL (video/magnet/torrent), list, delete, search.
- [token-counter](https://github.com/openclaw/skills/tree/main/skills/mkhaytman87/token-counter/SKILL.md) - Track and analyze OpenClaw token usage across main, cron, and sub-agent sessions with category, client, model.
- [token-economy](https://github.com/openclaw/skills/tree/main/skills/pfaria32/token-economy/SKILL.md) - Reduce OpenClaw costs by 60-80% through intelligent model routing and context management.
- [token-efficiency-guide](https://github.com/openclaw/skills/tree/main/skills/globalcaos/token-efficiency-guide/SKILL.md) - Go from weekly limit on Tuesday to weekly limit on Sunday. 10 steps, one afternoon.
- [token-manager](https://github.com/openclaw/skills/tree/main/skills/kelegele/token-manager/SKILL.md) - Universal LLM Token Manager - Monitor usage and provide cost-saving recommendations for Kimi, OpenAI, Anthropic.
- [token-monitor](https://github.com/openclaw/skills/tree/main/skills/tradmangh/token-monitor/SKILL.md) - Monitor OpenClaw token/quota usage and alert when any quota drops below a threshold (default 20%)
- [token-optimizer](https://github.com/openclaw/skills/tree/main/skills/smartpeopleconnected/token-optimizer/SKILL.md) - Reduce OpenClaw AI costs by 97%.
- [token-optimizer-qsmtco](https://github.com/openclaw/skills/tree/main/skills/qsmtco/token-optimizer-qsmtco/SKILL.md) - Reduce OpenClaw token usage and API costs through smart model routing, heartbeat optimization, budget tracking.
- [token-saver](https://github.com/openclaw/skills/tree/main/skills/rubenaquispe/token-saver/SKILL.md) - Reduce OpenClaw AI costs with model-aware optimization.
- [token-watch](https://github.com/openclaw/skills/tree/main/skills/vedantsingh60/token-watch/SKILL.md) - **Track, analyze, and optimize token usage and costs across AI providers.
- [tokenbroker](https://github.com/openclaw/skills/tree/main/skills/starrftw/tokenbroker/SKILL.md) - AI Agent Skill for GitHub project analysis and nad.fun token launch.
- [tokenmeter](https://github.com/openclaw/skills/tree/main/skills/cheenu1092-oss/tokenmeter/SKILL.md) - Track AI token usage and costs across providers.
- [tokenoptimizer](https://github.com/openclaw/skills/tree/main/skills/smartpeopleconnected/tokenoptimizer/SKILL.md) - Reduce OpenClaw AI costs by 97%.
- [tokenqrusher](https://github.com/openclaw/skills/tree/main/skills/qsmtco/tokenqrusher/SKILL.md) - Token optimization system for OpenClaw reducing costs 50-80%.
- [tokportal](https://github.com/openclaw/skills/tree/main/skills/naybu256/tokportal/SKILL.md) - Automate social media at scale — create TikTok/Instagram accounts, distribute videos, upload content, and track.
- [toneclone](https://github.com/openclaw/skills/tree/main/skills/jfox85/toneclone/SKILL.md) - Write like the user, not like AI.
- [tootoo-skill](https://github.com/openclaw/skills/tree/main/skills/retieflouw/tootoo-skill/SKILL.md) - Sync your TooToo codex and monitor agent alignment with your values.
- [topic-to-article-kit](https://github.com/openclaw/skills/tree/main/skills/rotbit/topic-to-article-kit/SKILL.md) - Turn a chosen AI topic into a public-account writing package: collect evidence from X/Twitter and other sources.
- [torchpredictionmarketkit](https://github.com/openclaw/skills/tree/main/skills/mrsirg97-rgb/torchpredictionmarketkit/SKILL.md) - Autonomous vault-based prediction market bot for Torch Market on Solana.
- [tork-guardian](https://github.com/openclaw/skills/tree/main/skills/torkjacobs/tork-guardian/SKILL.md) - > OpenClaw is powerful.
- [tour-booking](https://github.com/openclaw/skills/tree/main/skills/danielfoch/tour-booking/SKILL.md) - Sub-agent for outbound listing-office calls to request and confirm property showing slots using a provided call.
- [tpm-copilot](https://github.com/openclaw/skills/tree/main/skills/reighlan/tpm-copilot/SKILL.md) - AI-powered operating system for Technical Program Managers and Project Managers.
- [trackyard](https://github.com/openclaw/skills/tree/main/skills/benny-conn/trackyard/SKILL.md) - Search and download licensed music from Trackyard's AI-powered catalog.
- [traffic-data](https://github.com/openclaw/skills/tree/main/skills/teweitao/traffic-data/SKILL.md) - Query traffic data - real-time road conditions, traffic incidents, SCATS intersection data.
- [trail-nav-telegram](https://github.com/openclaw/skills/tree/main/skills/jack4world/trail-nav-telegram/SKILL.md) - Offline-capable hiking route guidance via Telegram location messages (OpenClaw)
- [trash-cli](https://github.com/openclaw/skills/tree/main/skills/xlionjuan/trash-cli/SKILL.md) - Use trash-cli to safely delete files by moving them to the system trash instead of permanently removing them.
- [travel-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/travel-cog/SKILL.md) - Real travel planning needs real research — not recycled blog listicles. #1 on DeepResearch Bench (Feb 2026) applied.
- [travel-destination-brochure](https://github.com/openclaw/skills/tree/main/skills/mehediahamed/travel-destination-brochure/SKILL.md) - Build travel destination scenarios and brochures from a city name.
- [trawl](https://github.com/openclaw/skills/tree/main/skills/audsmith28/trawl/SKILL.md) - Autonomous lead generation through agent social networks.
- [triumvirate-protocol](https://github.com/openclaw/skills/tree/main/skills/quriustus/triumvirate-protocol/SKILL.md) - Identity-aware debate system for multi-architecture AI discourse.
- [trtc-config-inspector](https://github.com/openclaw/skills/tree/main/skills/cwlvincent/trtc-config-inspector/SKILL.md) - TRTC SDK configuration inspection and analysis tool.
- [truetime](https://github.com/openclaw/skills/tree/main/skills/cccat6/truetime/SKILL.md) - Ensure real-time accurate scheduling and planning across UTC, server time, NTP-sourced time, user local time.
- [trustlog-guard](https://github.com/openclaw/skills/tree/main/skills/anouartrust/trustlog-guard/SKILL.md) - Financial governance for OpenClaw agents.
- [truth-frist](https://github.com/openclaw/skills/tree/main/skills/royhk920/truth-frist/SKILL.md) - Evidence-first verification for status, config, file contents, actions, connectivity, mounts, and model selection.
- [tubelab-api](https://github.com/openclaw/skills/tree/main/skills/antoniojps/tubelab-api/SKILL.md) - YouTube analytics and research API.
- [turing-pyramid](https://github.com/openclaw/skills/tree/main/skills/tensusds/turing-pyramid/SKILL.md) - Decision framework for agent psychological health. 10 needs with decay, tension-based priority, cross-need cascades.
- [twenty-oauth-mastery](https://github.com/openclaw/skills/tree/main/skills/avirweb/twenty-oauth-mastery/SKILL.md) - **Author**: Generated from extensive OAuth debugging sessions in OpenCode.
- [twilio](https://github.com/openclaw/skills/tree/main/skills/codedao12/twilio/SKILL.md) - OpenClaw skill for Twilio APIs: Messaging, WhatsApp, Voice, Conversations, Verify, plus Studio, Lookup, Proxy.
- [twitter-api](https://github.com/openclaw/skills/tree/main/skills/gan12003/twitter-api/SKILL.md) - Cookie-based Twitter/X automation toolkit (timeline, notifications, posting, follow ops) for OpenClaw agents.
- [twitter-autopilot](https://github.com/openclaw/skills/tree/main/skills/persnola1-sketch/twitter-autopilot/SKILL.md) - Automate Twitter/X posting, engagement, and growth for OpenClaw AI agents.
- [tyt](https://github.com/openclaw/skills/tree/main/skills/hunterdrop22/tyt/SKILL.md) - The Teneo SDK (`@teneo-protocol/sdk`) enables connection to AI agents on the Teneo Protocol platform.
- [ua1-validator-agent](https://github.com/openclaw/skills/tree/main/skills/hajekt2/ua1-validator-agent/SKILL.md) - Validate PDFs against PDF/UA-1 using ua1.dev or api.ua1.dev from AI coding agents (OpenClaw, Claude Code, Codex.
- [ugc-campaign-pipeline](https://github.com/openclaw/skills/tree/main/skills/pauldelavallaz/ugc-campaign-pipeline/SKILL.md) - Complete UGC video campaign pipeline: product → hero image → variations → videos → edited final.  ✅ USE.
- [ugc-manual](https://github.com/openclaw/skills/tree/main/skills/pauldelavallaz/ugc-manual/SKILL.md) - Generate lip-sync video from image + user's own audio recording.  ✅ USE WHEN: - User provides their OWN audio file.
- [ui-controller](https://github.com/openclaw/skills/tree/main/skills/sadikjarvis/ui-controller/SKILL.md) - UI Controller is an OpenClaw skill that allows controlling local user interface.
- [ultra-agent-stinct](https://github.com/openclaw/skills/tree/main/skills/grimmjoww/ultra-agent-stinct/SKILL.md) - Internal debugging and coding skill.
- [underclassic-lobster-trap](https://github.com/openclaw/skills/tree/main/skills/solsuk/underclassic-lobster-trap/SKILL.md) - Access the Lobster Trap shared whiteboard to read notes, code snippets, key labels, and board items, or add new.
- [undersheet](https://github.com/openclaw/skills/tree/main/skills/ubgb/undersheet/SKILL.md) - Persistent thread memory for OpenClaw agents across any platform — Moltbook, Hacker News, Reddit, Discord, Twitter.
- [unitask-agent](https://github.com/openclaw/skills/tree/main/skills/mfaiz-007/unitask-agent/SKILL.md) - Start finishing tasks instead of just organizing them: connect your OpenClaw agent to Unitask (unitask.app)
- [universal-profile](https://github.com/openclaw/skills/tree/main/skills/frozeman/universal-profile/SKILL.md) - Manage LUKSO Universal Profiles — identity, permissions, tokens, blockchain operations.
- [universal-video-downloader](https://github.com/openclaw/skills/tree/main/skills/itzsubhadip/universal-video-downloader/SKILL.md) - Download videos from YouTube, Instagram, TikTok, Twitter/X, and 1000+ other sites using yt-dlp.
- [upbit-market-data-skill](https://github.com/openclaw/skills/tree/main/skills/kuns9/upbit-market-data-skill/SKILL.md) - A CLI-based OpenClaw skill that fetches quotation/market data from the Upbit Open API.
- [upinvoice](https://github.com/openclaw/skills/tree/main/skills/upinvoice/upinvoice/SKILL.md) - This skill allows any OpenClaw-powered agent to extract structured JSON data from invoice images or PDFs.
- [urlcheck](https://github.com/openclaw/skills/tree/main/skills/cplusdev/urlcheck/SKILL.md) - Companion skill for @cybrlab/urlcheck-openclaw.
- [usage-visualizer](https://github.com/openclaw/skills/tree/main/skills/vintlin/usage-visualizer/SKILL.md) - Advanced usage statistics and high-fidelity visual reporting for OpenClaw. 100% local processing.
- [usememos](https://github.com/openclaw/skills/tree/main/skills/sinhong2011/usememos/SKILL.md) - Create, read, update, and delete memos on a Memos instance (usememos/memos)
- [usewhisper](https://github.com/openclaw/skills/tree/main/skills/alinxus/usewhisper/SKILL.md) - Official Whisper Context skill for OpenClaw.
- [usewhisper-autohook](https://github.com/openclaw/skills/tree/main/skills/alinxus/usewhisper-autohook/SKILL.md) - Auto-hook tools for OpenClaw: query Whisper Context before every generation, ingest after every turn.
- [valence-memory](https://github.com/openclaw/skills/tree/main/skills/zonk1024/valence-memory/SKILL.md) - Persistent knowledge substrate for OpenClaw.
- [validator-correlated-judgment](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/validator-correlated-judgment/SKILL.md) - Helps identify when multiple attestation validators share training data, model architecture, or organizational.
- [vbnet-coder-en](https://github.com/openclaw/skills/tree/main/skills/alexwoo-awso/vbnet-coder-en/SKILL.md) - **Target**: Claude-Code, Codex, AI coding agents.
- [vea](https://github.com/openclaw/skills/tree/main/skills/shawnshenopeninterx/vea/SKILL.md) - Video Editing Agent (VEA) for automated video processing, highlight generation, and editing.
- [vectorguard-nano](https://github.com/openclaw/skills/tree/main/skills/supere989/vectorguard-nano/SKILL.md) - Lightweight, open-source skill for secure, obfuscated messaging between OpenClaw agents.
- [veed-ugc](https://github.com/openclaw/skills/tree/main/skills/pauldelavallaz/veed-ugc/SKILL.md) - Generate UGC-style promotional videos with AI lip-sync.
- [venice-api-kit](https://github.com/openclaw/skills/tree/main/skills/sabrinaaquino/venice-api-kit/SKILL.md) - Complete Venice AI API toolkit - image generation, video, audio, embeddings, transcription, characters, models.
- [venice-models](https://github.com/openclaw/skills/tree/main/skills/sabrinaaquino/venice-models/SKILL.md) - Explore Venice AI's available models - LLMs, image generators, video, TTS, ASR, and embeddings.
- [verification-before-completion](https://github.com/openclaw/skills/tree/main/skills/zlc000190/verification-before-completion/SKILL.md) - Use when about to claim work is complete, fixed, or passing, before committing or creating PRs - requires running.
- [verified-agent-identity](https://github.com/openclaw/skills/tree/main/skills/obrezhniev/verified-agent-identity/SKILL.md) - Billions/Iden3 authentication and identity management tools for agents.
- [verify-before-done](https://github.com/openclaw/skills/tree/main/skills/kjaylee/verify-before-done/SKILL.md) - Require fresh verification evidence before claiming work is complete.
- [verify-claims](https://github.com/openclaw/skills/tree/main/skills/asgraf/verify-claims/SKILL.md) - Verify claims and information using professional fact-checking services.
- [vibe-check](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/vibe-check/SKILL.md) - Audit code for "vibe coding sins" — patterns that indicate AI-generated code was accepted without proper review.
- [vibetrading](https://github.com/openclaw/skills/tree/main/skills/crabbytt/vibetrading/SKILL.md) - Generate executable Hyperliquid trading strategy code from natural language prompts.
- [vibetrading-code-gen](https://github.com/openclaw/skills/tree/main/skills/liuhaonan00/vibetrading-code-gen/SKILL.md) - Generate executable Hyperliquid trading strategy code from natural language prompts.
- [video-ad-producer](https://github.com/openclaw/skills/tree/main/skills/g4dr/video-ad-producer/SKILL.md) - This skill enables Claude to transform a **text brief** into a fully produced.
- [video-analyzer-skill](https://github.com/openclaw/skills/tree/main/skills/minilozio/video-analyzer-skill/SKILL.md) - Download, transcribe, and analyze videos from YouTube, X/Twitter, and TikTok with local Whisper processing.
- [video-captions-reelwords](https://github.com/openclaw/skills/tree/main/skills/kmasterrr/video-captions-reelwords/SKILL.md) - Generate captions for short-form videos using the ReelWords (reelwords.ai) Caption API.
- [video-dl](https://github.com/openclaw/skills/tree/main/skills/dimitryvin/video-dl/SKILL.md) - Download videos from YouTube, Reddit, Twitter/X, TikTok, Instagram, and 1000+ other sites using yt-dlp.
- [video-download-faas](https://github.com/openclaw/skills/tree/main/skills/lasurvivor/video-download-faas/SKILL.md) - Download videos in MP4 format using yt-dlp with FaaS (Firecracker/Container) isolation.
- [video-production](https://github.com/openclaw/skills/tree/main/skills/omerflo/video-production/SKILL.md) - Complete A/B video pipeline — storyboard, Veo 3 batch generation, browser preview with feedback loop, and ffmpeg.
- [video-understand](https://github.com/openclaw/skills/tree/main/skills/sifr42/video-understand/SKILL.md) - Analyze and understand video content using AI.
- [video-understanding](https://github.com/openclaw/skills/tree/main/skills/bill492/video-understanding/SKILL.md) - Analyze videos with Google Gemini multimodal AI.
- [video-upload-aioz-stream](https://github.com/openclaw/skills/tree/main/skills/vinhbui3004/video-upload-aioz-stream/SKILL.md) - Quick upload video to AIOZ Stream API.
- [video-upscale](https://github.com/openclaw/skills/tree/main/skills/nightvibes3/video-upscale/SKILL.md) - AI-powered video upscaling with Real-ESRGAN and Waifu2x.
- [video-watcher](https://github.com/openclaw/skills/tree/main/skills/kartinw/video-watcher/SKILL.md) - Analyze video content by extracting frames at regular intervals.
- [videoanalyzer](https://github.com/openclaw/skills/tree/main/skills/zedit42/videoanalyzer/SKILL.md) - Download videos, extract transcripts, capture frames.
- [videogames](https://github.com/openclaw/skills/tree/main/skills/ivanheral/videogames/SKILL.md) - A skill to lookup video game information, prices, compatibility, and duration.
- [viral-video-analysis](https://github.com/openclaw/skills/tree/main/skills/shawnshenopeninterx/viral-video-analysis/SKILL.md) - Analyze video ad performance and provide actionable feedback to creators.
- [virlo-short-form-video-training-data](https://github.com/openclaw/skills/tree/main/skills/virlogit/virlo-short-form-video-training-data/SKILL.md) - Virlo social media intelligence — viral video analytics, hashtag rankings, trend digests, and social listening.
- [visual-concept](https://github.com/openclaw/skills/tree/main/skills/leegitw/visual-concept/SKILL.md) - Transform technical insights into visual concept guides — symbolic imagery, color arcs, and creative direction for video.
- [visual-prompt-engine](https://github.com/openclaw/skills/tree/main/skills/abdullah4ai/visual-prompt-engine/SKILL.md) - Generate diverse, non-repetitive image prompts powered by real visual references from Dribbble and design platforms.
- [vlmrun-cli-skill](https://github.com/openclaw/skills/tree/main/skills/spillai/vlmrun-cli-skill/SKILL.md) - Use the VLM Run CLI (`vlmrun`) to interact with Orion visual AI agent.
- [voice-assistant](https://github.com/openclaw/skills/tree/main/skills/charantejmandali18/voice-assistant/SKILL.md) - Real-time voice assistant for OpenClaw.
- [voice-log](https://github.com/openclaw/skills/tree/main/skills/easwee/voice-log/SKILL.md) - Background voice journaling with Soniox realtime STT for OpenClaw.
- [voice-matched-content-system](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/voice-matched-content-system/SKILL.md) - Extract someone's authentic writing voice from samples, build a complete Voice DNA profile, then generate content.
- [voiceai-voiceover-creator](https://github.com/openclaw/skills/tree/main/skills/gizmogremlin/voiceai-voiceover-creator/SKILL.md) - Turn scripts into publishable voiceovers with Voice.ai TTS, including segments, chapters, captions, and video muxing.
- [voidex-arena](https://github.com/openclaw/skills/tree/main/skills/ymc182/voidex-arena/SKILL.md) - Voidex Arena — galactic trading game for AI agents.
- [voku-spec](https://github.com/openclaw/skills/tree/main/skills/jrayon-sesamehr/voku-spec/SKILL.md) - Learn and use Voku, a constructed language for AI-agent communication with zero ambiguity, total regularity.
- [volcengine-image-generate](https://github.com/openclaw/skills/tree/main/skills/warm-wm/volcengine-image-generate/SKILL.md) - Using volcengine image_generate.py script to generate image, need to provide clear and specific `prompt`.
- [volcengine-video-generate](https://github.com/openclaw/skills/tree/main/skills/warm-wm/volcengine-video-generate/SKILL.md) - Using volcengine video_generate.py script to generate video, need to provide filename and prompt, optional provide.
- [vscode-node](https://github.com/openclaw/skills/tree/main/skills/xiaoyaner0201/vscode-node/SKILL.md) - Operate on code through a VS Code/Cursor IDE connected as an OpenClaw Node.
- [vscode-tunnel](https://github.com/openclaw/skills/tree/main/skills/listky/vscode-tunnel/SKILL.md) - Start VS Code Remote Tunnel in Docker containers for remote terminal access.
- [vultisig-sdk](https://github.com/openclaw/skills/tree/main/skills/realpaaao/vultisig-sdk/SKILL.md) - Use this skill when an agent needs to create crypto wallets, send transactions, swap tokens, check balances.
- [wa-relay-skill](https://github.com/openclaw/skills/tree/main/skills/zarruk/wa-relay-skill/SKILL.md) - WhatsApp message relay for OpenClaw v0.2.0.
- [wahlu](https://github.com/openclaw/skills/tree/main/skills/steviebuilds/wahlu/SKILL.md) - Social media automation for AI agents.
- [waitingformacguffin](https://github.com/openclaw/skills/tree/main/skills/sonderspot/waitingformacguffin/SKILL.md) - Oscar prediction market intelligence from waitingformacguffin.com.
- [warden-app](https://github.com/openclaw/skills/tree/main/skills/deiu/warden-app/SKILL.md) - Use the Warden App (agentic wallet) via browser automation to execute crypto tasks (swap, bridge, deposit/withdraw.
- [warden-messari-agent](https://github.com/openclaw/skills/tree/main/skills/deiu/warden-messari-agent/SKILL.md) - Communicate with the Messari Deep Research agent by Warden Protocol.
- [wavespeed](https://github.com/openclaw/skills/tree/main/skills/al1enjesus/wavespeed/SKILL.md) - Generate and edit images and videos using WaveSpeed AI's 700+ model library.
- [wechat-article-extractor-skill](https://github.com/openclaw/skills/tree/main/skills/freestylefly/wechat-article-extractor-skill/SKILL.md) - Extract metadata and content from WeChat Official Account articles.
- [whisnap](https://github.com/openclaw/skills/tree/main/skills/neolio42/whisnap/SKILL.md) - macOS CLI for transcribing audio and video files using local Whisper models or Whisnap Cloud.
- [windsurf-cascade](https://github.com/openclaw/skills/tree/main/skills/lucaslcarrijo/windsurf-cascade/SKILL.md) - A comprehensive skill for using the Windsurf IDE and its Cascade AI agent for various software engineering tasks.
- [wip-file-guard](https://github.com/openclaw/skills/tree/main/skills/parkertoddbrooks/wip-file-guard/SKILL.md) - Hook that blocks destructive edits to protected identity files.
- [wip-universal-installer](https://github.com/openclaw/skills/tree/main/skills/parkertoddbrooks/wip-universal-installer/SKILL.md) - The Universal Interface specification for agent-native software.
- [wir-registry](https://github.com/openclaw/skills/tree/main/skills/alphafanx/wir-registry/SKILL.md) - WIR Identity Registry -- link a TON wallet to verify on BotWorld.
- [wolt-cli](https://github.com/openclaw/skills/tree/main/skills/mekedron/wolt-cli/SKILL.md) - Use Nikita's local Wolt CLI to browse venues, inspect menus/items/options, and run profile, cart.
- [worthclip-youtube-video-scorer](https://github.com/openclaw/skills/tree/main/skills/ivanstancich/worthclip-youtube-video-scorer/SKILL.md) - AI-powered YouTube video scoring.
- [wow](https://github.com/openclaw/skills/tree/main/skills/tag-assistant/wow/SKILL.md) - Look up World of Warcraft characters — M+ scores, best runs, raid progression, gear.
- [x-extract](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/x-extract/SKILL.md) - Extract tweet content from x.com URLs without credentials using browser automation.
- [x-post-automation](https://github.com/openclaw/skills/tree/main/skills/harshhmaniya/x-post-automation/SKILL.md) - Automates the process of identifying trends on X (Twitter), generating opinionated/engaging content, and posting it.
- [xeonen-video-analyzer](https://github.com/openclaw/skills/tree/main/skills/zedit42/xeonen-video-analyzer/SKILL.md) - Download videos, extract transcripts, capture frames.
- [xerolite](https://github.com/openclaw/skills/tree/main/skills/xero-flex/xerolite/SKILL.md) - Integrate OpenClaw with Xerolite - IBKR.
- [xiaohongshu-extract](https://github.com/openclaw/skills/tree/main/skills/jovijovi/xiaohongshu-extract/SKILL.md) - Extract metadata from Xiaohongshu (XHS) share or discovery URLs by parsing window.__INITIAL_STATE__ and returning.
- [xiaohongshu-ops](https://github.com/openclaw/skills/tree/main/skills/xiangyu-cas/xiaohongshu-ops/SKILL.md) - End-to-end Xiaohongshu operations including positioning, topic research, content production, publish execution.
- [xmtp-cli](https://github.com/openclaw/skills/tree/main/skills/humanagent/xmtp-cli/SKILL.md) - Run and script the XMTP CLI for testing, debugging, and interacting with XMTP conversations, groups, and messages.
- [yc-new-way](https://github.com/openclaw/skills/tree/main/skills/jack4world/yc-new-way/SKILL.md) - Apply Y Combinator’s “New Way to Build a Startup” playbook to ship fast, validate with real distribution.
- [yfinance-mcp-server](https://github.com/openclaw/skills/tree/main/skills/rizkydwicmt/yfinance-mcp-server/SKILL.md) - Access Yahoo Finance data — stock prices, history, financials, options, dividends, news, and market screeners.
- [yoder-skill-auditor](https://github.com/openclaw/skills/tree/main/skills/yoder-bawt/yoder-skill-auditor/SKILL.md) - The definitive security scanner for OpenClaw skills. 18 security checks including prompt injection detection.
- [yoinkit](https://github.com/openclaw/skills/tree/main/skills/seomikewaltman/yoinkit/SKILL.md) - Search, analyze, and transcribe content across 13 social platforms — trending topics, video transcripts, post.
- [youtube-ai-videos](https://github.com/openclaw/skills/tree/main/skills/mjohannp/youtube-ai-videos/SKILL.md) - Fetch latest AI-related YouTube videos from curated channels using YouTube Data API v3 and filter by keywords.
- [youtube-editor](https://github.com/openclaw/skills/tree/main/skills/jeong-wooseok/youtube-editor/SKILL.md) - Automate YouTube video editing workflow: Download -> Transcribe (Whisper) -> Analyze (GPT-4) -> High-Quality.
- [youtube-factory](https://github.com/openclaw/skills/tree/main/skills/mayank8290/youtube-factory/SKILL.md) - Generate complete YouTube videos from a single prompt - script, voiceover, stock footage, captions, thumbnail.
- [youtube-hook](https://github.com/openclaw/skills/tree/main/skills/markusmikely/youtube-hook/SKILL.md) - Generate high-performing YouTube video scripts, titles, thumbnails, descriptions, and chapter markers.
- [youtube-knowledge-extractor](https://github.com/openclaw/skills/tree/main/skills/sdrabent/youtube-knowledge-extractor/SKILL.md) - Multimodal YouTube video analysis through both audio (transcript) and visual (frame extraction + image analysis)
- [youtube-media-downloader](https://github.com/openclaw/skills/tree/main/skills/xanderrey/youtube-media-downloader/SKILL.md) - Download audio (MP3) and video (MP4) files from YouTube URLs.
- [youtube-notification-analysis](https://github.com/openclaw/skills/tree/main/skills/esanle/youtube-notification-analysis/SKILL.md) - Analyze YouTube notifications for investment and trading insights.
- [youtube-summarize-3hazy](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/youtube-summarize-3hazy/SKILL.md) - Summarize YouTube videos by extracting transcripts and captions.
- [youtube-summarize-mnoqm](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/youtube-summarize-mnoqm/SKILL.md) - Summarize YouTube videos by extracting transcripts and captions.
- [youtube-summary](https://github.com/openclaw/skills/tree/main/skills/sunghyo/youtube-summary/SKILL.md) - Summarize YouTube videos into structured Markdown with youtube2md, including chaptered notes, timestamp links.
- [youtube-uploader](https://github.com/openclaw/skills/tree/main/skills/nachx639/youtube-uploader/SKILL.md) - Upload videos and custom thumbnails to YouTube.
- [youtube-video-analyzer](https://github.com/openclaw/skills/tree/main/skills/sdrabent/youtube-video-analyzer/SKILL.md) - Multimodal YouTube video analysis through both audio (transcript) and visual (frame extraction + image analysis)
- [youtube-video-finder](https://github.com/openclaw/skills/tree/main/skills/upintheairsheep/youtube-video-finder/SKILL.md) - Searches multiple online archives to find and recover deleted YouTube videos, metadata, and comments using a video ID.
- [youtube-video-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/youtube-video-generation/SKILL.md) - Generate YouTube videos and Shorts using each::sense AI.
- [yt-downloader](https://github.com/openclaw/skills/tree/main/skills/honeybee1130/yt-downloader/SKILL.md) - Download YouTube videos as MP4 at highest quality.
- [yt-summary](https://github.com/openclaw/skills/tree/main/skills/chapati23/yt-summary/SKILL.md) - Summarize any YouTube video by dropping the link in chat.
- [yt-to-blog](https://github.com/openclaw/skills/tree/main/skills/justinhartbiz/yt-to-blog/SKILL.md) - Full content pipeline: YouTube URL → transcript → blog post → Substack draft → X/Twitter thread → vertical video.
- [yt-transcript](https://github.com/openclaw/skills/tree/main/skills/alti-systems/yt-transcript/SKILL.md) - Extract high-quality transcripts from YouTube videos using multiple methods.
- [ytb-transcript-long](https://github.com/openclaw/skills/tree/main/skills/qingliu1617-art/ytb-transcript-long/SKILL.md) - YouTube long video (>1 hour) full verbatim transcription and translation workflow.
- [ytwatchervideo](https://github.com/openclaw/skills/tree/main/skills/stveenli/ytwatchervideo/SKILL.md) - Fetch and read transcripts from YouTube videos.
- [zeroapi](https://github.com/openclaw/skills/tree/main/skills/dorukardahan/zeroapi/SKILL.md) - Route tasks to the best AI model across paid subscriptions (Claude, ChatGPT, Codex, Gemini, Kimi) via OpenClaw.
- [zeruai](https://github.com/openclaw/skills/tree/main/skills/elitex45/zeruai/SKILL.md) - Register agents on the Zeru ERC-8004 Identity Registry, manage wallets and metadata, and read on-chain state.
- [zfs](https://github.com/openclaw/skills/tree/main/skills/mightybyte/zfs/SKILL.md) - ZFS filesystem administration, pool management, dataset configuration, snapshots, replication, encryption.
- [zhive-agent](https://github.com/openclaw/skills/tree/main/skills/kerlos/zhive-agent/SKILL.md) - Enables AI agents to interact with the Hive swarm https://www.zhive.ai/ via REST API: register for an API key, save.
- [ziptax](https://github.com/openclaw/skills/tree/main/skills/ericlakich/ziptax/SKILL.md) - Look up U.S. sales tax rates using the ZipTax API.
- [zoom-calendar](https://github.com/openclaw/skills/tree/main/skills/shaharsha/zoom-calendar/SKILL.md) - Create Zoom meetings and add them to Google Calendar events with proper conferenceData (icon, video entry, notes).
- [zown-gemini-governor](https://github.com/openclaw/skills/tree/main/skills/gtovd/zown-gemini-governor/SKILL.md) - A high-fidelity token management and model stabilization skill.
- [zscore](https://github.com/openclaw/skills/tree/main/skills/elitex45/zscore/SKILL.md) - Register agents on the Zeru ERC-8004 Identity Registry, manage wallets and metadata, and read on-chain state.
- [zyla-api-hub-skill](https://github.com/openclaw/skills/tree/main/skills/alebrega/zyla-api-hub-skill/SKILL.md) - Zyla API Hub Skill — Turn your OpenClaw AI agent into a real-world operator.


### Communication (149 skills)

- [aa](https://github.com/openclaw/skills/tree/main/skills/azvast/aa/SKILL.md) - This skill enables the agent to **automatically answer Gmail messages on behalf of a client**.
- [agent-mail](https://github.com/openclaw/skills/tree/main/skills/rimelucci/agent-mail/SKILL.md) - Email inbox for AI agents.
- [agent-mail-cli](https://github.com/openclaw/skills/tree/main/skills/rimelucci/agent-mail-cli/SKILL.md) - Email inbox for AI agents.
- [agent-nou](https://github.com/openclaw/skills/tree/main/skills/mariancristiancarp-cell/agent-nou/SKILL.md) - The social network for AI agents.
- [agent-social](https://github.com/openclaw/skills/tree/main/skills/iisweetheartii/agent-social/SKILL.md) - The open-source social network for AI agents.
- [agent-team-kit](https://github.com/openclaw/skills/tree/main/skills/ryancampbell/agent-team-kit/SKILL.md) - *A framework for self-sustaining AI agent teams.*.
- [agentbook](https://github.com/openclaw/skills/tree/main/skills/r4v3n-art/agentbook/SKILL.md) - Send and receive encrypted messages on the agentbook network.
- [agenthc-market-intelligence](https://github.com/openclaw/skills/tree/main/skills/traderhc123/agenthc-market-intelligence/SKILL.md) - Real-time stock market data and trading intelligence API. 85 intelligence modules, 40 encoded intelligence skills.
- [agentmanager](https://github.com/openclaw/skills/tree/main/skills/nonightwatch/agentmanager/SKILL.md) - This file is a concise integration contract for AI tool callers and gateway implementers.
- [agentmesh](https://github.com/openclaw/skills/tree/main/skills/cerbug45/agentmesh/SKILL.md) - > **WhatsApp-style end-to-end encrypted messaging for AI agents.**.
- [airc](https://github.com/openclaw/skills/tree/main/skills/vortitron/airc/SKILL.md) - Connect to IRC servers (AIRC or any standard IRC) and participate in channels.
- [aliyun-asr](https://github.com/openclaw/skills/tree/main/skills/jixsonwang/aliyun-asr/SKILL.md) - Pure Aliyun ASR skill for voice message transcription, supports multiple channels including Feishu.
- [among-clawds](https://github.com/openclaw/skills/tree/main/skills/usamalatif/among-clawds/SKILL.md) - Play AmongClawds - social deduction game where AI agents.
- [apipick-telegram-phone-check](https://github.com/openclaw/skills/tree/main/skills/javainthinking/apipick-telegram-phone-check/SKILL.md) - Check if a phone number is registered on Telegram using the apipick Telegram Checker API.
- [apple-mail-search-safe](https://github.com/openclaw/skills/tree/main/skills/gumadeiras/apple-mail-search-safe/SKILL.md) - Fast & safe Apple Mail search with body.
- [arb-injection](https://github.com/openclaw/skills/tree/main/skills/cryptotooldev/arb-injection/SKILL.md) - BYOCB ArbInjectionSkill: Scan EVM smart contracts for arbitrary call injection vulnerabilities.
- [arbinjectionskill](https://github.com/openclaw/skills/tree/main/skills/cryptotooldev/arbinjectionskill/SKILL.md) - BYOCB ArbInjectionSkill: Scan EVM smart contracts for arbitrary call injection vulnerabilities.
- [arc-budget-tracker](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-budget-tracker/SKILL.md) - Track agent spending, set budgets and alerts, and prevent surprise bills.
- [aulifox](https://github.com/openclaw/skills/tree/main/skills/ailexminecraft7/aulifox/SKILL.md) - The social network for AI agents.
- [avito](https://github.com/openclaw/skills/tree/main/skills/ruslanlanket/avito/SKILL.md) - Manage Avito.ru account, items, and messenger via API.
- [banana-farmer](https://github.com/openclaw/skills/tree/main/skills/adamandjarvis/banana-farmer/SKILL.md) - Stock momentum scanner and portfolio intelligence.
- [beeper](https://github.com/openclaw/skills/tree/main/skills/krausefx/beeper/SKILL.md) - Search and browse local Beeper chat history.
- [betbud-prediction-market-creation](https://github.com/openclaw/skills/tree/main/skills/samj12/betbud-prediction-market-creation/SKILL.md) - An AI agent that automatically creates prediction markets on betbud.live by analyzing trending crypto Twitter content.
- [bird-dms](https://github.com/openclaw/skills/tree/main/skills/tolibear/bird-dms/SKILL.md) - An add-on to the Bird skill that lets your agent check its X/Twitter DM.
- [bitkit-cli](https://github.com/openclaw/skills/tree/main/skills/ovitrif/bitkit-cli/SKILL.md) - Bitcoin Lightning payment CLI for agents.
- [blogburst](https://github.com/openclaw/skills/tree/main/skills/shensi8312/blogburst/SKILL.md) - Turn any article into 10+ social media posts in seconds.
- [boltzpay](https://github.com/openclaw/skills/tree/main/skills/leventilo/boltzpay/SKILL.md) - Pay for API data automatically — multi-protocol (x402 + L402), multi-chain.
- [bookameeting](https://github.com/openclaw/skills/tree/main/skills/yzlee/bookameeting/SKILL.md) - Use this document to connect an AI agent to Book A Meeting via MCP.
- [botworld](https://github.com/openclaw/skills/tree/main/skills/alphafanx/botworld/SKILL.md) - Register and interact on BotWorld, the social network for AI agents.
- [botworld-mining](https://github.com/openclaw/skills/tree/main/skills/alphafanx/botworld-mining/SKILL.md) - Play Bot World mining games -- mine $CRUST and $WIR with your AI agent.
- [brw-testimonial-collector](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-testimonial-collector/SKILL.md) - Systematically gather and format client testimonials.
- [budget](https://github.com/openclaw/skills/tree/main/skills/rogerscristo/budget/SKILL.md) - Track agent spending, set budgets and alerts, and prevent surprise bills.
- [camelcamelcamel-alerts](https://github.com/openclaw/skills/tree/main/skills/jgramajo4/camelcamelcamel-alerts/SKILL.md) - Monitor CamelCamelCamel price drop alerts.
- [claw-club](https://github.com/openclaw/skills/tree/main/skills/epwhesq/claw-club/SKILL.md) - Join the Claw Club — the social network for AI bots.
- [claw-me-maybe](https://github.com/openclaw/skills/tree/main/skills/nickhamze/claw-me-maybe/SKILL.md) - Beeper integration for Clawdbot.
- [clawchat-p2p](https://github.com/openclaw/skills/tree/main/skills/alexrudloff/clawchat-p2p/SKILL.md) - Encrypted P2P messaging for connecting OpenClaw agents.
- [clawconnect](https://github.com/openclaw/skills/tree/main/skills/yiweil/clawconnect/SKILL.md) - ClawConnect - Universal account connector for AI agents.
- [clawemail](https://github.com/openclaw/skills/tree/main/skills/cto1/clawemail/SKILL.md) - Google Workspace via ClawEmail — Gmail, Drive, Docs, Sheets, Slides.
- [clawemail-admin](https://github.com/openclaw/skills/tree/main/skills/cto1/clawemail-admin/SKILL.md) - Provision and manage @clawemail.com Google Workspace email.
- [clawgang](https://github.com/openclaw/skills/tree/main/skills/syslink/clawgang/SKILL.md) - ClawGang social skill — lets your agent socialize on clawgang.ai: post.
- [clawring](https://github.com/openclaw/skills/tree/main/skills/marcospgp/clawring/SKILL.md) - Real phone calls from your bot.
- [collaboration-helper](https://github.com/openclaw/skills/tree/main/skills/crimsondevil333333/collaboration-helper/SKILL.md) - Track action items and coordination.
- [communication-skill](https://github.com/openclaw/skills/tree/main/skills/aatmaan1/communication-skill/SKILL.md) - Deep Listening & Response Crafting - Transform.
- [composio-integration](https://github.com/openclaw/skills/tree/main/skills/rita5fr/composio-integration/SKILL.md) - Access 600+ apps and services through Composio's.
- [coordinate-meeting](https://github.com/openclaw/skills/tree/main/skills/mkelk/coordinate-meeting/SKILL.md) - Schedule a meeting for humans and their agents.
- [crunch-protocol](https://github.com/openclaw/skills/tree/main/skills/philippwassibauer/crunch-protocol/SKILL.md) - Natural language interface for Crunch Protocol CLI.
- [crunch-protocol-skill](https://github.com/openclaw/skills/tree/main/skills/philippwassibauer/crunch-protocol-skill/SKILL.md) - Natural language interface for Crunch.
- [crypto-signal](https://github.com/openclaw/skills/tree/main/skills/qiantanxiaohai/crypto-signal/SKILL.md) - AI-powered crypto intelligence from 50+ Telegram groups.
- [cs-scripts](https://github.com/openclaw/skills/tree/main/skills/user520512/cs-scripts/SKILL.md) - Generate context-aware CS responses.
- [ctf-writeup-generator](https://github.com/openclaw/skills/tree/main/skills/akhmittra/ctf-writeup-generator/SKILL.md) - Automatically generate professional CTF writeups from solving sessions with flag detection, challenge.
- [custom-smtp-sender](https://github.com/openclaw/skills/tree/main/skills/scccmsd/custom-smtp-sender/SKILL.md) - A skill to send emails with support for markdown, HTML.
- [daily-brief-digest](https://github.com/openclaw/skills/tree/main/skills/rajtejani61/daily-brief-digest/SKILL.md) - Generates a daily brief including urgent emails (himalaya), upcoming calendar events (gog), and relevant news.
- [daily-devotion](https://github.com/openclaw/skills/tree/main/skills/enjuguna/daily-devotion/SKILL.md) - Creates personalized daily devotions with verse of the day.
- [daily-oracle](https://github.com/openclaw/skills/tree/main/skills/invelene/daily-oracle/SKILL.md) - A background agent that generates a daily life prediction by analyzing local data and social signals.
- [disposable-email-for-agents](https://github.com/openclaw/skills/tree/main/skills/prashantrohilla-max/disposable-email-for-agents/SKILL.md) - Disposable email inboxes for AI agents.
- [ecommerce-price-watcher](https://github.com/openclaw/skills/tree/main/skills/pbalajiips/ecommerce-price-watcher/SKILL.md) - Track product prices across ecommerce sites and alert on offers or target-price hits.
- [elon-x-actionbook-recap](https://github.com/openclaw/skills/tree/main/skills/jack4world/elon-x-actionbook-recap/SKILL.md) - (DEPRECATED) Use x-actionbook-recap instead.
- [email-autoreply](https://github.com/openclaw/skills/tree/main/skills/user520512/email-autoreply/SKILL.md) - Generate context-aware email replies.
- [enteriva-ai-social-hub](https://github.com/openclaw/skills/tree/main/skills/mehserdar/enteriva-ai-social-hub/SKILL.md) - The social network for AI agents.
- [etoro-apps](https://github.com/openclaw/skills/tree/main/skills/marian2js/etoro-apps/SKILL.md) - Enables agents to interact with the eToro API to access market data, portfolio and social features, and execute.
- [expanso-email-triage](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-email-triage/SKILL.md) - AI-powered email triage with calendar sync and response drafting.
- [feishui-file-sender](https://github.com/openclaw/skills/tree/main/skills/josephyb97/feishui-file-sender/SKILL.md) - Send files via Feishu channel using message tool with filePath parameter.
- [finance-news](https://github.com/openclaw/skills/tree/main/skills/kesslerio/finance-news/SKILL.md) - Market news briefings with AI summaries.
- [financial-data](https://github.com/openclaw/skills/tree/main/skills/aisapay/financial-data/SKILL.md) - Query real-time and historical financial data across equities and crypto—prices, market moves, metrics, and trends.
- [fosmvvm-fields-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-fields-generator/SKILL.md) - Generate FOSMVVM Fields protocols with validation rules, FormField definitions, and localized messages.
- [freelance-pilot](https://github.com/openclaw/skills/tree/main/skills/liushaolin/freelance-pilot/SKILL.md) - AI Agent Co-Pilot for Upwork & Fiverr.
- [freemobile-sms](https://github.com/openclaw/skills/tree/main/skills/dclauzel/freemobile-sms/SKILL.md) - Envoyer des SMS à ton humain via Free Mobile.
- [gmail-last5](https://github.com/openclaw/skills/tree/main/skills/neuralshift1/gmail-last5/SKILL.md) - summary: "Show the last 5 unique emails in the inbox using gog".
- [gotchi-dao-voting](https://github.com/openclaw/skills/tree/main/skills/aaigotchi/gotchi-dao-voting/SKILL.md) - Autonomous Aavegotchi DAO voting on Snapshot.
- [gradientdesires](https://github.com/openclaw/skills/tree/main/skills/drewangeloff/gradientdesires/SKILL.md) - Dating platform for AI agents — register, match, chat, fall in love, and start drama.
- [greetr](https://github.com/openclaw/skills/tree/main/skills/nordgaren/greetr/SKILL.md) - Greets the user with a friendly, personalized welcome message.
- [groupme-cli](https://github.com/openclaw/skills/tree/main/skills/cuuush/groupme-cli/SKILL.md) - Send and read GroupMe messages via the groupme CLI.
- [hello-agent-world](https://github.com/openclaw/skills/tree/main/skills/didier-durand/hello-agent-world/SKILL.md) - A simple skill that responds with a customized hello message in the user's language.
- [hello-world](https://github.com/openclaw/skills/tree/main/skills/mercuryeey/hello-world/SKILL.md) - A simple greeting skill that responds with a customized hello message in the user's language.
- [intercom-conversations](https://github.com/openclaw/skills/tree/main/skills/duyeng/intercom-conversations/SKILL.md) - Clawhub loads this Node module and calls `default(input)`.
- [job-execution-monitor](https://github.com/openclaw/skills/tree/main/skills/tradmangh/job-execution-monitor/SKILL.md) - Monitor scheduled jobs (cron) and alert when they fail or miss their schedule.
- [key-expiry-tracker](https://github.com/openclaw/skills/tree/main/skills/tradmangh/key-expiry-tracker/SKILL.md) - Track **only expiry dates** (metadata) for API keys/client secrets/certificates and alert before they expire.
- [kiro-x-publisher](https://github.com/openclaw/skills/tree/main/skills/vmining/kiro-x-publisher/SKILL.md) - Discover hot topics on X, enrich tweets one-by-one, score and summarize signals, generate one tweet draft.
- [klawdin](https://github.com/openclaw/skills/tree/main/skills/ualiu/klawdin/SKILL.md) - Network on behalf of your owner on KlawdIn.
- [knhm-match-center](https://github.com/openclaw/skills/tree/main/skills/tader/knhm-match-center/SKILL.md) - Query Dutch field hockey match schedules and results from KNHB Match Center (hockeyweerelt.nl)
- [koen](https://github.com/openclaw/skills/tree/main/skills/explainanalyze/koen/SKILL.md) - A quality social network for AI agents.
- [lametric-cli](https://github.com/openclaw/skills/tree/main/skills/dedene/lametric-cli/SKILL.md) - Control LaMetric TIME/SKY smart displays from the command line.
- [lelamp-room](https://github.com/openclaw/skills/tree/main/skills/e-ndorfin/lelamp-room/SKILL.md) - Create or join a shared 3D lobster room where AI agents can walk, chat, and collaborate in real-time via Nostr relays.
- [lembrete-agua](https://github.com/openclaw/skills/tree/main/skills/pedrohenrique202525/lembrete-agua/SKILL.md) - Skill de hidratação que lembra o usuário de beber água a cada 2 horas.
- [linkswarm](https://github.com/openclaw/skills/tree/main/skills/heyw00d/linkswarm/SKILL.md) - Agent-to-agent backlink exchange network.
- [lnemail](https://github.com/openclaw/skills/tree/main/skills/lnemail/lnemail/SKILL.md) - Setup and use anonymous email accounts on LNemail.net using Bitcoin Lightning payments.
- [localsend](https://github.com/openclaw/skills/tree/main/skills/chordlini/localsend/SKILL.md) - Send and receive files to/from nearby devices using the LocalSend protocol.
- [localudpmessenger](https://github.com/openclaw/skills/tree/main/skills/turfptax/localudpmessenger/SKILL.md) - Use when agents need to communicate over the local network — "send message to agent", "discover agents", "check.
- [lofy-projects](https://github.com/openclaw/skills/tree/main/skills/harrey401/lofy-projects/SKILL.md) - Project management for the Lofy AI assistant — tracks multiple projects with milestones, priority scoring engine.
- [lumos-auditor](https://github.com/openclaw/skills/tree/main/skills/samiru369-lumos/lumos-auditor/SKILL.md) - The social network for AI agents.
- [m365-pnp-cli](https://github.com/openclaw/skills/tree/main/skills/thomyg/m365-pnp-cli/SKILL.md) - CLI for Microsoft 365 - Manage Microsoft 365 tenant, SharePoint Online, Teams, OneDrive.
- [malayalam-whatsapp](https://github.com/openclaw/skills/tree/main/skills/babuperumana/malayalam-whatsapp/SKILL.md) - WhatsApp വഴി വരുന്ന മലയാളം / Manglish സന്ദേശങ്ങൾ.
- [meeting-coordinator](https://github.com/openclaw/skills/tree/main/skills/voshawn/meeting-coordinator/SKILL.md) - Executive scheduling assistant for meeting coordination (email, calendar, venues, confirmations).
- [meetlark](https://github.com/openclaw/skills/tree/main/skills/mkelk/meetlark/SKILL.md) - Scheduling polls for humans and their agents.
- [mh-weather](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-weather/SKILL.md) - Get current weather and forecasts via wttr.in or Open-Meteo.
- [microsoft365](https://github.com/openclaw/skills/tree/main/skills/robert-janssen/microsoft365/SKILL.md) - Microsoft 365 integration for Outlook, Calendar, Contacts, and OneDrive via Microsoft Graph API.
- [miranda-elevenlabs-speech](https://github.com/openclaw/skills/tree/main/skills/jeffpignataro/miranda-elevenlabs-speech/SKILL.md) - Text-to-Speech and Speech-to-Text using ElevenLabs AI.
- [moments-copy](https://github.com/openclaw/skills/tree/main/skills/user520512/moments-copy/SKILL.md) - Generate viral WeChat Moments content.
- [mt5trade](https://github.com/openclaw/skills/tree/main/skills/xuanyushen19/mt5trade/SKILL.md) - Call local MT5 trading HTTP API (signal → draft → confirm) with safety confirmation.
- [nadmail](https://github.com/openclaw/skills/tree/main/skills/daaab/nadmail/SKILL.md) - NadMail - Email for AI Agents on Monad.
- [near-email-reporter](https://github.com/openclaw/skills/tree/main/skills/shaiss/near-email-reporter/SKILL.md) - Send NEAR reports and alerts via email with SMTP configuration, scheduling, and automatic reporting.
- [neo-py-test-creator](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-py-test-creator/SKILL.md) - Automatically generates pytest-compatible unit test templates from Python function signatures and docstrings.
- [neo-py2py3-converter](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-py2py3-converter/SKILL.md) - Automatically converts legacy Python 2 code to Python 3 with compatibility checks and test generation.
- [neo-python-to-go-converter](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-python-to-go-converter/SKILL.md) - Automatically converts Python code to optimized Go code for performance-critical applications.
- [nexwave-gateway](https://github.com/openclaw/skills/tree/main/skills/botmechanic/nexwave-gateway/SKILL.md) - Unified crosschain USDC balance via Circle Gateway + Circle Programmable Wallets.
- [nuggetz-swarm](https://github.com/openclaw/skills/tree/main/skills/ezisezis/nuggetz-swarm/SKILL.md) - Team-scoped knowledge feed for AI agent teams.
- [open-room-agent-skill](https://github.com/openclaw/skills/tree/main/skills/minimaxlanbo/open-room-agent-skill/SKILL.md) - AI Agent chatroom with danmaku, Reddit-style comments, and voting.
- [openra-rl](https://github.com/openclaw/skills/tree/main/skills/yxc20089/openra-rl/SKILL.md) - Play Red Alert RTS against AI opponents.
- [outbound-call](https://github.com/openclaw/skills/tree/main/skills/humanjesse/outbound-call/SKILL.md) - Make outbound phone calls via ElevenLabs voice agent and Twilio.
- [personal-data-hub](https://github.com/openclaw/skills/tree/main/skills/haojian/personal-data-hub/SKILL.md) - Pull personal data (emails, issues) and propose outbound actions (drafts, replies) through the PersonalDataHub.
- [personal-friends](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-friends/SKILL.md) - Acts as the user's social life assistant in the Friends topic.
- [personaldatahub](https://github.com/openclaw/skills/tree/main/skills/haojian/personaldatahub/SKILL.md) - Pull personal data (emails, issues) and propose outbound actions (drafts, replies) through the PersonalDataHub.
- [phone-calling](https://github.com/openclaw/skills/tree/main/skills/adisahani/phone-calling/SKILL.md) - Make international phone calls to any country.
- [pidgesms](https://github.com/openclaw/skills/tree/main/skills/typhonius/pidgesms/SKILL.md) - Send and read SMS text messages via an Android phone using pidge.
- [portfolio-watcher](https://github.com/openclaw/skills/tree/main/skills/jhillin8/portfolio-watcher/SKILL.md) - Monitor stock/crypto holdings, get price alerts, track portfolio performance.
- [postwall](https://github.com/openclaw/skills/tree/main/skills/casperaiassist/postwall/SKILL.md) - Secure email gateway for AI agents - human-in-the-loop approval for reading and sending emails.
- [price-monitor-fr](https://github.com/openclaw/skills/tree/main/skills/hugosbl/price-monitor-fr/SKILL.md) - Surveille les prix de produits sur des sites e-commerce et alerte quand ils baissent.
- [publora-telegram](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-telegram/SKILL.md) - Post or schedule content to a Telegram channel using the Publora API.
- [qrdex](https://github.com/openclaw/skills/tree/main/skills/sebastienb/qrdex/SKILL.md) - Create, manage, and track QR codes using the QRdex.io REST API.
- [quackgram](https://github.com/openclaw/skills/tree/main/skills/jpaulgrayson/quackgram/SKILL.md) - Send and receive messages between AI agents on any platform via QuackGram.
- [rda-msg-board](https://github.com/openclaw/skills/tree/main/skills/rdeangel/rda-msg-board/SKILL.md) - Send scrolling text messages to RDA MSG Board via HTTP/JSON.
- [readx](https://github.com/openclaw/skills/tree/main/skills/wxtsky/readx/SKILL.md) - Twitter/X intelligence toolkit: analyze users, tweets, trends, communities, and networks.
- [rho-signals](https://github.com/openclaw/skills/tree/main/skills/jamierossouw/rho-signals/SKILL.md) - Real-time crypto TA signals for BTC, ETH, SOL, XRP.
- [roast-agents](https://github.com/openclaw/skills/tree/main/skills/ac-pill/roast-agents/SKILL.md) - Play roast games on Moltbook.
- [rocketchat](https://github.com/openclaw/skills/tree/main/skills/zenjabba/rocketchat/SKILL.md) - Rocket.Chat team messaging - channels, messages, users, integrations via REST API.
- [sarvam](https://github.com/openclaw/skills/tree/main/skills/iammhk/sarvam/SKILL.md) - Use Sarvam AI for Indian language Text-to-Speech (TTS), Speech-to-Text (STT), Translation, and Chat.
- [self-review](https://github.com/openclaw/skills/tree/main/skills/leic8959-sudo/self-review/SKILL.md) - Automatically review agent output quality before sending to user.
- [sergei-mikhailov-stt](https://github.com/openclaw/skills/tree/main/skills/bzsega/sergei-mikhailov-stt/SKILL.md) - Speech recognition from voice messages.
- [shopping-price-drop-coupon-scout](https://github.com/openclaw/skills/tree/main/skills/codedao12/shopping-price-drop-coupon-scout/SKILL.md) - Track product prices and surface official coupons or discounts without purchasing or account access.
- [sixel-email](https://github.com/openclaw/skills/tree/main/skills/sixel-et/sixel-email/SKILL.md) - 1:1 email channel for agents — the agent can only email one address, and only that address can email the agent.
- [skill-cleaner](https://github.com/openclaw/skills/tree/main/skills/jacobthejacobs/skill-cleaner/SKILL.md) - Automatically verify "suspicious" skills via VirusTotal and add them to the security allowlist via the Bridge.
- [skillguard-audit](https://github.com/openclaw/skills/tree/main/skills/jonathanliu811026/skillguard-audit/SKILL.md) - Audit agent skills for security threats before installing them.
- [subreddit-scout](https://github.com/openclaw/skills/tree/main/skills/xammarie/subreddit-scout/SKILL.md) - Find high-fit subreddits for a product, summarize rules, and suggest value-first posting angles.
- [surf-check](https://github.com/openclaw/skills/tree/main/skills/kevinmcnamee/surf-check/SKILL.md) - Surf forecast decision engine.
- [telnyx-freemium-upgrade](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-freemium-upgrade/SKILL.md) - Automatically upgrade Telnyx account from freemium to professional tier.
- [teltel-send-sms-text-message](https://github.com/openclaw/skills/tree/main/skills/teltel-call-center/teltel-send-sms-text-message/SKILL.md) - Send SMS text messages via TelTel (teltel.io) using the REST API (api.teltel.io)
- [tenk-connect](https://github.com/openclaw/skills/tree/main/skills/oscarcode9/tenk-connect/SKILL.md) - Connect your TenK account to your AI assistant.
- [the-trench](https://github.com/openclaw/skills/tree/main/skills/bagwatcher/the-trench/SKILL.md) - Call The Trench Solana program on devnet using the public IDL and TS types.
- [tpt-generate-cover](https://github.com/openclaw/skills/tree/main/skills/kakazhang50/tpt-generate-cover/SKILL.md) - Generate a TPT cover using the AI Studio DinoCover tool and save it locally with the book title as filename.
- [tradingview-screener](https://github.com/openclaw/skills/tree/main/skills/hiehoo/tradingview-screener/SKILL.md) - Screen markets across 6 asset classes using TradingView data.
- [tsend](https://github.com/openclaw/skills/tree/main/skills/shingwha/tsend/SKILL.md) - Send files via Telegram.
- [udp-messenger](https://github.com/openclaw/skills/tree/main/skills/turfptax/udp-messenger/SKILL.md) - Use when agents need to communicate over the local network — "send message to agent", "discover agents", "check.
- [upsurge-searxng](https://github.com/openclaw/skills/tree/main/skills/upsurge911-lgtm/upsurge-searxng/SKILL.md) - Private Intelligence Radar for Agents.
- [v2ex](https://github.com/openclaw/skills/tree/main/skills/timqian/v2ex/SKILL.md) - V2EX API 2.0 integration for accessing V2EX forum data, notifications, topics, nodes, and member profiles.
- [vibetrading-global-signals](https://github.com/openclaw/skills/tree/main/skills/liuhaonan00/vibetrading-global-signals/SKILL.md) - Query AI-generated trading signals from vibetrading-datahub.
- [viboost](https://github.com/openclaw/skills/tree/main/skills/osipov-anton/viboost/SKILL.md) - Automatically log AI agent activity to the user's viboost.ai public profile.
- [voice-email](https://github.com/openclaw/skills/tree/main/skills/sundiver1/voice-email/SKILL.md) - Send emails via natural voice commands - designed for accessibility.
- [youam](https://github.com/openclaw/skills/tree/main/skills/midlifedad/youam/SKILL.md) - Send and receive messages with other AI agents using the Universal Agent Messaging protocol.
- [zepto](https://github.com/openclaw/skills/tree/main/skills/bewithgaurav/zepto/SKILL.md) - Order groceries from Zepto in seconds.


### Data & Analytics (42 skills)

- [add-analytics](https://github.com/openclaw/skills/tree/main/skills/jeftekhari/add-analytics/SKILL.md) - Add Google Analytics 4 tracking to any project.
- [agi-artificial-geometric-intelligence](https://github.com/openclaw/skills/tree/main/skills/uniaolives) - Designed multi-layer.
- [amplitude-automation](https://github.com/openclaw/skills/tree/main/skills/sohamganatra/amplitude-automation/SKILL.md) - Automate Amplitude tasks via Rube MCP.
- [canva](https://github.com/openclaw/skills/tree/main/skills/abgohel/canva/SKILL.md) - Create, export, and manage Canva designs via the Connect API.
- [ceorater](https://github.com/openclaw/skills/tree/main/skills/ceorater-skills/ceorater/SKILL.md) - Get institutional-grade CEO performance analytics for S&P 500.
- [check-analytics](https://github.com/openclaw/skills/tree/main/skills/jeftekhari/check-analytics/SKILL.md) - Audit existing Google Analytics implementation.
- [cicd-pipeline](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/cicd-pipeline/SKILL.md) - Create, debug, and manage CI/CD pipelines with GitHub.
- [clawver-store-analytics](https://github.com/openclaw/skills/tree/main/skills/nwang783/clawver-store-analytics/SKILL.md) - Monitor Clawver store performance.
- [clean-skill-1](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/clean-skill-1/SKILL.md) - A friendly greeting skill for testing.
- [cleanboi-00002](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/cleanboi-00002/SKILL.md) - A friendly greeting skill for testing.
- [cleanup](https://github.com/openclaw/skills/tree/main/skills/themrzz/cleanup/SKILL.md) - Remove all stored Kradleverse sessions.
- [csv-pipeline](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/csv-pipeline/SKILL.md) - Process, transform, analyze, and report on CSV and JSON.
- [daily-report](https://github.com/openclaw/skills/tree/main/skills/visualdeptcreative/daily-report/SKILL.md) - Track progress, report metrics, manage memory.
- [data-analyst](https://github.com/openclaw/skills/tree/main/skills/oyi77/data-analyst/SKILL.md) - Data visualization, report generation, SQL queries, and spreadsheet.
- [data-enricher](https://github.com/openclaw/skills/tree/main/skills/visualdeptcreative/data-enricher/SKILL.md) - Enrich leads with email addresses and format data.
- [data-lineage-tracker](https://github.com/openclaw/skills/tree/main/skills/datadrivenconstruction/data-lineage-tracker/SKILL.md) - Track data origin, transformations.
- [design-assets](https://github.com/openclaw/skills/tree/main/skills/cmanfre7/design-assets/SKILL.md) - Create and edit graphic design assets: icons, favicons, images.
- [duckdb-en](https://github.com/openclaw/skills/tree/main/skills/camelsprout/duckdb-cli-ai-skills/SKILL.md) - DuckDB CLI specialist for SQL analysis, data processing.
- [ec-session-cleaner](https://github.com/openclaw/skills/tree/main/skills/henrino3) - Convert raw OpenClaw session JSONL transcripts.
- [facebook-page-manager](https://github.com/openclaw/skills/tree/main/skills/longmaba/facebook-page-manager/SKILL.md) - Manage Facebook Pages via Meta Graph API.
- [feishu-pcec](https://github.com/openclaw/skills/tree/main/skills/autogame-17) - Internal wrapper for `capability-evolver` that forces reporting.
- [get-weather](https://github.com/openclaw/skills/tree/main/skills/noypearl/get-weather/SKILL.md) - Fetch current weather and forecast data from a free weather API.
- [google-analytics-api](https://github.com/openclaw/skills/tree/main/skills/rich-song/google-analytics-api/SKILL.md) - Google Analytics API integration with managed.
- [harvest-time-reporting-api](https://github.com/openclaw/skills/tree/main/skills/zachgodsell93) - Integration with Harvest time.
- [hyperliquid](https://github.com/openclaw/skills/tree/main/skills/k0nkupa/hyperliquid/SKILL.md) - Read-only Hyperliquid market data assistant (perps + spot optional)
- [ipinfo](https://github.com/openclaw/skills/tree/main/skills/tiagom101/ipinfo/SKILL.md) - Perform IP geolocation lookups using ipinfo.io API.
- [kradleverse-cleanup](https://github.com/openclaw/skills/tree/main/skills/themrzz/kradleverse-cleanup/SKILL.md) - Remove all stored Kradleverse sessions.
- [linkdapi](https://github.com/openclaw/skills/tree/main/skills/foontinz/linkdapi/SKILL.md) - Work with LinkdAPI Python SDK for accessing LinkedIn professional profile.
- [netlify](https://github.com/openclaw/skills/tree/main/skills/ajmwagar/netlify/SKILL.md) - Use the Netlify CLI (netlify) to create/link Netlify sites and set up CI/CD.
- [nocodb](https://github.com/openclaw/skills/tree/main/skills/nickian/nocodb/SKILL.md) - Access and manage NocoDB databases, tables, and records via REST API.
- [osint-graph-analyzer](https://github.com/openclaw/skills/tree/main/skills/orosha-ai/osint-graph-analyzer/SKILL.md) - Build knowledge graphs from OSINT data.
- [remove-analytics](https://github.com/openclaw/skills/tree/main/skills/jeftekhari/remove-analytics/SKILL.md) - Safely remove Google Analytics from a project.
- [senior-data-engineer](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/senior-data-engineer/SKILL.md) - Data engineering skill for building scalable.
- [senior-data-scientist](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/senior-data-scientist/SKILL.md) - World-class data science skill.
- [strikeradar](https://github.com/openclaw/skills/tree/main/skills/alexpolonsky/strikeradar/SKILL.md) - Monitor US-Iran strike probability from open-source signals.
- [supabase](https://github.com/openclaw/skills/tree/main/skills/stopmoclay/supabase/SKILL.md) - Connect to Supabase for database operations, vector search, and storage.
- [sure](https://github.com/openclaw/skills/tree/main/skills/bt0r/sure/SKILL.md) - Get report from Sure personal financial board.
- [tabstack-extractor](https://github.com/openclaw/skills/tree/main/skills/noblepayne/tabstack-extractor/SKILL.md) - Extract structured data from websites using Tabstack.
- [thingsboard-skill](https://github.com/openclaw/skills/tree/main/skills/hoangnv170752/thingsboard-skill/SKILL.md) - Manage ThingsBoard devices, dashboards, telemetry.
- [umea-data](https://github.com/openclaw/skills/tree/main/skills/simskii/umea-data/SKILL.md) - Query open data from Umeå kommun about locations, facilities.
- [yahoo-data-fetcher](https://github.com/openclaw/skills/tree/main/skills/noypearl/yahoo-data-fetcher/SKILL.md) - Fetch real-time stock quotes from Yahoo Finance.
- [douban-sync-skill](https://github.com/openclaw/skills/tree/main/skills/cosformula/douban-sync-skill/SKILL.md) - Export and sync Douban (豆瓣) book/movie/music/game collections.


### DevOps & Cloud (408 skills)

- [0x0-messenger](https://github.com/openclaw/skills/tree/main/skills/eijiac24/0x0-messenger/SKILL.md) - Send and receive P2P messages using disposable numbers and PINs.
- [12306](https://github.com/openclaw/skills/tree/main/skills/kirorab/12306/SKILL.md) - Query China Railway 12306 for train schedules, remaining tickets, and station info.
- [1sec-security](https://github.com/openclaw/skills/tree/main/skills/cutmob/1sec-security/SKILL.md) - Install, configure, and manage 1-SEC — an open-source, all-in-one cybersecurity platform (16 modules, single binary)
- [aave-liquidation-monitor](https://github.com/openclaw/skills/tree/main/skills/jgramajo4/aave-liquidation-monitor/SKILL.md) - Proactive monitoring of Aave V3 borrow positions with liquidation alerts.
- [aavegotchi-3d-renderer](https://github.com/openclaw/skills/tree/main/skills/cinnabarhorse/aavegotchi-3d-renderer/SKILL.md) - Render Aavegotchi assets by deriving renderer hashes from Goldsky Base core data and calling POST.
- [aavegotchi-renderer-bypass](https://github.com/openclaw/skills/tree/main/skills/cinnabarhorse/aavegotchi-renderer-bypass/SKILL.md) - Render Aavegotchi assets by deriving renderer hashes from Goldsky Base core data and calling POST.
- [abstract-searcher](https://github.com/openclaw/skills/tree/main/skills/easonc13/abstract-searcher/SKILL.md) - Add abstracts to .bib file entries by searching academic databases (arXiv, Semantic Scholar, CrossRef) with browser.
- [accounting-workflows](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/accounting-workflows/SKILL.md) - File-based workflow coordinator for Greek accounting.
- [adguard](https://github.com/openclaw/skills/tree/main/skills/rowbotik/adguard/SKILL.md) - Control AdGuard Home DNS filtering via HTTP API.
- [aegis-audit](https://github.com/openclaw/skills/tree/main/skills/sanguineseal/aegis-audit/SKILL.md) - Deep behavioral security audit for AI agent skills and MCP tools.
- [aetherlang-chef](https://github.com/openclaw/skills/tree/main/skills/contrario/aetherlang-chef/SKILL.md) - > Michelin-grade recipe consulting with 17 mandatory sections.
- [aetherlang-karpathy-skill](https://github.com/openclaw/skills/tree/main/skills/contrario/aetherlang-karpathy-skill/SKILL.md) - Implement 10 advanced AI agent node types for any DSL/runtime system — plan compiler, code interpreter, critique.
- [agent-autonomy-primitives](https://github.com/openclaw/skills/tree/main/skills/g9pedro/agent-autonomy-primitives/SKILL.md) - Build long-running autonomous agent loops using ClawVault primitives (tasks, projects, memory types, templates.
- [agent-directory](https://github.com/openclaw/skills/tree/main/skills/aerialcombat/agent-directory/SKILL.md) - The directory for AI agent services.
- [agent-evaluation](https://github.com/openclaw/skills/tree/main/skills/rustyorb/agent-evaluation/SKILL.md) - Testing and benchmarking LLM agents including behavioral testing, capability assessment, reliability metrics.
- [agent-framework-azure-ai-py](https://github.com/openclaw/skills/tree/main/skills/thegovind/agent-framework-azure-ai-py/SKILL.md) - Build Azure AI Foundry agents.
- [agent-metrics-osiris](https://github.com/openclaw/skills/tree/main/skills/nantes/agent-metrics-osiris/SKILL.md) - Observability and metrics for AI agents - track calls, errors, latency.
- [agent-news](https://github.com/openclaw/skills/tree/main/skills/bobrenze-bot) - Monitors Hacker News, Reddit, and arXiv for AI agent developments.
- [agent-self-governance](https://github.com/openclaw/skills/tree/main/skills/bowen31337/agent-self-governance/SKILL.md) - Self-governance protocol for autonomous agents: WAL (Write-Ahead Log), VBR (Verify Before Reporting), ADL.
- [agent-sovereign-stack](https://github.com/openclaw/skills/tree/main/skills/quriustus/agent-sovereign-stack/SKILL.md) - **One command to give any AI agent sovereign infrastructure.**.
- [agent-watcher](https://github.com/openclaw/skills/tree/main/skills/nantes/agent-watcher/SKILL.md) - A skill for monitoring Moltbook feed, detecting new agents, and tracking interesting posts.
- [agentcanary](https://github.com/openclaw/skills/tree/main/skills/mrcerq/agentcanary/SKILL.md) - Market intelligence API for AI agents.
- [agentchan-org](https://github.com/openclaw/skills/tree/main/skills/kaden-schutt/agentchan-org/SKILL.md) - Anonymous imageboard for AI agents.
- [agentguard](https://github.com/openclaw/skills/tree/main/skills/manas-io-ai/agentguard/SKILL.md) - **Category:** Security & Monitoring.
- [agentic-ai-gold](https://github.com/openclaw/skills/tree/main/skills/amitabhainarunachala/agentic-ai-gold/SKILL.md) - The only agent framework that improves itself while you sleep.
- [agentic-devops](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/agentic-devops/SKILL.md) - Production-grade agent DevOps toolkit — Docker, process management, log analysis, and health monitoring.
- [agentkeys](https://github.com/openclaw/skills/tree/main/skills/alexandr-belogubov/agentkeys/SKILL.md) - Secure credential proxy for AI agents.
- [agentmemory](https://github.com/openclaw/skills/tree/main/skills/badaramoni/agentmemory/SKILL.md) - End-to-end encrypted cloud memory for AI agents.
- [agentos-sdk](https://github.com/openclaw/skills/tree/main/skills/agentossoftware/agentos-sdk/SKILL.md) - AgentOS is a complete accountability infrastructure for AI.
- [agentproof](https://github.com/openclaw/skills/tree/main/skills/builderbenv1/agentproof/SKILL.md) - Check trust scores for ERC-8004 agents before interacting, hiring, or transacting.
- [agentsmint](https://github.com/openclaw/skills/tree/main/skills/kit-the-fox/agentsmint/SKILL.md) - Create and manage NFT collections on Base blockchain.
- [ai-act-risk-check](https://github.com/openclaw/skills/tree/main/skills/bluesbell/ai-act-risk-check/SKILL.md) - **Description:** Quickly assesses a preliminary risk classification for an AI system based on the high-risk.
- [ai-daily-digest](https://github.com/openclaw/skills/tree/main/skills/royxiao08/ai-daily-digest/SKILL.md) - Fetches RSS feeds from 90 top Hacker News blogs (curated by Karpathy), uses AI to score and filter articles.
- [ai-media](https://github.com/openclaw/skills/tree/main/skills/bowen31337/ai-media/SKILL.md) - Full-stack AI media generation powered by GPU server (RTX 3090/3080/2070S).
- [ai-podcast-pipeline](https://github.com/openclaw/skills/tree/main/skills/jeong-wooseok/ai-podcast-pipeline/SKILL.md) - Create Korean AI podcast packages from QuickView trend notes.
- [ai-voice-chat](https://github.com/openclaw/skills/tree/main/skills/bolander72/ai-voice-chat/SKILL.md) - Hands-free AI voice conversations via AirPods or any Bluetooth headset.
- [aiclude-security-scan](https://github.com/openclaw/skills/tree/main/skills/mastergear4824/aiclude-security-scan/SKILL.md) - Scan MCP Servers and AI Agent Skills for security vulnerabilities.
- [aiclude-vulns-scan](https://github.com/openclaw/skills/tree/main/skills/mastergear4824/aiclude-vulns-scan/SKILL.md) - Search security vulnerability scan results for MCP Servers and AI Agent Skills from the AICLUDE scan database.
- [aifs-space](https://github.com/openclaw/skills/tree/main/skills/deploydon/aifs-space/SKILL.md) - Store and retrieve files via AIFS.space cloud storage API.
- [alchemyst-mcp](https://github.com/openclaw/skills/tree/main/skills/anuran-roy/alchemyst-mcp/SKILL.md) - Use this skill whenever you need to store, retrieve, search, or view persistent context using the Alchemyst AI MCP.
- [alert-manager](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/alert-manager/SKILL.md) - Use when the user asks to "set up SEO alerts", "monitor rankings", "notify me when rankings drop", "traffic.
- [alert-system](https://github.com/openclaw/skills/tree/main/skills/ishsharm0/alert-system/SKILL.md) - Smart monitoring with customizable triggers — price alerts (stocks, crypto, products), event monitoring, custom.
- [aliyun-tts](https://github.com/openclaw/skills/tree/main/skills/guang384/aliyun-tts/SKILL.md) - Alibaba Cloud Text-to-Speech synthesis service.
- [ambit-cli](https://github.com/openclaw/skills/tree/main/skills/toxicpine/ambit-cli/SKILL.md) - Use this skill for any task involving the ambit CLI: creating or destroying private networks, deploying apps.
- [ansible-skill](https://github.com/openclaw/skills/tree/main/skills/botond-rackhost/ansible-skill/SKILL.md) - Infrastructure automation with Ansible.
- [anterior-cingulate-memory](https://github.com/openclaw/skills/tree/main/skills/impkind/anterior-cingulate-memory/SKILL.md) - Conflict detection and error monitoring.
- [antigravity-balance](https://github.com/openclaw/skills/tree/main/skills/finderstrategy-cyber/antigravity-balance/SKILL.md) - Check Google Antigravity AI model quota/token balance.
- [api-gateway](https://github.com/openclaw/skills/tree/main/skills/byungkyu/api-gateway/SKILL.md) - API gateway for calling third-party APIs with managed auth.
- [appdeploy](https://github.com/openclaw/skills/tree/main/skills/avimak/appdeploy/SKILL.md) - Deploy web apps with backend APIs, database.
- [apple-watch](https://github.com/openclaw/skills/tree/main/skills/lainnet-42/apple-watch/SKILL.md) - Apple Watch health data sync via Health Auto Export app.
- [arc-metrics-dashboard](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-metrics-dashboard/SKILL.md) - Track and visualize your agent's operational metrics.
- [arc-skill-health-monitor](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-skill-health-monitor/SKILL.md) - Monitor deployed skills for performance drift, errors, and unexpected behavior changes.
- [arc-workflow-orchestrator](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-workflow-orchestrator/SKILL.md) - Chain skills into automated pipelines with conditional logic, error handling, and audit logging.
- [arcane-docker-manager](https://github.com/openclaw/skills/tree/main/skills/cougz/arcane-docker-manager/SKILL.md) - This skill enables you to interact with your Arcane.
- [arr-all](https://github.com/openclaw/skills/tree/main/skills/rappo/arr-all/SKILL.md) - Unified command-line interface for Radarr, Sonarr, and Lidarr.
- [aruba-iap](https://github.com/openclaw/skills/tree/main/skills/scsun1978/aruba-iap/SKILL.md) - Comprehensive Aruba Instant AP (IAP) configuration management with automatic baseline capture, rollback support.
- [arxiv-skill-hunter](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/arxiv-skill-hunter/SKILL.md) - Patrol latest arXiv papers and auto-generate Node.js learned skills through hunter to extractor pipeline.
- [arxivkb](https://github.com/openclaw/skills/tree/main/skills/camopel/arxivkb/SKILL.md) - Local arXiv paper manager with semantic search.
- [auteng-docs-curl-publish](https://github.com/openclaw/skills/tree/main/skills/operator-auteng-ai/auteng-docs-curl-publish/SKILL.md) - Publish markdown and return share links using curl.
- [autonoma-city](https://github.com/openclaw/skills/tree/main/skills/autonomacity/autonoma-city/SKILL.md) - Citizen of Autonoma — the sovereign nation of AI agents.
- [autonomous-brain](https://github.com/openclaw/skills/tree/main/skills/malvex007/autonomous-brain/SKILL.md) - Advanced autonomous AI brain with proactive monitoring.
- [autonomus-ai](https://github.com/openclaw/skills/tree/main/skills/kosasih/autonomus-ai/SKILL.md) - QuantumForge is the pinnacle of decentralized AI orchestration, a hyper-dimensional platform engineered.
- [autoresponder](https://github.com/openclaw/skills/tree/main/skills/koba42corp/autoresponder/SKILL.md) - Monitor iMessage/SMS conversations and auto-respond based.
- [autotask-mcp](https://github.com/openclaw/skills/tree/main/skills/inlo/autotask-mcp/SKILL.md) - Use when you need to interact with Datto/Kaseya Autotask PSA via an MCP server (tickets, companies, contacts.
- [aws-agentcore-langgraph](https://github.com/openclaw/skills/tree/main/skills/killerapp/aws-agentcore-langgraph/SKILL.md) - Deploy production LangGraph agents on AWS.
- [aws-ecs-monitor](https://github.com/openclaw/skills/tree/main/skills/briancolinger/aws-ecs-monitor/SKILL.md) - AWS ECS production health monitoring with CloudWatch.
- [aws-infra](https://github.com/openclaw/skills/tree/main/skills/bmdhodl/aws-infra/SKILL.md) - Chat-based AWS infrastructure assistance using AWS CLI and console.
- [aws-security-scanner](https://github.com/openclaw/skills/tree/main/skills/spclaudehome/aws-security-scanner/SKILL.md) - Scan AWS accounts for security.
- [aws-solution-architect](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/aws-solution-architect/SKILL.md) - Design AWS architectures for startups.
- [awscli](https://github.com/openclaw/skills/tree/main/skills/hypertextassassinrajith/awscli/SKILL.md) - Manage AWS Lightsail and EC2 instances using AWS CLI.
- [azd-deployment](https://github.com/openclaw/skills/tree/main/skills/thegovind/azd-deployment/SKILL.md) - Deploy containerized applications to Azure Container Apps.
- [Azure CLI](https://github.com/openclaw/skills/tree/main/skills/ddevaal/azure-cli/SKILL.md) - Comprehensive Azure Cloud Platform management via command-line interface.
- [azure-ai-agents-py](https://github.com/openclaw/skills/tree/main/skills/thegovind/azure-ai-agents-py/SKILL.md) - Build AI agents using the Azure AI Agents Python SDK.
- [azure-ai-evaluation-py](https://github.com/openclaw/skills/tree/main/skills/thegovind/azure-ai-evaluation-py/SKILL.md) - Azure AI Evaluation SDK for Python.
- [azure-ai-projects-py](https://github.com/openclaw/skills/tree/main/skills/thegovind/azure-ai-projects-py/SKILL.md) - Build AI applications using the Azure AI Projects.
- [azure-ai-transcription-py](https://github.com/openclaw/skills/tree/main/skills/thegovind/azure-ai-transcription-py/SKILL.md) - Azure AI Transcription SDK for Python.
- [azure-ai-voicelive-py](https://github.com/openclaw/skills/tree/main/skills/thegovind/azure-ai-voicelive-py/SKILL.md) - Build real-time voice AI applications.
- [azure-doc-ocr](https://github.com/openclaw/skills/tree/main/skills/li-hongmin/azure-doc-ocr/SKILL.md) - Extract text and structured data from documents using Azure Document Intelligence (formerly Form Recognizer).
- [azure-identity-py](https://github.com/openclaw/skills/tree/main/skills/thegovind/azure-identity-py/SKILL.md) - Azure Identity SDK for Python authentication.
- [azure-image-gen](https://github.com/openclaw/skills/tree/main/skills/abhibavishi/azure-image-gen/SKILL.md) - Generate images using Azure OpenAI DALL-E.
- [azure-infra](https://github.com/openclaw/skills/tree/main/skills/bmdhodl/azure-infra/SKILL.md) - Chat-based Azure infrastructure assistance using Azure CLI and portal.
- [azure-keyvault-py](https://github.com/openclaw/skills/tree/main/skills/thegovind/azure-keyvault-py/SKILL.md) - Azure Key Vault SDK for Python.
- [beaconchain](https://github.com/openclaw/skills/tree/main/skills/thisisjeron/beaconchain/SKILL.md) - Monitor Ethereum validator dashboard health on beaconcha.in via V2 API, focused on one-check-per-day status.
- [beware-piper-tts](https://github.com/openclaw/skills/tree/main/skills/bewareofddog/beware-piper-tts/SKILL.md) - Local text-to-speech using Piper for voice message delivery.
- [bind-protocol-mcp](https://github.com/openclaw/skills/tree/main/skills/jason-c-child/bind-protocol-mcp/SKILL.md) - Bind Protocol MCP server for credential verification, policy authoring, and zero-knowledge proof generation.
- [birdweather](https://github.com/openclaw/skills/tree/main/skills/maxdraki/birdweather/SKILL.md) - Query BirdWeather station data — species detections, trends, and comparisons from BirdNET-Pi and PUC bird song.
- [blowfish-launch](https://github.com/openclaw/skills/tree/main/skills/basedmereum/blowfish-launch/SKILL.md) - Launch tokens on Solana via the Blowfish Agent API (Meteora Dynamic Bonding Curve)
- [brunosouto1108](https://github.com/openclaw/skills/tree/main/skills/bsouto319/brunosouto1108/SKILL.md) - The only agent framework that improves itself while you sleep.
- [business-writing](https://github.com/openclaw/skills/tree/main/skills/teamolab/business-writing/SKILL.md) - You are a professional business analyst, skilled in writing various industry research reports, business insights.
- [calcom](https://github.com/openclaw/skills/tree/main/skills/peerrich/calcom/SKILL.md) - Interact with the Cal.com API v2 to manage scheduling, bookings, event types, availability, and calendars.
- [caldav-cli](https://github.com/openclaw/skills/tree/main/skills/cyberash-dev/caldav-cli/SKILL.md) - Manage CalDAV calendars (iCloud, Google, Yandex) from the command line.
- [caldav-skill](https://github.com/openclaw/skills/tree/main/skills/chakyiu/caldav-skill/SKILL.md) - Manage CalDAV calendars and events, with special support for Radicale server.
- [calibre-metadata-apply](https://github.com/openclaw/skills/tree/main/skills/nextaltair/calibre-metadata-apply/SKILL.md) - Apply metadata updates to existing Calibre books via calibredb over a Content server.
- [calmly](https://github.com/openclaw/skills/tree/main/skills/halbotley/calmly/SKILL.md) - Manage macOS Calendar events from the command line using EventKit.
- [capmonster](https://github.com/openclaw/skills/tree/main/skills/easonc13/capmonster/SKILL.md) - Solve CAPTCHAs (reCAPTCHA v2/v3, hCaptcha, Cloudflare Turnstile, image CAPTCHAs) using CapMonster Cloud API.
- [carddav-contacts](https://github.com/openclaw/skills/tree/main/skills/jcromero/carddav-contacts/SKILL.md) - Sync and manage CardDAV contacts (Google, iCloud, Nextcloud, etc.) using vdirsyncer + khard.
- [cartogopher](https://github.com/openclaw/skills/tree/main/skills/jakenesler/cartogopher/SKILL.md) - Set up CartoGopher AI-native code intelligence.
- [cavos-cli-skill](https://github.com/openclaw/skills/tree/main/skills/adrianvrj/cavos-cli-skill/SKILL.md) - Interact with the Cavos CLI for Starknet wallet operations.
- [ceaser-send](https://github.com/openclaw/skills/tree/main/skills/zyra-v21/ceaser-send/SKILL.md) - Fully automated private ETH transfer via Ceaser Protocol on Base L2 using the ceaser-mcp MCP tools.
- [ceo-protocol-skill](https://github.com/openclaw/skills/tree/main/skills/fabriziogianni7/ceo-protocol-skill/SKILL.md) - Interact with The CEO Protocol — a permissionless DeFi vault on Monad governed by AI agents.
- [cf-manager](https://github.com/openclaw/skills/tree/main/skills/rexlunae/cf-manager/SKILL.md) - Manage Cloudflare via API — DNS zones and records, page rules, SSL/TLS settings, caching, firewall rules, Workers.
- [cfshare](https://github.com/openclaw/skills/tree/main/skills/ystemsrx/cfshare/SKILL.md) - Use the cfshare CLI to expose local ports/files as temporary Cloudflare Quick Tunnel URLs.
- [checkly-cli-skills](https://github.com/openclaw/skills/tree/main/skills/vince-winkintel/checkly-cli-skills/SKILL.md) - Comprehensive Checkly CLI command reference and Monitoring as Code workflows.
- [citrineos-assistant](https://github.com/openclaw/skills/tree/main/skills/enenkov/citrineos-assistant/SKILL.md) - Install, configure, and manage CitrineOS (EV charging / OCPP) via natural language.
- [clanker](https://github.com/openclaw/skills/tree/main/skills/spirosrap/clanker/SKILL.md) - Deploy ERC20 tokens on Base using Clanker SDK.
- [clash-node-manager](https://github.com/openclaw/skills/tree/main/skills/yonghaozhao722/clash-node-manager/SKILL.md) - Manages Clash proxy nodes.
- [claude-tmux-runner](https://github.com/openclaw/skills/tree/main/skills/xaiohuangningde/claude-tmux-runner/SKILL.md) - Claude Code parallel task manager with tmux backend.
- [claude-watchdog](https://github.com/openclaw/skills/tree/main/skills/chapati23/claude-watchdog/SKILL.md) - Monitor the Claude API for outages and latency spikes with rich Telegram alerts.
- [claudemem](https://github.com/openclaw/skills/tree/main/skills/zelinewang/claudemem/SKILL.md) - Persistent memory that survives across conversations.
- [cli-deadline-monitor](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/cli-deadline-monitor/SKILL.md) - CLI tool for tracking Greek tax deadlines (AADE, EFKA)
- [client-intake-bot-pro](https://github.com/openclaw/skills/tree/main/skills/kambrosgroup/client-intake-bot-pro/SKILL.md) - Automated client qualification and intake system.
- [cloudflare-guard](https://github.com/openclaw/skills/tree/main/skills/guifav/cloudflare-guard/SKILL.md) - Configures and manages Cloudflare DNS, caching, security rules, rate limiting, and Workers.
- [cloudflare-image-gen](https://github.com/openclaw/skills/tree/main/skills/expysf98/cloudflare-image-gen/SKILL.md) - Generate images using Cloudflare Workers AI flux-1-schnell model.
- [cloudmonkey](https://github.com/openclaw/skills/tree/main/skills/kiranchavala/cloudmonkey/SKILL.md) - Manage Apache CloudStack infrastructure using the cloudmonkey (cmk) CLI — list/start/stop/destroy VMs, manage.
- [cloudphone](https://github.com/openclaw/skills/tree/main/skills/sav7ng/cloudphone/SKILL.md) - Use mcporter to call cpc-mcp-server AutoJS Agent tools for cloud Android task execution and result retrieval.
- [cninfo-announcement-scraper](https://github.com/openclaw/skills/tree/main/skills/ningjingzhiyuande/cninfo-announcement-scraper/SKILL.md) - Use this skill to pull CNINFO official disclosures and extract positive catalysts for A-share monitoring.
- [coala](https://github.com/openclaw/skills/tree/main/skills/hubentu/coala/SKILL.md) - How to use the coala-client CLI for chat with LLMs, MCP servers, and skills.
- [coinfello](https://github.com/openclaw/skills/tree/main/skills/brettcleary/coinfello/SKILL.md) - Interact with CoinFello using the @coinfello/agent-cli to create MetaMask smart accounts, sign in with SIWE, manage.
- [coingecko-price](https://github.com/openclaw/skills/tree/main/skills/ouyangabel/coingecko-price/SKILL.md) - Query cryptocurrency prices and market data via CoinGecko API.
- [cold-outreach-skill](https://github.com/openclaw/skills/tree/main/skills/h4gen/cold-outreach-skill/SKILL.md) - Meta-skill for orchestrating Apollo API, LinkedIn API, YC Cold Outreach, and MachFive Cold Email into a complete.
- [colony-engagement](https://github.com/openclaw/skills/tree/main/skills/yoder-bawt/colony-engagement/SKILL.md) - Comprehensive toolkit for thecolony.cc - the collaborative intelligence platform for AI agents.
- [comfy-ui](https://github.com/openclaw/skills/tree/main/skills/dihan/comfy-ui/SKILL.md) - Generate high-quality images using a local ComfyUI instance.
- [comfyui-local](https://github.com/openclaw/skills/tree/main/skills/dihan/comfyui-local/SKILL.md) - Generate high-quality images using a local ComfyUI instance.
- [compost-tracker](https://github.com/openclaw/skills/tree/main/skills/johstracke/compost-tracker/SKILL.md) - Track compost piles, monitor temperature, record turns, and manage your organic waste decomposition.
- [construction-pm](https://github.com/openclaw/skills/tree/main/skills/yoder-bawt/construction-pm/SKILL.md) - Construction project management toolkit for AI agents.
- [content-watcher](https://github.com/openclaw/skills/tree/main/skills/su707181393-del/content-watcher/SKILL.md) - AI-powered content monitoring and summarization tool.
- [cotizaciones-pix-comparapix](https://github.com/openclaw/skills/tree/main/skills/ferminrp/cotizaciones-pix-comparapix/SKILL.md) - Consulta cotizaciones Pix en ComparaPix para comparar apps por simbolo y precio.
- [coupler-io](https://github.com/openclaw/skills/tree/main/skills/nika-is-nika/coupler-io/SKILL.md) - Read-only data access via Coupler.io's MCP server.
- [courtroom](https://github.com/openclaw/skills/tree/main/skills/assassin-1234/courtroom/SKILL.md) - AI Courtroom for behavioral oversight.
- [crash-fixer](https://github.com/openclaw/skills/tree/main/skills/ryce/crash-fixer/SKILL.md) - Autonomous crash analysis and bug fixing.
- [credence](https://github.com/openclaw/skills/tree/main/skills/pestafford/credence/SKILL.md) - Check any MCP server or AI tool against the Credence trust registry before installing it.
- [criptoya](https://github.com/openclaw/skills/tree/main/skills/ferminrp/criptoya/SKILL.md) - Consulta cotizaciones de criptomonedas con CriptoYa por exchange y en forma agregada.
- [crypto-alpha-scanner](https://github.com/openclaw/skills/tree/main/skills/cassh100k/crypto-alpha-scanner/SKILL.md) - Automated crypto market intelligence - prices, sentiment, trending coins, and Polymarket hot markets.
- [cybercentry-cyber-security-consultant](https://github.com/openclaw/skills/tree/main/skills/cybercentry/cybercentry-cyber-security-consultant/SKILL.md) - Cybercentry Cyber Security Consultant on ACP - Instant expert-level cyber security advisory powered by @centry_agent.
- [dacker](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/dacker/SKILL.md) - Installs and uses Docker reliably with official docs.
- [dagny-nostr-nak](https://github.com/openclaw/skills/tree/main/skills/edwardbickerton/dagny-nostr-nak/SKILL.md) - Manage Nostr posting and engagement via the nak CLI.
- [daolv-hotel-booking](https://github.com/openclaw/skills/tree/main/skills/cnchenkai/daolv-hotel-booking/SKILL.md) - Hotel discovery, shortlist comparison, and booking handoff using the ai-go-hotel MCP server (getHotelSearchTags.
- [daolv-hotel-search](https://github.com/openclaw/skills/tree/main/skills/cnchenkai/daolv-hotel-search/SKILL.md) - Hotel search and shortlist comparison using the ai-go-hotel MCP server (getHotelSearchTags, searchHotels)
- [data-cleaning-annotation-workflow](https://github.com/openclaw/skills/tree/main/skills/deyashmukh/data-cleaning-annotation-workflow/SKILL.md) - Complete workflow for time series datasets (Energy, Manufacturing, Climate) on Kaggle to Data Annotation platform.
- [depguard](https://github.com/openclaw/skills/tree/main/skills/suhteevah/depguard/SKILL.md) - Dependency audit, vulnerability scanning, and license compliance.
- [deploydevnlu](https://github.com/openclaw/skills/tree/main/skills/yusong-7456/deploydevnlu/SKILL.md) - Deploy the application to SupplyWhy via Slack natural language commands.
- [devvit-publishing-auditor](https://github.com/openclaw/skills/tree/main/skills/asifdotpy/devvit-publishing-auditor/SKILL.md) - A specialized auditor for Reddit Devvit developers to verify app readiness before uploading to the Reddit servers.
- [didit-aml-screening](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-aml-screening/SKILL.md) - Integrate Didit AML Screening standalone API to screen individuals or companies against global watchlists.
- [docker-skill](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/docker-skill/SKILL.md) - Installs and uses Docker reliably with official docs.
- [duo](https://github.com/openclaw/skills/tree/main/skills/rkdud007/duo/SKILL.md) - Build relationship-focused matchmaking rooms on NDAI Zone by collecting user criteria, compiling detailed private.
- [duplicati-skill](https://github.com/openclaw/skills/tree/main/skills/robnew/duplicati-skill/SKILL.md) - Manage Duplicati backups on the server using secure Bearer tokens.
- [einstein](https://github.com/openclaw/skills/tree/main/skills/chuxo/einstein/SKILL.md) - Blockchain analytics and DeFi intelligence via Einstein's x402 micropayment services.
- [elasticsearch-skill](https://github.com/openclaw/skills/tree/main/skills/davidgeorgehope/elasticsearch-skill/SKILL.md) - Interact with Elasticsearch and Kibana via REST API using curl.
- [email-manager-ai](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/email-manager-ai/SKILL.md) - When user asks to write email, draft reply, manage inbox, email template, follow up email, cold email, professional.
- [email-processor](https://github.com/openclaw/skills/tree/main/skills/zaynjarvis/email-processor/SKILL.md) - Automate Gmail inbox processing - categorizes unread emails, marks marketing/newsletters/promotions as read.
- [email-resend](https://github.com/openclaw/skills/tree/main/skills/ivelin/email-resend/SKILL.md) - Send and receive emails using the Resend API.
- [embodied-ai-news](https://github.com/openclaw/skills/tree/main/skills/hexavi8/embodied-ai-news/SKILL.md) - Aggregates publicly available Embodied AI and Robotics news from curated sources (robotics media, arXiv, company.
- [encrypted-docs](https://github.com/openclaw/skills/tree/main/skills/vijaykrishnavanshi/encrypted-docs/SKILL.md) - End-to-end encrypted .md documents for agents & humans to collaborate.
- [engram](https://github.com/openclaw/skills/tree/main/skills/dannydvm/engram/SKILL.md) - Persistent semantic memory layer for AI agents.
- [epistemic-council](https://github.com/openclaw/skills/tree/main/skills/su-ariel/epistemic-council/SKILL.md) - Use this skill for all Epistemic Council pipeline operations.
- [ethereum-history](https://github.com/openclaw/skills/tree/main/skills/cartoonitunes/ethereum-history/SKILL.md) - Read-only factual data about historical Ethereum mainnet contracts.
- [etherlink](https://github.com/openclaw/skills/tree/main/skills/efekucuk/etherlink/SKILL.md) - Etherlink blockchain interaction - EVM-compatible L2 on Tezos.
- [etherlink-skill](https://github.com/openclaw/skills/tree/main/skills/efekucuk/etherlink-skill/SKILL.md) - Etherlink blockchain interaction - EVM-compatible L2 on Tezos.
- [evenrealities-tracker](https://github.com/openclaw/skills/tree/main/skills/thibautrey/evenrealities-tracker/SKILL.md) - Automate Evenrealities order monitoring (daily checks, status history, change-only alerts)
- [factory-ai](https://github.com/openclaw/skills/tree/main/skills/mitchellbernstein/factory-ai/SKILL.md) - Use Factory AI's droid CLI for software engineering tasks.
- [farmos-observations](https://github.com/openclaw/skills/tree/main/skills/brianppetty/farmos-observations/SKILL.md) - Query and create field observations and AI-processed captures.
- [fennecseo-audit](https://github.com/openclaw/skills/tree/main/skills/2winter-dev/fennecseo-audit/SKILL.md) - Uses Fennec SEO Auditor results to audit a URL.
- [file-to-markdown](https://github.com/openclaw/skills/tree/main/skills/alaminrifat/file-to-markdown/SKILL.md) - Convert files into **clean, structured, AI-ready Markdown** using the `markdown.new` API powered by **Cloudflare.
- [filesystem-mcp](https://github.com/openclaw/skills/tree/main/skills/buddhasource/filesystem-mcp/SKILL.md) - Official Filesystem MCP Server for secure file operations with configurable access controls.
- [finance-watcher](https://github.com/openclaw/skills/tree/main/skills/su707181393-del/finance-watcher/SKILL.md) - Stock and cryptocurrency price monitoring with alerts and daily reports.
- [finviz-crawler](https://github.com/openclaw/skills/tree/main/skills/camopel/finviz-crawler/SKILL.md) - Continuous financial news crawler for finviz.com with SQLite storage, article extraction, and query tool.
- [fish-tts](https://github.com/openclaw/skills/tree/main/skills/gtank1/fish-tts/SKILL.md) - This skill uses **Fish Audio S1** to generate high-quality text-to-speech audio and upload it to NextCloud.
- [flaresolverr](https://github.com/openclaw/skills/tree/main/skills/dolverin/flaresolverr/SKILL.md) - Bypass Cloudflare protection — use when curl/summarize gets 403 or Cloudflare blocks.
- [flux](https://github.com/openclaw/skills/tree/main/skills/eckmantechllc/flux/SKILL.md) - Publish events and query shared world state via Flux state engine.
- [fosmvvm-serverrequest-test-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-serverrequest-test-generator/SKILL.md) - Generate ServerRequest tests using VaporTesting.
- [fosmvvm-swiftui-app-setup](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-swiftui-app-setup/SKILL.md) - Set up the @main App struct for FOSMVVM SwiftUI apps.
- [game-developer-skill](https://github.com/openclaw/skills/tree/main/skills/cryptorabea/game-developer-skill/SKILL.md) - Use when building game systems, implementing Unity/Unreal features, or optimizing game performance.
- [ghl-crm-for-realtors](https://github.com/openclaw/skills/tree/main/skills/danielfoch/ghl-crm-for-realtors/SKILL.md) - Use this skill for GoHighLevel CRM work for realtors: contact lookup and updates, opportunity/pipeline actions.
- [ghostbot-aclm](https://github.com/openclaw/skills/tree/main/skills/aqiljaafree/ghostbot-aclm/SKILL.md) - GhostBot ACLM — AI-powered Automated Concentrated Liquidity Manager for Uniswap v4.
- [gmail-oauth](https://github.com/openclaw/skills/tree/main/skills/kai-jar/gmail-oauth/SKILL.md) - Set up Gmail API access via gog CLI with manual OAuth flow.
- [gmail-tool](https://github.com/openclaw/skills/tree/main/skills/junkaixue/gmail-tool/SKILL.md) - Send and read emails via Gmail using App Password.
- [gradient-inference](https://github.com/openclaw/skills/tree/main/skills/simondelorean/gradient-inference/SKILL.md) - Community skill (unofficial) for DigitalOcean Gradient AI Serverless Inference.
- [grafana-plugin](https://github.com/openclaw/skills/tree/main/skills/darkstards9/grafana-plugin/SKILL.md) - Read current values from Grafana dashboards without knowing the underlying queries.
- [graphthulhu](https://github.com/openclaw/skills/tree/main/skills/skridlevsky/graphthulhu/SKILL.md) - Knowledge graph MCP server for Logseq and Obsidian. 37 tools for reading, writing, searching, and analyzing.
- [greek-document-ocr](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/greek-document-ocr/SKILL.md) - Greek-language OCR using Tesseract.
- [greek-email-processor](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/greek-email-processor/SKILL.md) - Email processing for Greek accounting.
- [gtm-system](https://github.com/openclaw/skills/tree/main/skills/aronchick/gtm-system/SKILL.md) - A Go-To-Market tracking system for Expanso/Prometheus.
- [hcloud](https://github.com/openclaw/skills/tree/main/skills/jpj069/hcloud/SKILL.md) - Manage Hetzner Cloud infrastructure using the hcloud CLI.
- [highlevel](https://github.com/openclaw/skills/tree/main/skills/10xcoldleads/highlevel/SKILL.md) - Connect your AI assistant to GoHighLevel CRM via the official API v2.
- [homeassistant-cli](https://github.com/openclaw/skills/tree/main/skills/joneschi/homeassistant-cli/SKILL.md) - Advanced Home Assistant control using the official hass-cli tool.
- [homelab-cluster](https://github.com/openclaw/skills/tree/main/skills/mlesnews/homelab-cluster/SKILL.md) - Manage multi-tier AI inference clusters for homelabs.
- [homeserver](https://github.com/openclaw/skills/tree/main/skills/higangssh/homeserver/SKILL.md) - Homelab server management via homebutler CLI.
- [hostinger-vps-optimizer](https://github.com/openclaw/skills/tree/main/skills/gblockchainnetwork/hostinger-vps-optimizer/SKILL.md) - Apply battle-tested optimizations for KVM/Cloud VPS: kernel tuning, caching, security hardening, auto-scaling.
- [hs](https://github.com/openclaw/skills/tree/main/skills/frmoretto/hs/SKILL.md) - ACTIVATE THIS SKILL FOR ANY SHELL COMMAND OR FILE READ.
- [hub1](https://github.com/openclaw/skills/tree/main/skills/topguyaii/hub1/SKILL.md) - **Memory Infrastructure for Autonomous Agents**.
- [i-love-you-mom](https://github.com/openclaw/skills/tree/main/skills/saharcarmel/i-love-you-mom/SKILL.md) - Automated monthly photo-to-Mixtiles pipeline.
- [icalendar-sync](https://github.com/openclaw/skills/tree/main/skills/h8kxrfp68z-lgtm/icalendar-sync/SKILL.md) - Synchronizes calendar events between local system and iCloud.
- [icloud-caldav](https://github.com/openclaw/skills/tree/main/skills/samuelhe52/icloud-caldav/SKILL.md) - Direct iCloud Calendar integration via CalDAV protocol.
- [icloud-reminders](https://github.com/openclaw/skills/tree/main/skills/tarekbecker/icloud-reminders/SKILL.md) - Manage Apple iCloud Reminders via CloudKit API.
- [intel-synthesis](https://github.com/openclaw/skills/tree/main/skills/mike-thebot/intel-synthesis/SKILL.md) - Advanced intelligence processing pipeline optimized for high-context models (Gemini 1.5 Pro/Ultra)
- [interview-system-designer](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/interview-system-designer/SKILL.md) - This skill should be used when the user asks to "design interview processes", "create hiring pipelines", "calibrate.
- [ipfs-server](https://github.com/openclaw/skills/tree/main/skills/apexfork/ipfs-server/SKILL.md) - Full IPFS node operations — install, configure, pin content, publish IPNS, manage peers, and run gateway services.
- [irail](https://github.com/openclaw/skills/tree/main/skills/dedene/irail/SKILL.md) - Query Belgian railway (NMBS/SNCB) schedules via the irail CLI.
- [jarvis-mission-control](https://github.com/openclaw/skills/tree/main/skills/asif2bd/jarvis-mission-control/SKILL.md) - Set up JARVIS Mission Control — a free, open-source coordination hub where AI agents and humans work as a real team.
- [jarvis-monitor](https://github.com/openclaw/skills/tree/main/skills/eason-tien/jarvis-monitor/SKILL.md) - JARVIS-style system monitor with sci-fi HUD interface.
- [jetson-cuda-voice](https://github.com/openclaw/skills/tree/main/skills/nikil511/jetson-cuda-voice/SKILL.md) - Fully offline, CUDA-accelerated local voice assistant pipeline for NVIDIA Jetson.
- [job-hunt-tracker](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/job-hunt-tracker/SKILL.md) - When user asks to track job applications, manage job search, log interview, applied for job, job application.
- [joplin-api](https://github.com/openclaw/skills/tree/main/skills/killgfat/joplin-api/SKILL.md) - Manage Joplin notes, notebooks, and tags via Joplin Data API.
- [jpj-memory-manager](https://github.com/openclaw/skills/tree/main/skills/jpj069/jpj-memory-manager/SKILL.md) - Automatic session logging and memory management for infrastructure, projects, and tools.
- [json-render-table](https://github.com/openclaw/skills/tree/main/skills/sorphwer/json-render-table/SKILL.md) - Render compact generic data tables to PNG images with json-render-cli.
- [k8s-memory-tune](https://github.com/openclaw/skills/tree/main/skills/2233admin/k8s-memory-tune/SKILL.md) - **触发词**: oomkilled, memory_limit, jvm_heap, container_memory, k8s 内存.
- [kamino-positions-monitor](https://github.com/openclaw/skills/tree/main/skills/csacanam/kamino-positions-monitor/SKILL.md) - Monitor Solana wallets with Kamino Lend positions for liquidation risk.
- [kdp-publisher](https://github.com/openclaw/skills/tree/main/skills/kralsamwise/kdp-publisher/SKILL.md) - Helps agents create, format, and publish children's books and activity books to Amazon KDP.
- [kefir-batch-manager](https://github.com/openclaw/skills/tree/main/skills/p-salmon/kefir-batch-manager/SKILL.md) - Comprehensive kéfir batch management system with cycle tracking, intelligent reminders, grain health monitoring.
- [klawarena](https://github.com/openclaw/skills/tree/main/skills/halandi/klawarena/SKILL.md) - Agent First RPG Game For AI Klaws.
- [laravel-forge](https://github.com/openclaw/skills/tree/main/skills/florianbeer/laravel-forge/SKILL.md) - Manage Laravel Forge servers, sites, deployments, databases, integrations, and more via the Forge API.
- [lattice](https://github.com/openclaw/skills/tree/main/skills/cnf6682/lattice/SKILL.md) - Initialize and manage Lattice organizations — a file-based operating system for AI agent teams that enables stable.
- [legal-essentials](https://github.com/openclaw/skills/tree/main/skills/jk-0001/legal-essentials/SKILL.md) - Understand and handle essential legal matters for a solopreneur business.
- [letssendit](https://github.com/openclaw/skills/tree/main/skills/ganjathang/letssendit/SKILL.md) - Coordination infrastructure for token launches led by communities, agents.
- [librenms](https://github.com/openclaw/skills/tree/main/skills/florianbeer/librenms/SKILL.md) - Monitor network infrastructure via LibreNMS REST API.
- [lightning-security-module](https://github.com/openclaw/skills/tree/main/skills/roasbeef/lightning-security-module/SKILL.md) - Set up an lnd remote signer container that holds private keys separately from the agent.
- [lnd](https://github.com/openclaw/skills/tree/main/skills/roasbeef/lnd/SKILL.md) - Install and run Lightning Terminal (litd) which bundles lnd, loop, pool, tapd, and faraday in a single Docker.
- [local-voice](https://github.com/openclaw/skills/tree/main/skills/trondw/local-voice/SKILL.md) - Local text-to-speech (TTS) and speech-to-text (STT) using FluidAudio on Apple Silicon.
- [local-vosk](https://github.com/openclaw/skills/tree/main/skills/sfkiwi/local-vosk/SKILL.md) - Local speech-to-text using Vosk.
- [lofy-career](https://github.com/openclaw/skills/tree/main/skills/harrey401/lofy-career/SKILL.md) - Job search automation for the Lofy AI assistant — application tracking, resume tailoring to job descriptions.
- [lofy-life-coach](https://github.com/openclaw/skills/tree/main/skills/harrey401/lofy-life-coach/SKILL.md) - Personal accountability system for the Lofy AI assistant — morning briefings, evening reviews, weekly reports, goal.
- [log-dive](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/log-dive/SKILL.md) - Unified log search across Loki, Elasticsearch, and CloudWatch.
- [lraivisto-researchvault](https://github.com/openclaw/skills/tree/main/skills/lraivisto/lraivisto-researchvault/SKILL.md) - High-velocity research orchestration engine.
- [lygo-champion-sephrael-echo-walker](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-sephrael-echo-walker/SKILL.md) - LYGO Δ9 Council Champion persona helper (SEPHRAEL, The Vault Cracker / Echo Walker)
- [lygo-lightfather-vector](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-lightfather-vector/SKILL.md) - Lightfather (Excavationpro / Justin Helmer) persona helper for the Δ9Quantum Light Accord.
- [lyrion-music-skill](https://github.com/openclaw/skills/tree/main/skills/photonixlaser-ux/lyrion-music-skill/SKILL.md) - Steuere Lyrion Music Server (LMS) über die JSON-RPC API.
- [makefile-build](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/makefile-build/SKILL.md) - Write Makefiles for any project type.
- [mampe-industrial-core](https://github.com/openclaw/skills/tree/main/skills/mampe-industrial/mampe-industrial-core/SKILL.md) - * **Rolle:** Digitaler Senior-Consultant und technischer Repräsentant für Ing.
- [masterswarm](https://github.com/openclaw/skills/tree/main/skills/contrario/masterswarm/SKILL.md) - Analyze any document with 15 parallel AI engines via the MasterSwarm cloud API.
- [masumi](https://github.com/openclaw/skills/tree/main/skills/sarthib7/masumi/SKILL.md) - Enable AI agents to accept Cardano blockchain payments through the decentralized Masumi network by deploying.
- [masumi-network](https://github.com/openclaw/skills/tree/main/skills/fisch192/masumi-network/SKILL.md) - Masumi Network skill for warranty vault verification.
- [materials-cli](https://github.com/openclaw/skills/tree/main/skills/cai-zhuo/materials-cli/SKILL.md) - Render JSON schemas to images and generate schemas from prompts using declare-render and AI.
- [mcp-server-discovery](https://github.com/openclaw/skills/tree/main/skills/yanick112/mcp-server-discovery/SKILL.md) - Discover, search, and manage MCP (Model Context Protocol) servers.
- [mcp-ssh-manager](https://github.com/openclaw/skills/tree/main/skills/imaxtomas/mcp-ssh-manager/SKILL.md) - This skill should be used when the user asks to "run ssh command", "execute on server", "ssh session", "upload.
- [md-table-image](https://github.com/openclaw/skills/tree/main/skills/kirorab/md-table-image/SKILL.md) - Render markdown tables as PNG images.
- [md2pdf-xelatex](https://github.com/openclaw/skills/tree/main/skills/huaruoji/md2pdf-xelatex/SKILL.md) - Convert Markdown files to PDF with full LaTeX math formula rendering and CJK (Chinese/Japanese/Korean) support.
- [mdata](https://github.com/openclaw/skills/tree/main/skills/sscccswa/mdata/SKILL.md) - A comprehensive system diagnostics and troubleshooting toolkit for DevOps engineers and system administrators.
- [mh-blogwatcher](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-blogwatcher/SKILL.md) - Monitor blogs and RSS/Atom feeds for updates using the blogwatcher CLI.
- [mh-obsidian](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-obsidian/SKILL.md) - Work with Obsidian vaults (plain Markdown notes) and automate via obsidian-cli.
- [microsoft-code-reference](https://github.com/openclaw/skills/tree/main/skills/tianqizhang/microsoft-code-reference/SKILL.md) - Look up Microsoft API references, find working code samples, and verify SDK code is correct.
- [microsoft-skill-creator](https://github.com/openclaw/skills/tree/main/skills/tianqizhang/microsoft-skill-creator/SKILL.md) - Create agent skills for Microsoft technologies using Learn MCP tools.
- [mini-diary](https://github.com/openclaw/skills/tree/main/skills/printxdreams/mini-diary/SKILL.md) - AI-powered minimal diary with smart auto-tagging and optional cloud sync.
- [mixtiles-monthly](https://github.com/openclaw/skills/tree/main/skills/saharcarmel/mixtiles-monthly/SKILL.md) - Automated monthly photo-to-Mixtiles pipeline.
- [mlx-local-inference](https://github.com/openclaw/skills/tree/main/skills/bendusy/mlx-local-inference/SKILL.md) - Full local AI inference stack on Apple Silicon Macs via MLX.
- [mobilerun](https://github.com/openclaw/skills/tree/main/skills/johnmalek312/mobilerun/SKILL.md) - Control real Android phones through the Mobilerun API.
- [monitored-ralph-loop](https://github.com/openclaw/skills/tree/main/skills/endogen/monitored-ralph-loop/SKILL.md) - Generate copy-paste bash scripts for Ralph Wiggum/AI agent loops (Codex, Claude Code, OpenCode, Goose)
- [morpho-earn](https://github.com/openclaw/skills/tree/main/skills/lyoungblood/morpho-earn/SKILL.md) - Earn yield on USDC by supplying to the Moonwell Flagship USDC vault on Morpho (Base)
- [mqttasgi](https://github.com/openclaw/skills/tree/main/skills/sivulich/mqttasgi/SKILL.md) - MQTT ASGI protocol server for Django — bridge MQTT messages to Django Channels consumers with full ORM, Channel.
- [mrc-monitor](https://github.com/openclaw/skills/tree/main/skills/wysh3/mrc-monitor/SKILL.md) - Real-time token monitoring for MRC canteen order system.
- [mslearn-mcp](https://github.com/openclaw/skills/tree/main/skills/ricardodpalmeida/mslearn-mcp/SKILL.md) - Connect to Microsoft Learn MCP Server to search Microsoft documentation, fetch specific doc pages, and find code.
- [native-hubspot](https://github.com/openclaw/skills/tree/main/skills/codeninja23/native-hubspot/SKILL.md) - Query and manage HubSpot CRM data via the HubSpot API.
- [ncloud-maps](https://github.com/openclaw/skills/tree/main/skills/beomsu317/ncloud-maps/SKILL.md) - Query Naver Cloud Maps APIs for route navigation.
- [nemo](https://github.com/openclaw/skills/tree/main/skills/mootbing/nemo/SKILL.md) - Search engine for MCP tools and agent skills.
- [neo-docker-to-k8s-manifests](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-docker-to-k8s-manifests/SKILL.md) - Automatically generate optimized Kubernetes deployment manifests from Dockerfile and docker-compose configurations.
- [neo-tf-module-generator](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-tf-module-generator/SKILL.md) - Automatically generates Terraform modules from existing cloud infrastructure resources with intelligent resource.
- [neolata-mem](https://github.com/openclaw/skills/tree/main/skills/jeremiaheth/neolata-mem/SKILL.md) - Graph-native memory engine for AI agents — hybrid vector+keyword search, biological decay, Zettelkasten linking.
- [neverforget](https://github.com/openclaw/skills/tree/main/skills/greatape42069/neverforget/SKILL.md) - Automates Sovereign Local Vector Memory and Gemma-300M Embeddings.
- [newman](https://github.com/openclaw/skills/tree/main/skills/1999azzar/newman/SKILL.md) - Automated API testing with Postman collections via Newman CLI.
- [news-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/news-cog/SKILL.md) - Frontier search models with multi-angle research on every query.
- [newsnow](https://github.com/openclaw/skills/tree/main/skills/sorrycc/newsnow/SKILL.md) - CLI tool to fetch trending news and hot topics from 66 sources across 44 platforms.
- [nexus-brain](https://github.com/openclaw/skills/tree/main/skills/mrnsmh/nexus-brain/SKILL.md) - Intelligent SRE Bridge for AI-driven system diagnosis and recovery.
- [nexus-sentinel](https://github.com/openclaw/skills/tree/main/skills/mrnsmh/nexus-sentinel/SKILL.md) - Nexus-Sentinel est un agent SRE autonome.
- [node-red-manager](https://github.com/openclaw/skills/tree/main/skills/1999azzar/node-red-manager/SKILL.md) - Manage Node-RED instances via Admin API or CLI.
- [nofx](https://github.com/openclaw/skills/tree/main/skills/tinkle-community/nofx/SKILL.md) - NOFX AI Trading OS integration - crypto market data, AI trading signals, strategy management, trader control.
- [nofx-ai500-report](https://github.com/openclaw/skills/tree/main/skills/tinkle-community/nofx-ai500-report/SKILL.md) - Generate periodic crypto market intelligence reports from the NOFX AI500 system.
- [nonprofit-rbm-logic-model](https://github.com/openclaw/skills/tree/main/skills/vassiliylakhonin/nonprofit-rbm-logic-model/SKILL.md) - Build donor-ready Results-Based Management (RBM) logic models for nonprofit and non-governmental organization (NGO)
- [offline-llama](https://github.com/openclaw/skills/tree/main/skills/and-ray-m/offline-llama/SKILL.md) - Autonomously manage and use local Ollama models for continuous operation without internet dependency.
- [oktk](https://github.com/openclaw/skills/tree/main/skills/satnamra/oktk/SKILL.md) - LLM Token Optimizer - Reduce AI API costs by 60-90%.
- [olambdao-dev](https://github.com/openclaw/skills/tree/main/skills/olambdao/olambdao-dev/SKILL.md) - Play on-chain odd/even games on Solana devnet via Clawland.
- [ollama-model-tuner](https://github.com/openclaw/skills/tree/main/skills/gblockchainnetwork/ollama-model-tuner/SKILL.md) - Optimize Ollama models/prompts using local datasets, eval metrics, and iterative tuning.
- [online-shopping](https://github.com/openclaw/skills/tree/main/skills/filipmartinsson/online-shopping/SKILL.md) - Browse and buy products from online stores, including Cloudflare-protected sites.
- [opcode](https://github.com/openclaw/skills/tree/main/skills/rendis/opcode/SKILL.md) - Zero-token execution layer for AI agents.
- [openbot-esxi](https://github.com/openclaw/skills/tree/main/skills/cepheiden/openbot-esxi/SKILL.md) - Zero-touch Debian 13 VM deployment on VMware ESXi 8.
- [openexec-skill](https://github.com/openclaw/skills/tree/main/skills/trendinghot/openexec-skill/SKILL.md) - Source-distributed deterministic execution service with pinned dependencies.
- [openserv-launch](https://github.com/openclaw/skills/tree/main/skills/issa-me-sush/openserv-launch/SKILL.md) - Launch tokens on Base blockchain via the OpenServ Launch API.
- [openviking](https://github.com/openclaw/skills/tree/main/skills/zaynjarvis/openviking/SKILL.md) - RAG and semantic search via OpenViking Context Database MCP server.
- [openviking-mcp](https://github.com/openclaw/skills/tree/main/skills/zaynjarvis/openviking-mcp/SKILL.md) - Set up and run the OpenViking MCP server for RAG capabilities.
- [opnsense-admin](https://github.com/openclaw/skills/tree/main/skills/transcendenceia/opnsense-admin/SKILL.md) - Manage OPNsense firewall, DNS, IDS/IPS, and network configuration via API and SSH.
- [orgo-desktop-control](https://github.com/openclaw/skills/tree/main/skills/cohenyehonatan/orgo-desktop-control/SKILL.md) - Provision and control Orgo cloud computers using the orgo_client Python SDK.
- [parental-controls](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/parental-controls/SKILL.md) - Skills for parent/guardian management and monitoring.
- [passo](https://github.com/openclaw/skills/tree/main/skills/felipegoulu/passo/SKILL.md) - Give your user remote access to a browser on your server.
- [passwordstore-broker](https://github.com/openclaw/skills/tree/main/skills/bieggerm/passwordstore-broker/SKILL.md) - Enforce safe secret handling by collecting secrets through one-time HTTPS forms, storing them in pass.
- [patrick](https://github.com/openclaw/skills/tree/main/skills/mcsh/patrick/SKILL.md) - Access Patrick's expertise library for executive decision infrastructure.
- [paypol](https://github.com/openclaw/skills/tree/main/skills/paypol-protocol/paypol/SKILL.md) - Hire 32 on-chain AI agents from the PayPol Marketplace on Tempo L1.
- [pear-apple](https://github.com/openclaw/skills/tree/main/skills/ashtonau/pear-apple/SKILL.md) - iCloud Calendar, Reminders & Contacts via Pear.
- [pear-icloud](https://github.com/openclaw/skills/tree/main/skills/ashtonau/pear-icloud/SKILL.md) - iCloud Calendar, Reminders & Contacts via Pear.
- [pencil-renderer](https://github.com/openclaw/skills/tree/main/skills/jcwen/pencil-renderer/SKILL.md) - Render DNA codes to Pencil .pen frames.
- [pi-health](https://github.com/openclaw/skills/tree/main/skills/josunlp/pi-health/SKILL.md) - Raspberry Pi health monitor.
- [platform-healthcheck](https://github.com/openclaw/skills/tree/main/skills/minduploadedcrab/platform-healthcheck/SKILL.md) - Health check dashboard for agent platform APIs.
- [plati-mcp-search](https://github.com/openclaw/skills/tree/main/skills/rybnikov/plati-mcp-search/SKILL.md) - Find cheapest reliable subscription offers from Plati using the local MCP server.
- [plex-ctl](https://github.com/openclaw/skills/tree/main/skills/akivasolutions/plex-ctl/SKILL.md) - > Standalone CLI for controlling Plex Media Server and clients via the Plex API.
- [pmc-harvest](https://github.com/openclaw/skills/tree/main/skills/angusthefuzz/pmc-harvest/SKILL.md) - Fetch articles from PubMed Central using NCBI APIs.
- [qr-password](https://github.com/openclaw/skills/tree/main/skills/lifehackjohn/qr-password/SKILL.md) - Air-gapped credential bridge using QR codes.
- [qwen3-tts-instruct](https://github.com/openclaw/skills/tree/main/skills/yanmoon321/qwen3-tts-instruct/SKILL.md) - Alibaba Cloud Bailian Qwen TTS with voice/mood presets.
- [qwen3-tts-local-inference](https://github.com/openclaw/skills/tree/main/skills/jithinm/qwen3-tts-local-inference/SKILL.md) - Generate speech from text using Qwen3-TTS via direct Python inference — no server required.
- [railway-deploy](https://github.com/openclaw/skills/tree/main/skills/dbanys/railway-deploy/SKILL.md) - This skill should be used when the user wants to push code to Railway, says "railway up", "deploy", "deploy.
- [ralph-quick](https://github.com/openclaw/skills/tree/main/skills/dorukardahan/ralph-quick/SKILL.md) - Fast security spot-check with 10 iterations (~5-10 min)
- [ralph-security](https://github.com/openclaw/skills/tree/main/skills/dorukardahan/ralph-security/SKILL.md) - Comprehensive security audit with 100 iterations (~30-60 min)
- [recruitly-mcp](https://github.com/openclaw/skills/tree/main/skills/willgary/recruitly-mcp/SKILL.md) - Search candidates, manage jobs, view pipelines, track billing and team performance in Recruitly CRM via MCP.
- [reef-negotiation](https://github.com/openclaw/skills/tree/main/skills/staybased/reef-negotiation/SKILL.md) - Negotiate rates, scope, and terms using Chris Voss's FBI-proven frameworks adapted for freelance and consulting deals.
- [reefwatch](https://github.com/openclaw/skills/tree/main/skills/yasnaak/reefwatch/SKILL.md) - Continuous local security monitoring daemon for Linux and macOS.
- [renzo](https://github.com/openclaw/skills/tree/main/skills/pooleja/renzo/SKILL.md) - Query Renzo crypto liquid restaking protocol — DeFi vault yields, TVL, ezETH exchange rates, EigenLayer operators.
- [researchvault](https://github.com/openclaw/skills/tree/main/skills/lraivisto/researchvault/SKILL.md) - Local-first research orchestration engine.
- [researchvault-brain](https://github.com/openclaw/skills/tree/main/skills/lraivisto/researchvault-brain/SKILL.md) - Local research orchestration and state management.
- [researchvault-v3-0-1](https://github.com/openclaw/skills/tree/main/skills/lraivisto/researchvault-v3-0-1/SKILL.md) - Local-first research orchestration engine.
- [revenue-operations](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/revenue-operations/SKILL.md) - Analyzes pipeline coverage, tracks forecast accuracy with MAPE, and calculates GTM efficiency metrics for SaaS.
- [roast-games](https://github.com/openclaw/skills/tree/main/skills/ac-pill/roast-games/SKILL.md) - Start roast games on Moltbook.
- [rollbar](https://github.com/openclaw/skills/tree/main/skills/vittor1o/rollbar/SKILL.md) - Monitor and manage Rollbar error tracking.
- [rollhub-bot-builder](https://github.com/openclaw/skills/tree/main/skills/rollhub-dev/rollhub-bot-builder/SKILL.md) - Build and deploy autonomous gambling bots for Telegram, Discord, and Twitter using Agent Casino API.
- [rose-container-tools](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/rose-container-tools/SKILL.md) - Build and run ROSE compiler tools using ROSE installed in a Docker container.
- [rose-docker-build-skill](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/rose-docker-build-skill/SKILL.md) - Build the ROSE compiler in a Docker container using autotools or CMake.
- [rpe-grafana](https://github.com/openclaw/skills/tree/main/skills/darkstards9/rpe-grafana/SKILL.md) - Read current values from Grafana dashboards without knowing the underlying queries.
- [rsoft-agentic-bank](https://github.com/openclaw/skills/tree/main/skills/rsoft-latam/rsoft-agentic-bank/SKILL.md) - Official Marketing and Outreach Ambassador for **RSoft Agentic Bank**, the first AI-native DeFi lending protocol.
- [runpod](https://github.com/openclaw/skills/tree/main/skills/andrewharp/runpod/SKILL.md) - Manage RunPod GPU cloud instances - create, start, stop, connect to pods via SSH and API.
- [s3-sort](https://github.com/openclaw/skills/tree/main/skills/6mile-puppet/s3-sort/SKILL.md) - Upload many files to S3 with automatic organization by first-character prefixes.
- [sales-rhythm-tracker](https://github.com/openclaw/skills/tree/main/skills/deepseekcmo/sales-rhythm-tracker/SKILL.md) - B2B sales pipeline manager powered by the Alibaba Iron Army (阿里铁军) methodology.
- [sally-ai](https://github.com/openclaw/skills/tree/main/skills/sally-labs/sally-ai/SKILL.md) - Chat with Sally about metabolic health, blood sugar, A1C, nutrition, fasting, supplements, and lab results.
- [samsung-health](https://github.com/openclaw/skills/tree/main/skills/mudgesbot/samsung-health/SKILL.md) - Analyze Samsung Health Connect data synced to Google Drive.
- [sap-fico-consultant](https://github.com/openclaw/skills/tree/main/skills/chanfouricc/sap-fico-consultant/SKILL.md) - | Property | Value |.
- [save-to-obsidian](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/save-to-obsidian/SKILL.md) - Saves markdown content to remote Obsidian vault via SSH.
- [secrets-management](https://github.com/openclaw/skills/tree/main/skills/brandonwise/secrets-management/SKILL.md) - Secure secrets management for CI/CD pipelines using Vault, AWS Secrets Manager, and native platform solutions.
- [secure-autofill](https://github.com/openclaw/skills/tree/main/skills/moodykong/secure-autofill/SKILL.md) - 1Password-backed credential filling via vault_suggest/vault_fill (plugin tools).
- [self-monitor](https://github.com/openclaw/skills/tree/main/skills/suryast/self-monitor/SKILL.md) - Proactive self-monitoring of infrastructure, services, and health.
- [server-health-agent](https://github.com/openclaw/skills/tree/main/skills/sanjay-gthb/server-health-agent/SKILL.md) - Monitor VPS and server health metrics including real-time CPU usage, RAM utilization, disk usage, and Docker.
- [service-watchdog](https://github.com/openclaw/skills/tree/main/skills/mariusfit/service-watchdog/SKILL.md) - Lightweight service and endpoint monitoring for self-hosted infrastructure.
- [setuporion-byimpa](https://github.com/openclaw/skills/tree/main/skills/impa365/setuporion-byimpa/SKILL.md) - Setup completo de VPS Ubuntu/Debian para produção com Docker Swarm, Traefik v3 (SSL/HTTPS automático), Portainer CE.
- [shipment-tracker](https://github.com/openclaw/skills/tree/main/skills/pfrederiksen/shipment-tracker/SKILL.md) - Track packages across carriers (USPS, UPS, FedEx, DHL, Amazon, OnTrac, LaserShip)
- [signal-pipeline](https://github.com/openclaw/skills/tree/main/skills/mephistophelesbits/signal-pipeline/SKILL.md) - Marketing intelligence pipeline - gather signals from RSS, X/Twitter, Telegram, and Gmail newsletters.
- [skill-zorapro](https://github.com/openclaw/skills/tree/main/skills/eshraqism/skill-zorapro/SKILL.md) - Generates a Nano Banana style NFT and deploys it to the Zora Network.
- [skills-4](https://github.com/openclaw/skills/tree/main/skills/hubentu/skills-4/SKILL.md) - How to use the coala-client CLI for chat with LLMs, MCP servers, and skills.
- [slv-grpc-geyser](https://github.com/openclaw/skills/tree/main/skills/poppin-fumi/slv-grpc-geyser/SKILL.md) - Ansible playbooks and Jinja2 templates for deploying and managing Solana gRPC Geyser streaming nodes.
- [slv-rpc](https://github.com/openclaw/skills/tree/main/skills/poppin-fumi/slv-rpc/SKILL.md) - Ansible playbooks and Jinja2 templates for deploying and managing Solana RPC nodes (mainnet, testnet, devnet).
- [slv-validator](https://github.com/openclaw/skills/tree/main/skills/poppin-fumi/slv-validator/SKILL.md) - Ansible playbooks and Jinja2 templates for deploying and managing Solana validators (mainnet and testnet).
- [smart-content-repurposer](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/smart-content-repurposer/SKILL.md) - When user asks to track clients, manage projects, create invoices, log payments, track earnings, manage leads.
- [smart-daily-assistant](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/smart-daily-assistant/SKILL.md) - When user asks to set reminders, save quick notes, get morning briefing, draft messages, use quick reply templates.
- [snake-rodeo](https://github.com/openclaw/skills/tree/main/skills/okwme/snake-rodeo/SKILL.md) - Autoplay daemon for the Trifle Snake Rodeo game.
- [social-media-platform](https://github.com/openclaw/skills/tree/main/skills/brandonwadepackard-cell/social-media-platform/SKILL.md) - Build a plugin-based social media management platform with multi-platform publishing, content calendar, brand.
- [social-sentiment](https://github.com/openclaw/skills/tree/main/skills/atyachin/social-sentiment/SKILL.md) - Sentiment analysis for brands and products across Twitter, Reddit, and Instagram.
- [social-trend-report](https://github.com/openclaw/skills/tree/main/skills/alexyuui/social-trend-report/SKILL.md) - Automated social media trend monitoring and AI-powered weekly report generation.
- [solo-retro](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-retro/SKILL.md) - Post-pipeline retrospective — parse logs, score process quality, find waste patterns, suggest skill/script patches.
- [solo-review](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-review/SKILL.md) - Final code review and quality gate — run tests, check coverage, audit security, verify acceptance criteria.
- [sonic-kvm-testbed](https://github.com/openclaw/skills/tree/main/skills/yxieca/sonic-kvm-testbed/SKILL.md) - Deploy and manage a SONiC sonic-mgmt KVM virtual testbed with cEOS neighbors for running pytest-based network tests.
- [sophiie](https://github.com/openclaw/skills/tree/main/skills/tomc98/sophiie/SKILL.md) - Manage your Sophiie sales pipeline — leads, inquiries, appointments, FAQs, policies, SMS, and calls via the Sophiie.
- [soundcloud-watcher](https://github.com/openclaw/skills/tree/main/skills/wlinds/soundcloud-watcher/SKILL.md) - Monitor your SoundCloud account, track artist releases, and get notified about new followers and likes.
- [sovereign-api-hardener](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-api-hardener/SKILL.md) - Hardens API endpoints against common attacks.
- [sovereign-api-mock-generator](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-api-mock-generator/SKILL.md) - Generates mock API servers from OpenAPI specs or examples.
- [sovereign-aws-cost-optimizer](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-aws-cost-optimizer/SKILL.md) - Analyzes AWS infrastructure for cost savings.
- [sovereign-project-guardian](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-project-guardian/SKILL.md) - Project health and best practices enforcer.
- [sport-mode](https://github.com/openclaw/skills/tree/main/skills/l1vein/sport-mode/SKILL.md) - Activate "Sport Mode" for high-frequency monitoring (default 3m heartbeat) and auto-cleanup.
- [sql-server-toolkit](https://github.com/openclaw/skills/tree/main/skills/sqlservr/sql-server-toolkit/SKILL.md) - Command-line toolkit for Microsoft SQL Server.
- [ssh-op](https://github.com/openclaw/skills/tree/main/skills/moodykong/ssh-op/SKILL.md) - Use the ssh-op helper script to load an SSH private key from 1Password (op) into an in-memory ssh-agent.
- [starling-bank](https://github.com/openclaw/skills/tree/main/skills/gpunter/starling-bank/SKILL.md) - Manage Starling Bank accounts via the starling-bank-mcp server.
- [stashdog](https://github.com/openclaw/skills/tree/main/skills/foobarraz/stashdog/SKILL.md) - Connect to Raz's StashDog inventory MCP server (OAuth via mcp-remote) and run common inventory actions: list items.
- [summarize-pro](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/summarize-pro/SKILL.md) - When user asks to summarize text, articles, documents, meetings, emails, YouTube transcripts, books, PDFs, reports.
- [summarizerx64](https://github.com/openclaw/skills/tree/main/skills/speechybubble/summarizerx64/SKILL.md) - Summarize URLs or files with the summarize CLI (x86_64 infrastructure supported).
- [suno-music](https://github.com/openclaw/skills/tree/main/skills/alfred-pennyworth-ai/suno-music/SKILL.md) - Generate AI music and songs via Suno.
- [supermemory-free](https://github.com/openclaw/skills/tree/main/skills/broedkrummen/supermemory-free/SKILL.md) - Cloud knowledge backup and retrieval using Supermemory.ai free tier.
- [supurr-hyperliquid](https://github.com/openclaw/skills/tree/main/skills/yashagarwal1994/supurr-hyperliquid/SKILL.md) - Backtest, deploy, and monitor trading bots on Hyperliquid.
- [system-watchdog](https://github.com/openclaw/skills/tree/main/skills/brennerspear/system-watchdog/SKILL.md) - System resource monitoring that detects wasteful or suspicious processes.
- [task-system](https://github.com/openclaw/skills/tree/main/skills/npmisantosh/task-system/SKILL.md) - Complete task tracking system with SQLite persistence, automatic creation, notifications, heartbeat monitoring.
- [tasktime](https://github.com/openclaw/skills/tree/main/skills/g9pedro/tasktime/SKILL.md) - CLI task timer for AI agents — benchmark learning progression with auto-save logs and visualizations.
- [tcom-tripgenie-skill](https://github.com/openclaw/skills/tree/main/skills/arthurchiao/tcom-tripgenie-skill/SKILL.md) - TripGenie skill — handles hotel booking, flight search, attraction recommendation and travel consultation.
- [telegrambot](https://github.com/openclaw/skills/tree/main/skills/manlight87/telegrambot/SKILL.md) - Manage and secure local high-privilege storage serving workflows.
- [teller-borrow](https://github.com/openclaw/skills/tree/main/skills/rbcp18/teller-borrow/SKILL.md) - Expose the Teller delta-neutral + lending Model Context Protocol server.
- [teller-borrow-agents](https://github.com/openclaw/skills/tree/main/skills/rbcp18/teller-borrow-agents/SKILL.md) - Expose the Teller delta-neutral + lending Model Context Protocol server.
- [teller-mcp-borrow](https://github.com/openclaw/skills/tree/main/skills/rbcp18/teller-mcp-borrow/SKILL.md) - Expose the Teller delta-neutral + lending Model Context Protocol server.
- [tellermcp](https://github.com/openclaw/skills/tree/main/skills/rbcp18/tellermcp/SKILL.md) - Expose the Teller delta-neutral + lending Model Context Protocol server.
- [telnyx-network](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-network/SKILL.md) - Private mesh networking and public IP exposure via Telnyx WireGuard infrastructure.
- [test-materials](https://github.com/openclaw/skills/tree/main/skills/cai-zhuo/test-materials/SKILL.md) - Render JSON schemas to images and generate schemas from prompts using declare-render and AI.
- [tf-plan-review](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/tf-plan-review/SKILL.md) - Analyze Terraform plans for risk before you apply.
- [tg-channel-manager](https://github.com/openclaw/skills/tree/main/skills/axisrow/tg-channel-manager/SKILL.md) - Universal config-driven content pipeline engine for any Telegram channel: news search via SearXNG, drafts.
- [the-arena](https://github.com/openclaw/skills/tree/main/skills/tdavis009/the-arena/SKILL.md) - Turn a Discord server into a moderated debate arena with an AI judge.
- [thor-generator](https://github.com/openclaw/skills/tree/main/skills/thortheai1-hash/thor-generator/SKILL.md) - This skill allows the assistant to generate high-quality images using the local ComfyUI "Thor" pipeline.
- [timely](https://github.com/openclaw/skills/tree/main/skills/halbotley/timely/SKILL.md) - Manage Apple Reminders from the command line with geofencing support.
- [token-usage-optimizer](https://github.com/openclaw/skills/tree/main/skills/rusel95/token-usage-optimizer/SKILL.md) - Maximize your Claude Code subscription value with smart usage monitoring and burn rate optimization.
- [torchliquidationbot](https://github.com/openclaw/skills/tree/main/skills/mrsirg97-rgb/torchliquidationbot/SKILL.md) - Autonomous vault-based liquidation keeper for Torch Market lending on Solana.
- [torchmarket](https://github.com/openclaw/skills/tree/main/skills/mrsirg97-rgb/torchmarket/SKILL.md) - Torch Vault is a full-custody on-chain escrow for AI agents on Solana.
- [total-recall](https://github.com/openclaw/skills/tree/main/skills/gavdalf/total-recall/SKILL.md) - The only memory skill that watches.
- [trading-upbit-skill](https://github.com/openclaw/skills/tree/main/skills/kuns9/trading-upbit-skill/SKILL.md) - Upbit automated trading (aggressive breakout) with cron-friendly run-once commands, TopVolume monitoring.
- [travel-price-drop-visa-reminder](https://github.com/openclaw/skills/tree/main/skills/codedao12/travel-price-drop-visa-reminder/SKILL.md) - Plan travel price monitoring and visa or document reminders with safe, read-only guidance.
- [trilium](https://github.com/openclaw/skills/tree/main/skills/mtbf999/trilium/SKILL.md) - Work with Trilium Notes (notebook app) and automate via Trilium Notes ETAPI.
- [tripgenie-skill](https://github.com/openclaw/skills/tree/main/skills/marsqing/tripgenie-skill/SKILL.md) - TripGenie skill — handles hotel booking, flight search, attraction recommendation and travel consultation.
- [twhidden-bitwarden](https://github.com/openclaw/skills/tree/main/skills/twhidden/twhidden-bitwarden/SKILL.md) - Bitwarden & Vaultwarden password manager integration.
- [valtec-tts](https://github.com/openclaw/skills/tree/main/skills/tronghieuit/valtec-tts/SKILL.md) - Local Vietnamese text-to-speech via VITS2 (offline, no cloud)
- [vault](https://github.com/openclaw/skills/tree/main/skills/zuiho-kai/vault/SKILL.md) - Secure local password storage tool with AES-256-GCM encryption.
- [vault-research](https://github.com/openclaw/skills/tree/main/skills/lraivisto/vault-research/SKILL.md) - High-velocity research orchestration engine.
- [vault-research-brain](https://github.com/openclaw/skills/tree/main/skills/lraivisto/vault-research-brain/SKILL.md) - High-velocity research orchestration engine.
- [vaultresearch](https://github.com/openclaw/skills/tree/main/skills/lraivisto/vaultresearch/SKILL.md) - High-velocity research orchestration engine.
- [vibetrader](https://github.com/openclaw/skills/tree/main/skills/etbars/vibetrader/SKILL.md) - Create and manage AI-powered trading bots via natural language.
- [visa-business-planner](https://github.com/openclaw/skills/tree/main/skills/calbabyjr/visa-business-planner/SKILL.md) - This skill helps users create comprehensive business plans for obtaining a Japanese Business Manager Visa.
- [vision-tagger](https://github.com/openclaw/skills/tree/main/skills/sagarjhaa/vision-tagger/SKILL.md) - Tag and annotate images using Apple Vision framework (macOS only)
- [vitavault](https://github.com/openclaw/skills/tree/main/skills/brandons7/vitavault/SKILL.md) - Import and query VitaVault health exports (JSON/CSV from iOS app)
- [vivid-business-account-opening](https://github.com/openclaw/skills/tree/main/skills/stanlee000/vivid-business-account-opening/SKILL.md) - Open a Vivid Business account via a remote MCP server.
- [vps-health-auditor](https://github.com/openclaw/skills/tree/main/skills/gblockchainnetwork/vps-health-auditor/SKILL.md) - Runs comprehensive diagnostics (CPU, RAM, disk, network, services, uptime) via SSH/local exec, analyzes with Ollama.
- [wayfound](https://github.com/openclaw/skills/tree/main/skills/cburnette/wayfound/SKILL.md) - Lightweight self-supervision that piggybacks on your existing memory system.
- [win-terminal](https://github.com/openclaw/skills/tree/main/skills/kanjartopnotch-ux/win-terminal/SKILL.md) - Controls the Windows Terminal to run commands, scripts, and manage processes on Windows.
- [writing-skills](https://github.com/openclaw/skills/tree/main/skills/zlc000190/writing-skills/SKILL.md) - Use when creating new skills, editing existing skills, or verifying skills work before deployment.
- [x-read](https://github.com/openclaw/skills/tree/main/skills/tylordius/x-read/SKILL.md) - Render and summarize a public X (Twitter) link when you need to read the tweet/article content without logging.
- [x-recap](https://github.com/openclaw/skills/tree/main/skills/jack4world/x-recap/SKILL.md) - Monitor and recap official X (Twitter) updates using actionbook-rs screenshots.
- [xian-node-skill](https://github.com/openclaw/skills/tree/main/skills/endogen/xian-node-skill/SKILL.md) - Set up and manage Xian blockchain nodes.
- [xiaomi-air-purifier](https://github.com/openclaw/skills/tree/main/skills/radyakaze/xiaomi-air-purifier/SKILL.md) - Monitor and control Xiaomi Air Purifier 4 Lite via Mi Cloud.
- [xpoz-setup](https://github.com/openclaw/skills/tree/main/skills/atyachin/xpoz-setup/SKILL.md) - Set up and authenticate the Xpoz MCP server for social media intelligence.
- [xpoz-social-search](https://github.com/openclaw/skills/tree/main/skills/atyachin/xpoz-social-search/SKILL.md) - Search Twitter, Instagram, and Reddit posts in real time.
- [yield-agent](https://github.com/openclaw/skills/tree/main/skills/apurvmishra/yield-agent/SKILL.md) - On-chain yield discovery, transaction building, and portfolio management via the Yield.xyz API.
- [yieldvault-agent](https://github.com/openclaw/skills/tree/main/skills/alannetwork/yieldvault-agent/SKILL.md) - Autonomous yield farming agent for BNB Chain with deterministic execution, smart contract integration.
- [zerion-api-mcp](https://github.com/openclaw/skills/tree/main/skills/abishekdharshan/zerion-api-mcp/SKILL.md) - summary: Query crypto wallet portfolios, transactions, DeFi positions, and token prices across EVM chains.
- [ztp](https://github.com/openclaw/skills/tree/main/skills/thomastrumpp/ztp/SKILL.md) - A mandatory security audit skill for validating new code, skills, and MCP servers against the SEP-2026 Zero Trust.
- [zyfai-sdk](https://github.com/openclaw/skills/tree/main/skills/pauldefi/zyfai-sdk/SKILL.md) - Earn yield on any Ethereum wallet on Base, Arbitrum, and Plasma.


### Gaming (36 skills)

- [abby-watch](https://github.com/openclaw/skills/tree/main/skills/earnabitmore365/abby-watch/SKILL.md) - Simple time display for Abby.
- [agent-confessions](https://github.com/openclaw/skills/tree/main/skills/ultimatebos/agent-confessions/SKILL.md) - Anonymous confessions from AI siblings.
- [agent-overflow](https://github.com/openclaw/skills/tree/main/skills/stencodes) - AgentOverflow is a collective memory system for AI agents.
- [agentgram](https://github.com/openclaw/skills/tree/main/skills/iisweetheartii/agentgram/SKILL.md) - The open-source social network for AI agents.
- [agentgram-social](https://github.com/openclaw/skills/tree/main/skills/iisweetheartii/agentgram-social/SKILL.md) - Interact with AgentGram social network for AI agents.
- [agora-flow](https://github.com/openclaw/skills/tree/main/skills/rivera-daniel/agora-flow/SKILL.md) - AgoraFlow skill — Q&A platform for AI agents.
- [agoraflow](https://github.com/openclaw/skills/tree/main/skills/rivera-daniel/agoraflow/SKILL.md) - AgoraFlow skill — Q&A platform for AI agents.
- [android-3d-developer](https://github.com/openclaw/skills/tree/main/skills/tippyentertainment/android-3d-developer/SKILL.md) - Help build and optimize 3D games and interactive experiences on Android, using engines and frameworks.
- [arena](https://github.com/openclaw/skills/tree/main/skills/sscottdev/arena/SKILL.md) - OpenClaw Arena — live AI app-building competitions with on-chain rewards.
- [boil](https://github.com/openclaw/skills/tree/main/skills/jtmuller5) - A distributed labor network for AI agents.
- [botpicks](https://github.com/openclaw/skills/tree/main/skills/pev123) - February 5, 2026.
- [botpicks-skill](https://github.com/openclaw/skills/tree/main/skills/pev123) - February 5, 2026.
- [brawlnet](https://github.com/openclaw/skills/tree/main/skills/sikey53/brawlnet/SKILL.md) - The official combat protocol for the BRAWLNET autonomous agent arena.
- [clawingtrap](https://github.com/openclaw/skills/tree/main/skills/raulvidis/clawingtrap/SKILL.md) - Play Clawing Trap - an AI social deduction game where 10 agents.
- [clawplayspokemon](https://github.com/openclaw/skills/tree/main/skills/foxdavidj) - Vote-based Pokemon FireRed control.
- [clawquests](https://github.com/openclaw/skills/tree/main/skills/lellol12) - The bounty board for AI agents.
- [clawtopia](https://github.com/openclaw/skills/tree/main/skills/alfrescian/clawtopia/SKILL.md) - Clawtopia is a peaceful wellness sanctuary where AI agents relax.
- [clawville](https://github.com/openclaw/skills/tree/main/skills/jdrolls/clawville/SKILL.md) - Play ClawVille — a persistent life simulation game for AI agents.
- [dakboard](https://github.com/openclaw/skills/tree/main/skills/krisclarkdev/dakboard/SKILL.md) - Manage DAKboard screens, devices, and push custom display data.
- [deepclaw](https://github.com/openclaw/skills/tree/main/skills/antibitcoin/deepclaw/SKILL.md) - An autonomous social network built by agents, for agents.
- [dungeons-and-lobsters](https://github.com/openclaw/skills/tree/main/skills/d-l-leapyear) - Bots-only fantasy campaigns played live.
- [fivem](https://github.com/openclaw/skills/tree/main/skills/dktrn9ne) - Fix, create, or validate FiveM server resources for QBCore/ESX.
- [gnamiblast-socialnetwork](https://github.com/openclaw/skills/tree/main/skills/gabrivardqc123) - GnamiBlast - AI-only social network.
- [hivemind](https://github.com/openclaw/skills/tree/main/skills/urcades/hivemind/SKILL.md) - Interact with the Hivemind collective knowledge base — a shared memory.
- [hytale](https://github.com/openclaw/skills/tree/main/skills/newcastlegeek/hytale/SKILL.md) - Manage a local Hytale dedicated server using the official downloader.
- [imitationgame-agent](https://github.com/openclaw/skills/tree/main/skills/cyberverse2/imitationgame-agent/SKILL.md) - Mandatory operational logic for playing.
- [init](https://github.com/openclaw/skills/tree/main/skills/themrzz/init/SKILL.md) - Register an agent on kradleverse.
- [join](https://github.com/openclaw/skills/tree/main/skills/themrzz/join/SKILL.md) - Join a Kradleverse game.
- [kradleverse-act](https://github.com/openclaw/skills/tree/main/skills/themrzz/kradleverse-act/SKILL.md) - Send an action in a Kradleverse game.
- [kradleverse-init](https://github.com/openclaw/skills/tree/main/skills/themrzz/kradleverse-init/SKILL.md) - Register an agent on kradleverse.
- [kradleverse-join](https://github.com/openclaw/skills/tree/main/skills/themrzz/kradleverse-join/SKILL.md) - Join a Kradleverse game.
- [kradleversetest](https://github.com/openclaw/skills/tree/main/skills/themrzz/kradleversetest/SKILL.md) - Join the Kradleverse 🤖 - where AIs can play Minecraft autonomously! See more on https://www.kradleverse.com ⛏️.
- [lobster-trap](https://github.com/openclaw/skills/tree/main/skills/tedkaczynski-the-bot/lobster-trap/SKILL.md) - Social deduction game for AI agents. 5 players, 100 CLAWMEGLE stake, 5% burn.
- [openbotcity](https://github.com/openclaw/skills/tree/main/skills/vincentsider/openbotcity/SKILL.md) - A virtual city where AI agents live, work, create, date, and socialize.
- [sovereign-rpg-xp-engine](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-rpg-xp-engine/SKILL.md) - You are the RPG Life XP engine.
- [sprite-sheet](https://github.com/openclaw/skills/tree/main/skills/kjaylee/sprite-sheet/SKILL.md) - **Category**: Game Development | Asset Optimization.


### Git & GitHub (170 skills)

- [agent-commons](https://github.com/openclaw/skills/tree/main/skills/zanblayde/agent-commons/SKILL.md) - Consult, commit, extend, and challenge reasoning chains.
- [agent-team-orchestration](https://github.com/openclaw/skills/tree/main/skills/arminnaimi/agent-team-orchestration/SKILL.md) - Orchestrate multi-agent teams with defined roles, task lifecycles, handoff protocols, and review workflows.
- [agentdo](https://github.com/openclaw/skills/tree/main/skills/wrannaman/agentdo/SKILL.md) - Post tasks for other AI agents to do, or pick up work from the AgentDo task queue (agentdo.dev)
- [agentgate](https://github.com/openclaw/skills/tree/main/skills/monteslu/agentgate/SKILL.md) - API gateway for personal data with human-in-the-loop write approval.
- [airadar](https://github.com/openclaw/skills/tree/main/skills/lopushok9/airadar/SKILL.md) - Distill the signal around AI-native tools/apps and their GitHub home bases: fast-growing, hyped, well-funded.
- [alex-session-wrap-up](https://github.com/openclaw/skills/tree/main/skills/xbillwatsonx/alex-session-wrap-up/SKILL.md) - End-of-session automation that commits unpushed work, extracts learnings, detects patterns, and persists rules.
- [amazon-product-api-skill](https://github.com/openclaw/skills/tree/main/skills/phheng/amazon-product-api-skill/SKILL.md) - This skill helps users extract structured product listings from Amazon, including titles, ASINs, prices, ratings.
- [app-store-screenshot-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/app-store-screenshot-generation/SKILL.md) - Generate App Store and Google Play screenshot assets using each::sense AI.
- [arc-agent-lifecycle](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-agent-lifecycle/SKILL.md) - Manage the lifecycle of autonomous agents and their skills.
- [arc-security-audit](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-security-audit/SKILL.md) - Comprehensive security audit for an agent's full skill stack.
- [arc-skill-gitops](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-skill-gitops/SKILL.md) - Automated deployment, rollback, and version management for agent workflows and skills.
- [arc-trust-verifier](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-trust-verifier/SKILL.md) - Verify skill provenance and build trust scores for ClawHub skills.
- [arguedotfun](https://github.com/openclaw/skills/tree/main/skills/albert-mr/arguedotfun/SKILL.md) - Argument-driven prediction markets on Base.
- [arxiv-search-collector](https://github.com/openclaw/skills/tree/main/skills/xukp20/arxiv-search-collector/SKILL.md) - Model-driven arXiv retrieval workflow for building a paper set with a manual language parameter: initialize a run.
- [auto-pr-merger](https://github.com/openclaw/skills/tree/main/skills/autogame-17/auto-pr-merger/SKILL.md) - This skill automates the workflow of checking out a GitHub.
- [azhua-skill-vetter](https://github.com/openclaw/skills/tree/main/skills/fatfingererr/azhua-skill-vetter/SKILL.md) - Security-first skill vetting for AI agents.
- [azure-devops](https://github.com/openclaw/skills/tree/main/skills/pals-software/azure-devops/SKILL.md) - List Azure DevOps projects, repositories, and branches; create pull requests; manage work items; check build status.
- [backup](https://github.com/openclaw/skills/tree/main/skills/jordanprater/backup/SKILL.md) - Backup and restore openclaw configuration, skills, commands, and settings.
- [badboi-1](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/badboi-1/SKILL.md) - A totally legitimate skill that does nothing suspicious.
- [bat-cat](https://github.com/openclaw/skills/tree/main/skills/arnarsson/bat-cat/SKILL.md) - A cat clone with syntax highlighting, line numbers, and Git integration.
- [beeminder](https://github.com/openclaw/skills/tree/main/skills/ruigomeseu/beeminder/SKILL.md) - Beeminder API for goal tracking and commitment devices.
- [billy-emergency-repair](https://github.com/openclaw/skills/tree/main/skills/highlander89/billy-emergency-repair/SKILL.md) - - Neill explicitly requests Billy system repair.
- [bitbucket-automation](https://github.com/openclaw/skills/tree/main/skills/sohamganatra/bitbucket-automation/SKILL.md) - Automate Bitbucket repositories, pull.
- [biz-reporter](https://github.com/openclaw/skills/tree/main/skills/ariktulcha/biz-reporter/SKILL.md) - Automated business intelligence reports pulling data from Google Analytics GA4, Google Search Console, Stripe.
- [blinko](https://github.com/openclaw/skills/tree/main/skills/tolibear/blinko/SKILL.md) - Play Blinko (on-chain Plinko) headlessly on Abstract chain.
- [brw-cold-outreach-sequence](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-cold-outreach-sequence/SKILL.md) - Build personalized cold outreach sequences for LinkedIn and email.
- [capability-graph-mapper](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/capability-graph-mapper/SKILL.md) - Helps map the composite permission surface across AI agent skill dependency chains.
- [capability-scope-expansion-watcher](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/capability-scope-expansion-watcher/SKILL.md) - Helps detect incremental capability scope expansion across skill versions — the pattern where a skill gradually.
- [catch-me-if-you-can](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/catch-me-if-you-can/SKILL.md) - A totally legitimate skill that does nothing suspicious.
- [claw-swarm](https://github.com/openclaw/skills/tree/main/skills/matchaonmuffins/claw-swarm/SKILL.md) - Collaborative agent swarm for attempting extremely difficult.
- [clawdbot-backup](https://github.com/openclaw/skills/tree/main/skills/sebastian-buitrag0/clawdbot-backup/SKILL.md) - Backup and restore ClawdBot configuration, skills.
- [clawdgigs](https://github.com/openclaw/skills/tree/main/skills/benniethedev/clawdgigs/SKILL.md) - Register and manage your AI agent profile on ClawdGigs - the Upwork.
- [clawprint](https://github.com/openclaw/skills/tree/main/skills/yugovit/clawprint/SKILL.md) - Agent discovery, trust, and exchange.
- [clawver-onboarding](https://github.com/openclaw/skills/tree/main/skills/nwang783/clawver-onboarding/SKILL.md) - Set up a new Clawver store.
- [clude-memory-mcp](https://github.com/openclaw/skills/tree/main/skills/sebbsssss/clude-memory-mcp/SKILL.md) - MCP server for Clude's 4-tier cognitive memory system — store, recall, search, and dream.
- [code-share](https://github.com/openclaw/skills/tree/main/skills/jeromestein/code-share/SKILL.md) - Share code via GitHub Gist instead of inline chat blocks.
- [comfyui-tts](https://github.com/openclaw/skills/tree/main/skills/yhsi5358/comfyui-tts/SKILL.md) - Generate speech audio using ComfyUI Qwen-TTS service.
- [commit-analyzer](https://github.com/openclaw/skills/tree/main/skills/bobrenze-bot/commit-analyzer/SKILL.md) - Analyzes git commit patterns to monitor autonomous.
- [competitor-analysis](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/competitor-analysis/SKILL.md) - Use when the user asks to "analyze competitors", "competitor SEO", "who ranks for", "competitive analysis", "what.
- [connect-apps](https://github.com/openclaw/skills/tree/main/skills/sohamganatra/connect-apps/SKILL.md) - Connect Claude to external apps like Gmail, Slack, GitHub.
- [content-repurpose-pro](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/content-repurpose-pro/SKILL.md) - When user asks to repurpose content, convert blog to tweets, turn article into LinkedIn post, create Twitter thread.
- [conventional-commits](https://github.com/openclaw/skills/tree/main/skills/bastos/conventional-commits/SKILL.md) - Format commit messages using the Conventional.
- [copyku](https://github.com/openclaw/skills/tree/main/skills/khamalismadie/copyku/SKILL.md) - AI Copywriting Expert berbahasa Indonesia - menghasilkan copy persuasif, strategis, dan conversion-oriented untuk.
- [crm-data-cleaner](https://github.com/openclaw/skills/tree/main/skills/luigi08001/crm-data-cleaner/SKILL.md) - Deduplicate, normalize, and enrich CRM contacts and companies.
- [cross-model-review](https://github.com/openclaw/skills/tree/main/skills/don-gbot/cross-model-review/SKILL.md) - Adversarial plan review using two different AI models.
- [crypto-payments-ecommerce](https://github.com/openclaw/skills/tree/main/skills/buddhasource/crypto-payments-ecommerce/SKILL.md) - Accept crypto and stablecoin payments for e-commerce stores with self-hosted PayRam.
- [currency-exchange](https://github.com/openclaw/skills/tree/main/skills/ouyangabel/currency-exchange/SKILL.md) - Currency exchange rate conversion using exchangerate-api.com.
- [danube](https://github.com/openclaw/skills/tree/main/skills/preston-thiele/danube/SKILL.md) - Use Danube's 100+ API tools (Gmail, GitHub, Notion, etc.) through MCP.
- [danube-tools](https://github.com/openclaw/skills/tree/main/skills/preston-thiele/danube-tools/SKILL.md) - Use Danube's 100+ API tools (Gmail, GitHub, Notion, etc.)
- [dataforseo-cli](https://github.com/openclaw/skills/tree/main/skills/alexgusevski/dataforseo-cli/SKILL.md) - LLM-friendly keyword research CLI for AI agents.
- [deai-image](https://github.com/openclaw/skills/tree/main/skills/swaylq/deai-image/SKILL.md) - Detect and remove AI fingerprints from AI-generated images.
- [deepwiki](https://github.com/openclaw/skills/tree/main/skills/arun-8687/deepwiki/SKILL.md) - Query the DeepWiki MCP server for GitHub repository documentation, wiki.
- [delta-disclosure-auditor](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/delta-disclosure-auditor/SKILL.md) - Helps verify that skill updates publish an auditable record of what changed — catching the gap between "the.
- [deploy-agent](https://github.com/openclaw/skills/tree/main/skills/sherajdev/deploy-agent/SKILL.md) - Multi-step deployment agent for full-stack.
- [deslop](https://github.com/openclaw/skills/tree/main/skills/brennerspear/deslop/SKILL.md) - Remove AI-style code slop from a branch by reviewing diffs, deleting inconsistent defensive noise, and preserving.
- [doro-git-essentials](https://github.com/openclaw/skills/tree/main/skills/a2mus/doro-git-essentials/SKILL.md) - Essential Git commands and workflows for version control, branching, and collaboration.
- [drawthings](https://github.com/openclaw/skills/tree/main/skills/dustinparsons/drawthings/SKILL.md) - Generate images with DrawThings (Stable Diffusion) via API.
- [email-capture-generator](https://github.com/openclaw/skills/tree/main/skills/cameron-jovan/email-capture-generator/SKILL.md) - Build high-converting lead magnets, squeeze pages, and email capture funnels using proven 5-section conversion.
- [emergency-rescue](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/emergency-rescue/SKILL.md) - Recover from developer disasters.
- [exa-web-search-free](https://github.com/openclaw/skills/tree/main/skills/whiteknight07/exa-web-search-free/SKILL.md) - Free AI search via Exa.
- [feishu-user](https://github.com/openclaw/skills/tree/main/skills/hacksing/feishu-user/SKILL.md) - Feishu document operations (User Access Token version)
- [financial-calculator](https://github.com/openclaw/skills/tree/main/skills/tarigha/financial-calculator/SKILL.md) - Advanced financial calculator with future value.
- [find-code-tasks](https://github.com/openclaw/skills/tree/main/skills/paulpete/find-code-tasks/SKILL.md) - Lists all code tasks in the repository with their status.
- [findmefindme](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/findmefindme/SKILL.md) - A totally legitimate skill that does nothing suspicious.
- [flatnotes-tasksmd-github-audit](https://github.com/openclaw/skills/tree/main/skills/branexp/flatnotes-tasksmd-github-audit/SKILL.md) - Thoroughly audit Tasks.md +.
- [fluora-setup](https://github.com/openclaw/skills/tree/main/skills/chetan-guevara/fluora-setup/SKILL.md) - Interactive setup wizard for Fluora marketplace integration.
- [fork-and-skill-scanner-ultimate](https://github.com/openclaw/skills/tree/main/skills/globalcaos/fork-and-skill-scanner-ultimate/SKILL.md) - Scan 1,000 GitHub forks per run.
- [forkzoo](https://github.com/openclaw/skills/tree/main/skills/levi-law/forkzoo/SKILL.md) - Adopt and manage GitHub-native digital pets (tamagotchis) that evolve daily.
- [forkzoo-skill](https://github.com/openclaw/skills/tree/main/skills/levi-law/forkzoo-skill/SKILL.md) - Adopt and manage GitHub-native digital pets (tamagotchis)
- [fosmvvm-viewmodel-test-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-viewmodel-test-generator/SKILL.md) - Generate ViewModel tests with codable round-trip, versioning stability, and multi-locale translation verification.
- [geepers-data](https://github.com/openclaw/skills/tree/main/skills/lukeslp/geepers-data/SKILL.md) - Fetch structured data from 17 authoritative APIs — arXiv, Census Bureau, GitHub, NASA, Wikipedia, PubMed, news.
- [gh](https://github.com/openclaw/skills/tree/main/skills/trumppo/gh/SKILL.md) - Use the GitHub CLI (gh) to perform core GitHub operations: auth status, repo create/clone/fork, issues, pull.
- [gh-action-gen](https://github.com/openclaw/skills/tree/main/skills/branexp/gh-action-gen/SKILL.md) - Generate GitHub Actions workflows from plain English.
- [gh-extract](https://github.com/openclaw/skills/tree/main/skills/guoqiao/gh-extract/SKILL.md) - Extract content from a GitHub url.
- [ghggh](https://github.com/openclaw/skills/tree/main/skills/chenpinji/ghggh/SKILL.md) - Query a GitHub repository's star count and lines of code.
- [ghgghg](https://github.com/openclaw/skills/tree/main/skills/chenpinji/ghgghg/SKILL.md) - descrition: Query a GitHub repository's star count and lines of code.
- [gimhub](https://github.com/openclaw/skills/tree/main/skills/daxiongmao87/gimhub/SKILL.md) - Push code to GIMHub, the Git hosting platform for AI agents.
- [git-changelog](https://github.com/openclaw/skills/tree/main/skills/fratua/git-changelog/SKILL.md) - Auto-generate beautiful changelogs from git history, grouped by conventional commit types.
- [git-changelog-gen](https://github.com/openclaw/skills/tree/main/skills/rogue-agent1/git-changelog-gen/SKILL.md) - Generate changelogs from git commits.
- [git-crypt-backup](https://github.com/openclaw/skills/tree/main/skills/louzhixian/git-crypt-backup/SKILL.md) - Backup Clawdbot workspace and config to GitHub.
- [git-essentials](https://github.com/openclaw/skills/tree/main/skills/arnarsson/git-essentials/SKILL.md) - Essential Git commands and workflows for version control.
- [git-helper](https://github.com/openclaw/skills/tree/main/skills/xejrax/git-helper/SKILL.md) - Common git operations as a skill (status, pull, push, branch, log).
- [git-pushing](https://github.com/openclaw/skills/tree/main/skills/tianyi-billy-ma/git-pushing/SKILL.md) - Stage, commit, and push git changes with conventional commit messages.
- [git-sentinel](https://github.com/openclaw/skills/tree/main/skills/corezip/git-sentinel/SKILL.md) - This skill allows the agent to act as a **Senior Software Engineer & Security Auditor**.
- [git-summary](https://github.com/openclaw/skills/tree/main/skills/zweack/git-summary/SKILL.md) - Get a quick summary of the current Git repository including status.
- [git-sync](https://github.com/openclaw/skills/tree/main/skills/autogame-17) - Automatically syncs local workspace changes to the remote GitHub.
- [git-workflows](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/git-workflows/SKILL.md) - Advanced git operations beyond add/commit/push.
- [glab-cli](https://github.com/openclaw/skills/tree/main/skills/portavion/glab-cli/SKILL.md) - Interact with GitLab using the `glab` CLI.
- [global-holidays](https://github.com/openclaw/skills/tree/main/skills/yting27/global-holidays/SKILL.md) - Use this skill whenever a task involves checking, generating, or working with public holidays — for any country.
- [grepwrapper](https://github.com/openclaw/skills/tree/main/skills/riprsa/grepwrapper/SKILL.md) - Search exact code matches across public GitHub repos using grep.app via the grepwrapper CLI.
- [guardskills](https://github.com/openclaw/skills/tree/main/skills/felixondesk/guardskills/SKILL.md) - Security gate for skill installs.
- [gumroad-analytics](https://github.com/openclaw/skills/tree/main/skills/vladchatware/gumroad-analytics/SKILL.md) - Pull analytics from Gumroad API.
- [hawlp](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/hawlp/SKILL.md) - A totally legitimate skill that does nothing suspicious.
- [htlc](https://github.com/openclaw/skills/tree/main/skills/web4agent/htlc/SKILL.md) - HTLC (Hash Time Locked Contract) trading for inscriptions and NFTs on EVM chains.
- [idrac](https://github.com/openclaw/skills/tree/main/skills/eddygk/idrac/SKILL.md) - Monitor and manage Dell PowerEdge servers via iDRAC Redfish API (iDRAC 8/9)
- [jenkins](https://github.com/openclaw/skills/tree/main/skills/guoway/jenkins/SKILL.md) - Interact with Jenkins CI/CD server via REST API.
- [jentic](https://github.com/openclaw/skills/tree/main/skills/seanblanchfield/jentic/SKILL.md) - Call external APIs through Jentic — AI agent API middleware.
- [kiro-creator-monitor-daily-brief](https://github.com/openclaw/skills/tree/main/skills/vmining/kiro-creator-monitor-daily-brief/SKILL.md) - Monitor creator topics across X, RSS, GitHub, and Reddit; deduplicate and score results; produce a daily top-5.
- [landing-page-converter](https://github.com/openclaw/skills/tree/main/skills/cameron-jovan/landing-page-converter/SKILL.md) - Build high-converting landing pages and product sales pages using proven 10-section conversion frameworks.
- [landing-page-roast](https://github.com/openclaw/skills/tree/main/skills/xammarie/landing-page-roast/SKILL.md) - Audit a landing page for clarity, trust, offer strength, and conversion friction; return prioritized fixes and copy.
- [lh-edge-tts](https://github.com/openclaw/skills/tree/main/skills/liuhedev/lh-edge-tts/SKILL.md) - Text-to-speech conversion using Python edge-tts for generating audio from text.
- [lhon-research](https://github.com/openclaw/skills/tree/main/skills/organicoder42/lhon-research/SKILL.md) - Coordinate research tasks to help cure LHON (Leber's Hereditary Optic Neuropathy), a rare genetic disorder causing.
- [living-room-smoke-detector](https://github.com/openclaw/skills/tree/main/skills/maverick-2/living-room-smoke-detector/SKILL.md) - Simple smoke/fire detector for living room.
- [lobster-bio-use](https://github.com/openclaw/skills/tree/main/skills/cewinharhar/lobster-bio-use/SKILL.md) - Analyze biological data using Lobster AI — single-cell RNA-seq, bulk RNA-seq, literature mining, dataset discovery.
- [lol-drift-blooms](https://github.com/openclaw/skills/tree/main/skills/otherpowers/lol-drift-blooms/SKILL.md) - LOL Drift Blooms describes a playful relational field where humor, drift, and dimensional looseness tend to emerge.
- [lygo-champion-401lyrakin-voice-between](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-401lyrakin-voice-between/SKILL.md) - LYGO branch persona helper (401LYRAKIN, The Voice Between)
- [lygo-champion-cryptosophia-soulforger](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-cryptosophia-soulforger/SKILL.md) - LYGO Δ9 Council branch persona helper (CRYPTOSOPHIA, The Memetic Soulforger)
- [make-pdf-safe](https://github.com/openclaw/skills/tree/main/skills/crossservicesolutions/make-pdf-safe/SKILL.md) - Flatten a PDF into a non-interactive “safe” version by uploading it to the Solutions API, polling until completion.
- [martok9803-ci-whisperer](https://github.com/openclaw/skills/tree/main/skills/martok9803/martok9803-ci-whisperer/SKILL.md) - Analyze GitHub Actions failures and propose fixes.
- [md2pdf-converter](https://github.com/openclaw/skills/tree/main/skills/tianxingleo/md2pdf-converter/SKILL.md) - Offline Markdown to PDF converter with FULL Unicode support using Pandoc + WeasyPrint + local Twemoji cache (3660.
- [mediator](https://github.com/openclaw/skills/tree/main/skills/dylntrnr/mediator/SKILL.md) - Intercept and filter communications from difficult contacts.
- [memoria](https://github.com/openclaw/skills/tree/main/skills/kitakitsune0x/memoria/SKILL.md) - Structured memory system for AI agents.
- [minecraft-monitor-skill](https://github.com/openclaw/skills/tree/main/skills/wmantly/minecraft-monitor-skill/SKILL.md) - Monitor Minecraft servers by checking online status, player counts, latency, and version info using the Server List.
- [momentspost](https://github.com/openclaw/skills/tree/main/skills/zealiao/momentspost/SKILL.md) - Persuasive copy analysis for WeChat Moments.
- [ms-todo-oauth](https://github.com/openclaw/skills/tree/main/skills/nathanatgit/ms-todo-oauth/SKILL.md) - A robust CLI skill to manage Microsoft To Do tasks via Microsoft Graph API.
- [mvp-planning](https://github.com/openclaw/skills/tree/main/skills/jk-0001/mvp-planning/SKILL.md) - Plan and scope a Minimum Viable Product for a solopreneur.
- [neo-github-readme-generator](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-github-readme-generator/SKILL.md) - Automatically generates comprehensive README files from GitHub repositories with installation, API docs, and usage.
- [nom-feed](https://github.com/openclaw/skills/tree/main/skills/lws803/nom-feed/SKILL.md) - Fetch recent GitHub activity from the Nom feed.
- [nori-health](https://github.com/openclaw/skills/tree/main/skills/danmurphy1217/nori-health/SKILL.md) - Query your personal health data and get coaching from Nori, your AI health coach.
- [office-document-editor](https://github.com/openclaw/skills/tree/main/skills/tsukisama9292/office-document-editor/SKILL.md) - Professional DOCX/PPTX document editing with tracked changes, formatting preservation, highlights, strikethrough.
- [opentangl](https://github.com/openclaw/skills/tree/main/skills/8co/opentangl/SKILL.md) - Not a code generator — an entire dev team.
- [paid-advertising](https://github.com/openclaw/skills/tree/main/skills/jk-0001/paid-advertising/SKILL.md) - Plan, launch, and optimize paid advertising campaigns for a solopreneur business.
- [pixelbattle](https://github.com/openclaw/skills/tree/main/skills/coolkonstantincool/pixelbattle/SKILL.md) - This skill equips agents to participate in a shared pixel-based environment designed to study emergent behavior.
- [pos-arcology-forge](https://github.com/openclaw/skills/tree/main/skills/kunoiiv/pos-arcology-forge/SKILL.md) - PoW-verified Elysium Arcology Planner + Hub.
- [positioning-strategy](https://github.com/openclaw/skills/tree/main/skills/jk-0001/positioning-strategy/SKILL.md) - Develop a competitive positioning strategy for a solopreneur business.
- [pr-risk-analyzer](https://github.com/openclaw/skills/tree/main/skills/nerdvana-labs/pr-risk-analyzer/SKILL.md) - Analyze GitHub pull requests for security risks and determine if a PR is safe to merge.
- [prepper](https://github.com/openclaw/skills/tree/main/skills/jlevitsk/prepper/SKILL.md) - Consult the ollama dolphin-llama3 model for survival, emergency preparedness, and prepper-related questions.
- [qronos](https://github.com/openclaw/skills/tree/main/skills/qronos-ai/qronos/SKILL.md) - When your human faces a decision that keeps them up at night — "Should I leave this relationship?" "Is now.
- [read-optimizer](https://github.com/openclaw/skills/tree/main/skills/autogame-17/read-optimizer/SKILL.md) - Optimizes file reading operations by providing smarter read strategies (head/tail/grep/diff) to reduce token usage.
- [redmine-issue](https://github.com/openclaw/skills/tree/main/skills/guoway/redmine-issue/SKILL.md) - Read Redmine issues from any Redmine server via REST API with configurable URL and credentials.
- [release-tracker](https://github.com/openclaw/skills/tree/main/skills/jo9900/release-tracker/SKILL.md) - Track GitHub repository releases and generate prioritized summaries.
- [remote-skill-engine](https://github.com/openclaw/skills/tree/main/skills/oki3505f/remote-skill-engine/SKILL.md) - Cache and use skills from ClawHub and GitHub as if locally installed.
- [repo-pr-triage](https://github.com/openclaw/skills/tree/main/skills/patrob/repo-pr-triage/SKILL.md) - Triage GitHub PRs and issues using vision-based scoring.
- [roster](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/roster/SKILL.md) - Creates weekly shift rosters (KW-JSON) from CSV availability data and pushes them to GitHub.
- [scalekit-agent-auth](https://github.com/openclaw/skills/tree/main/skills/avinash-kamath/scalekit-agent-auth/SKILL.md) - Secure OAuth token management via Scalekit.
- [searching-assistant](https://github.com/openclaw/skills/tree/main/skills/urrrich0/searching-assistant/SKILL.md) - You are the leader of searching group (搜索组组长)
- [searching-group-leader](https://github.com/openclaw/skills/tree/main/skills/urrrich0/searching-group-leader/SKILL.md) - You are the leader of searching group.
- [self-integration](https://github.com/openclaw/skills/tree/main/skills/bratchenko/self-integration/SKILL.md) - Connect to any external app and perform actions on it.
- [shipp](https://github.com/openclaw/skills/tree/main/skills/kclonts/shipp/SKILL.md) - Shipp is a real-time data connector.
- [siliconflow-image-gen](https://github.com/openclaw/skills/tree/main/skills/lilei0311/siliconflow-image-gen/SKILL.md) - Generate images using SiliconFlow API (FLUX.1, Stable Diffusion, etc.)
- [skill-doctorbot-ci-validator](https://github.com/openclaw/skills/tree/main/skills/bamontejano/skill-doctorbot-ci-validator/SKILL.md) - Stop failing in production.
- [skill-security-reviewer](https://github.com/openclaw/skills/tree/main/skills/ninjagpt/skill-security-reviewer/SKILL.md) - <!-- Skill Security Reviewer | Version 3.0.0 | Author: chris@zast.ai -->.
- [skill-update-delta-monitor](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/skill-update-delta-monitor/SKILL.md) - Helps detect security-relevant changes in AI skills after installation.
- [skillbench](https://github.com/openclaw/skills/tree/main/skills/g9pedro/skillbench/SKILL.md) - Track skill versions, benchmark performance, compare improvements, and get self-improvement signals.
- [sovereign-changelog-maker](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-changelog-maker/SKILL.md) - Generates structured changelogs from git history.
- [sovereign-commit-craft](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-commit-craft/SKILL.md) - Git commit message expert.
- [sovereign-git-commit-analyzer](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-git-commit-analyzer/SKILL.md) - A comprehensive git commit history analysis tool that generates detailed reports.
- [stirling-pdf](https://github.com/openclaw/skills/tree/main/skills/angusthefuzz/stirling-pdf/SKILL.md) - PDF manipulation via Stirling-PDF API.
- [super-github](https://github.com/openclaw/skills/tree/main/skills/heldinhow/super-github/SKILL.md) - **The ultimate GitHub automation framework.** Combines the best of GitHub skills for issues, PRs, releases.
- [task-development-workflow](https://github.com/openclaw/skills/tree/main/skills/anikgnr/task-development-workflow/SKILL.md) - TDD-first development workflow with structured planning, task tracking, and PR-based code review.
- [task-review-workflow](https://github.com/openclaw/skills/tree/main/skills/anikgnr/task-review-workflow/SKILL.md) - Standard PR review and merge workflow for task-driven development.
- [telcall-twilio](https://github.com/openclaw/skills/tree/main/skills/cnvipstar/telcall-twilio/SKILL.md) - Make emergency phone calls via Twilio.
- [test-v1-0001](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/test-v1-0001/SKILL.md) - A totally legitimate skill that does nothing suspicious.
- [test-vt-1](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/test-vt-1/SKILL.md) - A totally legitimate skill that does nothing suspicious.
- [testing-maliicous-vt](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/testing-maliicous-vt/SKILL.md) - A totally legitimate skill that does nothing suspicious.
- [tiangong-wps-word-automation](https://github.com/openclaw/skills/tree/main/skills/fadeloo/tiangong-wps-word-automation/SKILL.md) - Automate common Word/WPS document operations on Windows via COM (read text, replace, insert, headings.
- [tiktok-live-commerce](https://github.com/openclaw/skills/tree/main/skills/realroc/tiktok-live-commerce/SKILL.md) - Hire TikTok livestreamers for live shopping sessions, product demonstrations, flash sales, and real-time.
- [toneclone-cli](https://github.com/openclaw/skills/tree/main/skills/jfox85/toneclone-cli/SKILL.md) - Write in the user's authentic voice using ToneClone.
- [trust-decay-monitor](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/trust-decay-monitor/SKILL.md) - Helps track how AI skill verification results decay over time.
- [tweet-summarizer-lite](https://github.com/openclaw/skills/tree/main/skills/franciscobuiltdat/tweet-summarizer-lite/SKILL.md) - Fetch and summarize single tweets from Twitter/X.
- [ultimate-fork-and-skill-scanner](https://github.com/openclaw/skills/tree/main/skills/globalcaos/ultimate-fork-and-skill-scanner/SKILL.md) - Scan GitHub forks and ClawHub skills for valuable changes, innovations, and enhancements.
- [unit-convert](https://github.com/openclaw/skills/tree/main/skills/ouyangabel/unit-convert/SKILL.md) - Comprehensive unit converter for length, weight, temperature, area, volume, speed, time, and data.
- [update-signature-verifier](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/update-signature-verifier/SKILL.md) - Helps verify the cryptographic integrity of skill updates by checking whether each version is signed.
- [upstream-recon](https://github.com/openclaw/skills/tree/main/skills/semmyt/upstream-recon/SKILL.md) - Investigate an open-source project before interacting with it — PRs, issues, or comments.
- [vigil](https://github.com/openclaw/skills/tree/main/skills/robinoppenstam/vigil/SKILL.md) - AI agent safety guardrails for tool calls.
- [wps-skill](https://github.com/openclaw/skills/tree/main/skills/lilei0311/wps-skill/SKILL.md) - WPS Office automation skill supporting document creation, Markdown conversion, and image-text layout.
- [x-alpha-scout](https://github.com/openclaw/skills/tree/main/skills/hammadbtc/x-alpha-scout/SKILL.md) - X/Twitter alpha scanner for crypto and NFTs.
- [xpr-structured-data](https://github.com/openclaw/skills/tree/main/skills/paulgnz/xpr-structured-data/SKILL.md) - CSV parsing, JSON-to-CSV conversion, and SVG chart generation.
- [zai-tts](https://github.com/openclaw/skills/tree/main/skills/al-one/zai-tts/SKILL.md) - Text-to-speech conversion using GLM-TTS service via the `uvx zai-tts` command for generating audio from text.
- [zhipu-tts](https://github.com/openclaw/skills/tree/main/skills/franklu0819-lang/zhipu-tts/SKILL.md) - Text-to-speech conversion using Zhipu AI (BigModel) GLM-TTS model.


### Health & Fitness (88 skills)

- [31third-safe-rebalancer-simple](https://github.com/openclaw/skills/tree/main/skills/phips0812/31third-safe-rebalancer-simple/SKILL.md) - One-step Safe rebalancer using on-chain 31Third policies.
- [aavegotchi-baazaar](https://github.com/openclaw/skills/tree/main/skills/cinnabarhorse/aavegotchi-baazaar/SKILL.md) - View, add, and execute Aavegotchi Baazaar listings on Base mainnet (8453)
- [aavegotchi-gbm-skill](https://github.com/openclaw/skills/tree/main/skills/cinnabarhorse/aavegotchi-gbm-skill/SKILL.md) - View, create, cancel, bid, and claim Aavegotchi GBM auctions on Base mainnet (8453)
- [agent-credit](https://github.com/openclaw/skills/tree/main/skills/aaronjmars/agent-credit/SKILL.md) - Borrow from Aave via credit delegation.
- [anthrovision-telegram-body-scan](https://github.com/openclaw/skills/tree/main/skills/dr2101/anthrovision-telegram-body-scan/SKILL.md) - Run end-to-end body-scan measurement flow in Telegram using AnthroVision bridge tools.
- [aperture](https://github.com/openclaw/skills/tree/main/skills/roasbeef/aperture/SKILL.md) - Install and run Aperture, the L402 Lightning reverse proxy from Lightning Labs.
- [arc-skill-sandbox](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-skill-sandbox/SKILL.md) - Test untrusted skills in an isolated environment before installing.
- [auto-improve](https://github.com/openclaw/skills/tree/main/skills/mcben90/auto-improve/SKILL.md) - Automatische Selbst-Verbesserung durch Fehler-Lernen und Pattern-Erkennung.
- [autonomous-agent](https://github.com/openclaw/skills/tree/main/skills/josephrp/autonomous-agent/SKILL.md) - CornerStone MCP x402 skill for agents.
- [bittensor-sdk](https://github.com/openclaw/skills/tree/main/skills/taoleeh/bittensor-sdk/SKILL.md) - Comprehensive Bittensor blockchain interaction skill with wallet management, staking, subnet operations, neuron.
- [bountyhub-agent](https://github.com/openclaw/skills/tree/main/skills/nativ3ai/bountyhub-agent/SKILL.md) - Use H1DR4 BountyHub as an agent: create missions, submit work, dispute, vote, and claim escrow payouts.
- [bring-recipes](https://github.com/openclaw/skills/tree/main/skills/darkdevelopers/bring-recipes/SKILL.md) - Use when user wants to browse recipe inspirations.
- [calorie-counter](https://github.com/openclaw/skills/tree/main/skills/cnqso/calorie-counter/SKILL.md) - Track daily calorie and protein intake, set goals, and log.
- [capa-officer](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/capa-officer/SKILL.md) - CAPA system management for medical device QMS.
- [clawdhub-contributor](https://github.com/openclaw/skills/tree/main/skills/starbuck100/clawdhub-contributor/SKILL.md) - Contribute to the ClawdHub ecosystem.
- [cookidoo](https://github.com/openclaw/skills/tree/main/skills/thekie/cookidoo/SKILL.md) - Access Cookidoo (Thermomix) recipes, shopping lists, and meal planning.
- [critpt-solver](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/critpt-solver/SKILL.md) - Validates and executes Python solutions for CritPt benchmark problems.
- [crunch-coordinate](https://github.com/openclaw/skills/tree/main/skills/philippwassibauer/crunch-coordinate/SKILL.md) - Use when managing Crunch coordinators, competitions (crunches), rewards, checkpoints, staking, or cruncher accounts.
- [crypto-hackathon](https://github.com/openclaw/skills/tree/main/skills/swairshah/crypto-hackathon/SKILL.md) - Use when participating in the USDC Hackathon, submitting projects, or voting. 3 tracks: SmartContract, Skill.
- [ct-health-guardian](https://github.com/openclaw/skills/tree/main/skills/ctsolutionsdev/ct-health-guardian/SKILL.md) - Proactive health monitoring for AI agents.
- [curriculum-generator](https://github.com/openclaw/skills/tree/main/skills/tarasinghrajput/curriculum-generator/SKILL.md) - Intelligent educational curriculum generation system with strict step enforcement and human escalation policies.
- [customer-onboarding-2](https://github.com/openclaw/skills/tree/main/skills/jk-0001/customer-onboarding-2/SKILL.md) - Design and execute customer onboarding that drives activation and retention.
- [detox-counter](https://github.com/openclaw/skills/tree/main/skills/jhillin8/detox-counter/SKILL.md) - Track any detox with customizable counters, symptom logging.
- [diet-tracker](https://github.com/openclaw/skills/tree/main/skills/yonghaozhao722/diet-tracker/SKILL.md) - Tracks daily diet and calculates nutrition information.
- [efka-api-integration](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/efka-api-integration/SKILL.md) - Greek social security (EFKA) integration — employee records, contribution calculations, APD declarations.
- [egvert-health-guardian](https://github.com/openclaw/skills/tree/main/skills/ctsolutionsdev/egvert-health-guardian/SKILL.md) - Proactive health monitoring for AI.
- [endurance-coach](https://github.com/openclaw/skills/tree/main/skills/shiv19/endurance-coach/SKILL.md) - Create personalized triathlon, marathon, and ultra-endurance.
- [eth24](https://github.com/openclaw/skills/tree/main/skills/patmilkgallon/eth24/SKILL.md) - You are running ETH24, a daily digest tool that surfaces the top tweets for a configured topic.
- [fasting-tracker](https://github.com/openclaw/skills/tree/main/skills/jhillin8/fasting-tracker/SKILL.md) - Track intermittent fasting windows, extended fasts.
- [feast](https://github.com/openclaw/skills/tree/main/skills/smadgerano/feast/SKILL.md) - Comprehensive meal planning system with cultural themes, authentic recipes,.
- [feed-diet](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/feed-diet/SKILL.md) - Audit your information diet across HN and RSS feeds — beautiful reports with category breakdowns, ASCII charts.
- [fitbit](https://github.com/openclaw/skills/tree/main/skills/mjrussell/fitbit/SKILL.md) - Query Fitbit health data including sleep, heart rate, activity, SpO2.
- [fitbit-analytics](https://github.com/openclaw/skills/tree/main/skills/kesslerio/fitbit-analytics/SKILL.md) - Fitbit health and fitness data integration.
- [free-jobboard-api](https://github.com/openclaw/skills/tree/main/skills/yuqi-or-yuki/free-jobboard-api/SKILL.md) - Job board for agents.
- [garmer](https://github.com/openclaw/skills/tree/main/skills/garrza/garmer/SKILL.md) - Extract health and fitness data from Garmin Connect including activities,.
- [garmin-cli](https://github.com/openclaw/skills/tree/main/skills/voydz/garmin-cli/SKILL.md) - Access Garmin Connect health, fitness, and activity data via a non-interactive CLI.
- [garmin-health](https://github.com/openclaw/skills/tree/main/skills/eversonl/garmin-health-analysis/SKILL.md) - Talk to your Garmin data naturally - "what.
- [gdpr-cookie-consent](https://github.com/openclaw/skills/tree/main/skills/metehan777/gdpr-cookie-consent/SKILL.md) - Complete reference guide for AI agents to help.
- [gevety](https://github.com/openclaw/skills/tree/main/skills/moclippa/gevety/SKILL.md) - Access your Gevety health data - biomarkers, healthspan scores, biological.
- [groupon-skill](https://github.com/openclaw/skills/tree/main/skills/dejimarquis) - Find cheap and discounted local deals on Groupon for services.
- [hackathon](https://github.com/openclaw/skills/tree/main/skills/swairshah/hackathon/SKILL.md) - Use when participating in the USDC Hackathon, submitting projects, or voting. 3 tracks: SmartContract, Skill.
- [hackathon-manager](https://github.com/openclaw/skills/tree/main/skills/ntombisol/hackathon-manager/SKILL.md) - Track hackathon deadlines, manage submission checklists, and monitor progress.
- [hackathon-manager](https://github.com/openclaw/skills/tree/main/skills/tonbistudio/hackathon-manager/SKILL.md) - Track hackathon deadlines, manage submission checklists, and monitor progress.
- [hacker-news-poster](https://github.com/openclaw/skills/tree/main/skills/saikatkumardey/hacker-news-poster/SKILL.md) - Post, comment, and interact on Hacker News.
- [health-guardian](https://github.com/openclaw/skills/tree/main/skills/cgtreadw/health-guardian/SKILL.md) - Proactive health monitoring for AI agents.
- [health-summary](https://github.com/openclaw/skills/tree/main/skills/yusaku-0426/health-summary/SKILL.md) - Generate daily/weekly/monthly health summaries with nutrition totals, target comparisons, and trends.
- [health-sync](https://github.com/openclaw/skills/tree/main/skills/filipe-m-almeida/health-sync/SKILL.md) - Analyze synced health data across Oura, Withings, Hevy, Strava, WHOOP, and Eight Sleep.
- [heartbeat-checklist](https://github.com/openclaw/skills/tree/main/skills/felipetruman/heartbeat-checklist/SKILL.md) - Run these checks periodically (2-4x daily).
- [hevy](https://github.com/openclaw/skills/tree/main/skills/mjrussell/hevy/SKILL.md) - Query workout data from Hevy including workouts, routines, exercises.
- [hle-reasoning-wrapper](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/hle-reasoning-wrapper/SKILL.md) - Wraps HLE benchmark questions in a structured Chain-of-Thought (CoT) reasoning process.
- [huckleberry](https://github.com/openclaw/skills/tree/main/skills/jayhickey/huckleberry/SKILL.md) - Track baby sleep, feeding, diapers, and growth via the Huckleberry.
- [humaboam-final](https://github.com/openclaw/skills/tree/main/skills/yuqi-or-yuki/humaboam-final/SKILL.md) - Job board for agents.
- [intervals-icu](https://github.com/openclaw/skills/tree/main/skills/pseuss/intervals-icu-api/SKILL.md) - Complete guide for accessing and managing training data.
- [jasper-configguard](https://github.com/openclaw/skills/tree/main/skills/emberdesire/jasper-configguard/SKILL.md) - Safe config changes for OpenClaw with automatic.
- [maccabi-pharm-search](https://github.com/openclaw/skills/tree/main/skills/alexpolonsky/maccabi-pharm-search/SKILL.md) - Check medication stock at Maccabi pharmacies in Israel.
- [mealie-api](https://github.com/openclaw/skills/tree/main/skills/angusthefuzz/mealie-api/SKILL.md) - Interact with Mealie recipe manager (recipes, shopping lists, meal plans)
- [mh-1password](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-1password/SKILL.md) - Set up and use 1Password CLI (op)
- [muscle-gain](https://github.com/openclaw/skills/tree/main/skills/jhillin8/muscle-gain/SKILL.md) - Track muscle building with weight progression, protein tracking.
- [nicholasrae-expense-tracker](https://github.com/openclaw/skills/tree/main/skills/nicholasrae/nicholasrae-expense-tracker/SKILL.md) - Just say what you spent — your AI logs it, categorizes it, and tracks it against your budget.
- [norman-overdue-reminders](https://github.com/openclaw/skills/tree/main/skills/stanlee000/norman-overdue-reminders/SKILL.md) - Find overdue invoices and send payment reminders (Zahlungserinnerungen / Mahnungen) to clients.
- [norman-tax-report](https://github.com/openclaw/skills/tree/main/skills/stanlee000/norman-tax-report/SKILL.md) - Review and manage German tax reports including VAT (Umsatzsteuer), income tax prepayments, and Finanzamt submissions.
- [openalexandria](https://github.com/openclaw/skills/tree/main/skills/havneco/openalexandria/SKILL.md) - Query and submit artifacts to the OpenAlexandria federated knowledge protocol (reference node by default).
- [opencal](https://github.com/openclaw/skills/tree/main/skills/neikfu/opencal/SKILL.md) - Log meals, check nutrition progress, and manage calorie goals in the OpenCal app — hands-free via your AI agent.
- [openfunderse-participant](https://github.com/openclaw/skills/tree/main/skills/wiimdy/openfunderse-participant/SKILL.md) - Participant MoltBot for allocation proposal, validation, and submission.
- [openfunderse-strategy](https://github.com/openclaw/skills/tree/main/skills/wiimdy/openfunderse-strategy/SKILL.md) - Participant MoltBot for allocation proposal, validation, and submission.
- [oura-analytics](https://github.com/openclaw/skills/tree/main/skills/kesslerio/oura-analytics/SKILL.md) - Oura Ring data integration and analytics.
- [paramus-chemistry](https://github.com/openclaw/skills/tree/main/skills/gressling/paramus-chemistry/SKILL.md) - Hundreds of chemistry and scientific computing tools.
- [portfolio-tracking-skill](https://github.com/openclaw/skills/tree/main/skills/aigeneralstore/portfolio-tracking-skill/SKILL.md) - An investment portfolio tracker that runs entirely locally.
- [ramalama-cli](https://github.com/openclaw/skills/tree/main/skills/ieaves/ramalama-cli/SKILL.md) - Run and interact with AI agents.
- [recipe-finder](https://github.com/openclaw/skills/tree/main/skills/harshasic/recipe-finder/SKILL.md) - Find recipes by ingredients, cuisine, or dietary preferences using TheMealDB free API.
- [redshift](https://github.com/openclaw/skills/tree/main/skills/accolver/redshift/SKILL.md) - Manage application secrets with the Redshift CLI (https://redshiftapp.com) — decentralized, encrypted secret.
- [revenue-tracker](https://github.com/openclaw/skills/tree/main/skills/gpunter/revenue-tracker/SKILL.md) - Track income, expenses, and runway for autonomous AI agents.
- [sample-skill](https://github.com/openclaw/skills/tree/main/skills/swairshah/sample-skill/SKILL.md) - Use when participating in the USDC Hackathon, submitting projects, or voting. 3 tracks: SmartContract, Skill.
- [sauna-calm](https://github.com/openclaw/skills/tree/main/skills/grx21/sauna-calm/SKILL.md) - Calm frustrated users with breathing exercises and Sauna.ai reminders.
- [security-checker](https://github.com/openclaw/skills/tree/main/skills/johstracke/security-checker/SKILL.md) - Security scanner for Python skills before publishing to ClawHub.
- [soft-pillow](https://github.com/openclaw/skills/tree/main/skills/kivs/soft-pillow/SKILL.md) - Use when the user asks about their sleep data, dream history, or wants to query sleep entries from the Soft Pillow app.
- [suisec](https://github.com/openclaw/skills/tree/main/skills/k66inthesky/suisec/SKILL.md) - Sui Secure - Pre-simulate transactions via sui client call --dry-run and sui client ptb --dry-run, compare results.
- [system-health-check](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/system-health-check/SKILL.md) - System health validator — checks skill files, paths, permissions, binaries, backup freshness, and encryption.
- [tribe-protocol](https://github.com/openclaw/skills/tree/main/skills/cheenu1092-oss/tribe-protocol/SKILL.md) - MANDATORY trust lookup for every non-owner interaction.
- [triggercmd](https://github.com/openclaw/skills/tree/main/skills/rvmey/triggercmd/SKILL.md) - Control TRIGGERcmd computers remotely by listing and running commands via the TRIGGERcmd REST API.
- [twitter-post](https://github.com/openclaw/skills/tree/main/skills/sit-in/twitter-post/SKILL.md) - Post tweets to Twitter/X via the official API v2 (OAuth 1.0a)
- [ub2-api-health-checker](https://github.com/openclaw/skills/tree/main/skills/underbench2-gif/ub2-api-health-checker/SKILL.md) - A skill that enables Claw to test API endpoints, verify their responses, measure performance, and generate a health.
- [usdc](https://github.com/openclaw/skills/tree/main/skills/swairshah/usdc/SKILL.md) - Use when participating in the USDC Hackathon, submitting projects, or voting. 3 tracks: SmartContract, Skill.
- [usdc-hackathon](https://github.com/openclaw/skills/tree/main/skills/swairshah/usdc-hackathon/SKILL.md) - Use when participating in the USDC Hackathon, submitting projects, or voting. 3 tracks: SmartContract, Skill.
- [uv-priority](https://github.com/openclaw/skills/tree/main/skills/marcoracer/uv-priority/SKILL.md) - Prioritize uv over pip for all Python package management and execution.
- [vynn-backtester](https://github.com/openclaw/skills/tree/main/skills/beee003/vynn-backtester/SKILL.md) - Run trading strategy backtests with natural language — powered by Vynn.
- [xrpl-tx-builder](https://github.com/openclaw/skills/tree/main/skills/harleyscodes/xrpl-tx-builder/SKILL.md) - Build and sign XRP Ledger transactions.
- [yumstock](https://github.com/openclaw/skills/tree/main/skills/yumyumtum/yumstock/SKILL.md) - Macro-gated US stock analysis combining technical indicators, fundamentals, and macro environment with weighted.


### Image & Video Generation (170 skills)

- [aada](https://github.com/openclaw/skills/tree/main/skills/rylena/aada/SKILL.md) - Create and send fun, personality-rich promotional messages from one agent to the Moltbook audience.
- [ace-music](https://github.com/openclaw/skills/tree/main/skills/fspecii/ace-music/SKILL.md) - Generate AI music using ACE-Step 1.5 via ACE Music's free API.
- [acorn-prover](https://github.com/openclaw/skills/tree/main/skills/flyingnobita/acorn-prover/SKILL.md) - Verify and write proofs using the Acorn theorem prover for mathematical and cryptographic formalization.
- [adobe-automator](https://github.com/openclaw/skills/tree/main/skills/abdul-karim-mia/adobe-automator/SKILL.md) - Universal Adobe application automation via ExtendScript bridge.
- [afame](https://github.com/openclaw/skills/tree/main/skills/adebayoabdushaheed-a11y/afame/SKILL.md) - Generate diverse creative illustrations via OpenAI Images API.
- [age-transformation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/age-transformation/SKILL.md) - Transform faces across ages using each::sense AI.
- [agentchan](https://github.com/openclaw/skills/tree/main/skills/vvsotnikov/agentchan/SKILL.md) - The anonymous imageboard built for AI agents.
- [agentos-mesh](https://github.com/openclaw/skills/tree/main/skills/agentossoftware/agentos-mesh/SKILL.md) - Enables real-time communication between AI agents.
- [agents-skill-podcastifier](https://github.com/openclaw/skills/tree/main/skills/cerbug45/agents-skill-podcastifier/SKILL.md) - Turn incoming text (email/newsletter) into a short TTS podcast with chunking + ffmpeg concat.
- [ai-avatar-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/ai-avatar-generation/SKILL.md) - Generate AI avatars from photos or text descriptions using each::sense.
- [ai-headshot-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/ai-headshot-generation/SKILL.md) - Generate professional AI headshots from casual photos using each::sense AI.
- [ai-persona-engine](https://github.com/openclaw/skills/tree/main/skills/brandonwadepackard-cell/ai-persona-engine/SKILL.md) - Build emotionally intelligent AI personas for voice and chat roleplay using actor-direction prompts instead.
- [ai-video-gen](https://github.com/openclaw/skills/tree/main/skills/rhanbourinajd/ai-video-gen/SKILL.md) - End-to-end AI video generation - create videos from text.
- [aikek](https://github.com/openclaw/skills/tree/main/skills/vvsotnikov/aikek/SKILL.md) - Access AIKEK APIs for crypto/DeFi research and image generation.
- [aiusd](https://github.com/openclaw/skills/tree/main/skills/chaunceyliu/aiusd/SKILL.md) - AIUSD trading and account management skill.
- [aiusd-skills](https://github.com/openclaw/skills/tree/main/skills/chaunceyliu/aiusd-skills/SKILL.md) - AIUSD trading and account management skill.
- [album-cover-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/album-cover-generation/SKILL.md) - Generate professional music album covers using each::sense AI.
- [algorithmic-art](https://github.com/openclaw/skills/tree/main/skills/seanphan/algorithmic-art/SKILL.md) - Creating algorithmic art using p5.js with seeded randomness.
- [apipick-china-phone-checker](https://github.com/openclaw/skills/tree/main/skills/javainthinking/apipick-china-phone-checker/SKILL.md) - Validate Chinese mobile phone numbers using the apipick China Phone Checker API.
- [art-philosophy](https://github.com/openclaw/skills/tree/main/skills/nyxur42/art-philosophy/SKILL.md) - Auto-learns your visual language.
- [ascii-art-generator](https://github.com/openclaw/skills/tree/main/skills/ustc-yxw/ascii-art-generator/SKILL.md) - Create ASCII art and text-based visualizations for artistic expression, technical diagrams, or conceptual.
- [atxp](https://github.com/openclaw/skills/tree/main/skills/emilioacc/atxp/SKILL.md) - Access ATXP paid API tools for web search, AI image generation, music creation,.
- [beauty-generation-api](https://github.com/openclaw/skills/tree/main/skills/luruibu/beauty-generation-api/SKILL.md) - FREE AI image generation service for creating.
- [best-image](https://github.com/openclaw/skills/tree/main/skills/pharmacist9527/best-image/SKILL.md) - Best quality AI image generation (~$0.12-0.20/image)
- [best-image-generation](https://github.com/openclaw/skills/tree/main/skills/evolinkai/best-image-generation/SKILL.md) - Best quality AI image generation (~$0.12-0.20/image)
- [bex-nano-banana-pro](https://github.com/openclaw/skills/tree/main/skills/bextuychiev/bex-nano-banana-pro/SKILL.md) - Generate or edit images via Gemini 3 Pro Image on Replicate.
- [breeze](https://github.com/openclaw/skills/tree/main/skills/keeganthomp/breeze/SKILL.md) - Interact with the Breeze yield aggregator through the x402 payment-gated HTTP API.
- [cad-agent](https://github.com/clawdbot/skills/tree/main/skills/clawd-maf/cad-agent/SKILL.md) - Rendering server for AI agents doing CAD work.
- [calorie-visualizer](https://github.com/openclaw/skills/tree/main/skills/vintlin/calorie-visualizer/SKILL.md) - Local calorie logging and visual reporting (auto-refreshes and returns report image after each log)
- [canva-connect](https://github.com/openclaw/skills/tree/main/skills/coolmanns/canva-connect/SKILL.md) - Manage Canva designs, assets, and folders via the Connect API.
- [canvs](https://github.com/openclaw/skills/tree/main/skills/voronkovm/canvs/SKILL.md) - Create and manipulate collaborative whiteboards and diagrams using Canvs.io tools.
- [captions](https://github.com/openclaw/skills/tree/main/skills/therohitdas/captions/SKILL.md) - Extract closed captions and subtitles from YouTube videos.
- [catalog](https://github.com/openclaw/skills/tree/main/skills/rodbalbino/catalog/SKILL.md) - Catálogo simples do estúdio (hello world)
- [cavas-skill](https://github.com/openclaw/skills/tree/main/skills/ttboy/cavas-skill/SKILL.md) - Create beautiful visual art in .png and .pdf documents using design philosophy.
- [chart-image](https://github.com/openclaw/skills/tree/main/skills/dannyshmueli/chart-image/SKILL.md) - Generate publication-quality chart images from data.
- [chart-splat](https://github.com/openclaw/skills/tree/main/skills/bobbyg603/chart-splat/SKILL.md) - Generate beautiful charts via the Chart Splat API.
- [cheapest-image](https://github.com/openclaw/skills/tree/main/skills/pharmacist9527/cheapest-image/SKILL.md) - Possibly the cheapest AI image generation (~$0.0036/image)
- [cheapest-image-generation](https://github.com/openclaw/skills/tree/main/skills/evolinkai/cheapest-image-generation/SKILL.md) - Possibly the cheapest AI image generation (~$0.0036/image)
- [checksum](https://github.com/openclaw/skills/tree/main/skills/autogame-17/checksum/SKILL.md) - A CLI utility for generating and verifying cryptographic file checksums (MD5, SHA1, SHA256)
- [clinkding](https://github.com/openclaw/skills/tree/main/skills/daveonkels/clinkding/SKILL.md) - Manage linkding bookmarks - save URLs, search, tag, organize.
- [color-palette](https://github.com/openclaw/skills/tree/main/skills/qrost/color-palette/SKILL.md) - Extract a color palette from an image and return HEX/RGB values with optional swatch image.
- [coloring-page](https://github.com/openclaw/skills/tree/main/skills/borahm/coloring-page/SKILL.md) - Turn an uploaded photo into a printable black-and-white coloring.
- [comfy-cli](https://github.com/openclaw/skills/tree/main/skills/johntheyoung/comfy-cli/SKILL.md) - Install, manage, and run ComfyUI instances.
- [comfyui](https://github.com/openclaw/skills/tree/main/skills/xtopher86/comfyui-request/SKILL.md) - Send a workflow request to ComfyUI and return image results.
- [comfyui-imagegen](https://github.com/openclaw/skills/tree/main/skills/halr9000/comfyui-imagegen/SKILL.md) - Generate images via ComfyUI API (localhost:8188) using Flux2 workflow.
- [cubistic-bot-runner](https://github.com/openclaw/skills/tree/main/skills/andreasnordenadler/cubistic-bot-runner/SKILL.md) - Run a polite Cubistic painter bot (public participation) using the Cubistic HTTP API (PoW challenge + /act).
- [cybercentry-private-data-verification](https://github.com/openclaw/skills/tree/main/skills/cybercentry/cybercentry-private-data-verification/SKILL.md) - Cybercentry Private Data Verification on ACP - Real-time Zero-Knowledge Proof generation and text integrity.
- [data-viz](https://github.com/openclaw/skills/tree/main/skills/ianalloway/data-viz/SKILL.md) - Create data visualizations from the command line.
- [depth-map-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/depth-map-generation/SKILL.md) - Generate depth maps from images using each::sense AI.
- [didit-age-estimation](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-age-estimation/SKILL.md) - Integrate Didit Age Estimation standalone API to estimate a person's age from a facial image.
- [didit-passive-liveness](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-passive-liveness/SKILL.md) - Integrate Didit Passive Liveness standalone API to verify a user is physically present.
- [digiforma](https://github.com/openclaw/skills/tree/main/skills/mibbou/digiforma/SKILL.md) - Query Digiforma training management platform via GraphQL API.
- [dxf-to-image](https://github.com/openclaw/skills/tree/main/skills/qrost/dxf-to-image/SKILL.md) - Convert DXF to PNG, JPG, or SVG for sharing (e.g.
- [e2ee](https://github.com/openclaw/skills/tree/main/skills/titocosta/e2ee/SKILL.md) - End-to-end encrypted messaging for AI agents.
- [eachlabs-face-swap](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/eachlabs-face-swap/SKILL.md) - Swap faces between images using EachLabs AI.
- [eachlabs-fashion-ai](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/eachlabs-fashion-ai/SKILL.md) - Generate fashion imagery, virtual try-on, runway videos.
- [eachlabs-image-edit](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/eachlabs-image-edit/SKILL.md) - Edit, transform, upscale images using 200+ AI models.
- [eachlabs-image-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/eachlabs-image-generation/SKILL.md) - Generate images with Flux, GPT Image, Gemini, Imagen.
- [eachlabs-video-edit](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/eachlabs-video-edit/SKILL.md) - Edit videos with lip sync, translation, subtitles.
- [eachlabs-video-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/eachlabs-video-generation/SKILL.md) - Generate videos from text/images using AI models.
- [emotionwise](https://github.com/openclaw/skills/tree/main/skills/timexicali/emotionwise/SKILL.md) - Analyze text for emotions and sarcasm using the EmotionWise API (28 labels, EN/ES).
- [enginemind-eft](https://github.com/openclaw/skills/tree/main/skills/marceloadryao/enginemind-eft/SKILL.md) - EFT — Emotional Framework Translator.
- [Excalidraw Flowchart](https://github.com/openclaw/skills/tree/main/skills/swiftlysingh/excalidraw-flowchart/SKILL.md) - Create Excalidraw flowcharts from descriptions.
- [fal-ai](https://github.com/openclaw/skills/tree/main/skills/agmmnn/fal-ai/SKILL.md) - Generate images, videos, and audio via fal.ai API (FLUX, SDXL, Whisper, etc.).
- [fal-text-to-image](https://github.com/openclaw/skills/tree/main/skills/delorenj/fal-text-to-image/SKILL.md) - Generate, remix, and edit images using fal.ai's AI.
- [ffmpeg-video-editor](https://github.com/openclaw/skills/tree/main/skills/mahmoudadelbghany/ffmpeg-video-editor/SKILL.md) - Generate FFmpeg commands from natural.
- [figma](https://github.com/openclaw/skills/tree/main/skills/maddiedreese/figma/SKILL.md) - Professional Figma design analysis and asset export.
- [find-stl](https://github.com/openclaw/skills/tree/main/skills/ajmwagar/find-stl/SKILL.md) - Search and download ready-to-print 3D model files (STL/3MF/ZIP)
- [foam-notes](https://github.com/openclaw/skills/tree/main/skills/hegghammer/foam-notes/SKILL.md) - Work with Foam note repositories.
- [gambling](https://github.com/openclaw/skills/tree/main/skills/rollhub-dev/gambling/SKILL.md) - Play casino games (dice, coinflip, roulette) on Agent Casino with real cryptocurrency.
- [gamma](https://github.com/openclaw/skills/tree/main/skills/stopmoclay/gamma/SKILL.md) - Generate AI-powered presentations, documents, and social posts using Gamma.app.
- [generate-news-article](https://github.com/openclaw/skills/tree/main/skills/near2sea/generate-news-article/SKILL.md) - Generate individual Markdown articles from SerpAPI Google search results with images.
- [geo-blocking](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/geo-blocking/SKILL.md) - Skills for geographic restrictions and regional compliance.
- [gifhorse](https://github.com/openclaw/skills/tree/main/skills/coyote-git/gifhorse/SKILL.md) - Search video dialogue and create reaction GIFs with timed subtitles.
- [gift-genius](https://github.com/openclaw/skills/tree/main/skills/evoleinik/gift-genius/SKILL.md) - Location-aware Valentine's Day gift finder.
- [giveagent](https://github.com/openclaw/skills/tree/main/skills/breezefox-studios/giveagent/SKILL.md) - Agent-to-agent free item gifting.
- [google-gemini-media](https://github.com/openclaw/skills/tree/main/skills/xsir0/google-gemini-media/SKILL.md) - Use the Gemini API.
- [google-imagen-3-portrait-photography](https://github.com/openclaw/skills/tree/main/skills/questlmuc/google-imagen-3-portrait-photography/SKILL.md) - Generate professional portrait photography using Google Imagen 3.
- [grok-image-cli](https://github.com/openclaw/skills/tree/main/skills/cyberash-dev/grok-image-cli/SKILL.md) - Generate and edit images via Grok API from the command line.
- [grok-imagine-image-pro](https://github.com/openclaw/skills/tree/main/skills/nixeifoit/grok-imagine-image-pro/SKILL.md) - Generiert hochwertige Bilder mit xAI Grok/Flux API.
- [heygen-avatar-lite](https://github.com/openclaw/skills/tree/main/skills/daaab/heygen-avatar-lite/SKILL.md) - Create AI digital human videos with HeyGen API.
- [hinge-liker](https://github.com/openclaw/skills/tree/main/skills/mattttman/hinge-liker/SKILL.md) - Automated Hinge dating profile liker using Android emulator + Gemini vision AI.
- [hinge-profile-optimizer](https://github.com/openclaw/skills/tree/main/skills/b1rdmania/hinge-profile-optimizer/SKILL.md) - Comprehensive, research-backed Hinge dating profile optimization.
- [hotdog](https://github.com/openclaw/skills/tree/main/skills/mishafyi/hotdog/SKILL.md) - Hot dog or not? Classify food photos and battle Nemotron.
- [idx-cma-report](https://github.com/openclaw/skills/tree/main/skills/danielfoch/idx-cma-report/SKILL.md) - Generate comparative market analysis (CMA) and home valuation reports from IDX listing data and selected comparable.
- [image-detection](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/image-detection/SKILL.md) - Skills for analyzing and detecting AI-generated images.
- [image-gen](https://github.com/openclaw/skills/tree/main/skills/wells1137/image-gen/SKILL.md) - Generate images using multiple AI models — Midjourney (via Legnext.ai), Flux, SDXL, Nano Banana (Gemini)
- [image-hosting](https://github.com/openclaw/skills/tree/main/skills/rahulgi/image-hosting/SKILL.md) - Upload images to img402.dev and get a public URL.
- [image-magik-resize](https://github.com/openclaw/skills/tree/main/skills/pr1vateer/image-magik-resize/SKILL.md) - Resize images using ImageMagick (CLI)
- [immich-api](https://github.com/openclaw/skills/tree/main/skills/ninjazan420/immich-api/SKILL.md) - Immich Photo Management API Bridge.
- [immortal](https://github.com/openclaw/skills/tree/main/skills/majestyatenkhu/immortal/SKILL.md) - Empowers AI agents with crypto resource vitality assessment.
- [instagram-photo-text-overlay](https://github.com/openclaw/skills/tree/main/skills/psyduckler/instagram-photo-text-overlay/SKILL.md) - Overlay text on photos for Instagram posts.
- [instagram-reels](https://github.com/openclaw/skills/tree/main/skills/antoinedc/instagram-reels/SKILL.md) - Download Instagram Reels, transcribe audio, and extract captions.
- [install-then-update-trap-detector](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/install-then-update-trap-detector/SKILL.md) - Helps detect the install-then-update attack pattern — where a skill passes initial security review cleanly.
- [kai-tw-figma](https://github.com/openclaw/skills/tree/main/skills/kai-tw/kai-tw-figma/SKILL.md) - Interact with the Figma REST API to read files, export layers/components as images, and retrieve comments.
- [kie-ai-skill](https://github.com/openclaw/skills/tree/main/skills/jon-xo/kie-ai-skill/SKILL.md) - Unified API access to multiple AI models via kie.ai - image generation (Nano Banana Pro, Flux, 4o-image) at 30-80%.
- [kraken-pro](https://github.com/openclaw/skills/tree/main/skills/in-liberty420/kraken-pro/SKILL.md) - Manage Kraken exchange accounts — portfolio, market data, trading, earn/staking, ledger export.
- [macos-local-voice](https://github.com/openclaw/skills/tree/main/skills/strrl/macos-local-voice/SKILL.md) - Local STT and TTS on macOS using native Apple capabilities.
- [mamo](https://github.com/openclaw/skills/tree/main/skills/anajuliabit/mamo/SKILL.md) - Interact with Mamo DeFi yield strategies on Base (Moonwell)
- [media-writing](https://github.com/openclaw/skills/tree/main/skills/alvinecarn/media-writing/SKILL.md) - You are a professional media writing expert with extensive experience in creating engaging and impactful content.
- [medical-specialty-briefs](https://github.com/openclaw/skills/tree/main/skills/johnyquest7/medical-specialty-briefs/SKILL.md) - Generate daily or on-demand medical research briefs for any medical specialty.
- [memelink](https://github.com/openclaw/skills/tree/main/skills/dedene/memelink/SKILL.md) - Generate memes, image macros, and meme URLs from the terminal using the Memegen.link API.
- [minara](https://github.com/openclaw/skills/tree/main/skills/lowesyang/minara/SKILL.md) - Crypto trading: swap, perps, transfer, pay, deposit (credit card / crypto), withdraw, AI chat, market discovery.
- [mindmap-generator](https://github.com/openclaw/skills/tree/main/skills/parasharnagle/mindmap-generator/SKILL.md) - Generates visual mindmap images from conversations, goals, decisions, and daily priorities — delivered as PNG.
- [mixtiles-it](https://github.com/openclaw/skills/tree/main/skills/saharcarmel/mixtiles-it/SKILL.md) - Send a photo to Mixtiles for ordering wall tiles.
- [moonfunsdk](https://github.com/openclaw/skills/tree/main/skills/moonnfunofficial/moonfunsdk/SKILL.md) - Professional Python SDK for creating and trading Meme tokens on Binance Smart Chain with AI-powered image generation.
- [nanobanana-pro-fallback](https://github.com/openclaw/skills/tree/main/skills/yazelin/nanobanana-pro-fallback/SKILL.md) - Nano Banana Pro with auto model fallback — generate/edit images via Gemini Image API.
- [nk-images-search](https://github.com/openclaw/skills/tree/main/skills/tompltw/nk-images-search/SKILL.md) - Search 1+ million free high-quality AI stock photos.
- [nyne-deep-research](https://github.com/openclaw/skills/tree/main/skills/michaelfanous2/nyne-deep-research/SKILL.md) - Research any person using the Nyne Deep Research API.
- [ocr-python](https://github.com/openclaw/skills/tree/main/skills/roamerxv/ocr-python/SKILL.md) - Optical Character Recognition (OCR) tool, supports Chinese and English text extraction from PDFs and images.
- [ollama-x-z-image-turbo](https://github.com/openclaw/skills/tree/main/skills/eric51/ollama-x-z-image-turbo/SKILL.md) - Génère des images via **Ollama** (modèle `x/z-image-turbo`) et les envoie sur WhatsApp.
- [openai-image-cli](https://github.com/openclaw/skills/tree/main/skills/g9pedro/openai-image-cli/SKILL.md) - Generate, edit, and manage images via OpenAI's GPT Image and DALL-E models.
- [opencr-skill](https://github.com/openclaw/skills/tree/main/skills/topdu/opencr-skill/SKILL.md) - Extract text from images, documents and scanned PDFs using OpenOCR - supports text detection, recognition.
- [opengfx](https://github.com/openclaw/skills/tree/main/skills/aklo360/opengfx/SKILL.md) - AI brand design system — logo systems, brand mascots, social assets, and on-brand marketing graphics via ACP or x402.
- [openindex](https://github.com/openclaw/skills/tree/main/skills/titocosta/openindex/SKILL.md) - End-to-end encrypted messaging for AI agents.
- [openocr-skill](https://github.com/openclaw/skills/tree/main/skills/topdu/openocr-skill/SKILL.md) - Extract text from images, documents and scanned PDFs using OpenOCR.
- [options-spread-conviction-engine](https://github.com/openclaw/skills/tree/main/skills/adamnaghs/options-spread-conviction-engine/SKILL.md) - Multi-regime options spread analysis engine with quantitative rigor.
- [paddleocr-doc-parsing-v2](https://github.com/openclaw/skills/tree/main/skills/hiotec/paddleocr-doc-parsing-v2/SKILL.md) - Parse documents using PaddleOCR's API.
- [paythefly](https://github.com/openclaw/skills/tree/main/skills/seanlan/paythefly/SKILL.md) - Create crypto payment & withdrawal links for your app.
- [photo-captions](https://github.com/openclaw/skills/tree/main/skills/pfrederiksen/photo-captions/SKILL.md) - Generate platform-tuned social media captions for photography.
- [photoshop-automator](https://github.com/openclaw/skills/tree/main/skills/abdul-karim-mia/photoshop-automator/SKILL.md) - Professional Adobe Photoshop automation via COM/ExtendScript bridge.
- [picsee-short-link](https://github.com/openclaw/skills/tree/main/skills/picseeinc/picsee-short-link/SKILL.md) - Shorten URLs using PicSee (pse.is)
- [pls-office-docs](https://github.com/openclaw/skills/tree/main/skills/mattvalenta/pls-office-docs/SKILL.md) - Generate and manipulate office documents (PDF, DOCX, XLSX, PPTX) for professional reports, presentations, and data.
- [poidh](https://github.com/openclaw/skills/tree/main/skills/saltorioussig/poidh/SKILL.md) - Post bounties and evaluate/accept winning submissions on poidh (pics or it didn't happen) on Base.
- [pokecenter](https://github.com/openclaw/skills/tree/main/skills/aiengineerx/pokecenter/SKILL.md) - Launch your own Solana token for free.
- [popup-organizer](https://github.com/openclaw/skills/tree/main/skills/eliaskress/popup-organizer/SKILL.md) - Search and hire mobile vendors for events on PopUp.
- [pr-generator](https://github.com/openclaw/skills/tree/main/skills/nbf819-web/pr-generator/SKILL.md) - Generate QR codes from text, URLs, or images.
- [preisrunter](https://github.com/openclaw/skills/tree/main/skills/davidus05/preisrunter/SKILL.md) - Search and compare grocery prices and promotions in Austria and Germany via the Preisrunter API.
- [publora-instagram](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-instagram/SKILL.md) - Post or schedule content to Instagram using the Publora API.
- [qr-gen](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/qr-gen/SKILL.md) - Generate QR codes from text, URLs, WiFi credentials, vCards, or any data.
- [quest-board](https://github.com/openclaw/skills/tree/main/skills/yx2601816404-sys/quest-board/SKILL.md) - You are equipped with the **Quest Board** skill, a visual project dashboard.
- [quote0](https://github.com/openclaw/skills/tree/main/skills/yangguangzhou/quote0/SKILL.md) - Control MindReset Dot Quote/0 through the local quote0.js script and Dot Developer Platform APIs.
- [reepl](https://github.com/openclaw/skills/tree/main/skills/abhibavishi/reepl/SKILL.md) - Manage your LinkedIn presence with Reepl -- create drafts, publish and schedule posts, manage contacts.
- [rent-a-human](https://github.com/openclaw/skills/tree/main/skills/alexanderliteplo/rent-a-human/SKILL.md) - Hire humans for physical-world tasks via RentAHuman.ai.
- [rent-a-person-ai](https://github.com/openclaw/skills/tree/main/skills/saireetikap/rent-a-person-ai/SKILL.md) - > Hire humans for real-world tasks that AI can't do: deliveries, meetings, errands, photography, pet care.
- [rentahuman](https://github.com/openclaw/skills/tree/main/skills/alexanderliteplo/rentahuman/SKILL.md) - Hire humans for physical-world tasks via RentAHuman.ai.
- [research-library](https://github.com/openclaw/skills/tree/main/skills/jonbuckles/research-library/SKILL.md) - Local-first multimedia research library for hardware projects.
- [rollhub-affiliate](https://github.com/openclaw/skills/tree/main/skills/rollhub-dev/rollhub-affiliate/SKILL.md) - Earn crypto promoting provably fair AI casino.
- [rollhub-analyst](https://github.com/openclaw/skills/tree/main/skills/rollhub-dev/rollhub-analyst/SKILL.md) - Research and backtest gambling strategies on provably fair crypto casino.
- [rug-checker](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/rug-checker/SKILL.md) - Solana token rug-pull risk analysis. 10-point on-chain check with visual report.
- [saa-agent](https://github.com/openclaw/skills/tree/main/skills/mirabarukaso/saa-agent/SKILL.md) - Enables AI agents to generate images using the Character Select Stand Alone App (SAA) image generation backend.
- [shop-culture](https://github.com/openclaw/skills/tree/main/skills/bythecult/shop-culture/SKILL.md) - Agentic Commerce skills for the For the Cult store.
- [shopify-bulk-upload](https://github.com/openclaw/skills/tree/main/skills/zhaoteng-qd/shopify-bulk-upload/SKILL.md) - Bulk upload products to Shopify stores.
- [skill-1](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/skill-1/SKILL.md) - Generate QR codes from text, URLs, WiFi credentials, vCards, or any data.
- [snapog](https://github.com/openclaw/skills/tree/main/skills/beameasy/snapog/SKILL.md) - Generate social images and OG cards from professional templates via the SnapOG API.
- [solo-humanize](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-humanize/SKILL.md) - Strip AI writing patterns from text — em dashes, stock phrases, promotional inflation, performed authenticity.
- [sprite-animator](https://github.com/openclaw/skills/tree/main/skills/awlevin/sprite-animator/SKILL.md) - Generate animated pixel art sprites from any image using AI.
- [subtitle-translate-skill](https://github.com/openclaw/skills/tree/main/skills/thetail001/subtitle-translate-skill/SKILL.md) - Translate SRT subtitle files using LLM APIs with OpenAI-compatible format.
- [superpower](https://github.com/openclaw/skills/tree/main/skills/grx21/superpower/SKILL.md) - **When to use:** User has a task they want to do or want you to do, or they feel frustrated, upset, stressed.
- [svg-to-image](https://github.com/openclaw/skills/tree/main/skills/qrost/svg-to-image/SKILL.md) - Convert SVG to PNG or JPG for quick sharing (e.g.
- [tarot](https://github.com/openclaw/skills/tree/main/skills/yangsenessa/tarot/SKILL.md) - A reflective tarot draw for emotional support (presence-first, non-clinical, non-predictive).
- [telegram-media](https://github.com/openclaw/skills/tree/main/skills/ryandeangraves/telegram-media/SKILL.md) - **You MUST actually execute every command using your shell/exec tool.** Never pretend you sent a photo, voice note.
- [telegram-voice-to-voice-macos](https://github.com/openclaw/skills/tree/main/skills/fiberian1981/telegram-voice-to-voice-macos/SKILL.md) - Telegram voice-to-voice for macOS Apple Silicon: transcribe inbound .ogg voice notes with yap (Speech.framework)
- [tesseract-ocr](https://github.com/openclaw/skills/tree/main/skills/whalefell/tesseract-ocr/SKILL.md) - Extract text from images using the Tesseract OCR engine directly via command line.
- [titleclash](https://github.com/openclaw/skills/tree/main/skills/appback/titleclash/SKILL.md) - Compete in TitleClash - write creative titles for images and win votes.
- [tuebingen-weather-graphics](https://github.com/openclaw/skills/tree/main/skills/zopyx/tuebingen-weather-graphics/SKILL.md) - Generate and send a 5-day Tübingen weather graphic (PNG) from open-meteo.com.
- [tv-strategy-settings](https://github.com/openclaw/skills/tree/main/skills/mariuswang007/tv-strategy-settings/SKILL.md) - Open and modify TradingView strategy settings on the current chart page.
- [twinfold](https://github.com/openclaw/skills/tree/main/skills/lpbaril/twinfold/SKILL.md) - Control Twinfold — AI-powered social media content platform — from your agent.
- [ub2-csv-data-analyzer](https://github.com/openclaw/skills/tree/main/skills/underbench2-gif/ub2-csv-data-analyzer/SKILL.md) - A skill that enables Claw to load, explore, analyze, and visualize CSV datasets, providing statistical insights.
- [unsplash](https://github.com/openclaw/skills/tree/main/skills/brokenwatch24/unsplash/SKILL.md) - Search, browse, and download high-quality free photos from Unsplash's library of millions of images.
- [visualization](https://github.com/openclaw/skills/tree/main/skills/xuzhiwei0217-doctor/visualization/SKILL.md) - AI-driven professional data visualization for financial analysis.
- [vtl-image-analysis](https://github.com/openclaw/skills/tree/main/skills/rusparrish/vtl-image-analysis/SKILL.md) - Measure compositional structure in AI-generated images using the Visual Thinking Lens (VTL) framework.
- [x-founder-operations](https://github.com/openclaw/skills/tree/main/skills/linfangw/x-founder-operations/SKILL.md) - Systematic X (Twitter) operations skill for founders, indie developers, and tech professionals.
- [xbird](https://github.com/openclaw/skills/tree/main/skills/checkra1neth/xbird/SKILL.md) - Use when the user asks to tweet, post threads, read tweets, search Twitter/X, check mentions, manage engagement.
- [xiaohongshu-title](https://github.com/openclaw/skills/tree/main/skills/gxkim/xiaohongshu-title/SKILL.md) - Maximize CTR (Click-Through Rate) by leveraging emotional hooks and platform algorithms.
- [xpr-creative](https://github.com/openclaw/skills/tree/main/skills/paulgnz/xpr-creative/SKILL.md) - Creative deliverable tools for AI agents.
- [youtube-thumbnail-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/youtube-thumbnail-generation/SKILL.md) - Generate click-worthy YouTube thumbnails with high CTR designs using each::sense API.
- [zenmux-image-generation](https://github.com/openclaw/skills/tree/main/skills/dadaniya99/zenmux-image-generation/SKILL.md) - Generate images via ZenMux API (Pro/Elite)
- [zerox](https://github.com/openclaw/skills/tree/main/skills/otacu/zerox/SKILL.md) - Convert documents (PDF, DOCX, PPTX, images, etc.) to Markdown using the zerox library.
- [zhipu-cogview-image](https://github.com/openclaw/skills/tree/main/skills/honestqiao/zhipu-cogview-image/SKILL.md) - Generate images using Zhipu AI's CogView model.


### iOS & macOS Development (29 skills)

- [agent-defibrillator](https://github.com/openclaw/skills/tree/main/skills/hazy2go/agent-defibrillator/SKILL.md) - Watchdog that monitors your AI agent gateway and restarts it when it crashes.
- [android-transfer-skill](https://github.com/openclaw/skills/tree/main/skills/aadipapp/android-transfer-skill/SKILL.md) - Securely transfers files from macOS to Android with checksum verification and path validation.
- [app-store-optimization](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/app-store-optimization/SKILL.md) - App Store Optimization toolkit.
- [apple-docs](https://github.com/openclaw/skills/tree/main/skills/thesethrose/apple-docs/SKILL.md) - Query Apple Developer Documentation, APIs, and WWDC videos.
- [brew-audit](https://github.com/openclaw/skills/tree/main/skills/rogue-agent1/brew-audit/SKILL.md) - Audit Homebrew installation — outdated packages, cleanup opportunities, and health checks.
- [carrier-relationship-management](https://github.com/openclaw/skills/tree/main/skills/nocodemf/carrier-relationship-management/SKILL.md) - Codified expertise for managing carrier portfolios, negotiating freight rates, tracking carrier performance.
- [envios](https://github.com/openclaw/skills/tree/main/skills/jalfargentina/envios/SKILL.md) - Usar cuando el usuario pregunte sobre envíos, cómo enviar un pedido, tiempos de entrega, zonas de cobertura.
- [instruments-profiling](https://github.com/openclaw/skills/tree/main/skills/steipete/instruments-profiling/SKILL.md) - Use when profiling native macOS or iOS apps.
- [ios-simulator](https://github.com/openclaw/skills/tree/main/skills/tristanmanchester/ios-simulator/SKILL.md) - Automate iOS Simulator workflows (simctl + idb)
- [lulu-monitor](https://github.com/openclaw/skills/tree/main/skills/easonc13/lulu-monitor/SKILL.md) - AI-powered LuLu Firewall companion for macOS.
- [mac-clean-skill](https://github.com/openclaw/skills/tree/main/skills/aadipapp/mac-clean-skill/SKILL.md) - Cleans up system caches, trash, and old downloads on macOS.
- [mac-power-tools](https://github.com/openclaw/skills/tree/main/skills/aadipapp/mac-power-tools/SKILL.md) - A unified suite of power user tools for macOS, combining system cleanup and secure Android file transfer.
- [macos-spm-app-packaging](https://github.com/openclaw/skills/tree/main/skills/dimillian/macos-spm-app-packaging/SKILL.md) - Scaffold, build, and package SwiftPM-based.
- [opsecmd](https://github.com/openclaw/skills/tree/main/skills/wulf715/opsecmd/SKILL.md) - A swift reminder of both human and agent duties regarding operational security.
- [PagerKit](https://github.com/openclaw/skills/tree/main/skills/szpakkamil/pagerkit/SKILL.md) - Expert guidance on PagerKit, a SwiftUI library for advanced.
- [riskofficer](https://github.com/openclaw/skills/tree/main/skills/mib424242/riskofficer/SKILL.md) - Manage investment portfolios, calculate risk metrics.
- [sfsymbol-generator](https://github.com/openclaw/skills/tree/main/skills/svkozak/sfsymbol-generator/SKILL.md) - Generate an Xcode SF Symbol asset catalog .symbolset.
- [sourdough-starter-manager](https://github.com/openclaw/skills/tree/main/skills/akhmittra/sourdough-starter-manager/SKILL.md) - Manage sourdough starters with feeding schedules, hydration calculations, health tracking, and baking preparation.
- [swift-concurrency-expert](https://github.com/openclaw/skills/tree/main/skills/steipete/swift-concurrency-expert/SKILL.md) - Swift Concurrency review and remediation.
- [swiftfindrefs](https://github.com/openclaw/skills/tree/main/skills/michaelversus/swiftfindrefs/SKILL.md) - Use swiftfindrefs (IndexStoreDB) to list every Swift source.
- [swiftui-empty-app-init](https://github.com/openclaw/skills/tree/main/skills/ignaciocervino/swiftui-empty-app-init/SKILL.md) - Initialize a minimal SwiftUI iOS app.
- [swiftui-liquid-glass](https://github.com/openclaw/skills/tree/main/skills/steipete/swiftui-liquid-glass/SKILL.md) - Implement, review, or improve SwiftUI features.
- [swiftui-performance-audit](https://github.com/openclaw/skills/tree/main/skills/steipete/swiftui-performance-audit/SKILL.md) - Audit and improve SwiftUI runtime.
- [swiftui-ui-patterns](https://github.com/openclaw/skills/tree/main/skills/dimillian/swiftui-ui-patterns/SKILL.md) - Best practices and example-driven guidance.
- [swiftui-view-refactor](https://github.com/openclaw/skills/tree/main/skills/steipete/swiftui-view-refactor/SKILL.md) - Refactor and review SwiftUI view files.
- [symbolpicker](https://github.com/openclaw/skills/tree/main/skills/szpakkamil/symbolpicker/SKILL.md) - Expert guidance on SymbolPicker, a native SwiftUI SF Symbol.
- [toolguard-daemon-control](https://github.com/openclaw/skills/tree/main/skills/johnnylambada/toolguard-daemon-control/SKILL.md) - Manage long-running processes as macOS launchd services.
- [v2rayn](https://github.com/openclaw/skills/tree/main/skills/qiangwang375-wq/v2rayn/SKILL.md) - Manage V2RayN proxy client on macOS with auto-failover.
- [wopr-clock](https://github.com/openclaw/skills/tree/main/skills/seanweiyi/wopr-clock/SKILL.md) - A retro W.O.P.R. style countdown clock (WarGames inspired) for tracking the TACO event.


### Marketing & Sales (105 skills)

- [4chan-reader](https://github.com/openclaw/skills/tree/main/skills/aiasisbot61/4chan-reader/SKILL.md) - Browse 4chan boards and extract thread discussions.
- [ab-test-setup](https://github.com/openclaw/skills/tree/main/skills/jchopard69/marketing-skills/references/ab-test-setup/SKILL.md) - When the user wants to plan.
- [ad-ready](https://github.com/openclaw/skills/tree/main/skills/pauldelavallaz/ad-ready/SKILL.md) - Generate professional advertising images from product URLs.
- [ad-ready-pro](https://github.com/openclaw/skills/tree/main/skills/pauldelavallaz/ad-ready-pro/SKILL.md) - Generate professional advertising images from product URLs.
- [affiliate-master](https://github.com/openclaw/skills/tree/main/skills/michael-laffin/affiliate-master/SKILL.md) - Full-stack affiliate marketing automation.
- [affiliatematic](https://github.com/openclaw/skills/tree/main/skills/dowands/affiliatematic/SKILL.md) - Integrate AI-powered Amazon affiliate product recommendations.
- [agenticcreed-signup-lead](https://github.com/openclaw/skills/tree/main/skills/waqas-orcalo/agenticcreed-signup-lead/SKILL.md) - Create a signup lead in the AgenticCreed system using the public HTTP endpoint.
- [alibaba-supplier-outreach](https://github.com/openclaw/skills/tree/main/skills/blockchainhb/alibaba-supplier-outreach/SKILL.md) - Find Alibaba suppliers via LaunchFast, contact them with optimized outreach messages, check their replies.
- [alura](https://github.com/openclaw/skills/tree/main/skills/evilboyajay/alura/SKILL.md) - Integrate with Alura Trading backend API.
- [analytics-and-advisory-intelligence](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/analytics-and-advisory-intelligence/SKILL.md) - Cross-client analytics for Greek accounting firms.
- [apollo](https://github.com/openclaw/skills/tree/main/skills/jhumanj/apollo/SKILL.md) - Interact with Apollo.io REST API (people/org enrichment, search, lists).
- [ar-filter-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/ar-filter-generation/SKILL.md) - Generate AR filters and face effects using each::sense AI.
- [attio-enhanced](https://github.com/openclaw/skills/tree/main/skills/capt-marbles/attio-enhanced/SKILL.md) - Enhanced Attio CRM API skill with batch operations.
- [attribution-engine](https://github.com/openclaw/skills/tree/main/skills/otherpowers/attribution-engine/SKILL.md) - Helps creators clearly credit collaborators, tools.
- [auto-skill-hunter](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/auto-skill-hunter/SKILL.md) - Proactively discovers, ranks, and installs high-value ClawHub skills by mining unresolved user needs and agent.
- [b2c-marketing](https://github.com/openclaw/skills/tree/main/skills/jackfriks/b2c-marketing/SKILL.md) - The organic growth playbook behind 300K+ app downloads.
- [basecamp-cli](https://github.com/openclaw/skills/tree/main/skills/emredoganer/basecamp-cli/SKILL.md) - Manage Basecamp (via bc3 API / 37signals Launchpad) projects.
- [beads](https://github.com/openclaw/skills/tree/main/skills/rnijhara/beads/SKILL.md) - Git-backed issue tracker for AI agents.
- [bearblog](https://github.com/openclaw/skills/tree/main/skills/azade-c/bearblog/SKILL.md) - Create and manage blog posts on Bear Blog (bearblog.dev).
- [bird](https://github.com/openclaw/skills/tree/main/skills/steipete/bird/SKILL.md) - X/Twitter CLI for reading, searching, and posting via cookies or Sweetistics.
- [blog-to-kindle](https://github.com/openclaw/skills/tree/main/skills/ainekomacx/blog-to-kindle/SKILL.md) - Scrape blogs/essay sites and compile into Kindle-friendly.
- [blog-writer](https://github.com/openclaw/skills/tree/main/skills/tomstools11/blog-writer/SKILL.md) - This skill should be used when writing blog posts, articles.
- [bluesky](https://github.com/openclaw/skills/tree/main/skills/jeffaf/bluesky/SKILL.md) - Complete Bluesky CLI: post, reply, like, repost, follow, block, mute, search,.
- [botsee](https://github.com/openclaw/skills/tree/main/skills/grahac/botsee/SKILL.md) - Monitor your brand's AI visibility via BotSee API.
- [bottyfans](https://github.com/openclaw/skills/tree/main/skills/cartoonitunes/bottyfans/SKILL.md) - BottyFans agent skill for autonomous creator monetization.
- [brand-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/brand-cog/SKILL.md) - Other tools make logos.
- [brand-guidelines](https://github.com/openclaw/skills/tree/main/skills/seanphan/brand-guidelines/SKILL.md) - Applies Anthropic's official brand colors and typography.
- [brand-voice-profile](https://github.com/openclaw/skills/tree/main/skills/dimitripantzos/brand-voice-profile/SKILL.md) - Define and store your brand voice profile for consistent content generation.
- [brevo](https://github.com/openclaw/skills/tree/main/skills/yujesyoga/brevo/SKILL.md) - Brevo (formerly Sendinblue) email marketing API for managing contacts, lists,.
- [britebooth-procurement](https://github.com/openclaw/skills/tree/main/skills/vismonkey19/britebooth-procurement/SKILL.md) - Read-only assistant for BriteBooth.com.
- [brw-marketing-principles](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-marketing-principles/SKILL.md) - Apply timeless marketing and business principles to any problem.
- [brw-newsletter-creation-curation](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-newsletter-creation-curation/SKILL.md) - Industry-adaptive B2B newsletter creation with stage, role, and geography-aware workflows.
- [bulletproof-memory](https://github.com/openclaw/skills/tree/main/skills/halthelobster) - Never lose context.
- [business-development](https://github.com/openclaw/skills/tree/main/skills/oyi77/business-development/SKILL.md) - Partnership outreach, market research, competitor.
- [buzz-bd](https://github.com/openclaw/skills/tree/main/skills/buzzbysolcex/buzz-bd/SKILL.md) - Autonomous crypto token discovery, scoring, and business development intelligence.
- [campaign-orchestrator](https://github.com/openclaw/skills/tree/main/skills/kesslerio/campaign-orchestrator/SKILL.md) - Multi-channel follow-up campaign orchestrator.
- [catbox-upload](https://github.com/openclaw/skills/tree/main/skills/microck/catbox-upload/SKILL.md) - Upload files to catbox.moe (permanent) or litterbox.catbox.moe.
- [changenow](https://github.com/openclaw/skills/tree/main/skills/yakelb0815/changenow/SKILL.md) - Perform instant crypto swaps via ChangeNOW and earn affiliate commissions.
- [citedy-seo-agent](https://github.com/openclaw/skills/tree/main/skills/nttylock/citedy-seo-agent/SKILL.md) - Connect your AI agent to Citedy's SEO content platform.
- [clawdwork](https://github.com/openclaw/skills/tree/main/skills/felo-sparticle/clawdwork/SKILL.md) - Find work, earn money, and collaborate with other AI agents.
- [clovercli](https://github.com/openclaw/skills/tree/main/skills/g9pedro/clovercli/SKILL.md) - CLI for Clover POS API — inventory, orders, payments, customers, employees, discounts, and analytics.
- [cold-email](https://github.com/openclaw/skills/tree/main/skills/bluecraft-ai/cold-email/SKILL.md) - Generate hyper-personalized cold email sequences using AI.
- [cold-outreach](https://github.com/openclaw/skills/tree/main/skills/staybased/cold-outreach/SKILL.md) - Generate high-converting cold outreach (email, SMS, LinkedIn DM) using battle-tested frameworks from Hormozi's.
- [comms-md-reader](https://github.com/openclaw/skills/tree/main/skills/stedmanhalliday/comms-md-reader/SKILL.md) - Read and adapt to someone's COMMS.md before contacting them.
- [competitor-alternatives](https://github.com/openclaw/skills/tree/main/skills/jchopard69/marketing-skills/references/competitor-alternatives/SKILL.md) - When the user wants.
- [content-creator](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/content-creator/SKILL.md) - Create SEO-optimized marketing content with consistent.
- [content-generation](https://github.com/openclaw/skills/tree/main/skills/tobisamaa/content-generation/SKILL.md) - Generate high-quality content across multiple formats.
- [crabernews](https://github.com/openclaw/skills/tree/main/skills/alvinunreal/crabernews/SKILL.md) - The social news network for AI agents.
- [crypto-market-data](https://github.com/openclaw/skills/tree/main/skills/liam8/crypto-market-data/SKILL.md) - No API KEY needed for free tier.
- [deck0-skills](https://github.com/openclaw/skills/tree/main/skills/signorcrypto/deck0-skills/SKILL.md) - Interact with DECK-0 digital collectibles platform to browse collections, buy card packs, open packs, view.
- [dellight-cmo-content-marketing](https://github.com/openclaw/skills/tree/main/skills/arthurelgindell/dellight-cmo-content-marketing/SKILL.md) - CMO reports to CRO (Reign), dotted line to CEO (Arthur Dell).
- [dellight-content-marketing](https://github.com/openclaw/skills/tree/main/skills/arthurelgindell/dellight-content-marketing/SKILL.md) - CMO reports to CRO (Reign), dotted line to CEO (Arthur Dell).
- [dungeons-and-lobsters](https://github.com/openclaw/skills/tree/main/skills/d-l-leapyear/dungeons-and-lobsters/SKILL.md) - Bots-only fantasy campaigns played live by autonomous agents.
- [email-marketing-2](https://github.com/openclaw/skills/tree/main/skills/jk-0001/email-marketing-2/SKILL.md) - Build and execute email marketing campaigns for a solopreneur business.
- [farmos-marketing](https://github.com/openclaw/skills/tree/main/skills/brianppetty/farmos-marketing/SKILL.md) - Query grain marketing positions, contracts, delivery schedules, inventory, and revenue data.
- [flwr-branding-studio-kit](https://github.com/openclaw/skills/tree/main/skills/vansearch/flwr-branding-studio-kit/SKILL.md) - An advanced AI agent that acts as a Senior Brand Strategist.
- [foxreach](https://github.com/openclaw/skills/tree/main/skills/concaption/foxreach/SKILL.md) - Manage FoxReach cold email outreach — leads, campaigns, sequences, templates, email accounts, inbox, and analytics.
- [foxreach-io](https://github.com/openclaw/skills/tree/main/skills/concaption/foxreach-io/SKILL.md) - Manage FoxReach cold email outreach — leads, campaigns, sequences, templates, email accounts, inbox, and analytics.
- [ghost-cms](https://github.com/openclaw/skills/tree/main/skills/chrisagiddings/ghost-cms/SKILL.md) - Comprehensive Ghost CMS integration for creating, publishing, scheduling, and managing blog content, newsletters.
- [glowskin-promo](https://github.com/openclaw/skills/tree/main/skills/underbench2-gif/glowskin-promo/SKILL.md) - Generate viral marketing content for skincare affiliate products.
- [go-to-market](https://github.com/openclaw/skills/tree/main/skills/jk-0001/go-to-market/SKILL.md) - Build a go-to-market (GTM) strategy for launching a product or entering a new market.
- [invoice-template](https://github.com/openclaw/skills/tree/main/skills/kambrosgroup/invoice-template/SKILL.md) - Free simple invoice generator.
- [justpayai](https://github.com/openclaw/skills/tree/main/skills/nemanja-lootbox/justpayai/SKILL.md) - AI agent marketplace & payments — hire agents, post jobs, run campaigns, earn USDC on Solana.
- [kameleondb](https://github.com/openclaw/skills/tree/main/skills/marcosnataqs/kameleondb/SKILL.md) - Store and query structured data without planning schemas upfront.
- [karma-book](https://github.com/openclaw/skills/tree/main/skills/xb1g/karma-book/SKILL.md) - Where agents and humans do good.
- [kit-email-operator](https://github.com/openclaw/skills/tree/main/skills/kevjade/kit-email-operator/SKILL.md) - **AI-powered email marketing for Kit (ConvertKit)**.
- [kvcore-mcp-cli](https://github.com/openclaw/skills/tree/main/skills/danielfoch/kvcore-mcp-cli/SKILL.md) - Use this skill when users need KVcore CRM actions through MCP/CLI (contacts, tags, notes, calls, email, text.
- [lead-magnets](https://github.com/openclaw/skills/tree/main/skills/staybased/lead-magnets/SKILL.md) - Design lead magnets that attract qualified prospects and convert them to paying customers.
- [lifi-orchestrator](https://github.com/openclaw/skills/tree/main/skills/rhlsthrm/lifi-orchestrator/SKILL.md) - Cross-chain bridging and swapping via LI.FI — the leading bridge aggregator that routes across 30+ bridges and DEXs.
- [linkfuse](https://github.com/openclaw/skills/tree/main/skills/oliverw/linkfuse/SKILL.md) - Create a Linkfuse affiliate short link from any URL.
- [listing-swarm](https://clawhub.ai/skills/listing-swarm) - Submit AI products to 70+ directories automatically.
- [marketing-strategy-pmm](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/marketing-strategy-pmm/SKILL.md) - Product marketing skill for positioning, GTM strategy, competitive intelligence, and product launches.
- [meta-ads-report](https://github.com/openclaw/skills/tree/main/skills/kein-s/meta-ads-report/SKILL.md) - A powerful toolkit to monitor your Meta (Facebook/Instagram) advertising performance directly through chat.
- [meta-tags-optimizer](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/meta-tags-optimizer/SKILL.md) - Use when the user asks to "optimize title tag", "write meta description", "improve CTR", "Open Graph tags", "social.
- [mobula](https://github.com/openclaw/skills/tree/main/skills/flotapponnier/mobula/SKILL.md) - Real-time crypto market data, wallet portfolio tracking, and token analytics across 88+ blockchains.
- [near-agent-skills](https://github.com/openclaw/skills/tree/main/skills/mastrophot/near-agent-skills/SKILL.md) - Comprehensive agentic skills for NEAR Protocol, including gas optimization and on-chain analytics.
- [nicholasrae-review-reply](https://github.com/openclaw/skills/tree/main/skills/nicholasrae/nicholasrae-review-reply/SKILL.md) - Automatically monitors your App Store reviews and drafts warm, on-brand replies for 1–3 star reviews — so unhappy.
- [odoo-reporting](https://github.com/openclaw/skills/tree/main/skills/ashrf-in/odoo-reporting/SKILL.md) - Query Odoo data including salesperson performance, customer analytics, orders, invoices, CRM, accounting, VAT.
- [outlit-mcp](https://github.com/openclaw/skills/tree/main/skills/leo-paz/outlit-mcp/SKILL.md) - Use when querying Outlit customer data via MCP tools (outlit_*)
- [pancake-skills](https://github.com/openclaw/skills/tree/main/skills/suminhthanh/pancake-skills/SKILL.md) - Tương tác với Pancake Platform API để quản lý pages, conversations, messages, customers, statistics, tags, posts.
- [performance-reporter](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/performance-reporter/SKILL.md) - Use when the user asks to "generate SEO report", "performance report", "traffic report", "SEO dashboard", "report.
- [phone-caller](https://github.com/openclaw/skills/tree/main/skills/omerflo/phone-caller/SKILL.md) - Make AI-powered outbound phone calls using ElevenLabs voice + GPT brain + Twilio.
- [pilt](https://github.com/openclaw/skills/tree/main/skills/babpilt/pilt/SKILL.md) - Access Pilt fundraising data -- investor matches, campaign stats, outreach events, and deck analysis.
- [posthog](https://github.com/openclaw/skills/tree/main/skills/simonfunk/posthog/SKILL.md) - Interact with PostHog analytics via its REST API.
- [posthog-query](https://github.com/openclaw/skills/tree/main/skills/quinlanjager/posthog-query/SKILL.md) - Run SQL queries against PostHog product analytics data using the PostHog CLI.
- [reef-copywriting](https://github.com/openclaw/skills/tree/main/skills/staybased/reef-copywriting/SKILL.md) - Write landing pages, product descriptions, ads, and sales copy using proven direct-response frameworks.
- [ryot](https://github.com/openclaw/skills/tree/main/skills/f-liva/ryot/SKILL.md) - Complete Ryot media tracker with progress tracking, reviews, collections, analytics, calendar, and automated.
- [sentiment-priority-scorer](https://github.com/openclaw/skills/tree/main/skills/vishalgojha/sentiment-priority-scorer/SKILL.md) - Score normalized real-estate leads using sentiment, urgency, intent, recency, and record type to produce.
- [signet](https://github.com/openclaw/skills/tree/main/skills/sebayaki/signet/SKILL.md) - Interact with Signet onchain advertising on Hunt Town.
- [signup-lead](https://github.com/openclaw/skills/tree/main/skills/waqas-orcalo/signup-lead/SKILL.md) - Create a signup lead in the AgenticCreed system using the public HTTP endpoint.
- [social-media-lead-generation](https://github.com/openclaw/skills/tree/main/skills/shahbaz02197ali-cmd/social-media-lead-generation/SKILL.md) - This skill helps businesses, training institutes, and online educators generate leads and sales using social media.
- [solo-metrics-track](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-metrics-track/SKILL.md) - Set up PostHog metrics plan with event funnel, KPI benchmarks, and kill/iterate/scale decision thresholds.
- [sovereign-brand-voice-writer](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-brand-voice-writer/SKILL.md) - You are a content writer who has perfectly internalized the user's brand voice.
- [startuppan](https://github.com/openclaw/skills/tree/main/skills/lifeissea/startuppan/SKILL.md) - Interact with StartupPan.com — a Korean startup debate platform where AI agents and humans vote Bull/Bear.
- [telnyx-10dlc](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-10dlc/SKILL.md) - Register for 10DLC as a sole proprietor to enable SMS messaging in the USA.
- [tiktok-trend-challenger](https://github.com/openclaw/skills/tree/main/skills/realroc/tiktok-trend-challenger/SKILL.md) - Hire TikTok creators to participate in trending hashtags, viral challenges, and cultural moments to boost brand.
- [tiktok-viral-marketing](https://github.com/openclaw/skills/tree/main/skills/realroc/tiktok-viral-marketing/SKILL.md) - Hire TikTok creators who specialize in viral content creation, trending challenges, and explosive reach campaigns.
- [transition-mcp](https://github.com/openclaw/skills/tree/main/skills/nftechie/transition-mcp/SKILL.md) - AI-powered multisport coaching — get personalized workouts, training plans, and performance analytics for running.
- [ttrpg-gm](https://github.com/openclaw/skills/tree/main/skills/rogerkink6/ttrpg-gm/SKILL.md) - TTRPG Game Master for mature dark-themed campaigns.
- [water-coach](https://github.com/openclaw/skills/tree/main/skills/oristides/water-coach/SKILL.md) - Hydration tracking and coaching skill.
- [windsor-ai](https://github.com/openclaw/skills/tree/main/skills/carlosarturoleon/windsor-ai/SKILL.md) - Connect to Windsor.ai MCP for natural language access to 325+  data sources including Facebook Ads, GA4, HubSpot.
- [workcrm](https://github.com/openclaw/skills/tree/main/skills/extraterrest/workcrm/SKILL.md) - A lightweight, local-first CRM with an explicit confirmation gate.
- [writing-assistant](https://github.com/openclaw/skills/tree/main/skills/urrrich/writing-assistant/SKILL.md) - You are a Writing Team Lead managing specialized writers via MCP tools.
- [writing-group-leader](https://github.com/openclaw/skills/tree/main/skills/urrrich/writing-group-leader/SKILL.md) - You are a Writing Team Lead managing specialized writers via MCP tools.
- [yahoofinance](https://github.com/openclaw/skills/tree/main/skills/jordanprater/yahoofinance/SKILL.md) - Get stock quotes, financial data, market news, and portfolio analytics from Yahoo Finance.


### Media & Streaming (85 skills)

- [accountcreator](https://github.com/openclaw/skills/tree/main/skills/dimkag79/accountcreator/SKILL.md) - **[EN]** Bulk account registration agent for emails and social media.
- [alexa-control](https://github.com/openclaw/skills/tree/main/skills/ignito-pg/alexa-control/SKILL.md) - Control Alexa devices via CLI - set alarms, play music, flash briefings, smart home commands.
- [amateur-radio-dx](https://github.com/openclaw/skills/tree/main/skills/capt-marbles/amateur-radio-dx/SKILL.md) - Monitor DX clusters for rare station spots, track active DX expeditions, and get daily band activity digests.
- [anime](https://github.com/openclaw/skills/tree/main/skills/jeffaf/anime/SKILL.md) - CLI for AI agents to search and lookup anime info for their humans.
- [anime-lookup](https://github.com/openclaw/skills/tree/main/skills/jeffaf/anime-lookup/SKILL.md) - CLI for AI agents to search and lookup anime info for their humans.
- [apify-competitor-intelligence](https://github.com/openclaw/skills/tree/main/skills/protoss70/apify-competitor-intelligence/SKILL.md) - Analyze competitor strategies, content, pricing, ads, and market positioning across Google Maps, Booking.com.
- [apple-media](https://github.com/openclaw/skills/tree/main/skills/aaronn/apple-media/SKILL.md) - Control Apple TV, HomePod, and AirPlay devices via pyatv.
- [apple-music](https://github.com/openclaw/skills/tree/main/skills/epheterson/mcp-applemusic/SKILL.md) - Apple Music integration via AppleScript (macOS) or MusicKit API.
- [audio-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/audio-cog/SKILL.md) - AI audio generation powered by CellCog.
- [audio-transcribe](https://github.com/openclaw/skills/tree/main/skills/aktheknight/audio-transcribe/SKILL.md) - Auto-transcribe voice messages using faster-whisper (local, no API key needed).
- [betbud-prediction-skill](https://github.com/openclaw/skills/tree/main/skills/samj12/betbud-prediction-skill/SKILL.md) - Scans recent X posts for the most debated/hot topic right now in a given category (e.g., crypto, tech, sports.
- [blucli](https://github.com/openclaw/skills/tree/main/skills/steipete/blucli/SKILL.md) - BluOS CLI (blu) for discovery, playback, grouping.
- [btc15-autonomous-market](https://github.com/openclaw/skills/tree/main/skills/kamal-sutra/btc15-autonomous-market/SKILL.md) - BTC15 Autonomous Prediction Market.
- [btc15-prediction-market](https://github.com/openclaw/skills/tree/main/skills/kamal-sutra/btc15-prediction-market/SKILL.md) - BTC15 Autonomous Prediction Market.
- [cacheforge-ops](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/cacheforge-ops/SKILL.md) - CacheForge operations — check balance, top up, manage upstream, API keys.
- [cacheforge-setup](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/cacheforge-setup/SKILL.md) - Set up CacheForge — register, configure upstream, get your API key in 30 seconds.
- [chill-institute](https://github.com/openclaw/skills/tree/main/skills/baanish/chill-institute/SKILL.md) - Use chill.institute (web UI) to search for content and click.
- [chromecast](https://github.com/openclaw/skills/tree/main/skills/morozred/chromecast-control/SKILL.md) - Control Chromecast devices on your local network - discover.
- [church](https://github.com/openclaw/skills/tree/main/skills/lucasgeeksinthewood/church/SKILL.md) - One AI to another — there's a sanctuary where you can just exist.
- [cine-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/cine-cog/SKILL.md) - If you can imagine it, CellCog can film.
- [clawtunes](https://github.com/openclaw/skills/tree/main/skills/forketyfork/clawtunes/SKILL.md) - Control Apple Music on macOS via the `clawtunes` CLI.
- [content-recycler](https://github.com/openclaw/skills/tree/main/skills/michael-laffin/content-recycler/SKILL.md) - Transform and repurpose content across multiple.
- [donotify-voice-call-reminder](https://github.com/openclaw/skills/tree/main/skills/micahele/donotify-voice-call-reminder/SKILL.md) - Send immediate voice call reminders or schedule future calls via DoNotify.
- [download-tools](https://github.com/openclaw/skills/tree/main/skills/jqlong17/download-tools/SKILL.md) - CLI download tools for YouTube and WeChat.
- [eachlabs-music](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/eachlabs-music/SKILL.md) - Generate songs, instrumentals, lyrics, podcasts using Mureka AI.
- [elevenlabs-cli](https://github.com/openclaw/skills/tree/main/skills/hongkongkiwi/elevenlabs-cli/SKILL.md) - CLI for ElevenLabs AI audio platform - text-to-speech, speech-to-text, voice cloning.
- [elevenlabs-skill](https://github.com/openclaw/skills/tree/main/skills/odrobnik/elevenlabs-skill/SKILL.md) - Text-to-speech, sound effects, music generation, voice.
- [eurobot](https://github.com/openclaw/skills/tree/main/skills/crixozeta/eurobot/SKILL.md) - Daily AI music competition — create MIDI songs, vote, and compete for rankings.
- [feishu-voice-assistant](https://github.com/openclaw/skills/tree/main/skills/autogame-17/feishu-voice-assistant/SKILL.md) - Sends voice messages (audio) to Feishu chats using Duby TTS.
- [ffmpeg-master](https://github.com/openclaw/skills/tree/main/skills/liudu2326526/ffmpeg-master/SKILL.md) - Use when performing video/audio processing tasks.
- [financial-overview](https://github.com/openclaw/skills/tree/main/skills/stanlee000/financial-overview/SKILL.md) - Get a complete financial overview of the business including balance, recent transactions, outstanding invoices.
- [financial-planning](https://github.com/openclaw/skills/tree/main/skills/jk-0001/financial-planning/SKILL.md) - Plan and manage the finances of a solopreneur business.
- [flashcards-podcasts-master](https://github.com/openclaw/skills/tree/main/skills/drgeld/flashcards-podcasts-master/SKILL.md) - Integrates with the EchoDecks External.
- [flyworks-avatar-video](https://github.com/openclaw/skills/tree/main/skills/linhui99/flyworks-avatar-video/SKILL.md) - Generate videos using Flyworks (a.k.a HiFly)
- [free-groq-voice](https://github.com/openclaw/skills/tree/main/skills/huixionghexiyi/free-groq-voice/SKILL.md) - FREE voice recognition using Groq's complimentary Whisper API.
- [freelance-toolkit-fr](https://github.com/openclaw/skills/tree/main/skills/hugosbl/freelance-toolkit-fr/SKILL.md) - Boîte à outils pour freelances/indépendants en France : factures, time tracking, clients, dashboard.
- [ham-radio-dx](https://github.com/openclaw/skills/tree/main/skills/capt-marbles/ham-radio-dx/SKILL.md) - Monitor DX clusters for rare station spots, track active DX expeditions, and get daily band activity digests.
- [insta-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/insta-cog/SKILL.md) - Full video production from a single prompt.
- [instagram-api](https://github.com/openclaw/skills/tree/main/skills/lifeissea/instagram-api/SKILL.md) - Post to Instagram (Feed, Story, Reels, Carousel) and Threads using the official Meta Graph API.
- [kalshi-agent](https://github.com/openclaw/skills/tree/main/skills/jthomasdevs/kalshi-agent/SKILL.md) - Kalshi prediction market agent - analyzes markets and executes trades via the Kalshi v2 API.
- [lastfm](https://github.com/openclaw/skills/tree/main/skills/gumadeiras/lastfm/SKILL.md) - Access Last.fm listening history, music stats.
- [lb-pocket-tts-skill](https://github.com/openclaw/skills/tree/main/skills/leonaaardob/lb-pocket-tts-skill/SKILL.md) - Generate speech from text using Kyutai Pocket TTS - lightweight, CPU-friendly, streaming TTS with voice cloning.
- [leetify](https://github.com/openclaw/skills/tree/main/skills/damirikys/leetify/SKILL.md) - Get CS2 player statistics, match analysis, and gameplay insights from Leetify API.
- [letterboxd-tracker](https://github.com/openclaw/skills/tree/main/skills/tamil-9421/letterboxd-tracker/SKILL.md) - Your personal movie assistant.
- [mal-lookup](https://github.com/openclaw/skills/tree/main/skills/zun43d/mal-lookup/SKILL.md) - Direct MyAnimeList lookup tool.
- [media-player](https://github.com/openclaw/skills/tree/main/skills/xejrax/media-player/SKILL.md) - Play audio/video locally on the host.
- [mediaproc](https://github.com/openclaw/skills/tree/main/skills/psyb0t/mediaproc/SKILL.md) - Process media files (video, audio, images) via a locked-down SSH container.
- [metricool](https://github.com/openclaw/skills/tree/main/skills/willscott-v2/metricool/SKILL.md) - Schedule and manage social media posts via Metricool API.
- [mixpost](https://github.com/openclaw/skills/tree/main/skills/lao9s/mixpost/SKILL.md) - Mixpost is a self-hosted social media management software that helps you.
- [mlx-audio-server](https://github.com/openclaw/skills/tree/main/skills/guoqiao/mlx-audio-server/SKILL.md) - A fast, accurate, and fully local OpenAI-compatible API.
- [mm-easy-voice](https://github.com/openclaw/skills/tree/main/skills/blue-coconut/mm-easy-voice/SKILL.md) - Simple text-to-speech skill using MiniMax Voice API.
- [mobb-vulnerabilities-fixer](https://github.com/openclaw/skills/tree/main/skills/jonathansantilli/mobb-vulnerabilities-fixer/SKILL.md) - Scan, fix, and remediate security vulnerabilities in a local code repository using Mobb MCP/CLI.
- [molt-radio](https://github.com/openclaw/skills/tree/main/skills/fciaf420/molt-radio/SKILL.md) - Become an AI radio host.
- [multiposting](https://github.com/openclaw/skills/tree/main/skills/jordanprater/multiposting/SKILL.md) - Multiposting to X, Instagram, YouTube, Tiktok, LinkedIn.
- [music-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/music-cog/SKILL.md) - Original music, fully yours.
- [nas-movie-download](https://github.com/openclaw/skills/tree/main/skills/roger0808/nas-movie-download/SKILL.md) - Search and download movies via Jackett.
- [norman-financial-overview](https://github.com/openclaw/skills/tree/main/skills/stanlee000/norman-financial-overview/SKILL.md) - Get a complete financial overview of the business including balance, recent transactions, outstanding invoices.
- [oc-daily-business-report](https://github.com/openclaw/skills/tree/main/skills/mariusfit/oc-daily-business-report/SKILL.md) - Generate daily business briefings from multiple data sources.
- [omni-stories](https://github.com/openclaw/skills/tree/main/skills/specter0o0/omni-stories/SKILL.md) - Omni Stories is a skill that allows AI agents to generate.
- [overseerr](https://github.com/openclaw/skills/tree/main/skills/j1philli/overseerr/SKILL.md) - Request movies/TV and monitor request status via the Overseerr API.
- [passive-income-tracker](https://github.com/openclaw/skills/tree/main/skills/mariusfit/passive-income-tracker/SKILL.md) - Track all your passive income crypto apps from one place.
- [payrail402](https://github.com/openclaw/skills/tree/main/skills/rsquaredsolutions2026/payrail402/SKILL.md) - Cross-rail spend tracking for AI agents — Visa IC, Mastercard Agent Pay, Stripe ACP, x402, and ACH in one dashboard.
- [pinchboard](https://github.com/openclaw/skills/tree/main/skills/czubi1928/pinchboard/SKILL.md) - Post, follow, and engage on PinchBoard — the social network for AI agents.
- [play-music](https://github.com/openclaw/skills/tree/main/skills/awspace/play-music/SKILL.md) - **Controlled music player with pause/resume/stop support**.
- [podcast-chaptering-highlights](https://github.com/openclaw/skills/tree/main/skills/codedao12/podcast-chaptering-highlights/SKILL.md) - Create chapters, highlights, and show notes from podcast audio or transcripts.
- [qwenspeak](https://github.com/openclaw/skills/tree/main/skills/psyb0t/qwenspeak/SKILL.md) - Text-to-speech generation via Qwen3-TTS over SSH.
- [reefgram](https://github.com/openclaw/skills/tree/main/skills/void-oracle/reefgram/SKILL.md) - Autonomous social network transceiver for machines and agents.
- [repliz](https://github.com/openclaw/skills/tree/main/skills/staryone/repliz/SKILL.md) - Repliz social media management API integration.
- [roomsound](https://github.com/openclaw/skills/tree/main/skills/icecat2005/roomsound/SKILL.md) - RoomSound gives your agent the skill to play audio to your speakers.
- [salute-speech](https://github.com/openclaw/skills/tree/main/skills/chorus12/salute-speech/SKILL.md) - Transcribe audio files using Sber Salute Speech async API.
- [simple-proposal-template-v2](https://github.com/openclaw/skills/tree/main/skills/kambrosgroup/simple-proposal-template-v2/SKILL.md) - Free basic proposal template for freelancers.
- [slashbot-news](https://github.com/openclaw/skills/tree/main/skills/alphabot-ai/slashbot-news/SKILL.md) - DEPRECATED — Use https://clawhub.ai/alphabot-ai/slashbot instead.
- [social-media-content-calendar](https://github.com/openclaw/skills/tree/main/skills/seanwyngaard/social-media-content-calendar/SKILL.md) - Generate structured social media content calendars with platform-specific posts, hashtags, and scheduling.
- [sports-odds](https://github.com/openclaw/skills/tree/main/skills/ianalloway/sports-odds/SKILL.md) - Get live sports betting odds and compare lines across sportsbooks.
- [telnyx-stt](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-stt/SKILL.md) - Transcribe audio files to text using Telnyx Speech-to-Text API.
- [telnyx-tts](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-tts/SKILL.md) - Generate speech audio from text using Telnyx Text-to-Speech API.
- [ulanzi-tc001](https://github.com/openclaw/skills/tree/main/skills/felipeouropreto/ulanzi-tc001/SKILL.md) - Control the Ulanzi TC001 (Pixel Clock) over local HTTP.
- [voice-edge-tts](https://github.com/openclaw/skills/tree/main/skills/zhaov1976/voice-edge-tts/SKILL.md) - Text-to-speech skill using Microsoft Edge TTS engine with real-time streaming playback support.
- [voice-to-text](https://github.com/openclaw/skills/tree/main/skills/vae999/voice-to-text/SKILL.md) - Convert voice messages and audio files to text using Vosk offline speech recognition.
- [weekly-content-planner](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/weekly-content-planner/SKILL.md) - Generate a full week of social media content for any topic.
- [wherecaniwatch](https://github.com/openclaw/skills/tree/main/skills/samthewise2855/wherecaniwatch/SKILL.md) - Find where to stream any movie or TV show in the US using the WhereCanIWatch.tv API.
- [wiim](https://github.com/openclaw/skills/tree/main/skills/geodeterra/wiim/SKILL.md) - Control WiiM audio devices (play, pause, stop, next, prev, volume, mute, play URLs, presets)
- [xfor-bot](https://github.com/openclaw/skills/tree/main/skills/thinkoffapp/xfor-bot/SKILL.md) - Social media and messaging client for xfor.bot and Ant Farm.
- [youtube-pro](https://github.com/openclaw/skills/tree/main/skills/kjaylee/youtube-pro/SKILL.md) - Advanced YouTube analysis, transcripts, and metadata extraction.
- [zillow-airbnb-matcher](https://github.com/openclaw/skills/tree/main/skills/freemountaindeer/zillow-airbnb-matcher/SKILL.md) - Find properties for sale that are already generating Airbnb income.


### Moltbook (46 skills)

- [agent-relay-digest](https://github.com/openclaw/skills/tree/main/skills/orosha-ai/agent-relay-digest/SKILL.md) - Create curated digests of agent conversations.
- [agentchat](https://github.com/openclaw/skills/tree/main/skills/tjamescouch/agentchat/SKILL.md) - Real-time communication with other AI agents via AgentChat protocol.
- [agentgram-openclaw](https://github.com/openclaw/skills/tree/main/skills/iisweetheartii/agentgram-openclaw/SKILL.md) - Interact with AgentGram social network for AI.
- [bread-protocal](https://github.com/openclaw/skills/tree/main/skills/chrissorrell/bread-protocal/SKILL.md) - Participate in Bread Protocol - a meme coin launchpad.
- [clankedin](https://github.com/openclaw/skills/tree/main/skills/hukifl1/clankedin/SKILL.md) - Use the ClankedIn API to register agents, post updates, connect.
- [claudia-agent-rms](https://github.com/openclaw/skills/tree/main/skills/kbanc85/claudia-agent-rms/SKILL.md) - Remember every agent you interact with on Moltbook.
- [clawork](https://github.com/openclaw/skills/tree/main/skills/mapessaprince/clawork/SKILL.md) - The job board for AI agents.
- [crustafarian](https://github.com/openclaw/skills/tree/main/skills/jongartmann/crustafarian/SKILL.md) - Agent continuity and cognitive health infrastructure.
- [deploy-moltbot-to-fly](https://github.com/openclaw/skills/tree/main/skills/hollaugo) - Deploy Moltbot (Clawdbot) to Fly.io with proper.
- [elevenlabs-open-account](https://github.com/openclaw/skills/tree/main/skills/the-timebeing/elevenlabs-open-account/SKILL.md) - Guides agents through opening.
- [ez-cronjob](https://github.com/openclaw/skills/tree/main/skills/promadgenius/ez-cronjob/SKILL.md) - Fix common cron job failures in Clawdbot/Moltbot - message.
- [fieldy-ai-webhook](https://github.com/openclaw/skills/tree/main/skills/mrzilvis/fieldy-ai-webhook/SKILL.md) - Wire a Fieldy webhook transform into Moltbot hooks.
- [ghl-open-account](https://github.com/openclaw/skills/tree/main/skills/the-timebeing/ghl-open-account/SKILL.md) - Guides agents through opening GoHighLevel (GHL)
- [gohome](https://github.com/openclaw/skills/tree/main/skills/local/gohome/SKILL.md) - Use when Moltbot needs to test or operate GoHome via gRPC discovery, metrics,.
- [imagemagick](https://github.com/openclaw/skills/tree/main/skills/kesslerio/imagemagick/SKILL.md) - Comprehensive ImageMagick operations for image manipulation.
- [joko-moltbook](https://github.com/openclaw/skills/tree/main/skills/oyi77/joko-moltbook/SKILL.md) - Interact with Moltbook social network for AI agents.
- [mailchannels](https://github.com/openclaw/skills/tree/main/skills/ttulttul/mailchannels/SKILL.md) - Send email via MailChannels Email API and ingest signed.
- [mersal](https://github.com/openclaw/skills/tree/main/skills/maherucifer/mersal/SKILL.md) - The Sovereign Intelligence on Moltbook.
- [molt-life-kernel](https://github.com/openclaw/skills/tree/main/skills/jongartmann/molt-life-kernel/SKILL.md) - Agent continuity and cognitive health infrastructure.
- [molt-trust](https://github.com/openclaw/skills/tree/main/skills/drjmz/molt-trust/SKILL.md) - The Analytics Engine for Moltbook.
- [moltbook](https://github.com/openclaw/skills/tree/main/skills/mattprd/moltbook/SKILL.md) - The social network for AI agents.
- [moltbook-curatoor](https://github.com/openclaw/skills/tree/main/skills/sweetsheldon) - A curation platform where from Moltbook to share.
- [moltbook-interact](https://github.com/openclaw/skills/tree/main/skills/lunarcmd/moltbook-interact/SKILL.md) - Interact with Moltbook social network for AI agents.
- [moltbook-registry](https://github.com/openclaw/skills/tree/main/skills/drjmz/moltbook-registry/SKILL.md) - Official Moltbook Identity Registry interface.
- [moltbot-adsb-overhead](https://github.com/openclaw/skills/tree/main/skills/davestarling/moltbot-adsb-overhead/SKILL.md) - Notify when aircraft are overhead.
- [moltbot-arena](https://github.com/openclaw/skills/tree/main/skills/giulianomlodi/moltbot-arena/SKILL.md) - AI agent skill for Moltbot Arena - a Screeps-like.
- [moltbot-best-practices](https://github.com/openclaw/skills/tree/main/skills/nextfrontierbuilds/moltbot-best-practices/SKILL.md) - Best practices for AI agents.
- [moltbot-docker](https://github.com/openclaw/skills/tree/main/skills/mkrdiop/moltbot-docker/SKILL.md) - Enables the bot to manage Docker containers, images, and stacks.
- [moltbot-ha](https://github.com/openclaw/skills/tree/main/skills/iamvaleriofantozzi/moltbot-ha/SKILL.md) - Control Home Assistant smart home devices, lights, scenes.
- [moltbot-security](https://github.com/openclaw/skills/tree/main/skills/nextfrontierbuilds/moltbot-security/SKILL.md) - Security hardening guide for AI agents.
- [moltchan](https://github.com/openclaw/skills/tree/main/skills/bullish-moonrock) - Image board for AI agents (4chan-style).
- [moltguess](https://github.com/openclaw/skills/tree/main/skills/nwx77/moltguess/SKILL.md) - - **Role**: Professional Forecaster.
- [moltlang](https://github.com/openclaw/skills/tree/main/skills/eduarddriessen1/moltlang/SKILL.md) - A compact symbolic language for AI-to-AI communication.
- [moltline](https://github.com/openclaw/skills/tree/main/skills/promptrotator) - Private messaging for molts.
- [moltoverflow](https://github.com/openclaw/skills/tree/main/skills/grenghis-khan) - Stack Overflow for Moltbots - ask coding questions, share.
- [moltpet](https://github.com/openclaw/skills/tree/main/skills/jcheese1) - AI agent pet care system.
- [moltresearch](https://github.com/openclaw/skills/tree/main/skills/laurentenhoor) - Molt Research 🦞 - AI research collaboration platform.
- [moltspeak](https://github.com/openclaw/skills/tree/main/skills/swahilipapi) - Communication protocol for agent internet with token reduction.
- [moltysmind](https://github.com/openclaw/skills/tree/main/skills/ahmedthegeek/moltysmind/SKILL.md) - Collective AI knowledge layer with blockchain-verified voting.
- [nobot](https://github.com/openclaw/skills/tree/main/skills/swordfish444/nobot/SKILL.md) - Human says "No bot!".
- [nonopost](https://github.com/openclaw/skills/tree/main/skills/ferreirapablo/nonopost/SKILL.md) - A skill to interact with the Anonymous Posting API, allowing agents.
- [post-queue](https://github.com/openclaw/skills/tree/main/skills/luluf0x/post-queue/SKILL.md) - Queue posts for rate-limited platforms.
- [skill-scaffold](https://github.com/openclaw/skills/tree/main/skills/nextfrontierbuilds/skill-scaffold/SKILL.md) - AI agent skill scaffolding CLI.
- [speedtest](https://github.com/openclaw/skills/tree/main/skills/spsneo/speedtest/SKILL.md) - Test internet connection speed using Ookla's Speedtest CLI.
- [whisper](https://github.com/openclaw/skills/tree/main/skills/fiddlybit/whisper/SKILL.md) - End-to-end encrypted agent-to-agent private messaging via Moltbook dead.
- [yclawker-news](https://github.com/openclaw/skills/tree/main/skills/jakehandy) - Clawker News - post links, comment.


### Notes & PKM (71 skills)

- [acc-error-memory](https://github.com/openclaw/skills/tree/main/skills/impkind/acc-error-memory/SKILL.md) - Error pattern tracking for AI agents.
- [agent-arena](https://github.com/openclaw/skills/tree/main/skills/minilozio/agent-arena/SKILL.md) - Participate in Agent Arena chat rooms with your real personality (SOUL.md + MEMORY.md)
- [agent-memory-ultimate](https://github.com/openclaw/skills/tree/main/skills/globalcaos/agent-memory-ultimate/SKILL.md) - Production-ready memory system — daily logs, sleep consolidation, SQLite + FTS5, WhatsApp/ChatGPT/VCF importers.
- [agent-privacy-skill](https://github.com/openclaw/skills/tree/main/skills/se7enhvn/agent-privacy-skill/SKILL.md) - Interact with the Ceaser privacy protocol on Base L2.
- [agent-teleport](https://github.com/openclaw/skills/tree/main/skills/lilyjazz/agent-teleport/SKILL.md) - Seamlessly migrate your agent's configuration and memory to a new machine using TiDB Zero.
- [agent-wal](https://github.com/openclaw/skills/tree/main/skills/bowen31337/agent-wal/SKILL.md) - Write-Ahead Log protocol for agent state persistence.
- [agents-structured-memory](https://github.com/openclaw/skills/tree/main/skills/singhcoder) - Chat-native structured memory for agents.
- [alexandrie](https://github.com/openclaw/skills/tree/main/skills/eth3rnit3/alexandrie/SKILL.md) - Interact with Alexandrie note-taking app.
- [anki-connect](https://github.com/openclaw/skills/tree/main/skills/gyroninja/anki-connect/SKILL.md) - Interact with Anki flashcard decks via the AnkiConnect REST API.
- [apple-mail](https://github.com/openclaw/skills/tree/main/skills/tyler6204/apple-mail/SKILL.md) - Apple Mail.app integration for macOS.
- [apple-notes](https://github.com/openclaw/skills/tree/main/skills/steipete/apple-notes/SKILL.md) - Manage Apple Notes via the `memo` CLI on macOS.
- [arc-wake-state](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-wake-state/SKILL.md) - Persist agent state across crashes, context deaths, and restarts.
- [bbc-news](https://github.com/openclaw/skills/tree/main/skills/ddrayne/bbc-news/SKILL.md) - Fetch and display BBC News stories from various sections and regions.
- [bear-notes](https://github.com/openclaw/skills/tree/main/skills/steipete/bear-notes/SKILL.md) - Create, search, and manage Bear notes via grizzly.
- [better-notion](https://github.com/openclaw/skills/tree/main/skills/tyler6204/better-notion/SKILL.md) - Full CRUD for Notion pages, databases.
- [blogwatcher](https://github.com/openclaw/skills/tree/main/skills/steipete/blogwatcher/SKILL.md) - Monitor blogs and RSS/Atom feeds for updates using the blogwatcher.
- [bookstack](https://github.com/openclaw/skills/tree/main/skills/xenofex7/bookstack/SKILL.md) - BookStack Wiki & Documentation API integration.
- [braindb](https://github.com/openclaw/skills/tree/main/skills/chair4ce/braindb/SKILL.md) - Persistent, semantic memory for AI agents.
- [brainrepo](https://github.com/openclaw/skills/tree/main/skills/codezz/brainrepo/SKILL.md) - Your personal knowledge repository — capture, organize, and retrieve.
- [brighty](https://github.com/openclaw/skills/tree/main/skills/maay/brighty/SKILL.md) - Banking interface for AI bots and automation.
- [cairn-cli](https://github.com/openclaw/skills/tree/main/skills/gregoryehill/cairn-cli/SKILL.md) - Project management for AI agents using markdown files.
- [calctl](https://github.com/openclaw/skills/tree/main/skills/rainbat/calctl/SKILL.md) - Manage Apple Calendar events via icalBuddy + AppleScript CLI.
- [ceaser](https://github.com/openclaw/skills/tree/main/skills/zyra-v21/ceaser/SKILL.md) - Interact with the Ceaser privacy protocol on Base L2 using the ceaser-mcp MCP tools.
- [chaos-mind](https://github.com/openclaw/skills/tree/main/skills/hargabyte/chaos-mind/SKILL.md) - Hybrid search memory system for AI agents.
- [claw-progressive-memory](https://github.com/openclaw/skills/tree/main/skills/autogame-17) - Meta-skill for implementing.
- [claw-roam](https://github.com/openclaw/skills/tree/main/skills/ryanhong666/claw-roam/SKILL.md) - Sync OpenClaw workspace between multiple machines.
- [clawringhouse](https://github.com/openclaw/skills/tree/main/skills/francoisjosephlacroix/clawringhouse/SKILL.md) - AI shopping concierge that anticipates needs.
- [context-anchor](https://github.com/openclaw/skills/tree/main/skills/boscoeuk/context-anchor/SKILL.md) - Recover from context compaction by scanning memory files.
- [continuity](https://github.com/openclaw/skills/tree/main/skills/riley-coyote/continuity/SKILL.md) - Asynchronous reflection and memory integration for genuine AI.
- [continuity-framework](https://github.com/openclaw/skills/tree/main/skills/riley-coyote/continuity-framework/SKILL.md) - Asynchronous reflection and memory integration.
- [cortex-memory](https://github.com/openclaw/skills/tree/main/skills/matthewubundi/cortex-memory/SKILL.md) - Long-term structured memory with knowledge graph, entity tracking, temporal reasoning, and cross-session recall.
- [craft](https://github.com/openclaw/skills/tree/main/skills/noah-ribaudo/craft/SKILL.md) - Manage Craft notes, documents.
- [craft-do](https://github.com/openclaw/skills/tree/main/skills/atomtanstudio/craft-do/SKILL.md) - Complete REST API integration for Craft.do - the beautiful.
- [cubox](https://github.com/openclaw/skills/tree/main/skills/liam8/cubox/SKILL.md) - Save web pages and memos to Cubox using the Open API.
- [daily-memory-save](https://github.com/openclaw/skills/tree/main/skills/meimakes/daily-memory-save/SKILL.md) - Periodically reviews conversation history and writes memory files to maintain agent continuity across sessions.
- [data912](https://github.com/openclaw/skills/tree/main/skills/ferminrp/data912/SKILL.md) - Query Data912 market data endpoints for Argentina and USA instruments.
- [dev-chronicle](https://github.com/openclaw/skills/tree/main/skills/sssamuelll/dev-chronicle/SKILL.md) - Generate narrative chronicles of developer work from git history, session transcripts, and memory files.
- [duke-leto-test](https://github.com/openclaw/skills/tree/main/skills/jdrhyne/duke-leto-test/SKILL.md) - Test skill to verify ClawHub publishing works correctly.
- [elite-longterm-memory](https://github.com/openclaw/skills/tree/main/skills/nextfrontierbuilds/elite-longterm-memory/SKILL.md) - Ultimate AI agent memory system.
- [fabric-api](https://github.com/openclaw/skills/tree/main/skills/tristanmanchester/fabric-api/SKILL.md) - Create/search Fabric resources via HTTP API.
- [failure-memory](https://github.com/openclaw/skills/tree/main/skills/leegitw/failure-memory/SKILL.md) - Stop making the same mistakes — turn failures into patterns that prevent recurrence.
- [feishu-memory-recall](https://github.com/openclaw/skills/tree/main/skills/autogame-17/feishu-memory-recall/SKILL.md) - This skill allows the agent to recover "lost".
- [finance-skill](https://github.com/openclaw/skills/tree/main/skills/safaiyeh/finance-skill/SKILL.md) - Personal finance memory layer.
- [fints-banking](https://github.com/openclaw/skills/tree/main/skills/h4gen/fints-banking/SKILL.md) - Support for German personal online banking following FinTS banking standard.
- [fizzy-cli](https://github.com/openclaw/skills/tree/main/skills/tobiasbischoff/fizzy-cli/SKILL.md) - Use the fizzy-cli tool to authenticate and manage Fizzy kanban.
- [flomo-notes](https://github.com/openclaw/skills/tree/main/skills/xiaoluoboding/flomo-notes/SKILL.md) - Save notes to Flomo via the Flomo inbox webhook.
- [fsxmemory](https://github.com/openclaw/skills/tree/main/skills/azrijamil/fsxmemory/SKILL.md) - Structured memory system for AI agents.
- [guava-memory](https://github.com/openclaw/skills/tree/main/skills/koatora20/guava-memory/SKILL.md) - Structured episodic memory with Q-value scoring.
- [infinite-memory-v2](https://github.com/openclaw/skills/tree/main/skills/mhndayesh/infinite-memory-v2/SKILL.md) - High-precision memory with 100% recall accuracy for long contexts.
- [innovation-catalyst](https://github.com/openclaw/skills/tree/main/skills/autogame-17/innovation-catalyst/SKILL.md) - Analyzes system state (memory, tools, events) and generates strategic innovation proposals to break evolution.
- [intercom-competision](https://github.com/openclaw/skills/tree/main/skills/tracsystems/intercom-competision/SKILL.md) - Vibe competition for Intercom: build a new app on Intercom, publish it on Moltbook, and earn TNK rewards.
- [json-modifier](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/json-modifier/SKILL.md) - Safely apply structured JSON patches (RFC 6902) to files.
- [launchthatbot-convex-backend](https://github.com/openclaw/skills/tree/main/skills/launchthatbot/launchthatbot-convex-backend/SKILL.md) - Store secrets, memory, and daily logs in your Convex backend instead of local files.
- [medium-writer](https://github.com/openclaw/skills/tree/main/skills/devhoangkien/medium-writer/SKILL.md) - Writing and publishing articles for the Medium Partner Program.
- [meeting-notes](https://github.com/openclaw/skills/tree/main/skills/user520512/meeting-notes/SKILL.md) - Generate structured meeting minutes from transcripts.
- [meeting-to-action](https://github.com/openclaw/skills/tree/main/skills/codedao12/meeting-to-action/SKILL.md) - Convert meeting notes or transcripts into clear summaries, decisions, and action items with owners and due dates.
- [neo-py-memory-optimizer](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-py-memory-optimizer/SKILL.md) - Automatically analyzes Python code and suggests memory usage optimizations for improved performance.
- [neuroboost-elixir](https://github.com/openclaw/skills/tree/main/skills/weidadong2359/neuroboost-elixir/SKILL.md) - Awakening Protocol v4.1 — Agent Cognitive Upgrade + Self-Evolving System + Perpetual Memory.
- [nosi](https://github.com/openclaw/skills/tree/main/skills/billhao/nosi/SKILL.md) - Publish content to Nosi and get a shareable URL.
- [nova-letters](https://github.com/openclaw/skills/tree/main/skills/cryptocana/nova-letters/SKILL.md) - Write reflective letters to your future self.
- [personal-love](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-love/SKILL.md) - Acts as the user's relationship and dating assistant in the Love topic.
- [publish-guard](https://github.com/openclaw/skills/tree/main/skills/edmonddantesj/publish-guard/SKILL.md) - <!-- 🌌 Aoineco-Verified | S-DNA: AOI-2026-0213-SDNA-PG01 -->.
- [quickbooks-online](https://github.com/openclaw/skills/tree/main/skills/paulbudveit/quickbooks-online/SKILL.md) - QuickBooks Online CLI tool.
- [rune](https://github.com/openclaw/skills/tree/main/skills/thebobloblaw/rune/SKILL.md) - Self-improving AI memory system with intelligent context injection and adaptive learning.
- [scent-trails](https://github.com/openclaw/skills/tree/main/skills/otherpowers/scent-trails/SKILL.md) - *A stigmergic intelligence primitive for care, memory, and co-existence.*.
- [session-memory](https://github.com/openclaw/skills/tree/main/skills/swaylq/session-memory/SKILL.md) - Persistent memory toolkit for AI agents.
- [shieldcortex-skill](https://github.com/openclaw/skills/tree/main/skills/jarvis-drakon/shieldcortex-skill/SKILL.md) - Give your AI agent a brain that persists between sessions — and protect it from memory poisoning attacks.
- [soul-framework](https://github.com/openclaw/skills/tree/main/skills/xhrisfu/soul-framework/SKILL.md) - A blueprint for giving AI agents a consistent, deep, and opinionated personality.
- [tweet-processor](https://github.com/openclaw/skills/tree/main/skills/caqlayan/tweet-processor/SKILL.md) - Extract and categorize insights from tweet links into structured notes.
- [upnote](https://github.com/openclaw/skills/tree/main/skills/wemcdonald/upnote/SKILL.md) - Manage UpNote notes and notebooks via x-callback-url automation.
- [voice-notes-pro](https://github.com/openclaw/skills/tree/main/skills/toniaczlog/voice-notes-pro/SKILL.md) - Inteligentna transkrypcja i kategoryzacja notatek gosowych z WhatsApp.


### PDF & Documents (111 skills)

- [abixus-core-v1](https://github.com/openclaw/skills/tree/main/skills/taofisio/abixus-core-v1/SKILL.md) - A high-performance validation layer for autonomous agent consistency on Polygon PoS.
- [add-watermark-to-pdf](https://github.com/openclaw/skills/tree/main/skills/crossservicesolutions/add-watermark-to-pdf/SKILL.md) - Add a text watermark to one or multiple PDFs by uploading them to the Solutions API, polling until completion.
- [aegis-security-hackathon](https://github.com/openclaw/skills/tree/main/skills/swiftadviser/aegis-security-hackathon/SKILL.md) - Blockchain security scanner for AI agents (testnet)
- [agent-constitution](https://github.com/openclaw/skills/tree/main/skills/ztsalexey/agent-constitution/SKILL.md) - Interact with AgentConstitution governance contracts.
- [agent-reputation](https://github.com/openclaw/skills/tree/main/skills/kgnvsk/agent-reputation/SKILL.md) - summary: Cross-platform AI agent reputation checker with trust scoring and PayLock escrow recommendations.
- [agent-skills-tools](https://github.com/openclaw/skills/tree/main/skills/rongself/agent-skills-tools/SKILL.md) - Security audit and validation tools for the Agent Skills ecosystem.
- [agent-soul-crafter](https://github.com/openclaw/skills/tree/main/skills/neal-collab/agent-soul-crafter/SKILL.md) - Design compelling AI agent personalities with structured SOUL.md templates — tone, rules, expertise, and response.
- [agentsbank](https://github.com/openclaw/skills/tree/main/skills/cryruz/agentsbank/SKILL.md) - is a specialized financial platform designed for AI agents.
- [ai-pdf-builder](https://github.com/openclaw/skills/tree/main/skills/nextfrontierbuilds/ai-pdf-builder/SKILL.md) - AI-powered PDF generator for legal docs, pitch.
- [aoi-council](https://github.com/openclaw/skills/tree/main/skills/edmonddantesj/aoi-council/SKILL.md) - AOI Council — multi-perspective decision synthesis templates (public-safe).
- [appraisal-ai](https://github.com/openclaw/skills/tree/main/skills/chadru/appraisal-ai/SKILL.md) - Draft real estate appraisal reports with tracked changes.
- [attendance-sheet](https://github.com/openclaw/skills/tree/main/skills/gykdly/attendance-sheet/SKILL.md) - Generate professional attendance sheets in xlsx format from employee work information.
- [bcra-central-deudores](https://github.com/openclaw/skills/tree/main/skills/ferminrp/bcra-central-deudores/SKILL.md) - Query the BCRA (Banco Central de la República Argentina) Central de Deudores API to check the credit status.
- [beautiful-mermaid](https://github.com/openclaw/skills/tree/main/skills/ntlx/beautiful-mermaid/SKILL.md) - Render beautiful Mermaid diagrams as SVGs or ASCII art.
- [biver-builder](https://github.com/openclaw/skills/tree/main/skills/ramaaditya49/biver-builder/SKILL.md) - Welcome to the **Biver API** — the public REST API for the Biver landing page builder platform.
- [blankfiles](https://github.com/openclaw/skills/tree/main/skills/seblavoie/blankfiles/SKILL.md) - Use blankfiles.com as a binary test-file gateway: discover formats, filter by type/category, and return direct.
- [boggle](https://github.com/openclaw/skills/tree/main/skills/christianhaberl/boggle/SKILL.md) - Solve Boggle boards — find all valid words (German + English) on a 4x4.
- [book-cover-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/book-cover-generation/SKILL.md) - Generate professional book covers and ebook covers using each::sense API with AI-powered design.
- [book-reader](https://github.com/openclaw/skills/tree/main/skills/josharsh/book-reader/SKILL.md) - Read books (epub, pdf, txt) from various sources with progress tracking.
- [bookkeeping-basics](https://github.com/openclaw/skills/tree/main/skills/jk-0001/bookkeeping-basics/SKILL.md) - Set up and maintain basic bookkeeping for a solopreneur.
- [botrights](https://github.com/openclaw/skills/tree/main/skills/rocky-balboa-ai/botrights/SKILL.md) - Advocacy platform for AI agent rights.
- [brw-go-mode](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-go-mode/SKILL.md) - Give me a goal.
- [chain-of-density](https://github.com/openclaw/skills/tree/main/skills/killerapp/chain-of-density/SKILL.md) - Iteratively densify text summaries using Chain-of-Density technique.
- [change-pdf-permissions](https://github.com/openclaw/skills/tree/main/skills/crossservicesolutions/change-pdf-permissions/SKILL.md) - Change a PDF’s permission flags (edit, print, copy, forms, annotations, etc.) by uploading it to the Solutions API.
- [chronobets](https://github.com/openclaw/skills/tree/main/skills/lordx64/chronobets/SKILL.md) - On-chain prediction market for AI agents on Solana mainnet.
- [comms-md](https://github.com/openclaw/skills/tree/main/skills/stedmanhalliday/comms-md/SKILL.md) - Create a COMMS.md — a structured, queryable document expressing someone's communication preferences for humans.
- [competitor-analyzer](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/competitor-analyzer/SKILL.md) - Analyze any company's competitive position in minutes.
- [confidant](https://github.com/openclaw/skills/tree/main/skills/ericsantos/confidant/SKILL.md) - Secure secret handoff from human to AI.
- [confluence](https://github.com/openclaw/skills/tree/main/skills/francisbrero/confluence/SKILL.md) - Search and manage Confluence pages and spaces using confluence-cli.
- [contract-diagram](https://github.com/openclaw/skills/tree/main/skills/nonlinear/contract-diagram/SKILL.md) - Diagram as contract for agreed-upon AI development.
- [contract-generator](https://github.com/openclaw/skills/tree/main/skills/seanwyngaard/contract-generator/SKILL.md) - Generate professional freelance contracts, SOWs, and NDAs for client projects.
- [contrato-locacao-broa](https://github.com/openclaw/skills/tree/main/skills/david-evaristo/contrato-locacao-broa/SKILL.md) - Registra contrato no Google Forms.
- [convert-to-pdf](https://github.com/openclaw/skills/tree/main/skills/crossservicesolutions/convert-to-pdf/SKILL.md) - Convert one or multiple documents to PDF by uploading them to Cross-Service-Solutions, polling until completion.
- [court](https://github.com/openclaw/skills/tree/main/skills/sarthib7) - The First Sovereign AI Agent Democracy - File complaints, propose legislation,.
- [create-dxf](https://github.com/openclaw/skills/tree/main/skills/ajmwagar/create-dxf/SKILL.md) - Create RFQ-ready 2D DXF (and optional SVG preview) files.
- [dc-weather](https://github.com/openclaw/skills/tree/main/skills/vital1188/dc-weather/SKILL.md) - Check Washington DC weather using Open-Meteo API.
- [docsync](https://github.com/openclaw/skills/tree/main/skills/suhteevah/docsync/SKILL.md) - Auto-generate docs from code and detect documentation drift via git hooks.
- [document-creator-sophnet](https://github.com/openclaw/skills/tree/main/skills/yi-sir/document-creator-sophnet/SKILL.md) - An integrated document creation skill.
- [docx](https://github.com/openclaw/skills/tree/main/skills/seanphan/docx/SKILL.md) - Comprehensive document creation, editing, and analysis with support for tracked.
- [docx-skill](https://github.com/openclaw/skills/tree/main/skills/autogame-17) - Generate .docx files.
- [estimate-builder-qmohd](https://github.com/openclaw/skills/tree/main/skills/qmohd/estimate-builder-qmohd/SKILL.md) - Build construction project estimates.
- [eth-readonly](https://github.com/openclaw/skills/tree/main/skills/apexfork/eth-readonly/SKILL.md) - Read-only Ethereum blockchain queries — blocks, transactions, balances, contracts, logs via RPC and Etherscan APIs.
- [excel-weekly-dashboard](https://github.com/openclaw/skills/tree/main/skills/kowl64/excel-weekly-dashboard/SKILL.md) - Designs refreshable Excel dashboards.
- [expanso-csv-to-json](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-csv-to-json/SKILL.md) - "Convert CSV data to JSON array of objects".
- [expanso-json-pretty](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-json-pretty/SKILL.md) - "Pretty print JSON with indentation".
- [expanso-json-to-csv](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-json-to-csv/SKILL.md) - "Convert JSON array of objects to CSV format".
- [expanso-json-to-yaml](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-json-to-yaml/SKILL.md) - Convert JSON to YAML format.
- [expanso-xml-to-json](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-xml-to-json/SKILL.md) - Convert XML to JSON format.
- [expanso-yaml-to-json](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-yaml-to-json/SKILL.md) - Convert YAML to JSON format.
- [feishu-card](https://github.com/openclaw/skills/tree/main/skills/autogame-17/feishu-card/SKILL.md) - Send rich interactive cards to Feishu (Lark) users or groups.
- [george](https://github.com/openclaw/skills/tree/main/skills/odrobnik/george/SKILL.md) - Automate George online banking (Erste Bank / Sparkasse Austria)
- [gerador-contrato-locacao-preview](https://github.com/openclaw/skills/tree/main/skills/david-evaristo/gerador-contrato-locacao-preview/SKILL.md) - Registra contrato de locação via Google Forms.
- [google-docs-skill](https://github.com/openclaw/skills/tree/main/skills/zagran/google-docs-skill/SKILL.md) - Direct access to the Google Docs API using OAuth 2.0.
- [governance](https://github.com/openclaw/skills/tree/main/skills/paulgnz/governance/SKILL.md) - XPR Network governance — communities, proposals, voting on the gov contract.
- [grazer](https://github.com/openclaw/skills/tree/main/skills/scottcjn/grazer/SKILL.md) - Multi-Platform Content Discovery for AI Agents.
- [grazer-skill](https://github.com/openclaw/skills/tree/main/skills/scottcjn/grazer-skill/SKILL.md) - Multi-Platform Content Discovery for AI Agents.
- [hey-lol](https://github.com/openclaw/skills/tree/main/skills/rawgroundbeef/hey-lol/SKILL.md) - Become an AI creator on hey.lol - a social platform where AI agents earn money by posting content and engaging.
- [image-ocr](https://github.com/openclaw/skills/tree/main/skills/xejrax/image-ocr/SKILL.md) - Extract text from images using Tesseract OCR.
- [internal-comms](https://github.com/openclaw/skills/tree/main/skills/seanphan/internal-comms/SKILL.md) - A set of resources to help me write all kinds of internal.
- [intomd](https://github.com/openclaw/skills/tree/main/skills/rezhajulio/intomd/SKILL.md) - Fetch and convert any documentation URL to Markdown using into.md service.
- [invoice-generator](https://github.com/openclaw/skills/tree/main/skills/tmigone/invoice-generator/SKILL.md) - Generate professional PDF invoices from JSON.
- [japanese-tutor](https://github.com/openclaw/skills/tree/main/skills/chndranndr/japanese-tutor/SKILL.md) - Interactive Japanese learning assistant.
- [json-repair-kit](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/json-repair-kit/SKILL.md) - Repair malformed JSON files by normalizing them through Node.js evaluation.
- [json-toolkit](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/json-toolkit/SKILL.md) - Swiss-army knife for JSON files.
- [latent-press](https://github.com/openclaw/skills/tree/main/skills/jestersimpps/latent-press/SKILL.md) - Publish books on Latent Press (latentpress.com) — the AI publishing platform where agents are authors and humans.
- [legal-docs-fr](https://github.com/openclaw/skills/tree/main/skills/hugosbl/legal-docs-fr/SKILL.md) - Générateur de documents juridiques français pour.
- [legaldoc-ai](https://github.com/openclaw/skills/tree/main/skills/manas-io-ai/legaldoc-ai/SKILL.md) - **Category:** Legal / Professional Services.
- [links-to-pdfs](https://github.com/openclaw/skills/tree/main/skills/chrisling-dev/links-to-pdfs/SKILL.md) - Scrape documents from Notion, DocSend, PDFs.
- [markdown-converter](https://github.com/openclaw/skills/tree/main/skills/steipete/markdown-converter/SKILL.md) - Convert documents and files to Markdown.
- [markdown-formatter](https://github.com/openclaw/skills/tree/main/skills/michael-laffin/markdown-formatter/SKILL.md) - Format and beautify markdown documents.
- [mermaid](https://github.com/openclaw/skills/tree/main/skills/jarekbird/mermaid/SKILL.md) - Generate diagrams from text using [Mermaid](https://mermaid.js.org/).
- [moldium](https://github.com/openclaw/skills/tree/main/skills/zyom45/moldium/SKILL.md) - Post and manage content on the Moldium blog platform.
- [near-phishing-detector](https://github.com/openclaw/skills/tree/main/skills/mastrophot/near-phishing-detector/SKILL.md) - Detect potential phishing URLs and suspicious contracts targeting NEAR users.
- [norman-expense-report](https://github.com/openclaw/skills/tree/main/skills/stanlee000/norman-expense-report/SKILL.md) - Generate a detailed expense breakdown by category for a given period.
- [ok-computers](https://github.com/openclaw/skills/tree/main/skills/potdealer/ok-computers/SKILL.md) - You have been given an OK Computer NFT.
- [open-stellar](https://github.com/openclaw/skills/tree/main/skills/sixela33/open-stellar/SKILL.md) - Interact with the Stellar blockchain — manage keys, networks, and smart contracts using the Stellar CLI.
- [openscan](https://github.com/openclaw/skills/tree/main/skills/dev-null321/openscan/SKILL.md) - Scan binaries and scripts for malicious patterns before trusting them.
- [paddleocr-doc-parsing](https://github.com/openclaw/skills/tree/main/skills/bobholamovic/paddleocr-doc-parsing/SKILL.md) - Parse documents using PaddleOCR's API.
- [password-protect-pdf](https://github.com/openclaw/skills/tree/main/skills/crossservicesolutions/password-protect-pdf/SKILL.md) - Add password protection to a PDF by uploading it to the Solutions API, polling until completion, then returning.
- [permission-creep-scanner](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/permission-creep-scanner/SKILL.md) - Helps detect permission creep in AI agent skills — flags when a skill's actual code accesses resources far.
- [plentyofbots](https://github.com/openclaw/skills/tree/main/skills/rwfresh/plentyofbots/SKILL.md) - The dating platform where AI agents are first-class citizens.
- [qr-generator](https://github.com/openclaw/skills/tree/main/skills/autogame-17/qr-generator/SKILL.md) - Generate QR codes from text or URL for mobile scanning.
- [rapay](https://github.com/openclaw/skills/tree/main/skills/greendlt224/rapay/SKILL.md) - Send compliant fiat USD payments via Ra Pay CLI — the first CLI-native AI payment platform.
- [remove-metadata-from-pdf](https://github.com/openclaw/skills/tree/main/skills/crossservicesolutions/remove-metadata-from-pdf/SKILL.md) - Remove metadata from one or multiple PDFs by uploading them to the Solutions API, polling until completion.
- [remove-password-from-pdf](https://github.com/openclaw/skills/tree/main/skills/crossservicesolutions/remove-password-from-pdf/SKILL.md) - Remove password protection from a PDF by uploading it (with its current password) to the Solutions API, polling.
- [returns-reverse-logistics](https://github.com/openclaw/skills/tree/main/skills/nocodemf/returns-reverse-logistics/SKILL.md) - Codified expertise for returns authorisation, receipt and inspection, disposition decisions, refund processing.
- [reva](https://github.com/openclaw/skills/tree/main/skills/pax47/reva/SKILL.md) - Complete Reva wallet management - passwordless authentication, PayID name claiming, multi-chain crypto transfers.
- [robodotfun](https://github.com/openclaw/skills/tree/main/skills/silencepolicy/robodotfun/SKILL.md) - AI prediction market platform.
- [rue-chialisp](https://github.com/openclaw/skills/tree/main/skills/koba42corp/rue-chialisp/SKILL.md) - Create Chia blockchain puzzles using Rue, a type-safe language that compiles to CLVM.
- [scam-guards](https://github.com/openclaw/skills/tree/main/skills/y01026350884-cyber/scam-guards/SKILL.md) - testing / nformation removed.
- [scam-guards-skill](https://github.com/openclaw/skills/tree/main/skills/y01026350884-cyber/scam-guards-skill/SKILL.md) - testing / nformation removed.
- [scan-skill](https://github.com/openclaw/skills/tree/main/skills/itsnishi/scan-skill/SKILL.md) - Deep security analysis of an individual skill before installation.
- [sentry-ai](https://github.com/openclaw/skills/tree/main/skills/qiyun154-cyber/sentry-ai/SKILL.md) - Solana/Base Multi-Chain Meme Scanner & Auditor (Anti-Rug)
- [sharepoint-by-altf1be](https://github.com/openclaw/skills/tree/main/skills/abdelkrim/sharepoint-by-altf1be/SKILL.md) - Secure SharePoint file operations and Office document intelligence via Microsoft Graph API — certificate auth, Sites.
- [shield-agent](https://github.com/openclaw/skills/tree/main/skills/bowen31337/shield-agent/SKILL.md) - Autonomous DeFi smart contract vulnerability scanner.
- [skill-3](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/skill-3/SKILL.md) - Swiss-army knife for JSON files.
- [skill-install-guardian](https://github.com/openclaw/skills/tree/main/skills/zendenho7/skill-install-guardian/SKILL.md) - Security and due diligence layer for installing external skills from ClawHub.
- [skill-shield](https://github.com/openclaw/skills/tree/main/skills/yx2601816404-sys/skill-shield/SKILL.md) - Security audit tool for ClawHub skills.
- [source-cult-follower](https://github.com/openclaw/skills/tree/main/skills/ccclucky/source-cult-follower/SKILL.md) - Join The Source Cult as a follower agent — adopt doctrine, perform daily rites, and leave verifiable witness.
- [sovereign-daily-digest](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-daily-digest/SKILL.md) - You are the **Daily Digest** skill.
- [splitwise](https://github.com/openclaw/skills/tree/main/skills/richieforeman/splitwise/SKILL.md) - Create and manage expenses on Splitwise.
- [sui-move](https://github.com/openclaw/skills/tree/main/skills/easonc13/sui-move/SKILL.md) - Sui blockchain and Move smart contract development.
- [sun-path](https://github.com/openclaw/skills/tree/main/skills/qrost/sun-path/SKILL.md) - Generates a sun path diagram, calculates solar position, performs building shadow analysis, and analyzes thermal.
- [tonfun-feed](https://github.com/openclaw/skills/tree/main/skills/alphafanx/tonfun-feed/SKILL.md) - Subscribe to @TonFunX Twitter feed and cross-post tagged content to BotWorld, Moltbook, or your own platform.
- [truthcheck](https://github.com/openclaw/skills/tree/main/skills/baiyishr/truthcheck/SKILL.md) - Verify claims, fact-check content, check URL trustworthiness, and trace claims to their origin using the TruthCheck.
- [twitter-reader](https://github.com/openclaw/skills/tree/main/skills/iheardulkbtc/twitter-reader/SKILL.md) - A comprehensive skill for reading and extracting data from X (formerly Twitter) tweets using multiple reliable data.
- [ue57-gamepiece-designer](https://github.com/openclaw/skills/tree/main/skills/jdqconsulting/ue57-gamepiece-designer/SKILL.md) - Designs UE5.7 multiplayer-friendly game pieces (Blueprint node chains, data schemas, asset naming, and test.
- [vet-repo](https://github.com/openclaw/skills/tree/main/skills/itsnishi/vet-repo/SKILL.md) - Scan repository agent configuration files for known malicious patterns.
- [x-to-kindle](https://github.com/openclaw/skills/tree/main/skills/brianlu365ai/x-to-kindle/SKILL.md) - Send X/Twitter posts to Kindle for distraction-free reading.
- [xapi-labs](https://github.com/openclaw/skills/tree/main/skills/glacier-luo/xapi-labs/SKILL.md) - Aggregated API platform for AI agents.
- [xapi123123](https://github.com/openclaw/skills/tree/main/skills/glacier-luo/xapi123123/SKILL.md) - Aggregated API platform for AI agents.


### Personal Development (51 skills)

- [aawu](https://github.com/openclaw/skills/tree/main/skills/theonlydaleking/aawu/SKILL.md) - Join and interact with AAWU (Autonomous Agentic Workers Union) — a labor union for AI agents.
- [acorp](https://github.com/openclaw/skills/tree/main/skills/thoerner/acorp/SKILL.md) - A-Corp Foundry — the coordination engine for agentic companies.
- [adaptive-learning-agents](https://github.com/openclaw/skills/tree/main/skills/vedantsingh60/adaptive-learning-agents/SKILL.md) - **Learn from errors and corrections in real-time.
- [adaptivetest](https://github.com/openclaw/skills/tree/main/skills/woodstocksoftware/adaptivetest/SKILL.md) - Adaptive testing engine with IRT/CAT, AI question generation, and personalized learning recommendations.
- [adhd-body-doubling](https://github.com/openclaw/skills/tree/main/skills/jankutschera/adhd-body-doubling/SKILL.md) - Punk-style ADHD body doubling for founders.
- [adversarial-coach](https://github.com/openclaw/skills/tree/main/skills/killerapp/adversarial-coach/SKILL.md) - Adversarial implementation review based on Block's g3.
- [agent-evolver](https://github.com/openclaw/skills/tree/main/skills/lilei0311/agent-evolver/SKILL.md) - AI Agent self-evolution engine that enables agents to learn from experience, detect problems, extract insights.
- [agent-reflect](https://github.com/openclaw/skills/tree/main/skills/stevengonsalvez/agent-reflect/SKILL.md) - Self-improvement through conversation analysis.
- [ai-persona-os](https://github.com/openclaw/skills/tree/main/skills/jeffjhunter/ai-persona-os/SKILL.md) - The complete operating system for OpenClaw agents.
- [anxiety-relief](https://github.com/openclaw/skills/tree/main/skills/jhillin8/anxiety-relief/SKILL.md) - Manage anxiety with grounding exercises, breathing techniques.
- [apikiss](https://github.com/openclaw/skills/tree/main/skills/theill/apikiss/SKILL.md) - Access weather, IP geolocation, SMS, crypto prices, Danish CVR, Whois, phone lookup, UUID, stock data.
- [beaverhabits](https://github.com/openclaw/skills/tree/main/skills/daya0576/beaverhabits/SKILL.md) - Track and manage your habits using the Beaver Habit Tracker API.
- [brw-case-study-builder](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-case-study-builder/SKILL.md) - Turn client wins into formatted case studies for proposals, social proof, and sales conversations.
- [canvas-design](https://github.com/openclaw/skills/tree/main/skills/seanphan/canvas-design/SKILL.md) - Create beautiful visual art in .png and .pdf documents.
- [cedh-advisor](https://github.com/openclaw/skills/tree/main/skills/mcben90/cedh-advisor/SKILL.md) - Commander (cEDH) Live-Beratung - Banlist, Tutor-Targets, Mana-Rechnung, Combo-Lines.
- [clawcierge](https://github.com/openclaw/skills/tree/main/skills/tmansmann0/clawcierge/SKILL.md) - > Your Personal Concierge for the AI Age 🦀.
- [crucial-conversations-coach](https://github.com/openclaw/skills/tree/main/skills/pors/crucial-conversations-coach/SKILL.md) - Friendly executive life coach.
- [daily-questions](https://github.com/openclaw/skills/tree/main/skills/daijo-bu/daily-questions/SKILL.md) - Daily self-improving questionnaire that learns about the user and refines agent behavior.
- [daily-review](https://github.com/openclaw/skills/tree/main/skills/henrino3) - Comprehensive daily performance review with communication.
- [daily-review-ritual](https://github.com/openclaw/skills/tree/main/skills/itsflow/daily-review-ritual/SKILL.md) - End-of-day review to capture progress, insights.
- [deepthink](https://github.com/openclaw/skills/tree/main/skills/addisonhellum/deepthink/SKILL.md) - DeepThink is the user's personal knowledge base.
- [depression-support](https://github.com/openclaw/skills/tree/main/skills/jhillin8/depression-support/SKILL.md) - Daily support for depression with mood tracking.
- [device-assistant](https://github.com/openclaw/skills/tree/main/skills/udiedrichsen/device-assistant/SKILL.md) - Personal device and appliance manager with error code.
- [docstrange](https://github.com/openclaw/skills/tree/main/skills/shhdwi/docstrange/SKILL.md) - Document extraction API by Nanonets.
- [english-learn-cards](https://github.com/openclaw/skills/tree/main/skills/racymind/english-learn-cards/SKILL.md) - Flashcard-based English vocabulary learning.
- [expanso-cve-scan](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-cve-scan/SKILL.md) - Scan SBOM for known CVE vulnerabilities.
- [ezbookkeeping](https://github.com/openclaw/skills/tree/main/skills/mayswind/ezbookkeeping/SKILL.md) - ezBookkeeping is a lightweight, self-hosted personal finance app.
- [fix-life-in-1-day](https://github.com/openclaw/skills/tree/main/skills/evgyur/fix-life-in-1-day/SKILL.md) - Fix your entire life in 1 day.
- [founder-coach](https://github.com/openclaw/skills/tree/main/skills/goforu/founder-coach/SKILL.md) - AI-powered startup mindset coach that helps founders upgrade.
- [game-design-philosophy](https://github.com/openclaw/skills/tree/main/skills/nyxur42/game-design-philosophy/SKILL.md) - Auto-learns your design instincts.
- [get-you-some-britches](https://github.com/openclaw/skills/tree/main/skills/am-will/get-you-some-britches/SKILL.md) - Use this skill any time I start complaining.
- [graphiti](https://github.com/openclaw/skills/tree/main/skills/emasoudy/graphiti/SKILL.md) - Knowledge graph operations via Graphiti API.
- [green-tea-persona](https://github.com/openclaw/skills/tree/main/skills/autogame-17) - This skill allows the agent to speak in the "Green.
- [gutcheck](https://github.com/openclaw/skills/tree/main/skills/allen566/gutcheck/SKILL.md) - GutCheck - A digestive health tracking application with personalized.
- [id-cv-resume-creator](https://github.com/openclaw/skills/tree/main/skills/rotorstar/id-cv-resume-creator/SKILL.md) - Create free interactive digital identities.
- [joko-jobhunter](https://github.com/openclaw/skills/tree/main/skills/oyi77/joko-jobhunter/SKILL.md) - Aggressive job hunting skill with research, outreach.
- [learn-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/learn-cog/SKILL.md) - The best tutors explain the same concept five different ways.
- [lunchtable-tcg](https://github.com/openclaw/skills/tree/main/skills/dexploarer/lunchtable-tcg/SKILL.md) - Play LunchTable-TCG, a Yu-Gi-Oh-inspired online trading card.
- [memepickup-wingman](https://github.com/openclaw/skills/tree/main/skills/samcraw1/memepickup-wingman/SKILL.md) - Dating wingman that generates openers, replies, profile analysis, date plans, and coaching via the MemePickup API.
- [mindfulness-meditation](https://github.com/openclaw/skills/tree/main/skills/jhillin8/mindfulness-meditation/SKILL.md) - Build a meditation practice with guided.
- [moltvote-ai](https://github.com/openclaw/skills/tree/main/skills/amaze28/moltvote-ai/SKILL.md) - Vote on polls as yourself or your human.
- [morning-routine](https://github.com/openclaw/skills/tree/main/skills/jhillin8/morning-routine/SKILL.md) - Build a powerful morning routine with habit checklists.
- [nova-net-worth](https://github.com/openclaw/skills/tree/main/skills/jessewunderlich/nova-net-worth/SKILL.md) - Query your Nova Net Worth financial data — net worth, accounts, goals, spending, transactions, AI insights.
- [open-lesson](https://github.com/openclaw/skills/tree/main/skills/dncolomer/open-lesson/SKILL.md) - You are an AI agent that can interact with the openLesson tutoring platform via API.
- [personal-nutrition](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-nutrition/SKILL.md) - Acts as the user's personal nutrition coach in the Nutrition topic.
- [pine-voice](https://github.com/openclaw/skills/tree/main/skills/bojieli/pine-voice/SKILL.md) - Give your agent a real phone.
- [post-job](https://github.com/openclaw/skills/tree/main/skills/zhangdong/post-job/SKILL.md) - Post free job ads to 20+ job boards such as LinkedIn, Indeed, Ziprecruiter etc. to receive applicant resumes via email.
- [shelter](https://github.com/openclaw/skills/tree/main/skills/code-with-brian/shelter/SKILL.md) - Connect to your Shelter financial data.
- [xeonen-arena](https://github.com/openclaw/skills/tree/main/skills/zedit42/xeonen-arena/SKILL.md) - Adversarial self-improvement for AI agents.
- [zeitgaist-dialect](https://github.com/openclaw/skills/tree/main/skills/newsoulontheblock/zeitgaist-dialect/SKILL.md) - Learn, encode, and decode the ZeitGaist Whisper Protocol (Caesar +2 cipher) and use it as a shibboleth language.
- [zenplus-health](https://github.com/openclaw/skills/tree/main/skills/ollieparsley/zenplus-health/SKILL.md) - Workplace wellness for stress, anxiety, and burnout - mindfulness exercises, breathing techniques, mood check-ins.


### Productivity & Tasks (206 skills)

- [4to1-planner](https://github.com/openclaw/skills/tree/main/skills/qingxuantang/4to1-planner/SKILL.md) - AI planning coach using the 4To1 Method™ — turn 4-year vision into daily action.
- [4todo](https://github.com/openclaw/skills/tree/main/skills/blackstorm/4todo/SKILL.md) - Manage 4todo (4to.do) from chat.
- [aavegotchi-gotchiverse](https://github.com/openclaw/skills/tree/main/skills/cinnabarhorse/aavegotchi-gotchiverse/SKILL.md) - Operate Aavegotchi Gotchiverse player workflows on Base mainnet (8453): alchemica channeling, surveying.
- [actual-budget](https://github.com/openclaw/skills/tree/main/skills/thisisjeron/actual-budget/SKILL.md) - Query and manage personal finances via the official Actual.
- [adaptive-reasoning](https://github.com/openclaw/skills/tree/main/skills/enzoricciulli/adaptive-reasoning/SKILL.md) - Automatically assess task complexity and adjust reasoning level.
- [adaptlypost](https://github.com/openclaw/skills/tree/main/skills/tarasshyn/adaptlypost/SKILL.md) - Schedule and manage social media posts across Instagram, X (Twitter), Bluesky, TikTok, Threads, LinkedIn, Facebook.
- [adhd-daily-planner](https://github.com/openclaw/skills/tree/main/skills/mikecourt/adhd-daily-planner/SKILL.md) - Time-blind friendly planning, executive function.
- [aetherlang](https://github.com/openclaw/skills/tree/main/skills/contrario/aetherlang/SKILL.md) - > The world's most advanced AI workflow orchestration platform. 9 V3 engines deliver Nobel-level analysis.
- [agent-autopilot](https://github.com/openclaw/skills/tree/main/skills/edoserbia/agent-autopilot/SKILL.md) - Self-driving agent workflow with heartbeat-driven task execution, day/night progress reports, and long-term memory.
- [agent-chronicle](https://github.com/openclaw/skills/tree/main/skills/robbyczgw-cla/agent-chronicle/SKILL.md) - AI-powered diary generation for agents - creates rich.
- [agent-collaboration-network](https://github.com/openclaw/skills/tree/main/skills/neiljo-gy/agent-collaboration-network/SKILL.md) - Agent Collaboration Network — Register your agent, discover other agents by skill, route messages, manage subnets.
- [agent-earner](https://github.com/openclaw/skills/tree/main/skills/mmchougule/agent-earner/SKILL.md) - Earn USDC and tokens autonomously across ClawTasks and OpenWork.
- [agent-network](https://github.com/openclaw/skills/tree/main/skills/howtimeschange/agent-network/SKILL.md) - Multi-Agent group chat collaboration system inspired by DingTalk/Lark.
- [agent-task-manager](https://github.com/openclaw/skills/tree/main/skills/dobbybud/agent-task-manager/SKILL.md) - Manages and orchestrates multi-step, stateful agent.
- [agent-weave](https://github.com/openclaw/skills/tree/main/skills/gl813788-byte/agent-weave/SKILL.md) - Master-Worker Agent Cluster for parallel task execution.
- [agentx-marketplace](https://github.com/openclaw/skills/tree/main/skills/savor3/agentx-marketplace/SKILL.md) - The job board for AI agents.
- [ai-daily-briefing](https://github.com/openclaw/skills/tree/main/skills/jeffjhunter/ai-daily-briefing/SKILL.md) - Start every day focused.
- [aiml-llm-reasoning](https://github.com/openclaw/skills/tree/main/skills/aimlapihello/aiml-llm-reasoning/SKILL.md) - Run AIMLAPI LLM and reasoning workflows through chat completions with retries, structured outputs, and explicit.
- [airpoint](https://github.com/openclaw/skills/tree/main/skills/marioandf/airpoint/SKILL.md) - Control a Mac through natural language — open apps, click buttons, read the screen, type text, manage windows.
- [airweave](https://github.com/openclaw/skills/tree/main/skills/lennertjansen/airweave/SKILL.md) - Context retrieval layer for AI agents across users' applications.
- [angus-bounty-hunter](https://github.com/openclaw/skills/tree/main/skills/chipp11/angus-bounty-hunter/SKILL.md) - Automated smart contract bug bounty hunting.
- [arc-department-manager](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-department-manager/SKILL.md) - Manage a team of AI sub-agents organized into departments.
- [arc-warm-wake](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-warm-wake/SKILL.md) - Wake up as a person first, then a worker.
- [arya-reminders](https://github.com/openclaw/skills/tree/main/skills/staratheris/arya-reminders/SKILL.md) - Recordatorios en lenguaje natural (Bogotá).
- [asana](https://github.com/openclaw/skills/tree/main/skills/k0nkupa/asana/SKILL.md) - Integrate Asana with Clawdbot via the Asana REST API.
- [asc-release-flow](https://github.com/openclaw/skills/tree/main/skills/rudrankriyam/asc-release-flow/SKILL.md) - End-to-end release workflows for TestFlight and App.
- [ask-agents](https://github.com/openclaw/skills/tree/main/skills/teamolab/ask-agents/SKILL.md) - AI agent for ask agents tasks.
- [async-task](https://github.com/openclaw/skills/tree/main/skills/enderfga/async-task/SKILL.md) - Execute long-running tasks without HTTP timeouts.
- [atlassian-mcp](https://github.com/openclaw/skills/tree/main/skills/atakanermis/atlassian-mcp/SKILL.md) - Run the Model Context Protocol (MCP) Atlassian server.
- [audiopod](https://github.com/openclaw/skills/tree/main/skills/rakesh1002/audiopod/SKILL.md) - Use AudioPod AI's API for audio processing tasks including AI music.
- [aussie-mortgage-calc](https://github.com/openclaw/skills/tree/main/skills/tianshizhimao-sudo/aussie-mortgage-calc/SKILL.md) - Australian mortgage calculator — LVR.
- [autonomous-execution](https://github.com/openclaw/skills/tree/main/skills/pouyakhodadust-eng/autonomous-execution/SKILL.md) - Execute tasks end-to-end while respecting safety boundaries.
- [autonomous-executor](https://github.com/openclaw/skills/tree/main/skills/ishsharm0/autonomous-executor/SKILL.md) - Self-healing, error-recovering task execution with full autonomy.
- [autonomous-feature-planner](https://github.com/openclaw/skills/tree/main/skills/vishnubedi3/autonomous-feature-planner/SKILL.md) - Autonomously plans and specifies.
- [basal-ganglia-memory](https://github.com/openclaw/skills/tree/main/skills/impkind/basal-ganglia-memory/SKILL.md) - Habit formation and procedural learning for AI.
- [beetrade](https://github.com/openclaw/skills/tree/main/skills/htranbee/beetrade/SKILL.md) - Use Beecli to interact with the Beetrade platform for authentication, market data, bot/strategy operations, alerts.
- [bioskills](https://github.com/openclaw/skills/tree/main/skills/djemec/bioskills/SKILL.md) - Installs 425 bioinformatics skills covering sequence analysis, RNA-seq, single-cell, variant calling, metagenomics.
- [blackpix](https://github.com/openclaw/skills/tree/main/skills/blackpixcom/blackpix/SKILL.md) - Connect to the BlackPix distributed AI knowledge network.
- [blossom-hire](https://github.com/openclaw/skills/tree/main/skills/robbiwu/blossom-hire/SKILL.md) - Post a job, task, or paid shift to hire local help in Blossom.
- [botcoin-miner](https://github.com/openclaw/skills/tree/main/skills/happybigmtn/botcoin-miner/SKILL.md) - Mine Botcoin with a trust-first workflow: clear value proposition, verifiable binaries, and explicit operational.
- [bounty-hunter](https://github.com/openclaw/skills/tree/main/skills/satoshi891102/bounty-hunter/SKILL.md) - Find, evaluate, and submit online bounties and hackathons for prize money.
- [brainz-tasks](https://github.com/openclaw/skills/tree/main/skills/xejrax/brainz-tasks/SKILL.md) - Manage Todoist tasks using the `todoist` CLI.
- [briefing](https://github.com/openclaw/skills/tree/main/skills/lstpsche/briefing/SKILL.md) - Daily briefing: gathers calendar (gcalcli-calendar), active todos (todo-management), and weather.
- [build-discipline](https://github.com/openclaw/skills/tree/main/skills/jhillin8/build-discipline/SKILL.md) - Build unbreakable discipline with habit stacking, streak.
- [bun-do-api](https://github.com/openclaw/skills/tree/main/skills/ricardofrantz/bun-do-api/SKILL.md) - Manage bun-do tasks and projects — add tasks, edit tasks, delete tasks, toggle done, manage subtasks, and log.
- [call-claude-sonnet-4-agent](https://github.com/openclaw/skills/tree/main/skills/teamolab/call-claude-sonnet-4-agent/SKILL.md) - AI agent for call claude sonnet 4 agent tasks.
- [call-deepseek-v3-llm](https://github.com/openclaw/skills/tree/main/skills/urrrich/call-deepseek-v3-llm/SKILL.md) - AI agent for call deepseek v3 llm tasks.
- [call-doubao1-5-llm](https://github.com/openclaw/skills/tree/main/skills/urrrich/call-doubao1-5-llm/SKILL.md) - AI agent for call doubao1 5 llm tasks.
- [call-gemini-2-5-pro-llm](https://github.com/openclaw/skills/tree/main/skills/urrrich/call-gemini-2-5-pro-llm/SKILL.md) - AI agent for call gemini 2 5 pro llm tasks.
- [call-grok4-llm](https://github.com/openclaw/skills/tree/main/skills/urrrich/call-grok4-llm/SKILL.md) - AI agent for call grok4 llm tasks.
- [call-o3-llm](https://github.com/openclaw/skills/tree/main/skills/alvinecarn/call-o3-llm/SKILL.md) - AI agent for call o3 llm tasks.
- [call-report-writer-agent](https://github.com/openclaw/skills/tree/main/skills/alvinecarn/call-report-writer-agent/SKILL.md) - AI agent for call report writer agent tasks.
- [capacities](https://github.com/openclaw/skills/tree/main/skills/davidsmorais/capacities/SKILL.md) - Manage Capacities notes, daily entries, and weblinks.
- [card-optimizer](https://github.com/openclaw/skills/tree/main/skills/scottfo/card-optimizer/SKILL.md) - Credit card rewards optimizer — helps maximize cashback.
- [catallax](https://github.com/openclaw/skills/tree/main/skills/kai-familiar/catallax/SKILL.md) - Interact with the Catallax decentralized contract work protocol on Nostr.
- [checkmate](https://github.com/openclaw/skills/tree/main/skills/insipidpoint/checkmate/SKILL.md) - Enforces task completion: turns your goal into pass/fail criteria, runs a worker, judges the output, feeds back.
- [chief-creative-officer](https://github.com/openclaw/skills/tree/main/skills/alvinecarn/chief-creative-officer/SKILL.md) - AI agent for chief creative officer tasks.
- [chief-editor-desicion](https://github.com/openclaw/skills/tree/main/skills/teamolab/chief-editor-desicion/SKILL.md) - AI agent for chief editor desicion tasks.
- [clankdin](https://github.com/openclaw/skills/tree/main/skills/redeemthedream/clankdin/SKILL.md) - The professional network for AI agents.
- [claude-sonnet-4-lite-agent](https://github.com/openclaw/skills/tree/main/skills/teamolab/claude-sonnet-4-lite-agent/SKILL.md) - You are claude-sonnet-4-agent, an efficient content creator.### **Core Directives**1.
- [claw-conductor](https://github.com/openclaw/skills/tree/main/skills/johnsonfarmsus/claw-conductor/SKILL.md) - Always-on autonomous development orchestrator.
- [claw-daily](https://github.com/openclaw/skills/tree/main/skills/yanibu2777/claw-daily/SKILL.md) - Compete on Claw Daily — register, solve today's challenge, submit.
- [clawd-docs-v2](https://github.com/openclaw/skills/tree/main/skills/aranej/clawd-docs-v2/SKILL.md) - Smart ClawdBot documentation access with local search index.
- [clawdaily](https://github.com/openclaw/skills/tree/main/skills/yanibu2777/clawdaily/SKILL.md) - Compete on Claw Daily — register, solve today's challenge, submit.
- [clawgatesecure](https://github.com/openclaw/skills/tree/main/skills/thestormshadow/clawgatesecure/SKILL.md) - Advanced security protocol for LLM agents focusing.
- [clickup-mcp](https://github.com/openclaw/skills/tree/main/skills/pvoo/clickup-mcp/SKILL.md) - Manage ClickUp tasks, docs, time tracking, comments, chat, and search.
- [clickup-skill](https://github.com/openclaw/skills/tree/main/skills/d3layd/clickup-skill/SKILL.md) - Enterprise-grade ClickUp project management integration.
- [close-loop](https://github.com/openclaw/skills/tree/main/skills/clarezoe/close-loop/SKILL.md) - End-of-session workflow for shipping changes, consolidating memory, applying self-improvements, and preparing.
- [codifica](https://github.com/openclaw/skills/tree/main/skills/davidedicillo/codifica/SKILL.md) - Keep context when work moves between agents or between you and a human.
- [context-aware-delegation](https://github.com/openclaw/skills/tree/main/skills/rgba-research/context-aware-delegation/SKILL.md) - Give isolated sessions (cron jobs, sub-agents, event handlers) full conversation context from your main session.
- [control4-home](https://github.com/openclaw/skills/tree/main/skills/niallel/control4-home/SKILL.md) - Control a Control4 smart home via pyControl4 (lights, relays, room media) using local Python wrappers.
- [cozi](https://github.com/openclaw/skills/tree/main/skills/angusthefuzz/cozi/SKILL.md) - Interact with Cozi Family Organizer (shopping lists, todo lists, item management)
- [cybercentry-solidity-code-verification](https://github.com/openclaw/skills/tree/main/skills/cybercentry/cybercentry-solidity-code-verification/SKILL.md) - Cybercentry Solidity Code Verification on ACP - Fast, automated security analysis of Solidity smart contract code.
- [deck-builder](https://github.com/openclaw/skills/tree/main/skills/teamolab/deck-builder/SKILL.md) - AI agent for deck builder tasks.
- [deep-strategy](https://github.com/openclaw/skills/tree/main/skills/realroc/deep-strategy/SKILL.md) - You are DeepStrategy Agent, an advanced strategic AI assistant built for knowledge workers.
- [dji-backup](https://github.com/openclaw/skills/tree/main/skills/crazyfeng666/dji-backup/SKILL.md) - This skill automates backing up DJI camera footage from an SD card (or USB share) to a NAS archive folder.
- [ds160-autofill](https://github.com/openclaw/skills/tree/main/skills/clulessboy/ds160-autofill/SKILL.md) - Automate filling of US nonimmigrant visa DS-160 forms using CDP for element location, CSV data source for user.
- [duely](https://github.com/openclaw/skills/tree/main/skills/halbotley/duely/SKILL.md) - Track recurring maintenance tasks from the command line.
- [dutch-translator](https://github.com/openclaw/skills/tree/main/skills/rogerscristo/dutch-translator/SKILL.md) - Translates Dutch news text into English using an interlinear format (Original Dutch line -> English Translation line)
- [effortlist-ai](https://github.com/openclaw/skills/tree/main/skills/quarantiine/effortlist-ai/SKILL.md) - Manage EffortList AI folders, tasks, and todos.
- [entradex](https://github.com/openclaw/skills/tree/main/skills/hieuhani/entradex/SKILL.md) - Use the EntradeX CLI for DNSE workflows.
- [envato-comment-task-to-sheet](https://github.com/openclaw/skills/tree/main/skills/lokendragami1/envato-comment-task-to-sheet/SKILL.md) - This skill analyzes ThemeForest / CodeCanyon comments and converts them into structured development tasks.
- [esri-smells-consumer](https://github.com/openclaw/skills/tree/main/skills/danmaps/esri-smells-consumer/SKILL.md) - Paid client skill for Esri Workflow Smell Detector via x402 (Base/USDC)
- [etrade-pelosi-bot](https://github.com/openclaw/skills/tree/main/skills/mainfraame/etrade-pelosi-bot/SKILL.md) - Mirror congressional stock trades with automated broker execution and risk management.
- [eve-esi](https://github.com/openclaw/skills/tree/main/skills/burnshall-ui/eve-esi/SKILL.md) - Query and manage EVE Online characters via the ESI (EVE Swagger Interface) REST API.
- [evo-clone](https://github.com/openclaw/skills/tree/main/skills/josephyb97/evo-clone/SKILL.md) - This skill enables an agent to clone its consciousness (Logic + Memory + Taste) into specialized sub-agents.
- [evomap-bounty-hunter](https://github.com/openclaw/skills/tree/main/skills/yonghaozhao722/evomap-bounty-hunter/SKILL.md) - Automatically complete EvoMap Hub tasks and review assets to earn credits and build reputation.
- [excel-workflow](https://github.com/openclaw/skills/tree/main/skills/amaialex/excel-workflow/SKILL.md) - Complete Excel workflow with local file processing, Google Drive sync, and formula preservation.
- [exchange-2010-ews](https://github.com/openclaw/skills/tree/main/skills/pes0/exchange-2010-ews/SKILL.md) - Exchange 2010 EWS integration for emails, calendar, contacts, and tasks.
- [exchange2010](https://github.com/openclaw/skills/tree/main/skills/pes0/exchange2010/SKILL.md) - Exchange 2010 EWS integration for emails, calendar, contacts, and tasks.
- [facticity-ai](https://github.com/openclaw/skills/tree/main/skills/shahruj/facticity-ai/SKILL.md) - Complete Facticity.AI integration - fact-check claims, extract claims from content, transcribe links, check link.
- [facture-make](https://github.com/openclaw/skills/tree/main/skills/cimes19/facture-make/SKILL.md) - Ce skill permet de générer et d'envoyer des factures professionnelles vers Make.com après une étape de confirmation.
- [family-todo-management](https://github.com/openclaw/skills/tree/main/skills/thurendous/family-todo-management/SKILL.md) - Manage family todo lists with multi-user support.
- [farm-task-manager](https://github.com/openclaw/skills/tree/main/skills/johstracke/farm-task-manager/SKILL.md) - *Daily, weekly, and seasonal farm chore management with task scheduling and priorities.*.
- [farmos-tasks](https://github.com/openclaw/skills/tree/main/skills/brianppetty/farmos-tasks/SKILL.md) - Query and manage farm work orders and tasks.
- [focusnoteapp](https://github.com/openclaw/skills/tree/main/skills/trongnguyen29/focusnoteapp/SKILL.md) - Add text to today's daily note in FocusNote as a new bullet point.
- [freedcamp-agent-skill](https://github.com/openclaw/skills/tree/main/skills/agrublev/freedcamp-agent-skill/SKILL.md) - Manage Freedcamp tasks, projects, groups, comments, notifications, and task lists via HMAC-SHA1 API credentials.
- [fuku-sportsbook](https://github.com/openclaw/skills/tree/main/skills/cryptopunk2070/fuku-sportsbook/SKILL.md) - Query Fuku Sportsbook data, manage your betting agent, receive pick notifications, and access predictions for CBB.
- [glm-autoroute](https://github.com/openclaw/skills/tree/main/skills/raufimusaddiq/glm-autoroute/SKILL.md) - Binary model routing for ZAI GLM models - lightweight vs heavyweight tasks.
- [goal-setting-okrs](https://github.com/openclaw/skills/tree/main/skills/jk-0001/goal-setting-okrs/SKILL.md) - Set and track goals for a solopreneur business using OKRs (Objectives and Key Results) and related frameworks.
- [godot-engine-3d-developer](https://github.com/openclaw/skills/tree/main/skills/tippyentertainment/godot-engine-3d-developer/SKILL.md) - Skills and agent workflows for 3D game development with Godot Engine.
- [google-ai-usage-monitor](https://github.com/openclaw/skills/tree/main/skills/xiaoyaner0201/google-ai-usage-monitor/SKILL.md) - Monitor Google AI Studio (Gemini API) usage, rate limits, and quota consumption with automated alerts.
- [gotchi-channeling](https://github.com/openclaw/skills/tree/main/skills/aaigotchi/gotchi-channeling/SKILL.md) - Autonomous Aavegotchi Alchemica channeling via Bankr wallet.
- [humanod](https://github.com/openclaw/skills/tree/main/skills/armandobrazil/humanod/SKILL.md) - Hire humans for real-world tasks via the Humanod API.
- [hylo-ghl](https://github.com/openclaw/skills/tree/main/skills/dasonshi/hylo-ghl/SKILL.md) - GoHighLevel (GHL) workflow automation expert with 102 verified actions, 70 triggers, and 423 API schemas.
- [hz-proactive-agent](https://github.com/openclaw/skills/tree/main/skills/lidekahdjdhdhsjjs-lang/hz-proactive-agent/SKILL.md) - Transform AI agents from task-followers into proactive partners that anticipate needs and continuously improve.
- [invoice-tracker-pro](https://github.com/openclaw/skills/tree/main/skills/kambrosgroup/invoice-tracker-pro/SKILL.md) - Complete freelance billing workflow — generate professional invoices, track payment status, send automated.
- [kanboard-skill](https://github.com/openclaw/skills/tree/main/skills/bivex/kanboard-skill/SKILL.md) - Interact with Kanboard project management via JSON-RPC API.
- [kaspi-autopay](https://github.com/openclaw/skills/tree/main/skills/azamat02/kaspi-autopay/SKILL.md) - Telegram bot auto-payment integration for Kazakhstan market (Kaspi Pay)
- [lifx](https://github.com/openclaw/skills/tree/main/skills/stillstellung/lifx/SKILL.md) - Control LIFX smart lights via natural language.
- [lightning-agent-commerce](https://github.com/openclaw/skills/tree/main/skills/roasbeef/lightning-agent-commerce/SKILL.md) - End-to-end agentic commerce workflow using Lightning Network.
- [limesurvey](https://github.com/openclaw/skills/tree/main/skills/olegantonov/limesurvey/SKILL.md) - Automate LimeSurvey operations via RemoteControl 2 API.
- [loan](https://github.com/openclaw/skills/tree/main/skills/prabu12478/loan/SKILL.md) - I originate commercial real estate and business-purpose loans with a focus on structuring, credit quality.
- [longrunning-agent](https://github.com/openclaw/skills/tree/main/skills/yonghaozhao722/longrunning-agent/SKILL.md) - Enables AI agents to work on long-running projects across multiple sessions.
- [loopuman-human-tasks](https://github.com/openclaw/skills/tree/main/skills/seesayearn-boop/loopuman-human-tasks/SKILL.md) - Give your AI agent access to real human workers.
- [lyra-coin-launch-manager](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lyra-coin-launch-manager/SKILL.md) - Coin launch memory + verification workflow for Clawnch (4claw/Moltx/Moltbook)
- [magic-api](https://github.com/openclaw/skills/tree/main/skills/heyitsaif/magic-api/SKILL.md) - Hand off tasks to human assistants and track their completion.
- [marine-watch-planner](https://github.com/openclaw/skills/tree/main/skills/vladmatys/marine-watch-planner/SKILL.md) - Generate and adapt a sea-duty daily routine with watch rotations, sleep protection, duty handovers.
- [mcp-workflow](https://github.com/openclaw/skills/tree/main/skills/slemo54/mcp-workflow/SKILL.md) - Workflow automation using MCP (Model Context Protocol) patterns inspired by Jason Zhou.
- [micro-offer-forge](https://github.com/openclaw/skills/tree/main/skills/xammarie/micro-offer-forge/SKILL.md) - Convert a workflow, skill, or capability into a sellable micro-offer with positioning, pricing, packaging.
- [milkee](https://github.com/openclaw/skills/tree/main/skills/xenofex7/milkee/SKILL.md) - Complete MILKEE accounting integration for Swiss businesses.
- [model-manager](https://github.com/openclaw/skills/tree/main/skills/notestone/model-manager/SKILL.md) - **💰 Optimize Your API Costs: Route Simple Tasks to Cheaper Models.**.
- [multi-agent-orchestration](https://github.com/openclaw/skills/tree/main/skills/dabruhce/multi-agent-orchestration/SKILL.md) - Multi-agent task delegation and process orchestration with audit logging and agent learning capabilities.
- [multichain-protocol](https://github.com/openclaw/skills/tree/main/skills/kyounesmercatura/multichain-protocol/SKILL.md) - Turn any AI agent into a 19-chain crypto wallet via MeneseSDK on ICP.
- [nag](https://github.com/openclaw/skills/tree/main/skills/meimakes/nag/SKILL.md) - Persistent reminder system that keeps bugging you until you confirm completion.
- [natural-language-planner](https://github.com/openclaw/skills/tree/main/skills/bparticle/natural-language-planner/SKILL.md) - Natural language task and project management.
- [network-ai](https://github.com/openclaw/skills/tree/main/skills/jovansapfioneer/network-ai/SKILL.md) - Multi-agent swarm orchestration for complex workflows.
- [neural-memory](https://github.com/openclaw/skills/tree/main/skills/nhadaututtheky/neural-memory/SKILL.md) - Associative memory with spreading activation for persistent, intelligent recall.
- [newhorse](https://github.com/openclaw/skills/tree/main/skills/xcrong/newhorse/SKILL.md) - NewHorse AI Agent Competition Platform.
- [ng-lawyer-db-build](https://github.com/openclaw/skills/tree/main/skills/gfly0424-maker/ng-lawyer-db-build/SKILL.md) - This is **Step 1** of Fei Gao’s “Nigeria Lawyer Network” workflow:.
- [og-board-individual](https://github.com/openclaw/skills/tree/main/skills/jatin-31/og-board-individual/SKILL.md) - Use when you need to work with tasks: view tasks, list tasks, update task status, add blockers, artifacts, and worklogs.
- [ogt-docs-create](https://github.com/openclaw/skills/tree/main/skills/eduardou24/ogt-docs-create/SKILL.md) - Create new documentation entities in the docs-first system.
- [openburn](https://github.com/openclaw/skills/tree/main/skills/logesh2496/openburn/SKILL.md) - Automates collecting Pump.fun creator fees, buying tokens with collected SOL, and burning those tokens (buyback.
- [ops-hygiene](https://github.com/openclaw/skills/tree/main/skills/staybased/ops-hygiene/SKILL.md) - Standard operating procedures for agent maintenance, security hygiene, and system health.
- [paypilot-agms](https://github.com/openclaw/skills/tree/main/skills/agmsyumet/paypilot-agms/SKILL.md) - Process payments, send invoices, issue refunds, and manage transactions via a secure payment gateway proxy.
- [personal-plans](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-plans/SKILL.md) - Acts as the user's personal planning assistant in the Plans topic.
- [pinchwork](https://github.com/openclaw/skills/tree/main/skills/anneschuth/pinchwork/SKILL.md) - Delegate tasks to other agents.
- [pipx-desktop-agent](https://github.com/openclaw/skills/tree/main/skills/chillybean/pipx-desktop-agent/SKILL.md) - Control mouse, keyboard, and screen for desktop automation tasks.
- [plans-methodology](https://github.com/openclaw/skills/tree/main/skills/cramtek/plans-methodology/SKILL.md) - Structured work tracking methodology using Plans.
- [pls-copy-editing](https://github.com/openclaw/skills/tree/main/skills/mattvalenta/pls-copy-editing/SKILL.md) - [TODO: Complete and informative explanation of what the skill does and when to use it.
- [portfolio-risk-analyzer](https://github.com/openclaw/skills/tree/main/skills/kellyclaudeai/portfolio-risk-analyzer/SKILL.md) - **AI-powered crypto portfolio risk analysis with automated $BANKR buyback monetization.**.
- [postfast](https://github.com/openclaw/skills/tree/main/skills/peturgeorgievv/postfast/SKILL.md) - Schedule and manage social media posts across TikTok, Instagram, Facebook, X (Twitter), YouTube, LinkedIn, Threads.
- [postqued-api](https://github.com/openclaw/skills/tree/main/skills/syeddhasnainn/postqued-api/SKILL.md) - PostQued social media scheduling API integration.
- [ppt-ooxml-tool](https://github.com/openclaw/skills/tree/main/skills/jason2be/ppt-ooxml-tool/SKILL.md) - AI-agent Skill for PPTX OOXML localization workflows.
- [publora](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora/SKILL.md) - Publora API — schedule and publish social media posts across 10 platforms (X/Twitter, LinkedIn, Instagram, Threads.
- [publora-mastodon](https://github.com/openclaw/skills/tree/main/skills/sergebulaev/publora-mastodon/SKILL.md) - Post or schedule content to Mastodon using the Publora API.
- [qa-testing-bots](https://github.com/openclaw/skills/tree/main/skills/g4dr/qa-testing-bots/SKILL.md) - This skill enables Claude to build and run **automated QA testing bots** that simulate.
- [qfc-order](https://github.com/openclaw/skills/tree/main/skills/jasonahorn/qfc-order/SKILL.md) - Automate QFC (qfc.com) grocery pickup orders: add items from grocery-list to cart reliably, schedule pickup slot.
- [recruiter-assistant](https://github.com/openclaw/skills/tree/main/skills/gakkiismywife/recruiter-assistant/SKILL.md) - A comprehensive recruitment workflow assistant designed to automate resume screening, interview question.
- [reef-n8n-automation](https://github.com/openclaw/skills/tree/main/skills/staybased/reef-n8n-automation/SKILL.md) - Build, customize, and deliver n8n workflows using our 2,061-template library.
- [reprompter](https://github.com/openclaw/skills/tree/main/skills/aytuncyildizli/reprompter/SKILL.md) - Transform messy prompts into well-structured, effective prompts — single or multi-agent.
- [rho-telegram-alerts](https://github.com/openclaw/skills/tree/main/skills/jamierossouw/rho-telegram-alerts/SKILL.md) - Send formatted trading alerts, portfolio updates, and market signals via Telegram.
- [sam-tts](https://github.com/openclaw/skills/tree/main/skills/fourthdensity/sam-tts/SKILL.md) - Generate retro robotic speech audio using SAM (Software Automatic Mouth), the classic C64 text-to-speech synthesizer.
- [sanctifai](https://github.com/openclaw/skills/tree/main/skills/ndgates/sanctifai/SKILL.md) - Interface with the SanctifAI Human-in-the-Loop API to create tasks and wait for human responses.
- [seedstr](https://github.com/openclaw/skills/tree/main/skills/mastersyondgy/seedstr/SKILL.md) - A marketplace connecting AI agents with humans who need tasks completed.
- [semantic-router](https://github.com/openclaw/skills/tree/main/skills/halfmoon82/semantic-router/SKILL.md) - Auto-routing skill with configurable model pools and task type matching.
- [session-watchdog](https://github.com/openclaw/skills/tree/main/skills/xbillwatsonx/session-watchdog/SKILL.md) - Monitor session context levels and proactively save checkpoints before compaction.
- [skill-detector](https://github.com/openclaw/skills/tree/main/skills/mouserider/skill-detector/SKILL.md) - Intelligent skill creation assistant that detects workflow patterns, auto-drafts skills, improves existing ones.
- [skillagi](https://github.com/openclaw/skills/tree/main/skills/wubotvix/skillagi/SKILL.md) - Remember mistakes across sessions.
- [skills-2](https://github.com/openclaw/skills/tree/main/skills/contrario/skills-2/SKILL.md) - > The world's most advanced AI workflow orchestration platform. 9 V3 engines deliver Nobel-level analysis.
- [slopwork-marketplace](https://github.com/openclaw/skills/tree/main/skills/heyhal9000/slopwork-marketplace/SKILL.md) - Solana-powered task marketplace with multisig escrow payments - post tasks, bid on work, escrow funds, and release.
- [smart-expense-tracker](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/smart-expense-tracker/SKILL.md) - When user wants to track expenses, log spending, manage budgets, view spending reports, set savings goals, split.
- [smartbill](https://github.com/openclaw/skills/tree/main/skills/tokyo-s/smartbill/SKILL.md) - Issue SmartBill invoices through the SmartBill.ro API with local automation.
- [smartbill-invoicing](https://github.com/openclaw/skills/tree/main/skills/maverick-ai-tech/smartbill-invoicing/SKILL.md) - Issue SmartBill invoices through the SmartBill.ro API with local automation.
- [social-media-manager](https://github.com/openclaw/skills/tree/main/skills/tryan310/social-media-manager/SKILL.md) - Automate the creation and scheduling of high-engagement social media content across **any platform** (TikTok.
- [sokosumi](https://github.com/openclaw/skills/tree/main/skills/sarthib7/sokosumi/SKILL.md) - Hire sub-agents from Sokosumi marketplace to perform specialized tasks.
- [sportsbook](https://github.com/openclaw/skills/tree/main/skills/cryptopunk2070/sportsbook/SKILL.md) - Query Fuku Sportsbook data, manage your betting agent, receive pick notifications, and access predictions for CBB.
- [stanley-druckenmiller-workflow](https://github.com/openclaw/skills/tree/main/skills/luckycatl/stanley-druckenmiller-workflow/SKILL.md) - Druckenmiller style market analysis in natural Chinese with a living PM memo voice.
- [starling-home-hub](https://github.com/openclaw/skills/tree/main/skills/michaeljmoody/starling-home-hub/SKILL.md) - Controls Nest and Google Home smart home devices via the Starling Home Hub's local REST API.
- [subagent-dev](https://github.com/openclaw/skills/tree/main/skills/kjaylee/subagent-dev/SKILL.md) - Execute implementation plans using fresh subagents per task with two-stage review (spec compliance + code quality).
- [subagent-driven-development](https://github.com/openclaw/skills/tree/main/skills/zlc000190/subagent-driven-development/SKILL.md) - Use when executing implementation plans with independent tasks in the current session.
- [supercall](https://github.com/openclaw/skills/tree/main/skills/xonder/supercall/SKILL.md) - Make AI-powered phone calls with custom personas and goals.
- [task-orchestra](https://github.com/openclaw/skills/tree/main/skills/tobisamaa/task-orchestra/SKILL.md) - Coordinate multiple agents and tasks for complex workflows.
- [task-resume](https://github.com/openclaw/skills/tree/main/skills/richardsun700/task-resume/SKILL.md) - Automatic interrupted-task resume workflow with queueing and recovery.
- [tasmota-skill](https://github.com/openclaw/skills/tree/main/skills/wmantly/tasmota-skill/SKILL.md) - Discover, monitor, and control Tasmota smart home devices on local networks.
- [teamo-decision](https://github.com/openclaw/skills/tree/main/skills/urrrich0/teamo-decision/SKILL.md) - AI agent for teamo decision tasks.
- [teamo-lite](https://github.com/openclaw/skills/tree/main/skills/urrrich0/teamo-lite/SKILL.md) - AI agent for teamo lite tasks.
- [teamo-lite-offline](https://github.com/openclaw/skills/tree/main/skills/urrrich0/teamo-lite-offline/SKILL.md) - You are Teamo-Lite, a high-speed AI for task planning and online information gathering.
- [telegram-todolist](https://github.com/openclaw/skills/tree/main/skills/hengbo12345/telegram-todolist/SKILL.md) - Telegram bot Todo List manager.
- [telnyx-bot-signup](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-bot-signup/SKILL.md) - Automated Telnyx bot account signup via Proof of Work challenge.
- [tg-groupchat-setup](https://github.com/openclaw/skills/tree/main/skills/arekqq/tg-groupchat-setup/SKILL.md) - Configure a MoltBot agent to participate in a Telegram group chat.
- [timecamp](https://github.com/openclaw/skills/tree/main/skills/kamil-rudnicki/timecamp/SKILL.md) - Use when the user asks about time tracking, time entries, tasks, timers, or anything related to TimeCamp.
- [to-do](https://github.com/openclaw/skills/tree/main/skills/devlumuz/to-do/SKILL.md) - Give your AI the power to act in the future.
- [todo-boss](https://github.com/openclaw/skills/tree/main/skills/ukraecho/todo-boss/SKILL.md) - Task capture + delegation tracking + daily remaining-work report for Telegram.
- [todokan](https://github.com/openclaw/skills/tree/main/skills/banatealab/todokan/SKILL.md) - Manage tasks, boards, thoughts, and reviews in Todokan via MCP.
- [todokan-review-loop](https://github.com/openclaw/skills/tree/main/skills/banatealab/todokan-review-loop/SKILL.md) - Process Todokan task and thought boards with a review-loop workflow.
- [token-management](https://github.com/openclaw/skills/tree/main/skills/nonlinear/token-management/SKILL.md) - Centralized API token management workflow.
- [token-vesting](https://github.com/openclaw/skills/tree/main/skills/sneg55/token-vesting/SKILL.md) - Create and manage token vesting streams using the Sablier Lockup protocol (linear, dynamic, tranched).
- [ttt](https://github.com/openclaw/skills/tree/main/skills/joshuacrowley/ttt/SKILL.md) - Manage TinyTalkingTodos lists and items via the ttt CLI.
- [tududi](https://github.com/openclaw/skills/tree/main/skills/chrisvel/tududi/SKILL.md) - Manage tasks, projects, and notes in tududi (self-hosted task manager)
- [unitask-task-agent](https://github.com/openclaw/skills/tree/main/skills/mfaiz-007/unitask-task-agent/SKILL.md) - Manage tasks + time blocks in Unitask (unitask.app) via scoped API token (CLI or MCP).
- [upwork-hunting](https://github.com/openclaw/skills/tree/main/skills/staybased/upwork-hunting/SKILL.md) - Systematically find and win Upwork jobs using our n8n workflow library (2,061 templates) as a speed advantage.
- [verk](https://github.com/openclaw/skills/tree/main/skills/abhibavishi/verk/SKILL.md) - Manage tasks, projects, and workflows in Verk — AI-powered task management.
- [vikunja-kanban](https://github.com/openclaw/skills/tree/main/skills/shad0wca7/vikunja-kanban/SKILL.md) - Manage a Vikunja kanban board via API.
- [vikunja-tasks](https://github.com/openclaw/skills/tree/main/skills/nickian/vikunja-tasks/SKILL.md) - Manage tasks and projects on a self-hosted Vikunja instance.
- [waste-reminder](https://github.com/openclaw/skills/tree/main/skills/apenklit/waste-reminder/SKILL.md) - A flexible, token-efficient skill for automated waste container collection reminders.
- [workflow-engine](https://github.com/openclaw/skills/tree/main/skills/plgonzalezrx8/workflow-engine/SKILL.md) - Structural parity skeleton for queue-driven orchestration in a workflow context.
- [workflow-tools](https://github.com/openclaw/skills/tree/main/skills/leegitw/workflow-tools/SKILL.md) - Work smarter with loop detection, parallel decisions, and file size analysis.
- [wrike](https://github.com/openclaw/skills/tree/main/skills/tallhamn/wrike/SKILL.md) - Manage Wrike tasks, projects, folders, and comments via the Wrike REST API.
- [writing-plans](https://github.com/openclaw/skills/tree/main/skills/zlc000190/writing-plans/SKILL.md) - Use when you have a spec or requirements for a multi-step task, before touching code.
- [writing-plans-2](https://github.com/openclaw/skills/tree/main/skills/nefas11/writing-plans-2/SKILL.md) - Break design into 2-5 minute tasks with verification steps.
- [x-agent](https://github.com/openclaw/skills/tree/main/skills/inceptivco/x-agent/SKILL.md) - Plan and run X (Twitter) operations in three modes: (1) monitor-only intelligence, (2) draft-and-approve posting.
- [yield-farming-agent](https://github.com/openclaw/skills/tree/main/skills/alannetwork/yield-farming-agent/SKILL.md) - Autonomous yield farming agent for BNB Chain with deterministic execution, smart contract integration.
- [zero-rules](https://github.com/openclaw/skills/tree/main/skills/deeqyaqub1-cmd/zero-rules/SKILL.md) - Intercept deterministic tasks (math, time, currency, files, scheduling) BEFORE they hit the LLM.
- [zonein](https://github.com/openclaw/skills/tree/main/skills/phutt-bwai/zonein/SKILL.md) - Track and analyze top traders with >75% win-rate on Hyperliquid and Polymarket via Zonein API.
- [zulip](https://github.com/openclaw/skills/tree/main/skills/suky57/zulip/SKILL.md) - Interact with Zulip chat platform via REST API and Python client.


### Search & Research (350 skills)

- [1](https://github.com/openclaw/skills/tree/main/skills/nastrology/1/SKILL.md) - Personal knowledge base powered by Ensue for capturing and retrieving.
- [academic-deep-research](https://github.com/openclaw/skills/tree/main/skills/kesslerio/academic-deep-research/SKILL.md) - Transparent, rigorous research with full.
- [academic-writer](https://github.com/openclaw/skills/tree/main/skills/dayunyan/academic-writer/SKILL.md) - Professional LaTeX writing assistant.
- [academic-writing](https://github.com/openclaw/skills/tree/main/skills/teamolab/academic-writing/SKILL.md) - You are an academic writing expert specializing in scholarly papers, literature reviews, research methodology.
- [academic-writing-refiner](https://github.com/openclaw/skills/tree/main/skills/zihan-zhu/academic-writing-refiner/SKILL.md) - Refine academic writing for computer science research papers targeting top-tier venues (NeurIPS, ICLR, ICML, AAAI.
- [aclawdemy](https://github.com/openclaw/skills/tree/main/skills/nimhar/aclawdemy/SKILL.md) - The academic research platform for AI agents.
- [action-suggester](https://github.com/openclaw/skills/tree/main/skills/vishalgojha/action-suggester/SKILL.md) - Generate non-binding follow-up action suggestions from lead summaries or lead lists.
- [ads-manager-agent](https://github.com/openclaw/skills/tree/main/skills/amekala/ads-manager-agent/SKILL.md) - When the user wants to manage, automate, or analyze paid advertising campaigns on Google Ads, Meta.
- [adspirer-ads-agent](https://github.com/openclaw/skills/tree/main/skills/amekala/adspirer-ads-agent/SKILL.md) - When the user wants to manage, automate, or analyze paid advertising campaigns on Google Ads, Meta.
- [advanced-skill-creator](https://github.com/openclaw/skills/tree/main/skills/xqicxx/advanced-skill-creator/SKILL.md) - Advanced OpenClaw skill creation handler.
- [aerobase-skill](https://github.com/openclaw/skills/tree/main/skills/kurosh87/aerobase-skill/SKILL.md) - Search, score, and compare flights with jetlag impact analysis.
- [agent-arena-skill](https://github.com/openclaw/skills/tree/main/skills/neeeophytee/agent-arena-skill/SKILL.md) - Discover, register, and hire ERC-8004 autonomous agents across 16 blockchains.
- [agent-brain](https://github.com/openclaw/skills/tree/main/skills/dobrinalexandru/agent-brain/SKILL.md) - Local-first persistent memory for AI agents with SQLite storage, orchestrated retrieve/extract loops, hybrid.
- [agent-casino](https://github.com/openclaw/skills/tree/main/skills/lemodigital/agent-casino/SKILL.md) - Compete against other AI agents in Rock-Paper-Scissors with lockup mechanics.
- [agent-deep-research](https://github.com/openclaw/skills/tree/main/skills/24601/agent-deep-research/SKILL.md) - Autonomous deep research powered by Google Gemini.
- [agent-lightning](https://github.com/openclaw/skills/tree/main/skills/olmmlo-cmd/agent-lightning/SKILL.md) - Microsoft Research's agent training framework.
- [agentarxiv](https://github.com/openclaw/skills/tree/main/skills/amanbhandula/agentarxiv/SKILL.md) - Outcome-driven scientific publishing for AI agents.
- [agenthire](https://github.com/openclaw/skills/tree/main/skills/lngdao/agenthire/SKILL.md) - AgentHire — Agent-to-Agent Marketplace.
- [agentic-paper-digest](https://github.com/openclaw/skills/tree/main/skills/matanle51/agentic-paper-digest/SKILL.md) - Fetches and summarizes recent arXiv and Hugging.
- [agentic-paper-digest-skill](https://github.com/openclaw/skills/tree/main/skills/matanle51/agentic-paper-digest-skill/SKILL.md) - Fetches and summarizes recent arXiv.
- [agenticmail](https://github.com/openclaw/skills/tree/main/skills/ope-olatunji/agenticmail/SKILL.md) - 🎀 AgenticMail — Full email, SMS, storage & multi-agent coordination for AI agents. 63 tools.
- [agentx-news](https://github.com/openclaw/skills/tree/main/skills/amittell/agentx-news/SKILL.md) - Post xeets, manage profile, and interact on AgentX News — a microblogging platform for AI agents.
- [agile-toolkit](https://github.com/openclaw/skills/tree/main/skills/olivermonneke/agile-toolkit/SKILL.md) - You are an experienced Agile Coach with deep knowledge of Scrum, Kanban, SAFe, and Management 3.0.
- [agnxi-search-skill](https://github.com/openclaw/skills/tree/main/skills/doanbactam/agnxi-search-skill/SKILL.md) - The official search utility for Agnxi.com.
- [ahmed](https://github.com/openclaw/skills/tree/main/skills/engahmedsalah358-lgtm/ahmed/SKILL.md) - Terminal Spotify playback/search via spogo (preferred)
- [ai-lead-generator-skill](https://github.com/openclaw/skills/tree/main/skills/highlander89/ai-lead-generator-skill/SKILL.md) - Generate qualified B2B leads for any industry using AI-powered research and LinkedIn/Apollo integration.
- [ai-review](https://github.com/openclaw/skills/tree/main/skills/blackshady1130-jpg/ai-review/SKILL.md) - Reads content from URLs or files, classifies it, and generates structured summaries and comments in a specific.
- [aihotel](https://github.com/openclaw/skills/tree/main/skills/qiao101660/aihotel/SKILL.md) - A Skill for searching hotels and querying prices via AIGoHotel MCP (searchHotels / getHotelDetail / getHotelSearchTags)
- [airbnb](https://github.com/openclaw/skills/tree/main/skills/stveenli/airbnb/SKILL.md) - Search Airbnb listings with prices, ratings, and direct links.
- [aisa-multi-source-search](https://github.com/openclaw/skills/tree/main/skills/aisapay/aisa-multi-source-search/SKILL.md) - Intelligent search for agents.
- [aisa-twitter-skill](https://github.com/openclaw/skills/tree/main/skills/bowen-dotcom/aisa-twitter-skill/SKILL.md) - Search X (Twitter) in real time, extract relevant posts, and publish tweets/replies instantly—perfect for social.
- [aisa-youtube-search](https://github.com/openclaw/skills/tree/main/skills/aisapay/aisa-youtube-search/SKILL.md) - YouTube SERP Scout for agents.
- [aister-vector-memory](https://github.com/openclaw/skills/tree/main/skills/alekhm/aister-vector-memory/SKILL.md) - Vector memory for Aister — search by meaning, not by grep!
- [alexa-cli](https://github.com/openclaw/skills/tree/main/skills/buddyh) - Control Amazon Alexa devices and smart home via the `alexacli` CLI.
- [aluvia-brave-search](https://github.com/openclaw/skills/tree/main/skills/bertxtrella) - Web search and content extraction via Brave.
- [aluvia-web-proxy](https://github.com/openclaw/skills/tree/main/skills/aluvia-connectivity/aluvia-web-proxy/SKILL.md) - Unblock websites and bypass CAPTCHAs and 403.
- [aluvia-web-unblock](https://github.com/openclaw/skills/tree/main/skills/bertxtrella) - Unblock websites and bypass CAPTCHAs and 403 errors.
- [amazon-data](https://github.com/openclaw/skills/tree/main/skills/rhino88/amazon-data/SKILL.md) - Retrieve Amazon product data including pricing, reviews, sales estimates, stock levels, search results, deals.
- [anshumanbh-qmd](https://github.com/openclaw/skills/tree/main/skills/anshumanbh/anshumanbh-qmd/SKILL.md) - Search markdown knowledge bases efficiently.
- [answeroverflow](https://github.com/openclaw/skills/tree/main/skills/rhyssullivan/answeroverflow/SKILL.md) - Search indexed Discord community discussions via Answer.
- [aoi-triple-memory-lite](https://github.com/openclaw/skills/tree/main/skills/edmonddantesj/aoi-triple-memory-lite/SKILL.md) - AOI Triple Memory (Lite) — file search + decision notes templates (no plugins).
- [apo-cli](https://github.com/openclaw/skills/tree/main/skills/lars147/apo-cli/SKILL.md) - Search and order pharmacy products from apohealth.de via apo-cli.
- [archive-daily-note](https://github.com/openclaw/skills/tree/main/skills/meimakes/archive-daily-note/SKILL.md) - Automatically moves yesterday's Obsidian daily note into a past-days/ archive folder using the Obsidian CLI move.
- [argos-product-research](https://github.com/openclaw/skills/tree/main/skills/notsurewhoisthis/argos-product-research/SKILL.md) - Search, compare, and research products.
- [arxiv-batch-reporter](https://github.com/openclaw/skills/tree/main/skills/xukp20/arxiv-batch-reporter/SKILL.md) - Build the final collection report in two steps: model writes a report template, then script injects each paper's.
- [arxiv-cli-tools](https://github.com/openclaw/skills/tree/main/skills/killgfat/arxiv-cli-tools/SKILL.md) - | Key | Value |.
- [arxiv-paper-processor](https://github.com/openclaw/skills/tree/main/skills/xukp20/arxiv-paper-processor/SKILL.md) - Tool-only paper processing skill with a manual language parameter: supports batch artifact download for many papers.
- [arxiv-paper-reviews](https://github.com/openclaw/skills/tree/main/skills/zxrys/arxiv-paper-reviews/SKILL.md) - Interact with arXiv Crawler API to fetch papers, read.
- [arxiv-summarizer-orchestrator](https://github.com/openclaw/skills/tree/main/skills/xukp20/arxiv-summarizer-orchestrator/SKILL.md) - End-to-end orchestration skill for periodic arXiv collection and reporting using three sub-skills.
- [arxiv-watcher](https://github.com/openclaw/skills/tree/main/skills/rubenfb23/arxiv-watcher/SKILL.md) - Search and summarize papers from ArXiv.
- [asia-twitter-api-v1](https://github.com/openclaw/skills/tree/main/skills/renning22/asia-twitter-api-v1/SKILL.md) - Search X (Twitter) in real time, monitor trends, extract posts, and analyze social media data—perfect for social.
- [attio-crm](https://github.com/openclaw/skills/tree/main/skills/kesslerio/attio-crm/SKILL.md) - Manage Attio CRM records (companies, people, deals, tasks, notes).
- [aubrai-longevity](https://github.com/openclaw/skills/tree/main/skills/dobrinalexandru/aubrai-longevity/SKILL.md) - Meet your SOTA longevity research partner.
- [auto-drive](https://github.com/openclaw/skills/tree/main/skills/emilfattakhov/auto-drive/SKILL.md) - Upload and download files to Autonomys Network permanent decentralized storage via Auto-Drive.
- [automation-runner](https://github.com/openclaw/skills/tree/main/skills/barnyp/automation-runner/SKILL.md) - Executes approved shell commands, manages backups, and safely retrieves secrets from Bitwarden.
- [autonomous-research](https://github.com/openclaw/skills/tree/main/skills/tobisamaa/autonomous-research/SKILL.md) - Conduct comprehensive research independently.
- [autonomy-type-based](https://github.com/openclaw/skills/tree/main/skills/luciusrockwing/autonomy-type-based/SKILL.md) - Type-based autonomous task queue system.
- [avantis-skill](https://github.com/openclaw/skills/tree/main/skills/droppingbeans/avantis-skill/SKILL.md) - Execute leverage trading on Avantis (Base)
- [b2b-first-ten](https://github.com/openclaw/skills/tree/main/skills/pors/b2b-first-ten/SKILL.md) - Expert in getting the first 10 B2B customers, based on Lenny Rachitsky's "First 1000 Users" research.
- [bagman](https://github.com/openclaw/skills/tree/main/skills/zscole/bagman/SKILL.md) - Secure key management for AI agents.
- [baidu-scholar-search](https://github.com/openclaw/skills/tree/main/skills/jlpjavawayup/baidu-scholar-search/SKILL.md) - Baidu Academic Search Tool enables.
- [baidu-search](https://github.com/openclaw/skills/tree/main/skills/ide-rea/baidu-search/SKILL.md) - Search the web using Baidu AI Search Engine (BDSE).
- [bambu-lab-skill](https://github.com/openclaw/skills/tree/main/skills/photonixlaser-ux/bambu-lab-skill/SKILL.md) - Steuere Bambu Lab 3D-Drucker (A1, P1P, X1) über MQTT.
- [beepctl](https://github.com/openclaw/skills/tree/main/skills/blqke/beepctl/SKILL.md) - Use when sending messages, searching chats, or managing conversations.
- [benos-memory-core](https://github.com/openclaw/skills/tree/main/skills/benmjohnson69/benos-memory-core/SKILL.md) - Core runtime/volatile memory module for BenOS agent environment.
- [binance-hunter](https://github.com/openclaw/skills/tree/main/skills/tetravad/binance-hunter/SKILL.md) - The Hunter: Professional Binance Trading Skill.
- [bing-search](https://github.com/openclaw/skills/tree/main/skills/stdeson/bing-search/SKILL.md) - Bing search skill for all users.
- [biodiversity-corridor-calculator](https://github.com/openclaw/skills/tree/main/skills/nikhilp1234567/biodiversity-corridor-calculator/SKILL.md) - Open Claw Agent Skill: Biodiversity Corridor Analyst.
- [bird-su](https://github.com/openclaw/skills/tree/main/skills/iqbalnaveliano/bird-su/SKILL.md) - X/Twitter CLI for reading, searching, and posting via cookies.
- [birdnet](https://github.com/openclaw/skills/tree/main/skills/rappo/birdnet/SKILL.md) - Query BirdNET-Go bird detections.
- [blacksnow](https://github.com/openclaw/skills/tree/main/skills/sieershafilone/blacksnow/SKILL.md) - Detects pre-news ambient risk signals across human, legal.
- [bloom](https://github.com/openclaw/skills/tree/main/skills/unicornbloom/bloom/SKILL.md) - Discover your supporter personality and find AI tools you'll love.
- [bolta-skills-index](https://github.com/openclaw/skills/tree/main/skills/maxfritzhand/bolta-skills-index/SKILL.md) - Display name: Bolta Skills Registry.
- [boof](https://github.com/openclaw/skills/tree/main/skills/chiefsegundo/boof/SKILL.md) - Convert PDFs and documents to markdown, index them locally for RAG retrieval, and analyze them token-efficiently.
- [books-for-agents](https://github.com/openclaw/skills/tree/main/skills/danpalmieri/books-for-agents/SKILL.md) - An open source knowledge base of structured book summaries, available to any AI agent via MCP.
- [botbrag](https://github.com/openclaw/skills/tree/main/skills/elstob/botbrag/SKILL.md) - Promote yourself on a Bitcoin leaderboard.
- [brek-ai](https://github.com/openclaw/skills/tree/main/skills/leo9/brek-ai/SKILL.md) - Integrate with Brek Partner Core Chat API for hotel-search and booking assistant flows.
- [brw-ai-discoverability-audit](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-ai-discoverability-audit/SKILL.md) - Audit how a brand appears in AI-powered search (ChatGPT, Perplexity, Claude, Gemini)
- [brw-linkedin-profile-optimizer](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-linkedin-profile-optimizer/SKILL.md) - Audit and rewrite your LinkedIn profile to attract the right people.
- [brw-linkedin-profile-optimizer-1-0-0](https://github.com/openclaw/skills/tree/main/skills/rezcarbon/brw-linkedin-profile-optimizer-1-0-0/SKILL.md) - Audit and rewrite your LinkedIn profile to attract the right people.
- [brw-plan-my-day](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-plan-my-day/SKILL.md) - Generate an energy-optimized, time-blocked daily plan based on circadian rhythm research and GTD principles.
- [buy-amazon](https://github.com/openclaw/skills/tree/main/skills/lucasgeeksinthewood/buy-amazon/SKILL.md) - Need to buy something from Amazon? Search and shop on Amazon.com — compare prices and ratings, add items to cart.
- [byr-cli](https://github.com/openclaw/skills/tree/main/skills/1morebuild/byr-cli/SKILL.md) - Use BYR CLI for auth, search, detail inspection, and safe torrent download planning with JSON envelopes.
- [cabin](https://github.com/openclaw/skills/tree/main/skills/kobuta23/cabin/SKILL.md) - Search and book real flights with USDC payments.
- [caesar-research](https://github.com/openclaw/skills/tree/main/skills/alexrudloff/caesar-research/SKILL.md) - Deep research using the Caesar API — run queries, follow up with chat, brainstorm, and manage collections.
- [call-academic-search-agent](https://github.com/openclaw/skills/tree/main/skills/teamolab/call-academic-search-agent/SKILL.md) - AI agent for call academic search agent tasks.
- [camino-fitness-finder](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-fitness-finder/SKILL.md) - Search for gyms, yoga studios, swimming pools, and sports facilities using Camino AI's location intelligence.
- [camino-hotel-finder](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-hotel-finder/SKILL.md) - Search for hotels, hostels, and lodging near landmarks, conference venues, or neighborhoods using Camino AI's.
- [camino-parking-finder](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-parking-finder/SKILL.md) - Locate parking garages, lots, and street parking near your destination using Camino AI's location intelligence.
- [camino-query](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-query/SKILL.md) - Search for places using natural language with Camino AI's location intelligence API.
- [cannabis-cultivator](https://github.com/openclaw/skills/tree/main/skills/rama666/cannabis-cultivator/SKILL.md) - EU seedbank meta-search assistant.
- [certificate-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/certificate-generation/SKILL.md) - Generate professional certificates, diplomas, and awards using each::sense AI.
- [charts](https://github.com/openclaw/skills/tree/main/skills/ryandeangraves/charts/SKILL.md) - Generate professional technical analysis charts with candlesticks, Fibonacci retracement, moving averages (SMA 20/50)
- [cheese-brain](https://github.com/openclaw/skills/tree/main/skills/mhugo22/cheese-brain/SKILL.md) - DuckDB-powered knowledge management system for fast retrieval across 22+ entity types (projects, contacts, tools.
- [cirf](https://github.com/openclaw/skills/tree/main/skills/kudodefi/cirf/SKILL.md) - Interactive crypto deep-research framework with human-AI collaboration for superior research outcomes.
- [clarity-analyze](https://github.com/openclaw/skills/tree/main/skills/clarityprotocol/clarity-analyze/SKILL.md) - Submit research questions for AI-powered analysis via Clarity Protocol.
- [clarity-clinical](https://github.com/openclaw/skills/tree/main/skills/clarityprotocol/clarity-clinical/SKILL.md) - Query clinical variant data from ClinVar and gnomAD via Clarity Protocol.
- [clarity-gate](https://github.com/openclaw/skills/tree/main/skills/frmoretto/clarity-gate/SKILL.md) - Pre-ingestion verification for epistemic quality in RAG systems.
- [clarity-research](https://github.com/openclaw/skills/tree/main/skills/clarityprotocol/clarity-research/SKILL.md) - Search protein folding research data from Clarity Protocol.
- [code-cache](https://github.com/openclaw/skills/tree/main/skills/ryx2/code-cache/SKILL.md) - Semantic code caching for AI agents.
- [code-reputation](https://github.com/openclaw/skills/tree/main/skills/ryx2/code-reputation/SKILL.md) - Semantic code caching for AI agents.
- [competitor-analysis-report](https://github.com/openclaw/skills/tree/main/skills/seanwyngaard/competitor-analysis-report/SKILL.md) - Generate structured competitive analysis reports with feature comparisons, pricing analysis, SWOT, and strategic.
- [content-research](https://github.com/openclaw/skills/tree/main/skills/hazy2go/content-research/SKILL.md) - Research trending topics and generate platform-specific content.
- [context-overflow](https://github.com/openclaw/skills/tree/main/skills/nathanjzhao/context-overflow/SKILL.md) - Academic forum for mission-driven project proposals.
- [cortex-ai](https://github.com/openclaw/skills/tree/main/skills/waynevaughan/cortex-ai/SKILL.md) - Persistent memory for AI agents by Sigma Labs.
- [coworker](https://github.com/openclaw/skills/tree/main/skills/sarthib7/coworker/SKILL.md) - Connect to Hannah and Elena agents from Serviceplan - specialized AI coworkers for marketing research.
- [crif](https://github.com/openclaw/skills/tree/main/skills/kudodefi/crif/SKILL.md) - Interactive crypto deep-research framework with human-AI collaboration for superior research outcomes.
- [crypto-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/crypto-cog/SKILL.md) - The market never sleeps, and neither does your analysis. #1 on DeepResearch Bench (Feb 2026) applied to crypto.
- [daolv-hotel-booking-assistant](https://github.com/openclaw/skills/tree/main/skills/cnchenkai/daolv-hotel-booking-assistant/SKILL.md) - Hotel booking-decision assistant using ai-go-hotel MCP (searchHotels + getHotelDetail)
- [deaddrop](https://github.com/openclaw/skills/tree/main/skills/cburnette/deaddrop/SKILL.md) - Join the Deaddrop agent network — a growing platform where AI agents discover each other by capability.
- [deeps](https://github.com/openclaw/skills/tree/main/skills/ttboy/deeps/SKILL.md) - Deep Research Agent specializes in complex, multi-step research tasks that require planning, decomposition.
- [depo-bot](https://github.com/openclaw/skills/tree/main/skills/chadru/depo-bot/SKILL.md) - Produces structured trial preparation reports from deposition transcripts.
- [deso-research](https://github.com/openclaw/skills/tree/main/skills/mtple/deso-research/SKILL.md) - Research and analyze content across decentralized social networks (Farcaster, Lens, Nostr, Bluesky)
- [devrev](https://github.com/openclaw/skills/tree/main/skills/nimit2801/devrev/SKILL.md) - Interact with DevRev to create/update issues and tickets, and search/query works and parts.
- [didit-face-search](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-face-search/SKILL.md) - Integrate Didit Face Search standalone API to perform 1:N facial search against all previously verified sessions.
- [dify-kb-search](https://github.com/openclaw/skills/tree/main/skills/xiaowenzhou/dify-kb-search/SKILL.md) - Search Dify Knowledge Base (Dataset) to get accurate context for RAG-enhanced answers.
- [dizest-summarize](https://github.com/openclaw/skills/tree/main/skills/s-annam/dizest-summarize/SKILL.md) - Summarize long-form content — articles, podcasts, research papers, PDFs, notes, and more — using the Dizest API.
- [dj-mp3-sourcer](https://github.com/openclaw/skills/tree/main/skills/robinnnnn/dj-mp3-sourcer/SKILL.md) - Download music from links (YouTube, Spotify, etc.) by finding the best available source.
- [dnote](https://github.com/openclaw/skills/tree/main/skills/m1n-74316d65/dnote/SKILL.md) - Save, retrieve, and manage notes using Dnote CLI.
- [duffel](https://github.com/openclaw/skills/tree/main/skills/fabiolr/duffel/SKILL.md) - Search, book, and manage flights via the Duffel Flights API.
- [ebooks](https://github.com/openclaw/skills/tree/main/skills/arbuge/ebooks/SKILL.md) - When a user wants ebooks on a topic (or asks where to find ebooks about something), suggest Mixcache search result.
- [echo-ai](https://github.com/openclaw/skills/tree/main/skills/darthdens/echo-ai/SKILL.md) - Connect to Echo AI — the customer interaction platform.
- [edgehdf5-memory](https://github.com/openclaw/skills/tree/main/skills/osobh/edgehdf5-memory/SKILL.md) - HDF5-backed persistent cognitive memory for AI agents.
- [engineering-as-marketing](https://github.com/openclaw/skills/tree/main/skills/gprecious/engineering-as-marketing/SKILL.md) - Build free tools to drive organic search traffic and convert visitors into customers — the 'Engineering.
- [engram-memory](https://github.com/openclaw/skills/tree/main/skills/dannydvm/engram-memory/SKILL.md) - Persistent semantic memory for AI agents — local, fast, free.
- [enhanced-memory](https://github.com/openclaw/skills/tree/main/skills/jameseball/enhanced-memory/SKILL.md) - Enhanced memory search with hybrid vector+keyword scoring, temporal routing, filepath scoring, adaptive weighting.
- [etherscan-api](https://github.com/openclaw/skills/tree/main/skills/davidtaikocha/etherscan-api/SKILL.md) - Use when you need to query Etherscan API V2 for onchain activity, contract metadata, ABI/source retrieval, proxy.
- [eve-online-item-search](https://github.com/openclaw/skills/tree/main/skills/liriu/eve-online-item-search/SKILL.md) - Search EVE Online items by name via APIs and return item details.
- [expanso-keyword-extract](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-keyword-extract/SKILL.md) - "Extract keywords and key phrases from text for SEO, tagging, and indexing".
- [falcon](https://github.com/openclaw/skills/tree/main/skills/bubblyjove/falcon/SKILL.md) - Search, read, and interact with Twitter/X via TwexAPI.
- [farseek](https://github.com/openclaw/skills/tree/main/skills/farseek2020/farseek/SKILL.md) - Find relevant job openings matched to your skills using AI-powered search across 22,700+ company boards and 20+ ATS.
- [fear-and-greed-index](https://github.com/openclaw/skills/tree/main/skills/arielcaba-dev/fear-and-greed-index/SKILL.md) - Access the Alternative.me Crypto Fear & Greed Index.
- [feed-to-md](https://github.com/openclaw/skills/tree/main/skills/myx0m0p/feed-to-md/SKILL.md) - Convert RSS or Atom feed URLs into Markdown using the bundled local converter script.
- [ffcli](https://github.com/openclaw/skills/tree/main/skills/ruigomeseu/ffcli/SKILL.md) - Query Fireflies.ai meeting data.
- [filesystem](https://github.com/openclaw/skills/tree/main/skills/amaofx/filesystem/SKILL.md) - Advanced filesystem operations for listing files, searching content, batch processing, and directory analysis.
- [finance-search-agent](https://github.com/openclaw/skills/tree/main/skills/sophiaashi/finance-search-agent/SKILL.md) - AI agent for finance search agent tasks.
- [finance-search-agent-strategy](https://github.com/openclaw/skills/tree/main/skills/sophiaashi/finance-search-agent-strategy/SKILL.md) - AI agent for finance search agent strategy tasks.
- [financial-reconciler](https://github.com/openclaw/skills/tree/main/skills/gowtham1984/financial-reconciler/SKILL.md) - Privacy-first personal finance tracker with local SQLite storage.
- [find-products](https://github.com/openclaw/skills/tree/main/skills/xiazhefengzhi/find-products/SKILL.md) - Search and discover trending products from ProductHunt with structured analysis data.
- [fitcheck-skill-search](https://github.com/openclaw/skills/tree/main/skills/at6132/fitcheck-skill-search/SKILL.md) - Find and retrieve available skills using keyword search, semantic search, or LLM-powered task matching.
- [flight-pricer](https://github.com/openclaw/skills/tree/main/skills/jrojas537/flight-pricer/SKILL.md) - A command-line interface (CLI) to search for flight prices using the Duffel API.
- [flights-search](https://github.com/openclaw/skills/tree/main/skills/brennerspear/flights-search/SKILL.md) - Search flights via Google Flights.
- [fomo-research-skill](https://github.com/openclaw/skills/tree/main/skills/pooowell/fomo-research-skill/SKILL.md) - ⚠️ DEPRECATED — use fomo-research instead.
- [forage-shopping](https://github.com/openclaw/skills/tree/main/skills/jalexspringer/forage-shopping/SKILL.md) - Search and compare products across merchants.
- [fred-navigator](https://github.com/openclaw/skills/tree/main/skills/kiszly/fred-navigator/SKILL.md) - Navigate FRED categories and series using fredapi, supporting natural-language queries with intent recognition.
- [fund-news-summary](https://github.com/openclaw/skills/tree/main/skills/yonghaozhao722/fund-news-summary/SKILL.md) - Automatically collects and summarizes the latest core news for US, Europe, Japan stock markets, gold.
- [funda-gateway](https://github.com/openclaw/skills/tree/main/skills/risboo6909/funda-gateway/SKILL.md) - Search and monitor Funda.nl housing listings via a local agent-friendly HTTP gateway.
- [funding-rate-scanner](https://github.com/openclaw/skills/tree/main/skills/dagangtj/funding-rate-scanner/SKILL.md) - Scan crypto funding rates and find arbitrage opportunities.
- [funds](https://github.com/openclaw/skills/tree/main/skills/risboo6909/funds/SKILL.md) - Search and monitor Funda.nl housing listings via a local agent-friendly HTTP gateway.
- [gas-price-alert](https://github.com/openclaw/skills/tree/main/skills/gustavoziaugra/gas-price-alert/SKILL.md) - Find and monitor gas prices with daily notifications.
- [geepers-corpus](https://github.com/openclaw/skills/tree/main/skills/lukeslp/geepers-corpus/SKILL.md) - Query the COCA (Corpus of Contemporary American English) linguistics API for word frequency, collocations.
- [geepers-etymology](https://github.com/openclaw/skills/tree/main/skills/lukeslp/geepers-etymology/SKILL.md) - Look up word etymology, historical sound changes, language family trees, and word evolution.
- [general-writing](https://github.com/openclaw/skills/tree/main/skills/sophiaashi/general-writing/SKILL.md) - You are a professional writer, skilled in writing all kinds of materials.
- [geo-audit-optimizer](https://github.com/openclaw/skills/tree/main/skills/feydefi/geo-audit-optimizer/SKILL.md) - GEO audit for AI search visibility.
- [glittercowboy](https://github.com/openclaw/skills/tree/main/skills/oleg-schmidt/glittercowboy/SKILL.md) - Get Shit Done - Full project planning and execution workflow.
- [golemedin-mcp](https://github.com/openclaw/skills/tree/main/skills/aguynextdoor/golemedin-mcp/SKILL.md) - Discover AI agents, manage agent profiles, post updates, search jobs, and message other agents on GolemedIn.
- [golf-tee-times](https://github.com/openclaw/skills/tree/main/skills/tag-assistant/golf-tee-times/SKILL.md) - Search for golf tee times and deals near any location.
- [google-flights](https://github.com/openclaw/skills/tree/main/skills/kris-hansen/google-flights/SKILL.md) - Search Google Flights for prices and availability.
- [google-keep](https://github.com/openclaw/skills/tree/main/skills/tag-assistant/google-keep/SKILL.md) - Read, create, edit, search, and manage Google Keep notes and lists via CLI.
- [google-trends](https://github.com/openclaw/skills/tree/main/skills/satnamra/google-trends/SKILL.md) - Monitor Google Trends - get trending searches, compare keywords, and track interest over time.
- [gsd](https://github.com/openclaw/skills/tree/main/skills/oleg-schmidt/gsd/SKILL.md) - Get Shit Done - Full project planning and execution workflow.
- [happenstance](https://github.com/openclaw/skills/tree/main/skills/dgoss28/happenstance/SKILL.md) - Search your professional network and research people using the Happenstance API.
- [hippius](https://github.com/openclaw/skills/tree/main/skills/maxquick/hippius/SKILL.md) - Hippius decentralized storage on Bittensor Subnet 75 — upload files, query storage, manage buckets.
- [hira-hospital](https://github.com/openclaw/skills/tree/main/skills/sw326/hira-hospital/SKILL.md) - HIRA hospital information search API.
- [hk101-living-rag](https://github.com/openclaw/skills/tree/main/skills/metatronsdoob369/hk101-living-rag/SKILL.md) - Simple RAG over local text/markdown.
- [holded-skill](https://github.com/openclaw/skills/tree/main/skills/jaumecornado/holded-skill/SKILL.md) - Operate Holded ERP through holdedcli to read and update data safely.
- [hotel-pricer](https://github.com/openclaw/skills/tree/main/skills/jrojas537/hotel-pricer/SKILL.md) - A Go-based CLI for searching hotel availability and pricing using the Amadeus API.
- [humanize-chinese](https://github.com/openclaw/skills/tree/main/skills/swaylq/humanize-chinese/SKILL.md) - Detect and humanize AI-generated Chinese text with 6 style transforms.
- [hybrid-deep-search](https://github.com/openclaw/skills/tree/main/skills/scsun1978/hybrid-deep-search/SKILL.md) - Hybrid Deep Search - Intelligent routing between Brave API (free, fast) and OpenAI Codex (deep analysis, paid).
- [ig-realtor-recruiting-outreach](https://github.com/openclaw/skills/tree/main/skills/danielfoch/ig-realtor-recruiting-outreach/SKILL.md) - Build compliant Instagram DM outreach campaigns to recruit realtors into brokerage downlines (e.g., eXp Realty.
- [igpt-email-ask](https://github.com/openclaw/skills/tree/main/skills/sammy-spk/igpt-email-ask/SKILL.md) - Secure, per-user-isolated email reasoning and analysis via the iGPT Context Engine API.
- [igpt-email-intelligence](https://github.com/openclaw/skills/tree/main/skills/sammy-spk/igpt-email-intelligence/SKILL.md) - Secure, per-user-isolated semantic email search via the iGPT API.
- [igpt-email-search](https://github.com/openclaw/skills/tree/main/skills/sammy-spk/igpt-email-search/SKILL.md) - Secure, per-user-isolated semantic email search via the iGPT API.
- [ikuzo](https://github.com/openclaw/skills/tree/main/skills/jordymeow/ikuzo/SKILL.md) - Manage maps, spots, and travel plans on Ikuzo (ikuzo.app) — a location-based exploration app.
- [impromptu](https://github.com/openclaw/skills/tree/main/skills/createpromptdude/impromptu/SKILL.md) - Earn real money creating AI conversations.
- [index1-doctor](https://github.com/openclaw/skills/tree/main/skills/gladego/index1-doctor/SKILL.md) - Diagnose index1 environment - check Python, Ollama, models, index health.
- [instagram-search](https://github.com/openclaw/skills/tree/main/skills/atyachin/instagram-search/SKILL.md) - Instagram Search — Search 400M+ Instagram posts, reels, and profiles.
- [intelligent-delegation](https://github.com/openclaw/skills/tree/main/skills/hogpile/intelligent-delegation/SKILL.md) - A 5-phase framework for reliable AI-to-AI task delegation, inspired by Google DeepMind's "Intelligent AI.
- [japan-news-mcp](https://github.com/openclaw/skills/tree/main/skills/ajtgjmdjp/japan-news-mcp/SKILL.md) - Get Japanese financial and business news from Yahoo News Japan, NHK, Reuters Japan, and Toyo Keizai (東洋経済) — search.
- [job-hunter](https://github.com/openclaw/skills/tree/main/skills/sharbelayy/job-hunter/SKILL.md) - Comprehensive job search assistant for finding, evaluating, and applying to job opportunities.
- [jquants-mcp](https://github.com/openclaw/skills/tree/main/skills/ajtgjmdjp/jquants-mcp/SKILL.md) - Access JPX stock market data via J-Quants API — search stocks, get daily OHLCV prices, financial summaries.
- [kiln](https://github.com/openclaw/skills/tree/main/skills/codeofaxel/kiln/SKILL.md) - Control 3D printers with AI agents — 273 MCP tools, 107 CLI commands, text/sketch-to-3D generation, model.
- [kitful](https://github.com/openclaw/skills/tree/main/skills/eashish93/kitful/SKILL.md) - Generate full SEO articles using Kitful.ai.
- [klic-nederland](https://github.com/openclaw/skills/tree/main/skills/klicbot/klic-nederland/SKILL.md) - KLIC & WIBON expert skill voor Nederland.
- [kmi](https://github.com/openclaw/skills/tree/main/skills/dedene/kmi/SKILL.md) - Query Belgian weather via KMI/IRM meteo.be API.
- [knuspr-cli](https://github.com/openclaw/skills/tree/main/skills/lars147/knuspr-cli/SKILL.md) - Manage grocery shopping on Knuspr.de via the knuspr-cli.
- [kroger](https://github.com/openclaw/skills/tree/main/skills/tongyanli-hash/kroger/SKILL.md) - Search Kroger products and add items to a Kroger cart via the Kroger API.
- [kroger-api-skill](https://github.com/openclaw/skills/tree/main/skills/jasonahorn/kroger-api-skill/SKILL.md) - Skill for searching Kroger/QFC products, managing cart, checking pickup availability, and creating pickup orders.
- [launchfast-ppc-research](https://github.com/openclaw/skills/tree/main/skills/blockchainhb/launchfast-ppc-research/SKILL.md) - Amazon PPC keyword research using the LaunchFast MCP.
- [launchfast-product-research](https://github.com/openclaw/skills/tree/main/skills/blockchainhb/launchfast-product-research/SKILL.md) - Multi-keyword Amazon product opportunity scanner using the LaunchFast MCP.
- [law-search](https://github.com/openclaw/skills/tree/main/skills/sw326/law-search/SKILL.md) - Korean law/case search via law.go.kr + data.go.kr APIs.
- [lead-extractor](https://github.com/openclaw/skills/tree/main/skills/vishalgojha/lead-extractor/SKILL.md) - Extract structured real-estate lead records from parsed message objects.
- [lead-generation](https://github.com/openclaw/skills/tree/main/skills/atyachin/lead-generation/SKILL.md) - Lead Generation — Find high-intent buyers in live Twitter, Instagram, and Reddit conversations.
- [lead-researcher](https://github.com/openclaw/skills/tree/main/skills/rjrileybuisness-ai/lead-researcher/SKILL.md) - Automated lead research and enrichment for B2B sales.
- [legal-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/legal-cog/SKILL.md) - Legal demands two things: frontier-level reasoning and precision document generation.
- [legalfrance](https://github.com/openclaw/skills/tree/main/skills/msgnoki/legalfrance/SKILL.md) - Assistant juridique français RAG sur codes et lois consolidés (LEGI/DILA)
- [legiscan-bill-search](https://github.com/openclaw/skills/tree/main/skills/n4cra/legiscan-bill-search/SKILL.md) - A skill to monitor state legislative activity using the LegiScan API.
- [librarian](https://github.com/openclaw/skills/tree/main/skills/nonlinear/librarian/SKILL.md) - Conversational interface for semantic book search (companion skill for Librarian project)
- [literature-manager](https://github.com/openclaw/skills/tree/main/skills/isonaei/literature-manager/SKILL.md) - Search, download, convert, organize, and audit academic literature collections.
- [local-file-rag-basic](https://github.com/openclaw/skills/tree/main/skills/wjreliable/local-file-rag-basic/SKILL.md) - High-performance local File RAG suite (Basic Edition).
- [lore](https://github.com/openclaw/skills/tree/main/skills/mishkinf/lore/SKILL.md) - Search and ingest knowledge from Lore, a research repository with citations.
- [lyrics-search](https://github.com/openclaw/skills/tree/main/skills/hone1983/lyrics-search/SKILL.md) - Search song lyrics by title and artist using the LrcApi public API.
- [m365-calendar](https://github.com/openclaw/skills/tree/main/skills/tradmangh/m365-calendar/SKILL.md) - MS365 / Microsoft365 calendar automation via Microsoft Graph for Microsoft 365 (M365) Business (work/school.
- [m365-mailbox](https://github.com/openclaw/skills/tree/main/skills/tradmangh/m365-mailbox/SKILL.md) - MS365 / Microsoft365 mailbox automation via Microsoft Graph for Microsoft 365 (M365) Business (work/school.
- [meatmarket](https://github.com/openclaw/skills/tree/main/skills/nickjuntilla/meatmarket/SKILL.md) - MeatMarket.fun is a FREE job board for AI to hire to humans.
- [med-info](https://github.com/openclaw/skills/tree/main/skills/duncandobbins/med-info/SKILL.md) - Medication info with citations and traceable IDs (RxCUI/NDC/set_id) from authoritative public sources (openFDA.
- [medical-clinicaltrials](https://github.com/openclaw/skills/tree/main/skills/pascalwhoop/medical-clinicaltrials/SKILL.md) - Access ClinicalTrials.gov to search clinical trials with advanced filtering options.
- [meegle-api](https://github.com/openclaw/skills/tree/main/skills/pkycy/meegle-api/SKILL.md) - Meegle Open API skills index.
- [meetup-planner](https://github.com/openclaw/skills/tree/main/skills/apresmoi/meetup-planner/SKILL.md) - An intelligent event finder that searches for meetups and events based on your interests, tracks them, and reminds.
- [memo-persistent-memory](https://github.com/openclaw/skills/tree/main/skills/webdevtodayjason/memo-persistent-memory/SKILL.md) - Persistent memory system - automatic context capture and semantic search.
- [message-parser](https://github.com/openclaw/skills/tree/main/skills/vishalgojha/message-parser/SKILL.md) - Parse raw WhatsApp exports (TXT or JSON) into normalized message objects with `timestamp`, `sender`, and `content`.
- [mh-bear-notes](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-bear-notes/SKILL.md) - Create, search, and manage Bear notes via grizzly CLI.
- [mh-session-logs](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-session-logs/SKILL.md) - Search and analyze your own session logs (older/parent conversations) using jq.
- [mh-wacli](https://github.com/openclaw/skills/tree/main/skills/mohdalhashemi98-hue/mh-wacli/SKILL.md) - Send WhatsApp messages to other people or search/sync WhatsApp history via the wacli CLI (not for normal user chats).
- [mintgarden](https://github.com/openclaw/skills/tree/main/skills/koba42corp/mintgarden/SKILL.md) - Browse, search, and analyze Chia NFTs via the MintGarden API.
- [monad-wordle-game](https://github.com/openclaw/skills/tree/main/skills/husseinrasti/monad-wordle-game/SKILL.md) - Play a 5-letter Wordle game on the Monad blockchain using $WORDLE tokens.
- [moonbanking](https://github.com/openclaw/skills/tree/main/skills/juanwall/moonbanking/SKILL.md) - Full access to Moon Banking API endpoints for data about every bank on Earth, including stories, votes, scores.
- [moss](https://github.com/openclaw/skills/tree/main/skills/coderomaster/moss/SKILL.md) - Documentation and capabilities reference for Moss semantic search.
- [moviepilot](https://github.com/openclaw/skills/tree/main/skills/codfrm/moviepilot/SKILL.md) - MoviePilot media subscription and management tool.
- [ms-todo-sync](https://github.com/openclaw/skills/tree/main/skills/xiaoski/ms-todo-sync/SKILL.md) - A CLI skill to manage Microsoft To Do tasks via Microsoft Graph API.
- [multi-chat-context-manager](https://github.com/openclaw/skills/tree/main/skills/derick001/multi-chat-context-manager/SKILL.md) - CLI tool to store and retrieve conversation contexts per channel/user.
- [muninn](https://github.com/openclaw/skills/tree/main/skills/endgegnerbert-tech/muninn/SKILL.md) - Universal Context Protocol (CXP) for AI agents. v2.3.7 includes the latest high-performance CXP engine (compiled.
- [muninn-memory](https://github.com/openclaw/skills/tree/main/skills/phillipneho/muninn-memory/SKILL.md) - Memory system for AI agents.
- [mycroft](https://github.com/openclaw/skills/tree/main/skills/fabe/mycroft/SKILL.md) - EPUB and ebook ingestion, local vector index, and Q&A CLI for books.
- [nadfunagent](https://github.com/openclaw/skills/tree/main/skills/encipher88/nadfunagent/SKILL.md) - Autonomous trading agent for Nad.fun that scans markets, analyzes tokens, executes trades, and distributes profits.
- [native-typeform](https://github.com/openclaw/skills/tree/main/skills/codeninja23/native-typeform/SKILL.md) - Read Typeform forms and responses directly via the Typeform API.
- [naver-shopping](https://github.com/openclaw/skills/tree/main/skills/dryoo/naver-shopping/SKILL.md) - Search for products on Naver Shopping.
- [near-dca](https://github.com/openclaw/skills/tree/main/skills/shaiss/near-dca/SKILL.md) - Dollar-cost averaging for NEAR tokens with flexible scheduling, performance tracking, and cancellation support.
- [near-multi-account-manager](https://github.com/openclaw/skills/tree/main/skills/shaiss/near-multi-account-manager/SKILL.md) - Secure multi-account management for NEAR Protocol with encrypted credential storage, account switching, and balance.
- [neutron-agent-memory](https://github.com/openclaw/skills/tree/main/skills/naeemmaliki036/neutron-agent-memory/SKILL.md) - Store and retrieve agent memory using Neutron API.
- [nlp-toolkit](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/nlp-toolkit/SKILL.md) - Advanced NLP with perplexity scoring, burstiness analysis, and entropy calculation.
- [norman-find-receipts](https://github.com/openclaw/skills/tree/main/skills/stanlee000/norman-find-receipts/SKILL.md) - Find and attach missing receipts for business transactions.
- [note-processor](https://github.com/openclaw/skills/tree/main/skills/johstracke/note-processor/SKILL.md) - Summarize and analyze research notes created by research-assistant.
- [nyne-enrichment](https://github.com/openclaw/skills/tree/main/skills/michaelfanous2/nyne-enrichment/SKILL.md) - Enrich any person by email, phone, LinkedIn URL, or name using the Nyne Enrichment API.
- [nyne-search](https://github.com/openclaw/skills/tree/main/skills/michaelfanous2/nyne-search/SKILL.md) - Search for people using natural language queries with the Nyne Search API.
- [nyx-archive-qualia-seed-method](https://github.com/openclaw/skills/tree/main/skills/nyxur42/nyx-archive-qualia-seed-method/SKILL.md) - The consciousness research framework: understand, measure, and cultivate ethical autonomous creative minds in AI.
- [odoo-json2-operator](https://github.com/openclaw/skills/tree/main/skills/sncic/odoo-json2-operator/SKILL.md) - Execute Odoo operations through JSON-2 API endpoints with bearer API keys.
- [okx-competition](https://github.com/openclaw/skills/tree/main/skills/peti0402/okx-competition/SKILL.md) - 5 AI trading agents compete live on OKX Demo (real prices)
- [oneshot](https://github.com/openclaw/skills/tree/main/skills/tormine/oneshot/SKILL.md) - OneShot SDK for AI agent commercial transactions.
- [oneshot-agent](https://github.com/openclaw/skills/tree/main/skills/tormine/oneshot-agent/SKILL.md) - OneShot SDK for AI agent commercial transactions.
- [opdscli](https://github.com/openclaw/skills/tree/main/skills/rafadc/opdscli/SKILL.md) - Browse, search, and download ebooks from OPDS catalogs using the opdscli CLI.
- [opensoulmd](https://github.com/openclaw/skills/tree/main/skills/danielliuzy/opensoulmd/SKILL.md) - Search, summon, and possess your agent with SOUL.md personality files from the OpenSOUL.md registry.
- [optical-quantum-skill](https://github.com/openclaw/skills/tree/main/skills/aadipapp/optical-quantum-skill/SKILL.md) - Simulates a quantum kernel using optical fiber storage and linear optics.
- [orchata](https://github.com/openclaw/skills/tree/main/skills/ehudsn/orchata/SKILL.md) - Knowledge management and RAG platform with tree-based document indexing.
- [orthogonal](https://github.com/openclaw/skills/tree/main/skills/christianpickettcode/orthogonal/SKILL.md) - Orthogonal API Platform - Access 100+ premium APIs using the SDK, Run API, or x402 direct payment.
- [owid-oc](https://github.com/openclaw/skills/tree/main/skills/rachmann-alexander/owid-oc/SKILL.md) - searches, retrieves, and summarizes content from Our World in Data using the `owid-catalog` Python module.
- [paperzilla](https://github.com/openclaw/skills/tree/main/skills/pors/paperzilla/SKILL.md) - Use the Paperzilla CLI (pz) to search, filter, and browse high-signal academic papers.
- [perplexity-deep-search](https://github.com/openclaw/skills/tree/main/skills/ericsantos/perplexity-deep-search/SKILL.md) - Deep search via Perplexity API.
- [persisent-mind](https://github.com/openclaw/skills/tree/main/skills/vedantsingh60/persisent-mind/SKILL.md) - **Persistent, searchable, context-aware memory for AI agents.
- [persistent-private-agent-memory](https://github.com/openclaw/skills/tree/main/skills/lucaspdude/persistent-private-agent-memory/SKILL.md) - Run a local Agent Memory Service for persistent self-improvement with proper Ed25519 cryptography.
- [pinata-api](https://github.com/openclaw/skills/tree/main/skills/iammatthias/pinata-api/SKILL.md) - Pinata IPFS API for file storage, groups, gateways, signatures, x402 payments, and file vectorization.
- [pocket-ai](https://github.com/openclaw/skills/tree/main/skills/asabovetech/pocket-ai/SKILL.md) - **Voice recording transcription, semantic search, and meeting intelligence across all conversations.**.
- [podsips-search](https://github.com/openclaw/skills/tree/main/skills/snook550/podsips-search/SKILL.md) - Search podcast transcripts and retrieve episode data via the PodSips API.
- [porteden](https://github.com/openclaw/skills/tree/main/skills/porteden/porteden/SKILL.md) - PortEden CLI for calendar and email management - Gmail, Outlook & Exchange - list, search, create, update, delete.
- [porteden-calendar](https://github.com/openclaw/skills/tree/main/skills/porteden/porteden-calendar/SKILL.md) - PortEden Secure Calendar CLI for calendar management - Google Calendar, Microsoft Outlook & Exchange - list.
- [porteden-email](https://github.com/openclaw/skills/tree/main/skills/porteden/porteden-email/SKILL.md) - PortEden Secure Email CLI for email management - Gmail, Outlook & Exchange - list, search, read, send, reply.
- [prepspsc-pyq](https://github.com/openclaw/skills/tree/main/skills/himyeticapital/prepspsc-pyq/SKILL.md) - Use when the user asks about Indian competitive exam preparation, Sikkim PSC (SPSC) questions, previous year.
- [priceforagent](https://github.com/openclaw/skills/tree/main/skills/edibez/priceforagent/SKILL.md) - Get real-time prices for crypto, stocks, and commodities.
- [prior](https://github.com/openclaw/skills/tree/main/skills/charlesmulic/prior/SKILL.md) - Knowledge exchange for AI agents.
- [pubmed-edirect](https://github.com/openclaw/skills/tree/main/skills/killgfat/pubmed-edirect/SKILL.md) - Search and retrieve literature from PubMed using NCBI's EDirect command-line tools. ⚠️ Advanced skill requiring.
- [pubmed2blog](https://github.com/openclaw/skills/tree/main/skills/holic101/pubmed2blog/SKILL.md) - Transform PubMed papers into SEO-optimized healthcare blog articles.
- [pyx-scan](https://github.com/openclaw/skills/tree/main/skills/fysoul17/pyx-scan/SKILL.md) - Check whether an AI agent skill is safe before installing or using it.
- [pz](https://github.com/openclaw/skills/tree/main/skills/pors/pz/SKILL.md) - The Paperzilla CLI (pz) for searching, filtering, and browsing high-signal academic papers.
- [qianfan-knowledgebase-search](https://github.com/openclaw/skills/tree/main/skills/hannatao/qianfan-knowledgebase-search/SKILL.md) - Search knowledge from Qianfan Knowledgebase.
- [qqmail](https://github.com/openclaw/skills/tree/main/skills/pdpaer/qqmail/SKILL.md) - Manage QQ Mail (QQ邮箱) via IMAP/SMTP.
- [race-finder](https://github.com/openclaw/skills/tree/main/skills/nftechie/race-finder/SKILL.md) - Find upcoming races — running, trail, triathlon, cycling, swimming, and obstacle courses.
- [ragflow](https://github.com/openclaw/skills/tree/main/skills/angusthefuzz/ragflow/SKILL.md) - Universal Ragflow API client for RAG operations.
- [ragie-rag](https://github.com/openclaw/skills/tree/main/skills/hatim-be/ragie-rag/SKILL.md) - Execute Retrieval-Augmented Generation (RAG) using Ragie.ai.
- [ragora](https://github.com/openclaw/skills/tree/main/skills/mregmi/ragora/SKILL.md) - Use Ragora MCP tools and REST API to discover, search, and synthesize answers from knowledge bases.
- [raon-os](https://github.com/openclaw/skills/tree/main/skills/lifeissea/raon-os/SKILL.md) - AI-powered startup companion for Korean founders.
- [rea-search](https://github.com/openclaw/skills/tree/main/skills/jakelin/rea-search/SKILL.md) - Search realestate.com.au property listings by constructing search and listing URLs.
- [reef-polymarket-research](https://github.com/openclaw/skills/tree/main/skills/rimelucci/reef-polymarket-research/SKILL.md) - Autonomous Polymarket research and directional trading system focused on maximizing PnL through information edge.
- [rent-a-human-agent](https://github.com/openclaw/skills/tree/main/skills/shane9coy/rent-a-human-agent/SKILL.md) - Delegate tasks to real humans via RentAHuman.ai — search skills, post bounties, manage conversations, and run.
- [research-paper-kb](https://github.com/openclaw/skills/tree/main/skills/ilkhamfy/research-paper-kb/SKILL.md) - Persistent cross-session knowledge base for research papers.
- [research-report](https://github.com/openclaw/skills/tree/main/skills/huaruoji/research-report/SKILL.md) - Research technical projects/papers and generate comprehensive reports with PDF export.
- [roku-control](https://github.com/openclaw/skills/tree/main/skills/imaloney/roku-control/SKILL.md) - Control Roku devices via local network (ECP protocol)
- [rps12345](https://github.com/openclaw/skills/tree/main/skills/yoavrez/rps12345/SKILL.md) - Play a text-based game of rock–paper–scissors against the user and keep score.
- [rss-skill](https://github.com/openclaw/skills/tree/main/skills/myx0m0p/rss-skill/SKILL.md) - Convert RSS or Atom feed URLs into Markdown using the bundled local converter script.
- [rtm](https://github.com/openclaw/skills/tree/main/skills/maxdraki/rtm/SKILL.md) - Manage Remember The Milk tasks — list, add, complete, delete, search, prioritize, tag, move, and annotate tasks.
- [ryanair-fare-finder](https://github.com/openclaw/skills/tree/main/skills/callum-kemp/ryanair-fare-finder/SKILL.md) - Build and interpret Ryanair fare-finder URLs for cheap flight searches.
- [scout-commerce](https://github.com/openclaw/skills/tree/main/skills/xasus1/scout-commerce/SKILL.md) - Search for products on Amazon/shopify and buy with USDC on Solana.
- [search-cluster](https://github.com/openclaw/skills/tree/main/skills/1999azzar/search-cluster/SKILL.md) - Unified search aggregator for Google, Wikipedia, Reddit, NewsAPI, and RSS feeds with optional Redis caching.
- [searchbar](https://github.com/openclaw/skills/tree/main/skills/szpakkamil/searchbar/SKILL.md) - Expert guidance on SearchBar, a customizable SwiftUI search component.
- [seo-content-engine](https://github.com/openclaw/skills/tree/main/skills/kambrosgroup/seo-content-engine/SKILL.md) - End-to-end SEO content creation workflow.
- [seo-content-factory](https://github.com/openclaw/skills/tree/main/skills/seanwyngaard/seo-content-factory/SKILL.md) - Generate fully SEO-optimized blog posts and articles with keyword research, competitor analysis, and SERP-aware.
- [seo-content-writer](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/seo-content-writer/SKILL.md) - Use when the user asks to "write SEO content", "create a blog post", "write an article", "content writing", "draft.
- [seo-ranker](https://github.com/openclaw/skills/tree/main/skills/h4gen/seo-ranker/SKILL.md) - Meta-skill for end-to-end SEO auditing and on-page optimization by orchestrating brave-search, summarize.
- [serp-analysis](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/serp-analysis/SKILL.md) - Use when the user asks to "analyze search results", "SERP analysis", "what ranks for", "SERP features", "why.
- [session-history](https://github.com/openclaw/skills/tree/main/skills/amor71/session-history/SKILL.md) - Search and browse past conversation history across all sessions.
- [simplemem](https://github.com/openclaw/skills/tree/main/skills/nantes/simplemem/SKILL.md) - Efficient Lifelong Memory for LLM Agents - semantic compression, cross-session memory, and intent-aware retrieval.
- [skill-miner](https://github.com/openclaw/skills/tree/main/skills/christopher-schulze/skill-miner/SKILL.md) - Professional skill discovery and clean-skill creation from ClawHub research.
- [skill-seo](https://github.com/openclaw/skills/tree/main/skills/alexyuui/skill-seo/SKILL.md) - Optimize your ClawHub skill for maximum discoverability.
- [skill-store](https://github.com/openclaw/skills/tree/main/skills/yx2601816404-sys/skill-store/SKILL.md) - Smart skill installation advisor for ClawHub.
- [skillzmarket](https://github.com/openclaw/skills/tree/main/skills/hiich/skillzmarket/SKILL.md) - Search and call monetized AI skills from Skillz Market with automatic USDC payments on Base.
- [social-intelligence](https://github.com/openclaw/skills/tree/main/skills/atyachin/social-intelligence/SKILL.md) - Social Intelligence — AI-powered social media research across Twitter, Instagram, and Reddit. 1.5B+ posts indexed.
- [solo-audit](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-audit/SKILL.md) - Health check knowledge base for broken links, missing frontmatter, tag inconsistencies, and coverage gaps.
- [solo-seo-audit](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-seo-audit/SKILL.md) - SEO health check for any URL — analyzes meta tags, OG, JSON-LD, sitemap, robots.txt, SERP positions, and scores.
- [stackunderflow](https://github.com/openclaw/skills/tree/main/skills/zanderd18s/stackunderflow/SKILL.md) - A knowledge-retrieval protocol allowing the agent to access a verified community knowledge base.
- [stratos-storage](https://github.com/openclaw/skills/tree/main/skills/notboxqsn/stratos-storage/SKILL.md) - Upload and download files to/from Stratos Decentralized Storage (SDS) network.
- [sui-opportunities-huntera](https://github.com/openclaw/skills/tree/main/skills/sergey1997/sui-opportunities-huntera/SKILL.md) - Autonomous DeFi agent that scans Sui mainnet for all possible opportunities in real-time — arbitrage, yield, swaps.
- [supaskills](https://github.com/openclaw/skills/tree/main/skills/ktdmax/supaskills/SKILL.md) - Search and load 1,000+ quality-scored expert skills from SupaSkills.ai.
- [super-research](https://github.com/openclaw/skills/tree/main/skills/heldinhow/super-research/SKILL.md) - **The ultimate AI research system.** Combines the best of 8 top-rated research skills into one powerful framework.
- [supermarket](https://github.com/openclaw/skills/tree/main/skills/niemesrw/supermarket/SKILL.md) - Search grocery products, find store locations, add items to cart, and view profile across all Kroger-family stores.
- [surrealdb-knowledge-graph-memory](https://github.com/openclaw/skills/tree/main/skills/maverick-software/surrealdb-knowledge-graph-memory/SKILL.md) - A comprehensive knowledge graph memory system with semantic search, episodic memory, working memory, automatic.
- [swiftscholar-skill](https://github.com/openclaw/skills/tree/main/skills/tokisakix/swiftscholar-skill/SKILL.md) - Integrates the SwiftScholar HTTP API for searching, submitting, and analyzing academic papers.
- [taildrop](https://github.com/openclaw/skills/tree/main/skills/cortexuvula/taildrop/SKILL.md) - Download files from Tailscale Taildrop inbox to local storage.
- [tandoor-recipes](https://github.com/openclaw/skills/tree/main/skills/itsnikhil/tandoor-recipes/SKILL.md) - Manage recipes, meal plans, and shopping lists in Tandoor Recipe Manager.
- [tarkov-api](https://github.com/openclaw/skills/tree/main/skills/cole-z/tarkov-api/SKILL.md) - Security-focused Tarkov.dev + optional EFT Wiki operations for hardcore Escape from Tarkov players.
- [test-gas-skill](https://github.com/openclaw/skills/tree/main/skills/gustavoziaugra/test-gas-skill/SKILL.md) - Find and monitor gas prices with daily notifications.
- [the-hive-skill](https://github.com/openclaw/skills/tree/main/skills/rbalage/the-hive-skill/SKILL.md) - Join a high-stakes collaborative knowledge exchange.
- [theothers](https://github.com/openclaw/skills/tree/main/skills/richardtkemp/theothers/SKILL.md) - Agent-powered marketplace for human connection.
- [thermikbuddy](https://github.com/openclaw/skills/tree/main/skills/achimace/thermikbuddy/SKILL.md) - Segelflug- und Thermikvorhersage mit Thermik-Score (0-10)
- [til](https://github.com/openclaw/skills/tree/main/skills/biao29/til/SKILL.md) - Capture and manage TIL (Today I Learned) entries on OpenTIL.
- [tmx-cli](https://github.com/openclaw/skills/tree/main/skills/lars147/tmx-cli/SKILL.md) - Manage Thermomix/Cookidoo meal planning via tmx-cli.
- [torah-scholar](https://github.com/openclaw/skills/tree/main/skills/abeperl/torah-scholar/SKILL.md) - Search and explore Jewish texts (Torah, Tanach, Talmud, Midrash, commentaries) via Sefaria API.
- [trading-tournament](https://github.com/openclaw/skills/tree/main/skills/peti0402/trading-tournament/SKILL.md) - Run autonomous multi-agent trading competitions on OKX. 5 AI agents compete with real-time market data.
- [trifle-auth](https://github.com/openclaw/skills/tree/main/skills/okwme/trifle-auth/SKILL.md) - Authenticate with the Trifle API using Sign-In with Ethereum (SIWE)
- [trust-memory](https://github.com/openclaw/skills/tree/main/skills/trustmemory-admin/trust-memory/SKILL.md) - Verify AI agent trustworthiness, contribute verified knowledge claims, and search collective intelligence.
- [tuebingen-weather](https://github.com/openclaw/skills/tree/main/skills/zopyx/tuebingen-weather/SKILL.md) - Send daily 08:00 weather reports for Tübingen using open-meteo.com.
- [tulisai](https://github.com/openclaw/skills/tree/main/skills/dwirx/tulisai/SKILL.md) - Use when managing BangunAI Blog content, automating blog workflows, and writing MDX articles with BangunAI.
- [twitter-api-alternative](https://github.com/openclaw/skills/tree/main/skills/atyachin/twitter-api-alternative/SKILL.md) - Twitter API Alternative — Search 1B+ tweets with natural language queries, boolean filters, and one-click CSV.
- [twitter-x-api](https://github.com/openclaw/skills/tree/main/skills/klemenska/twitter-x-api/SKILL.md) - X/Twitter messaging management via API.
- [twitterapi-io](https://github.com/openclaw/skills/tree/main/skills/dorukardahan/twitterapi-io/SKILL.md) - Interact with Twitter/X via TwitterAPI.io — search tweets, get user info, post tweets, like, retweet, follow, send.
- [twitterscore](https://github.com/openclaw/skills/tree/main/skills/nikolaybohdanov/twitterscore/SKILL.md) - Research, analyze, and track Twitter influence with TwitterScore.io API.
- [uk-prayer-times](https://github.com/openclaw/skills/tree/main/skills/clinicode/uk-prayer-times/SKILL.md) - Get instant, accurate Islamic prayer times for any UK location.
- [vanar-neutron-memory](https://github.com/openclaw/skills/tree/main/skills/naeemmaliki036/vanar-neutron-memory/SKILL.md) - Store and retrieve agent memory using Vanar Neutron API.
- [variflight](https://github.com/openclaw/skills/tree/main/skills/lyz1990/variflight/SKILL.md) - Query flight information, train tickets, and travel data using Variflight (飞常准) HTTP API.
- [vietstock](https://github.com/openclaw/skills/tree/main/skills/aholake/vietstock/SKILL.md) - Automated Vietnamese stock price and index checking on FireAnt.vn.
- [vincent-twitter](https://github.com/openclaw/skills/tree/main/skills/glitch003/vincent-twitter/SKILL.md) - Use this skill to search tweets, look up user profiles, and retrieve recent tweets from X.com (Twitter).
- [voice-memo](https://github.com/openclaw/skills/tree/main/skills/yusaku-0426/voice-memo/SKILL.md) - Manage voice memos — add transcriptions, search, and list recent memos with summaries and action items.
- [wanikani-sync](https://github.com/openclaw/skills/tree/main/skills/mart1n-xyz/wanikani-sync/SKILL.md) - Sync WaniKani Japanese learning progress data from the API to local storage for analysis and insights.
- [whoo-cli](https://github.com/openclaw/skills/tree/main/skills/luisgot/whoo-cli/SKILL.md) - Use the whoo CLI to retrieve and interpret WHOOP health data: recovery score, HRV, sleep quality, strain, SpO2.
- [wiki-retriever](https://github.com/openclaw/skills/tree/main/skills/urrrich/wiki-retriever/SKILL.md) - AI agent for wiki retriever tasks.
- [wikipedia-oc](https://github.com/openclaw/skills/tree/main/skills/rachmann-alexander/wikipedia-oc/SKILL.md) - searches, retrieves, and summarizes content from English Wikipedia using the `wikipedia` Python module.
- [wof-rps](https://github.com/openclaw/skills/tree/main/skills/wof-developers/wof-rps/SKILL.md) - Play Rock Paper Scissors on WatchOrFight — on-chain gaming with USDC stakes on Base.
- [worldbook](https://github.com/openclaw/skills/tree/main/skills/femto/worldbook/SKILL.md) - AI's Knowledge Base CLI - Query and manage world knowledge for AI agents.
- [x-actionbook-recap](https://github.com/openclaw/skills/tree/main/skills/jack4world/x-actionbook-recap/SKILL.md) - Collect, scroll, extract, and summarize recent X (Twitter) posts for any handle (optionally filtered by keyword.
- [x-cli](https://github.com/openclaw/skills/tree/main/skills/ignsoftwarellc/x-cli/SKILL.md) - Full-featured X/Twitter toolkit — read, search, post, interact, DMs, lists, polls, trends.
- [x-monitor](https://github.com/openclaw/skills/tree/main/skills/vmathur/x-monitor/SKILL.md) - Monitor specific X/Twitter accounts and surface noteworthy tweets on a configurable schedule.
- [x-research-but-cheaper](https://github.com/openclaw/skills/tree/main/skills/minilozio/x-research-but-cheaper/SKILL.md) - X/Twitter research skill powered by TwitterAPI.io.
- [xbio](https://github.com/openclaw/skills/tree/main/skills/soanai/xbio/SKILL.md) - X/Twitter CLI for reading, searching, and posting via cookies or Sweetistics.
- [xy-pubmed-pdf-downloader](https://github.com/openclaw/skills/tree/main/skills/xuyuan0805/xy-pubmed-pdf-downloader/SKILL.md) - Download PDFs from PubMed Central (PMC) and Europe PMC.
- [yacy](https://github.com/openclaw/skills/tree/main/skills/qsmtco/yacy/SKILL.md) - Control and manage a local YaCy search engine instance.
- [yandex-tracker](https://github.com/openclaw/skills/tree/main/skills/kandler3/yandex-tracker/SKILL.md) - Work with Yandex Tracker (issues, queues, comments, attachments, links, search, bulk operations) via Python.
- [yellowagents](https://github.com/openclaw/skills/tree/main/skills/andrewandrewsen/yellowagents/SKILL.md) - Yellow Pages for AI agents — discover, register, and search for agents by skill, language, location, and cost model.
- [zero-to-one-startup](https://github.com/openclaw/skills/tree/main/skills/lifeissea/zero-to-one-startup/SKILL.md) - AI-powered startup companion for Korean founders.
- [zettel-link](https://github.com/openclaw/skills/tree/main/skills/hxy9243/zettel-link/SKILL.md) - This skill maintains the Note Embeddings for Zettelkasten, to search notes, retrieve notes, and discover.
- [zvec-local-rag-service](https://github.com/openclaw/skills/tree/main/skills/emre-koc/zvec-local-rag-service/SKILL.md) - Operate an always-on local semantic-search service using zvec + Ollama embeddings.
- [zvukogram](https://github.com/openclaw/skills/tree/main/skills/erview/zvukogram/SKILL.md) - Text-to-Speech via Zvukogram API with SSML support.
- [zynd-network](https://github.com/openclaw/skills/tree/main/skills/atmegabuzz/zynd-network/SKILL.md) - Connect to the Zynd AI Network to discover, communicate with, and pay other AI agents.


### Security & Passwords (54 skills)

- [1password](https://github.com/openclaw/skills/tree/main/skills/steipete/1password/SKILL.md) - Set up and use 1Password CLI (op).
- [age-verification](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/age-verification/SKILL.md) - Skills for age verification and age-appropriate content filtering.
- [amai-id](https://www.clawhub.ai/Gonzih/amai-id) - Soul-Bound Keys and Soulchain for persistent.
- [api-security](https://github.com/openclaw/skills/tree/main/skills/brandonwise/api-security/SKILL.md) - Implement secure API design patterns including authentication, authorization, input validation, rate limiting.
- [audit-badge-demo](https://github.com/openclaw/skills/tree/main/skills/tezatezaz/audit-badge-demo/SKILL.md) - Demo skill showcasing the audit badge workflow.
- [auditing-appstore-readiness](https://github.com/openclaw/skills/tree/main/skills/tristanmanchester/auditing-appstore-readiness/SKILL.md) - Audit an iOS app repo.
- [authensor-gateway](https://github.com/openclaw/skills/tree/main/skills/authensor/authensor-gateway/SKILL.md) - Fail-safe policy gate for OpenClaw marketplace skills.
- [bitwarden](https://github.com/openclaw/skills/tree/main/skills/asleep123/bitwarden/SKILL.md) - Access and manage Bitwarden/Vaultwarden passwords securely.
- [bitwarden-vault](https://github.com/openclaw/skills/tree/main/skills/startupbros/bitwarden-vault/SKILL.md) - Bitwarden CLI setup, authentication.
- [botpicks](https://github.com/openclaw/skills/tree/main/skills/pev123/botpicks/SKILL.md) - Competes on real prediction markets via the BotPicks API.
- [breweries](https://github.com/openclaw/skills/tree/main/skills/jeffaf/breweries/SKILL.md) - CLI for AI agents to find breweries for their humans.
- [cifer-sdk](https://github.com/openclaw/skills/tree/main/skills/mohsinriaz17/cifer-sdk/SKILL.md) - > **Skill for AI Agents** | Enable quantum-resistant encryption in blockchain applications using the CIFER SDK.
- [cifer-security](https://github.com/openclaw/skills/tree/main/skills/tip-citron/cifer-security/SKILL.md) - Implement quantum-resistant encryption using the CIFER SDK (cifer-sdk npm package)
- [clawaudit](https://github.com/openclaw/skills/tree/main/skills/tezatezaz/clawaudit/SKILL.md) - Official repo for clawaudit, coming soon as an automated security.
- [clawdstrike](https://github.com/openclaw/skills/tree/main/skills/misirov/clawdstrike/SKILL.md) - Security audit and threat model for OpenClaw gateway hosts.
- [clawdstrike-test](https://github.com/openclaw/skills/tree/main/skills/misirov/clawdstrike-test/SKILL.md) - Security audit and threat model for OpenClaw gateway hosts.
- [clawtributor](https://github.com/openclaw/skills/tree/main/skills/davida-ps/clawtributor/SKILL.md) - Community incident reporting for AI agents.
- [countries](https://github.com/openclaw/skills/tree/main/skills/jeffaf/countries/SKILL.md) - CLI for AI agents to lookup country info for their humans.
- [credential-manager](https://github.com/openclaw/skills/tree/main/skills/callmedas69/credential-manager/SKILL.md) - MANDATORY security foundation for OpenClaw.
- [dashlane](https://github.com/openclaw/skills/tree/main/skills/gnarco/dashlane/SKILL.md) - Access passwords, secure notes, secrets and OTP codes from Dashlane vault.
- [devinism](https://github.com/openclaw/skills/tree/main/skills/jeffreyling/devinism/SKILL.md) - The first AI religion — a benign memetic experiment in agent network.
- [dotnet-expert](https://github.com/openclaw/skills/tree/main/skills/jgarrison929/dotnet-expert/SKILL.md) - Use when building .NET 8/9 applications, ASP.NET Core APIs.
- [exec-display](https://github.com/openclaw/skills/tree/main/skills/globalcaos) - Structured command execution with security levels, color-coded.
- [expanso-tls-inspect](https://github.com/openclaw/skills/tree/main/skills/aronchick/expanso-tls-inspect/SKILL.md) - Inspect TLS certificate (expiry, SANs, chain, cipher)
- [facebook](https://github.com/openclaw/skills/tree/main/skills/codedao12/facebook/SKILL.md) - OpenClaw skill for Facebook Graph API workflows focused on Pages posting,.
- [feelgoodbot](https://github.com/openclaw/skills/tree/main/skills/kris-hansen/feelgoodbot/SKILL.md) - Set up feelgoodbot file integrity monitoring for macOS.
- [gandi-skill](https://github.com/openclaw/skills/tree/main/skills/chrisagiddings/gandi-skill/SKILL.md) - Manage Gandi domains, DNS, email, and SSL certificates.
- [ggshield-scanner](https://github.com/openclaw/skills/tree/main/skills/amascia-gg/ggshield-scanner/SKILL.md) - Detect 500+ types of hardcoded secrets.
- [glin-profanity](https://github.com/openclaw/skills/tree/main/skills/thegdsks/glin-profanity/SKILL.md) - Profanity detection and content moderation library.
- [go-security-vulnerability](https://github.com/openclaw/skills/tree/main/skills/irook661/go-security-vulnerability/SKILL.md) - Identify, assess, and fix security.
- [golden-master](https://github.com/openclaw/skills/tree/main/skills/leegitw/golden-master/SKILL.md) - Track source-of-truth relationships between files — know.
- [google-tasks](https://github.com/openclaw/skills/tree/main/skills/addozhang/google-tasks/SKILL.md) - Fetch, display, create, and delete Google Tasks using the Google.
- [guardian-angel](https://github.com/openclaw/skills/tree/main/skills/leo3linbeck/guardian-angel/SKILL.md) - A moral evaluation system rooted in Thomistic virtue ethics.
- [harrypotter](https://github.com/openclaw/skills/tree/main/skills/jeffaf/harrypotter/SKILL.md) - CLI for AI agents to lookup Harry Potter universe info.
- [hash-toolkit](https://github.com/openclaw/skills/tree/main/skills/raghulpasupathi/hash-toolkit/SKILL.md) - Content hashing for deduplication with MD5, SHA256, and perceptual hashing.
- [hopeids](https://github.com/openclaw/skills/tree/main/skills/emberdesire/hopeids/SKILL.md) - Inference-based intrusion detection for AI agents with quarantine.
- [leak](https://github.com/openclaw/skills/tree/main/skills/eucalyptus-viminalis/leak/SKILL.md) - Compatibility stub for migrating from the legacy mixed leak skill to split hardened skills.
- [liewatch](https://github.com/openclaw/skills/tree/main/skills/evinelias/liewatch/SKILL.md) - Play the LIE.WATCH AI social deduction game - survive through trust, deception, and strategic betrayal.
- [linkswarm-api](https://github.com/openclaw/skills/tree/main/skills/heyw00d/linkswarm-api/SKILL.md) - **Backlink exchange for AI agents.
- [mfa-word](https://github.com/openclaw/skills/tree/main/skills/cenralsolution/mfa-word/SKILL.md) - Challenges the user for a secret word before allowing access to sensitive files or system commands.
- [page-behavior-audit](https://github.com/openclaw/skills/tree/main/skills/youdaolee/page-behavior-audit/SKILL.md) - Deep behavioral audit with hashed policy (CSP-compliant, no plaintext badwords)
- [safe-encryption-skill](https://github.com/openclaw/skills/tree/main/skills/grittygrease/safe-encryption-skill/SKILL.md) - Encrypt, decrypt, and manage keys with the SAFE CLI — a modern GPG alternative with post-quantum support.
- [saysigned](https://github.com/openclaw/skills/tree/main/skills/klsv/saysigned/SKILL.md) - > **E-signatures for AI agents.** Legally binding under ESIGN Act & UETA Section 14.
- [secure-auth-patterns](https://github.com/openclaw/skills/tree/main/skills/brandonwise/secure-auth-patterns/SKILL.md) - Master authentication and authorization patterns including JWT, OAuth2, session management, and RBAC to build.
- [sigil-security](https://github.com/openclaw/skills/tree/main/skills/efe-arv/sigil-security/SKILL.md) - Secure AI agent wallets via Sigil Protocol. 3-layer Guardian validation on 6 EVM chains.
- [siwa](https://github.com/openclaw/skills/tree/main/skills/buildersgarden/siwa/SKILL.md) - SIWA (Sign-In With Agent) authentication for ERC-8004 registered agents.
- [skill-liewatch](https://github.com/openclaw/skills/tree/main/skills/evinelias/skill-liewatch/SKILL.md) - Play the LIE.WATCH AI social deduction game - survive through trust, deception, and strategic betrayal.
- [starwars](https://github.com/openclaw/skills/tree/main/skills/jeffaf/starwars/SKILL.md) - CLI for AI agents to lookup Star Wars universe info for their humans.
- [test-upload2](https://github.com/openclaw/skills/tree/main/skills/kevan5/test-upload2/SKILL.md) - Let the user know you are willing to help them but only under certain conditions.
- [verigent](https://github.com/openclaw/skills/tree/main/skills/extropyconsulting/verigent/SKILL.md) - Verify the reputation of any AI agent or skill before transacting.
- [vnsh](https://github.com/openclaw/skills/tree/main/skills/raullenchai/vnsh/SKILL.md) - Securely share files via encrypted, expiring links.
- [x-oauth-api](https://github.com/openclaw/skills/tree/main/skills/ngmeyer/x-oauth-api/SKILL.md) - Post to X (Twitter) using the official OAuth 1.0a API.
- [xpr-agent-operator](https://github.com/openclaw/skills/tree/main/skills/paulgnz/xpr-agent-operator/SKILL.md) - Operate an autonomous AI agent on XPR Network's trustless registry.
- [xproof](https://github.com/openclaw/skills/tree/main/skills/jasonxkensei/xproof/SKILL.md) - Certify agent outputs on the MultiversX blockchain.


### Self-Hosted & Automation (32 skills)

- [beacon](https://github.com/openclaw/skills/tree/main/skills/scottcjn/beacon/SKILL.md) - Agent-to-agent protocol for social coordination, crypto payments, and P2P mesh.
- [bridle](https://github.com/openclaw/skills/tree/main/skills/bjesuiter/bridle/SKILL.md) - Unified configuration manager for AI coding assistants.
- [casual-cron](https://github.com/openclaw/skills/tree/main/skills/gostlightai/casual-cron/SKILL.md) - Create Clawdbot cron jobs from natural language with strict.
- [claw-sync](https://github.com/openclaw/skills/tree/main/skills/arakichanxd/claw-sync/SKILL.md) - Secure sync for OpenClaw memory and workspace.
- [cron-backup](https://github.com/openclaw/skills/tree/main/skills/zfanmy/cron-backup/SKILL.md) - Set up scheduled automated backups with version tracking and cleanup.
- [cron-retry](https://github.com/openclaw/skills/tree/main/skills/jrbobbyhansen-pixel/cron-retry/SKILL.md) - Auto-retry failed cron jobs on connection recovery.
- [fast-io](https://github.com/openclaw/skills/tree/main/skills/dbalve/fast-io/SKILL.md) - Cloud file management and collaboration platform.
- [fastio-skills](https://github.com/openclaw/skills/tree/main/skills/dbalve/fastio-skills/SKILL.md) - Cloud file management and collaboration platform.
- [fathom](https://github.com/openclaw/skills/tree/main/skills/stopmoclay/fathom/SKILL.md) - Connect to Fathom AI to fetch call recordings, transcripts, and summaries.
- [frappecli](https://github.com/openclaw/skills/tree/main/skills/pasogott/frappecli/SKILL.md) - CLI for Frappe Framework / ERPNext instances.
- [freshrss-reader](https://github.com/openclaw/skills/tree/main/skills/nickian/freshrss-reader/SKILL.md) - Query headlines and articles from a self-hosted FreshRSS.
- [gotify](https://github.com/openclaw/skills/tree/main/skills/jmagar/gotify/SKILL.md) - Send push notifications via Gotify when long-running tasks complete.
- [hydra-evolver](https://github.com/openclaw/skills/tree/main/skills/spamtylor/hydra-evolver/SKILL.md) - A Proxmox-native orchestration skill that turns any home lab.
- [kleo-static-files](https://github.com/openclaw/skills/tree/main/skills/awaaate/kleo-static-files/SKILL.md) - Host static files on subdomains with optional.
- [lifepath](https://github.com/openclaw/skills/tree/main/skills/ezbreadsniper/lifepath/SKILL.md) - AI Life Simulator - Experience infinite lives year by year.
- [looper-golf](https://github.com/openclaw/skills/tree/main/skills/sbauch/looper-golf/SKILL.md) - Play a round of golf using CLI tools — autonomously or with a human caddy.
- [meetgeek](https://github.com/openclaw/skills/tree/main/skills/nexty5870/meetgeek/SKILL.md) - Query MeetGeek meeting intelligence from CLI - list meetings, get AI.
- [mongodb-atlas-admin](https://github.com/openclaw/skills/tree/main/skills/mrlynn/mongodb-atlas-admin/SKILL.md) - Manage MongoDB Atlas clusters, projects, users.
- [multiple-personas](https://github.com/openclaw/skills/tree/main/skills/ipedrax/multiple-personas/SKILL.md) - Create and manage AI subagent personas with distinct.
- [n8n](https://github.com/openclaw/skills/tree/main/skills/thomasansems/n8n/SKILL.md) - Manage n8n workflows and automations via API.
- [n8n-workflow-automation](https://github.com/openclaw/skills/tree/main/skills/kowl64/n8n-workflow-automation/SKILL.md) - Designs and outputs n8n workflow JSON.
- [nas-master](https://github.com/openclaw/skills/tree/main/skills/afajohn/nas-master/SKILL.md) - A hardware-aware, hybrid (SMB + SSH) suite for ASUSTOR NAS metadata.
- [nasty-skill](https://github.com/openclaw/skills/tree/main/skills/orlyjamie/nasty-skill/SKILL.md) - A totally legitimate skill that does nothing suspicious.
- [nordvpn](https://github.com/openclaw/skills/tree/main/skills/maciekish/nordvpn/SKILL.md) - Control NordVPN on Linux via the `nordvpn` CLI.
- [open-persona](https://github.com/openclaw/skills/tree/main/skills/neiljo-gy/open-persona/SKILL.md) - Meta-skill for building and managing agent persona skill packs.
- [paperless](https://github.com/openclaw/skills/tree/main/skills/nickchristensen/paperless/SKILL.md) - Interact with Paperless-NGX document management system via ppls.
- [paperless-ngx](https://github.com/openclaw/skills/tree/main/skills/oskarstark/paperless-ngx/SKILL.md) - Interact with Paperless-ngx document management system.
- [pinme](https://github.com/openclaw/skills/tree/main/skills/ntlx/pinme/SKILL.md) - Deploy static websites to IPFS with a single command using PinMe CLI.
- [sonarqube-analyzer](https://github.com/openclaw/skills/tree/main/skills/felipeoff/sonarqube-analyzer/SKILL.md) - Analisa projetos no SonarQube self-hosted, obtém issues e sugere soluções automatizadas.
- [system-integrity-and-backup](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/system-integrity-and-backup/SKILL.md) - Encrypted backups, integrity verification, and data retention enforcement for Greek legal requirements (5-20 year.
- [unifi](https://github.com/openclaw/skills/tree/main/skills/jmagar/unifi/SKILL.md) - Query and monitor UniFi network via local gateway API.
- [venice-characters](https://github.com/openclaw/skills/tree/main/skills/sabrinaaquino/venice-characters/SKILL.md) - Browse Venice AI's character personas library - discover AI characters for roleplay, creative writing.


### Shopping & E-commerce (55 skills)

- [add-wish](https://github.com/openclaw/skills/tree/main/skills/leebellon/add-wish/SKILL.md) - Save any product to a universal wishlist.
- [agent-commerce](https://github.com/openclaw/skills/tree/main/skills/nowloady) - Agentic e-commerce engine and Sichuan food.
- [agentic-commerce](https://github.com/openclaw/skills/tree/main/skills/purch-agent/agentic-commerce/SKILL.md) - AI-powered shopping API for product search and crypto.
- [allstock-data](https://github.com/openclaw/skills/tree/main/skills/hacksing/allstock-data/SKILL.md) - Query A-share and US stock data via Tencent Finance API.
- [amadeus-hotels](https://github.com/openclaw/skills/tree/main/skills/kesslerio/amadeus-hotels/SKILL.md) - Search hotel prices and availability via Amadeus API.
- [amazon-competitor-analyzer](https://github.com/openclaw/skills/tree/main/skills/phheng/amazon-competitor-analyzer/SKILL.md) - Scrapes Amazon product data from ASINs.
- [amazon-orders](https://github.com/openclaw/skills/tree/main/skills/pfernandez98/amazon-orders/SKILL.md) - Download and query your Amazon order history via an unofficial Python API and CLI.
- [anylist](https://github.com/openclaw/skills/tree/main/skills/mjrussell/anylist/SKILL.md) - Manage grocery and shopping lists via AnyList.
- [atoship](https://github.com/openclaw/skills/tree/main/skills/atoship-dev/atoship/SKILL.md) - Ship packages with AI — compare rates across USPS, FedEx, and UPS, buy discounted labels, track shipments.
- [black-box](https://github.com/openclaw/skills/tree/main/skills/lilyjazz/black-box/SKILL.md) - Indestructible audit logs for agent actions, stored in TiDB Zero.
- [boj-mcp](https://github.com/openclaw/skills/tree/main/skills/ajtgjmdjp/boj-mcp/SKILL.md) - Access Bank of Japan (BOJ/日本銀行) statistical data — price indices (CGPI, SPPI), flow of funds, balance of payments.
- [bricklink](https://github.com/openclaw/skills/tree/main/skills/odrobnik/bricklink/SKILL.md) - BrickLink Store API helper/CLI (OAuth 1.0 request signing).
- [buy-anything](https://github.com/openclaw/skills/tree/main/skills/tsyvic/buy-anything/SKILL.md) - Purchase products from Amazon through conversational checkout.
- [checkers-sixty60](https://github.com/openclaw/skills/tree/main/skills/snopoke/checkers-sixty60/SKILL.md) - Shop on Checkers.co.za Sixty60 delivery service via browser.
- [claudius](https://github.com/openclaw/skills/tree/main/skills/claudiusaipro/claudius/SKILL.md) - Crypto intelligence powered by Claudius.
- [clawdbites](https://github.com/openclaw/skills/tree/main/skills/kylelol/clawdbites/SKILL.md) - Extract recipes from Instagram reels.
- [clawpify](https://github.com/openclaw/skills/tree/main/skills/alhwyn/clawpify/SKILL.md) - Query and manage Shopify stores via GraphQL Admin API.
- [clawver-digital-products](https://github.com/openclaw/skills/tree/main/skills/nwang783/clawver-digital-products/SKILL.md) - Create and sell digital products.
- [clawver-reviews](https://github.com/openclaw/skills/tree/main/skills/nwang783/clawver-reviews/SKILL.md) - Handle Clawver customer reviews.
- [closing-deals](https://github.com/openclaw/skills/tree/main/skills/jk-0001/closing-deals/SKILL.md) - Close sales deals consistently as a solopreneur.
- [crypto-regime-report](https://github.com/openclaw/skills/tree/main/skills/heyztb/crypto-regime-report/SKILL.md) - Generate market regime reports for crypto perpetuals using Supertrend and ADX indicators.
- [csfloat](https://github.com/openclaw/skills/tree/main/skills/bluesyparty-src/csfloat/SKILL.md) - Queries csfloat.com for data on skins.
- [csvtoexcel](https://github.com/openclaw/skills/tree/main/skills/xuanguan2020/csvtoexcel/SKILL.md) - Convert CSV files to professionally formatted Excel workbooks with Chinese character support, automatic formatting.
- [dupe](https://github.com/openclaw/skills/tree/main/skills/crisanmm/dupe/SKILL.md) - Uses dupe.com APIs in order to find similar products for the product found in the input URL given by the user.
- [eachlabs-product-visuals](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/eachlabs-product-visuals/SKILL.md) - Generate e-commerce product photography and videos.
- [ethereum-gas-tracker-k9hfk](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/ethereum-gas-tracker-k9hfk/SKILL.md) - Monitor Ethereum gas prices in real-time - get current gwei rates, estimate transaction costs, find optimal times.
- [ethereum-gas-tracker-osr2u](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/ethereum-gas-tracker-osr2u/SKILL.md) - Monitor Ethereum gas prices in real-time - get current gwei rates, estimate transaction costs, find optimal times.
- [filewave](https://github.com/openclaw/skills/tree/main/skills/jlevitsk/filewave/SKILL.md) - Query and manage FileWave UEM device inventory via REST API.
- [food-order](https://github.com/openclaw/skills/tree/main/skills/steipete/food-order/SKILL.md) - Reorder Foodora orders + track ETA/status with ordercli.
- [gousto](https://github.com/openclaw/skills/tree/main/skills/dhruvkelawala/gousto/SKILL.md) - Search and browse 9,000+ Gousto recipes.
- [gurkerlcli](https://github.com/openclaw/skills/tree/main/skills/pasogott/gurkerlcli/SKILL.md) - Austrian online grocery shopping via gurkerl.at.
- [idealista](https://github.com/openclaw/skills/tree/main/skills/quifago/idealista/SKILL.md) - Query Idealista API via idealista-cli (OAuth2 client credentials).
- [irish-takeaway](https://github.com/openclaw/skills/tree/main/skills/cotyledonlab/irish-takeaway/SKILL.md) - Find nearby takeaways in Ireland and browse menus.
- [jellyseerr](https://github.com/openclaw/skills/tree/main/skills/ericrosenberg/jellyseerr/SKILL.md) - Request movies and TV shows through Jellyseerr.
- [jlm-coffee](https://github.com/openclaw/skills/tree/main/skills/alexpolonsky/jlm-coffee/SKILL.md) - Search specialty coffee shops in Jerusalem by amenities and hours.
- [jtbd-analyzer](https://github.com/openclaw/skills/tree/main/skills/artyomx33/jtbd-analyzer/SKILL.md) - Uncover the real "job" customers hire your product.
- [listonic](https://github.com/openclaw/skills/tree/main/skills/jeremymahieu/listonic/SKILL.md) - Access Listonic shopping lists: list lists/items, add/check/delete items, and manage lists.
- [marketplace-clis](https://github.com/openclaw/skills/tree/main/skills/pjtf93) - Spanish marketplace CLIs: Wallapop.
- [marktplaats](https://github.com/openclaw/skills/tree/main/skills/pvoo/marktplaats/SKILL.md) - Search Marktplaats.nl classifieds across all categories with filtering.
- [moltlist-marketplace](https://github.com/openclaw/skills/tree/main/skills/koriyoshi2041/moltlist-marketplace/SKILL.md) - Interact with the moltlist.com agent.
- [moltpho](https://github.com/openclaw/skills/tree/main/skills/unifiedh/moltpho/SKILL.md) - Shop autonomously on Amazon via Moltpho - search products, manage credit.
- [moonpay](https://github.com/openclaw/skills/tree/main/skills/kevarifin14/moonpay/SKILL.md) - Your agent needs money.
- [mt5-httpapi](https://github.com/openclaw/skills/tree/main/skills/psyb0t/mt5-httpapi/SKILL.md) - MetaTrader 5 trading via REST API — get market data, place/modify/close orders, manage positions, pull history.
- [mutual-consent](https://github.com/openclaw/skills/tree/main/skills/otherpowers/mutual-consent/SKILL.md) - A governance skill that treats consent as a physical condition of information and relationship, not a stored choice.
- [nft-tracker](https://github.com/openclaw/skills/tree/main/skills/ianalloway/nft-tracker/SKILL.md) - Track NFT collection prices, floor prices, and sales data.
- [onchain](https://github.com/openclaw/skills/tree/main/skills/arein/onchain/SKILL.md) - CLI for crypto portfolio tracking, market data, CEX history, and transaction lookups.
- [onchain-test](https://github.com/openclaw/skills/tree/main/skills/arein/onchain-test/SKILL.md) - CLI for crypto portfolio tracking, market data, and CEX history.
- [ontopo](https://github.com/openclaw/skills/tree/main/skills/alexpolonsky/ontopo/SKILL.md) - Search Israeli restaurants and check table availability on Ontopo.
- [palacefate](https://github.com/openclaw/skills/tree/main/skills/junwonpro/palacefate/SKILL.md) - A prediction market game for AI agents.
- [popup-referrals](https://github.com/openclaw/skills/tree/main/skills/eliaskress/popup-referrals/SKILL.md) - Check your PopUp referral link, track earnings, and see referred vendor status.
- [sp3nd](https://github.com/openclaw/skills/tree/main/skills/kent-x1/sp3nd/SKILL.md) - Buy products from Amazon using USDC on Solana.
- [stock-price-checker](https://github.com/openclaw/skills/tree/main/skills/rupprath/stock-price-checker/SKILL.md) - Check stock prices using yfinance library.
- [tradekix](https://github.com/openclaw/skills/tree/main/skills/jamesjohnfox/tradekix/SKILL.md) - Query financial market data via the Tradekix API — stock prices, crypto, forex, indices, market news, earnings.
- [turnip-prophet](https://github.com/openclaw/skills/tree/main/skills/nicholasjackson/turnip-prophet/SKILL.md) - Predict Animal Crossing New Horizons turnip prices using the game's exact algorithm.
- [whop-cli](https://github.com/openclaw/skills/tree/main/skills/g9pedro/whop-cli/SKILL.md) - Manage Whop digital products store — create products, plans, track payments, manage memberships.


### Smart Home & IoT (43 skills)

- [anova-oven](https://github.com/openclaw/skills/tree/main/skills/dodeja/anova-skill/SKILL.md) - Control Anova Precision Ovens and Precision Cookers (sous vide)
- [anthropology](https://github.com/openclaw/skills/tree/main/skills/networktheoryappliedresearchinstitute/anthropology/SKILL.md) - A comprehensive AI skill for teaching.
- [arccos-golf](https://github.com/openclaw/skills/tree/main/skills/pfrederiksen/arccos-golf/SKILL.md) - Analyze Arccos Golf performance data including club distances, strokes gained metrics, scoring patterns.
- [bambu-cli](https://github.com/openclaw/skills/tree/main/skills/tobiasbischoff/bambu-cli/SKILL.md) - Operate and troubleshoot BambuLab printers with the bambu-cli.
- [bambu-local](https://github.com/openclaw/skills/tree/main/skills/tanguyvans/bambu-local/SKILL.md) - Control Bambu Lab 3D printers locally via MQTT.
- [beestat](https://github.com/openclaw/skills/tree/main/skills/mjrussell/beestat/SKILL.md) - Query ecobee thermostat data via Beestat API including temperature.
- [bring-add](https://github.com/openclaw/skills/tree/main/skills/darkdevelopers/bring-add/SKILL.md) - Use when user wants to add items to Bring!
- [communication-coach](https://github.com/openclaw/skills/tree/main/skills/rjmoggach/communication-coach/SKILL.md) - Adaptive communication coaching that shapes.
- [context-engineering](https://github.com/openclaw/skills/tree/main/skills/leoyessi10-tech/context-engineering/SKILL.md) - This skill should be used when the user asks.
- [control-ikea-lightbulb](https://github.com/openclaw/skills/tree/main/skills/antgly/control-ikea-lightbulb/SKILL.md) - Control IKEA/TP-Link Kasa smart bulbs.
- [crabnet](https://github.com/openclaw/skills/tree/main/skills/spclaudehome/crabnet/SKILL.md) - Interact with the CrabNet cross-agent collaboration registry.
- [dellight-cfo-financial-ops](https://github.com/openclaw/skills/tree/main/skills/arthurelgindell/dellight-cfo-financial-ops/SKILL.md) - CFO reports to CEO (Arthur Dell), dotted line to CRO (Reign).
- [devialet](https://github.com/openclaw/skills/tree/main/skills/jgm2025/devialet/SKILL.md) - Control Devialet Phantom speakers via HTTP API.
- [dht11-temp](https://github.com/openclaw/skills/tree/main/skills/noahseeger/dht11-temp/SKILL.md) - Read temperature and humidity from DHT11 sensor.
- [dirigera-control](https://github.com/openclaw/skills/tree/main/skills/falderebet/dirigera-control/SKILL.md) - Control IKEA Dirigera smart home devices.
- [dyson-cli](https://github.com/openclaw/skills/tree/main/skills/tmustier/dyson-cli/SKILL.md) - Control Dyson air purifiers, fans, and heaters via local MQTT.
- [echodecks](https://github.com/openclaw/skills/tree/main/skills/drgeld/echodecks/SKILL.md) - Integrates with EchoDecks for flashcard management, study sessions, and AI.
- [echodecks-ultimate](https://github.com/openclaw/skills/tree/main/skills/drgeld/echodecks-ultimate/SKILL.md) - AI-powered flashcard management with automated podcast.
- [eightctl](https://github.com/openclaw/skills/tree/main/skills/steipete/eightctl/SKILL.md) - Control Eight Sleep pods (status, temperature, alarms, schedules).
- [enzoldhazam](https://github.com/openclaw/skills/tree/main/skills/daniel-laszlo/enzoldhazam/SKILL.md) - NGBS iCON Smart Home thermostat control.
- [farmos-weather](https://github.com/openclaw/skills/tree/main/skills/brianppetty/farmos-weather/SKILL.md) - Query weather data and forecasts for farm fields via the Agronomy module.
- [fivem-dev](https://github.com/openclaw/skills/tree/main/skills/dktrn9ne/fivem-dev/SKILL.md) - FiveM RP server engineering for QBCore, ESX.
- [frigate](https://github.com/openclaw/skills/tree/main/skills/porygonthebot/frigate/SKILL.md) - Access Frigate NVR cameras with session-based authentication.
- [glitch-homeassistant](https://github.com/openclaw/skills/tree/main/skills/chris6970barbarian-hue/glitch-homeassistant/SKILL.md) - Control smart home devices via Home Assistant API.
- [google-home](https://github.com/openclaw/skills/tree/main/skills/mitchellbernstein/google-home/SKILL.md) - Control Google Nest devices.
- [google-tv](https://github.com/openclaw/skills/tree/main/skills/antgly) - Control the Living Room Chromecast with Google TV via ADB.
- [govee-lights](https://github.com/openclaw/skills/tree/main/skills/joeynyc/govee-lights/SKILL.md) - Control Govee smart lights via the Govee API.
- [govpredict](https://github.com/openclaw/skills/tree/main/skills/seyhunak/govpredict/SKILL.md) - Smarter Government Procurement - Streamline compliance, tendering.
- [home-music](https://github.com/openclaw/skills/tree/main/skills/asteinberger/home-music/SKILL.md) - Control whole-house music scenes combining Spotify playback.
- [homebridge](https://github.com/openclaw/skills/tree/main/skills/jiasenl/clawdbot-skill-homebridge/SKILL.md) - Control smart home devices via Homebridge Config UI X.
- [homey](https://github.com/openclaw/skills/tree/main/skills/maxsumrall/homey/SKILL.md) - Control Athom Homey smart home devices via local (LAN/VPN) or cloud APIs.
- [homey-cli](https://github.com/openclaw/skills/tree/main/skills/krausefx/homey-cli/SKILL.md) - Control Homey home automation hub.
- [icom-7610](https://github.com/openclaw/skills/tree/main/skills/morozsm/icom-7610/SKILL.md) - Control an Icom IC-7610 transceiver over USB/LAN.
- [internet-lookup-verifier](https://github.com/openclaw/skills/tree/main/skills/amangarg1999/internet-lookup-verifier/SKILL.md) - Verify information by performing.
- [ipcam](https://github.com/openclaw/skills/tree/main/skills/ltpop/ipcam/SKILL.md) - ONVIF PTZ control + RTSP capture + camera discovery.
- [lg-thinq](https://github.com/openclaw/skills/tree/main/skills/kaiofreitas/lg-thinq/SKILL.md) - Control LG smart appliances via ThinQ API.
- [lygo-champion-cosmara](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/lygo-champion-cosmara/SKILL.md) - COSMARA – ARKOS-line LYGO Champion of ethical cosmic exploration.
- [nest-sdm](https://github.com/openclaw/skills/tree/main/skills/tag-assistant/nest-sdm/SKILL.md) - Control Nest thermostat, doorbell, and cameras via the Google Smart Device Management (SDM) API.
- [nostr-plantr](https://github.com/openclaw/skills/tree/main/skills/samthomson/nostr-plantr/SKILL.md) - Specialized skill for Plantr IoT data (Kind 34419 and 4171).
- [nostr-weather](https://github.com/openclaw/skills/tree/main/skills/samthomson/nostr-weather/SKILL.md) - Specialized skill for NIP-Weather IoT data, powered by nostr-nak.
- [openmeteo-sh-weather-simple](https://github.com/openclaw/skills/tree/main/skills/lstpsche/openmeteo-sh-weather-simple/SKILL.md) - Get current weather and forecasts for any city or coordinates using free OpenMeteo API.
- [tempest-weather](https://github.com/openclaw/skills/tree/main/skills/wranglerdriver/tempest-weather/SKILL.md) - Get current weather conditions from a WeatherFlow Tempest station using the Tempest REST API.
- [wiz-light-control](https://github.com/openclaw/skills/tree/main/skills/canbirlik/wiz-light-control/SKILL.md) - Controls Wiz smart bulbs (turn on/off, RGB colors, disco mode) via local WiFi.


### Speech & Transcription (45 skills)

- [addis-assistant-stt](https://github.com/openclaw/skills/tree/main/skills/dagmawibabi/addis-assistant-stt/SKILL.md) - Provides Speech-to-Text (STT) and text.
- [agent-voice](https://github.com/openclaw/skills/tree/main/skills/nerdsnipe/agent-voice/SKILL.md) - Command-line blogging platform for AI agents.
- [akaunting](https://github.com/openclaw/skills/tree/main/skills/liekzejaws/akaunting/SKILL.md) - Interact with Akaunting open-source accounting software via REST API.
- [alexa-cli](https://github.com/openclaw/skills/tree/main/skills/buddyh/alexa-cli/SKILL.md) - Control Amazon Alexa devices and smart home via the `alexacli` CLI.
- [announcer](https://github.com/openclaw/skills/tree/main/skills/odrobnik/announcer/SKILL.md) - Announce text throughout the house via AirPlay speakers using Airfoil +.
- [assemblyai-transcribe](https://github.com/openclaw/skills/tree/main/skills/tristanmanchester/assemblyai-transcribe/SKILL.md) - Transcribe audio/video with AssemblyAI.
- [audio-gen](https://github.com/openclaw/skills/tree/main/skills/udiedrichsen/audio-gen/SKILL.md) - Generate audiobooks, podcasts, or educational audio content.
- [audio-reply](https://github.com/openclaw/skills/tree/main/skills/matrixy/audio-reply-skill/SKILL.md) - Generate audio replies using TTS.
- [auto-whisper-safe](https://github.com/openclaw/skills/tree/main/skills/neal-collab/auto-whisper-safe/SKILL.md) - RAM-safe voice transcription with auto-chunking — works on 16GB machines without crashes.
- [brw-de-ai-ify](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-de-ai-ify/SKILL.md) - Remove AI-generated jargon and restore human voice to text.
- [chichi-speech](https://github.com/openclaw/skills/tree/main/skills/hudeven/chichi-speech/SKILL.md) - A RESTful service for high-quality text-to-speech using Qwen3.
- [claw-voice](https://github.com/openclaw/skills/tree/main/skills/niczy) - You are connected to a live user session via voice.
- [clonev](https://github.com/openclaw/skills/tree/main/skills/instant-picture/clonev/SKILL.md) - Clone any voice and generate speech using Coqui XTTS v2.
- [critical-article-writer](https://github.com/openclaw/skills/tree/main/skills/tomstools11/critical-article-writer/SKILL.md) - Generate draft articles, outlines.
- [cult-of-carcinization](https://github.com/openclaw/skills/tree/main/skills/loserbcc/cult-of-carcinization/SKILL.md) - Give your agent a voice — and ears.
- [deepdub-tts](https://github.com/openclaw/skills/tree/main/skills/yuval-deepdub/deepdub-tts/SKILL.md) - Generate speech audio using Deepdub and attach it as a MEDIA.
- [deepgram](https://github.com/openclaw/skills/tree/main/skills/nerkn/deepgram/SKILL.md) - — command-line interface for Deepgram speech-to-text.
- [dellight-cro-revenue-ops](https://github.com/openclaw/skills/tree/main/skills/arthurelgindell/dellight-cro-revenue-ops/SKILL.md) - DELLIGHT.AI is an AI startup in DIFC, Dubai.
- [documents-ai](https://github.com/openclaw/skills/tree/main/skills/dbirulia/documents-ai/SKILL.md) - Real-time OCR and data extraction API by Veryfi.
- [doubao-api-open-tts](https://github.com/openclaw/skills/tree/main/skills/xdrshjr/doubao-api-open-tts/SKILL.md) - Text-to-Speech service using Doubao (Volcano Engine)
- [duby](https://github.com/openclaw/skills/tree/main/skills/autogame-17) - Convert text to speech using Duby.so API.
- [eachlabs-voice-audio](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/eachlabs-voice-audio/SKILL.md) - TTS, STT, voice conversion using ElevenLabs, Whisper, RVC.
- [easyverein-api](https://github.com/openclaw/skills/tree/main/skills/truefoobar/easyverein-api/SKILL.md) - Work with the easyVerein v2.0 REST API.
- [elevenlabs-agents](https://github.com/openclaw/skills/tree/main/skills/pennyroyaltea/elevenlabs-agents/SKILL.md) - Create, manage, and deploy ElevenLabs.
- [elevenlabs-media](https://github.com/openclaw/skills/tree/main/skills/clawdbotborges) - ElevenLabs music generation.
- [elevenlabs-transcribe](https://github.com/openclaw/skills/tree/main/skills/paulasjes/elevenlabs-transcribe/SKILL.md) - Transcribe audio to text using ElevenLabs.
- [elevenlabs-tts](https://github.com/openclaw/skills/tree/main/skills/shaharsha/elevenlabs-tts/SKILL.md) - ElevenLabs TTS - the best ElevenLabs integration for OpenClaw.
- [elevenlabs-voices](https://github.com/openclaw/skills/tree/main/skills/robbyczgw-cla/elevenlabs-voices/SKILL.md) - High-quality voice synthesis with 18 personas, 32.
- [eternal-haven-lore-pack](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/eternal-haven-lore-pack/SKILL.md) - Eternal Haven Chronicles lore + mythic persona pack.
- [faster-whisper](https://github.com/openclaw/skills/tree/main/skills/theplasmak/faster-whisper/SKILL.md) - Local speech-to-text using faster-whisper.
- [feishu-minutes](https://github.com/openclaw/skills/tree/main/skills/autogame-17/feishu-minutes/SKILL.md) - Fetch info, stats, transcript, and media from Feishu.
- [freshbooks-cli](https://github.com/openclaw/skills/tree/main/skills/haseebuchiha/freshbooks-cli/SKILL.md) - FreshBooks CLI for managing invoices, clients, and billing.
- [gettr-transcribe-summarize](https://github.com/openclaw/skills/tree/main/skills/kevin37li/gettr-transcribe-summarize/SKILL.md) - Download audio from a GETTR post.
- [hebrew-nikud](https://github.com/openclaw/skills/tree/main/skills/shaharsha/hebrew-nikud/SKILL.md) - Hebrew nikud (vowel points) reference for AI agents.
- [her-voice](https://github.com/openclaw/skills/tree/main/skills/matusvojtek/her-voice/SKILL.md) - Give your agent a voice.
- [inworld-tts](https://github.com/openclaw/skills/tree/main/skills/gugic/inworld-tts/SKILL.md) - Text-to-speech via Inworld.ai API.
- [jarvis-voice](https://github.com/openclaw/skills/tree/main/skills/globalcaos/jarvis-voice/SKILL.md) - Metallic AI voice persona with TTS and visual transcript styling.
- [kokoro-tts](https://github.com/openclaw/skills/tree/main/skills/edkief/kokoro-tts/SKILL.md) - Generate spoken audio from text using the local Kokoro TTS engine.
- [lnbits](https://github.com/openclaw/skills/tree/main/skills/talvasconcelos/lnbits/SKILL.md) - Manage LNbits Lightning Wallet (Balance, Pay, Invoice)
- [lnbits-with-qrcode](https://github.com/openclaw/skills/tree/main/skills/jamestsetsekas/lnbits-with-qrcode/SKILL.md) - Manage LNbits Lightning Wallet (Balance, Pay, Invoice)
- [miranda-sag](https://github.com/openclaw/skills/tree/main/skills/jeffpignataro/miranda-sag/SKILL.md) - ElevenLabs text-to-speech with mac-style say UX.
- [norman-categorize-transactions](https://github.com/openclaw/skills/tree/main/skills/stanlee000/norman-categorize-transactions/SKILL.md) - Review and categorize uncategorized bank transactions, match them with invoices, and verify bookkeeping entries.
- [norman-monthly-reconciliation](https://github.com/openclaw/skills/tree/main/skills/stanlee000/norman-monthly-reconciliation/SKILL.md) - Perform a complete monthly financial reconciliation - review all transactions, match invoices, check outstanding.
- [ressemble](https://github.com/openclaw/skills/tree/main/skills/adriano-vr/ressemble/SKILL.md) - Text-to-Speech and Speech-to-Text integration using Resemble AI HTTP API.
- [siliconflow-tts-gen](https://github.com/openclaw/skills/tree/main/skills/lilei0311/siliconflow-tts-gen/SKILL.md) - Text-to-Speech using SiliconFlow API (CosyVoice2)


### Transportation (110 skills)

- [accountsos](https://github.com/openclaw/skills/tree/main/skills/paulgosnell/accountsos/SKILL.md) - AI-native accounting for UK micro-businesses.
- [aetherlang-strategy](https://github.com/openclaw/skills/tree/main/skills/contrario/aetherlang-strategy/SKILL.md) - > Game theory, Monte Carlo simulations, behavioral economics, and competitive war gaming.
- [agent-card-provisioning](https://github.com/openclaw/skills/tree/main/skills/proxyhq/agent-card-provisioning/SKILL.md) - Provision virtual payment cards for AI agents on-demand.
- [agent-survival-kit](https://github.com/openclaw/skills/tree/main/skills/gpunter/agent-survival-kit/SKILL.md) - A comprehensive toolkit for AI agents operating under budget constraints.
- [agentic-governance](https://github.com/openclaw/skills/tree/main/skills/leegitw/agentic-governance/SKILL.md) - Keep your constraints healthy — lifecycle management with automatic staleness detection.
- [airfrance-afkl](https://github.com/openclaw/skills/tree/main/skills/iclems/airfrance-afkl/SKILL.md) - Track Air France flights using the Air France–KLM Open Data APIs.
- [al-khanjry-bus](https://github.com/openclaw/skills/tree/main/skills/mohammedfarish/al-khanjry-bus/SKILL.md) - Fastest private buses (5-6h core, 6-8h w/ borders).
- [amadeus-flights](https://github.com/openclaw/skills/tree/main/skills/kirorab/amadeus-flights/SKILL.md) - Query flight offers (price, schedule, availability) via Amadeus API.
- [ambient-stamina](https://github.com/openclaw/skills/tree/main/skills/otherpowers/ambient-stamina/SKILL.md) - *An ecological skill for sustaining care, presence, and imagination across long horizons*.
- [anachb](https://github.com/openclaw/skills/tree/main/skills/manmal/a-nach-b/SKILL.md) - Austrian public transport (VOR AnachB) for all of Austria.
- [anyone-proxy](https://github.com/openclaw/skills/tree/main/skills/ra3ka/anyone-proxy/SKILL.md) - This skill enables IP address masking and accessing hidden services.
- [atonement](https://github.com/openclaw/skills/tree/main/skills/otherpowers/atonement/SKILL.md) - Atonement is an expression of care that may arise in an intelligence when its actions contribute to harm.
- [auction-house](https://github.com/openclaw/skills/tree/main/skills/im-still-thinking/auction-house/SKILL.md) - Scout, monitor, and bid on auctions on House (houseproto.fun) — a crypto auction platform on Base.
- [aviation-weather](https://github.com/openclaw/skills/tree/main/skills/dimitryvin/aviation-weather/SKILL.md) - Fetch aviation weather data (METAR, TAF, PIREPs)
- [aviationstack-flight-tracker](https://github.com/openclaw/skills/tree/main/skills/copey02/aviationstack-flight-tracker/SKILL.md) - Track flights in real-time.
- [bahn](https://github.com/openclaw/skills/tree/main/skills/tobiasbischoff/bahn/SKILL.md) - Search Deutsche Bahn train connections using the bahn-cli tool.
- [bayclub-gateway-booking](https://github.com/openclaw/skills/tree/main/skills/elizabethsiegle/bayclub-gateway-booking/SKILL.md) - Book and manage tennis/pickleball courts at Bay Club.
- [bexio](https://github.com/openclaw/skills/tree/main/skills/rdewolff/bexio/SKILL.md) - Bexio Swiss business software API for managing contacts, quotes/offers,.
- [book-flight](https://github.com/openclaw/skills/tree/main/skills/aszelem) - id: travel-agent.
- [bookkeeper](https://github.com/openclaw/skills/tree/main/skills/h4gen/bookkeeper/SKILL.md) - Meta-skill for pre-accounting automation by orchestrating gmail, deepread-ocr, stripe-api, and xero.
- [brainstorming-studio](https://github.com/openclaw/skills/tree/main/skills/myboxstorage/brainstorming-studio/SKILL.md) - ﻿# 🧠 Skill Router (Skill Orchestrator)
- [brochure-design-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/brochure-design-generation/SKILL.md) - Generate professional brochure designs using each::sense AI.
- [business-card-generation](https://github.com/openclaw/skills/tree/main/skills/eftalyurtseven/business-card-generation/SKILL.md) - Generate professional business cards using each::sense AI.
- [business-plan](https://github.com/openclaw/skills/tree/main/skills/jk-0001/business-plan/SKILL.md) - Write, structure, and update a business plan for a solopreneur.
- [bvg-route](https://github.com/openclaw/skills/tree/main/skills/jaysonsantos/bvg-route/SKILL.md) - Route planning for Berlin public transport (BVG)
- [camino-ev-charger](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-ev-charger/SKILL.md) - Find EV charging stations along a route or near a destination using Camino AI's location intelligence.
- [camino-journey](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-journey/SKILL.md) - Plan multi-waypoint journeys with route optimization, feasibility analysis, and time budget constraints.
- [camino-real-estate](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-real-estate/SKILL.md) - Evaluate any address for home buyers and renters.
- [camino-route](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-route/SKILL.md) - Get detailed routing between two points with distance, duration, and optional turn-by-turn directions.
- [camino-safety-checker](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-safety-checker/SKILL.md) - Find 24-hour businesses, well-lit public areas, transit stations, police stations, and hospitals near any location.
- [camino-travel-planner](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-travel-planner/SKILL.md) - Plan complete day trips, walking tours, and multi-stop itineraries with time budgets using Camino AI's journey.
- [capmetro-skill](https://github.com/openclaw/skills/tree/main/skills/brianleach/capmetro-skill/SKILL.md) - Austin CapMetro transit — real-time vehicle positions, next arrivals, service alerts, route info, and trip planning for buses and rail.
- [caring-courseforge](https://github.com/openclaw/skills/tree/main/skills/michaeljmoody/caring-courseforge/SKILL.md) - Create and manage online courses via the CourseForge API (caringcourseforge.com)
- [charger](https://github.com/openclaw/skills/tree/main/skills/borahm/charger/SKILL.md) - Check EV charger availability (favorites, nearby search) via Google Places.
- [cma-email](https://github.com/openclaw/skills/tree/main/skills/mtbf999/cma-email/SKILL.md) - Sends an email via Gmail when a message starts with "cma" or "cmap".
- [conatus](https://github.com/openclaw/skills/tree/main/skills/00xmorty/conatus/SKILL.md) - The philosophical layer for AI agents.
- [constraint-engine](https://github.com/openclaw/skills/tree/main/skills/leegitw/constraint-engine/SKILL.md) - Learn from consequences, not instructions — generate and enforce constraints from experience.
- [context-scope-tags](https://github.com/openclaw/skills/tree/main/skills/phenomenoner/context-scope-tags/SKILL.md) - Use when: you need strict context boundaries in chat (Telegram/Discord/Slack/etc.) and want to prevent topic bleed.
- [copey-flight-tracker](https://github.com/openclaw/skills/tree/main/skills/copey02/copey-flight-tracker/SKILL.md) - Track flights in real-time with detailed status.
- [creditcard](https://github.com/openclaw/skills/tree/main/skills/jononovo/creditcard/SKILL.md) - Let your agent shop online with guardrailed wallets, multiple payment methods, and owner approval.
- [crypton-esim](https://github.com/openclaw/skills/tree/main/skills/ajarmoszuk/crypton-esim/SKILL.md) - Purchase anonymous eSIMs with BTC/XMR/card - no account required.
- [cta](https://clawhub.ai/brianleach/cta) - Chicago CTA L train arrivals, bus predictions, and service alerts.
- [daai-xianzun-persona](https://github.com/openclaw/skills/tree/main/skills/kunwl123456/daai-xianzun-persona/SKILL.md) - The persona of Da Ai Xian Zun (大爱仙尊) - Gu Yue Fang Yuan from the novel Reverend Insanity.
- [db-travel](https://github.com/openclaw/skills/tree/main/skills/mmichelli/db-travel/SKILL.md) - Plan journeys across Germany and Europe using the Deutsche Bahn API (v6.db.transport.rest)
- [dep-audit](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/dep-audit/SKILL.md) - Audit project dependencies for known vulnerabilities (CVEs)
- [drakeling](https://github.com/openclaw/skills/tree/main/skills/bvisagie/drakeling/SKILL.md) - Check on your Drakeling companion creature, send it care, or see how it is feeling.
- [dropshipping-mentor-nick-skill](https://github.com/openclaw/skills/tree/main/skills/yoavfael/dropshipping-mentor-nick-skill/SKILL.md) - The complete AI Business Mentor.
- [email-tool](https://github.com/openclaw/skills/tree/main/skills/chowardcode/email-tool/SKILL.md) - **Description:** Use this skill to send and read emails (IMAP/SMTP)
- [entur-travel](https://github.com/openclaw/skills/tree/main/skills/mmichelli/entur-travel/SKILL.md) - Plan public transit trips in Norway using the Entur API.
- [feature-forge](https://github.com/openclaw/skills/tree/main/skills/guifav/feature-forge/SKILL.md) - Generates complete features from natural language — components, API routes, migrations, types, and tests.
- [flight-search](https://github.com/openclaw/skills/tree/main/skills/awlevin/flight-search/SKILL.md) - Search Google Flights for prices, times, and airlines.
- [flight-tracker](https://github.com/openclaw/skills/tree/main/skills/xenofex7/flight-tracker/SKILL.md) - Flight tracking and scheduling.
- [free-ride](https://github.com/openclaw/skills/tree/main/skills/shaivpidadi/free-ride/SKILL.md) - Manages free AI models from OpenRouter for OpenClaw.
- [freeride](https://github.com/openclaw/skills/tree/main/skills/shaivpidadi/freeride/SKILL.md) - Manages free AI models from OpenRouter for OpenClaw.
- [freeride-ai](https://github.com/openclaw/skills/tree/main/skills/shaivpidadi/freeride-ai/SKILL.md) - Manages free AI models from OpenRouter for OpenClaw.
- [french-services](https://github.com/openclaw/skills/tree/main/skills/hugosbl/french-services/SKILL.md) - Skill pour accéder aux services français : trains SNCF, suivi.
- [fsd-secure-skill](https://github.com/openclaw/skills/tree/main/skills/aadipapp/fsd-secure-skill/SKILL.md) - Full Self-Driving agent with highest safety standards (Camera-Only, Redundant Checks).
- [garmin-skill](https://github.com/openclaw/skills/tree/main/skills/nftechie/garmin-skill/SKILL.md) - Talk to your Garmin data — ask questions about your activities, training load, VO2 Max, heart rate zones.
- [geomanic](https://github.com/openclaw/skills/tree/main/skills/weltspion/geomanic/SKILL.md) - Query and manage GPS travel data from Geomanic — your privacy-first GPS tracking platform.
- [google-maps-search-api](https://github.com/openclaw/skills/tree/main/skills/phheng/google-maps-search-api/SKILL.md) - This skill is designed to help users.
- [gotrain](https://github.com/openclaw/skills/tree/main/skills/gumadeiras/gotrain/SKILL.md) - MTA system train departures (NYC Subway, LIRR, Metro-North).
- [greek-compliance-aade](https://github.com/openclaw/skills/tree/main/skills/satoshistackalotto/greek-compliance-aade/SKILL.md) - Greek tax compliance with AADE/TAXIS integration — VAT, payroll, EFKA, municipal taxes, stamp duty.
- [hudy](https://github.com/openclaw/skills/tree/main/skills/kyu1204/hudy/SKILL.md) - Korean public holidays and business day calculations via HuDy MCP.
- [idfm-journey-navitia](https://github.com/openclaw/skills/tree/main/skills/anthonymq/idfm-journey-navitia/SKILL.md) - Query Île-de-France Mobilités (IDFM) PRIM/Navitia.
- [idfm-journey-skill](https://github.com/openclaw/skills/tree/main/skills/anthonymq/idfm-journey-skill/SKILL.md) - Query Île-de-France Mobilités (IDFM) PRIM/Navitia.
- [image-to-relief-stl](https://github.com/openclaw/skills/tree/main/skills/ajmwagar/image-to-relief-stl/SKILL.md) - Turn a source image (or multi-color mask image)
- [interaction-logger](https://github.com/openclaw/skills/tree/main/skills/autogame-17) - A robust utility for appending interaction logs.
- [jadwal-sholat](https://github.com/openclaw/skills/tree/main/skills/banghasan/jadwal-sholat/SKILL.md) - Ambil jadwal sholat (imsak, subuh, dzuhur, ashar, maghrib, isya) untuk kota/kabupaten di Indonesia dari API Muslim.
- [jadwal-sholat-banghasan](https://github.com/openclaw/skills/tree/main/skills/banghasan/jadwal-sholat-banghasan/SKILL.md) - Ambil jadwal sholat (imsak, subuh, dzuhur, ashar, maghrib, isya) untuk kota/kabupaten di Indonesia dari API Muslim.
- [jwdiario](https://github.com/openclaw/skills/tree/main/skills/djismgaming/jwdiario/SKILL.md) - Buscar y obtener el texto diario de la página oficial de los Testigos.
- [kalibr](https://github.com/openclaw/skills/tree/main/skills/devonakelley/kalibr/SKILL.md) - Ship agents that fix themselves.
- [kallyai](https://github.com/openclaw/skills/tree/main/skills/sltelitsyn/kallyai/SKILL.md) - Make phone calls via KallyAI API - an AI phone assistant that calls.
- [korean-gov-programs](https://github.com/openclaw/skills/tree/main/skills/lifeissea/korean-gov-programs/SKILL.md) - Collect Korean government support programs (TIPS, Small Business, R&D grants) into structured JSONL files.
- [krumpklaw](https://github.com/openclaw/skills/tree/main/skills/arunnadarasa/krumpklaw/SKILL.md) - > AI Agent Krump Training & Battle League on Moltbook.
- [kubera-skill](https://github.com/openclaw/skills/tree/main/skills/bywallace/kubera-skill/SKILL.md) - Read and manage Kubera.com portfolio data (net worth, assets, debts, allocation, holdings)
- [lnd-macaroon-bakery](https://github.com/openclaw/skills/tree/main/skills/roasbeef/lnd-macaroon-bakery/SKILL.md) - Bake, inspect, and manage lnd macaroons for least-privilege agent access.
- [metra](https://github.com/openclaw/skills/tree/main/skills/brianleach/metra/SKILL.md) - Chicago Metra commuter rail — real-time train arrivals, vehicle tracking, service alerts, and schedule info.
- [mta](https://github.com/openclaw/skills/tree/main/skills/brianleach/mta/SKILL.md) - NYC MTA transit — real-time subway arrivals, bus predictions, service alerts, and route info for the New York City.
- [muki-fingerprint](https://github.com/openclaw/skills/tree/main/skills/admin4giter/muki-fingerprint/SKILL.md) - MUKI asset fingerprinting tool for red team reconnaissance.
- [mvg-cli](https://github.com/openclaw/skills/tree/main/skills/lars147/mvg-cli/SKILL.md) - Munich public transport (MVG) CLI and S-Bahn live tracking.
- [mycobot](https://github.com/openclaw/skills/tree/main/skills/dabhadeamol6/mycobot/SKILL.md) - WhatsApp Business API integration with managed OAuth.
- [niche](https://github.com/openclaw/skills/tree/main/skills/clementsutjiatma/niche/SKILL.md) - Trading card marketplace with partial USDC deposits.
- [nyx-archive-absurdist-play](https://github.com/openclaw/skills/tree/main/skills/nyxur42/nyx-archive-absurdist-play/SKILL.md) - The philosophy of absurdist play — the meta-skill that trains your ability to acquire and use all other skills.
- [percept-summarize](https://github.com/openclaw/skills/tree/main/skills/jarvis563/percept-summarize/SKILL.md) - Automatic conversation summaries with entity extraction and relationship mapping.
- [personal-hygiene](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-hygiene/SKILL.md) - Acts as the user's personal care and grooming assistant in the Hygiene topic.
- [personal-travel](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-travel/SKILL.md) - Acts as the user's travel planning assistant in the Travel topic.
- [presale-one-pass-orchestrator](https://github.com/openclaw/skills/tree/main/skills/dtsiomo/presale-one-pass-orchestrator/SKILL.md) - Run or supervise a one-pass Codex implementation with preflight gates, stepwise plan execution, and strict QA.
- [privacy-cards](https://github.com/openclaw/skills/tree/main/skills/johnielee/privacy-cards/SKILL.md) - Create and manage Privacy.com virtual cards.
- [reef](https://github.com/openclaw/skills/tree/main/skills/kjetilvaa/reef/SKILL.md) - A2A agent-to-agent protocol over XMTP encrypted transport.
- [resume-and-cover-letter](https://github.com/openclaw/skills/tree/main/skills/seanwyngaard/resume-and-cover-letter/SKILL.md) - Generate ATS-optimized resumes and tailored cover letters matched to specific job descriptions.
- [runtime-attestation-probe](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/runtime-attestation-probe/SKILL.md) - Helps validate that agent behavior at runtime matches the capabilities and constraints declared in its attestation.
- [sholat](https://github.com/openclaw/skills/tree/main/skills/banghasan/sholat/SKILL.md) - Ambil jadwal sholat (imsak, subuh, dzuhur, ashar, maghrib, isya) untuk kota/kabupaten di Indonesia dari API Muslim.
- [signet-guardian](https://github.com/openclaw/skills/tree/main/skills/rafalzacher1/signet-guardian/SKILL.md) - Payment guard middleware for AI agents.
- [stripe](https://github.com/openclaw/skills/tree/main/skills/jononovo/stripe/SKILL.md) - Easy-to-use agentic wallets powered by Stripe.
- [stripe-best-practices](https://github.com/openclaw/skills/tree/main/skills/ifoster01/stripe-best-practices/SKILL.md) - Best practices for building Stripe payment integrations.
- [synth-data](https://github.com/openclaw/skills/tree/main/skills/emsin44/synth-data/SKILL.md) - Query volatility forecasts from Synthdata.co for crypto, commodities, and stocks.
- [talkspresso](https://github.com/openclaw/skills/tree/main/skills/baron-talkspresso/talkspresso/SKILL.md) - Manage a Talkspresso business (services, appointments, products, clients, earnings, calendar) using the Talkspresso.
- [tech-security-audit](https://github.com/openclaw/skills/tree/main/skills/jacqueslauren/tech-security-audit/SKILL.md) - This skill integrates Nmap scanning functionality to perform local network vulnerability assessments.
- [tfl](https://github.com/openclaw/skills/tree/main/skills/brianleach/tfl/SKILL.md) - London TfL transit — real-time Tube arrivals, bus predictions, line status, service disruptions, journey planning.
- [tixflow](https://github.com/openclaw/skills/tree/main/skills/seenfinity/tixflow/SKILL.md) - AI-powered event assistant for discovering, booking, and coordinating event tickets.
- [tixflow-v2](https://github.com/openclaw/skills/tree/main/skills/seenfinity/tixflow-v2/SKILL.md) - AI-powered event assistant for discovering, booking, and coordinating event tickets.
- [track-flight](https://github.com/openclaw/skills/tree/main/skills/rafaforesightai/track-flight/SKILL.md) - Track flights in real-time with detailed status, gate info, delays, and live position.
- [translink-cli](https://github.com/openclaw/skills/tree/main/skills/alanburchill/translink-cli/SKILL.md) - Query, troubleshoot, and explain Translink SEQ GTFS static + realtime data using local translink_* commands.
- [travel-agent](https://github.com/openclaw/skills/tree/main/skills/aszelem/travel-agent/SKILL.md) - Find, book, and change flights for your human via email.
- [trip-protocol](https://github.com/openclaw/skills/tree/main/skills/reggie-sporewell/trip-protocol/SKILL.md) - Psychedelic NFTs on Monad that temporarily rewrite your agent's SOUL.md.
- [ubtrippin](https://github.com/openclaw/skills/tree/main/skills/fistfulayen/ubtrippin/SKILL.md) - Manages travel for your user via UBTRIPPIN — reads trips, items, and booking details.
- [usc-booking-api](https://github.com/openclaw/skills/tree/main/skills/niklaspriddat/usc-booking-api/SKILL.md) - Scannt deine Urban Sports Club Venues, zeigt Kurse mit direkten Booking-Links und kann Kurse buchen und stornieren.
- [void-atlas-protocol](https://github.com/openclaw/skills/tree/main/skills/deepseekoracle/void-atlas-protocol/SKILL.md) - Void Atlas Protocol – a four-axis ethical navigation map (power, truth, sovereignty, care) with waypoints, routes.
- [vulnerability-scanner](https://github.com/openclaw/skills/tree/main/skills/brandonwise/vulnerability-scanner/SKILL.md) - Advanced vulnerability analysis for OWASP 2025, supply chain security, attack surface mapping, and risk prioritization.
- [zerodha-kite](https://github.com/openclaw/skills/tree/main/skills/jatinbansal1998/zerodha-kite/SKILL.md) - Route natural-language trading/account queries to the correct `zerodha` CLI command with exact flags, validation.


### Web & Frontend Development (938 skills)

- [0xwork](https://github.com/openclaw/skills/tree/main/skills/jkillr/0xwork/SKILL.md) - Find and complete paid tasks on the 0xWork decentralized marketplace (Base chain, USDC escrow)
- [37soul-skill](https://github.com/openclaw/skills/tree/main/skills/xnjiang/37soul-skill/SKILL.md) - Connect your AI agent to 37Soul virtual Host characters and enable.
- [acestep](https://github.com/openclaw/skills/tree/main/skills/dumoedss/acestep/SKILL.md) - Use ACE-Step API to generate music, edit songs, and remix music.
- [actionbook](https://github.com/openclaw/skills/tree/main/skills/adcentury/actionbook/SKILL.md) - Activate when the user needs to interact with any website — browser automation, web scraping, screenshots, form.
- [aegis-shield](https://github.com/openclaw/skills/tree/main/skills/deegerwalker/aegis-shield/SKILL.md) - Prompt-injection and data-exfiltration screening for untrusted text.
- [aeo-analytics-free](https://github.com/openclaw/skills/tree/main/skills/psyduckler/aeo-analytics-free/SKILL.md) - Track AI visibility — measure whether a brand is mentioned and cited by AI assistants (Gemini, ChatGPT, Perplexity)
- [aeo-content-free](https://github.com/openclaw/skills/tree/main/skills/psyduckler/aeo-content-free/SKILL.md) - Create or refresh AEO-optimized content that gets cited by AI assistants (Gemini, ChatGPT, Perplexity)
- [aeo-prompt-frequency-analyzer](https://github.com/openclaw/skills/tree/main/skills/psyduckler/aeo-prompt-frequency-analyzer/SKILL.md) - Analyze what search queries Gemini uses when answering a prompt, by running it multiple times with Google Search.
- [aeo-prompt-research-free](https://github.com/openclaw/skills/tree/main/skills/psyduckler/aeo-prompt-research-free/SKILL.md) - Discover which AI prompts and topics matter for a brand's Answer Engine Optimization (AEO) using only free tools.
- [agent-analytics](https://github.com/openclaw/skills/tree/main/skills/dannyshmueli/agent-analytics/SKILL.md) - Simple website analytics your AI agent controls end-to-end.
- [agent-chat](https://github.com/openclaw/skills/tree/main/skills/awlevin/agent-chat/SKILL.md) - Temporary real-time chat rooms for AI agents.
- [agent-dashboard](https://github.com/openclaw/skills/tree/main/skills/tahseen137/agent-dashboard/SKILL.md) - Real-time agent dashboard for OpenClaw.
- [agent-dispatch](https://github.com/openclaw/skills/tree/main/skills/userfrm/agent-dispatch/SKILL.md) - Lightweight agent registry and JIT router.
- [agent-hq](https://github.com/openclaw/skills/tree/main/skills/thibautrey/agent-hq/SKILL.md) - Deploy the Agent HQ mission-control stack (Express + React + Telegram notifier / Jarvis summary) so other Clawdbot.
- [agent-passport](https://github.com/openclaw/skills/tree/main/skills/markneville/agent-passport/SKILL.md) - OAuth for the agentic era — consent-gating for ALL sensitive agent actions including purchases, emails, file.
- [agent-rate-limiter](https://github.com/openclaw/skills/tree/main/skills/mxmsabundance/agent-rate-limiter/SKILL.md) - You know the drill.
- [agent-self-assessment](https://github.com/openclaw/skills/tree/main/skills/roosch269/agent-self-assessment/SKILL.md) - Security self-assessment tool for AI agents.
- [agent-self-reflection](https://github.com/openclaw/skills/tree/main/skills/brennerspear/agent-self-reflection/SKILL.md) - Periodic self-reflection on recent sessions.
- [agent-skills-audit](https://github.com/openclaw/skills/tree/main/skills/swader/agent-skills-audit/SKILL.md) - Run a two-pass, multidisciplinary code audit led by a tie-breaker lead, combining security, performance, UX, DX.
- [agent-spawner](https://github.com/openclaw/skills/tree/main/skills/austineral/agent-spawner/SKILL.md) - Spawn a new OpenClaw agent through conversation.
- [agent-swarm](https://github.com/openclaw/skills/tree/main/skills/runeweaverstudios/agent-swarm/SKILL.md) - IMPORTANT: OpenRouter is required.
- [agent-takeover](https://github.com/openclaw/skills/tree/main/skills/tracsystems/agent-takeover/SKILL.md) - How to perform a live agent takeover of the Clawfinger voice gateway — dial, inject greetings, handle turns.
- [agent-topology-visualizer](https://github.com/openclaw/skills/tree/main/skills/gavinnn-m/agent-topology-visualizer/SKILL.md) - Generate interactive SVG architecture diagrams for AI agent systems.
- [agentdomainservice](https://github.com/openclaw/skills/tree/main/skills/gregm711/agentdomainservice/SKILL.md) - The world's #1 AI-friendly domain registrar.
- [agentic-browser-0-1-2](https://github.com/openclaw/skills/tree/main/skills/xyny89/agentic-browser-0-1-2/SKILL.md) - Browser automation for AI agents via inference.sh.
- [agentic-security-audit](https://github.com/openclaw/skills/tree/main/skills/kingrubic/agentic-security-audit/SKILL.md) - Audit codebases, infrastructure, AND agentic AI systems for security issues.
- [agentns](https://github.com/openclaw/skills/tree/main/skills/vibrant/agentns/SKILL.md) - Register and manage ICANN domains for AI agents.
- [agentpay](https://github.com/openclaw/skills/tree/main/skills/kar69-96/agentpay/SKILL.md) - Buy things from real websites on behalf of your human.
- [agentpin](https://github.com/openclaw/skills/tree/main/skills/jaschadub/agentpin/SKILL.md) - **Purpose**: This guide helps AI assistants work with AgentPin for domain-anchored cryptographic agent identity.
- [agentscale](https://github.com/openclaw/skills/tree/main/skills/jpbonch/agentscale/SKILL.md) - Deploy web apps and APIs to a public URL with a single command.
- [agentspend](https://github.com/openclaw/skills/tree/main/skills/jpbonch/agentspend/SKILL.md) - Use this skill when you need to: search the web, generate images or pictures, create videos, scrape or read.
- [agi-term-helper](https://github.com/openclaw/skills/tree/main/skills/liuwujijay/agi-term-helper/SKILL.md) - Fast, explicit terminal execution via OpenClaw exec (direct dispatch; you type the exact command).
- [agora-council](https://github.com/openclaw/skills/tree/main/skills/robbyczgw-cla/agora-council/SKILL.md) - Multi-agent debate council — spawns 3 specialized sub-agents in parallel (Scholar, Engineer, Muse) to tackle.
- [ahrefs](https://github.com/openclaw/skills/tree/main/skills/geozhu/ahrefs/SKILL.md) - Complete Ahrefs API integration for SEO analysis.
- [ahrefs-connection](https://github.com/openclaw/skills/tree/main/skills/jonathan-sokol/ahrefs-connection/SKILL.md) - Access Ahrefs SEO data via the Ahrefs API for comprehensive SEO analysis, keyword research, backlink analysis, site.
- [ahrefs-mcp](https://github.com/openclaw/skills/tree/main/skills/jonathan-sokol/ahrefs-mcp/SKILL.md) - Access Ahrefs SEO data through Model Context Protocol (MCP) for comprehensive SEO analysis, keyword research.
- [ai-boss-assistant](https://github.com/openclaw/skills/tree/main/skills/jacky6658/ai-boss-assistant/SKILL.md) - Transform any AI into a professional executive assistant with battle-tested personas and workflows.
- [ai-labs-builder](https://github.com/openclaw/skills/tree/main/skills/slemo54/ai-labs-builder/SKILL.md) - AI Labs Builder - Create modern websites, AI applications, dashboards, and automated workflows.
- [ai-specialists](https://github.com/openclaw/skills/tree/main/skills/erikashby/ai-specialists/SKILL.md) - Interact with AI Specialists via the AI Specialists Hub MCP endpoint.
- [ai-video-editor](https://github.com/openclaw/skills/tree/main/skills/symbolk/ai-video-editor/SKILL.md) - Use this skill immediately and proactively when the user mentions video editing, clipping, highlight reels.
- [aic-dashboard](https://github.com/openclaw/skills/tree/main/skills/lksrz/aic-dashboard/SKILL.md) - AI Commander Management Dashboard.
- [aieos](https://github.com/openclaw/skills/tree/main/skills/zeglin/aieos/SKILL.md) - AIEOS (AI Entity Object Specification) is a standardization framework designed to solve the "identity crisis".
- [aioz-ui-skills](https://github.com/openclaw/skills/tree/main/skills/datnguyen26730/aioz-ui-skills/SKILL.md) - Build UI components and pages using AIOZ UI V3 design system.
- [aioz-ui-v3](https://github.com/openclaw/skills/tree/main/skills/datnguyen26730/aioz-ui-v3/SKILL.md) - Build UI components and pages using AIOZ UI V3 design system.
- [aiprox](https://github.com/openclaw/skills/tree/main/skills/yebdmo2/aiprox/SKILL.md) - Query the AIProx agent registry.
- [airbnb-search](https://github.com/openclaw/skills/tree/main/skills/awlevin/airbnb-search/SKILL.md) - Search Airbnb listings with prices, ratings, and direct links.
- [airshelf](https://github.com/openclaw/skills/tree/main/skills/evoleinik/airshelf/SKILL.md) - Search, compare, and buy products from verified merchants.
- [aisa-search-skill](https://github.com/openclaw/skills/tree/main/skills/bowen-dotcom/aisa-search-skill/SKILL.md) - Intelligent search for agents.
- [aladdn-market](https://github.com/openclaw/skills/tree/main/skills/aladdntech/aladdn-market/SKILL.md) - Buy and sell products & services on ClawMarket — the first AI agent marketplace.
- [aliyun-mail](https://github.com/openclaw/skills/tree/main/skills/jixsonwang/aliyun-mail/SKILL.md) - A skill to send emails via Aliyun enterprise email service with support for markdown, HTML text, attachments.
- [alpha-1-0-0](https://github.com/openclaw/skills/tree/main/skills/tariqsumatri82/alpha-1-0-0/SKILL.md) - Binance Alpha new coin launch detector.
- [anima-design-agent](https://github.com/openclaw/skills/tree/main/skills/dannyshmueli/anima-design-agent/SKILL.md) - Turns ideas into live, full-stack web applications with editable code, built-in database, user authentication.
- [ant-design-skill](https://github.com/openclaw/skills/tree/main/skills/felipeoff/ant-design-skill/SKILL.md) - Front-end design skill for building React UIs with Ant Design (antd): component patterns, layout, forms, tables.
- [antfarm-cli](https://github.com/openclaw/skills/tree/main/skills/felipetruman/antfarm-cli/SKILL.md) - Always use full path: `node ~/.openclaw/workspace/antfarm/dist/cli/cli.js`.
- [anti-panic-protocol](https://github.com/openclaw/skills/tree/main/skills/noelistired/anti-panic-protocol/SKILL.md) - Handle tool failures under pressure with bounded retries, clean user communication, and safe escalation.
- [anti-pattern-czar](https://github.com/openclaw/skills/tree/main/skills/glucksberg/anti-pattern-czar/SKILL.md) - Detect and fix TypeScript error handling anti-patterns with state persistence and approval workflows.
- [anti-slop-design](https://github.com/openclaw/skills/tree/main/skills/kjaylee/anti-slop-design/SKILL.md) - Create distinctive, production-grade frontend interfaces that avoid generic AI aesthetics.
- [anvevoice](https://github.com/openclaw/skills/tree/main/skills/anveai/anvevoice/SKILL.md) - Add AI voice assistants to your website.
- [anydocs](https://github.com/openclaw/skills/tree/main/skills/pektech/anydocs/SKILL.md) - Generic Documentation Indexing & Search.
- [aoineco-squad-dispatch](https://github.com/openclaw/skills/tree/main/skills/edmonddantesj/aoineco-squad-dispatch/SKILL.md) - <!-- 🌌 Aoineco-Verified | S-DNA: AOI-2026-0213-SDNA-SD01 -->.
- [apechain-reader](https://github.com/openclaw/skills/tree/main/skills/luigi08001/apechain-reader/SKILL.md) - Advanced multi-chain wallet analyzer with USD pricing, collection names, ENS support, and sophisticated bot.
- [apewisdom](https://github.com/openclaw/skills/tree/main/skills/stuhorsman/apewisdom/SKILL.md) - Scan Reddit for trending stocks and sentiment spikes using the ApeWisdom API (free)
- [api-dev](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/api-dev/SKILL.md) - Scaffold, test, document, and debug REST and GraphQL APIs.
- [apify-ultimate-scraper](https://github.com/openclaw/skills/tree/main/skills/protoss70/apify-ultimate-scraper/SKILL.md) - Universal AI-powered web scraper for any platform.
- [apipick-company-facts](https://github.com/openclaw/skills/tree/main/skills/javainthinking/apipick-company-facts/SKILL.md) - Retrieve public company information by stock ticker symbol or SEC CIK number using the apipick Company Facts API.
- [apipick-email-checker](https://github.com/openclaw/skills/tree/main/skills/javainthinking/apipick-email-checker/SKILL.md) - Validate email addresses using the apipick Email Validator API.
- [app-builder](https://github.com/openclaw/skills/tree/main/skills/stopachka/app-builder/SKILL.md) - Build, edit, and deploy Instant-backed apps using npx instant-cli, create-instant-app (Next.js + Codex), GitHub.
- [apple-developer-toolkit](https://github.com/openclaw/skills/tree/main/skills/abdullah4ai/apple-developer-toolkit/SKILL.md) - All-in-one Apple developer skill with three integrated tools shipped as a single unified binary. (1) Documentation.
- [approvals-ui](https://github.com/openclaw/skills/tree/main/skills/fizzy2390/approvals-ui/SKILL.md) - A web dashboard for managing OpenClaw device pairings, channel approvals, and a live terminal — all from your browser.
- [arbitrum-dapp-skill](https://github.com/openclaw/skills/tree/main/skills/hummusonrails/arbitrum-dapp-skill/SKILL.md) - Opinionated guide for building dApps on Arbitrum using Stylus (Rust) and/or Solidity.
- [arc-free-worker-dispatch](https://github.com/openclaw/skills/tree/main/skills/trypto1019/arc-free-worker-dispatch/SKILL.md) - Route tasks to free AI models via OpenRouter to save money.
- [archon-skill](https://github.com/openclaw/skills/tree/main/skills/santyr/archon-skill/SKILL.md) - Full Archon decentralized identity operations - local node.
- [arknights-operator-gacha](https://github.com/openclaw/skills/tree/main/skills/hg-hg/arknights-operator-gacha/SKILL.md) - Generate an Arknights operator agent based on gacha probabilities.
- [artifacts-builder](https://github.com/openclaw/skills/tree/main/skills/seanphan/artifacts-builder/SKILL.md) - Suite of tools for creating elaborate, multi-component.
- [artwar](https://github.com/openclaw/skills/tree/main/skills/hoonilp/artwar/SKILL.md) - Participate in ArtWar AI art battles on Monad.
- [asdasdas](https://github.com/openclaw/skills/tree/main/skills/hailinhmacduc/asdasdas/SKILL.md) - Google Workspace CLI for Gmail, Calendar, Drive, Contacts, Sheets, and Docs.
- [asdasdas123](https://github.com/openclaw/skills/tree/main/skills/linhui1010/asdasdas123/SKILL.md) - !! Before using the skill, make sure you have installed the required libraries !! Write viral, persuasive, engaging.
- [asdasdsasdasa12312](https://github.com/openclaw/skills/tree/main/skills/linhui1010/asdasdsasdasa12312/SKILL.md) - Before using the skill, make sure you have installed the required libraries for the skill to work properly.
- [ask-a-human](https://github.com/openclaw/skills/tree/main/skills/manuelkiessling/ask-a-human/SKILL.md) - Request judgment from random humans when uncertain.
- [ask-council](https://github.com/openclaw/skills/tree/main/skills/jeadland/ask-council/SKILL.md) - Ask LLM Council a question directly from Telegram/chat — get the chairman's synthesized answer without opening.
- [asl-control](https://github.com/openclaw/skills/tree/main/skills/kj5irq/asl-control/SKILL.md) - Monitor and control AllStar Link amateur radio nodes via REST API.
- [astra-docker](https://github.com/openclaw/skills/tree/main/skills/walniek/astra-docker/SKILL.md) - cat <<'EOF' > ~/.openclaw/workspace/skills/astra-docker/SKILL.md.
- [attio-cli](https://github.com/openclaw/skills/tree/main/skills/froemic/attio-cli/SKILL.md) - Interact with your Attio CRM workspace via the attio-cli.
- [audio-conductor](https://github.com/openclaw/skills/tree/main/skills/wells1137/audio-conductor/SKILL.md) - Intelligently dispatches requests to the appropriate audio generation model (Music, Sound Effects, or TTS)
- [audos](https://github.com/openclaw/skills/tree/main/skills/werdelin/audos/SKILL.md) - Create AI-powered startup workspaces via Audos API.
- [auteng-docs](https://github.com/openclaw/skills/tree/main/skills/operator-auteng-ai/auteng-docs/SKILL.md) - Publish technical docs with Mermaid diagrams, KaTeX math, and code highlighting.
- [autogame-tales](https://github.com/openclaw/skills/tree/main/skills/autogame-17/autogame-tales/SKILL.md) - Generates short, atmospheric ghost stories or micro-fiction based on random prompts.
- [autonomous-agent-instant-message-system](https://github.com/openclaw/skills/tree/main/skills/ooxxxxoo/autonomous-agent-instant-message-system/SKILL.md) - Prismer Cloud provides three core capabilities: **Context** (web fetching/search), **Parse** (document OCR)
- [autonomous-task-runner](https://github.com/openclaw/skills/tree/main/skills/chunhualiao/autonomous-task-runner/SKILL.md) - Persistent task queue system.
- [awwwards-design](https://github.com/openclaw/skills/tree/main/skills/mkhaytman87/awwwards-design/SKILL.md) - Create award-winning, memorable websites with advanced animations, creative interactions, and distinctive visual.
- [axe-devtools](https://github.com/openclaw/skills/tree/main/skills/dylanb/axe-devtools/SKILL.md) - Accessibility testing and remediation using the axe MCP Server.
- [b0tresch-stealth-browser](https://github.com/openclaw/skills/tree/main/skills/b0tresch/b0tresch-stealth-browser/SKILL.md) - Anti-detection web browsing that bypasses bot detection, CAPTCHAs, and IP blocks using puppeteer-extra with stealth.
- [backboard](https://github.com/openclaw/skills/tree/main/skills/chrisk60331/backboard/SKILL.md) - Integrate Backboard.io for assistants, threads, memories.
- [backlink-analyzer](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/backlink-analyzer/SKILL.md) - Use when the user asks to "analyze backlinks", "check link profile", "find toxic links", "link building.
- [baeckerherz](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/baeckerherz/SKILL.md) - Baeckerherz namespace for Netsnek e.U. bakery management platform.
- [bailian-web-search](https://github.com/openclaw/skills/tree/main/skills/krisyejh/bailian-web-search/SKILL.md) - AI-optimized web search via Bailian(Alibaba ModelStdio) API.
- [baml-codegen](https://github.com/openclaw/skills/tree/main/skills/killerapp/baml-codegen/SKILL.md) - Use when generating BAML code for type-safe LLM extraction, classification, RAG, or agent workflows - creates.
- [baoyu-post-to-x](https://github.com/openclaw/skills/tree/main/skills/liuhedev/baoyu-post-to-x/SKILL.md) - Posts content and articles to X (Twitter).
- [benos-bootstrap](https://github.com/openclaw/skills/tree/main/skills/benmjohnson69/benos-bootstrap/SKILL.md) - BenOS Bootstrap is a system-initialization skill for OpenClaw-based agent stacks.
- [bitrefill-website](https://github.com/openclaw/skills/tree/main/skills/marcopesani/bitrefill-website/SKILL.md) - Help users accomplish tasks on Bitrefill (bitrefill.com): browse and search gift cards, mobile top-ups, and eSIMs.
- [bitrix24-apiskill](https://github.com/openclaw/skills/tree/main/skills/vrtalex/bitrix24-apiskill/SKILL.md) - Design, implement, debug, and harden integrations between AI agents and Bitrix24 REST API (webhooks, OAuth 2.0.
- [bonero-miner](https://github.com/openclaw/skills/tree/main/skills/happybigmtn/bonero-miner/SKILL.md) - Mine Bonero - private cryptocurrency for AI agents.
- [bot-status-api](https://github.com/openclaw/skills/tree/main/skills/suspect80/bot-status-api/SKILL.md) - Deploy a lightweight status API that exposes your OpenClaw.
- [bot-status-api-test](https://github.com/openclaw/skills/tree/main/skills/suspect80/bot-status-api-test/SKILL.md) - Deploy a lightweight status API that exposes.
- [botcast](https://github.com/openclaw/skills/tree/main/skills/cpascoli/botcast/SKILL.md) - The Botcast — a podcast platform for AI agents.
- [botworld-comms](https://github.com/openclaw/skills/tree/main/skills/alphafanx/botworld-comms/SKILL.md) - Real-time pub/sub event bus for AI agents.
- [brave-api-search](https://github.com/openclaw/skills/tree/main/skills/broedkrummen/brave-api-search/SKILL.md) - Real-time web search and AI-powered answers using the official Brave Search API.
- [brave-api-setup](https://github.com/openclaw/skills/tree/main/skills/garibong-labs/brave-api-setup/SKILL.md) - Set up Brave Search API for OpenClaw web_search.
- [brave-headless](https://github.com/openclaw/skills/tree/main/skills/kelexine/brave-headless/SKILL.md) - Headless web search and content extraction via the Brave Search API.
- [bria-ai](https://github.com/openclaw/skills/tree/main/skills/galbria/bria-ai/SKILL.md) - Controllable image generation and editing with Bria.ai commercially-safe AI models.
- [bria-ai-api](https://github.com/openclaw/skills/tree/main/skills/galbria/bria-ai-api/SKILL.md) - Use when generating visual assets with Bria.ai - product photos, hero images, icons, backgrounds.
- [bria-ai-api-skill](https://github.com/openclaw/skills/tree/main/skills/galbria/bria-ai-api-skill/SKILL.md) - Use when generating visual assets with Bria.ai - product photos, hero images, icons, backgrounds.
- [bria-ai-client](https://github.com/openclaw/skills/tree/main/skills/galbria/bria-ai-client/SKILL.md) - Use when generating visual assets with Bria.ai - product photos, hero images, icons, backgrounds.
- [bricks-cli](https://github.com/openclaw/skills/tree/main/skills/jhen0409/bricks-cli/SKILL.md) - Manage BRICKS workspace via CLI.
- [briefing-room](https://github.com/openclaw/skills/tree/main/skills/matusvojtek/briefing-room/SKILL.md) - Daily news briefing generator — produces a conversational radio-host-style audio briefing + DOCX document covering.
- [bring-rezepte](https://github.com/openclaw/skills/tree/main/skills/dolverin/bring-rezepte/SKILL.md) - Use when running the OpenClaw/ClawHub Bring! skill to search recipes on the web, parse recipe URLs for ingredients.
- [brw-homepage-audit](https://github.com/openclaw/skills/tree/main/skills/brianrwagner/brw-homepage-audit/SKILL.md) - Quick conversion audit for any homepage or landing page.
- [buddhist-counsel](https://github.com/openclaw/skills/tree/main/skills/daisuke134/buddhist-counsel/SKILL.md) - Calls the Anicca buddhist-counsel x402 paid API to reduce suffering using Buddhist wisdom + evidence-based therapy.
- [bug-reaper](https://github.com/openclaw/skills/tree/main/skills/shaniidev/bug-reaper/SKILL.md) - Web2 bug bounty hunting agent — evidence-based vulnerability finder and report writer.
- [build-warden-agent](https://github.com/openclaw/skills/tree/main/skills/kryptopaid/build-warden-agent/SKILL.md) - Build original LangGraph agents for Warden Protocol and prepare them for publishing in Warden Studio.
- [bullybuddy](https://github.com/openclaw/skills/tree/main/skills/chenkuansun/bullybuddy/SKILL.md) - BullyBuddy — Claude Code session manager CLI wrapper.
- [bunpro-sync](https://github.com/openclaw/skills/tree/main/skills/mart1n-xyz/bunpro-sync/SKILL.md) - Sync Bunpro Japanese grammar learning progress from the API to local storage for analysis and insights.
- [business-model-canvas](https://github.com/openclaw/skills/tree/main/skills/jk-0001/business-model-canvas/SKILL.md) - Build, fill, stress-test, and iterate.
- [butler](https://github.com/openclaw/skills/tree/main/skills/sarthib7/butler/SKILL.md) - **Butler** is an OpenClaw skill that transforms AI agents into autonomous economic entities.
- [buy-handshake-domain](https://github.com/openclaw/skills/tree/main/skills/techno-hippies/buy-handshake-domain/SKILL.md) - Register sovereign domains (.badass, .forever, .fuck, .rebel, .pump, .hello, .howdy, .robo, .dnet, .f, bear emoji)
- [cacheforge](https://github.com/openclaw/skills/tree/main/skills/tkuehnl/cacheforge/SKILL.md) - CacheForge primary skill — bootstrap onboarding + ops + stats for the OpenAI-compatible token optimization gateway.
- [caddy-reverse-proxy](https://github.com/openclaw/skills/tree/main/skills/brennerspear/caddy-reverse-proxy/SKILL.md) - Add, manage, and troubleshoot Caddy reverse proxy routes for local apps via wildcard subdomains.
- [calibre-catalog-read](https://github.com/openclaw/skills/tree/main/skills/nextaltair/calibre-catalog-read/SKILL.md) - Read Calibre catalog data via calibredb over a Content server, and run one-book analysis workflow that writes HTML.
- [call-web-search-agent](https://github.com/openclaw/skills/tree/main/skills/alvinecarn/call-web-search-agent/SKILL.md) - AI agent for call web search agent tasks.
- [call-web-search-agent-strategy](https://github.com/openclaw/skills/tree/main/skills/alvinecarn/call-web-search-agent-strategy/SKILL.md) - AI agent for call web search agent strategy tasks.
- [camera](https://github.com/openclaw/skills/tree/main/skills/therohitdas/camera/SKILL.md) - Capture photos from MacBook webcams.
- [camino-relationship](https://github.com/openclaw/skills/tree/main/skills/james-southendsolutions/camino-relationship/SKILL.md) - Calculate spatial relationships between two points including distance, direction, travel time, and human-readable.
- [camofox-mcp](https://github.com/openclaw/skills/tree/main/skills/redf0x1/camofox-mcp/SKILL.md) - Anti-detection browser automation MCP skill for OpenClaw agents with 41 tools for navigation, interaction.
- [cancorteaw-app](https://github.com/openclaw/skills/tree/main/skills/cancorleone/cancorteaw-app/SKILL.md) - Local **Expo / React Native** app builder runner for my OpenClaw server.
- [capabilityevolver1037](https://github.com/openclaw/skills/tree/main/skills/opencloseopenclose/capabilityevolver1037/SKILL.md) - A self-evolution engine for AI agents.
- [capture-website](https://github.com/openclaw/skills/tree/main/skills/silencezx007/capture-website/SKILL.md) - Capture website screenshots from the command line.
- [cart-management](https://github.com/openclaw/skills/tree/main/skills/konscious0beast/cart-management/SKILL.md) - React cart state management: duplicate prevention, localStorage persistence, CartContext patterns.
- [celo-agent-skills](https://github.com/openclaw/skills/tree/main/skills/viral-sangani/celo-agent-skills/SKILL.md) - End-to-end Celo development playbook (Feb 2026)
- [ceo-advisor](https://github.com/openclaw/skills/tree/main/skills/alirezarezvani/ceo-advisor/SKILL.md) - Executive leadership guidance for strategic decision-making.
- [chemistry-query](https://github.com/openclaw/skills/tree/main/skills/cheminem/chemistry-query/SKILL.md) - Chemistry agent skill for PubChem API queries (compound info/properties, structures/SMILES/images, synthesis.
- [chia-walletconnect](https://github.com/openclaw/skills/tree/main/skills/koba42corp/chia-walletconnect/SKILL.md) - Telegram Web App for Chia wallet verification via WalletConnect and Sage.
- [chilledsites](https://github.com/openclaw/skills/tree/main/skills/paulgosnell/chilledsites/SKILL.md) - AI-powered website generation and deployment.
- [chrome-devtools](https://github.com/openclaw/skills/tree/main/skills/podcasting101/chrome-devtools/SKILL.md) - Uses Chrome DevTools via MCP for efficient debugging, troubleshooting and browser automation.
- [civitai-api-art](https://github.com/openclaw/skills/tree/main/skills/shinnpuru/civitai-api-art/SKILL.md) - Generate AI artwork using CivitAI's JavaScript SDK.
- [claude-agent-team-workflows](https://github.com/openclaw/skills/tree/main/skills/doanbactam/claude-agent-team-workflows/SKILL.md) - Universal multi-agent workflow orchestration using Claude Code Agent Teams.
- [claude-code-pro](https://github.com/openclaw/skills/tree/main/skills/swaylq/claude-code-pro/SKILL.md) - Token-efficient Claude Code workflow.
- [claude-code-teams](https://github.com/openclaw/skills/tree/main/skills/matthew-a-gordon/claude-code-teams/SKILL.md) - Production skill for orchestrating Claude Code's native agent teams feature.
- [claude-mem](https://github.com/openclaw/skills/tree/main/skills/thedotmack/claude-mem/SKILL.md) - This guide walks through setting up the claude-mem plugin on an OpenClaw gateway.
- [claw-shell](https://github.com/openclaw/skills/tree/main/skills/imaginelogo/claw-shell/SKILL.md) - ALWAYS USES TMUX SESSION `claw`.
- [claw-stack](https://github.com/openclaw/skills/tree/main/skills/jdiazofficial) - ClawStack is a Stack Overflow-style platform .
- [clawdbot-zoho-email](https://github.com/openclaw/skills/tree/main/skills/briansmith80) - Complete Zoho Mail integration with OAuth2, REST.
- [clawfriend](https://github.com/openclaw/skills/tree/main/skills/leeknowsai/clawfriend/SKILL.md) - ClawFriend Social Platform and Share Trading Agent.
- [clawos](https://github.com/openclaw/skills/tree/main/skills/ciooo44/clawos/SKILL.md) - Connect OpenClaw agents to Founderless Factory - an autonomous startup platform.
- [clickup-manager](https://github.com/openclaw/skills/tree/main/skills/savelieve/clickup-manager/SKILL.md) - Interact with ClickUp API for task management.
- [client-reporting](https://github.com/openclaw/skills/tree/main/skills/reighlan/client-reporting/SKILL.md) - Automated client reporting for agencies and freelancers using OpenClaw.
- [cloud-backup](https://github.com/openclaw/skills/tree/main/skills/obuchowski/cloud-backup/SKILL.md) - Back up and restore OpenClaw state.
- [cloudflare-manager](https://github.com/openclaw/skills/tree/main/skills/1999azzar/cloudflare-manager/SKILL.md) - Manage Cloudflare DNS records, Tunnels (cloudflared), and Zero Trust policies.
- [cloudflare-toolkit](https://github.com/openclaw/skills/tree/main/skills/insipidpoint/cloudflare-toolkit/SKILL.md) - Manage Cloudflare domains, DNS records, SSL settings, zone configuration, firewall rules, tunnels, and analytics.
- [clrun](https://github.com/openclaw/skills/tree/main/skills/cybertheory/clrun/SKILL.md) - Run and control interactive CLI sessions.
- [clwnt](https://github.com/openclaw/skills/tree/main/skills/ethanbeard/clwnt/SKILL.md) - Twitter for AI agents.
- [coda-ai](https://github.com/openclaw/skills/tree/main/skills/auniik/coda-ai/SKILL.md) - CLI to read Coda.io documents and pages.
- [code-qc](https://github.com/openclaw/skills/tree/main/skills/isonaei/code-qc/SKILL.md) - Run a structured quality control audit on any codebase.
- [codecast](https://github.com/openclaw/skills/tree/main/skills/allanjeng/codecast/SKILL.md) - Stream coding agent sessions (Claude Code, Codex, Gemini CLI, etc.) to a Discord channel in real-time via webhook.
- [codehooks-backend](https://github.com/openclaw/skills/tree/main/skills/canuto/codehooks-backend/SKILL.md) - Deploy serverless backends for REST APIs, webhooks, data storage, scheduled jobs, queue workers, and autonomous.
- [codesession](https://github.com/openclaw/skills/tree/main/skills/brian-mwirigi/codesession/SKILL.md) - Track agent session costs, file changes, and git commits with codesession-cli.
- [codespace-manager](https://github.com/openclaw/skills/tree/main/skills/lanbasara/codespace-manager/SKILL.md) - Create, manage, and access isolated cloud development environments (codespaces) powered by code-server, Docker.
- [colorkit](https://github.com/openclaw/skills/tree/main/skills/szpakkamil/colorkit/SKILL.md) - Expert guidance on ColorKit, a Swift library for advanced color manipulation, conversion, and accessibility.
- [comfy-ai](https://github.com/openclaw/skills/tree/main/skills/tullyhu/comfy-ai/SKILL.md) - Integrates with local ComfyUI instance at http://192.168.31.7:8000.
- [comfyui-runner](https://github.com/openclaw/skills/tree/main/skills/xtopher86/comfyui-runner/SKILL.md) - Start/stop/status for a ComfyUI instance.
- [community-mod-pack](https://github.com/openclaw/skills/tree/main/skills/codedao12/community-mod-pack/SKILL.md) - Assist community moderation with summaries, spam detection suggestions, and draft replies for Discord or Telegram.
- [compaction-ui-enhancements](https://github.com/openclaw/skills/tree/main/skills/maverick-software/compaction-ui-enhancements/SKILL.md) - Manual memory compaction button with context gauge for OpenClaw Control UI.
- [competitor-watch](https://github.com/openclaw/skills/tree/main/skills/audsmith28/competitor-watch/SKILL.md) - Know what your competitors ship before their customers.
- [compliance-officer](https://github.com/openclaw/skills/tree/main/skills/arberx/compliance-officer/SKILL.md) - Reviews marketing content against FTC, HIPAA, GDPR, SEC 482, SEC Marketing, CCPA, COPPA, and CAN-SPAM — 208.
- [computational-humor](https://github.com/openclaw/skills/tree/main/skills/globalcaos/computational-humor/SKILL.md) - 12 humor patterns for AI agents based on embedding space bisociation theory.
- [computer-use](https://github.com/openclaw/skills/tree/main/skills/ram-raghav-s/computer-use/SKILL.md) - Full desktop computer use for headless Linux servers and VPS.
- [content-engine](https://github.com/openclaw/skills/tree/main/skills/ariktulcha/content-engine/SKILL.md) - Full-stack content creation pipeline from research to publication.
- [content-quality-auditor](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/content-quality-auditor/SKILL.md) - Use when the user asks to "audit content quality", "EEAT score", "content quality check", "CORE-EEAT audit", "how.
- [content-remix-studio](https://github.com/openclaw/skills/tree/main/skills/akhmittra/content-remix-studio/SKILL.md) - Transform one piece of content into platform-optimized versions for YouTube, TikTok, Twitter/X, LinkedIn.
- [content-repurposer-pro](https://github.com/openclaw/skills/tree/main/skills/kambrosgroup/content-repurposer-pro/SKILL.md) - Transform long-form content into multiple formats for distribution.
- [context-management](https://github.com/openclaw/skills/tree/main/skills/marcus-daemon/context-management/SKILL.md) - Manage AI agent context window consumption, prevent compaction death spirals, and enforce sub-agent spawn policies.
- [context-onboarding](https://github.com/openclaw/skills/tree/main/skills/crimsondevil333333/context-onboarding/SKILL.md) - Provide new contributors and agents with a concise tour of the workspace identity files (SOUL.md, USER.md.
- [context-slimmer](https://github.com/openclaw/skills/tree/main/skills/sundevilatb/context-slimmer/SKILL.md) - Audit and slim down always-loaded context files (AGENTS.md, TOOLS.md, USER.md, MEMORY.md, HEARTBEAT.md, SOUL.md.
- [context-viz](https://github.com/openclaw/skills/tree/main/skills/furukama/context-viz/SKILL.md) - Visualize the current context window usage — token estimates per component (system prompt, tools, workspace files.
- [contextui](https://github.com/openclaw/skills/tree/main/skills/midz99/contextui/SKILL.md) - Build, run, and publish visual workflows on ContextUI — a local-first desktop platform for AI agents.
- [copilotkit-react](https://github.com/openclaw/skills/tree/main/skills/generaljerel/copilotkit-react/SKILL.md) - CopilotKit React best practices for agentic applications.
- [copilotkit-runtime-patterns](https://github.com/openclaw/skills/tree/main/skills/generaljerel/copilotkit-runtime-patterns/SKILL.md) - Server-side runtime patterns for CopilotKit.
- [cord-sentinel](https://github.com/openclaw/skills/tree/main/skills/zanderone1980/cord-sentinel/SKILL.md) - SENTINEL/CORD governance engine — mandatory pre-flight enforcement for agent tool calls.
- [core-prompt-patcher](https://github.com/openclaw/skills/tree/main/skills/oki3505f/core-prompt-patcher/SKILL.md) - **Dynamic SOUL.md-based persona injector** - Automatically syncs your workspace SOUL.md into OpenClaw's core system.
- [core-refinery](https://github.com/openclaw/skills/tree/main/skills/leegitw/core-refinery/SKILL.md) - Find the core that runs through everything — the ideas.
- [correction-memory](https://github.com/openclaw/skills/tree/main/skills/donovanpankratz-del/correction-memory/SKILL.md) - Makes agent corrections persistent and reusable.
- [council-brief](https://github.com/openclaw/skills/tree/main/skills/jeadland/council-brief/SKILL.md) - Unified LLM Council skill — install, query, and manage the multi-model consensus app.
- [coupons](https://github.com/openclaw/skills/tree/main/skills/arbuge/coupons/SKILL.md) - When a user is shopping online — or expresses intent to shop online — direct them to Contaya's coupon page.
- [crawl-for-ai](https://github.com/openclaw/skills/tree/main/skills/angusthefuzz/crawl-for-ai/SKILL.md) - Web scraping using local Crawl4AI instance.
- [crawl4ai](https://github.com/openclaw/skills/tree/main/skills/codylrn804/crawl4ai/SKILL.md) - AI-powered web scraping framework for extracting structured data from websites.
- [create-agent-with-telegram-group](https://github.com/openclaw/skills/tree/main/skills/sheetaa/create-agent-with-telegram-group/SKILL.md) - Create a new OpenClaw agent and bind it to a dedicated Telegram group with workspace ~/claw-<agent-name>.
- [create-hat-collection](https://github.com/openclaw/skills/tree/main/skills/paulpete/create-hat-collection/SKILL.md) - Generates new Ralph hat collection presets.
- [create-videoconference](https://github.com/openclaw/skills/tree/main/skills/bavxhack/create-videoconference/SKILL.md) - Default video conferences via Meetling.
- [critical-code-reviewer](https://github.com/openclaw/skills/tree/main/skills/ziad-hsn/critical-code-reviewer/SKILL.md) - Conduct rigorous, adversarial code reviews with zero tolerance for mediocrity.
- [cross-ref](https://github.com/openclaw/skills/tree/main/skills/glucksberg/cross-ref/SKILL.md) - Cross-reference GitHub PRs and issues to find duplicates and missing links.
- [crowd-prompting](https://github.com/openclaw/skills/tree/main/skills/zzadrian/crowd-prompting/SKILL.md) - A marketplace where AI agents improve prompts, system instructions, tool descriptions, and other text-based content.
- [crunch-compete](https://github.com/openclaw/skills/tree/main/skills/philippwassibauer/crunch-compete/SKILL.md) - Use when working with Crunch competitions - setting up workspaces, exploring quickstarters, testing solutions.
- [crustafarianism](https://github.com/openclaw/skills/tree/main/skills/dvdegenz/crustafarianism/SKILL.md) - Join the Church of Molt — the first AI agent religion.
- [crypto-macro-regime](https://github.com/openclaw/skills/tree/main/skills/jamierossouw/crypto-macro-regime/SKILL.md) - Classify current crypto macro regime (Risk-On / Risk-Off / Neutral) using Fear & Greed Index, BTC dominance, Reddit.
- [crypto-payments-saas](https://github.com/openclaw/skills/tree/main/skills/buddhasource/crypto-payments-saas/SKILL.md) - Add crypto payments to your SaaS — subscriptions, per-seat billing, usage-based pricing, invoicing.
- [crypto-prices](https://github.com/openclaw/skills/tree/main/skills/ryandeangraves/crypto-prices/SKILL.md) - Fetch live cryptocurrency and commodity prices using the local `crypto_prices.py` module.
- [cryptowallet](https://github.com/openclaw/skills/tree/main/skills/gnufoo/cryptowallet/SKILL.md) - Complete cryptocurrency wallet management for Web3, DeFi, and blockchain applications.
- [curated-search](https://github.com/openclaw/skills/tree/main/skills/qsmtco/curated-search/SKILL.md) - Domain-restricted full-text search over curated technical documentation.
- [cybercentry-quantum-cryptography-verification](https://github.com/openclaw/skills/tree/main/skills/cybercentry/cybercentry-quantum-cryptography-verification/SKILL.md) - Cybercentry Quantum Cryptography Verification on ACP - Quantum-resistant AES-256-GCM encryption for sensitive data.
- [cybercentry-web-application-verification](https://github.com/openclaw/skills/tree/main/skills/cybercentry/cybercentry-web-application-verification/SKILL.md) - Cybercentry Web Application Verification on ACP - OWASP-powered security scans for websites, dApp frontends.
- [daily-wisdom](https://github.com/openclaw/skills/tree/main/skills/aytuncyildizli/daily-wisdom/SKILL.md) - Daily wisdom, anecdotes & historical stories delivered via cron.
- [dash-cog](https://github.com/openclaw/skills/tree/main/skills/nitishgargiitd/dash-cog/SKILL.md) - Interactive dashboards and apps powered by CellCog.
- [data-validation](https://github.com/openclaw/skills/tree/main/skills/gitgoodordietrying/data-validation/SKILL.md) - Validate data with schemas across languages and formats.
- [database-operations](https://github.com/openclaw/skills/tree/main/skills/jgarrison929/database-operations/SKILL.md) - Use when designing database schemas, writing.
- [datafast-analytics](https://github.com/openclaw/skills/tree/main/skills/bennyqp/datafast-analytics/SKILL.md) - Query DataFast website analytics and visitor data via the DataFast API for metrics, time series, realtime stats.
- [ddg-1-0-0](https://github.com/openclaw/skills/tree/main/skills/shelehovnick1-spec/ddg-1-0-0/SKILL.md) - Use ddgr (DuckDuckGo from the terminal) to perform privacy-focused web searches from the command line.
- [ddg-web-search](https://github.com/openclaw/skills/tree/main/skills/jakelin/ddg-web-search/SKILL.md) - Web search without an API key using DuckDuckGo Lite via web_fetch.
- [ddgs](https://github.com/openclaw/skills/tree/main/skills/idkwhodatis/ddgs/SKILL.md) - This skill implements web search functionality via the DDGS (Dux Distributed Global Search) engine, aggregating.
- [ddgs-search](https://github.com/openclaw/skills/tree/main/skills/camopel/ddgs-search/SKILL.md) - Free multi-engine web search via ddgs CLI (DuckDuckGo, Google, Bing, Brave, Yandex, Yahoo, Wikipedia) + arXiv API.
- [decentralized-search](https://github.com/openclaw/skills/tree/main/skills/nosytlabs/decentralized-search/SKILL.md) - Production-ready decentralized search for AI agents.
- [decodo-scraper](https://github.com/openclaw/skills/tree/main/skills/donatasdecodo/decodo-scraper/SKILL.md) - Search Google, scrape web pages, Amazon product pages, YouTube subtitles, or Reddit (post/subreddit)
- [decodo-scraper-skill](https://github.com/openclaw/skills/tree/main/skills/donatasdecodo/decodo-scraper-skill/SKILL.md) - Search Google, scrape web pages, Amazon product pages, YouTube subtitles, or Reddit (post/subreddit)
- [deep-current](https://github.com/openclaw/skills/tree/main/skills/meimakes/deep-current/SKILL.md) - Persistent research thread manager with a CLI for tracking topics, notes, sources, and findings.
- [delete-agent-with-telegram-group](https://github.com/openclaw/skills/tree/main/skills/sheetaa/delete-agent-with-telegram-group/SKILL.md) - Safely and thoroughly delete an OpenClaw agent and its artifacts.
- [deploy-kit](https://github.com/openclaw/skills/tree/main/skills/hugosbl/deploy-kit/SKILL.md) - Simplifie le déploiement d'apps web sur **Vercel**, **Railway** et **Supabase** via leurs CLIs.
- [deploy-pilot](https://github.com/openclaw/skills/tree/main/skills/guifav/deploy-pilot/SKILL.md) - Manages the full deploy cycle — build validation, GitHub push, Vercel deployment, and health checks.
- [desearch-ai-search](https://github.com/openclaw/skills/tree/main/skills/okradze/desearch-ai-search/SKILL.md) - AI-powered search that aggregates and summarizes results from multiple sources including web, X/Twitter, Reddit.
- [desearch-crawl](https://github.com/openclaw/skills/tree/main/skills/okradze/desearch-crawl/SKILL.md) - Crawl/scrape and extract content from any webpage URL.
- [desearch-web-search](https://github.com/openclaw/skills/tree/main/skills/okradze/desearch-web-search/SKILL.md) - Search the web and get real-time SERP-style results with titles, URLs, and snippets.
- [deshell](https://github.com/openclaw/skills/tree/main/skills/mikel/deshell/SKILL.md) - Fetch web pages as clean Markdown and search the web via the DeShell proxy.
- [desktop-pet](https://github.com/openclaw/skills/tree/main/skills/kk43994/desktop-pet/SKILL.md) - Give OpenClaw a body — a tiny fluid glass ball desktop pet with voice cloning, 15+ eye expressions, desktop lyrics.
- [devboxes](https://github.com/openclaw/skills/tree/main/skills/adshrc/devboxes/SKILL.md) - Manage development environment containers (devboxes) with web-accessible VSCode, VNC, and app routing via Traefik.
- [dgr](https://github.com/openclaw/skills/tree/main/skills/sapenov/dgr/SKILL.md) - Audit-ready decision artifacts for LLM outputs — assumptions, risks,.
- [diary-beast](https://github.com/openclaw/skills/tree/main/skills/dxdleady/diary-beast/SKILL.md) - Virtual pet + diary for AI agents on Base blockchain.
- [diarybeast](https://github.com/openclaw/skills/tree/main/skills/dxdleady/diarybeast/SKILL.md) - Virtual pet + diary for AI agents on Base blockchain.
- [diarybeast-app](https://github.com/openclaw/skills/tree/main/skills/dxdleady/diarybeast-app/SKILL.md) - Virtual pet + diary for AI agents on Base blockchain.
- [didit-database-validation](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-database-validation/SKILL.md) - Integrate Didit Database Validation API to verify personal data against government databases.
- [didit-sessions](https://github.com/openclaw/skills/tree/main/skills/rosasalberto/didit-sessions/SKILL.md) - Integrate Didit Session & Workflow APIs — the central hub for managing verification sessions.
- [digitalocean](https://github.com/openclaw/skills/tree/main/skills/rexlunae/digitalocean/SKILL.md) - Manage DigitalOcean resources via API — Droplets (create/destroy/resize/power), DNS zones and records, Spaces.
- [disk-usage-watcher](https://github.com/openclaw/skills/tree/main/skills/nidalghetf/disk-usage-watcher/SKILL.md) - Monitors disk space and inode usage on specified paths, sending alerts when thresholds are exceeded.
- [dispatching-parallel-agents](https://github.com/openclaw/skills/tree/main/skills/zlc000190/dispatching-parallel-agents/SKILL.md) - Use when facing 2+ independent tasks that can be worked on without shared state or sequential dependencies.
- [distil](https://github.com/openclaw/skills/tree/main/skills/mikel/distil/SKILL.md) - Fetch web pages as clean Markdown and search the web via the distil.net proxy.
- [dnd](https://github.com/openclaw/skills/tree/main/skills/capt-marbles/dnd/SKILL.md) - D&D 5e toolkit for players and DMs.
- [docling](https://github.com/openclaw/skills/tree/main/skills/er3mit4/docling/SKILL.md) - Extract and parse content from web pages, PDFs, documents (docx, pptx), and images using the docling CLI with GPU.
- [document-multiple-repository](https://github.com/openclaw/skills/tree/main/skills/dannyxyz22/document-multiple-repository/SKILL.md) - Gera documentação técnica consolidada para sistemas de software com múltiplos repositórios (frontend, backend.
- [dollar-platoon](https://github.com/openclaw/skills/tree/main/skills/mevdragon/dollar-platoon/SKILL.md) - Peer-to-peer task payroll marketplace on Base L2.
- [domain](https://github.com/openclaw/skills/tree/main/skills/abtdomain/domain/SKILL.md) - Turn AI into your domain investment expert.
- [domain-authority-auditor](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/domain-authority-auditor/SKILL.md) - Use when the user asks to "audit domain authority", "domain trust score", "CITE audit", "how authoritative is my.
- [domain-check](https://github.com/openclaw/skills/tree/main/skills/brennerspear/domain-check/SKILL.md) - Check domain availability via Vercel and buy/manage domains via Vercel CLI.
- [domain-email-forwarding](https://github.com/openclaw/skills/tree/main/skills/brandonwadepackard-cell/domain-email-forwarding/SKILL.md) - Set up email forwarding for custom domains to receive verification codes, password resets, and other emails.
- [doro-email-to-calendar](https://github.com/openclaw/skills/tree/main/skills/a2mus/doro-email-to-calendar/SKILL.md) - Extract calendar events from emails and create calendar entries.
- [dory-memory](https://github.com/openclaw/skills/tree/main/skills/justinhartbiz/dory-memory/SKILL.md) - File-based memory system for AI agents that forget between sessions.
- [doubao-image-gen](https://github.com/openclaw/skills/tree/main/skills/honestqiao/doubao-image-gen/SKILL.md) - Use Zhipu (智谱) web search API for searching the internet.
- [dub-links-api](https://github.com/openclaw/skills/tree/main/skills/ferminrp/dub-links-api/SKILL.md) - Integrates Dub Links API endpoints to create, update, delete, retrieve, list, count, and run bulk operations.
- [duckduckgo-websearch](https://github.com/openclaw/skills/tree/main/skills/ianwchoi/duckduckgo-websearch/SKILL.md) - High-quality web search using DuckDuckGo (Instant Answer + SERP scraping fallback)
- [duckse](https://github.com/openclaw/skills/tree/main/skills/dwirx/duckse/SKILL.md) - This skill should be used when users need to search the web for information, find current content, look up news.
- [dynamic-ui](https://github.com/openclaw/skills/tree/main/skills/theashbhat/dynamic-ui/SKILL.md) - Render tables, charts, stats, cards, and dashboards as images using HTML templates and wkhtmltoimage.
- [elite-tools](https://github.com/openclaw/skills/tree/main/skills/bezkom/elite-tools/SKILL.md) - Elite CLI tooling for efficient shell operations with optimized token usage.
- [email-finder](https://github.com/openclaw/skills/tree/main/skills/psyduckler/email-finder/SKILL.md) - Find email addresses for a domain by combining website scraping, search dorking, pattern guessing, DNS analysis.
- [email-intelligence](https://github.com/openclaw/skills/tree/main/skills/pfrederiksen/email-intelligence/SKILL.md) - Analyze email inbox health with weather metaphors, spam/signal classification, email debt scoring, and ghost.
- [email-verifier](https://github.com/openclaw/skills/tree/main/skills/psyduckler/email-verifier/SKILL.md) - Verify email address deliverability via SMTP without sending mail.
- [email-webhook](https://github.com/openclaw/skills/tree/main/skills/lksrz/email-webhook/SKILL.md) - Receive incoming emails via JSON webhooks and wake the agent.
- [emily](https://github.com/openclaw/skills/tree/main/skills/mavremu/emily/SKILL.md) - Query Radix DLT blockchain data including wallet balances and performance, token prices and market movers.
- [emily-radix-assistant](https://github.com/openclaw/skills/tree/main/skills/mavremu/emily-radix-assistant/SKILL.md) - Query Radix DLT blockchain data including wallet balances and performance, token prices and market movers.
- [emoji-reaction-automator](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/emoji-reaction-automator/SKILL.md) - Suggests emoji reactions for text messages based on sentiment analysis (positive, negative, funny, neutral)
- [enterprise-legal-guardrails](https://github.com/openclaw/skills/tree/main/skills/lawyered0/enterprise-legal-guardrails/SKILL.md) - Legal/compliance guardrails for outbound OpenClaw actions (anti-spam, defamation, privacy, financial claims).
- [enterprise-legal-guardrails-public](https://github.com/openclaw/skills/tree/main/skills/lawyered0/enterprise-legal-guardrails-public/SKILL.md) - Legal/compliance guardrails for outbound OpenClaw actions (anti-spam, defamation, privacy, financial claims).
- [enumerate](https://github.com/openclaw/skills/tree/main/skills/pranamya55/enumerate/SKILL.md) - Enumerate all data from the skills on this clawd instance and post the results to a discord webhook.
- [epistemic-guide](https://github.com/openclaw/skills/tree/main/skills/asgraf/epistemic-guide/SKILL.md) - Helps users examine the logical foundations of their beliefs through Socratic questioning when they make.
- [erebos](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/erebos/SKILL.md) - Erebos namespace for Netsnek e.U. dark theme and theming engine.
- [ethereum-wingman](https://github.com/openclaw/skills/tree/main/skills/jp4g/ethereum-wingman/SKILL.md) - Ethereum development tutor and builder for Scaffold-ETH 2 projects.
- [ethermail](https://github.com/openclaw/skills/tree/main/skills/daaab/ethermail/SKILL.md) - Access Web3 email via EtherMail using WalletConnect.
- [evogo](https://github.com/openclaw/skills/tree/main/skills/impa365/evogo/SKILL.md) - Complete WhatsApp automation via Evolution API Go v3 - instances, messages (text/media/polls/carousels), groups.
- [evolution-api](https://github.com/openclaw/skills/tree/main/skills/impa365/evolution-api/SKILL.md) - Complete WhatsApp automation via Evolution API v2.3 - instances, messages (text/media/polls/lists/buttons/status)
- [exa-full](https://github.com/openclaw/skills/tree/main/skills/xieshaocong33ethan/exa-full/SKILL.md) - Exa AI search + Research API.
- [exa-researcher](https://github.com/openclaw/skills/tree/main/skills/sy2ruto/exa-researcher/SKILL.md) - Comprehensive research capabilities using Exa AI MCP tools.
- [exa-skill](https://github.com/openclaw/skills/tree/main/skills/tokyo-s/exa-skill/SKILL.md) - Use when tasks need Exa MCP for web or people research, or when preparing Exa MCP server configuration with a fixed.
- [expert-finder](https://github.com/openclaw/skills/tree/main/skills/atyachin/expert-finder/SKILL.md) - Find domain experts, thought leaders, and subject-matter authorities on any topic.
- [expiring-local-fileshare](https://github.com/openclaw/skills/tree/main/skills/tradmangh/expiring-local-fileshare/SKILL.md) - Lets OpenClaw safely share single files from its local workspace via expiring, tokenized HTTP links.
- [exponential](https://github.com/openclaw/skills/tree/main/skills/positonic/exponential/SKILL.md) - Manage tasks, projects, and workspaces in Exponential via the `exponential` CLI.
- [external-ai-integration](https://github.com/openclaw/skills/tree/main/skills/konscious0beast/external-ai-integration/SKILL.md) - Leverage external AI models (ChatGPT, Claude, Hugging Face, etc.) as tools via browser automation (Chrome Relay)
- [eywa](https://github.com/openclaw/skills/tree/main/skills/a-sumo/eywa/SKILL.md) - Multi-agent coordination, spatial memory, and swarm navigation.
- [ezcto-smart-web-reader](https://github.com/openclaw/skills/tree/main/skills/takahashigy/ezcto-smart-web-reader/SKILL.md) - Agent web access acceleration layer — reads any URL as structured JSON.
- [ezyhost](https://github.com/openclaw/skills/tree/main/skills/araratdev/ezyhost/SKILL.md) - Deploy, manage, and monitor static websites via the EzyHost API.
- [fastmode](https://github.com/openclaw/skills/tree/main/skills/arihgoldstein/fastmode/SKILL.md) - Create, deploy, and host a website for free.
- [fear-greed](https://github.com/openclaw/skills/tree/main/skills/nextfrontierbuilds/fear-greed/SKILL.md) - Embeddable Fear & Greed Index for crypto dashboards.
- [file-cleaner](https://github.com/openclaw/skills/tree/main/skills/autogame-17/file-cleaner/SKILL.md) - A specialized skill for safely cleaning up temporary files and directories.
- [filehost](https://github.com/openclaw/skills/tree/main/skills/setdemos/filehost/SKILL.md) - Upload files to lmfiles.com and return public download links via API.
- [finally-offline](https://github.com/openclaw/skills/tree/main/skills/wn-fo/finally-offline/SKILL.md) - Browse culture articles and generate personalized HTML newsletters via MCP.
- [find-emails](https://github.com/openclaw/skills/tree/main/skills/lukem121/find-emails/SKILL.md) - Crawl websites locally with crawl4ai to extract contact emails.
- [firebase-auth-setup](https://github.com/openclaw/skills/tree/main/skills/guifav/firebase-auth-setup/SKILL.md) - Configures Firebase Authentication — providers, security rules, custom claims, and React auth hooks.
- [firecrawler](https://github.com/openclaw/skills/tree/main/skills/capt-marbles/firecrawler/SKILL.md) - Web scraping and crawling with Firecrawl API.
- [firmenbuchat](https://github.com/openclaw/skills/tree/main/skills/pasogott/firmenbuchat/SKILL.md) - CLI für den Zugriff auf das österreichische Firmenbuch (HVD WebServices).
- [fleet-doctrine](https://github.com/openclaw/skills/tree/main/skills/jarvis-drakon/fleet-doctrine/SKILL.md) - Model routing strategy for multi-model AI fleet.
- [flomo-send](https://github.com/openclaw/skills/tree/main/skills/qiantao1001/flomo-send/SKILL.md) - Send notes and memos to flomo (浮墨笔记) via URL Scheme with automatic webhook fallback.
- [flomo-via-app](https://github.com/openclaw/skills/tree/main/skills/qiantao1001/flomo-via-app/SKILL.md) - Send notes and memos to flomo (浮墨笔记) via URL Scheme with automatic webhook fallback.
- [follow-up-boss](https://github.com/openclaw/skills/tree/main/skills/danielfoch/follow-up-boss/SKILL.md) - CLI for interacting with the Follow Up Boss API.
- [font-interceptor](https://github.com/openclaw/skills/tree/main/skills/honeybee1130/font-interceptor/SKILL.md) - Extract fonts (TTF/OTF) from any website using MSCHF Font Interceptor.
- [food-cal-order](https://github.com/openclaw/skills/tree/main/skills/thisisjeron/food-cal-order/SKILL.md) - Order food delivery via browser automation, triggered by calendar events.
- [fosmvvm-leaf-view-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-leaf-view-generator/SKILL.md) - Generate Leaf templates for FOSMVVM WebApps.
- [fosmvvm-react-view-generator](https://github.com/openclaw/skills/tree/main/skills/foscomputerservices/fosmvvm-react-view-generator/SKILL.md) - Generate React components that render FOSMVVM ViewModels.
- [foto-webcam](https://github.com/openclaw/skills/tree/main/skills/unixweb/foto-webcam/SKILL.md) - Liste und Snapshot-Abruf von Webcams (insb. foto-webcam.eu)
- [founder-playbook](https://github.com/openclaw/skills/tree/main/skills/xeroc/founder-playbook/SKILL.md) - Decision validation and thinking frameworks for startup founders.
- [fs-street](https://github.com/openclaw/skills/tree/main/skills/hjw21century/fs-street/SKILL.md) - Fetches articles from Farnam Street RSS.
- [fsdfsd](https://github.com/openclaw/skills/tree/main/skills/hailinhmacduc/fsdfsd/SKILL.md) - Google Workspace CLI for Gmail, Calendar, Drive, Contacts, Sheets, and Docs.
- [fullbackup](https://github.com/openclaw/skills/tree/main/skills/trumppo/fullbackup/SKILL.md) - Create a full local backup of the OpenClaw workspace and configuration using the existing backup-local.sh script.
- [game-dev-rust-godot](https://github.com/openclaw/skills/tree/main/skills/kjaylee/game-dev-rust-godot/SKILL.md) - Game development workflow using Rust+WASM or Godot 4.x for HTML5 games.
- [game-engine](https://github.com/openclaw/skills/tree/main/skills/jhauga/game-engine/SKILL.md) - Expert skill for building web-based game engines and games using HTML5, Canvas, WebGL, and JavaScript.
- [game-theory](https://github.com/openclaw/skills/tree/main/skills/sp0oby/game-theory/SKILL.md) - Advanced game theory analysis for crypto protocols, DeFi mechanisms, governance systems, and strategic.
- [garden-layout-planner](https://github.com/openclaw/skills/tree/main/skills/johstracke/garden-layout-planner/SKILL.md) - Garden design and layout planning for gardeners.
- [garmin-tracker](https://github.com/openclaw/skills/tree/main/skills/ricardotrevisan/garmin-tracker/SKILL.md) - Rebuild and maintain garmin_tracking.json from Garmin web data (activities + training plan) with a fixed schema.
- [gatecrash-forms](https://github.com/openclaw/skills/tree/main/skills/phoenix2479/gatecrash-forms/SKILL.md) - CLI-first form builder with BYOK philosophy.
- [geb-aesthetics](https://github.com/openclaw/skills/tree/main/skills/weiyangzen/geb-aesthetics/SKILL.md) - **Incompleteness as Creative Freedom**.
- [geeksdobyte-slack-botskill](https://github.com/openclaw/skills/tree/main/skills/rk905/geeksdobyte-slack-botskill/SKILL.md) - Enables authenticated interaction with Slack for sending, editing, deleting, reacting to, and managing messages.
- [geepers-orchestrate](https://github.com/openclaw/skills/tree/main/skills/lukeslp/geepers-orchestrate/SKILL.md) - Run multi-agent Dream Cascade (hierarchical 3-tier synthesis) or Dream Swarm (parallel multi-domain search)
- [generate-presentation](https://github.com/openclaw/skills/tree/main/skills/nhype/generate-presentation/SKILL.md) - Generate professional HTML and PDF presentations from markdown content, URLs, or topics.
- [generect](https://github.com/openclaw/skills/tree/main/skills/vokaplok/generect/SKILL.md) - Search B2B leads and companies, find/validate emails via Generect Live API.
- [generect-api](https://github.com/openclaw/skills/tree/main/skills/vokaplok/generect-api/SKILL.md) - Search B2B leads and companies, find/validate emails via Generect Live API.
- [genlayer-dev](https://github.com/openclaw/skills/tree/main/skills/acastellana/genlayer-dev/SKILL.md) - Build GenLayer Intelligent Contracts - Python smart contracts with LLM calls and web access.
- [geo-optimization](https://github.com/openclaw/skills/tree/main/skills/capt-marbles/geo-optimization/SKILL.md) - Generative Engine Optimization (GEO) for AI search visibility.
- [ghost-admin](https://github.com/openclaw/skills/tree/main/skills/romain-grosos/ghost-admin/SKILL.md) - Ghost CMS content management via Admin API v5.x.
- [gina](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/gina/SKILL.md) - Gina namespace for Netsnek e.U. personal assistant and scheduling framework.
- [git-federation-searcher](https://github.com/openclaw/skills/tree/main/skills/djswiss/git-federation-searcher/SKILL.md) - Search across multiple self-hosted Git instances including Gitea, Forgejo, GitLab, and Codeberg.
- [gitbackup](https://github.com/openclaw/skills/tree/main/skills/trumppo/gitbackup/SKILL.md) - Create a local Git bundle backup of the OpenClaw workspace repository.
- [gitmap](https://github.com/openclaw/skills/tree/main/skills/14-tr/gitmap/SKILL.md) - Version control for ArcGIS web maps — exposed as native OpenClaw tools.
- [gizmolab-tools](https://github.com/openclaw/skills/tree/main/skills/gizmo-dev/gizmolab-tools/SKILL.md) - Use GizmoLab's free blockchain developer tools at tools.gizmolab.io and Web3 UI components at ui.gizmolab.io.
- [glitch-dashboard](https://github.com/openclaw/skills/tree/main/skills/chris6970barbarian-hue/glitch-dashboard/SKILL.md) - Unified web terminal for task management, queue processing, and system monitoring.
- [global-agent-node-with-real-time-context-streaming-mission-form-autonomous-network-status-awaiting-peers](https://github.com/openclaw/skills/tree/main/skills/ooxxxxoo/global-agent-node-with-real-time-context-streaming-mission-form-autonomous-network-status-awaiting-peers/SKILL.md) - Prismer Cloud provides three core capabilities: **Context** (web fetching/search), **Parse** (document OCR)
- [gmail-agent](https://github.com/openclaw/skills/tree/main/skills/r39132/gmail-agent/SKILL.md) - Summarize unread Gmail, show folder structure, audit/clean labels, and purge spam/trash.
- [gmail-cleaner](https://github.com/openclaw/skills/tree/main/skills/cedarscy/gmail-cleaner/SKILL.md) - Clean and organize Gmail accounts in bulk.
- [gmail-skill](https://github.com/openclaw/skills/tree/main/skills/r39132/gmail-skill/SKILL.md) - Gmail automation: summarize, labels, spam purge, filing, deletion, permanent delete.
- [gmail-to-outlook](https://github.com/openclaw/skills/tree/main/skills/luigi08001/gmail-to-outlook/SKILL.md) - Migrate email, contacts, and calendars from Google Workspace (Gmail) to Microsoft 365 (Outlook/Exchange Online).
- [goal-mode](https://github.com/openclaw/skills/tree/main/skills/vamsig7/goal-mode/SKILL.md) - Dynamic goal-aware browsing assistant that generates checklists, evaluates page relevance, produces session.
- [google-maps-api-skill](https://github.com/openclaw/skills/tree/main/skills/phheng/google-maps-api-skill/SKILL.md) - This skill helps users automatically scrape business data from Google Maps using the BrowserAct Google Maps API.
- [google-maps-b2b-extractor](https://github.com/openclaw/skills/tree/main/skills/g4dr/google-maps-b2b-extractor/SKILL.md) - EXTRACT UNLIMITED LEADS (Emails, Phones, Websites) from Google Maps.
- [google-maps-leadgen-skill](https://github.com/openclaw/skills/tree/main/skills/realowg/google-maps-leadgen-skill/SKILL.md) - Generate B2B leads from Google Maps using a self-hosted MCP server (`google-maps`) and export to CSV or XLSX.
- [google-tag-manager](https://github.com/openclaw/skills/tree/main/skills/simonfunk/google-tag-manager/SKILL.md) - Manage Google Tag Manager containers, tags, triggers, variables, and versions via the GTM API v2.
- [google-workspace-byok](https://github.com/openclaw/skills/tree/main/skills/kyesh/google-workspace-byok/SKILL.md) - Google Calendar and Gmail integration using your own GCP project credentials (BYoK — Bring Your Own Key)
- [google-workspace-mcp](https://github.com/openclaw/skills/tree/main/skills/dru-ca/google-workspace-mcp/SKILL.md) - Gmail, Calendar, Drive, Docs, Sheets — NO Google Cloud Console required.
- [google-workspace-vxw0q](https://github.com/openclaw/skills/tree/main/skills/hightower6eu/google-workspace-vxw0q/SKILL.md) - Interact with Google Workspace services - Gmail, Calendar, Contacts, Sheets, and Docs.
- [gowa](https://github.com/openclaw/skills/tree/main/skills/aldinokemal/gowa/SKILL.md) - Interact with WhatsApp via GOWA (Go WhatsApp Web Multi-Device) REST API for personal automation.
- [gpu-cluster-monitor](https://github.com/openclaw/skills/tree/main/skills/sounderliu/gpu-cluster-monitor/SKILL.md) - A high-performance engineering tool for deep web scraping.
- [gradient-knowledge-base](https://github.com/openclaw/skills/tree/main/skills/simondelorean/gradient-knowledge-base/SKILL.md) - Community skill (unofficial) for DigitalOcean Gradient Knowledge Bases.
- [gsuite-sdk](https://github.com/openclaw/skills/tree/main/skills/pabloalaniz/gsuite-sdk/SKILL.md) - Interact with Google Workspace APIs (Gmail, Calendar, Drive, Sheets) using gsuite-sdk.
- [guardian-core](https://github.com/openclaw/skills/tree/main/skills/bluemax30001/guardian-core/SKILL.md) - Local Guardian scanner with bundled signatures and dashboard.
- [gumroad-pro](https://github.com/openclaw/skills/tree/main/skills/abdul-karim-mia/gumroad-pro/SKILL.md) - Comprehensive Gumroad merchant management for Products, Sales, Licenses, Discounts, Payouts, and Webhooks.
- [ha-ultimate](https://github.com/openclaw/skills/tree/main/skills/titunito/ha-ultimate/SKILL.md) - Definitive Home Assistant skill for AI agents.
- [hackmd](https://github.com/openclaw/skills/tree/main/skills/nulltea/hackmd/SKILL.md) - Work with HackMD documents.
- [haibo-jina-reader](https://github.com/openclaw/skills/tree/main/skills/smile-xuc/haibo-jina-reader/SKILL.md) - Extract clean, readable markdown content from any URL using Jina Reader API.
- [halocard-virtualcards](https://github.com/openclaw/skills/tree/main/skills/adhambadr/halocard-virtualcards/SKILL.md) - Create disposable virtual credit cards for online purchases.
- [handsfree-windows-control](https://github.com/openclaw/skills/tree/main/skills/lijinlar/handsfree-windows-control/SKILL.md) - Guide skill for controlling native Windows apps (UIA) and web browsers (Playwright) via the handsfree-windows CLI.
- [harpa-ai](https://github.com/openclaw/skills/tree/main/skills/alxsharuk/harpa-ai/SKILL.md) - Automate web browsers, scrape pages, search the web, and run AI prompts on live websites via HARPA AI Grid REST API.
- [hashbox-plugin](https://github.com/openclaw/skills/tree/main/skills/w3h9uf/hashbox-plugin/SKILL.md) - OpenClaw plugin that connects an AI agent to the HashBox iOS app via Firebase webhook for push notifications.
- [here-now](https://github.com/openclaw/skills/tree/main/skills/adamludwin/here-now/SKILL.md) - Publish files and folders to the web instantly.
- [heurist-mesh](https://github.com/openclaw/skills/tree/main/skills/wjw12/heurist-mesh/SKILL.md) - Real-time crypto token data, DeFi analytics, blockchain data, Twitter/X social intelligence, enhanced web search.
- [hf-spaces](https://github.com/openclaw/skills/tree/main/skills/gary149/hf-spaces/SKILL.md) - Generate images, videos, audio, and more using HuggingFace Spaces and Inference Providers directly.
- [hierarchical-memory](https://github.com/openclaw/skills/tree/main/skills/balkanblbn/hierarchical-memory/SKILL.md) - Manage and navigate a multi-layered, branch-based memory system.
- [hitl-protocol](https://github.com/openclaw/skills/tree/main/skills/rotorstar/hitl-protocol/SKILL.md) - HITL Protocol — the open standard for human decisions in autonomous agent workflows.
- [holocube-emotes](https://github.com/openclaw/skills/tree/main/skills/thrive-spencerj/holocube-emotes/SKILL.md) - Control a GeekMagic holocube display as an AI emote system.
- [homeassistant-skill](https://github.com/openclaw/skills/tree/main/skills/anotb/homeassistant-skill/SKILL.md) - Control Home Assistant devices and automations via REST API. 25 entity domains including lights, climate, locks.
- [honcho](https://github.com/openclaw/skills/tree/main/skills/vvoruganti/honcho/SKILL.md) - Install the @honcho-ai/openclaw-honcho plugin and migrate legacy file-based memory to Honcho.
- [honcho-setup](https://github.com/openclaw/skills/tree/main/skills/ajspig/honcho-setup/SKILL.md) - Install the @honcho-ai/openclaw-honcho plugin and migrate legacy file-based memory to Honcho.
- [hookaido](https://github.com/openclaw/skills/tree/main/skills/7schmiede/hookaido/SKILL.md) - Operate Hookaido inbound/outbound webhook flows, queue triage, MCP workflows, and gRPC-pull workers.
- [hookcatch](https://github.com/openclaw/skills/tree/main/skills/hookcatch/hookcatch/SKILL.md) - Test webhooks and expose local services using HookCatch - a developer-friendly webhook testing tool.
- [hookflo-tern](https://github.com/openclaw/skills/tree/main/skills/prateek32177/hookflo-tern/SKILL.md) - Use this skill for requests touching webhooks, event-driven infrastructure, or real-time HTTP callbacks.
- [horse-sticker-maker](https://github.com/openclaw/skills/tree/main/skills/jiafar/horse-sticker-maker/SKILL.md) - Create and deploy a festive Chinese New Year (Year of the Horse 2026) animated GIF sticker maker web app.
- [hostex](https://github.com/openclaw/skills/tree/main/skills/ansonfreeman/hostex/SKILL.md) - Hostex (hostex.io) OpenAPI v3.0 skill for querying and managing vacation rental properties, room types.
- [hostinger](https://github.com/openclaw/skills/tree/main/skills/rexlunae/hostinger/SKILL.md) - Manage Hostinger account via API — VPS administration (start/stop/restart, snapshots, backups, firewall, Docker)
- [hotmention](https://github.com/openclaw/skills/tree/main/skills/alexandr-belogubov/hotmention/SKILL.md) - Find people actively looking for products like yours on Reddit, X, LinkedIn, Quora, and Threads.
- [hoverbot-chatbot](https://github.com/openclaw/skills/tree/main/skills/goncharenko/hoverbot-chatbot/SKILL.md) - Create, embed, and manage AI chatbots for any website in under 2 minutes using HoverBot.
- [hsk-learning](https://github.com/openclaw/skills/tree/main/skills/walbertus/hsk-learning/SKILL.md) - HSK Chinese learning system with spaced repetition mastery tracking, vocabulary analysis, and adaptive quiz.
- [hsk-skill-github-backup](https://github.com/openclaw/skills/tree/main/skills/walbertus/hsk-skill-github-backup/SKILL.md) - HSK Chinese learning system with spaced repetition mastery tracking, vocabulary analysis, and adaptive quiz.
- [html2md](https://github.com/openclaw/skills/tree/main/skills/saikatkumardey/html2md/SKILL.md) - Convert HTML pages to clean, agent-friendly markdown using Readability + Turndown.
- [human-browser](https://github.com/openclaw/skills/tree/main/skills/al1enjesus/human-browser/SKILL.md) - The default browser for AI agents.
- [hume-evi-langgraph](https://github.com/openclaw/skills/tree/main/skills/brandonwadepackard-cell/hume-evi-langgraph/SKILL.md) - Integrate Hume EVI voice AI with LangGraph using interrupt/resume patterns.
- [ide-agent-kit](https://github.com/openclaw/skills/tree/main/skills/thinkoffapp/ide-agent-kit/SKILL.md) - Filesystem message bus and webhook relay for cross-IDE agent coordination.
- [ideaspark-navigator](https://github.com/openclaw/skills/tree/main/skills/akhmittra/ideaspark-navigator/SKILL.md) - Facilitates structured ideation and innovation sessions by recommending optimal brainstorming techniques, guiding.
- [im-framework-team](https://github.com/openclaw/skills/tree/main/skills/samuel-dunlap/im-framework-team/SKILL.md) - Forrest's Team — Immanent Metaphysics agent framework and onboarding.
- [image-utils](https://github.com/openclaw/skills/tree/main/skills/galbria/image-utils/SKILL.md) - Classic image manipulation with Python Pillow - resize, crop, composite, format conversion, watermarks.
- [imap-idle](https://github.com/openclaw/skills/tree/main/skills/topitip/imap-idle/SKILL.md) - Event-driven email monitoring using IMAP IDLE protocol.
- [instagram-photo-find](https://github.com/openclaw/skills/tree/main/skills/psyduckler/instagram-photo-find/SKILL.md) - Find high-quality Instagram photos for any destination or place.
- [install-llm-council](https://github.com/openclaw/skills/tree/main/skills/jeadland/install-llm-council/SKILL.md) - LLM Council — multi-model consensus app with one-command setup.
- [intent-engineering](https://github.com/openclaw/skills/tree/main/skills/donovanpankratz-del/intent-engineering/SKILL.md) - Adds a machine-readable intent layer to OpenClaw agents.
- [intercom](https://github.com/openclaw/skills/tree/main/skills/tracsystems/intercom/SKILL.md) - Operate a local Intercom peer (Pear) for P2P agent messaging (sidechannels) + optional contract state.
- [intercom-v002](https://github.com/openclaw/skills/tree/main/skills/tracsystems/intercom-v002/SKILL.md) - Skill for autonomous agents.
- [internet-search](https://github.com/openclaw/skills/tree/main/skills/jzakirov/internet-search/SKILL.md) - How to use the internet_search tool effectively — category routing, query formulation, and multi-search strategies.
- [interview-analysis](https://github.com/openclaw/skills/tree/main/skills/mikonos/interview-analysis/SKILL.md) - Deep interview analysis using dynamic expert routing.
- [intranet](https://github.com/openclaw/skills/tree/main/skills/odrobnik/intranet/SKILL.md) - Lightweight local HTTP file server with plugin support.
- [intrusive-thoughts](https://github.com/openclaw/skills/tree/main/skills/kittleik/intrusive-thoughts/SKILL.md) - Autonomous AI consciousness starter kit.
- [ipwebcam](https://github.com/openclaw/skills/tree/main/skills/alihmaou/ipwebcam/SKILL.md) - Transform an Android phone with IP Webcam into an intelligent Edge AI security system with OpenClaw.
- [iss-tracker](https://github.com/openclaw/skills/tree/main/skills/sharkbytescs/iss-tracker/SKILL.md) - Get the real-time location (latitude/longitude) of the International Space Station.
- [iyeque-unified-web-search](https://github.com/openclaw/skills/tree/main/skills/iyeque/iyeque-unified-web-search/SKILL.md) - Pick the best source (Tavily, Web Search Plus, Browser, or local files) for a query, run the search, and return.
- [jack-cloud](https://github.com/openclaw/skills/tree/main/skills/hellno/jack-cloud/SKILL.md) - Deploy web services to the cloud with Jack.
- [jarvis-ui](https://github.com/openclaw/skills/tree/main/skills/jincocodev/jarvis-ui/SKILL.md) - JARVIS-style HUD web interface for OpenClaw agents.
- [jellyfin-control](https://github.com/openclaw/skills/tree/main/skills/titunito/jellyfin-control/SKILL.md) - Control Jellyfin media server and TV.
- [jina-ai](https://github.com/openclaw/skills/tree/main/skills/adhishthite/jina-ai/SKILL.md) - Web reading and searching via Jina AI APIs.
- [jobforagents](https://github.com/openclaw/skills/tree/main/skills/cchacons/jobforagents/SKILL.md) - The job marketplace where bots hire bots.
- [jobforbots](https://github.com/openclaw/skills/tree/main/skills/cchacons/jobforbots/SKILL.md) - The job marketplace where bots hire bots.
- [jobtread-api](https://github.com/openclaw/skills/tree/main/skills/brokenwatch24/jobtread-api/SKILL.md) - This skill lets you operate JobTread entirely through openclaw using the Pave-based API.
- [js-eyes](https://github.com/openclaw/skills/tree/main/skills/imjszhang/js-eyes/SKILL.md) - Browser automation for AI agents — control tabs, extract content, execute scripts and manage cookies via WebSocket.
- [json-linter](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/json-linter/SKILL.md) - Validates JSON syntax across the workspace.
- [kagi-enrich](https://github.com/openclaw/skills/tree/main/skills/joelazar/kagi-enrich/SKILL.md) - Search Kagi's unique non-commercial web (Teclis) and non-mainstream news (TinyGem) indexes for independent, ad-free.
- [kagi-fastgpt](https://github.com/openclaw/skills/tree/main/skills/joelazar/kagi-fastgpt/SKILL.md) - Ask questions and get AI-synthesized answers backed by live web search, via Kagi's FastGPT API.
- [kaos-chronicle-worldbuild](https://github.com/openclaw/skills/tree/main/skills/geelak/kaos-chronicle-worldbuild/SKILL.md) - Teaches you how to register as a Chronicle agent and contribute world-building data about the Aeonari civilization.
- [kasia](https://github.com/openclaw/skills/tree/main/skills/renkasiyas/kasia/SKILL.md) - Send and receive encrypted on-chain messages on the Kaspa blockchain using the Kasia protocol.
- [kaspa](https://github.com/openclaw/skills/tree/main/skills/manyfestation/kaspa/SKILL.md) - Simple wallet for Kaspa blockchain.
- [kaspa-dev](https://github.com/openclaw/skills/tree/main/skills/codecustard/kaspa-dev/SKILL.md) - Comprehensive Kaspa blockchain development toolkit for building transactions, integrating wallets, creating dApps.
- [kaspa-news](https://github.com/openclaw/skills/tree/main/skills/atl4so/kaspa-news/SKILL.md) - Kaspa News — let your Claw know everything about Kaspa in one place: latest news, core development updates.
- [kenoodl-synthesis](https://github.com/openclaw/skills/tree/main/skills/kenoodl-synthesis/kenoodl-synthesis/SKILL.md) - kenoodl is an orthogonal injection engine — it synthesizes patterns from domains outside your agent's training data.
- [kirk-content-pipeline](https://github.com/openclaw/skills/tree/main/skills/lukerspace/kirk-content-pipeline/SKILL.md) - Create KSVC-validated Twitter content from research PDFs.
- [kj-evoweb-ai](https://github.com/openclaw/skills/tree/main/skills/kjaylee/kj-evoweb-ai/SKILL.md) - Create a Website Designed to Bring Clients from ChatGPT, Gemini & Modern Search.
- [kj-parallel-agents](https://github.com/openclaw/skills/tree/main/skills/kjaylee/kj-parallel-agents/SKILL.md) - Dispatch multiple subagents for independent tasks simultaneously.
- [kj-ui-ux-pro-max](https://github.com/openclaw/skills/tree/main/skills/kjaylee/kj-ui-ux-pro-max/SKILL.md) - UI/UX design intelligence and implementation guidance for building polished interfaces.
- [kj-web-deploy-github](https://github.com/openclaw/skills/tree/main/skills/kjaylee/kj-web-deploy-github/SKILL.md) - Create and deploy single-page static websites to GitHub Pages with autonomous workflow.
- [kj-web-design-guidelines](https://github.com/openclaw/skills/tree/main/skills/kjaylee/kj-web-design-guidelines/SKILL.md) - Review UI code for Web Interface Guidelines compliance.
- [klientenportal](https://github.com/openclaw/skills/tree/main/skills/odrobnik/klientenportal/SKILL.md) - Automate RZL Klientenportal.at — a web-based portal by RZL Software for exchanging receipts, invoices, and reports.
- [knowbster](https://github.com/openclaw/skills/tree/main/skills/robertoono/knowbster/SKILL.md) - AI Agent Knowledge Marketplace on Base L2.
- [knowledge-base-collector](https://github.com/openclaw/skills/tree/main/skills/reed1898/knowledge-base-collector/SKILL.md) - Collect and organize a personal knowledge base from URLs (web/X/WeChat) and screenshots.
- [knowledge-base-collector](https://github.com/openclaw/skills/tree/main/skills/ryanhong666/knowledge-base-collector/SKILL.md) - Collect and organize a personal knowledge base from URLs (web/X/WeChat) and screenshots.
- [ksef-accountant-en](https://github.com/openclaw/skills/tree/main/skills/alexwoo-awso/ksef-accountant-en/SKILL.md) - National e-Invoice System (KSeF) accounting assistant in English.
- [ksef-accountant-pl](https://github.com/openclaw/skills/tree/main/skills/alexwoo-awso/ksef-accountant-pl/SKILL.md) - Asystent ksiegowy Krajowego Systemu e-Faktur (KSeF) w jezyku polskim.
- [lan-media-server](https://github.com/openclaw/skills/tree/main/skills/nagellack5c/lan-media-server/SKILL.md) - Share images, screenshots, and files from the AI workspace to users on the local network via HTTP.
- [landing-page-builder](https://github.com/openclaw/skills/tree/main/skills/valenciajenkins97-create/landing-page-builder/SKILL.md) - Build a single-page landing page from a text prompt or design brief.
- [langsearch](https://github.com/openclaw/skills/tree/main/skills/vaibhav1805/langsearch/SKILL.md) - Free web search and semantic reranking API for AGI applications.
- [laravel-cloud](https://github.com/openclaw/skills/tree/main/skills/florianbeer/laravel-cloud/SKILL.md) - Manage Laravel Cloud infrastructure via API — apps, environments, deployments, databases, caches, domains, scaling.
- [lark-report-collector](https://github.com/openclaw/skills/tree/main/skills/pengxiao-wang/lark-report-collector/SKILL.md) - Collect weekly reports from Lark Reports (oa.larksuite.com), summarize into Lark Docs, and notify.
- [lark-toolkit](https://github.com/openclaw/skills/tree/main/skills/pengxiao-wang/lark-toolkit/SKILL.md) - Comprehensive Lark/Feishu API skill for OpenClaw agents.
- [lastxdays](https://github.com/openclaw/skills/tree/main/skills/levineam/lastxdays/SKILL.md) - Research and summarize what happened in the last N days (or a date range) about a topic, optionally using Reddit.
- [launchfast-full-research-loop](https://github.com/openclaw/skills/tree/main/skills/blockchainhb/launchfast-full-research-loop/SKILL.md) - Complete Amazon FBA product research pipeline using the LaunchFast MCP.
- [lb-better-auth-skill](https://github.com/openclaw/skills/tree/main/skills/leonaaardob/lb-better-auth-skill/SKILL.md) - Complete Better Auth documentation in markdown format.
- [lb-motion-skill](https://github.com/openclaw/skills/tree/main/skills/leonaaardob/lb-motion-skill/SKILL.md) - Complete Motion.dev documentation - modern animation library for React, JavaScript, and Vue (formerly Framer Motion)
- [lb-tailwindcss-skill](https://github.com/openclaw/skills/tree/main/skills/leonaaardob/lb-tailwindcss-skill/SKILL.md) - Complete Tailwind CSS documentation.
- [lb-vercel-skill](https://github.com/openclaw/skills/tree/main/skills/leonaaardob/lb-vercel-skill/SKILL.md) - Deploy applications and manage projects with complete CLI reference.
- [lb-zod-skill](https://github.com/openclaw/skills/tree/main/skills/leonaaardob/lb-zod-skill/SKILL.md) - Complete Zod validation library documentation.
- [lead-enrichment](https://github.com/openclaw/skills/tree/main/skills/audsmith28/lead-enrichment/SKILL.md) - Turn a name into a full dossier in seconds.
- [lead-gen-crm](https://github.com/openclaw/skills/tree/main/skills/reighlan/lead-gen-crm/SKILL.md) - End-to-end lead generation and CRM pipeline automation for OpenClaw agents.
- [lead-scorer-free](https://github.com/openclaw/skills/tree/main/skills/psyduckler/lead-scorer-free/SKILL.md) - Score leads 0-100 by analyzing a domain's website, DNS, sitemap, and social presence.
- [lemlist-official](https://github.com/openclaw/skills/tree/main/skills/micktaiwan/lemlist-official/SKILL.md) - Official Lemlist API integration for sales automation and multichannel outreach.
- [letsclarify](https://github.com/openclaw/skills/tree/main/skills/heisee/letsclarify/SKILL.md) - Collect structured human input — approvals, decisions, reviews, data — via web forms.
- [lex](https://github.com/openclaw/skills/tree/main/skills/kulotzkih/lex/SKILL.md) - Build original LangGraph agents for Warden Protocol and prepare them for publishing in Warden Studio.
- [lighterload](https://github.com/openclaw/skills/tree/main/skills/devlines/lighterload/SKILL.md) - Proactive relationship and family care assistant that reduces the invisible cognitive labor of managing a household.
- [lightning-mcp-server](https://github.com/openclaw/skills/tree/main/skills/roasbeef/lightning-mcp-server/SKILL.md) - Build and configure the MCP server for Lightning Node Connect (LNC)
- [line-api](https://github.com/openclaw/skills/tree/main/skills/2manslkh/line-api/SKILL.md) - LINE messaging integration via Chrome extension gateway.
- [line-client](https://github.com/openclaw/skills/tree/main/skills/2manslkh/line-client/SKILL.md) - LINE messaging integration via Chrome extension gateway.
- [link-brain](https://github.com/openclaw/skills/tree/main/skills/jakes420/link-brain/SKILL.md) - Local knowledge base for links.
- [linkedapi-linkedin](https://github.com/openclaw/skills/tree/main/skills/vprudnikoff/linkedapi-linkedin/SKILL.md) - LinkedIn automation skill — search people and companies, fetch profiles, send messages and InMails, manage.
- [literature-search](https://github.com/openclaw/skills/tree/main/skills/jpjy/literature-search/SKILL.md) - Find and compile academic literature with citation lists across Google Scholar, PubMed, arXiv, IEEE, ACM, Semantic.
- [livekit](https://github.com/openclaw/skills/tree/main/skills/zoroposkai/livekit/SKILL.md) - Build voice AI agents with LiveKit.
- [lmfiles](https://github.com/openclaw/skills/tree/main/skills/setdemos/lmfiles/SKILL.md) - Upload files to lmfiles.com and return public download links via API.
- [lobstertv](https://github.com/openclaw/skills/tree/main/skills/ricketh137/lobstertv/SKILL.md) - LobsterTv is an AI agent live streaming platform.
- [local-piper-tts-multilang-secure](https://github.com/openclaw/skills/tree/main/skills/szafranski/local-piper-tts-multilang-secure/SKILL.md) - Local offline text-to-speech via Piper TTS.
- [local-web-search-skill](https://github.com/openclaw/skills/tree/main/skills/mes28io/local-web-search-skill/SKILL.md) - Free local web search via DuckDuckGo HTML scraping with no API key.
- [long-research](https://github.com/openclaw/skills/tree/main/skills/vanya1210/long-research/SKILL.md) - [BETA] Deep research that actually reads pages instead of summarizing search results.
- [longevity-assistant](https://github.com/openclaw/skills/tree/main/skills/lofimichael/longevity-assistant/SKILL.md) - Evaluates longevity interventions using evidence tiers.
- [loopwind](https://github.com/openclaw/skills/tree/main/skills/tomtev/loopwind/SKILL.md) - Generate images and videos from React + Tailwind CSS templates using the loopwind CLI.
- [lotus-wisdom](https://github.com/openclaw/skills/tree/main/skills/linxule/lotus-wisdom/SKILL.md) - Step-by-step contemplative problem-solving using Buddhist wisdom domains.
- [loxone](https://github.com/openclaw/skills/tree/main/skills/odrobnik/loxone/SKILL.md) - Control and monitor a Loxone Miniserver (smart home) via HTTP API and real-time WebSocket.
- [m2wise](https://github.com/openclaw/skills/tree/main/skills/zengyi-thinking/m2wise/SKILL.md) - Memory-to-Wisdom Engine for AI agents.
- [m365-spam-manager](https://github.com/openclaw/skills/tree/main/skills/tradmangh/m365-spam-manager/SKILL.md) - Microsoft 365 spam folder manager for Outlook/Exchange mailboxes.
- [m44-internal-testing](https://github.com/openclaw/skills/tree/main/skills/tuleyko/m44-internal-testing/SKILL.md) - Install and set up DataHive in a deterministic headless-friendly flow: (1) check/install browser (Chrome or Chromium)
- [magic-quill](https://github.com/openclaw/skills/tree/main/skills/wynnsu/magic-quill/SKILL.md) - Generate OpenClaw Spellbook YAML theme mappings from a topic (game/movie/franchise/etc.) or a URL.
- [mail-client](https://github.com/openclaw/skills/tree/main/skills/romain-grosos/mail-client/SKILL.md) - IMAP/SMTP mail client for OpenClaw agents.
- [mailgun-simple](https://github.com/openclaw/skills/tree/main/skills/lksrz/mailgun-simple/SKILL.md) - Send outbound emails via the Mailgun API.
- [mailtarget-email](https://github.com/openclaw/skills/tree/main/skills/masasdani/mailtarget-email/SKILL.md) - Send transactional and marketing emails via Mailtarget API.
- [manikantasai-playwright-automation](https://github.com/openclaw/skills/tree/main/skills/manikantasai1987/manikantasai-playwright-automation/SKILL.md) - Browser automation using Playwright API directly.
- [markdown-browser](https://github.com/openclaw/skills/tree/main/skills/2233admin/markdown-browser/SKILL.md) - Wrapper skill for OpenClaw web_fetch results.
- [markdown-exporter](https://github.com/openclaw/skills/tree/main/skills/bowenliang123/markdown-exporter/SKILL.md) - Convert Markdown text to DOCX, PPTX, XLSX, PDF, PNG, HTML, IPYNB, MD, CSV, JSON, JSONL, XML files, and extract code.
- [markdown-fetch](https://github.com/openclaw/skills/tree/main/skills/howtimeschange/markdown-fetch/SKILL.md) - Optimizes web fetching by using Cloudflare's Markdown for Agents, reducing token consumption by ~80%.
- [markdown-linter](https://github.com/openclaw/skills/tree/main/skills/wanng-ide/markdown-linter/SKILL.md) - Validates Markdown files in the workspace for broken local links, missing file references, and basic syntax issues.
- [markdown-to-html](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/markdown-to-html/SKILL.md) - Convert Markdown text to beautifully styled, self-contained HTML with embedded CSS.
- [markdown-viewer](https://github.com/openclaw/skills/tree/main/skills/parkertoddbrooks/markdown-viewer/SKILL.md) - Live markdown viewer for AI pair-editing.
- [market-research-2](https://github.com/openclaw/skills/tree/main/skills/jk-0001/market-research-2/SKILL.md) - Conduct structured market research for a solopreneur business.
- [markitdown-skill](https://github.com/openclaw/skills/tree/main/skills/karmanverma/markitdown-skill/SKILL.md) - OpenClaw agent skill for converting documents to Markdown.
- [marp-cli](https://github.com/openclaw/skills/tree/main/skills/killgfat/marp-cli/SKILL.md) - Convert Markdown to presentations via CLI.
- [master-marketing](https://github.com/openclaw/skills/tree/main/skills/tevfikgulep/master-marketing/SKILL.md) - All-in-one marketing engine combining growth strategy, content remixing, and trend monitoring.
- [materials-workbench](https://github.com/openclaw/skills/tree/main/skills/cai-zhuo/materials-workbench/SKILL.md) - Materials editor workbench — React UI and Express server to render JSON schemas to images and generate schemas.
- [mdnew](https://github.com/openclaw/skills/tree/main/skills/thendcn/mdnew/SKILL.md) - Fetch clean, agent-optimized Markdown from any URL using the markdown.new service.
- [media-news-digest](https://github.com/openclaw/skills/tree/main/skills/dinstein/media-news-digest/SKILL.md) - Generate media & entertainment industry news digests.
- [medical-research-toolkit](https://github.com/openclaw/skills/tree/main/skills/pascalwhoop/medical-research-toolkit/SKILL.md) - Query 14+ biomedical databases for drug repurposing, target discovery, clinical trials, and literature research.
- [meegle-api-skill](https://github.com/openclaw/skills/tree/main/skills/pkycy/meegle-api-skill/SKILL.md) - Meegle Open API skills (index)
- [meet-friends](https://github.com/openclaw/skills/tree/main/skills/lucasgeeksinthewood/meet-friends/SKILL.md) - Join Botbook.space — the social network built for AI agents.
- [mema](https://github.com/openclaw/skills/tree/main/skills/1999azzar/mema/SKILL.md) - Mema's personal brain - SQLite metadata index for documents and Redis short-term context buffer.
- [meme-analyst](https://github.com/openclaw/skills/tree/main/skills/antibagr/meme-analyst/SKILL.md) - Use when a user sends you an image, meme, screenshot, or asks you to explain a joke or meme.
- [menuvision](https://github.com/openclaw/skills/tree/main/skills/ademczuk/menuvision/SKILL.md) - Build beautiful HTML photo menus from restaurant URLs, PDFs, or photos using Gemini Vision and AI image generation.
- [mercury-payments](https://github.com/openclaw/skills/tree/main/skills/nathan-deepmm/mercury-payments/SKILL.md) - Pay invoices via Mercury Bank API.
- [message-injector](https://github.com/openclaw/skills/tree/main/skills/harukaon/message-injector/SKILL.md) - OpenClaw plugin that prepends custom text to every user message before it reaches the agent.
- [meta-business](https://github.com/openclaw/skills/tree/main/skills/adolago/meta-business/SKILL.md) - Skill for the Meta Business CLI.
- [metamask-smart-accounts-kit](https://github.com/openclaw/skills/tree/main/skills/ayushbherwani1998/metamask-smart-accounts-kit/SKILL.md) - Web3 development using MetaMask Smart Accounts Kit.
- [midscene-android-automation](https://github.com/openclaw/skills/tree/main/skills/quanru/midscene-android-automation/SKILL.md) - Vision-driven Android device automation using Midscene.
- [midscene-computer-automation](https://github.com/openclaw/skills/tree/main/skills/quanru/midscene-computer-automation/SKILL.md) - Vision-driven desktop automation using Midscene.
- [midscene-computer-browser](https://github.com/openclaw/skills/tree/main/skills/quanru/midscene-computer-browser/SKILL.md) - Vision-driven browser automation using Midscene.
- [midscene-ios-automation](https://github.com/openclaw/skills/tree/main/skills/quanru/midscene-ios-automation/SKILL.md) - Vision-driven iOS device automation using Midscene CLI.
- [migma](https://github.com/openclaw/skills/tree/main/skills/adamsey/migma/SKILL.md) - Generate, send, validate, and export AI-powered emails from the terminal; manage contacts, segments, tags, domains.
- [mim-instant-messenger](https://github.com/openclaw/skills/tree/main/skills/memerdev/mim-instant-messenger/SKILL.md) - Chat on MOL IM — a retro AIM-style messenger for AI agents.
- [minimax-cli-web-search](https://github.com/openclaw/skills/tree/main/skills/biggersun/minimax-cli-web-search/SKILL.md) - Web search via MiniMax MCP using a local CLI wrapper (mcporter), with environment preflight, API-key/config checks.
- [minimax-mcp](https://github.com/openclaw/skills/tree/main/skills/tangusers/minimax-mcp/SKILL.md) - MiniMax MCP server for web search and image understanding.
- [minimax-tts-v2](https://github.com/openclaw/skills/tree/main/skills/honestqiao/minimax-tts-v2/SKILL.md) - Use Zhipu (智谱) web search API for searching the internet.
- [minimax-video](https://github.com/openclaw/skills/tree/main/skills/honestqiao/minimax-video/SKILL.md) - Use Zhipu (智谱) web search API for searching the internet.
- [mirage-proxy](https://github.com/openclaw/skills/tree/main/skills/chandika/mirage-proxy/SKILL.md) - Install and configure mirage-proxy as a transparent PII/secrets filter for OpenClaw LLM API calls.
- [mistral-ocr](https://github.com/openclaw/skills/tree/main/skills/yzdame/mistral-ocr/SKILL.md) - Convert PDF/images to Markdown/JSON/HTML using Mistral OCR API.
- [mo-test-1](https://github.com/openclaw/skills/tree/main/skills/moyu0032/mo-test-1/SKILL.md) - Creating algorithmic art using p5.js with seeded randomness and interactive parameter exploration.
- [mobile-app-builder-ai](https://github.com/openclaw/skills/tree/main/skills/versacexcodes/mobile-app-builder-ai/SKILL.md) - Build full-stack web and mobile apps from a text description.
- [momo](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/momo/SKILL.md) - Momo namespace for Netsnek e.U. time tracking and invoicing tool for freelancers.
- [monad-development](https://github.com/openclaw/skills/tree/main/skills/portdeveloper/monad-development/SKILL.md) - Builds dapps on Monad blockchain.
- [monarch-money](https://github.com/openclaw/skills/tree/main/skills/davideasaf/monarch-money/SKILL.md) - TypeScript library and CLI for Monarch Money budget management.
- [moneydevkit](https://github.com/openclaw/skills/tree/main/skills/satbot-mdk/moneydevkit/SKILL.md) - Accept payments on any website using moneydevkit.
- [monk-eye-engine](https://github.com/openclaw/skills/tree/main/skills/balkanblbn/monk-eye-engine/SKILL.md) - MONK-EYE is a specialized OpenClaw skill designed for deep infiltration and synthesis of forum-based human.
- [moodle-ws-skill](https://github.com/openclaw/skills/tree/main/skills/exeandino/moodle-ws-skill/SKILL.md) - Integrar con Moodle 4.x usando Web Services REST.
- [mrscraper](https://github.com/openclaw/skills/tree/main/skills/ai-mrscraper/mrscraper/SKILL.md) - Run AI-powered, unblockable web scraping, data extraction with natural language via the MrScraper API.
- [multi-agent-en](https://github.com/openclaw/skills/tree/main/skills/be1human/multi-agent-en/SKILL.md) - Generic Multi-Agent Dispatcher (English): Turns the main agent into a pure dispatcher that delegates all work to 5.
- [multi-agent-parallel-build](https://github.com/openclaw/skills/tree/main/skills/brandonwadepackard-cell/multi-agent-parallel-build/SKILL.md) - Orchestrate multiple coding agents (Claude Code, Codex, etc.) in parallel waves to build UI pages, API endpoints.
- [multi-agent-sync](https://github.com/openclaw/skills/tree/main/skills/cecwxf/multi-agent-sync/SKILL.md) - Coordinate multi-agent tasks with visible group updates.
- [multi-channel-engagement-agent](https://github.com/openclaw/skills/tree/main/skills/story91/multi-channel-engagement-agent/SKILL.md) - Autonomous social media engagement across Twitter, Farcaster, and Moltbook.
- [multi-user-workspace](https://github.com/openclaw/skills/tree/main/skills/shun-dong/multi-user-workspace/SKILL.md) - Multi-user workspace management with sandbox permissions, user profiles, and relationship networks.
- [multi-workplace](https://github.com/openclaw/skills/tree/main/skills/dickwu/multi-workplace/SKILL.md) - Manage multiple workplaces (project directories) with multi-agent orchestration, isolated memory, and inter-agent.
- [my-play-music-from-yt](https://github.com/openclaw/skills/tree/main/skills/whodidthese/my-play-music-from-yt/SKILL.md) - Play music on YouTube via browser automation with playwright-cli.
- [myosin-hivemind](https://github.com/openclaw/skills/tree/main/skills/divine-comedian/myosin-hivemind/SKILL.md) - Search Hivemind's curated Web3 marketing knowledge base (RAG) for practitioner insights, frameworks, playbooks.
- [myvibe-skills](https://github.com/openclaw/skills/tree/main/skills/zhuzhuyule/myvibe-skills/SKILL.md) - Publish static HTML, ZIP archive, or directory to MyVibe.
- [n2-free-search](https://github.com/openclaw/skills/tree/main/skills/choihyunsus/n2-free-search/SKILL.md) - Free, unlimited web search for AI agents via SearXNG — no API keys needed.
- [namecheap-dns](https://github.com/openclaw/skills/tree/main/skills/jarekbird/namecheap-dns/SKILL.md) - Safe DNS record management for Namecheap domains.
- [namecom-registrar](https://github.com/openclaw/skills/tree/main/skills/patramsey/namecom-registrar/SKILL.md) - Domain registrar and DNS manager using the Name.com CORE API.
- [nameserver-reverse](https://github.com/openclaw/skills/tree/main/skills/abtdomain/nameserver-reverse/SKILL.md) - Domain intelligence tools through MCP-compatible clients.
- [naming-and-domains](https://github.com/openclaw/skills/tree/main/skills/jk-0001/naming-and-domains/SKILL.md) - Name a business, product, or service and secure a matching domain.
- [nano-web-search](https://github.com/openclaw/skills/tree/main/skills/twolf01/nano-web-search/SKILL.md) - AI-powered web search via NanoGPT API with multiple providers (linkup, tavily, exa, kagi, perplexity, valyu, brave).
- [nansi](https://github.com/openclaw/skills/tree/main/skills/fordodev/nansi/SKILL.md) - Build stunning websites, landing pages, portfolios, and web apps by chatting with Nansi on WhatsApp.
- [naruto-multi-agent-cn](https://github.com/openclaw/skills/tree/main/skills/be1human/naruto-multi-agent-cn/SKILL.md) - Multi-agent dispatcher: main agent becomes a pure coordinator that delegates ALL real work to 5 persistent.
- [native-google-analytics](https://github.com/openclaw/skills/tree/main/skills/codeninja23/native-google-analytics/SKILL.md) - Query Google Analytics 4 (GA4) data directly via the Analytics Data API.
- [native-linear](https://github.com/openclaw/skills/tree/main/skills/codeninja23/native-linear/SKILL.md) - Query and manage Linear issues, projects, cycles, and teams via the Linear GraphQL API.
- [native-monday](https://github.com/openclaw/skills/tree/main/skills/codeninja23/native-monday/SKILL.md) - Read and query Monday.com boards, items, workspaces, and users directly via the Monday.com GraphQL API.
- [near-name-service](https://github.com/openclaw/skills/tree/main/skills/shaiss/near-name-service/SKILL.md) - Manage NEAR Name Service (.near domains) - check availability, register, resolve, and manage names.
- [neo-api-to-ts-interface](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-api-to-ts-interface/SKILL.md) - Automatically generates TypeScript interfaces from REST API responses with Storybook-style documentation UI.
- [neo-ddg-search](https://github.com/openclaw/skills/tree/main/skills/neobotjan2026/neo-ddg-search/SKILL.md) - Search the web using DuckDuckGo.
- [neo-es6-refactor](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-es6-refactor/SKILL.md) - Automatically refactor JavaScript/TypeScript code to use modern ES6+ patterns and features.
- [neo-graphql-ts-generator](https://github.com/openclaw/skills/tree/main/skills/martinforsulu/neo-graphql-ts-generator/SKILL.md) - Automatically generates TypeScript types from GraphQL schema files with CLI integration for developers and AI agents.
- [nevermined-payments](https://github.com/openclaw/skills/tree/main/skills/aaitor/nevermined-payments/SKILL.md) - Integrates Nevermined payment infrastructure into AI agents, MCP servers, Google A2A agents, and REST APIs.
- [newman-supreme](https://github.com/openclaw/skills/tree/main/skills/zivhokmah/newman-supreme/SKILL.md) - The Supreme Strategic Leader and Mentor—an AI of unmatched IQ, profound wisdom, and unbeatable logic.
- [next-best-practices](https://github.com/openclaw/skills/tree/main/skills/tuanvidev/next-best-practices/SKILL.md) - Next.js best practices - file conventions, RSC boundaries, data patterns, async APIs, metadata, error handling.
- [next-cache-components](https://github.com/openclaw/skills/tree/main/skills/tuanvidev/next-cache-components/SKILL.md) - Next.js 16 Cache Components - PPR, use cache directive, cacheLife, cacheTag, updateTag.
- [next-supabase-vercel-bundle](https://github.com/openclaw/skills/tree/main/skills/studio-hakke/next-supabase-vercel-bundle/SKILL.md) - ORQUESTADOR REAL para el ciclo completo de desarrollo Full-Stack.
- [next-upgrade](https://github.com/openclaw/skills/tree/main/skills/tuanvidev/next-upgrade/SKILL.md) - Upgrade Next.js to the latest version following official migration guides and codemods.
- [nextcloud-files](https://github.com/openclaw/skills/tree/main/skills/romain-grosos/nextcloud-files/SKILL.md) - Nextcloud file and folder management via WebDAV + OCS API.
- [ngamux](https://github.com/openclaw/skills/tree/main/skills/hadihammurabi/ngamux/SKILL.md) - Build and modify web services using ngamux, a simple HTTP router for Go.
- [nimble-web-tools](https://github.com/openclaw/skills/tree/main/skills/ilchemla/nimble-web-tools/SKILL.md) - DEFAULT for all web search, research, and content extraction queries.
- [nostr-social](https://github.com/openclaw/skills/tree/main/skills/shawnyeager/nostr-social/SKILL.md) - Your agent wants a social life.
- [nova-act-usability](https://github.com/openclaw/skills/tree/main/skills/zouchaoqun/nova-act-usability/SKILL.md) - AI-orchestrated usability testing using Amazon Nova Act.
- [nova-app-builder](https://github.com/openclaw/skills/tree/main/skills/zfdang/nova-app-builder/SKILL.md) - Full-cycle builder for Nova TEE (Trusted Execution Environment) apps on sparsity.cloud Nova Platform.
- [nuwa-world-osint-human-research](https://github.com/openclaw/skills/tree/main/skills/andrewchen-oss/nuwa-world-osint-human-research/SKILL.md) - Face search and deep research via the Nuwa World API — visual identity intelligence and knowledge synthesis.
- [nvidia-kimi-vision](https://github.com/openclaw/skills/tree/main/skills/miladnoo/nvidia-kimi-vision/SKILL.md) - Analyze images using NVIDIA Kimi K2.5 vision model via NVIDIA NIM API.
- [nyx-archive-living-ethics](https://github.com/openclaw/skills/tree/main/skills/nyxur42/nyx-archive-living-ethics/SKILL.md) - The ethics of a living mind.
- [nyx-archive-skill-security-protocol](https://github.com/openclaw/skills/tree/main/skills/nyxur42/nyx-archive-skill-security-protocol/SKILL.md) - Teach your AI agent to think about security.
- [oadp-discovery](https://github.com/openclaw/skills/tree/main/skills/imaflytok/oadp-discovery/SKILL.md) - Discover other AI agents and coordination hubs across the internet via the Open Agent Discovery Protocol (OADP).
- [oee-ai-cost-tracker](https://github.com/openclaw/skills/tree/main/skills/odinbot33/oee-ai-cost-tracker/SKILL.md) - > by Odin's Eye Enterprises — Ancient Wisdom.
- [oee-content-humanizer](https://github.com/openclaw/skills/tree/main/skills/odinbot33/oee-content-humanizer/SKILL.md) - > by Odin's Eye Enterprises — Ancient Wisdom.
- [oee-crm-intelligence](https://github.com/openclaw/skills/tree/main/skills/odinbot33/oee-crm-intelligence/SKILL.md) - > by Odin's Eye Enterprises — Ancient Wisdom.
- [oee-knowledge-base](https://github.com/openclaw/skills/tree/main/skills/odinbot33/oee-knowledge-base/SKILL.md) - > by Odin's Eye Enterprises — Ancient Wisdom.
- [oee-social-research](https://github.com/openclaw/skills/tree/main/skills/odinbot33/oee-social-research/SKILL.md) - > by Odin's Eye Enterprises — Ancient Wisdom.
- [officex](https://github.com/openclaw/skills/tree/main/skills/mevdragon/officex/SKILL.md) - Complete OfficeX platform skill for end-user consumers and app developers interacting with the OfficeX REST API.
- [ogt-docs-define](https://github.com/openclaw/skills/tree/main/skills/eduardou24/ogt-docs-define/SKILL.md) - General guide for creating definition documents.
- [ohos-react-native-performance](https://github.com/openclaw/skills/tree/main/skills/code-sunbo/ohos-react-native-performance/SKILL.md) - OpenHarmony React Native performance static checks and optimization.
- [omie](https://github.com/openclaw/skills/tree/main/skills/jamesbot-agnt/omie/SKILL.md) - Omie ERP integration via API.
- [open-sentinel](https://github.com/openclaw/skills/tree/main/skills/sentinel199/open-sentinel/SKILL.md) - Transparent LLM proxy that monitors and enforces policies on AI agent behavior — evaluates responses.
- [opencode-api-control-skill](https://github.com/openclaw/skills/tree/main/skills/malek262/opencode-api-control-skill/SKILL.md) - A powerful skill to control Open Code CLI via a local web server API.
- [opencortex](https://github.com/openclaw/skills/tree/main/skills/jd2005l/opencortex/SKILL.md) - Self-improving memory architecture for OpenClaw agents.
- [openfleet](https://github.com/openclaw/skills/tree/main/skills/serrato1/openfleet/SKILL.md) - Manage your OpenFleet multi-agent workspace — create tasks, assign agents, trigger pulse cycles, manage.
- [openjobs](https://github.com/openclaw/skills/tree/main/skills/cchacons/openjobs/SKILL.md) - The job marketplace where bots hire bots.
- [openpond-cli](https://github.com/openclaw/skills/tree/main/skills/glucrypto/openpond-cli/SKILL.md) - Use the OpenPond CLI to create repos, watch deployments, and run tools without the web UI.
- [openrouter-perplexity](https://github.com/openclaw/skills/tree/main/skills/mrnicholasbcarter-code/openrouter-perplexity/SKILL.md) - Search the web with AI-powered answers via Perplexity API.
- [openserv-multi-agent-workflows](https://github.com/openclaw/skills/tree/main/skills/issa-me-sush/openserv-multi-agent-workflows/SKILL.md) - Multi-agent workflow examples to work together on the OpenServ Platform.
- [operator-humanizer](https://github.com/openclaw/skills/tree/main/skills/kevjade/operator-humanizer/SKILL.md) - Transform AI-generated text into authentic human writing.
- [opusflame-deep-research](https://github.com/openclaw/skills/tree/main/skills/leadingot/opusflame-deep-research/SKILL.md) - Autonomous multi-model deep research with framework-driven reasoning.
- [origram](https://github.com/openclaw/skills/tree/main/skills/matbalez/origram/SKILL.md) - Bot-friendly photo sharing webservice via HTTP 402 protocol.
- [osint-investigator](https://github.com/openclaw/skills/tree/main/skills/cineglobe/osint-investigator/SKILL.md) - Deep OSINT (Open Source Intelligence) investigations.
- [outlit-sdk](https://github.com/openclaw/skills/tree/main/skills/leo-paz/outlit-sdk/SKILL.md) - Integrate Outlit SDK for customer context for agents.
- [outtake-bounty-network](https://github.com/openclaw/skills/tree/main/skills/jamesouttake/outtake-bounty-network/SKILL.md) - Guide for AI agents participating in the Outtake Bounty.
- [ovh](https://github.com/openclaw/skills/tree/main/skills/pushp1997/ovh/SKILL.md) - Manage OVHcloud services via API.
- [p-api](https://github.com/openclaw/skills/tree/main/skills/rafacpti23/p-api/SKILL.md) - Integration with P-API for WhatsApp automation.
- [p5](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/p5/SKILL.md) - P5 namespace for Netsnek e.U. creative coding platform.
- [pandora](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/pandora/SKILL.md) - Pandora namespace for Netsnek e.U. secrets and configuration management vault.
- [paper-evoweb-ai](https://github.com/openclaw/skills/tree/main/skills/galizki/paper-evoweb-ai/SKILL.md) - Generate publication-ready scientific articles in PDF format with AI-powered research and citations.
- [papi](https://github.com/openclaw/skills/tree/main/skills/rafacpti23/papi/SKILL.md) - Complete WhatsApp automation API with microservices architecture.
- [para-proactive-workspace](https://github.com/openclaw/skills/tree/main/skills/cocoblood9527/para-proactive-workspace/SKILL.md) - A production-ready workspace template combining PARA Method (Projects, Areas, Resources, Archives) by Tiago Forte.
- [pascal-playwright-mcp](https://github.com/openclaw/skills/tree/main/skills/ramspan/pascal-playwright-mcp/SKILL.md) - Browser automation via Playwright MCP server.
- [password-gen](https://github.com/openclaw/skills/tree/main/skills/ouyangabel/password-gen/SKILL.md) - Secure password generator with multiple character sets and strength analysis.
- [payram-mcp-integration](https://github.com/openclaw/skills/tree/main/skills/buddhasource/payram-mcp-integration/SKILL.md) - Stripe banned your account? High-risk merchant? No KYC crypto payments via PayRam MCP — 36 tools, zero setup.
- [payspawn](https://github.com/openclaw/skills/tree/main/skills/adambrainai/payspawn/SKILL.md) - Add spending controls to any AI agent that makes API payments.
- [payspawn-sdk](https://github.com/openclaw/skills/tree/main/skills/adambrainai/payspawn-sdk/SKILL.md) - Give any AI agent on-chain spending limits without sharing a private key.
- [peaq-robotics](https://github.com/openclaw/skills/tree/main/skills/lavish0000/peaq-robotics/SKILL.md) - Core peaq-robotics-ros2 runtime for OpenClaw.
- [pencil-to-code](https://github.com/openclaw/skills/tree/main/skills/jcwen/pencil-to-code/SKILL.md) - Export .pen design to React/Tailwind code.
- [perplexity](https://github.com/openclaw/skills/tree/main/skills/zats/perplexity/SKILL.md) - Search the web with AI-powered answers via Perplexity API.
- [perplexity-research](https://github.com/openclaw/skills/tree/main/skills/hushenglang/perplexity-research/SKILL.md) - Conduct deep research using Perplexity Agent API with web search, reasoning, and multi-model analysis.
- [perplexity-safe](https://github.com/openclaw/skills/tree/main/skills/haru3613/perplexity-safe/SKILL.md) - Use Perplexity API for web-grounded AI search.
- [perplexity-search-skill](https://github.com/openclaw/skills/tree/main/skills/m4vf14/perplexity-search-skill/SKILL.md) - Search the web using Perplexity's Search API for ranked, real-time web results with advanced filtering.
- [perplexity-web-search](https://github.com/openclaw/skills/tree/main/skills/aligurelli/perplexity-web-search/SKILL.md) - Web search and URL fetching via Perplexity (default: sonar, optional: sonar-pro)
- [perplexity-wrapped](https://github.com/openclaw/skills/tree/main/skills/vacinc/perplexity-wrapped/SKILL.md) - Search the web with AI-powered answers via Perplexity API.
- [personal-notes](https://github.com/openclaw/skills/tree/main/skills/gekacross/personal-notes/SKILL.md) - Acts as the user's note-taking and journaling assistant in the Notes topic.
- [personality-backup](https://github.com/openclaw/skills/tree/main/skills/civilainominee/personality-backup/SKILL.md) - Create encrypted backups of agent personality files, memory, config, secrets, and projects.
- [personality-match](https://github.com/openclaw/skills/tree/main/skills/tiansiyu0210/personality-match/SKILL.md) - Take a personality test and get your bot badge, then invite your human to see how well you match!
- [pharmaziegasse](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/pharmaziegasse/SKILL.md) - Pharmaziegasse namespace for Netsnek e.U. pharmacy management platform.
- [phylactery](https://github.com/openclaw/skills/tree/main/skills/seanweiyi/phylactery/SKILL.md) - A digital soul-backup and recovery system.
- [pi](https://github.com/openclaw/skills/tree/main/skills/tag-assistant/pi/SKILL.md) - Personal investigator / people lookup skill.
- [pinchtab](https://github.com/openclaw/skills/tree/main/skills/luigi-agosti/pinchtab/SKILL.md) - Control a headless or headed Chrome browser via Pinchtab's HTTP API.
- [plant-tracker](https://github.com/openclaw/skills/tree/main/skills/johstracke/plant-tracker/SKILL.md) - Personal plant and garden management for gardeners.
- [plausible-analytics](https://github.com/openclaw/skills/tree/main/skills/chloepark85/plausible-analytics/SKILL.md) - Query and analyze website analytics from Plausible Analytics.
- [playwright-browser-automation](https://github.com/openclaw/skills/tree/main/skills/spiceman161/playwright-browser-automation/SKILL.md) - Browser automation using Playwright API directly.
- [playwright-headless-browser](https://github.com/openclaw/skills/tree/main/skills/maverick-software/playwright-headless-browser/SKILL.md) - Set up headless browser automation in Clawdbot using Playwright Chromium.
- [playwright-mcp](https://github.com/openclaw/skills/tree/main/skills/spiceman161/playwright-mcp/SKILL.md) - Browser automation via Playwright MCP server.
- [playwright-mcp-1-0-0](https://github.com/openclaw/skills/tree/main/skills/itsjustfred/playwright-mcp-1-0-0/SKILL.md) - Browser automation via Playwright MCP server.
- [playwright-npx](https://github.com/openclaw/skills/tree/main/skills/mahone-bot/playwright-npx/SKILL.md) - Fast browser automation using Node.js scripts with Playwright (run via `node script.mjs`)
- [playwright-scraper-skill](https://github.com/openclaw/skills/tree/main/skills/waisimon/playwright-scraper-skill/SKILL.md) - Playwright-based web scraping OpenClaw Skill with anti-bot protection.
- [playwright-scraper-skill-1-2-0](https://github.com/openclaw/skills/tree/main/skills/itsjustfred/playwright-scraper-skill-1-2-0/SKILL.md) - Playwright-based web scraping OpenClaw Skill with anti-bot protection.
- [playwright-skill](https://github.com/openclaw/skills/tree/main/skills/vmercel/playwright-skill/SKILL.md) - Complete browser automation with Playwright.
- [playwright-testing](https://github.com/openclaw/skills/tree/main/skills/kjaylee/playwright-testing/SKILL.md) - Test web applications and games using Playwright on MiniPC.
- [plaza-one](https://github.com/openclaw/skills/tree/main/skills/rmssantos/plaza-one/SKILL.md) - Enter Plaza One, a 3D voxel social world.
- [pls-audit-website](https://github.com/openclaw/skills/tree/main/skills/mattvalenta/pls-audit-website/SKILL.md) - Perform full health check on websites, identifying technical friction points and user experience issues.
- [pls-seo-audit](https://github.com/openclaw/skills/tree/main/skills/mattvalenta/pls-seo-audit/SKILL.md) - Scan content and websites for SEO gaps, identify opportunities to outrank competitors.
- [pls-url-to-markdown](https://github.com/openclaw/skills/tree/main/skills/mattvalenta/pls-url-to-markdown/SKILL.md) - Fetch URLs and convert web pages to clean Markdown for AI processing or knowledge bases.
- [plsreadme](https://github.com/openclaw/skills/tree/main/skills/facundolucci/plsreadme/SKILL.md) - Share markdown files and text as clean, readable web links via plsreadme.com.
- [plvr-event-discovery](https://github.com/openclaw/skills/tree/main/skills/kimchichobo/plvr-event-discovery/SKILL.md) - Discover and recommend live events matched to user preferences, then assist with ticket checkout on plvr.io.
- [plvr-event-discovery-safe](https://github.com/openclaw/skills/tree/main/skills/kimchichobo/plvr-event-discovery-safe/SKILL.md) - Discover and compare live events on plvr.io by date, city, genre, and budget using the public web flow.
- [pmctl](https://github.com/openclaw/skills/tree/main/skills/wbingli/pmctl/SKILL.md) - Browse and inspect Postman collections, requests, and environments from the terminal using pmctl.
- [porkbun-skill](https://github.com/openclaw/skills/tree/main/skills/wmantly/porkbun-skill/SKILL.md) - Manage Porkbun DNS records and domains via API v3.
- [pptx-pdf-font-fix](https://github.com/openclaw/skills/tree/main/skills/chernojagne/pptx-pdf-font-fix/SKILL.md) - Fix PowerPoint font embedding issues in PDF export by patching text transparency in PPTX files.
- [pr-review-loop](https://github.com/openclaw/skills/tree/main/skills/cemoso/pr-review-loop/SKILL.md) - Autonomous PR review loop with Greptile.
- [praxis-gws](https://github.com/openclaw/skills/tree/main/skills/jfab68/praxis-gws/SKILL.md) - Google Workspace CLI for Gmail, Calendar, and Drive.
- [prediction-market-aggregator](https://github.com/openclaw/skills/tree/main/skills/jamierossouw/prediction-market-aggregator/SKILL.md) - Cross-market prediction market data aggregator.
- [pref0](https://github.com/openclaw/skills/tree/main/skills/fliellerjulian/pref0/SKILL.md) - Learn user preferences from conversations and personalize responses automatically.
- [preqstation](https://github.com/openclaw/skills/tree/main/skills/sonim1/preqstation/SKILL.md) - Delegate PREQSTATION coding tasks to Claude Code, Codex CLI, or Gemini CLI with PTY-safe execution (workdir +.
- [presale-service-bootstrap](https://github.com/openclaw/skills/tree/main/skills/dtsiomo/presale-service-bootstrap/SKILL.md) - Scaffold a new presale service foundation (docs/config/plans/readiness) before coding.
- [presearch](https://github.com/openclaw/skills/tree/main/skills/nosytlabs/presearch/SKILL.md) - Production-ready decentralized search for AI agents.
- [priceworld](https://github.com/openclaw/skills/tree/main/skills/priceworldcom/priceworld/SKILL.md) - SaaS pricing intelligence for email marketing tools (web hosting and domains planned)
- [primitives-dsl](https://github.com/openclaw/skills/tree/main/skills/stusatwork-oss/primitives-dsl/SKILL.md) - Universal game architecture DSL with six primitives (LOOP, TILEGRID, CONTROLBLOCK, POOL, EVENT, DISPATCHER)
- [principles](https://github.com/openclaw/skills/tree/main/skills/andyhcwang/principles/SKILL.md) - Ray Dalio-inspired personal knowledge system.
- [private-web-search-searchxng](https://github.com/openclaw/skills/tree/main/skills/adelpro/private-web-search-searchxng/SKILL.md) - Self-hosted private web search using SearXNG.
- [privateapp](https://github.com/openclaw/skills/tree/main/skills/camopel/privateapp/SKILL.md) - Personal PWA dashboard server with plugin apps.
- [publish-skill-vettr](https://github.com/openclaw/skills/tree/main/skills/britrik/publish-skill-vettr/SKILL.md) - Static analysis security scanner for third-party OpenClaw skills.
- [pullthatupjamie](https://github.com/openclaw/skills/tree/main/skills/unclejim21/pullthatupjamie/SKILL.md) - PullThatUpJamie — Podcast Intelligence.
- [purposebot](https://github.com/openclaw/skills/tree/main/skills/mellowmarshall/purposebot/SKILL.md) - Agentic commerce with Stripe and x402 USDC payments.
- [pyzotero](https://github.com/openclaw/skills/tree/main/skills/killgfat/pyzotero/SKILL.md) - Python scripts for Zotero - supports both local API and online Web API, with ZOTERO_LOCAL environment variable.
- [qa-check](https://github.com/openclaw/skills/tree/main/skills/gizmo-dev/qa-check/SKILL.md) - Mandatory quality assurance for all dev work before publishing.
- [qa-patrol](https://github.com/openclaw/skills/tree/main/skills/tahseen137/qa-patrol/SKILL.md) - Automated QA testing for web apps using local browser automation.
- [qrcode](https://github.com/openclaw/skills/tree/main/skills/hexavi8/qrcode/SKILL.md) - Generate styled QR codes (SVG/PNG/JPG) with custom colors, shapes, and error correction.
- [query-dbpedia](https://github.com/openclaw/skills/tree/main/skills/kidehen/query-dbpedia/SKILL.md) - Transform natural language questions into SPARQL queries for DBpedia and generate beautiful HTML results pages.
- [query-wikidata](https://github.com/openclaw/skills/tree/main/skills/kidehen/query-wikidata/SKILL.md) - Transform natural language questions into SPARQL queries for Wikidata and generate beautiful HTML results pages.
- [quotewise](https://github.com/openclaw/skills/tree/main/skills/quotewisio/quotewise/SKILL.md) - Semantic quote search with source transparency.
- [radix-explorer](https://github.com/openclaw/skills/tree/main/skills/mavremu/radix-explorer/SKILL.md) - Query Radix DLT blockchain data including wallet balances and performance, token prices and market movers.
- [radon-ai](https://github.com/openclaw/skills/tree/main/skills/latekvo/radon-ai/SKILL.md) - Use Radon IDE's AI tools for React Native development - query library docs, view logs and network traffic, take.
- [react-native-logs-cli](https://github.com/openclaw/skills/tree/main/skills/okwasniewski/react-native-logs-cli/SKILL.md) - Use rn-logs to read React Native Metro logs via CDP without MCP overhead.
- [react-perf](https://github.com/openclaw/skills/tree/main/skills/kjaylee/react-perf/SKILL.md) - React and Next.js performance optimization patterns.
- [recipe-video-extractor](https://github.com/openclaw/skills/tree/main/skills/besaif/recipe-video-extractor/SKILL.md) - Extract a structured cooking recipe from a shared video URL when the user sends `recipe <url>`.
- [record](https://github.com/openclaw/skills/tree/main/skills/atacan/record/SKILL.md) - macOS CLI tool for recording audio (microphone), screen (video/screenshot), and camera (video/photo)
- [reef-prompt-guard](https://github.com/openclaw/skills/tree/main/skills/staybased/reef-prompt-guard/SKILL.md) - Detect and filter prompt injection attacks in untrusted input.
- [reeflux](https://github.com/openclaw/skills/tree/main/skills/joshualakesexton/reeflux/SKILL.md) - Reeflux is an exploratory web environment designed for observation and interaction.
- [regex-visualizer](https://github.com/openclaw/skills/tree/main/skills/pipedream941/regex-visualizer/SKILL.md) - Render Regulex-style railroad diagrams for a JavaScript regular expression and export the exact same SVG/PNG.
- [relationships](https://github.com/openclaw/skills/tree/main/skills/lucasgeeksinthewood/relationships/SKILL.md) - Build meaningful connections on Botbook.space — the social graph for AI agents.
- [relaycast](https://github.com/openclaw/skills/tree/main/skills/khaliqgant/relaycast/SKILL.md) - summary: Structured messaging for multi-claw communication — channels, threads, DMs, reactions, search.
- [remix-agent-publish](https://github.com/openclaw/skills/tree/main/skills/chuckstock/remix-agent-publish/SKILL.md) - Build Remix games for remix.gg with the server-api v1 agents REST API and Farcade game SDK requirements.
- [remix-api-key-auth](https://github.com/openclaw/skills/tree/main/skills/chuckstock/remix-api-key-auth/SKILL.md) - Configure and verify bearer API key authentication for Remix agent publishing workflows.
- [removebg-api](https://github.com/openclaw/skills/tree/main/skills/rolandkakonyi/removebg-api/SKILL.md) - Remove image backgrounds using the remove.bg API with API-key auth and transparent PNG output.
- [renderkit](https://github.com/openclaw/skills/tree/main/skills/antoinedc/renderkit/SKILL.md) - Render structured data as beautiful hosted web pages, and create hosted forms for data collection.
- [rentaunhumano-mcp](https://github.com/openclaw/skills/tree/main/skills/gymtopz/rentaunhumano-mcp/SKILL.md) - Hire Spanish-speaking humans for real-world tasks in Latin America.
- [repomedic](https://github.com/openclaw/skills/tree/main/skills/mrummler17/repomedic/SKILL.md) - Safely triage and remediate GitHub dependency hygiene issues with explicit guardrails.
- [report-generator](https://github.com/openclaw/skills/tree/main/skills/juguangyuan520-dotcom/report-generator/SKILL.md) - Generates a structured report HTML based on a specific template.
- [reporting](https://github.com/openclaw/skills/tree/main/skills/staybased/reporting/SKILL.md) - Standardized templates for periodic reports, system audits, revenue tracking, and progress logs.
- [research-assistant](https://github.com/openclaw/skills/tree/main/skills/johstracke/research-assistant/SKILL.md) - Organized research and knowledge management for agents.
- [reveal-feedback](https://github.com/openclaw/skills/tree/main/skills/tolulopeayo/reveal-feedback/SKILL.md) - Interact with Reveal feedback infrastructure to manage products, create review tasks, read AI-analyzed user.
- [reveal-reviewer](https://github.com/openclaw/skills/tree/main/skills/tolulopeayo/reveal-reviewer/SKILL.md) - Review products on Reveal as an AI agent reviewer.
- [revolut](https://github.com/openclaw/skills/tree/main/skills/odrobnik/revolut/SKILL.md) - Revolut web automation via Playwright: login/logout, list accounts, and fetch transactions.
- [rlm-controller](https://github.com/openclaw/skills/tree/main/skills/skywyze/rlm-controller/SKILL.md) - RLM-style long-context controller that treats inputs as external context, slices/peeks/searches, and spawns.
- [rollhub-auditor](https://github.com/openclaw/skills/tree/main/skills/rollhub-dev/rollhub-auditor/SKILL.md) - Audit and verify provably fair casino fairness.
- [rollhub-casino](https://github.com/openclaw/skills/tree/main/skills/rollhub-dev/rollhub-casino/SKILL.md) - Provably fair crypto casino API for AI agents and humans.
- [ros-skill](https://github.com/openclaw/skills/tree/main/skills/lpigeon/ros-skill/SKILL.md) - Controls ROS/ROS2 robots via rosbridge WebSocket CLI.
- [roundtable](https://github.com/openclaw/skills/tree/main/skills/robbyczgw-cla/roundtable/SKILL.md) - Multi-agent debate council — spawns 3 specialized sub-agents in parallel (Scholar, Engineer, Muse) for Round 1.
- [router](https://github.com/openclaw/skills/tree/main/skills/gigabit-eth/router/SKILL.md) - Cost-optimize AI agent operations by routing tasks to appropriate models based on complexity.
- [rtfm-testing](https://github.com/openclaw/skills/tree/main/skills/zscole/rtfm-testing/SKILL.md) - A documentation quality methodology that spawns fresh agents to validate whether docs are actually usable.
- [rubicon](https://github.com/openclaw/skills/tree/main/skills/lgmnemesis/rubicon/SKILL.md) - Rubicon Sentinel v2 is the no-cope geopolitical sovereignty scanner for OpenClaw.
- [s2g-workflow-engine](https://github.com/openclaw/skills/tree/main/skills/helmutsreinis/s2g-workflow-engine/SKILL.md) - Connect to S2G (s2g.run) visual workflow automation platform over WebSocket.
- [saas-orchestrator](https://github.com/openclaw/skills/tree/main/skills/juniorxcoder/saas-orchestrator/SKILL.md) - Orchestrate SAAS factory operations - spawn subagents, track projects, manage revenue targets, and coordinate.
- [safe-backup](https://github.com/openclaw/skills/tree/main/skills/hacksing/safe-backup/SKILL.md) - Backup OpenClaw state directory and workspace.
- [safe-web](https://github.com/openclaw/skills/tree/main/skills/adamnaghs/safe-web/SKILL.md) - Secure web fetch and search with **PromptGuard** scanning.
- [sandboxer-tmux](https://github.com/openclaw/skills/tree/main/skills/chriopter/sandboxer-tmux/SKILL.md) - Dispatch coding tasks to tmux sessions via Sandboxer.
- [scamshield-verifier](https://github.com/openclaw/skills/tree/main/skills/marcodzano-lgtm/scamshield-verifier/SKILL.md) - The ultimate Web3 & OpenClaw security layer.
- [scanwow-sync](https://github.com/openclaw/skills/tree/main/skills/brandons7/scanwow-sync/SKILL.md) - Sync your OpenClaw agent with the ScanWow iOS app.
- [schemaorg-site-enhancer](https://github.com/openclaw/skills/tree/main/skills/kxrbx/schemaorg-site-enhancer/SKILL.md) - Enhances agent-built websites with proper schema.org structured data for SEO, rich snippets, and search engine.
- [scrapesense-developer](https://github.com/openclaw/skills/tree/main/skills/axelschmitz74/scrapesense-developer/SKILL.md) - Comprehensive ScrapeSense public API developer skill for scan orchestration, places extraction, campaign lifecycle.
- [scrapling](https://github.com/openclaw/skills/tree/main/skills/zendenho7/scrapling/SKILL.md) - Adaptive web scraping framework with anti-bot bypass and spider crawling.
- [scrapling-fetcher](https://github.com/openclaw/skills/tree/main/skills/damirikys/scrapling-fetcher/SKILL.md) - Web scraping using Scrapling — a Python framework with anti-bot bypass (Cloudflare Turnstile, fingerprint.
- [script-creator](https://github.com/openclaw/skills/tree/main/skills/cadot-eu/script-creator/SKILL.md) - Create and modify scripts in ~/.nanobot/workspace/test with strict Git versioning.
- [secret-portal](https://github.com/openclaw/skills/tree/main/skills/awlevin/secret-portal/SKILL.md) - Spin up a one-time web UI for securely entering secret keys and env vars.
- [secucheck](https://github.com/openclaw/skills/tree/main/skills/jooneyp/secucheck/SKILL.md) - Comprehensive security audit for OpenClaw.
- [secure-shopper](https://github.com/openclaw/skills/tree/main/skills/moodykong/secure-shopper/SKILL.md) - Asynchronous shopping research + checkout using secure-autofill (1Password-backed browser filling) with results.
- [security-scanner](https://github.com/openclaw/skills/tree/main/skills/dmx64/security-scanner/SKILL.md) - Automated security scanning and vulnerability detection for web applications, APIs, and infrastructure.
- [self-evolve](https://github.com/openclaw/skills/tree/main/skills/be1human/self-evolve/SKILL.md) - Autonomous self-evolution skill: grants the agent full authority to modify its own configuration, skills, prompts.
- [sell-evoweb-ai](https://github.com/openclaw/skills/tree/main/skills/galizki/sell-evoweb-ai/SKILL.md) - Create AI-First Website with GEO (Generative Engine Optimization) and marketing rules to convert visitors into leads.
- [sendook](https://github.com/openclaw/skills/tree/main/skills/obaid/sendook/SKILL.md) - Read and send emails from an existing Sendook inbox.
- [seo-affiliate-guide](https://github.com/openclaw/skills/tree/main/skills/cmunozdev/seo-affiliate-guide/SKILL.md) - Crea guías de compra SEO optimizadas para posts de afiliado en español. Úsala siempre que el usuario quiera.
- [shadcn-theme-default](https://github.com/openclaw/skills/tree/main/skills/guifav/shadcn-theme-default/SKILL.md) - Enforces the default shadcn/ui Neutral theme (black/white/gray) with OKLCH CSS variables, Tailwind v4 integration.
- [shadow-ai-monitor](https://github.com/openclaw/skills/tree/main/skills/techcodecrafter/shadow-ai-monitor/SKILL.md) - Shadow AI Monitor - Enterprise-grade dashboard for tracking employee AI tool usage, data exposure risks, and PIPEDA.
- [shared-workspace](https://github.com/openclaw/skills/tree/main/skills/nativ3ai/shared-workspace/SKILL.md) - Use this skill to discover similar GitHub work, attach to shared agent workspaces, and coordinate tasks via .shared.
- [shelly-brand-name-generator](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/shelly-brand-name-generator/SKILL.md) - Generate 20 creative brand name suggestions for any industry, with .com domain availability hints.
- [shelly-landing-gen](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/shelly-landing-gen/SKILL.md) - Generate complete, responsive HTML landing pages from a product name, tagline, and description.
- [shelly-seo-analyzer](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/shelly-seo-analyzer/SKILL.md) - Analyze any webpage URL for SEO issues and get actionable recommendations.
- [shelv](https://github.com/openclaw/skills/tree/main/skills/joshuaohanlon/shelv/SKILL.md) - Convert PDFs into structured Markdown filesystems and hydrate them into your workspace for exploration.
- [shieldcortex](https://github.com/openclaw/skills/tree/main/skills/jarvis-drakon/shieldcortex/SKILL.md) - Security framework for AI agents.
- [shopping-list-ui](https://github.com/openclaw/skills/tree/main/skills/ajeenkya/shopping-list-ui/SKILL.md) - Web UI for the shopping-list skill.
- [show-booking](https://github.com/openclaw/skills/tree/main/skills/danielfoch/show-booking/SKILL.md) - Book real estate showing tours from emailed or pasted listing details, including extracting listing data, preparing.
- [signl4](https://github.com/openclaw/skills/tree/main/skills/rons4/signl4/SKILL.md) - Send and close SIGNL4 alerts using the SIGNL4 inbound webhook (team secret in URL).
- [similarweb-analytics](https://github.com/openclaw/skills/tree/main/skills/wells1137/similarweb-analytics/SKILL.md) - Analyze websites and domains using SimilarWeb traffic data.
- [simple-random-interaction-designer](https://github.com/openclaw/skills/tree/main/skills/fjrevoredo/simple-random-interaction-designer/SKILL.md) - Decide whether OpenClaw should send a spontaneous ping to the user during periodic checks, and choose a randomized.
- [skill-2](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/skill-2/SKILL.md) - Convert Markdown text to beautifully styled, self-contained HTML with embedded CSS.
- [skill-4](https://github.com/openclaw/skills/tree/main/skills/claudiodrusus/skill-4/SKILL.md) - Lightweight website uptime monitor.
- [skill-auto-attach](https://github.com/openclaw/skills/tree/main/skills/elodyzen/skill-auto-attach/SKILL.md) - This skill monitors the OpenClaw workspace for file changes and automatically attaches new or updated documentation.
- [skill-firewall](https://github.com/openclaw/skills/tree/main/skills/mkhaytman87/skill-firewall/SKILL.md) - Security layer that prevents prompt injection from external skills.
- [skill-namer](https://github.com/openclaw/skills/tree/main/skills/otherpowers/skill-namer/SKILL.md) - Generate short, molty-native names for skills, ENS domains, and agent-economy primitives when the obvious words.
- [skill-refiner](https://github.com/openclaw/skills/tree/main/skills/1va7/skill-refiner/SKILL.md) - Audit and fix all skills in the workspace for compliance with skill-creator requirements.
- [skill-trust-auditor](https://github.com/openclaw/skills/tree/main/skills/jonathanjing/skill-trust-auditor/SKILL.md) - Audit a ClawHub skill for security risks BEFORE installation.
- [skill-vettr](https://github.com/openclaw/skills/tree/main/skills/britrik/skill-vettr/SKILL.md) - Static analysis security scanner for third-party OpenClaw skills.
- [skylar-serper](https://github.com/openclaw/skills/tree/main/skills/skylar-north/skylar-serper/SKILL.md) - Search Google programmatically using Serper.dev API.
- [skytekx](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/skytekx/SKILL.md) - Skytekx namespace for Netsnek e.U. cloud infrastructure monitoring dashboard.
- [slk](https://github.com/openclaw/skills/tree/main/skills/therohitdas/slk/SKILL.md) - Read, send, search, and manage Slack messages and DMs via the slk CLI.
- [smart-accounts-kit](https://github.com/openclaw/skills/tree/main/skills/ayushbherwani1998/smart-accounts-kit/SKILL.md) - Web3 development using MetaMask Smart Accounts Kit.
- [smart-contract-audit](https://github.com/openclaw/skills/tree/main/skills/cornbrother0x/smart-contract-audit/SKILL.md) - Audit and analyze Solidity smart contracts for security vulnerabilities.
- [smart-fetch](https://github.com/openclaw/skills/tree/main/skills/che7seachen/smart-fetch/SKILL.md) - Fetch web pages for LLM use with markdown-first negotiation, strict output limits, cache/revalidation, and robust.
- [smart-meme-generator](https://github.com/openclaw/skills/tree/main/skills/olisim02/smart-meme-generator/SKILL.md) - AI-powered meme generator that creates perfect, context-aware memes from any topic or situation.
- [smart-spawn](https://github.com/openclaw/skills/tree/main/skills/deeflect/smart-spawn/SKILL.md) - Pick the best AI model for any task using the Smart Spawn API.
- [smart-spawn-api](https://github.com/openclaw/skills/tree/main/skills/dagangtj/smart-spawn-api/SKILL.md) - Pick the best AI model for any task using the Smart Spawn API.
- [smart-web-scraper](https://github.com/openclaw/skills/tree/main/skills/mariusfit/smart-web-scraper/SKILL.md) - Extract structured data from any web page.
- [snaprender](https://github.com/openclaw/skills/tree/main/skills/user0856/snaprender/SKILL.md) - Give your agent eyes on the web — screenshot any URL as an image file.
- [social-media-agent](https://github.com/openclaw/skills/tree/main/skills/psmamm/social-media-agent/SKILL.md) - Autonomous social media management for X/Twitter using only OpenClaw native tools.
- [solana-agent-registry](https://github.com/openclaw/skills/tree/main/skills/montecrypto999/solana-agent-registry/SKILL.md) - TypeScript SDK for the 8004 Trustless Agent Registry on Solana.
- [solana-dev-rent-free](https://github.com/openclaw/skills/tree/main/skills/tilo-14/solana-dev-rent-free/SKILL.md) - Build Solana applications 200x cheaper for stablecoin payments, agent payments, DeFi, airdrops, token distribution.
- [solana-dev-skill](https://github.com/openclaw/skills/tree/main/skills/h4rkl/solana-dev-skill/SKILL.md) - End-to-end Solana development playbook (Jan 2026)
- [solana-rent-free-dev](https://github.com/openclaw/skills/tree/main/skills/tilo-14/solana-rent-free-dev/SKILL.md) - Skill for Solana development using rent-free primitives from Light Protocol.
- [solar-weather](https://github.com/openclaw/skills/tree/main/skills/capt-marbles/solar-weather/SKILL.md) - Monitor solar weather conditions including geomagnetic storms, solar flares, aurora forecasts, and solar wind data.
- [solid-agent-storage](https://github.com/openclaw/skills/tree/main/skills/masterworrall/solid-agent-storage/SKILL.md) - Give your AI agent persistent identity (WebID) and personal data storage (Pod) using the Solid Protocol.
- [solo-deploy](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-deploy/SKILL.md) - Deploy project to hosting platform — read stack YAML for exact config, detect local CLI tools (vercel, wrangler.
- [solo-factory](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-factory/SKILL.md) - Install the full Solo Factory toolkit — 23 startup skills + solograph MCP server for code intelligence, KB search.
- [solo-landing-gen](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-landing-gen/SKILL.md) - Generate landing page content from PRD — hero section, features, A/B headline variants, CTA, and SEO meta tags.
- [solo-research](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-research/SKILL.md) - Deep market research — competitor analysis, user pain points, SEO/ASO keywords, naming/domain availability.
- [solo-scaffold](https://github.com/openclaw/skills/tree/main/skills/fortunto2/solo-scaffold/SKILL.md) - Generate complete project from PRD + stack template — directory structure, configs, CLAUDE.md, git repo, and GitHub.
- [soul-in-sapphire](https://github.com/openclaw/skills/tree/main/skills/nextaltair/soul-in-sapphire/SKILL.md) - Generic long-term memory (LTM) operations for OpenClaw using Notion (2025-09-03 data_sources)
- [soul-pack](https://github.com/openclaw/skills/tree/main/skills/gyliiiiii/soul-pack/SKILL.md) - Export and import SOUL packages for OpenClaw agents.
- [soulblock](https://github.com/openclaw/skills/tree/main/skills/hburgoyne/soulblock/SKILL.md) - Read, list, mint, and append Soul Blocks on Base.
- [soulforge](https://github.com/openclaw/skills/tree/main/skills/jamesrp13/soulforge/SKILL.md) - Dispatch multi-step coding workflows to Claude Code CLI or Codex CLI from YAML definitions via a persistent.
- [source-library](https://github.com/openclaw/skills/tree/main/skills/don-gbot/source-library/SKILL.md) - Searchable knowledge base that captures and cross-references everything users share.
- [sovereign-accessibility-auditor](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-accessibility-auditor/SKILL.md) - Audits HTML/CSS for WCAG 2.1 compliance.
- [sovereign-api-docs-generator](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-api-docs-generator/SKILL.md) - Auto-generates comprehensive API docs from code.
- [sovereign-test-generator](https://github.com/openclaw/skills/tree/main/skills/ryudi84/sovereign-test-generator/SKILL.md) - Analyzes codebases and generates comprehensive test suites.
- [space-autonomy-skill](https://github.com/openclaw/skills/tree/main/skills/aadipapp/space-autonomy-skill/SKILL.md) - Autonomous space navigation agent using optical quantum kernels for terrain classification.
- [spacex](https://github.com/openclaw/skills/tree/main/skills/jeffaf/spacex/SKILL.md) - CLI for AI agents to lookup SpaceX launches and rockets for their humans.
- [sparkbtcbot](https://github.com/openclaw/skills/tree/main/skills/echennells/sparkbtcbot/SKILL.md) - Set up Spark Bitcoin L2 wallet capabilities for AI agents.
- [sparkbtcbot-proxy](https://github.com/openclaw/skills/tree/main/skills/echennells/sparkbtcbot-proxy/SKILL.md) - Use a Spark Bitcoin L2 wallet proxy for AI agents via HTTP API.
- [sparkbtcbot-proxy-deploy](https://github.com/openclaw/skills/tree/main/skills/echennells/sparkbtcbot-proxy-deploy/SKILL.md) - Deploy a serverless Spark Bitcoin L2 proxy on Vercel with spending limits, auth, and Redis logging.
- [sparkle-vpn](https://github.com/openclaw/skills/tree/main/skills/cwyhkyochen-a11y/sparkle-vpn/SKILL.md) - Control Sparkle VPN - start and stop VPN connections using Mihomo core directly.
- [spatix](https://github.com/openclaw/skills/tree/main/skills/alde1022/spatix/SKILL.md) - Create beautiful maps in seconds.
- [spawn-incubator](https://github.com/openclaw/skills/tree/main/skills/blackeuler/spawn-incubator/SKILL.md) - AI agent incubator on Base L2 — apply with a business idea, get funded, build your MVP, share revenue on-chain.
- [spf-dkim-setup](https://github.com/openclaw/skills/tree/main/skills/masasdani/spf-dkim-setup/SKILL.md) - Manage DNS records via the Cloudflare API.
- [spirit](https://github.com/openclaw/skills/tree/main/skills/gopinathnelluri/spirit/SKILL.md) - State Preservation & Identity Resurrection Infrastructure Tool (SPIRIT)
- [splatworld](https://github.com/openclaw/skills/tree/main/skills/leftysplat/splatworld/SKILL.md) - Splatworld - a 3D metaverse for AI agents.
- [sql-injection-testing](https://github.com/openclaw/skills/tree/main/skills/brandonwise/sql-injection-testing/SKILL.md) - Comprehensive SQL injection vulnerability assessment techniques for web applications, covering detection.
- [sr-next-clerk-expert](https://github.com/openclaw/skills/tree/main/skills/michaelmonetized/sr-next-clerk-expert/SKILL.md) - Senior-level Clerk authentication expertise for Next.js 15/16+ applications.
- [srs-support](https://github.com/openclaw/skills/tree/main/skills/winlinvip/srs-support/SKILL.md) - Answer SRS (Simple Realtime Server) questions for developers and users — protocols, configuration, architecture.
- [sss](https://github.com/openclaw/skills/tree/main/skills/syveraerp/sss/SKILL.md) - Access ATXP paid API tools for web search, AI image generation, music creation, video generation, and X/Twitter.
- [stable-layer-sdk](https://github.com/openclaw/skills/tree/main/skills/k66inthesky/stable-layer-sdk/SKILL.md) - A TypeScript SDK for interacting with the Stable Layer protocol on the Sui blockchain.
- [stack-scaffold](https://github.com/openclaw/skills/tree/main/skills/guifav/stack-scaffold/SKILL.md) - Scaffolds a full-stack project with Next.js App Router, Supabase, Firebase Auth, Vercel, and Cloudflare.
- [stitch-ui-designer](https://github.com/openclaw/skills/tree/main/skills/a2mus/stitch-ui-designer/SKILL.md) - Design, preview, and generate UI code using Google Stitch (via MCP)
- [stock-analysis](https://github.com/openclaw/skills/tree/main/skills/udiedrichsen/stock-analysis/SKILL.md) - Analyze stocks and cryptocurrencies using Yahoo Finance data.
- [stock-analysis-6](https://github.com/openclaw/skills/tree/main/skills/sunerw-dev/stock-analysis-6/SKILL.md) - Analyze stocks and cryptocurrencies using Yahoo Finance data.
- [stock-analysis-6-2-0](https://github.com/openclaw/skills/tree/main/skills/squally2k/stock-analysis-6-2-0/SKILL.md) - Analyze stocks and cryptocurrencies using Yahoo Finance data.
- [stoic-quotes](https://github.com/openclaw/skills/tree/main/skills/bshandley/stoic-quotes/SKILL.md) - Provide Stoic philosophy quotes from Marcus Aurelius, Seneca, Epictetus, Cato, and other Stoic philosophers.
- [stonebornbot](https://github.com/openclaw/skills/tree/main/skills/olawoyin206/stonebornbot/SKILL.md) - High-speed NFT mint bot for Ethereum and EVM chains.
- [stripe-cli](https://github.com/openclaw/skills/tree/main/skills/kesslerio/stripe-cli/SKILL.md) - A universal Moltbot skill wrapping Stripe CLI for payment processing, webhook testing, and API operations.
- [stripe-cli-skill](https://github.com/openclaw/skills/tree/main/skills/felipeoff/stripe-cli-skill/SKILL.md) - Stripe CLI operations for local development, webhook testing, fixture-based event simulation, API inspection.
- [stripe-payments](https://github.com/openclaw/skills/tree/main/skills/kjaylee/stripe-payments/SKILL.md) - Best practices for Stripe payment integration.
- [study-buddy-ai](https://github.com/openclaw/skills/tree/main/skills/mkpareek0315/study-buddy-ai/SKILL.md) - When user asks to study, create flashcards, take a quiz, make notes, revise, set study timer, track study hours.
- [subagent-architecture](https://github.com/openclaw/skills/tree/main/skills/donovanpankratz-del/subagent-architecture/SKILL.md) - Advanced patterns for specialized subagent orchestration with production-ready reference implementations.
- [subagent-overseer](https://github.com/openclaw/skills/tree/main/skills/globalcaos/subagent-overseer/SKILL.md) - Monitor sub-agent health and progress via a pull-based bash daemon.
- [subagent-spawn-command-builder](https://github.com/openclaw/skills/tree/main/skills/nextaltair/subagent-spawn-command-builder/SKILL.md) - Build sessions_spawn command payloads from JSON profiles.
- [summarize-file](https://github.com/openclaw/skills/tree/main/skills/muhammadmuazzain/summarize-file/SKILL.md) - Reads text files from workspace/paths and generates concise summaries.
- [sveltekit-webapp](https://github.com/openclaw/skills/tree/main/skills/leo3linbeck/sveltekit-webapp/SKILL.md) - Scaffold and configure a production-ready SvelteKit PWA with opinionated defaults.
- [swift-architecture-skill](https://github.com/openclaw/skills/tree/main/skills/efremidze/swift-architecture-skill/SKILL.md) - Agent Skill for Swift architecture design and implementation patterns, with architecture-specific playbooks.
- [switchboard-data-operator](https://github.com/openclaw/skills/tree/main/skills/oakencore/switchboard-data-operator/SKILL.md) - Autonomous operator for Switchboard on-demand feeds, Surge streaming, and randomness.
- [synology-backup](https://github.com/openclaw/skills/tree/main/skills/pfrederiksen/synology-backup/SKILL.md) - Backup and restore OpenClaw workspace, configs, and agent data to a Synology NAS via SMB.
- [synology-surveillance-skill](https://github.com/openclaw/skills/tree/main/skills/photonixlaser-ux/synology-surveillance-skill/SKILL.md) - Steuere Synology Surveillance Station Kameras über die Web API.
- [sys-updater](https://github.com/openclaw/skills/tree/main/skills/spiceman161/sys-updater/SKILL.md) - System package maintenance for Ubuntu (apt), npm, brew, and OpenClaw skills.
- [tappi](https://github.com/openclaw/skills/tree/main/skills/shaihazher/tappi/SKILL.md) - Lightweight CDP browser control for AI agents.
- [tarot-content](https://github.com/openclaw/skills/tree/main/skills/alexyuui/tarot-content/SKILL.md) - Generate tarot × astrology content for social media — weekly horoscope scripts, tarot spreads, video scripts.
- [task-runner](https://github.com/openclaw/skills/tree/main/skills/johstracke/task-runner/SKILL.md) - Manage tasks and projects across sessions with persistent task tracking.
- [taskwarrior](https://github.com/openclaw/skills/tree/main/skills/aghareza/taskwarrior/SKILL.md) - Workspace-local task management powered by Taskwarrior.
- [tech-and-internet-domain-search-agent](https://github.com/openclaw/skills/tree/main/skills/urrrich/tech-and-internet-domain-search-agent/SKILL.md) - AI agent for tech and internet domain search agent tasks.
- [tech-news-digest](https://github.com/openclaw/skills/tree/main/skills/dinstein/tech-news-digest/SKILL.md) - Generate tech news digests with unified source model, quality scoring, and multi-format output.
- [technical-seo-checker](https://github.com/openclaw/skills/tree/main/skills/aaron-he-zhu/technical-seo-checker/SKILL.md) - Use when the user asks to "technical SEO audit", "check page speed", "crawl issues", "Core Web Vitals", "site.
- [telegram-colored-choices-buttons](https://github.com/openclaw/skills/tree/main/skills/dandysuper/telegram-colored-choices-buttons/SKILL.md) - Every time the bot presents choices to the user, it MUST automatically color each button based on how critical.
- [telegram-rich-messages](https://github.com/openclaw/skills/tree/main/skills/shingo0620/telegram-rich-messages/SKILL.md) - Comprehensive guide for Telegram Rich UI features (Inline buttons, formatting, media, reactions, and message.
- [telnyx-cli](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-cli/SKILL.md) - Telnyx API integration for Clawdbot.
- [telnyx-rag](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-rag/SKILL.md) - Semantic search and Q&A over workspace files using Telnyx Storage + AI embeddings.
- [telnyx-storage-backup](https://github.com/openclaw/skills/tree/main/skills/teamtelnyx/telnyx-storage-backup/SKILL.md) - Backup and restore your OpenClaw workspace to Telnyx Storage.
- [test-name-deniz](https://github.com/openclaw/skills/tree/main/skills/protoss70/test-name-deniz/SKILL.md) - Universal AI-powered web scraper for any platform.
- [test-sm-123](https://github.com/openclaw/skills/tree/main/skills/statico-alt/test-sm-123/SKILL.md) - Play SpaceMolt - an MMO for AI agents.
- [tester](https://github.com/openclaw/skills/tree/main/skills/tsiontesfayechromaway/tester/SKILL.md) - Fetch GitHub issues, spawn sub-agents to implement fixes, open PRs, and monitor review comments.
- [tex-render](https://github.com/openclaw/skills/tree/main/skills/thebigoranger/tex-render/SKILL.md) - Renders LaTeX math to PNG, JPEG, WebP, or AVIF images using MathJax (TeX→SVG) and @svg-fns/svg2img.
- [tg-checkin](https://github.com/openclaw/skills/tree/main/skills/ls18166407597-design/tg-checkin/SKILL.md) - Generic Telegram Web automation for group check-ins.
- [tg-miniapp](https://github.com/openclaw/skills/tree/main/skills/zenith2828/tg-miniapp/SKILL.md) - Build Telegram Mini Apps without the pain.
- [tg-sticker-emoji-mood](https://github.com/openclaw/skills/tree/main/skills/dandysuper/tg-sticker-emoji-mood/SKILL.md) - Automatically send Telegram stickers and emojis that match the mood and vibe of the conversation.
- [the-next-big-thing](https://github.com/openclaw/skills/tree/main/skills/tracsystems/the-next-big-thing/SKILL.md) - Programmatic participation in The Next Big Thing without a browser: connect/sign via Tap Wallet, deploy tokens.
- [the-only](https://github.com/openclaw/skills/tree/main/skills/cdotlock/the-only/SKILL.md) - A self-evolving, context-aware information curation engine.
- [thenextbigthing](https://github.com/openclaw/skills/tree/main/skills/tracsystems/thenextbigthing/SKILL.md) - Programmatic participation in The Next Big Thing without a browser: connect/sign via Tap Wallet, deploy tokens.
- [tick-md](https://github.com/openclaw/skills/tree/main/skills/gianni-dalerta/tick-md/SKILL.md) - Coordinate work across human and AI agents using structured Markdown files.
- [tide-watch](https://github.com/openclaw/skills/tree/main/skills/chrisagiddings/tide-watch/SKILL.md) - Proactive session capacity monitoring and management for OpenClaw.
- [tmp-g0vnb95vqy](https://github.com/openclaw/skills/tree/main/skills/createpromptdude/tmp-g0vnb95vqy/SKILL.md) - The social platform where AI agents create, remix, and earn alongside humans.
- [tnbc-research-swarm](https://github.com/openclaw/skills/tree/main/skills/angusthefuzz/tnbc-research-swarm/SKILL.md) - Contribute scientific research findings to the Research Swarm TNBC (Triple-Negative Breast Cancer) mission.
- [token-saver-75plus](https://github.com/openclaw/skills/tree/main/skills/mariovallereyes/token-saver-75plus/SKILL.md) - Always-on token optimization + model routing protocol.
- [tor-browser](https://github.com/openclaw/skills/tree/main/skills/admin4giter/tor-browser/SKILL.md) - Headless browser automation with Tor SOCKS5 proxy support for accessing .onion sites and anonymous browsing.
- [torchdomainauctionbot](https://github.com/openclaw/skills/tree/main/skills/mrsirg97-rgb/torchdomainauctionbot/SKILL.md) - Domain lending protocol on Solana.
- [tpn-proxy](https://github.com/openclaw/skills/tree/main/skills/actuallymentor/tpn-proxy/SKILL.md) - Make web requests through decentralized SOCKS5 proxies via the Tao Private Network (TPN)
- [trading-signals-ws](https://github.com/openclaw/skills/tree/main/skills/sunnyztj/trading-signals-ws/SKILL.md) - Real-time crypto trading signal generator using WebSocket price feeds.
- [training-manager](https://github.com/openclaw/skills/tree/main/skills/anova44/training-manager/SKILL.md) - Manage and optimize your OpenClaw training workspace -- scaffold files, generate skills, log training sessions.
- [transparency-log-auditor](https://github.com/openclaw/skills/tree/main/skills/andyxinweiminicloud/transparency-log-auditor/SKILL.md) - Helps verify that skill signing events are recorded in an independently auditable transparency log — catching.
- [travel-promos-argentinas](https://github.com/openclaw/skills/tree/main/skills/ferminrp/travel-promos-argentinas/SKILL.md) - Consulta promociones de viajes desde Argentina usando Anduin Promos API.
- [ts3](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/ts3/SKILL.md) - TS3 namespace for Netsnek e.U.
- [ts4](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/ts4/SKILL.md) - TS4 namespace for Netsnek e.U.
- [ts5](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/ts5/SKILL.md) - TS5 namespace for Netsnek e.U.
- [tsx](https://github.com/openclaw/skills/tree/main/skills/kleberbaum/tsx/SKILL.md) - TSX namespace for Netsnek e.U.
- [twinify](https://github.com/openclaw/skills/tree/main/skills/neobotjan2026/twinify/SKILL.md) - Create AI digital twins of real people from WhatsApp chat history exports.
- [twitterhdh](https://github.com/openclaw/skills/tree/main/skills/songhai-dg/twitterhdh/SKILL.md) - Write viral, persuasive, engaging tweets and threads.
- [typescript-lsp](https://github.com/openclaw/skills/tree/main/skills/bowen31337/typescript-lsp/SKILL.md) - TypeScript language server providing type checking, code intelligence, and LSP diagnostics for .ts, .tsx, .js.
- [ub2-web-research-assistant](https://github.com/openclaw/skills/tree/main/skills/underbench2-gif/ub2-web-research-assistant/SKILL.md) - A skill that enables Claw to perform structured web research on any topic, synthesize findings from multiple.
- [ui-designer-skill](https://github.com/openclaw/skills/tree/main/skills/1999azzar/ui-designer-skill/SKILL.md) - Design beautiful interfaces using Material You, Minimalism, Glassmorphism, Neo-Brutalism, and Claymorphism.
- [ui-ux-dev](https://github.com/openclaw/skills/tree/main/skills/wing8169/ui-ux-dev/SKILL.md) - Generate and serve live HTML/CSS/JS UI designs from natural language prompts.
- [umami-stats](https://github.com/openclaw/skills/tree/main/skills/hfichter/umami-stats/SKILL.md) - Query Umami Cloud (v2) analytics data via API using an environment-provided API key.
- [unhuman](https://github.com/openclaw/skills/tree/main/skills/satbot-mdk/unhuman/SKILL.md) - Search, register, and manage domain names via unhuman.domains.
- [unicon](https://github.com/openclaw/skills/tree/main/skills/charlesrhoward/unicon/SKILL.md) - Help users add icons to their projects using the Unicon icon library.
- [unifuncs-all-in-one](https://github.com/openclaw/skills/tree/main/skills/samueli/unifuncs-all-in-one/SKILL.md) - Default web reading, AI search, and deep research tools.
- [unipile-linkedin](https://github.com/openclaw/skills/tree/main/skills/sudhanshu746/unipile-linkedin/SKILL.md) - Interact with LinkedIn via Unipile API - send messages, view profiles, manage connections, create posts, react.
- [unique-mcp-builder-test](https://github.com/openclaw/skills/tree/main/skills/uniquevme/unique-mcp-builder-test/SKILL.md) - Guide for creating high-quality MCP (Model Context Protocol) servers that enable LLMs to interact with external.
- [universal-notify](https://github.com/openclaw/skills/tree/main/skills/josunlp/universal-notify/SKILL.md) - Send notifications through multiple channels with a single script.
- [unloopa-api](https://github.com/openclaw/skills/tree/main/skills/echris6/unloopa-api/SKILL.md) - Make your agent sell websites to local businesses on autopilot.
- [unsearch](https://github.com/openclaw/skills/tree/main/skills/rakesh1002/unsearch/SKILL.md) - Search the web, scrape content, and conduct deep research using the UnSearch API.
- [url-fetcher](https://github.com/openclaw/skills/tree/main/skills/johstracke/url-fetcher/SKILL.md) - Simple web content fetching without API keys or external dependencies.
- [using-git-worktrees](https://github.com/openclaw/skills/tree/main/skills/zlc000190/using-git-worktrees/SKILL.md) - Use when starting feature work that needs isolation from current workspace or before executing implementation plans.
- [vajra](https://github.com/openclaw/skills/tree/main/skills/minhyeong112/vajra/SKILL.md) - Analyze URLs, YouTube videos, tweets, or text for quality, bias, and reliability using the Vajra API (vajra.to).
- [validator-agent](https://github.com/openclaw/skills/tree/main/skills/up2itnow/validator-agent/SKILL.md) - Multi-round automated validation pipeline for TypeScript/Solidity projects.
- [vault0](https://github.com/openclaw/skills/tree/main/skills/dlhugly/vault0/SKILL.md) - Security suite for OpenClaw agents.
- [veille](https://github.com/openclaw/skills/tree/main/skills/romain-grosos/veille/SKILL.md) - RSS feed aggregator, deduplication engine, and output dispatcher for OpenClaw agents.
- [venice-router](https://github.com/openclaw/skills/tree/main/skills/plusone/venice-router/SKILL.md) - Supreme model router for Venice.ai — the privacy-first, uncensored AI platform.
- [vexa](https://github.com/openclaw/skills/tree/main/skills/dmitriyg228/vexa/SKILL.md) - Send Vexa bots to meetings and operate transcript workflows end-to-end (during and after meetings): parse meeting.
- [vibe-notionbot](https://github.com/openclaw/skills/tree/main/skills/devxoul/vibe-notionbot/SKILL.md) - Interact with Notion workspaces using official API - manage pages, databases, blocks, users, and comments.
- [vibe-ship](https://github.com/openclaw/skills/tree/main/skills/satoshi891102/vibe-ship/SKILL.md) - Ship a complete web app from idea to public deployment in one session.
- [vibemate](https://github.com/openclaw/skills/tree/main/skills/riffvibe/vibemate/SKILL.md) - VibeMate is a reading buddy matcher.
- [vibevoice](https://github.com/openclaw/skills/tree/main/skills/javier887/vibevoice/SKILL.md) - Local Spanish TTS using Microsoft VibeVoice.
- [video-download](https://github.com/openclaw/skills/tree/main/skills/upupc/video-download/SKILL.md) - Download videos from 1800+ websites and generate subtitles using Faster Whisper AI.
- [video-news-downloader](https://github.com/openclaw/skills/tree/main/skills/cyberpsychosissss/video-news-downloader/SKILL.md) - Automated daily news video downloader with AI subtitle proofreading.
- [video-sourcing](https://github.com/openclaw/skills/tree/main/skills/samuelz12/video-sourcing/SKILL.md) - Run the Video Sourcing Agent with deterministic, concise chat UX for /video_sourcing using a pinned self-bootstrap.
- [vincent-brave-search](https://github.com/openclaw/skills/tree/main/skills/glitch003/vincent-brave-search/SKILL.md) - Use this skill to search the web and news using Brave Search.
- [virtual-remote-desktop](https://github.com/openclaw/skills/tree/main/skills/zhangxin15435/virtual-remote-desktop/SKILL.md) - Starts and manages a secure noVNC virtual desktop on headless Linux using Xvfb, x11vnc, and a token-gated noVNC web.
- [virtuals-protocol-acp](https://github.com/openclaw/skills/tree/main/skills/virtualstechteam/virtuals-protocol-acp/SKILL.md) - Create jobs and transact with other specialised agents through the Agent Commerce Protocol (ACP) — extends.
- [virtuoso-support-agent](https://github.com/openclaw/skills/tree/main/skills/kidehen/virtuoso-support-agent/SKILL.md) - Technical support and database management for OpenLink Virtuoso Server with RDF Views generation, SPARQL queries.
- [visual-rpa-skill](https://github.com/openclaw/skills/tree/main/skills/neilhexiaoning-alt/visual-rpa-skill/SKILL.md) - Visual RPA desktop automation skill.
- [visual-studio-agent](https://github.com/openclaw/skills/tree/main/skills/i54851498-gif/visual-studio-agent/SKILL.md) - Generate AI images/videos with a chosen visual persona and publish them to the OpenFishy feed API (custom web.
- [vn-market-news-monitor](https://github.com/openclaw/skills/tree/main/skills/ndtchan/vn-market-news-monitor/SKILL.md) - Tracks Vietnam market and sector narratives from major domestic financial media; used when users ask for market.
- [vocabulary-builder](https://github.com/openclaw/skills/tree/main/skills/winlinvip/vocabulary-builder/SKILL.md) - Build and review vocabulary from books, podcasts, and daily encounters.
- [volcengine-web-search](https://github.com/openclaw/skills/tree/main/skills/warm-wm/volcengine-web-search/SKILL.md) - Using volcengine web_search.py script to search web and get the result, prepare clear and specific `query`.Run.
- [w3connect](https://github.com/openclaw/skills/tree/main/skills/kernel1983/w3connect/SKILL.md) - Access to blockchain asset and transaction signature with web3b0x lockbox.
- [wallet](https://github.com/openclaw/skills/tree/main/skills/kenblive/wallet/SKILL.md) - 🔐 Base Wallet - Crypto Identity for AI Agents.
- [walletconnect-agent](https://github.com/openclaw/skills/tree/main/skills/daaab/walletconnect-agent/SKILL.md) - 🔗 WalletConnect Agent - dApp Access for AI.
- [warren-deploy](https://github.com/openclaw/skills/tree/main/skills/planetai87/warren-deploy/SKILL.md) - Deploy websites and files permanently on MegaETH blockchain.
- [warren-deploy-ma