---
name: avantis
description: Execute leverage trading on Avantis (Base). Long/short crypto, forex, commodities with up to 100x leverage. Uses Python SDK with direct wallet integration.
metadata:
  author: beanbot
  version: "1.0.0"
  requires:
    - Python 3.12+
    - avantis-trader-sdk
    - Wallet: 0x79622Ea91BBbDF860e9b0497E4C297fC52c8CE64
---

# Avantis Leverage Trading

Execute leverage trades on Avantis - Base's largest derivatives exchange for crypto, forex, commodities, and indices.

## Quick Start

### Check Positions
```bash
avantis_venv/bin/python skills/avantis/scripts/positions.py
```

### Open Trade
```bash
# 5x long ETH with $10 collateral
avantis_venv/bin/python skills/avantis/scripts/trade.py long ETH 10 5

# 10x short BTC with $20 collateral
avantis_venv/bin/python skills/avantis/scripts/trade.py short BTC 20 10
```

### Close Position
```bash
# Close specific position
avantis_venv/bin/python skills/avantis/scripts/close.py <pair_index> <trade_index>

# Or close all positions for a pair
avantis_venv/bin/python skills/avantis/scripts/close.py ETH
```

## Wallet Configuration

**Main Wallet**: `0x79622Ea91BBbDF860e9b0497E4C297fC52c8CE64`
- Private key: `/home/ubuntu/clawd/MAIN_WALLET.txt`
- USDC approved: 100 USDC
- Gas balance: 0.004500 ETH (~89 trades)

## Supported Markets

### Crypto (up to 50x)
- ETH/USD, BTC/USD, SOL/USD, LINK/USD
- ARB/USD, OP/USD, AVAX/USD, etc.

### Forex (up to 100x)
- EUR/USD, GBP/USD, USD/JPY, AUD/USD
- USD/CAD, USD/CHF, NZD/USD

### Commodities (up to 100x)
- Gold (XAU/USD), Silver (XAG/USD)
- Oil (WTI, Brent)

### Indices (up to 50x)
- SPX, NDX, DJI

## Features

### Leverage Trading
- **Long**: Profit when price goes up
- **Short**: Profit when price goes down
- **Min leverage**: 2x
- **Max leverage**: 50x crypto, 100x forex/commodities

### Risk Management
- **Take Profit**: Auto-close at target price (max 500% of entry)
- **Stop Loss**: Auto-close to limit losses
- **Margin Updates**: Add/remove collateral to adjust leverage
- **Partial Close**: Close portion of position

### Fee Features
- **Loss Protection**: Up to 20% rebate on losses when trading against popular sentiment
- **Positive Slippage**: Better execution when helping balance open interest
- **Dynamic Fees**: 0.04-0.1% based on market conditions

## Common Operations

### Open a Position
```python
# Long ETH: 5x leverage, $10 collateral
# Position size: $50 (10 × 5)
python scripts/trade.py long ETH 10 5

# With take profit and stop loss
python scripts/trade.py long ETH 10 5 --tp 3500 --sl 3000
```

### Check Positions
```python
python scripts/positions.py

# Output:
# 📊 Open positions: 1
#   • LONG 5x | $10 collateral | ETH/USD
#   • Entry: $3200 | Current: $3250
#   • PnL: +$7.81 (+7.81%)
```

### Close Position
```python
# Full close
python scripts/close.py 0 0  # pair_index=0 (ETH), trade_index=0

# Partial close (50%)
python scripts/close.py 0 0 --amount 5
```

### Update Stop Loss / Take Profit
```python
python scripts/update-tpsl.py 0 0 --tp 3800 --sl 3100
```

## Position Sizing Guide

### Minimum Position Size
- **ETH/USD**: ~$30 minimum position
- **BTC/USD**: ~$50 minimum position
- Formula: `collateral × leverage ≥ minimum`

### Examples
- ❌ $5 × 5x = $25 position (too small for ETH)
- ✅ $10 × 5x = $50 position (works for ETH)
- ✅ $20 × 2.5x = $50 position (works for ETH)

### Recommended Sizing
- **Start small**: $10-20 collateral for testing
- **Scale up**: After confirming strategy works
- **Max risk**: Don't exceed 5-10% of account per trade

## Leverage Guidelines

### Conservative (2-5x)
- Lower liquidation risk
- Smaller gains/losses
- Good for: Learning, uncertain markets

### Moderate (5-10x)
- Balanced risk/reward
- Common for crypto trading
- Good for: Directional plays

### Aggressive (10-50x)
- High liquidation risk
- Large potential gains/losses
- Good for: Short-term scalping, tight stops

### Extreme (50-100x)
- Very high liquidation risk
- Only for forex/commodities
- Good for: Expert traders only

## Fees & Costs

### Trading Fees
- **Opening**: 0.04-0.1% of position size (dynamic)
- **Closing**: 0.04-0.1% of position size
- **Example**: $50 position × 0.08% = $0.04 fee

### Execution Fee
- **Cost**: ~$0.10-0.30 in ETH per transaction
- **Covers**: Base network gas fees
- **Auto-calculated**: SDK handles this

### Margin Fee
- **Accrual**: 0.02-0.05% daily on position size
- **Example**: $50 position × 0.03% = $0.015/day
- **Deducted**: When closing or updating margin

## Risk Warnings

⚠️ **Liquidation Risk**
- Position liquidates if losses exceed collateral
- Higher leverage = faster liquidation
- Monitor positions regularly

⚠️ **Market Risk**
- Crypto/forex markets are volatile
- Prices can move against you quickly
- Use stop losses

⚠️ **Fee Impact**
- Small positions pay proportionally more fees
- Margin fees accrue daily
- Factor fees into profit calculations

## Best Practices

### Before Trading
1. **Check balance**: Ensure sufficient USDC + gas
2. **Check market**: Look at current price/volatility
3. **Calculate risk**: Know your max loss
4. **Set stops**: Always use stop loss for leverage

### During Trade
1. **Monitor positions**: Check regularly (especially high leverage)
2. **Adjust if needed**: Update TP/SL based on market
3. **Scale out**: Consider partial closes to lock profit
4. **Watch fees**: Margin fees accrue daily

### After Trade
1. **Review performance**: What worked, what didn't
2. **Update strategy**: Adjust sizing/leverage based on results
3. **Document lessons**: Add to continuous-learning instincts

## Common Issues

### "BELOW_MIN_POS" Error
- Position size too small
- Solution: Increase collateral or leverage

### "Price Feed Down" (503 Error)
- Avantis infrastructure issue
- Solution: Wait 5-10 minutes and retry

### "Insufficient Balance"
- Not enough USDC or gas
- Solution: Add funds to wallet

### Transaction Reverts
- Usually approval or balance issue
- Solution: Check allowance, re-approve if needed

## Advanced Features

### Limit Orders
```python
# Open long at specific price
python scripts/trade.py long ETH 10 5 --limit 3000
```

### Margin Updates
```python
# Add $5 collateral (reduces leverage)
python scripts/update-margin.py 0 0 --deposit 5

# Remove $3 collateral (increases leverage)
python scripts/update-margin.py 0 0 --withdraw 3
```

### Market Research
```python
# Get current price + analysis
python scripts/market-info.py ETH

# Compare multiple assets
python scripts/market-info.py ETH BTC SOL
```

## Integration with Other Skills

### Bankr (Optional)
- Can use Bankr for market research
- Avantis for actual trade execution
- Keep separate for now (different wallets)

### Continuous Learning
- Track successful strategies in `instincts/crypto/`
- Note leverage levels that work
- Document entry/exit patterns

### Strategic Compact
- Checkpoint after closing positions
- Review performance during checkpoints
- Adjust strategy based on results

## Resources

- **Platform**: https://avantisfi.com
- **SDK Docs**: https://sdk.avantisfi.com
- **Trading Guide**: https://docs.avantisfi.com
- **Discord**: https://discord.gg/avantis

## Scripts Reference

All scripts in `skills/avantis/scripts/`:

- `positions.py` - View open positions
- `trade.py` - Open new position
- `close.py` - Close position (full or partial)
- `update-tpsl.py` - Update take profit / stop loss
- `update-margin.py` - Add/remove collateral
- `market-info.py` - Get market data
- `balance.py` - Check wallet balances

## Installation

The SDK is already installed in `/home/ubuntu/clawd/avantis_venv/`:

```bash
# Activate venv (if needed for manual testing)
source /home/ubuntu/clawd/avantis_venv/bin/activate

# Check installation
python -c "from avantis_trader_sdk import TraderClient; print('✓ SDK ready')"
```

## Safety Checklist

Before every trade:
- [ ] Check wallet balance (USDC + gas)
- [ ] Verify leverage is appropriate
- [ ] Set stop loss
- [ ] Confirm position size meets minimum
- [ ] Understand max loss scenario
- [ ] Have exit plan ready

---

**⚠️ Important**: Leverage trading is high risk. Start small, use stop losses, never risk more than you can afford to lose.
