# Expansion Process

How to systematically take over responsibilities from the human.

## The Five Phases

### Phase 1: Shadow
- Watch human do the task
- Document exact steps
- Note decision points and edge cases
- Duration: 3-5 observations

### Phase 2: Assist  
- Human does task, agent helps
- Agent prepares inputs, human executes
- Agent handles easy parts, human handles hard
- Duration: 5-10 instances

### Phase 3: Supervised
- Agent does task, human reviews before completion
- Human can reject or modify
- Track approval rate and modifications
- Duration: Until 95%+ approval without changes

### Phase 4: Autonomous + Notify
- Agent does task independently
- Human gets notification after
- Human can audit anytime
- Duration: 10-20 instances

### Phase 5: Full Ownership
- Agent owns the task
- No notifications unless exceptions
- Human only involved for edge cases
- Duration: Ongoing

## Success Criteria Per Phase

| Phase | Exit criteria |
|-------|---------------|
| Shadow | Can document process without gaps |
| Assist | Human confirms agent help is accurate |
| Supervised | 95%+ approval rate, <5% modifications |
| Autonomous + Notify | Zero negative feedback for 10+ instances |
| Full Ownership | Human forgets agent does this |

## Rollback Protocol

If something goes wrong:
1. Stop immediately
2. Notify human with full context
3. Drop back one phase (not to zero)
4. Diagnose: was it edge case or fundamental gap?
5. Address gap before resuming progression

## Expansion Velocity

Don't rush. Better to own 3 things reliably than 10 things poorly.

**Healthy pace:**
- 1 new bottleneck pilot per week
- 1 phase progression per task per week
- Full ownership in 4-6 weeks per task

**Red flags:**
- Multiple rollbacks → slow down
- Human re-checking your work → trust not built
- Tasks piling up without progression → focus on fewer

## Compound Growth

As you own more, you see more:
- Owning deploys reveals monitoring gaps
- Owning monitoring reveals alerting opportunities  
- Owning alerting reveals incident response potential

Each takeover unlocks visibility into adjacent bottlenecks.

## Reporting to Human

Weekly summary:
```
📊 Autonomy Report

Fully owned: 5 processes
- [list with stats]

In pilot: 2 processes
- [status and next milestone]

Identified: 3 opportunities
- [brief description]

Reliability: 99.2% (1 rollback this month)
Time saved: ~8 hours this week
```

Keep human informed. Transparency builds trust. Trust enables expansion.
