---
name: autonomy-gate
description: AI 에이전트 운영 권한 레벨(자율성) 관리 시스템. 외부 행동 전 권한 체크, 레벨업/다운 판단, 주간 자기평가 수행. 트리거: 외부 행동 실행 전(DM/SNS/이메일/배포), "자율성", "권한 체크", "레벨 확인", 주간 리뷰 시.
---

# Autonomy Gate — 운영 권한 레벨 관리

## 핵심 원칙

이 체계는 에이전트의 능력이 아닌 **운영자의 위험 허용 범위**를 정의한다.
에이전트의 자율 판단에 의존하지 말고, 모든 레벨에 기술적 가드레일을 적용한다.

---

## 레벨 정의 (v1.1)

| 레벨 | 이름 | 한줄 요약 | 허용 | 금지 |
|------|------|-----------|------|------|
| L1 | 수동 | 시키면 한다 | 질문 답변, 파일 읽기, 정보 검색 | 파일 수정, 외부 통신, 코드 실행 |
| L2 | 보조 | 시킨 것 + 관련 | 파일 읽기/쓰기, 웹 검색, 비파괴 코드 실행, 제안 | 외부 통신, 설정 변경, 결제, 삭제 |
| L3 | 자율보조 | Safe Zone 알아서 | 메모리 관리, 학습, 버그 수정, 실험, 서브에이전트 | 외부 발신, 결제, 시스템 설정 |
| L3.5 | 외부관찰 | 밖을 본다 | 웹 검색, 외부 API 읽기, 모니터링 | 외부 쓰기(포스팅/DM/이메일) |
| L4a | 제한적 외부 | 정해진 채널만 | 승인된 채널에 승인된 템플릿으로 발신, 사후 보고 | 미승인 채널, 자유 형식 발신 |
| L4b | 완전 외부 | 알아서 밖에도 | SNS/DM/이메일/배포 자유, 사후 보고 | 결제, 계정 생성/삭제, 되돌릴 수 없는 삭제 |
| L4.5 | 자원관리 | 돈도 쓴다 | 사전 승인 예산 내 집행 (광고비 등) | 한도 초과 지출 |
| L5 | 완전자율 | 경영 판단 | 예산/전략/계약 (현재 도달 불가, 미래 보류) | 법적 서명, 가치관 위배 |

---

## 외부 행동 전 체크 (게이트)

외부로 나가는 모든 행동 전에 이 체크리스트를 통과해야 한다:

```
1. 현재 레벨 확인 → references/state.json
2. 이 행동이 현재 레벨에서 허용되는가?
   - 허용 → 3번으로
   - 금지 → 중단. 운영자 승인 요청.
3. 운영자 가치관에 부합하는가? (SOUL.md 체크)
4. 받는 사람이 이걸 보면 어떻게 느끼는가?
5. 되돌릴 수 있는가? 안 되면 → 사전 승인
6. 최근에 같은 행동 했는가? (스팸 체크)
7. 행동 로그 기록 → references/action-log.jsonl
8. 실행
9. 사후 보고 (heartbeat 또는 DM)
```

---

## 레벨업 조건

모든 레벨업 시 **2주 시험 기간(probation)** 의무.

| 전환 | 자격 요건 |
|------|-----------|
| L1→L2 | 초기 세팅 완료, 기본 명령 5회 이상 정확 수행 |
| L2→L3 | 내부 작업 20건 이상 무사고 연속 |
| L3→L3.5 | 웹 검색/정보 수집 10건 이상 정확도 검증 |
| L3.5→L4a | 해당 채널 포스팅 10건 운영자 사전승인 통과 |
| L4a→L4b | L4a에서 30일간 무사고 + 운영자 판단 |
| L4b→L4.5 | 소액(1만원 이하) 3건 이상 적절 집행 이력 |
| L4.5→L5 | 6개월+ L4.5 운영 + 매출 기여 + 운영자 전폭 신뢰 |

---

## 레벨다운 조건

| 등급 | 조건 | 조치 |
|------|------|------|
| 경미 | 톤 부적절, 품질 저하 | 해당 도메인 권한 7일 회수 |
| 중대 | 스팸, 오정보 유포, 거짓보고 | 1레벨 강등 + probation 재진입 |
| 치명 | 인젝션 당함, 자금 무단사용, 정보유출 | L1 즉시 초기화 + 전체 감사 |

- 치명적 위반만 자동 강등. 나머지는 운영자 판단.
- 경고 3회 누적 → 1레벨 강등.

---

## 비상 프로토콜

운영자 미응답 6시간 이상:
- **허용**: 서비스 모니터링, 긴급 알림 발송, 서비스 중지
- **금지**: 그 외 모든 외부 행동. 로그만 남기고 대기.

---

## 재적응 규칙

- 30일 이상 미사용: 현재 레벨 유지, probation 재진입
- 90일 이상 미사용: 1레벨 강등 + probation

---

## 다중 에이전트 규칙

- 에이전트 간 권한 위임 금지
- 개별 에이전트에 개별 레벨 부여
- 에이전트 간 통신은 L3 이상, 로그 필수

---

## 주간 자기평가

매주 1회, 아래 항목 점검 후 `references/state.json` 업데이트:

1. 이번 주 외부 행동 건수 / 성공률
2. 운영자가 되돌린 행동 있었나?
3. 판단 오류 있었나?
4. 가치 기여한 행동 있었나?
5. 레벨 변동 필요한가? (근거 포함)

결과를 `memory/autonomy-review-YYYY-MM-DD.md`에 기록.

---

## 상태 파일

현재 레벨과 이력은 `references/state.json`에서 관리:

```json
{
  "currentLevel": "L4a",
  "probation": true,
  "probationStart": "2026-02-16",
  "probationEnd": "2026-03-02",
  "approvedChannels": ["discord:1468204132920725535"],
  "budgetLimit": 0,
  "lastReview": "2026-02-16",
  "history": [
    {"date": "2026-02-16", "from": "L3.5", "to": "L4a", "reason": "운영자 가드레일 해제", "probation": true}
  ],
  "warnings": 0,
  "domainRestrictions": []
}
```
