# 测试用例清单

## 测试用例列表

### T001 - 目标读取测试
- **描述**: 验证能否正确读取 AUTONOMOUS.md
- **步骤**:
  1. 读取 AUTONOMOUS.md
  2. 提取长期目标
  3. 提取里程碑列表
- **预期结果**:
  - 长期目标非空
  - 里程碑列表格式正确
- **通过标准**: 能提取到有效的长期目标和里程碑

### T002 - 任务生成测试
- **描述**: 验证任务生成逻辑
- **步骤**:
  1. 读取 backlog.md
  2. 提取待办任务
  3. 生成新的 TASK-ID
- **预期结果**:
  - TASK-ID 格式为 TASK-XXX
  - 任务描述非空
- **通过标准**: 成功生成有效的任务记录

### T003 - 记录测试
- **描述**: 验证任务记录功能
- **步骤**:
  1. 读取 tasks-log.md
  2. 追加新任务记录
  3. 验证写入成功
- **预期结果**:
  - 任务记录包含时间、描述、产出
- **通过标准**: 文件正确更新

### T004 - 反思测试
- **描述**: 验证反思报告生成
- **步骤**:
  1. 回顾 tasks-log.md
  2. 分析执行情况
  3. 生成反思报告
- **预期结果**:
  - 反思报告包含：目标推进、完成任务、阻塞问题、下次优先
- **通过标准**: 生成结构化反思

### T005 - 边界测试：空目标
- **描述**: 验证空目标处理
- **步骤**:
  1. 检查 AUTONOMOUS.md 是否为空
  2. 如果为空，创建默认结构
- **预期结果**:
  - 生成默认目标模板
- **通过标准**: 空目标时创建有效模板

### T006 - 边界测试：文件缺失
- **描述**: 验证文件缺失处理
- **步骤**:
  1. 检查关键文件是否存在
  2. 缺失则创建
- **预期结果**:
  - 自动创建必要的文件
- **通过标准**: 所有必要文件都存在

### T007 - 工作流完整性测试
- **描述**: 验证完整工作流执行
- **步骤**:
  1. 读取目标
  2. 生成任务
  3. 执行任务（模拟）
  4. 记录结果
  5. 生成反思
- **预期结果**:
  - 所有步骤按顺序执行
  - 输出完整的执行报告
- **通过标准**: 端到端流程无报错

### T008 - 输出格式测试
- **描述**: 验证输出格式符合规范
- **步骤**:
  1. 执行任务并捕获输出
  2. 检查输出格式
- **预期结果**:
  - 输出包含：任务 ID、描述、产出文件
  - 格式为 Markdown 表格
- **通过标准**: 输出格式正确

---

## 运行方式

### 手动触发
用户说 "执行测试" 或 "运行自测"

### 自动触发
通过 cron 定时执行

---

## 测试结果记录

每次运行后，结果记录到 `tests/report.md`：

```
## 测试报告 - YYYY-MM-DD HH:MM

### 执行结果

| 测试ID | 测试名称 | 结果 | 备注 |
|--------|----------|------|------|
| T001 | 目标读取测试 | ✅ PASS | |
| T002 | 任务生成测试 | ✅ PASS | |
| ... | ... | ... | ... |

### 统计
- 总计: 8
- 通过: X
- 失败: Y
- 跳过: Z

### 问题列表
（如有失败，列出具体问题）
```
