# 场景示例：个人项目管理系统

使用 autonomous-tasks 管理个人项目开发的完整指南。

## 目标设置

### AUTONOMOUS.md

```markdown
# 我的目标

## 长期目标

在一年内完成 3 个完整的个人项目，提升编程技能和产品思维。

## 里程碑

- [ ] v1.0.0 — 项目一：个人时间追踪 App
- [ ] v1.1.0 — 项目二：自动化脚本集合
- [ ] v1.2.0 — 项目三：AI 助手工具

## 当前阶段：项目一开发

### 当前待改进项
- [ ] 完成核心功能开发
- [ ] 编写测试用例
- [ ] 部署上线
```

## 使用示例

### 每日任务生成

基于项目目标，autonomous-tasks 会自动生成：

1. **代码开发任务**
   - 实现时间记录功能
   - 创建数据存储层
   - 编写 API 接口

2. **文档任务**
   - 更新 README
   - 编写使用文档

3. **测试任务**
   - 编写单元测试
   - 进行集成测试

## 任务产出

```
apps/
├── time-tracker/          # 项目一
│   ├── src/
│   ├── tests/
│   └── README.md
├── automation-scripts/    # 项目二
│   ├── backup.sh
│   └── sync.sh
└── ai-tools/              # 项目三
    └── ...
```

## 追踪进度

每周检查 tasks-log.md 统计：

```bash
grep "✅ TASK-" memory/tasks-log.md | wc -l
```

## 最佳实践

1. **目标具体化** — 每个项目有明确的交付物
2. **里程碑小颗粒** — 便于快速获得成就感
3. **定期回顾** — 每周评估进度，调整计划

---

*本示例展示如何用 autonomous-tasks 管理个人项目开发。*
