# 定期汇报机制设计

本文档设计 autonomous-tasks skill 的定期汇报能力。

## 需求概述

可选功能：让 AI 定期向用户汇报目标推进情况。

## 汇报频率选项

| 频率 | 适用场景 |
|------|----------|
| 每日汇报 | 目标推进期，需要频繁跟进 |
| 每周汇报 | 常规目标，周期性检查 |
| 每月汇报 | 长期目标，里程碑式检查 |

## 汇报内容模板

### 每日汇报

```
📊 今日进度报告

🎯 目标: [目标名称]
✅ 完成任务: [任务列表]
📈 推进情况: [百分比/状态]
🔜 下一步: [明日计划]
⚠️ 阻塞: [如有]
```

### 每周汇报

```
📊 本周进度报告 (Week XX)

🎯 目标: [目标名称]
✅ 完成的任务:
  - TASK-XXX: 任务描述
  - TASK-YYY: 任务描述
📈 总体进度: XX%
🔜 下周计划:
  - 任务 1
  - 任务 2
💡 洞察: [经验/改进]
```

### 每月汇报

```
📊 本月进度报告 (Month XX)

🎯 目标: [目标名称]
🏆 里程碑达成: [如有]
✅ 本月完成: X 个任务
📈 进度: XX%
🔜 下月重点: [优先级排序]
📝 反思: [经验总结]
```

## 技术实现

### 方案 1: Cron 定时 + 消息发送

```bash
# 每日汇报
openclaw cron add \
  --name "daily-report" \
  --message "生成每日汇报并发送到飞书" \
  --every 1d \
  --channel feishu
```

### 方案 2: 集成到自主任务工作流

在 SKILL.md 中添加可选步骤：
- 每次唤醒时检查是否需要汇报
- 根据配置频率决定是否发送

### 方案 3: 独立汇报 skill

创建独立的 `task-reporter` skill，与 autonomous-tasks 配合使用。

## 配置方式

用户可在 AUTONOMOUS.md 中配置：

```markdown
## 汇报设置

- 汇报频率: 每周
- 汇报渠道: 飞书
- 汇报时间: 周五 18:00
- 汇报格式: 详细
```

## 待实现

- [ ] 在 SKILL.md 中添加汇报配置章节
- [ ] 创建汇报模板库
- [ ] 实现消息发送集成

---

*设计创建时间: 2026-03-04*
