# 首次 Onboarding 引导方案

## 目标

让首次使用 autonomous-tasks 的用户能够零配置上手，快速体验价值。

## 引导流程

### 第一步：创建工作目录

系统自动创建 `claw_self/` 目录结构：

```
claw_self/
├── AUTONOMOUS.md       # 目标文件（用户填写）
├── SKILL.md            # 工作流（内置）
├── _meta.json          # 元数据（内置）
├── memory/
│   ├── tasks-log.md    # 任务日志
│   ├── backlog.md      # 待办池
│   └── changelog.md    # 变更日志
├── research/           # 调研产出
├── drafts/             # 文档产出
├── apps/               # 代码产出
└── scripts/            # 脚本产出
```

### 第二步：引导用户填写目标

首次唤醒时，发送以下引导消息：

```
🐕 欢迎使用自主任务系统！

我看到你是第一次使用，让我帮你设置目标。

请告诉我你的长期目标是什么？比如：
- "优化我的个人知识管理系统"
- "建立一个自动化的数据采集 pipeline"
- "完成某个项目的开发"

告诉我你想做什么，我来帮你规划任务！
```

### 第三步：生成初始任务

根据用户的目标，自动生成 3-5 个初始任务添加到 backlog。

：设置 Cron（### 第四步可选）

询问用户是否需要设置定时执行：

```
你想每天自动执行任务吗？我可以帮你设置定时唤醒。

例如：
- 每天早上 9 点
- 每隔 2 小时
- 每周一、三、五

回复"设置定时"并告诉我时间，我来配置。
```

## 用户交互示例

### 完整流程

```
AI: 🐕 欢迎使用自主任务系统！告诉我你的目标是什么？
用户: 我想建立一个自动读书笔记系统
AI: 好！我来帮你规划...
   
   已创建目标：建立自动读书笔记系统
   
   初始任务：
   1. 调研主流笔记工具 → research/note-tools.md
   2. 设计笔记模板 → drafts/note-template.md
   3. 选择技术方案 → drafts/tech-stack.md
   
   你想现在执行还是稍后？
```

## 技术实现

### 自动创建目录

在读取目标前，检查目录是否存在：

```bash
# 如果不存在，自动创建
mkdir -p claw_self/{memory,research,drafts,apps,scripts}
```

### 默认文件模板

内置默认模板，用户未填写时使用。

### 引导标志

使用 `.onboarding_complete` 标记文件，记录用户是否已完成首次设置。

## 改进建议

- [ ] 支持语音输入目标
- [ ] 提供预置目标模板（读书、健身、编程学习等）
- [ ] 支持导入 Notion/飞书文档作为目标来源
