# 学习语言场景示例

本文档展示如何使用 autonomous-tasks skill 来实现自主语言学习。

## 目标设置

在 AUTONOMOUS.md 中设置长期目标：

```markdown
# 我的目标

## 长期目标

在六个月内学会用日语进行日常交流。

## 里程碑

- [ ] v1.0.0 — 掌握 50 音图
- [ ] v1.1.0 — 掌握基础语法 (N5 水平)
- [ ] v1.2.0 — 能够进行简单对话
- [ ] v1.3.0 — 达到 N4 水平

## 当前阶段：50 音图学习

### 当前待改进项

- [ ] 每日背诵 5 个假名
- [ ] 练习书写
- [ ] 听写练习
```

## 自主任务示例

### 任务 1: 50 音图学习计划

- 目标：设计系统化的 50 音图学习方案
- 产出：`drafts/japanese-hiragana-plan.md`

### 任务 2: 每日单词本

- 目标：创建每日 10 词的记忆卡片
- 产出：`drafts/daily-vocabulary.md`

### 任务 3: 听力材料推荐

- 目标：收集适合初学者的日语听力资源
- 产出：`research/japanese-listening-resources.md`

## 执行日志示例

```
- ✅ TASK-030: 设计 50 音图学习计划 → drafts/japanese-hiragana-plan.md (2026-03-04)
- ✅ TASK-031: 创建每日单词本模板 → drafts/daily-vocabulary.md (2026-03-04)
- ✅ TASK-032: 收集听力资源 → research/japanese-listening-resources.md (2026-03-04)
```

## 效果追踪

每周回顾：
1. 掌握了哪些假名？
2. 记住了多少单词？
3. 听力理解能力有提升吗？
4. 下周重点是什么？

---

*示例创建时间: 2026-03-04*
