# 健康追踪场景示例

本文档展示如何使用 autonomous-tasks skill 来实现自主健康管理。

## 目标设置

```markdown
# 我的目标

## 长期目标

建立健康的生活习惯，提升整体身体素质。

## 里程碑

- [ ] v1.0.0 — 养成每日运动习惯
- [ ] v1.1.0 — 改善睡眠质量
- [ ] v1.2.0 — 饮食习惯优化
- [ ] v1.3.0 — 体检指标达标

## 当前阶段：每日运动

### 当前待改进项

- [ ] 每天运动 30 分钟
- [ ] 记录运动数据
- [ ] 每周总结分析
```

## 自主任务示例

### 任务 1: 运动计划设计

- 目标：制定可执行的每日运动方案
- 产出：`drafts/daily-exercise-plan.md`

### 任务 2: 睡眠追踪模板

- 目标：设计睡眠记录表
- 产出：`drafts/sleep-tracking.md`

### 任务 3: 饮食习惯分析

- 目标：创建饮食记录和分析框架
- 产出：`research/diet-analysis.md`

### 任务 4: 周报生成器

- 目标：设计自动生成健康周报
- 产出：`scripts/weekly-health-report.sh`

## 自动化集成

配合 Apple Reminders 或 Things 提醒：
- 每日运动提醒
- 睡前记录提醒
- 周报生成提醒

## 效果评估指标

| 维度 | 指标 | 目标 |
|------|------|------|
| 运动 | 每日步数 | 8000+ |
| 睡眠 | 平均睡眠时长 | 7-8 小时 |
| 饮食 | 饮水次数 | 8 杯/天 |

---

*示例创建时间: 2026-03-04*
