# 用户反馈收集表单设计

本文档设计用于收集 autonomous-tasks skill 的用户反馈。

## 反馈渠道

### 1. 主动反馈
- **GitHub Issues**: https://github.com/openclaw/openclaw/issues
- **Discord**: https://discord.com/invite/clawd
- **Email**: support@openclaw.ai

### 2. 被动反馈收集（应用内）

在 skill 中添加周期性提示，询问用户：

```
您好！感谢使用 autonomous-tasks。
您对当前版本满意吗？有什么建议？
回复"反馈"或直接提出您的建议~
```

## 反馈表单结构

### 基础信息（可选）
- 用户名/昵称（匿名可选）
- 使用场景
- 使用频率

### 核心问题

1. **功能满意度**
   - [ ] 非常满意
   - [ ] 满意
   - [ ] 一般
   - [ ] 不满意
   - [ ] 非常不满意

2. **最常用的功能**（多选）
   - [ ] Cron 定时触发
   - [ ] 手动触发
   - [ ] 目标管理
   - [ ] 任务追踪
   - [ ] 自我优化
   - [ ] 其他：_______

3. **最需要改进的功能**（多选）
   - [ ] Cron 触发稳定性
   - [ ] 任务生成质量
   - [ ] 文档完整性
   - [ ] 首次使用体验
   - [ ] 目标设定引导
   - [ ] 其他：_______

4. **开放性问题**
   - 您最喜欢 autonomous-tasks 的什么功能？
   - 您希望添加什么新功能？
   - 您有什么其他建议？

5. **愿意参与内测**
   - [ ] 是（请留联系方式）
   - [ ] 否

## 反馈处理流程

```
用户提交 → 自动分类 → 优先级排序 → 分配给开发者 → 反馈到产品路线图
```

### 自动分类规则

| 关键词 | 分类 |
|--------|------|
| crash, bug, 报错, 崩溃 | Bug |
| 文档, 说明, 不会用 | 文档 |
| 功能建议, 希望, 添加 | 功能请求 |
| 性能, 慢, 卡 | 性能优化 |

### 优先级排序

| 优先级 | 条件 |
|--------|------|
| P0 - 紧急 | 核心功能崩溃，影响使用 |
| P1 - 高 | 重要功能无法使用 |
| P2 - 中 | 功能有问题但有 workaround |
| P3 - 低 | 体验问题，优化建议 |

## 技术实现

### 方案 A：简单的 GitHub Issue 模板

创建 `.github/ISSUE_TEMPLATE/feedback.md`：

```markdown
## 反馈类型
- [ ] Bug 报告
- [ ] 功能建议
- [ ] 文档问题
- [ ] 其他

## 使用场景
（简要描述您使用 autonomous-tasks 的场景）

## 反馈内容
（详细描述您的建议或问题）

## 期望的解决方案
（可选）
```

### 方案 B：Webhook + 飞书/Slack 通知

当用户通过 CLI 提交反馈时，自动发送到指定渠道。

### 方案 C：定期用户调研

每月发送一次简短的 3 问题调研：

1. 本月使用满意度 (1-5)
2. 最大的痛点
3. 最大的改进

## 反馈激励机制

- **采纳奖励**: 被采纳的建议，赠送贡献者 badge
- **内测邀请**: 积极反馈的用户优先获得新功能内测资格
- **致谢名单**: 在 CHANGELOG 中感谢反馈者

## 下一步

1. 在 GitHub 创建 feedback issue template
2. 在 SKILL.md 中添加反馈提示
3. 设计内测用户招募流程

---

*本文档由 autonomous-tasks 自动生成*
