# 错误处理机制 v2.0

本文档完善 autonomous-tasks skill 的错误处理机制。

## 错误分类

### 1. 文件操作错误

| 错误类型 | 描述 | 处理方案 |
|----------|------|----------|
| 文件不存在 | AUTONOMOUS.md 等关键文件缺失 | 创建默认模板 |
| 权限不足 | 无法读取/写入文件 | 提示用户检查权限 |
| 文件损坏 | Markdown 格式错误 | 尝试修复或重建 |

### 2. 解析错误

| 错误类型 | 描述 | 处理方案 |
|----------|------|----------|
| 目标格式错误 | AUTONOMOUS.md 格式不符合规范 | 提示用户按模板修改 |
| 任务 ID 冲突 | 重复的 TASK-ID | 自动跳过或重新生成 |
| 日期格式错误 | 日期格式不标准 | 自动标准化为 YYYY-MM-DD |

### 3. 执行错误

| 错误类型 | 描述 | 处理方案 |
|----------|------|----------|
| 任务执行失败 | 任务无法完成 | 记录失败原因，继续下一个 |
| 产出文件冲突 | 同名文件已存在 | 询问用户或自动重命名 |
| 超时错误 | 任务执行过长 | 记录部分进度，等待下次 |

### 4. 外部依赖错误

| 错误类型 | 描述 | 处理方案 |
|----------|------|----------|
| 网络错误 | 无法访问外部资源 | 记录错误，继续执行 |
| 工具缺失 | 依赖的工具未安装 | 提示用户安装 |

## 错误处理策略

### 1. 保守策略

遇到错误时：
1. 记录错误详情到日志
2. 暂停当前任务
3. 询问用户如何处理

### 2. 激进策略

遇到错误时：
1. 记录错误详情
2. 尝试自动恢复
3. 继续执行后续任务

### 3. 选择方式

在 SKILL.md 中指定默认策略，或在任务执行时动态选择。

## 错误日志格式

```markdown
## 错误日志

### 2026-03-04 15:30
- **类型**: 文件操作错误
- **详情**: 无法读取 AUTONOMOUS.md
- **原因**: 文件不存在
- **处理**: 已创建默认模板
- **状态**: ✅ 已恢复
```

## 错误预防机制

### 前置检查

执行任务前进行：
1. 文件存在性检查
2. 权限检查
3. 格式预校验

### 增量执行

- 每完成一个任务立即记录
- 即使后续出错，已完成工作不丢失

### 状态备份

- 定期备份关键文件
- 保留历史版本以便回滚

## 用户错误处理指南

### 常见问题

**Q: 任务执行失败怎么办？**
A: 检查错误日志，确定原因后手动修复或重新执行。

**Q: 文件被误删怎么办？**
A: 从 git 历史恢复，或使用备份文件。

**Q: 任务 ID 乱怎么办？**
A: 手动编辑 tasks-log.md 修正 ID。

## 错误处理改进记录

- v1.0: 基础错误处理
- v2完善分类.0: 、自动恢复、用户指南

---

*本文档由 autonomous-tasks 自动生成 (2026-03-04)*
