# 环境变量使用指南

本文档说明 autonomous-tasks skill 支持的环境变量配置。

## 配置位置

环境变量可以通过以下方式设置：

1. **系统环境变量**: 在操作系统级别设置
2. **Shell 配置文件**: `~/.zshrc`, `~/.bashrc`
3. **OpenClaw 配置**: 在 config 中设置

## 核心配置变量

### 基本配置

| 变量名 | 说明 | 默认值 | 示例 |
|--------|------|--------|------|
| `OPENCLAW_WORKSPACE` | OpenClaw 工作目录 | `~/.openclaw/workspace` | `~/my_workspace` |
| `AUTONOMOUS_DIR` | 自主任务根目录 | `$OPENCLAW_WORKSPACE/claw_self` | - |

### 执行配置

| 变量名 | 说明 | 默认值 | 示例 |
|--------|------|--------|------|
| `AUTONOMOUS_TIMEOUT` | 单次执行超时(秒) | `600` | `3600` |
| `AUTONOMOUS_MAX_TASKS` | 单次生成最大任务数 | `5` | `3` |
| `AUTONOMOUS_LOG_LEVEL` | 日志级别 | `info` | `debug` |

### 输出配置

| 变量名 | 说明 | 默认值 | 示例 |
|--------|------|--------|------|
| `AUTONOMOUS_RESEARCH_DIR` | 调研输出目录 | `claw_self/research` | - |
| `AUTONOMOUS_DRAFTS_DIR` | 文档输出目录 | `claw_self/drafts` | - |
| `AUTONOMOUS_APPS_DIR` | 代码输出目录 | `claw_self/apps` | - |
| `AUTONOMOUS_SCRIPTS_DIR` | 脚本输出目录 | `claw_self/scripts` | - |

## 使用示例

### macOS / Linux

在 `~/.zshrc` 中添加：

```bash
# OpenClaw 基础配置
export OPENCLAW_WORKSPACE=~/my_workspace

# Autonomous Tasks 配置
export AUTONOMOUS_TIMEOUT=1800
export AUTONOMOUS_LOG_LEVEL=debug
export AUTONOMOUS_MAX_TASKS=3
```

然后执行：
```bash
source ~/.zshrc
```

### 验证配置

```bash
# 查看当前配置
env | grep AUTONOMOUS

# 测试配置生效
openclaw agent --message "执行自主任务"
```

## 高级配置

### 自定义输出目录

```bash
export AUTONOMOUS_RESEARCH_DIR=~/myresearch
export AUTONOMOUS_DRAFTS_DIR=~/mydrafts
```

### 调试模式

```bash
export AUTONOMOUS_LOG_LEVEL=debug
```

日志级别选项：
- `error`: 仅错误
- `warn`: 警告和错误
- `info`: 信息、警告和错误
- `debug`: 所有日志

## 故障排查

### 配置不生效

1. 确认配置文件已 source: `source ~/.zshrc`
2. 检查变量名拼写是否正确
3. 验证路径是否存在

### 路径问题

确保目录存在：
```bash
mkdir -p $AUTONOMOUS_RESEARCH_DIR
mkdir -p $AUTONOMOUS_DRAFTS_DIR
```

---

## 最佳实践

1. **使用默认值**: 大多数情况下不需要自定义配置
2. **渐进调整**: 先使用默认配置，再根据需要调整
3. **记录变更**: 在注释中说明配置变更原因
4. **版本控制**: 可将配置加入 .env 文件并版本控制

---

*本文档由 autonomous-tasks skill 自动维护*
