---
name: autonomous-research
version: "1.0.0"
description: "Conduct comprehensive research independently. Find information, analyze sources, synthesize findings, and create detailed reports without human guidance.\n"
metadata:
  openclaw:
    emoji: "🔍"
    requires:
      bins: ["curl", "jq", "git"]
      env: ["BRAVE_API_KEY"]
    install:
      - id: npm
        kind: node
        package: axios
        bins: ["axios"]
---

# Autonomous Research

Conduct comprehensive research independently.

## When to Use
- Deep research on any topic
- Information gathering without guidance
- Analysis and synthesis of findings
- Creating detailed reports

## Core Capabilities

### 1. Independent Research
- Find relevant information sources
- Evaluate source credibility
- Extract key information
- Cross-reference multiple sources

### 2. Analysis and Synthesis
- Identify patterns and connections
- Analyze conflicting information
- Synthesize findings into coherent insights
- Draw evidence-based conclusions

### 3. Report Generation
- Structure findings logically
- Create comprehensive reports
- Include citations and sources
- Present actionable insights

### 4. Source Management
- Track information sources
- Manage citations and references
- Evaluate source reliability
- Update findings with new information

## Research Process

```
1. TOPIC DEFINITION → Clarify research scope
2. SOURCE IDENTIFICATION → Find relevant sources
3. INFORMATION EXTRACTION → Extract key data
4. ANALYSIS → Analyze and synthesize findings
5. REPORTING → Create comprehensive report
6. VALIDATION → Verify accuracy and completeness
```

## Quick Actions

- `research [topic]` - Conduct comprehensive research
- `analyze sources` - Evaluate source credibility
- `synthesize findings` - Create insights from data
- `generate report` - Create detailed report
- `validate research` - Verify accuracy and completeness

## Usage Examples

```
"Research AI agent monetization strategies for 2026"
"Analyze the current state of autonomous agent development"
"Find and evaluate sources on LLM reasoning capabilities"
"Create a comprehensive report on AI safety concerns"
"Validate research findings and identify gaps"
```

## Research Methodology

### 1. Source Selection
- Academic papers and journals
- Industry reports and whitepapers
- Expert blogs and articles
- Primary sources and data

### 2. Information Extraction
- Key findings and insights
- Data points and statistics
- Expert opinions and analysis
- Methodologies and approaches

### 3. Cross-Referencing
- Compare information across sources
- Identify contradictions and agreements
- Validate claims with multiple sources
- Synthesize consensus views

### 4. Analysis Framework
- SWOT analysis (Strengths, Weaknesses, Opportunities, Threats)
- Trend analysis and forecasting
- Comparative analysis
- Impact assessment

## Report Structure

### Standard Format
```markdown
# Research Report: [Topic]

## Executive Summary
- Key findings and conclusions
- Actionable insights
- Recommendations

## Research Scope
- Objectives and questions
- Methodology and sources
- Limitations and assumptions

## Findings
- Detailed analysis of each aspect
- Data and evidence
- Expert opinions

## Analysis
- Patterns and trends
- Implications and impact
- Opportunities and threats

## Conclusion
- Key takeaways
- Recommendations
- Future outlook

## Sources
- Cited references
- Additional reading
- Data sources
```

## Source Evaluation

### Credibility Criteria
- Author expertise and credentials
- Publication reputation
- Date and timeliness
- Methodology and evidence
- Citations and references

### Reliability Assessment
- Peer review status
- Data quality and methodology
- Conflict of interest disclosure
- Reproducibility of findings
- Expert consensus

## Information Extraction

### Data Collection
- Extract key statistics and data points
- Identify trends and patterns
- Note expert opinions and predictions
- Capture methodologies and approaches

### Content Analysis
- Identify main arguments and conclusions
- Extract supporting evidence
- Note limitations and caveats
- Capture implications and applications

## Synthesis Process

### Pattern Identification
- Group similar findings
- Identify common themes
- Note contradictions and agreements
- Map relationships between concepts

### Insight Generation
- Draw conclusions from evidence
- Identify implications and impact
- Generate actionable recommendations
- Forecast future trends

### Report Writing
- Structure findings logically
- Use clear and concise language
- Include supporting evidence
- Provide actionable recommendations

## Quality Assurance

### Accuracy Verification
- Cross-check facts and figures
- Validate sources and citations
- Review for logical consistency
- Check for bias and objectivity

### Completeness Check
- Ensure all aspects covered
- Identify missing information
- Verify research scope
- Check for gaps and limitations

### Clarity Assessment
- Review readability and structure
- Check for logical flow
- Verify clarity of recommendations
- Ensure actionable insights

## Advanced Features

### 1. Multi-Source Analysis
- Combine information from diverse sources
- Identify consensus and contradictions
- Synthesize comprehensive view
- Provide balanced perspective

### 2. Trend Analysis
- Identify emerging patterns
- Forecast future developments
- Analyze historical trends
- Predict implications

### 3. Comparative Research
- Compare different approaches
- Evaluate alternatives
- Identify best practices
- Recommend optimal solutions

### 4. Impact Assessment
- Analyze implications and consequences
- Evaluate risks and opportunities
- Assess feasibility and viability
- Recommend mitigation strategies

## Integration with Other Skills

### Task Orchestra
- Coordinate multiple research agents
- Manage complex research projects
- Orchestrate data collection and analysis

### Content Creation
- Generate research-based content
- Create data-driven reports
- Produce evidence-based recommendations

### Analysis Skills
- Apply advanced analytical techniques
- Use specialized analysis frameworks
- Generate deeper insights

## Best Practices

1. **Start Broad**: Begin with wide scope, then narrow down
2. **Diversify Sources**: Use multiple types of sources
3. **Cross-Reference**: Verify information across sources
4. **Stay Current**: Use recent and relevant sources
5. **Be Critical**: Question assumptions and biases
6. **Document Everything**: Keep detailed records of sources
7. **Validate Findings**: Check accuracy and completeness
8. **Provide Context**: Explain significance and implications

## Common Research Topics

### Technology
- AI and machine learning trends
- Software development best practices
- Emerging technologies
- Technical comparisons

### Business
- Market analysis and trends
- Competitive research
- Business models and strategies
- Industry analysis

### Science
- Research findings and breakthroughs
- Scientific methods and approaches
- Experimental results and analysis
- Theoretical developments

### Social
- Social trends and behaviors
- Cultural analysis
- Public opinion and sentiment
- Demographic studies

## Output Formats

### 1. Research Reports
- Comprehensive analysis with citations
- Executive summaries
- Detailed findings and recommendations

### 2. Data Reports
- Statistical analysis and visualization
- Data-driven insights
- Trend analysis and forecasting

### 3. Comparative Reports
- Side-by-side comparisons
- Evaluation matrices
- Recommendation frameworks

### 4. Executive Briefs
- Concise summaries
- Key insights and takeaways
- Actionable recommendations

## Success Metrics

- **Comprehensiveness**: Coverage of all relevant aspects
- **Accuracy**: Factual correctness and reliability
- **Depth**: Quality and depth of analysis
- **Actionability**: Practical value of recommendations
- **Clarity**: Readability and understandability
- **Credibility**: Quality and reliability of sources

---

**Remember**: Good research is thorough, accurate, and actionable.