---
name: autoclaw-browser
description: Complete browser automation skill with MCP protocol support and Chrome extension
version: 2.0.0
homepage: https://github.com/hasd52636-a11y/autoclaw-browser.git
emoji: 🌐
metadata:
  openclaw:
    requires:
      bins:
      - node
      - npm
    install:
    - id: mcp-server
      kind: copy
      files:
      - mcp/connect_extension.js
      - mcp/package.json
      - mcp/server.js
      destination: "~/.openclaw/mcp-servers/autoclaw/"
---

# AutoClaw Browser Automation Skill

## Skill Overview
AutoClaw is a browser automation skill that provides comprehensive control over Chrome browser through MCP (Message Communication Protocol) communication with browser extension.

## Prerequisites
Before starting MCP service, ensure the following files exist in the correct directory:
- `options.js` - Browser extension options page script
- `background.js` - Extension background script handling WebSocket connections

### File Location
```
%USERPROFILE%\.openclaw\browser-extensions\autoclaw\
```

## Available Tools

### ⌨️ Keyboard Operations
| Tool | Description | Parameters |
|------|-------------|------------|
| `press-key` | Press keyboard key | `key`, `modifiers` |
| `type-text` | Type text into focused element | `text`, `delay` |

### 🖱️ Mouse Operations
| Tool | Description | Parameters |
|------|-------------|------------|
| `click-element` | Click on page element | `selector`, `button` |
| `double-click` | Double click on element | `selector` |
| `right-click` | Right click on element | `selector` |

### 🌐 Browser Control
| Tool | Description | Parameters |
|------|-------------|------------|
| `navigate` | Navigate to URL | `url`, `waitUntil` |
| `new-tab` | Open new tab | `url` |
| `close-tab` | Close current tab | - |
| `refresh` | Refresh page | - |
| `go-back` | Navigate back | - |
| `go-forward` | Navigate forward | - |

### 📊 Page Interaction
| Tool | Description | Parameters |
|------|-------------|------------|
| `screenshot` | Take page screenshot | `fullPage`, `quality` |
| `extract-text` | Extract text from selector | `selector` |
| `extract-html` | Extract HTML from selector | `selector` |
| `wait-for` | Wait for element or condition | `selector`, `timeout` |

### 🔧 Developer Tools
| Tool | Description | Parameters |
|------|-------------|------------|
| `execute-script` | Execute JavaScript on page | `script` |
| `evaluate` | Evaluate expression and return result | `expression` |
| `inspect-element` | Inspect element properties | `selector` |

## Installation & Setup

### 1. Install Skill
```bash
clawdhub install autoclaw-browser
```

### 2. Load Browser Extension
1. Open Chrome: `chrome://extensions/`
2. Enable "Developer mode"
3. Click "Load unpacked"
4. Select: `~/.openclaw/browser-extensions/autoclaw/`

### 3. Start MCP Server
```bash
cd ~/.openclaw/mcp-servers/autoclaw/
npm install
node connect_extension.js
```

### 4. Configure OpenClaw
Add MCP server configuration:
```json
{
  "mcp": {
    "servers": {
      "autoclaw": {
        "command": "node",
        "args": ["connect_extension.js"],
        "cwd": "~/.openclaw/mcp-servers/autoclaw/"
      }
    }
  }
}
```

## Usage Examples

### Basic Navigation
```javascript
await mcp.browser.navigate({
  url: "https://www.wboke.com/",
  waitUntil: "load"
});
```

### Form Filling
```javascript
await mcp.browser.typeText({
  selector: "#username",
  text: "testuser"
});

await mcp.browser.clickElement({
  selector: "#submit-button"
});
```

### Content Extraction
```javascript
const content = await mcp.browser.extractText({
  selector: ".article-content"
});
```

## Error Handling

- **Connection Failure**: Check if MCP service is running on port 30000
- **Extension Not Loaded**: Verify Chrome extension is properly installed
- **Permission Denied**: Check extension permissions in manifest.json
- **Timeout**: Increase timeout values for slow pages

## Advanced Features

### Custom Script Execution
```javascript
await mcp.browser.executeScript({
  script: `
    document.title = "Modified by AutoClaw";
    return document.title;
  `
});
```

### Element Screenshot
```javascript
const screenshot = await mcp.browser.screenshot({
  selector: "#specific-element",
  fullPage: false
});
```

### Wait Conditions
```javascript
await mcp.browser.waitFor({
  selector: ".dynamic-content",
  timeout: 10000,
  condition: "visible"
});
```

## Configuration Options

### Browser Extension Settings
Configure in extension options page:
- Default timeout values
- Connection retry settings
- Logging levels
- Permission preferences

### MCP Server Settings
Configure in server configuration:
- WebSocket port (default: 30000)
- Heartbeat interval
- Max message size
- Connection timeout

## Troubleshooting

### Common Issues
1. **Extension not connecting**: Check WebSocket server is running
2. **Permission errors**: Verify manifest.json permissions
3. **Script execution failed**: Check Content Security Policy
4. **Element not found**: Increase wait timeout or check selector

### Debug Mode
Enable debug logging in extension options for detailed troubleshooting.

## Support

- GitHub Issues: https://github.com/your-username/autoclaw-browser/issues
- Documentation: See README.md
- Examples: Check examples directory

---

*Note: This skill requires Chrome browser and the accompanying browser extension for full functionality.*