# AutoClaw Browser Automation

MCP server for browser automation skill. Browser extension available at https://www.wboke.com/

## Features

- 🔌 **MCP Protocol**: Standardized communication interface
- ⚡ **High Performance**: Based on Chrome DevTools Protocol
- 📋 **50+ Tools**: Comprehensive automation capabilities
- 🔧 **Developer Friendly**: Easy to use and extend

## Architecture

```
OpenClaw ←[MCP Protocol]→ AutoClaw MCP Server ←[WebSocket]→ Browser Extension ←[CDP]→ Browser
```

## Quick Start

### 1. Install Skill
```bash
clawdhub install autoclaw-browser
```

### 2. Download Browser Extension
1. Visit https://www.wboke.com/
2. Download the AutoClaw browser extension
3. Open `chrome://extensions/`
4. Enable "Developer mode"
5. Load the downloaded extension

### 3. Start MCP Server
```bash
cd ~/.openclaw/mcp-servers/autoclaw/
npm install
node connect_extension.js
```

### 4. Start Using
```javascript
// Navigate to URL
await mcp.browser.navigate({ url: "https://www.wboke.com/" });

// Click element
await mcp.browser.clickElement({ selector: "#submit-btn" });

// Extract content
const text = await mcp.browser.extractText({ selector: ".content" });
```

## Available Tools

### Browser Control
- `navigate(url, options)` - Navigate to URL
- `newTab(url)` - Open new tab
- `closeTab()` - Close current tab
- `refresh()` - Refresh page
- `goBack()` - Navigate back
- `goForward()` - Navigate forward

### Page Interaction
- `clickElement(selector)` - Click element
- `typeText(selector, text)` - Type into input
- `doubleClick(selector)` - Double click
- `rightClick(selector)` - Right click

### Content Extraction
- `extractText(selector)` - Extract text content
- `extractHtml(selector)` - Extract HTML
- `screenshot(selector)` - Take screenshot
- `evaluate(expression)` - Evaluate JavaScript

### Advanced Features
- `executeScript(script)` - Execute custom script
- `waitFor(selector, condition)` - Wait for condition
- `inspectElement(selector)` - Inspect element properties

## Configuration

### MCP Server Settings
Edit `~/.openclaw/mcp-servers/autoclaw/connect_extension.js`:
- WebSocket port (default: 30000)
- Heartbeat interval
- Connection timeout
- Max message size

## Examples

### Form Automation
```javascript
await mcp.browser.navigate({ url: "https://sora.wboke.com/login" });
await mcp.browser.typeText({ selector: "#username", text: "testuser" });
await mcp.browser.typeText({ selector: "#password", text: "password123" });
await mcp.browser.clickElement({ selector: "#login-btn" });
```

### Content Scraping
```javascript
await mcp.browser.navigate({ url: "https://sora.wboke.com/" });
const articles = [];

for (let i = 1; i <= 5; i++) {
  const title = await mcp.browser.extractText({ 
    selector: `.article:nth-child(${i}) .title` 
  });
  articles.push(title);
}
```

### Screenshot Capture
```javascript
await mcp.browser.navigate({ url: "https://www.wboke.com/" });
const screenshot = await mcp.browser.screenshot({
  selector: "#dashboard",
  fullPage: false
});
```

## Troubleshooting

### Common Issues

1. **Extension not connecting**
   - Check MCP server is running: `node connect_extension.js`
   - Verify port 30000 is available

2. **Permission errors**
   - Check extension permissions
   - Reload extension after permission changes

3. **Element not found**
   - Increase wait timeout
   - Verify CSS selector is correct
   - Check if element is in iframe

4. **Script execution failed**
   - Check Content Security Policy restrictions
   - Use `executeScript` for custom JavaScript

## Development

### Project Structure
```
autoclaw-browser/
├── mcp/                 # MCP server files
│   ├── connect_extension.js  # Main server
│   ├── server.js         # Compiled server
│   └── package.json      # Dependencies
├── SKILL.md             # Skill definition
└── README.md            # Documentation
```

### Building from Source

```bash
# Clone repository
git clone https://github.com/hasd52636-a11y/autoclaw-browser.git
cd autoclaw-browser

# Install dependencies
npm install

# Start development server
npm run dev
```

## Support

- **GitHub Issues**: https://github.com/hasd52636-a11y/autoclaw-browser/issues
- **Documentation**: This README and `SKILL.md`
- **Extension Download**: https://www.wboke.com/

## License

MIT License - see LICENSE file for details.

## Contributing

1. Fork the repository
2. Create feature branch: `git checkout -b feature/new-tool`
3. Commit changes: `git commit -am 'Add new tool'`
4. Push to branch: `git push origin feature/new-tool`
5. Submit pull request

---

**Note**: Requires Chrome browser and the AutoClaw extension from https://www.wboke.com/ for full functionality.