---
name: auto-updater-gateway
description: Schedule and run safe daily/weekly updates for Clawdbot + installed skills using the Gateway cron scheduler. Use when setting up "run updates at 04:00" jobs, rotating update reports, running `clawdhub update --all`, and (optionally) applying Clawdbot updates + restart + doctor.
metadata: {"version":"1.0.1","clawdbot":{"emoji":"🔄","category":"automation","os":["windows","darwin","linux"],"requires":{"anyBins":["clawdbot","clawdhub"]}}}
---

# Auto-Updater (Gateway)

Create a reliable daily auto-update routine using **Clawdbot Cron** (Gateway scheduler).

This is a "skill" in the sense of a repeatable workflow + correct config shapes (not a plugin).

## Quick setup checklist

1) Ensure ClawHub CLI is logged in (for skill updates):

```bash
/home/xabo/.nvm/versions/node/v22.22.0/bin/clawdhub login --workdir /home/xabo/clawd --dir skills
/home/xabo/.nvm/versions/node/v22.22.0/bin/clawdhub whoami --workdir /home/xabo/clawd --dir skills
```

2) Decide:
- When to run (cron + timezone)
- Whether the job should only **report**, or **update + restart**

## Recommended cron job (isolated, deliver output)

Use an **isolated** cron job so it doesn’t spam the main session context.

Example CLI (04:00 Europe/Stockholm):

```bash
/home/xabo/.nvm/versions/node/v22.22.0/bin/clawdbot cron add \
  --name "Daily auto-update (Clawdbot + skills)" \
  --cron "0 4 * * *" \
  --tz "Europe/Stockholm" \
  --session isolated \
  --wake now \
  --deliver \
  --channel telegram \
  --to "2095290688" \
  --message "Run daily auto-update: update skills via clawdhub update --all; if Clawdbot has an update available, apply it and restart; then run clawdbot doctor --non-interactive; report what changed."
```

## What the job should do (workflow)

Within the cron run:

1) Capture “before” state
- `clawdbot --version`
- `clawdhub list` (skills + versions)

2) Update skills
- `clawdhub update --all`

3) (Optional) Update Clawdbot
- Only if the owner explicitly wants self-updates.
- After updating, run `clawdbot doctor --non-interactive`.
- Restart gateway if required.

4) Send a concise summary
- Clawdbot version before/after
- Skills updated (old → new)
- Any errors

## Notes / gotchas

- **Timezone field:** in Gateway job objects this is `schedule.tz` (IANA tz like `Europe/Stockholm`).
- **Delivery:** Prefer explicit `channel` + `to` so the job always reaches you.
- **Clawdbot self-update:** can be disruptive (restarts). Run at a quiet time.

## Troubleshooting

- `clawdhub update` says “Not logged in” → run `clawdhub login` again.
- Job doesn’t run → confirm Gateway is always-on and cron is enabled.
- Nothing updates → that can be normal; still send a “no changes” report.
